require=(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({"../audits/aria-allowed-attr":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class ARIAAllowedAttr extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'aria-allowed-attr',
      description: 'Element aria-* roles are valid',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'aria-allowed-attr');

    return ARIAAllowedAttr.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = ARIAAllowedAttr;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/aria-valid-attr":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class ARIAValidAttr extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'aria-valid-attr',
      description: 'Element aria-* attributes are valid ARIA attributes',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'aria-valid-attr');

    return ARIAValidAttr.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = ARIAValidAttr;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/audit":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const DEFAULT_PASS = 'defaultPass';

class Audit {
  /**
   * @return {!String}
   */
  static get DEFAULT_PASS() {
    return DEFAULT_PASS;
  }

  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    throw new Error('Audit meta information must be overridden.');
  }

  /**
   * @param {!AuditResultInput} result
   * @return {!AuditResult}
   */
  static generateAuditResult(result) {
    if (typeof result.rawValue === 'undefined') {
      throw new Error('generateAuditResult requires a rawValue');
    }

    const score = typeof result.score === 'undefined' ? result.rawValue : result.score;
    let displayValue = result.displayValue;
    if (typeof displayValue === 'undefined') {
      displayValue = result.rawValue ? result.rawValue : '';
    }

    // The same value or true should be '' it doesn't add value to the report
    if (displayValue === score) {
      displayValue = '';
    }

    return {
      score,
      displayValue: `${displayValue}`,
      rawValue: result.rawValue,
      debugString: result.debugString,
      optimalValue: result.optimalValue,
      extendedInfo: result.extendedInfo,
      name: this.meta.name,
      category: this.meta.category,
      description: this.meta.description,
      helpText: this.meta.helpText
    };
  }
}

module.exports = Audit;

},{}],"../audits/cache-start-url":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class CacheStartUrl extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'cache-start-url',
      description: 'Cache contains start_url from manifest (alpha)',
      requiredArtifacts: ['CacheContents', 'Manifest', 'URL']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let cacheHasStartUrl = false;
    const manifest = artifacts.Manifest && artifacts.Manifest.value;
    const cacheContents = artifacts.CacheContents;

    if (!(manifest && manifest.start_url && manifest.start_url.value)) {
      return CacheStartUrl.generateAuditResult({
        rawValue: false,
        debugString: 'start_url not present in Manifest'
      });
    }

    if (!(Array.isArray(cacheContents) && artifacts.URL &&
          artifacts.URL.finalUrl)) {
      return CacheStartUrl.generateAuditResult({
        rawValue: false,
        debugString: 'No cache or URL detected'
      });
    }

    // Remove any UTM strings.
    const startURL = manifest.start_url.value;
    const altStartURL = startURL
        .replace(/\?utm_([^=]*)=([^&]|$)*/, '')
        .replace(/\?$/, '');

    // Now find the start_url in the cacheContents. This test is less than ideal since the Service
    // Worker can rewrite a request from the start URL to anything else in the cache, and so a TODO
    // here would be to resolve this more completely by asking the Service Worker about the start
    // URL. However that would also necessitate the cache contents gatherer relying on the manifest
    // gather rather than being independent of it.
    cacheHasStartUrl = cacheContents.find(req => {
      return (startURL === req || altStartURL === req);
    });

    return CacheStartUrl.generateAuditResult({
      rawValue: (cacheHasStartUrl !== undefined)
    });
  }
}

module.exports = CacheStartUrl;

},{"./audit":"../audits/audit"}],"../audits/color-contrast":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class ColorContrast extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'color-contrast',
      description: 'Background and foreground colors have a sufficient contrast ratio',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'color-contrast');

    return ColorContrast.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = ColorContrast;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/content-width":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ContentWidth extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Mobile Friendly',
      name: 'content-width',
      description: 'Content is sized correctly for the viewport',
      requiredArtifacts: ['ContentWidth']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    if (typeof artifacts.ContentWidth === 'undefined' ||
        typeof artifacts.ContentWidth.scrollWidth === 'undefined' ||
        typeof artifacts.ContentWidth.viewportWidth === 'undefined') {
      return ContentWidth.generateAuditResult({
        rawValue: false,
        debugString: 'Unable to find scroll and viewport widths.'
      });
    }

    const widthsMatch =
        artifacts.ContentWidth.scrollWidth === artifacts.ContentWidth.viewportWidth;

    return ContentWidth.generateAuditResult({
      rawValue: widthsMatch,
      debugString: this.createDebugString(widthsMatch, artifacts.ContentWidth)
    });
  }

  static createDebugString(match, artifact) {
    if (match) {
      return '';
    }

    return 'The content scroll size is ' + artifact.scrollWidth + 'px, ' +
        'whereas the viewport size is ' + artifact.viewportWidth + 'px.';
  }
}

module.exports = ContentWidth;

},{"./audit":"../audits/audit"}],"../audits/critical-request-chains":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class CriticalRequestChains extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'critical-request-chains',
      description: 'Critical Request Chains',
      optimalValue: 0,
      requiredArtifacts: ['networkRecords']
    };
  }

  /**
   * Audits the page to give a score for First Meaningful Paint.
   * @param {!Artifacts} artifacts The artifacts from the gather phase.
   * @return {!AuditResult} The score from the audit, ranging from 0-100.
   */
  static audit(artifacts) {
    const networkRecords = artifacts.networkRecords[Audit.DEFAULT_PASS];
    return artifacts.requestCriticalRequestChains(networkRecords).then(chains => {
      let chainCount = 0;
      function walk(node, depth) {
        const children = Object.keys(node);

        // Since a leaf node indicates the end of a chain, we can inspect the number
        // of child nodes, and, if the count is zero, increment the count.
        if (children.length === 0) {
          chainCount++;
        }

        children.forEach(id => {
          const child = node[id];
          walk(child.children, depth + 1);
        }, '');
      }

      walk(chains, 0);

      return CriticalRequestChains.generateAuditResult({
        rawValue: chainCount,
        optimalValue: this.meta.optimalValue,
        extendedInfo: {
          formatter: Formatter.SUPPORTED_FORMATS.CRITICAL_REQUEST_CHAINS,
          value: chains
        }
      });
    });
  }
}

module.exports = CriticalRequestChains;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/estimated-input-latency":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Audit = require('./audit');
const TracingProcessor = require('../lib/traces/tracing-processor');
const Formatter = require('../formatters/formatter');

// Parameters (in ms) for log-normal CDF scoring. To see the curve:
// https://www.desmos.com/calculator/srv0hqhf7d
const SCORING_POINT_OF_DIMINISHING_RETURNS = 50;
const SCORING_MEDIAN = 100;

class EstimatedInputLatency extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'estimated-input-latency',
      description: 'Estimated Input Latency',
      optimalValue: SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString() + 'ms',
      requiredArtifacts: ['traceContents']
    };
  }

  static calculate(speedline, trace) {
    // Use speedline's first paint as start of range for input latency check.
    const startTime = speedline.first;

    const tracingProcessor = new TracingProcessor();
    const model = tracingProcessor.init(trace);
    const latencyPercentiles = TracingProcessor.getRiskToResponsiveness(model, trace, startTime);

    const ninetieth = latencyPercentiles.find(result => result.percentile === 0.9);
    const rawValue = parseFloat(ninetieth.time.toFixed(1));

    // Use the CDF of a log-normal distribution for scoring.
    //  10th Percentile ≈ 58ms
    //  25th Percentile ≈ 75ms
    //  Median = 100ms
    //  75th Percentile ≈ 133ms
    //  95th Percentile ≈ 199ms
    const distribution = TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,
        SCORING_POINT_OF_DIMINISHING_RETURNS);
    const score = 100 * distribution.computeComplementaryPercentile(ninetieth.time);

    return EstimatedInputLatency.generateAuditResult({
      score: Math.round(score),
      optimalValue: this.meta.optimalValue,
      rawValue,
      displayValue: `${rawValue}ms`,
      extendedInfo: {
        value: latencyPercentiles,
        formatter: Formatter.SUPPORTED_FORMATS.ESTIMATED_INPUT_LATENCY
      }
    });
  }

  /**
   * Audits the page to estimate input latency.
   * @see https://github.com/GoogleChrome/lighthouse/issues/28
   * @param {!Artifacts} artifacts The artifacts from the gather phase.
   * @return {!Promise<!AuditResult>} The score from the audit, ranging from 0-100.
   */
  static audit(artifacts) {
    const trace = artifacts.traces[this.DEFAULT_PASS];

    return artifacts.requestSpeedline(trace)
      .then(speedline => EstimatedInputLatency.calculate(speedline, trace))
      .catch(err => {
        return EstimatedInputLatency.generateAuditResult({
          rawValue: -1,
          debugString: 'Speedline unable to parse trace contents: ' + err.message
        });
      });
  }
}

module.exports = EstimatedInputLatency;

},{"../formatters/formatter":7,"../lib/traces/tracing-processor":25,"./audit":"../audits/audit"}],"../audits/first-meaningful-paint":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const TracingProcessor = require('../lib/traces/tracing-processor');
const Formatter = require('../formatters/formatter');

const FAILURE_MESSAGE = 'Navigation and first paint timings not found.';

// Parameters (in ms) for log-normal CDF scoring. To see the curve:
// https://www.desmos.com/calculator/joz3pqttdq
const SCORING_POINT_OF_DIMINISHING_RETURNS = 1600;
const SCORING_MEDIAN = 4000;

const BLOCK_FIRST_MEANINGFUL_PAINT_IF_BLANK_CHARACTERS_MORE_THAN = 200;

class FirstMeaningfulPaint extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'first-meaningful-paint',
      description: 'First meaningful paint',
      optimalValue: SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString() + 'ms',
      requiredArtifacts: ['traceContents']
    };
  }

  /**
   * Audits the page to give a score for First Meaningful Paint.
   * @see https://github.com/GoogleChrome/lighthouse/issues/26
   * @see https://docs.google.com/document/d/1BR94tJdZLsin5poeet0XoTW60M0SjvOJQttKT-JK8HI/view
   * @param {!Artifacts} artifacts The artifacts from the gather phase.
   * @return {!Promise<!AuditResult>} The score from the audit, ranging from 0-100.
   */
  static audit(artifacts) {
    return new Promise((resolve, reject) => {
      const traceContents = artifacts.traces[this.DEFAULT_PASS].traceEvents;
      if (!traceContents || !Array.isArray(traceContents)) {
        throw new Error(FAILURE_MESSAGE);
      }
      const evts = this.collectEvents(traceContents);

      const navStart = evts.navigationStart;
      const fCP = evts.firstContentfulPaint;
      const fMPbasic = this.findFirstMeaningfulPaint(evts, {});
      const fMPpageheight = this.findFirstMeaningfulPaint(evts, {pageHeight: true});
      const fMPwebfont = this.findFirstMeaningfulPaint(evts, {webFont: true});
      const fMPfull = this.findFirstMeaningfulPaint(evts, {pageHeight: true, webFont: true});

      var data = {
        navStart,
        fmpCandidates: {
          fCP,
          fMPbasic,
          fMPpageheight,
          fMPwebfont,
          fMPfull
        }
      };

      const result = this.calculateScore(data);

      resolve(FirstMeaningfulPaint.generateAuditResult({
        score: result.score,
        rawValue: parseFloat(result.duration),
        displayValue: `${result.duration}ms`,
        debugString: result.debugString,
        optimalValue: this.meta.optimalValue,
        extendedInfo: {
          value: result.extendedInfo,
          formatter: Formatter.SUPPORTED_FORMATS.NULL
        }
      }));
    }).catch(err => {
      // Recover from trace parsing failures.
      return FirstMeaningfulPaint.generateAuditResult({
        rawValue: -1,
        debugString: err.message
      });
    });
  }

  static calculateScore(data) {
    // there are a few candidates for fMP:
    // * firstContentfulPaint: the first time that text or image content was painted.
    // * fMP basic: paint after most significant layout
    // * fMP page height: basic + scaling sigificance to page height
    // * fMP webfont: basic + waiting for in-flight webfonts to paint
    // * fMP full: considering both page height + webfont heuristics

    // Calculate the difference from navigation and save all candidates
    const timings = {};
    const timingsArr = [];
    Object.keys(data.fmpCandidates).forEach(name => {
      const evt = data.fmpCandidates[name];
      timings[name] = evt && ((evt.ts - data.navStart.ts) / 1000);
      timingsArr.push(timings[name]);
    });

    // First meaningful paint is the last timestamp observed from the candidates
    const firstMeaningfulPaint = timingsArr.reduce((maxTimestamp, curr) => max(maxTimestamp, curr));

    // Use the CDF of a log-normal distribution for scoring.
    //   < 1100ms: score≈100
    //   4000ms: score=50
    //   >= 14000ms: score≈0
    const distribution = TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,
        SCORING_POINT_OF_DIMINISHING_RETURNS);
    let score = 100 * distribution.computeComplementaryPercentile(firstMeaningfulPaint);

    // Clamp the score to 0 <= x <= 100.
    score = Math.min(100, score);
    score = Math.max(0, score);

    timings.navStart = data.navStart.ts / 1000;

    return {
      duration: `${firstMeaningfulPaint.toFixed(1)}`,
      score: Math.round(score),
      rawValue: firstMeaningfulPaint.toFixed(1),
      extendedInfo: {timings}
    };
  }

  /**
   * @param {!Array<!Object>} traceData
   */
  static collectEvents(traceData) {
    let mainFrameID;
    let navigationStart;
    let firstContentfulPaint;
    const layouts = new Map();
    const paints = [];

    // const model = new DevtoolsTimelineModel(traceData);
    // const events = model.timelineModel().mainThreadEvents();
    const events = traceData;

    // Parse the trace for our key events and sort them by timestamp.
    events.filter(e => {
      return e.cat.includes('blink.user_timing') ||
        e.name === 'FrameView::performLayout' ||
        e.name === 'Paint' ||
        e.name === 'TracingStartedInPage';
    }).sort((event0, event1) => {
      return event0.ts - event1.ts;
    }).forEach(event => {
      // Grab the page's ID from the first TracingStartedInPage in the trace
      if (event.name === 'TracingStartedInPage' && !mainFrameID) {
        mainFrameID = event.args.data.page;
      }

      // Record the navigationStart, but only once TracingStartedInPage has started
      // which is when mainFrameID exists
      if (event.name === 'navigationStart' && !!mainFrameID && !navigationStart) {
        navigationStart = event;
      }
      // firstContentfulPaint == the first time that text or image content was
      // painted. See src/third_party/WebKit/Source/core/paint/PaintTiming.h
      // COMPAT: firstContentfulPaint trace event first introduced in Chrome 49 (r370921)
      if (event.name === 'firstContentfulPaint' && event.args.frame === mainFrameID &&
          !!navigationStart && event.ts >= navigationStart.ts) {
        firstContentfulPaint = event;
      }
      // COMPAT: frame property requires Chrome 52 (r390306)
      // https://codereview.chromium.org/1922823003
      if (event.name === 'FrameView::performLayout' &&
          event.args.counters && event.args.counters.frame === mainFrameID &&
          !!navigationStart && event.ts >= navigationStart.ts) {
        layouts.set(event, event.args.counters);
      }

      if (event.name === 'Paint' && event.args.data.frame === mainFrameID &&
        !!navigationStart && event.ts >= navigationStart.ts) {
        paints.push(event);
      }
    });

    // navigationStart is currently essential to FMP calculation.
    // see: https://github.com/GoogleChrome/lighthouse/issues/753
    if (!navigationStart) {
      throw new Error('No `navigationStart` event found after `TracingStartedInPage` in trace');
    }

    return {
      navigationStart,
      firstContentfulPaint,
      layouts,
      paints
    };
  }

  static findFirstMeaningfulPaint(evts, heuristics) {
    let mostSignificantLayout;
    let significance = 0;
    let maxSignificanceSoFar = 0;
    let pending = 0;

    evts.layouts.forEach((countersObj, layoutEvent) => {
      const counter = val => countersObj[val];

      function heightRatio() {
        const ratioBefore = counter('contentsHeightBeforeLayout') / counter('visibleHeight');
        const ratioAfter = counter('contentsHeightAfterLayout') / counter('visibleHeight');
        return (max(1, ratioBefore) + max(1, ratioAfter)) / 2;
      }

      // If there are loading fonts when layout happened, the layout change accounting is postponed
      // until the font is displayed. However, icon fonts shouldn't block first meaningful paint.
      // We use a threshold that only web fonts that laid out more than 200 characters
      // should block first meaningful paint.
      //   https://docs.google.com/document/d/1BR94tJdZLsin5poeet0XoTW60M0SjvOJQttKT-JK8HI/edit#heading=h.wjx8tsc9m27r
      function hasTooManyBlankCharactersToBeMeaningful() {
        return counter('approximateBlankCharacterCount') >
            BLOCK_FIRST_MEANINGFUL_PAINT_IF_BLANK_CHARACTERS_MORE_THAN;
      }

      if (!counter('host') || counter('visibleHeight') === 0) {
        return;
      }

      const layoutCount = counter('LayoutObjectsThatHadNeverHadLayout') || 0;
      // layout significance = number of layout objects added / max(1, page height / screen height)
      significance = (heuristics.pageHeight) ? (layoutCount / heightRatio()) : layoutCount;

      if (heuristics.webFont && hasTooManyBlankCharactersToBeMeaningful()) {
        pending += significance;
      } else {
        significance += pending;
        pending = 0;
        if (significance > maxSignificanceSoFar) {
          maxSignificanceSoFar = significance;
          mostSignificantLayout = layoutEvent;
        }
      }
    });

    let paintAfterMSLayout;
    if (mostSignificantLayout) {
      paintAfterMSLayout = evts.paints.find(e => e.ts > mostSignificantLayout.ts);
    }
    return paintAfterMSLayout;
  }
}

module.exports = FirstMeaningfulPaint;

/**
 * Math.max, but with NaN values removed
 * @param {...number} _
 */
function max(_) {
  const args = [...arguments].filter(val => !isNaN(val));
  return Math.max.apply(Math, args);
}

},{"../formatters/formatter":7,"../lib/traces/tracing-processor":25,"./audit":"../audits/audit"}],"../audits/geolocation-on-start":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class GeolocationOnStart extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'UX',
      name: 'geolocation',
      description: 'Page does not automatically request geolocation',
      requiredArtifacts: ['GeolocationOnStart']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    if (typeof artifacts.GeolocationOnStart === 'undefined' ||
        artifacts.GeolocationOnStart === -1) {
      return GeolocationOnStart.generateAuditResult({
        rawValue: false,
        debugString: 'Unable to get geolocation values.'
      });
    }

    return GeolocationOnStart.generateAuditResult({
      rawValue: artifacts.GeolocationOnStart
    });
  }
}

module.exports = GeolocationOnStart;

},{"./audit":"../audits/audit"}],"../audits/image-alt":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class ImageAlt extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'image-alt',
      description: 'Every image element has an alt attribute',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'image-alt');

    return ImageAlt.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = ImageAlt;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/is-on-https":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Audit = require('./audit');

class HTTPS extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Security',
      name: 'is-on-https',
      description: 'Site is on HTTPS',
      requiredArtifacts: ['HTTPS']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    return HTTPS.generateAuditResult({
      rawValue: artifacts.HTTPS.value,
      debugString: artifacts.HTTPS.debugString
    });
  }
}

module.exports = HTTPS;

},{"./audit":"../audits/audit"}],"../audits/label":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class Label extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'label',
      description: 'Every form element has a label',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'label');

    return Label.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = Label;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/manifest-background-color":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class ManifestBackgroundColor extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-background-color',
      description: 'Manifest contains background_color',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Manifest=} manifest
   * @return {boolean}
   */
  static getBackgroundColorValue(manifest) {
    return manifest !== undefined &&
      manifest.background_color.value;
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const bgColor = ManifestBackgroundColor.getBackgroundColorValue(artifacts.Manifest.value);

    return ManifestBackgroundColor.generateAuditResult({
      rawValue: !!bgColor,
      extendedInfo: {
        value: bgColor,
        formatter: Formatter.SUPPORTED_FORMATS.NULL
      }
    });
  }
}

module.exports = ManifestBackgroundColor;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/manifest-display":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestDisplay extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-display',
      description: 'Manifest\'s display property is set',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {string|undefined} val
   * @return {boolean}
   */
  static hasRecommendedValue(val) {
    return (val === 'fullscreen' || val === 'standalone' || val === 'browser');
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const manifest = artifacts.Manifest.value;
    const displayValue = manifest && manifest.display.value;

    const hasRecommendedValue = ManifestDisplay.hasRecommendedValue(displayValue);

    return ManifestDisplay.generateAuditResult({
      rawValue: hasRecommendedValue,
      displayValue,
      debugString: 'Manifest display property should be set.'
    });
  }
}

module.exports = ManifestDisplay;

},{"./audit":"../audits/audit"}],"../audits/manifest-exists":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestExists extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-exists',
      description: 'Manifest exists',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    return ManifestExists.generateAuditResult({
      rawValue: typeof artifacts.Manifest.value !== 'undefined',
      debugString: artifacts.Manifest.debugString
    });
  }
}

module.exports = ManifestExists;

},{"./audit":"../audits/audit"}],"../audits/manifest-icons-min-144":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const icons = require('../lib/icons');

class ManifestIconsMin144 extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-icons-min-144',
      description: 'Manifest contains icons at least 144px',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const manifest = artifacts.Manifest.value;

    if (icons.doExist(manifest) === false) {
      return ManifestIconsMin144.generateAuditResult({
        rawValue: false,
        debugString: 'WARNING: No icons found in the manifest'
      });
    }

    const matchingIcons = icons.sizeAtLeast(144, /** @type {!Manifest} */ (manifest));
    const foundSizesDebug = matchingIcons.length ?
        `Found icons of sizes: ${matchingIcons}` : undefined;
    return ManifestIconsMin144.generateAuditResult({
      rawValue: !!matchingIcons.length,
      debugString: foundSizesDebug
    });
  }
}

module.exports = ManifestIconsMin144;


},{"../lib/icons":20,"./audit":"../audits/audit"}],"../audits/manifest-icons-min-192":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const icons = require('../lib/icons');

class ManifestIconsMin192 extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-icons-min-192',
      description: 'Manifest contains icons at least 192px',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const manifest = artifacts.Manifest.value;

    if (icons.doExist(manifest) === false) {
      return ManifestIconsMin192.generateAuditResult({
        rawValue: false,
        debugString: 'WARNING: No icons found in the manifest'
      });
    }

    const matchingIcons = icons.sizeAtLeast(192, /** @type {!Manifest} */ (manifest));

    const foundSizesDebug = matchingIcons.length ?
        `Found icons of sizes: ${matchingIcons}` : undefined;
    return ManifestIconsMin192.generateAuditResult({
      rawValue: !!matchingIcons.length,
      debugString: foundSizesDebug
    });
  }
}

module.exports = ManifestIconsMin192;

},{"../lib/icons":20,"./audit":"../audits/audit"}],"../audits/manifest-name":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestName extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-name',
      description: 'Manifest contains name',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let hasName = false;
    const manifest = artifacts.Manifest.value;

    if (manifest && manifest.name) {
      hasName = (!!manifest.name.value);
    }

    return ManifestName.generateAuditResult({
      rawValue: hasName
    });
  }
}

module.exports = ManifestName;

},{"./audit":"../audits/audit"}],"../audits/manifest-short-name-length":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestShortNameLength extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-short-name-length',
      description: 'Manifest\'s short_name won\'t be truncated when displayed on homescreen',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let isShortNameShortEnough = false;
    let debugString;
    const manifest = artifacts.Manifest.value;
    const suggestedLength = 12;

    if (manifest) {
      // When no shortname can be found we look for a name
      // Historically, Chrome recommended 12 chars as the maximum length to prevent truncation.
      // See #69 for more discussion.
      // https://developer.chrome.com/apps/manifest/name#short_name
      const manifestValue = manifest.short_name.value || manifest.name.value || '';
      isShortNameShortEnough = manifestValue && manifestValue.length <= suggestedLength;

      if (!isShortNameShortEnough) {
        debugString = `${suggestedLength} chars is the suggested maximum homescreen label length`;
        debugString += ` (Found: ${manifestValue.length} chars).`;
      }
    }

    return ManifestShortNameLength.generateAuditResult({
      rawValue: isShortNameShortEnough,
      debugString
    });
  }
}

module.exports = ManifestShortNameLength;

},{"./audit":"../audits/audit"}],"../audits/manifest-short-name":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestShortName extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-short-name',
      description: 'Manifest contains short_name',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let hasShortName = false;
    const manifest = artifacts.Manifest.value;

    if (manifest) {
      hasShortName = !!(manifest.short_name.value || manifest.name.value);
    }

    return ManifestShortName.generateAuditResult({
      rawValue: hasShortName
    });
  }
}

module.exports = ManifestShortName;

},{"./audit":"../audits/audit"}],"../audits/manifest-start-url":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestStartUrl extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-start-url',
      description: 'Manifest contains start_url',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let hasStartUrl = false;
    const manifest = artifacts.Manifest.value;

    if (manifest && manifest.start_url) {
      hasStartUrl = (!!manifest.start_url.value);
    }

    return ManifestStartUrl.generateAuditResult({
      rawValue: hasStartUrl
    });
  }
}

module.exports = ManifestStartUrl;

},{"./audit":"../audits/audit"}],"../audits/manifest-theme-color":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class ManifestThemeColor extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Manifest',
      name: 'manifest-theme-color',
      description: 'Manifest contains theme_color',
      requiredArtifacts: ['Manifest']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let hasThemeColor = false;
    const manifest = artifacts.Manifest.value;

    if (manifest && manifest.theme_color) {
      hasThemeColor = (!!manifest.theme_color.value);
    }

    return ManifestThemeColor.generateAuditResult({
      rawValue: hasThemeColor
    });
  }
}

module.exports = ManifestThemeColor;

},{"./audit":"../audits/audit"}],"../audits/meta-theme-color":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const validColor = require('../lib/web-inspector').Color.parse;
const Audit = require('./audit');

class ThemeColor extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'HTML',
      name: 'theme-color-meta',
      description: 'HTML has a theme-color <meta>',
      requiredArtifacts: ['ThemeColor']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const themeColorMeta = artifacts.ThemeColor;
    if (!themeColorMeta) {
      return ThemeColor.generateAuditResult({
        rawValue: false,
        debugString: 'No valid theme-color meta tag found.'
      });
    }

    if (!validColor(themeColorMeta)) {
      return ThemeColor.generateAuditResult({
        displayValue: themeColorMeta,
        rawValue: false,
        debugString: 'The theme-color meta tag did not contain a valid CSS color.'
      });
    }

    return ThemeColor.generateAuditResult({
      displayValue: themeColorMeta,
      rawValue: true
    });
  }
}

module.exports = ThemeColor;

},{"../lib/web-inspector":26,"./audit":"../audits/audit"}],"../audits/redirects-http":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Audit = require('./audit');

class RedirectsHTTP extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Security',
      name: 'redirects-http',
      description: 'Site redirects HTTP traffic to HTTPS',
      requiredArtifacts: ['HTTPRedirect']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    if (!artifacts.HTTPRedirect ||
        !artifacts.HTTPRedirect.value) {
      return RedirectsHTTP.generateAuditResult({
        rawValue: false
      });
    }

    return RedirectsHTTP.generateAuditResult({
      rawValue: artifacts.HTTPRedirect.value,
      debugString: artifacts.HTTPRedirect.debugString
    });
  }
}

module.exports = RedirectsHTTP;

},{"./audit":"../audits/audit"}],"../audits/screenshots":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class Screenshots extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'screenshots',
      description: 'Screenshots of all captured frames',
      requiredArtifacts: ['traceContents']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!Promise<!AuditResult>}
   */
  static audit(artifacts) {
    const trace = artifacts.traces[this.DEFAULT_PASS];
    if (typeof trace === 'undefined') {
      return Promise.resolve(Screenshots.generateAuditResult({
        rawValue: -1,
        debugString: 'No trace found to generate screenshots'
      }));
    }

    return artifacts.requestScreenshots(trace).then(screenshots => {
      if (typeof screenshots === 'undefined') {
        return Screenshots.generateAuditResult({
          rawValue: -1,
          debugString: 'No screenshot artifact'
        });
      }

      return Screenshots.generateAuditResult({
        rawValue: screenshots.length || 0,
        extendedInfo: {
          formatter: Formatter.SUPPORTED_FORMATS.NULL,
          value: screenshots
        }
      });
    });
  }
}

module.exports = Screenshots;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/service-worker":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const url = require('url');
const Audit = require('./audit');

/**
 * @param {string} targetURL
 * @return {string}
 */
function getOrigin(targetURL) {
  const parsedURL = url.parse(targetURL);
  return `${parsedURL.protocol}//${parsedURL.hostname}` +
      (parsedURL.port ? `:${parsedURL.port}` : '');
}

/**
 * @param {!Array<!ServiceWorkerVersion>} versions
 * @param {string} url
 * @return {(!ServiceWorkerVersion|undefined)}
 */
function getActivatedServiceWorker(versions, url) {
  const origin = getOrigin(url);
  return versions.find(v => v.status === 'activated' && getOrigin(v.scriptURL) === origin);
}

class ServiceWorker extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Offline',
      name: 'service-worker',
      description: 'Has a registered Service Worker',
      requiredArtifacts: ['URL', 'ServiceWorker']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    if (!artifacts.ServiceWorker.versions) {
      // Error in ServiceWorker gatherer.
      return ServiceWorker.generateAuditResult({
        rawValue: false,
        debugString: artifacts.ServiceWorker.debugString
      });
    }

    // Find active service worker for this URL. Match against
    // artifacts.URL.finalUrl so audit accounts for any redirects.
    const version = getActivatedServiceWorker(
        artifacts.ServiceWorker.versions, artifacts.URL.finalUrl);
    const debugString = version ? undefined : 'No active service worker found for this origin.';

    return ServiceWorker.generateAuditResult({
      rawValue: !!version,
      debugString: debugString
    });
  }
}

module.exports = ServiceWorker;

},{"./audit":"../audits/audit","url":204}],"../audits/speed-index-metric":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const TracingProcessor = require('../lib/traces/tracing-processor');
const Formatter = require('../formatters/formatter');

// Parameters (in ms) for log-normal CDF scoring. To see the curve:
// https://www.desmos.com/calculator/mdgjzchijg
const SCORING_POINT_OF_DIMINISHING_RETURNS = 1250;
const SCORING_MEDIAN = 5500;

class SpeedIndexMetric extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'speed-index-metric',
      description: 'Perceptual Speed Index',
      optimalValue: SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString(),
      requiredArtifacts: ['traceContents']
    };
  }

  /**
   * Audits the page to give a score for the Speed Index.
   * @see  https://github.com/GoogleChrome/lighthouse/issues/197
   * @param {!Artifacts} artifacts The artifacts from the gather phase.
   * @return {!Promise<!AuditResult>} The score from the audit, ranging from 0-100.
   */
  static audit(artifacts) {
    const trace = artifacts.traces[this.DEFAULT_PASS];
    if (typeof trace === 'undefined') {
      return SpeedIndexMetric.generateAuditResult({
        rawValue: -1,
        debugString: 'No trace found to generate screenshots'
      });
    }

    // run speedline
    return artifacts.requestSpeedline(trace).then(speedline => {
      if (speedline.frames.length === 0) {
        return SpeedIndexMetric.generateAuditResult({
          rawValue: -1,
          debugString: 'Trace unable to find visual progress frames.'
        });
      }

      if (speedline.speedIndex === 0) {
        return SpeedIndexMetric.generateAuditResult({
          rawValue: -1,
          debugString: 'Error in Speedline calculating Speed Index (speedIndex of 0).'
        });
      }

      // Use the CDF of a log-normal distribution for scoring.
      //  10th Percentile = 2,240
      //  25th Percentile = 3,430
      //  Median = 5,500
      //  75th Percentile = 8,820
      //  95th Percentile = 17,400
      const distribution = TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,
        SCORING_POINT_OF_DIMINISHING_RETURNS);
      let score = 100 * distribution.computeComplementaryPercentile(speedline.perceptualSpeedIndex);

      // Clamp the score to 0 <= x <= 100.
      score = Math.min(100, score);
      score = Math.max(0, score);

      const extendedInfo = {
        first: speedline.first,
        complete: speedline.complete,
        duration: speedline.duration,
        frames: speedline.frames.map(frame => {
          return {
            timestamp: frame.getTimeStamp(),
            progress: frame.getPerceptualProgress()
          };
        })
      };

      return SpeedIndexMetric.generateAuditResult({
        score: Math.round(score),
        rawValue: Math.round(speedline.perceptualSpeedIndex),
        optimalValue: this.meta.optimalValue,
        extendedInfo: {
          formatter: Formatter.SUPPORTED_FORMATS.SPEEDLINE,
          value: extendedInfo
        }
      });
    }).catch(err => {
      return SpeedIndexMetric.generateAuditResult({
        rawValue: -1,
        debugString: err.message
      });
    });
  }
}

module.exports = SpeedIndexMetric;

},{"../formatters/formatter":7,"../lib/traces/tracing-processor":25,"./audit":"../audits/audit"}],"../audits/tabindex":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');

class TabIndex extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Accessibility',
      name: 'tab-index',
      description: 'No element has a tabindex attribute greater than 0',
      requiredArtifacts: ['Accessibility']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const rule =
        artifacts.Accessibility.violations.find(result => result.id === 'tabindex');

    return TabIndex.generateAuditResult({
      rawValue: typeof rule === 'undefined',
      debugString: this.createDebugString(rule),
      extendedInfo: {
        formatter: Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,
        value: rule
      }
    });
  }

  static createDebugString(rule) {
    if (typeof rule === 'undefined') {
      return '';
    }

    const elementsStr = rule.nodes.length === 1 ? 'element' : 'elements';
    return `${rule.help} (Failed on ${rule.nodes.length} ${elementsStr})`;
  }
}

module.exports = TabIndex;

},{"../formatters/formatter":7,"./audit":"../audits/audit"}],"../audits/time-to-interactive":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const TracingProcessor = require('../lib/traces/tracing-processor');
const FMPMetric = require('./first-meaningful-paint');
const Formatter = require('../formatters/formatter');

// Parameters (in ms) for log-normal CDF scoring. To see the curve:
//   https://www.desmos.com/calculator/jlrx14q4w8
const SCORING_POINT_OF_DIMINISHING_RETURNS = 1700;
const SCORING_MEDIAN = 5000;

class TTIMetric extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'time-to-interactive',
      description: 'Time To Interactive (alpha)',
      optimalValue: SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString(),
      requiredArtifacts: ['traceContents']
    };
  }

  /**
   * Identify the time the page is "interactive"
   * @see https://docs.google.com/document/d/1oiy0_ych1v2ADhyG_QW7Ps4BNER2ShlJjx2zCbVzVyY/edit#
   *
   * The user thinks the page is ready - (They believe the page is done enough to start interacting with)
   *   - Layout has stabilized & key webfonts are visible.
   *     AKA: First meaningful paint has fired.
   *   - Page is nearly visually complete
   *     Visual completion is 85%
   *
   * The page is actually ready for user:
   *   - domContentLoadedEventEnd has fired
   *     Definition: HTML parsing has finished, all DOMContentLoaded handlers have run.
   *     No risk of DCL event handlers changing the page
   *     No surprises of inactive buttons/actions as DOM element event handlers should be bound
   *   - The main thread is available enough to handle user input
   *     first 500ms window where Est Input Latency is <50ms at the 90% percentile.
   *
   * WARNING: This metric WILL change its calculation. If you rely on its numbers now, know that they
   * will be changing in the future to a more accurate number.
   *
   * @param {!Artifacts} artifacts The artifacts from the gather phase.
   * @return {!Promise<!AuditResult>} The score from the audit, ranging from 0-100.
   */
  static audit(artifacts) {
    const trace = artifacts.traces[Audit.DEFAULT_PASS];
    const pendingSpeedline = artifacts.requestSpeedline(trace);
    const pendingFMP = FMPMetric.audit(artifacts);

    // We start looking at Math.Max(FMPMetric, visProgress[0.85])
    return Promise.all([pendingSpeedline, pendingFMP]).then(results => {
      const speedline = results[0];
      const fmpResult = results[1];
      if (fmpResult.rawValue === -1) {
        return generateError(fmpResult.debugString);
      }
      const fmpTiming = parseFloat(fmpResult.rawValue);
      const timings = fmpResult.extendedInfo && fmpResult.extendedInfo.value &&
          fmpResult.extendedInfo.value.timings;

      // Process the trace
      const tracingProcessor = new TracingProcessor();
      const trace = artifacts.traces[Audit.DEFAULT_PASS];
      const model = tracingProcessor.init(trace);
      const endOfTraceTime = model.bounds.max;

      // TODO: Wait for DOMContentLoadedEndEvent
      // TODO: Wait for UA loading indicator to be done

      // TODO CHECK these units are the same
      const fMPts = timings.fMPfull + timings.navStart;

      // look at speedline results for 85% starting at FMP
      let visuallyReadyTiming = 0;

      if (speedline.frames) {
        const eightyFivePctVC = speedline.frames.find(frame => {
          return frame.getTimeStamp() >= fMPts && frame.getProgress() >= 85;
        });

        if (eightyFivePctVC) {
          // TODO CHECK these units are the same
          visuallyReadyTiming = eightyFivePctVC.getTimeStamp() - timings.navStart;
        }
      }

      // Find first 500ms window where Est Input Latency is <50ms at the 90% percentile.
      let startTime = Math.max(fmpTiming, visuallyReadyTiming) - 50;
      let endTime;
      let currentLatency = Infinity;
      const percentiles = [0.9]; // [0.75, 0.9, 0.99, 1];
      const threshold = 50;
      const foundLatencies = [];

      // When we've found a latency that's good enough, we're good.
      while (currentLatency > threshold) {
        // While latency is too high, increment just 50ms and look again.
        startTime += 50;
        endTime = startTime + 500;
        // If there's no more room in the trace to look, we're done.
        if (endTime > endOfTraceTime) {
          return generateError('Entire trace was found to be busy.');
        }
        // Get our expected latency for the time window
        const latencies = TracingProcessor.getRiskToResponsiveness(
          model, trace, startTime, endTime, percentiles);
        const estLatency = latencies[0].time.toFixed(2);
        foundLatencies.push({
          estLatency: estLatency,
          startTime: startTime.toFixed(1)
        });

        // Grab this latency and try the threshold again
        currentLatency = estLatency;
      }
      const timeToInteractive = parseFloat(startTime.toFixed(1));

      // Use the CDF of a log-normal distribution for scoring.
      //   < 1200ms: score≈100
      //   5000ms: score=50
      //   >= 15000ms: score≈0
      const distribution = TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,
          SCORING_POINT_OF_DIMINISHING_RETURNS);
      let score = 100 * distribution.computeComplementaryPercentile(startTime);

      // Clamp the score to 0 <= x <= 100.
      score = Math.min(100, score);
      score = Math.max(0, score);
      score = Math.round(score);

      const extendedInfo = {
        timings: {
          fMP: fmpTiming.toFixed(1),
          visuallyReady: visuallyReadyTiming.toFixed(1),
          mainThreadAvail: startTime.toFixed(1)
        },
        expectedLatencyAtTTI: currentLatency,
        foundLatencies
      };

      return TTIMetric.generateAuditResult({
        score,
        rawValue: timeToInteractive,
        displayValue: `${timeToInteractive}ms`,
        optimalValue: this.meta.optimalValue,
        debugString: speedline.debugString,
        extendedInfo: {
          value: extendedInfo,
          formatter: Formatter.SUPPORTED_FORMATS.NULL
        }
      });
    }).catch(err => {
      return generateError(err);
    });
  }
}

module.exports = TTIMetric;

function generateError(err) {
  return TTIMetric.generateAuditResult({
    value: -1,
    rawValue: -1,
    optimalValue: TTIMetric.meta.optimalValue,
    debugString: err.message || err
  });
}

},{"../formatters/formatter":7,"../lib/traces/tracing-processor":25,"./audit":"../audits/audit","./first-meaningful-paint":"../audits/first-meaningful-paint"}],"../audits/user-timings":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');
const Formatter = require('../formatters/formatter');
const TimelineModel = require('../lib/traces/devtools-timeline-model');

const FAILURE_MESSAGE = 'Trace data not found.';

/**
 * @param {!Array<!Object>} traceData
 * @return {!Array<!UserTimingsExtendedInfo>}
 */
function filterTrace(traceData) {
  const userTimings = [];
  const measuresStartTimes = {};
  let traceStartFound = false;
  let navigationStartTime;

  // Fetch blink.user_timing events from the tracing data
  const timelineModel = new TimelineModel(traceData);
  const modeledTraceData = timelineModel.timelineModel();

  // Get all blink.user_timing events
  // The event phases we are interested in are mark and instant events (R, i, I)
  // and duration events which correspond to measures (B, b, E, e).
  // @see https://docs.google.com/document/d/1CvAClvFfyA5R-PhYUmn5OOQtYMH4h6I0nSsKchNAySU/preview#
  modeledTraceData.mainThreadEvents()
  .filter(ut => {
    if (ut.name === 'TracingStartedInPage' || ut.name === 'navigationStart') {
      return true;
    }

    if (ut.hasCategory('blink.user_timing')) {
      // reject these "userTiming" events that aren't really UserTiming, by nuking ones with frame data (or requestStart)
      // https://cs.chromium.org/search/?q=trace_event.*?user_timing&sq=package:chromium&type=cs
      return !(ut.name === 'requestStart' || ut.args.frame !== undefined);
    }

    return false;
  })
  .forEach(ut => {
    // Mark events fall under phases R and I (or i)
    if (ut.phase === 'R' || ut.phase.toUpperCase() === 'I') {
      // We only care about trace events that have to do with the page
      // Sometimes other frames can show up in the frame beforehand
      if (ut.name === 'TracingStartedInPage' && !traceStartFound) {
        traceStartFound = true;
        return;
      }

      // Once TraceingStartedInPage has begun, the next navigationStart event
      // marks the start of navigation
      // Make sure to not record such events hereafter
      if (ut.name === 'navigationStart' && traceStartFound && !navigationStartTime) {
        navigationStartTime = ut.startTime;
      }

      // Add user timings event to array
      if (ut.name !== 'navigationStart') {
        userTimings.push({
          name: ut.name,
          isMark: true,        // defines type of performance metric
          args: ut.args,
          startTime: ut.startTime
        });
      }
    } else if (ut.phase.toLowerCase() === 'b') {
      // Beginning of measure event, keep track of this events start time
      measuresStartTimes[ut.name] = ut.startTime;
    } else if (ut.phase.toLowerCase() === 'e') {
      // End of measure event
      // Add to the array of events
      userTimings.push({
        name: ut.name,
        isMark: false,
        args: ut.args,
        startTime: measuresStartTimes[ut.name],
        duration: ut.startTime - measuresStartTimes[ut.name],
        endTime: ut.startTime
      });
    }
  });

  userTimings.forEach(ut => {
    ut.startTime -= navigationStartTime;
    if (!ut.isMark) {
      ut.endTime -= navigationStartTime;
      ut.duration = ut.duration;
    }
  });

  return userTimings;
}

class UserTimings extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Performance',
      name: 'user-timings',
      description: 'User Timing marks and measures',
      requiredArtifacts: ['traceContents']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    return new Promise((resolve, reject) => {
      const traceContents =
        artifacts.traces[this.DEFAULT_PASS] &&
        artifacts.traces[this.DEFAULT_PASS].traceEvents;
      if (!traceContents || !Array.isArray(traceContents)) {
        throw new Error(FAILURE_MESSAGE);
      }

      const userTimings = filterTrace(traceContents);
      resolve(UserTimings.generateAuditResult({
        rawValue: userTimings.length,
        extendedInfo: {
          formatter: Formatter.SUPPORTED_FORMATS.USER_TIMINGS,
          value: userTimings
        }
      }));
    }).catch(err => {
      return UserTimings.generateAuditResult({
        rawValue: -1,
        debugString: err.message
      });
    });
  }
}

module.exports = UserTimings;

},{"../formatters/formatter":7,"../lib/traces/devtools-timeline-model":24,"./audit":"../audits/audit"}],"../audits/viewport":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Audit = require('./audit');

class Viewport extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Mobile Friendly',
      name: 'viewport',
      description: 'HTML has a viewport <meta>',
      requiredArtifacts: ['Viewport']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    const hasMobileViewport = typeof artifacts.Viewport === 'string' &&
        artifacts.Viewport.includes('width=');
    return Viewport.generateAuditResult({
      rawValue: !!hasMobileViewport
    });
  }
}

module.exports = Viewport;

},{"./audit":"../audits/audit"}],"../audits/without-javascript":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Audit = require('./audit');

class WithoutJavaScript extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'JavaScript',
      name: 'without-javascript',
      description: 'Page contains some content when its scripts are not available',
      requiredArtifacts: ['HTMLWithoutJavaScript']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    let bodyHasContent = true;
    let debugString;
    if (artifacts.HTMLWithoutJavaScript.trim() === '') {
      bodyHasContent = false;
      debugString = 'The page body should render some content if its scripts are not available.';
    }

    return WithoutJavaScript.generateAuditResult({
      rawValue: bodyHasContent,
      debugString
    });
  }
}

module.exports = WithoutJavaScript;

},{"./audit":"../audits/audit"}],"../audits/works-offline":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Audit = require('./audit');

class WorksOffline extends Audit {
  /**
   * @return {!AuditMeta}
   */
  static get meta() {
    return {
      category: 'Offline',
      name: 'works-offline',
      description: 'URL responds with a 200 when offline',
      requiredArtifacts: ['Offline']
    };
  }

  /**
   * @param {!Artifacts} artifacts
   * @return {!AuditResult}
   */
  static audit(artifacts) {
    return WorksOffline.generateAuditResult({
      rawValue: artifacts.Offline === 200
    });
  }
}

module.exports = WorksOffline;

},{"./audit":"../audits/audit"}],"./computed/computed-artifact":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

class ComputedArtifact {
  constructor() {
    this.cache = new Map();
  }

  /* eslint-disable no-unused-vars */

  /**
   * Override to implement a computed artifact. Can return a Promise or the
   * computed artifact itself.
   * @param {!Object} artifact Input to computation.
   * @return {!Promise|!Object|!Array}
   */
  compute_(artifact) {
    throw new Error('compute_() not implemented for computed artifact ' + this.name);
  }

  /* eslint-enable no-unused-vars */

  /**
   * Request a computed artifact, caching the result on the input artifact.
   * @param {!OBject} artifact
   * @return {!Promise}
   */
  request(artifact) {
    if (this.cache.has(artifact)) {
      return Promise.resolve(this.cache.get(artifact));
    }

    return Promise.resolve(this.compute_(artifact)).then(computedArtifact => {
      this.cache.set(artifact, computedArtifact);
      return computedArtifact;
    });
  }
}

module.exports = ComputedArtifact;

},{}],"./computed/critical-request-chains":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const ComputedArtifact = require('./computed-artifact');
const WebInspector = require('../../lib/web-inspector');

const includes = (arr, elm) => arr.indexOf(elm) > -1;

class CriticalRequestChains extends ComputedArtifact {

  get name() {
    return 'CriticalRequestChains';
  }

  /**
   * For now, we use network priorities as a proxy for "render-blocking"/critical-ness.
   * It's imperfect, but there is not a higher-fidelity signal available yet.
   * @see https://docs.google.com/document/d/1bCDuq9H1ih9iNjgzyAL0gpwNFiEP4TZS-YLRp_RuMlc
   * @param  {any} request
   */
  isCritical(request) {
    // XHRs are fetched at High priority, but we exclude them, as they are unlikely to be critical
    const resourceTypeCategory = request._resourceType && request._resourceType._category;
    if (resourceTypeCategory === WebInspector.resourceTypes.XHR._category) {
      return false;
    }

    // Treat favicons as non-critical resources
    if (request.mimeType === 'image/x-icon' ||
        (request.parsedURL && request.parsedURL.lastPathComponent === 'favicon.ico')) {
      return false;
    }

    return includes(['VeryHigh', 'High', 'Medium'], request.priority());
  }

  compute_(networkRecords) {
    // Build a map of requestID -> Node.
    const requestIdToRequests = new Map();
    for (const request of networkRecords) {
      requestIdToRequests.set(request.requestId, request);
    }

    // Get all the critical requests.
    /** @type {!Array<NetworkRequest>} */
    const criticalRequests = networkRecords.filter(req => this.isCritical(req));

    const flattenRequest = request => {
      return {
        url: request._url,
        startTime: request.startTime,
        endTime: request.endTime,
        responseReceivedTime: request.responseReceivedTime,
        transferSize: request.transferSize
      };
    };

    // Create a tree of critical requests.
    const criticalRequestChains = {};
    for (const request of criticalRequests) {
      // Work back from this request up to the root. If by some weird quirk we are giving request D
      // here, which has ancestors C, B and A (where A is the root), we will build array [C, B, A]
      // during this phase.
      const ancestors = [];
      let ancestorRequest = request.initiatorRequest();
      let node = criticalRequestChains;
      while (ancestorRequest) {
        const ancestorIsCritical = this.isCritical(ancestorRequest);

        // If the parent request isn't a high priority request it won't be in the
        // requestIdToRequests map, and so we can break the chain here. We should also
        // break it if we've seen this request before because this is some kind of circular
        // reference, and that's bad.
        if (!ancestorIsCritical || includes(ancestors, ancestorRequest.requestId)) {
          // Set the ancestors to an empty array and unset node so that we don't add
          // the request in to the tree.
          ancestors.length = 0;
          node = undefined;
          break;
        }
        ancestors.push(ancestorRequest.requestId);
        ancestorRequest = ancestorRequest.initiatorRequest();
      }

      // With the above array we can work from back to front, i.e. A, B, C, and during this process
      // we can build out the tree for any nodes that have yet to be created.
      let ancestor = ancestors.pop();
      while (ancestor) {
        const parentRequest = requestIdToRequests.get(ancestor);
        const parentRequestId = parentRequest.requestId;
        if (!node[parentRequestId]) {
          node[parentRequestId] = {
            request: flattenRequest(parentRequest),
            children: {}
          };
        }

        // Step to the next iteration.
        ancestor = ancestors.pop();
        node = node[parentRequestId].children;
      }

      if (!node) {
        continue;
      }

      // If the node already exists, bail.
      if (node[request.requestId]) {
        continue;
      }

      // node should now point to the immediate parent for this request.
      node[request.requestId] = {
        request: flattenRequest(request),
        children: {}
      };
    }

    return criticalRequestChains;
  }
}

module.exports = CriticalRequestChains;

},{"../../lib/web-inspector":26,"./computed-artifact":"./computed/computed-artifact"}],"./computed/pushed-requests":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const ComputedArtifact = require('./computed-artifact');

class PushedRequests extends ComputedArtifact {

  get name() {
    return 'PushedRequests';
  }

  /**
   * Return list of network requests that were pushed.
   * @param {!Array<!WebInspector.NetworkRequest>} records
   * @return {!Array<!WebInspector.NetworkRequest>}
   */
  compute_(records) {
    const pushedRecords = records.filter(r => r._timing && !!r._timing.pushStart);
    return pushedRecords;
  }
}

module.exports = PushedRequests;

},{"./computed-artifact":"./computed/computed-artifact"}],"./computed/screenshots":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const ComputedArtifact = require('./computed-artifact');
const DevtoolsTimelineModel = require('../../lib/traces/devtools-timeline-model');

class ScreenshotFilmstrip extends ComputedArtifact {

  get name() {
    return 'Screenshots';
  }

  fetchScreenshot(frame) {
    return frame
      .imageDataPromise()
      .then(data => 'data:image/jpg;base64,' + data);
  }

  /**
   * @param {{traceEvents: !Array}} trace
   * @return {!Promise}
  */
  compute_(trace) {
    const model = new DevtoolsTimelineModel(trace.traceEvents);
    const filmStripFrames = model.filmStripModel().frames();

    const frameFetches = filmStripFrames.map(frame => this.fetchScreenshot(frame));
    return Promise.all(frameFetches).then(images => {
      const result = filmStripFrames.map((frame, i) => ({
        timestamp: frame.timestamp,
        datauri: images[i]
      }));
      return result;
    });
  }
}

module.exports = ScreenshotFilmstrip;

},{"../../lib/traces/devtools-timeline-model":24,"./computed-artifact":"./computed/computed-artifact"}],"./computed/speedline":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const ComputedArtifact = require('./computed-artifact');
const speedline = require('speedline');

class Speedline extends ComputedArtifact {

  get name() {
    return 'Speedline';
  }

  /**
   * @return {!Promise}
   */
  compute_(trace) {
    // speedline() may throw without a promise, so we resolve immediately
    // to get in a promise chain.
    return Promise.resolve().then(_ => {
      return speedline(trace.traceEvents);
    }).then(speedlineResults => {
      return speedlineResults;
    });
  }
}

module.exports = Speedline;

},{"./computed-artifact":"./computed/computed-artifact","speedline":254}],"./gatherers/accessibility":[function(require,module,exports){
(function (Buffer){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/* global document */

const Gatherer = require('./gatherer');

const axe = Buffer("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","base64");

// This is run in the page, not Lighthouse itself.
/* istanbul ignore next */
function runA11yChecks() {
  return new Promise((resolve, reject) => {
    axe.a11yCheck(document, resolve);
  });
}

class Accessibility extends Gatherer {
  static _errorAccessibility(errorString) {
    return {
      raw: undefined,
      value: undefined,
      debugString: errorString
    };
  }

  afterPass(options) {
    const driver = options.driver;

    return driver
        .evaluateAsync(`${axe};(${runA11yChecks.toString()}())`)
        .then(returnedValue => {
          if (!returnedValue) {
            this.artifact = Accessibility._errorAccessibility('Unable to parse axe results');
            return;
          }

          if (returnedValue.error) {
            this.artifact = Accessibility._errorAccessibility(returnedValue.error);
          } else {
            this.artifact = returnedValue;
          }
        }, _ => {
          this.artifact = Accessibility._errorAccessibility('Axe results timed out');
        });
  }
}

module.exports = Accessibility;

}).call(this,require("buffer").Buffer)
},{"./gatherer":"./gatherers/gatherer","buffer":194}],"./gatherers/cache-contents":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/* global caches */

const Gatherer = require('./gatherer');

// This is run in the page, not Lighthouse itself.
/* istanbul ignore next */
function getCacheContents() {
  // Get every cache by name.
  return caches.keys()

      // Open each one.
      .then(cacheNames => Promise.all(cacheNames.map(cacheName => caches.open(cacheName))))

      .then(caches => {
        const requests = [];

        // Take each cache and get any requests is contains, and bounce each one down to its URL.
        return Promise.all(caches.map(cache => {
          return cache.keys()
              .then(reqs => {
                requests.push(...reqs.map(r => r.url));
              });
        })).then(_ => {
          return requests;
        });
      });
}

class CacheContents extends Gatherer {
  static _error(errorString) {
    return {
      raw: undefined,
      value: undefined,
      debugString: errorString
    };
  }

  afterPass(options) {
    const driver = options.driver;

    return driver
        .evaluateAsync(`(${getCacheContents.toString()}())`)
        .then(returnedValue => {
          if (!returnedValue) {
            this.artifact = CacheContents._error('Unable to retrieve cache contents');
            return;
          }
          this.artifact = returnedValue;
        }, _ => {
          this.artifact = CacheContents._error('Unable to retrieve cache contents');
        });
  }
}

module.exports = CacheContents;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/content-width":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

/* global window */

/* istanbul ignore next */
function getContentWidth() {
  // window.innerWidth to get the scrollable size of the window (irrespective of zoom)
  // window.outerWidth to get the size of the visible area
  return Promise.resolve({
    scrollWidth: window.innerWidth,
    viewportWidth: window.outerWidth
  });
}

class ContentWidth extends Gatherer {

  afterPass(options) {
    const driver = options.driver;

    return driver.evaluateAsync(`(${getContentWidth.toString()}())`)

    .then(returnedValue => {
      this.artifact = returnedValue;
    }, _ => {
      this.artifact = {
        scrollWidth: -1,
        viewportWidth: -1
      };
      return;
    });
  }
}

module.exports = ContentWidth;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/gatherer":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/**
 * Base class for all gatherers; defines pass lifecycle methods.
 */
class Gatherer {

  constructor() {
    this.artifact = {};
  }

  /**
   * @return {string}
   */
  get name() {
    return this.constructor.name;
  }

  /* eslint-disable no-unused-vars */

  /**
   * Called before navigation to target url.
   * @param {!Object} options
   */
  beforePass(options) { }

  /**
   * Called after target page is loaded. If a trace is enabled for this pass,
   * the trace is still being recorded.
   * @param {!Object} options
   */
  pass(options) { }

  /**
   * Called after target page is loaded, all gatherer `pass` methods have been
   * executed, and — if generated in this pass — the trace is ended. The trace
   * and record of network activity are provided in `loadData`.
   * @param {!Object} options
   * @param {{networkRecords: !Array, trace: {traceEvents: !Array}} loadData
   */
  afterPass(options, loadData) { }

  /* eslint-enable no-unused-vars */

}

module.exports = Gatherer;

},{}],"./gatherers/geolocation-on-start":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

/**
 * @fileoverview Tests whether the page attempts to request geolocation on page load. This often
 * represents a poor user experience, since it lacks context. As such, if the page requests
 * geolocation the gatherer will intercept the call and mark a boolean flag to true. The audit that
 * corresponds with this gatherer then checks for the flag.
 * @author Paul Lewis
 */

/* global navigator, window */

/* istanbul ignore next */
function overrideGeo() {
  window.__didNotCallGeo = true;
  // Override the geo functions so that if they're called they're intercepted and we know about it.
  navigator.geolocation.getCurrentPosition =
  navigator.geolocation.watchPosition = function() {
    window.__didNotCallGeo = false;
  };
}

function collectGeoState() {
  return Promise.resolve(window.__didNotCallGeo);
}

class GeolocationOnStart extends Gatherer {

  beforePass(options) {
    return options.driver.evaluateScriptOnLoad(`(${overrideGeo.toString()}())`);
  }

  afterPass(options) {
    return options.driver.evaluateAsync(`(${collectGeoState.toString()}())`)
        .then(returnedValue => {
          this.artifact = returnedValue;
        }, _ => {
          this.artifact = -1;
          return;
        });
  }
}

module.exports = GeolocationOnStart;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/html-without-javascript":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/* Note that this returns the innerText of the <body> element, not the HTML. */

const Gatherer = require('./gatherer');

/* global document */

/* istanbul ignore next */
function getBodyText() {
  // note: we use innerText, not textContent, because textContent includes the content of <script> elements!
  const body = document.querySelector('body');
  return Promise.resolve(body ? body.innerText : '');
}

class HTMLWithoutJavaScript extends Gatherer {

  beforePass(options) {
    options.disableJavaScript = true;
  }

  afterPass(options) {
    // Reset the JS disable.
    options.disableJavaScript = false;

    const driver = options.driver;

    this.artifact = {};
    return driver.evaluateAsync(`(${getBodyText.toString()}())`)
      .then(result => {
        this.artifact = result;
      })
      .catch(_ => {
        this.artifact = {
          value: -1,
          debugString: 'Unable to get document body innerText'
        };
      });
  }
}

module.exports = HTMLWithoutJavaScript;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/html":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class HTML extends Gatherer {

  afterPass(options) {
    const driver = options.driver;

    return driver.sendCommand('DOM.getDocument')
        .then(result => result.root.nodeId)
        .then(nodeId => driver.sendCommand('DOM.getOuterHTML', {
          nodeId: nodeId
        }))
        .then(nodeHTML => {
          this.artifact = nodeHTML.outerHTML;
        }).catch(_ => {
          this.artifact = {
            value: -1,
            debugString: 'Unable to get document HTML'
          };
        });
  }
}

module.exports = HTML;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/http-redirect":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

/**
 * This gatherer changes the options.url so that its pass loads the http page.
 * After load it detects if its on a crypographic scheme.
 * TODO: Instead of abusing a loadPage pass for this test, it could likely just do an XHR instead
 */
class HTTPRedirect extends Gatherer {

  constructor() {
    super();
    this._preRedirectURL = undefined;
  }

  beforePass(options) {
    this._preRedirectURL = options.url;
    options.url = this._preRedirectURL.replace(/^https/, 'http');
  }

  afterPass(options) {
    // Reset the options.
    options.url = this._preRedirectURL;

    // Allow override for faster testing.
    const timeout = options._testTimeout || 10000;

    const securityPromise = options.driver.getSecurityState()
      .then(state => {
        return {
          value: state.schemeIsCryptographic
        };
      }, _ => {
        return {
          value: false,
          debugString: 'Error requesting security state'
        };
      });

    let noSecurityChangesTimeout;
    const timeoutPromise = new Promise((resolve, reject) => {
      // Set up a timeout for ten seconds in case we don't get any
      // security events at all. If that happens, bail.
      noSecurityChangesTimeout = setTimeout(_ => {
        resolve({
          value: false,
          debugString: 'Timed out waiting for HTTP redirection.'
        });
      }, timeout);
    });

    return Promise.race([
      securityPromise,
      timeoutPromise
    ]).then(result => {
      // Clear timeout. No effect if it won, no need to wait if it lost.
      clearTimeout(noSecurityChangesTimeout);
      this.artifact = result;
    });
  }
}

module.exports = HTTPRedirect;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/https":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

/**
 * @fileoverview Determines the security level of the page.
 * @see https://chromedevtools.github.io/debugger-protocol-viewer/tot/Security/#type-SecurityState
 */

class HTTPS extends Gatherer {

  constructor() {
    super();
    this._noSecurityChangesTimeout = undefined;
  }

  afterPass(options) {
    // Allow override for faster testing.
    const timeout = options._testTimeout || 10000;

    const securityPromise = options.driver.getSecurityState()
      .then(state => {
        return {
          value: state.schemeIsCryptographic
        };
      }, _ => {
        return {
          value: false,
          debugString: 'Error requesting page security state.'
        };
      });

    let noSecurityChangesTimeout;
    const timeoutPromise = new Promise((resolve, reject) => {
      // Set up a timeout for ten seconds in case we don't get any
      // security events at all. If that happens, bail.
      noSecurityChangesTimeout = setTimeout(_ => {
        resolve({
          value: false,
          debugString: 'Timed out waiting for page security state.'
        });
      }, timeout);
    });

    return Promise.race([
      securityPromise,
      timeoutPromise
    ]).then(result => {
      // Clear timeout. No effect if it won, no need to wait if it lost.
      clearTimeout(noSecurityChangesTimeout);
      this.artifact = result;
    });
  }
}

module.exports = HTTPS;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/manifest":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');
const manifestParser = require('../../lib/manifest-parser');

class Manifest extends Gatherer {

  static _errorManifest(errorString) {
    return {
      raw: undefined,
      value: undefined,
      debugString: errorString
    };
  }

  afterPass(options) {
    const driver = options.driver;
    /**
     * This re-fetches the manifest separately, which could
     * potentially lead to a different asset. Using the original manifest
     * resource is tracked in issue #83
     */
    return driver.sendCommand('Page.getAppManifest')
      .then(response => {
        if (response.errors.length) {
          let errorString;
          if (response.url) {
            errorString = `Unable to retrieve manifest at ${response.url}: `;
          }
          this.artifact = Manifest._errorManifest(errorString + response.errors.join(', '));
          return;
        }

        // The driver will return an empty string for url and the data if the
        // page has no manifest.
        if (!response.data.length && !response.data.url) {
          this.artifact = Manifest._errorManifest('No manifest found.');
          return;
        }

        this.artifact = manifestParser(response.data, response.url, options.url);
      }, _ => {
        this.artifact = Manifest._errorManifest('Unable to retrieve manifest');
        return;
      });
  }
}

module.exports = Manifest;

},{"../../lib/manifest-parser":22,"./gatherer":"./gatherers/gatherer"}],"./gatherers/offline":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class Offline extends Gatherer {
  beforePass(options) {
    return options.driver.goOffline();
  }

  afterPass(options, tracingData) {
    const navigationRecord = tracingData.networkRecords.filter(record => {
      return record._url === options.url && record._fetchedViaServiceWorker;
    }).pop(); // Take the last record that matches.

    this.artifact = navigationRecord ? navigationRecord.statusCode : -1;

    return options.driver.goOnline(options);
  }
}

module.exports = Offline;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/service-worker":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class ServiceWorker extends Gatherer {
  beforePass(options) {
    const driver = options.driver;
    return driver
      .getServiceWorkerVersions()
      .then(data => {
        return {
          versions: data.versions
        };
      })
      .catch(err => {
        return {
          debugString: `Error in querying Service Worker status: ${err.message}`
        };
      }).then(artifact => {
        this.artifact = artifact;
      });
  }
}

module.exports = ServiceWorker;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/styles":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Gathers the active style and stylesheets used on a page.
 * "Active" means that if the stylesheet is removed at a later time
 * (before endStylesCollect is called), this gatherer will not include it.
 */

'use strict';

const WebInspector = require('../../lib/web-inspector');
const Gatherer = require('./gatherer');

/**
 * @param {!gonzales.AST} parseTree
 * @return {!Array}
 */
function getCSSPropsInStyleSheet(parseTree) {
  const results = [];

  parseTree.traverseByType('declaration', function(node, index, parent) {
    const keyVal = node.toString().split(':').map(item => item.trim());
    results.push({
      property: {name: keyVal[0], val: keyVal[1]},
      declarationRange: node.declarationRange,
      selector: parent.selectors.toString()
    });
  });

  return results;
}

class Styles extends Gatherer {

  constructor() {
    super();
    this._activeStyleSheetIds = [];
    this._activeStyleHeaders = {};
    this._onStyleSheetAdded = this.onStyleSheetAdded.bind(this);
    this._onStyleSheetRemoved = this.onStyleSheetRemoved.bind(this);
  }

  onStyleSheetAdded(styleHeader) {
    // Exclude stylesheets "injected" by extensions or ones that were added by
    // users using the "inspector".
    if (styleHeader.header.origin !== 'regular') {
      return;
    }

    this._activeStyleHeaders[styleHeader.header.styleSheetId] = styleHeader;
    this._activeStyleSheetIds.push(styleHeader.header.styleSheetId);
  }

  onStyleSheetRemoved(styleHeader) {
    delete this._activeStyleHeaders[styleHeader.styleSheetId];

    const idx = this._activeStyleSheetIds.indexOf(styleHeader.styleSheetId);
    if (idx !== -1) {
      this._activeStyleSheetIds.splice(idx, 1);
    }
  }

  beginStylesCollect(driver) {
    driver.on('CSS.styleSheetAdded', this._onStyleSheetAdded);
    driver.on('CSS.styleSheetRemoved', this._onStyleSheetRemoved);
    return driver.sendCommand('DOM.enable')
      .then(_ => driver.sendCommand('CSS.enable'));
  }

  endStylesCollect(driver) {
    return new Promise((resolve, reject) => {
      if (!this._activeStyleSheetIds.length) {
        reject('No active stylesheets were collected.');
        return;
      }

      const parser = new WebInspector.SCSSParser();

      // Get text content of each style.
      const contentPromises = this._activeStyleSheetIds.map(sheetId => {
        return driver.sendCommand('CSS.getStyleSheetText', {
          styleSheetId: sheetId
        }).then(content => {
          const styleHeader = this._activeStyleHeaders[sheetId];
          styleHeader.content = content.text;
          styleHeader.parsedContent = getCSSPropsInStyleSheet(
              parser.parse(styleHeader.content));
          return styleHeader;
        });
      });

      Promise.all(contentPromises).then(styleHeaders => {
        driver.off('CSS.styleSheetAdded', this._onStyleSheetAdded);
        driver.off('CSS.styleSheetRemoved', this._onStyleSheetRemoved);
        return driver.sendCommand('CSS.disable')
          .then(_ => driver.sendCommand('DOM.disable'))
          .then(_ => resolve(styleHeaders));
      }).catch(err => reject(err));
    });
  }

  beforePass(options) {
    return this.beginStylesCollect(options.driver);
  }

  afterPass(options) {
    return this.endStylesCollect(options.driver)
      .then(stylesheets => {
        // Want unique stylesheets. Remove those with the same text content.
        // An example where stylesheets are the same is if the user includes a
        // stylesheet more than once (these have unique stylesheet ids according to
        // the DevTools protocol). Another example is many instances of a shadow
        // root that share the same <style> tag.
        const map = new Map(stylesheets.map(s => [s.content, s]));
        this.artifact = Array.from(map.values());
      }, err => {
        this.artifact = {
          rawValue: -1,
          debugString: err
        };
      });
  }
}

module.exports = Styles;

},{"../../lib/web-inspector":26,"./gatherer":"./gatherers/gatherer"}],"./gatherers/theme-color":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class ThemeColor extends Gatherer {

  afterPass(options) {
    const driver = options.driver;

    return driver.querySelector('head meta[name="theme-color"]')
      .then(node => node && node.getAttribute('content'))
      .then(themeColorMeta => {
        this.artifact = themeColorMeta;
      })
      .catch(_ => {
        // The audit should read this as a fail since -1 is not a valid color.
        this.artifact = -1;
      });
  }
}

module.exports = ThemeColor;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/url":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class URL extends Gatherer {

  afterPass(options) {
    // Used currently by cache-start-url audit, which wants to know if the start_url
    // in the manifest is stored in the cache.
    // Instead of the originally inputted URL (options.initialUrl), we want the resolved
    // post-redirect URL (which is here at options.url)
    this.artifact = {
      initialUrl: options.initialUrl,
      finalUrl: options.url
    };
  }
}

module.exports = URL;

},{"./gatherer":"./gatherers/gatherer"}],"./gatherers/viewport":[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Gatherer = require('./gatherer');

class Viewport extends Gatherer {

  /**
   * @param {!{driver: !Object}} options Run options
   * @return {!Promise<?string>} The value of the viewport meta's content attribute, or null
   */
  afterPass(options) {
    const driver = options.driver;

    return driver.querySelector('head meta[name="viewport"]')
      .then(node => node && node.getAttribute('content'))
      .then(viewport => {
        this.artifact = viewport;
      })
      .catch(_ => {
        this.artifact = -1;
      });
  }
}

module.exports = Viewport;

},{"./gatherer":"./gatherers/gatherer"}],1:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

class Aggregate {

  /**
   * @private
   * @param {!Array<!AuditResult>} results
   * @param {!AggregationCriteria} expected
   * @return {!Array<!AuditResult>}
   */
  static _filterResultsByAuditNames(results, expected) {
    const expectedNames = Object.keys(expected);
    return results.filter(r => expectedNames.indexOf(/** @type {string} */ (r.name)) !== -1);
  }

  /**
   * @private
   * @param {!AggregationCriteria} expected
   * @return {number}
   */
  static _getTotalWeight(expected) {
    const expectedNames = Object.keys(expected);
    const totalWeight = expectedNames.reduce((last, e) => last + (expected[e].weight || 0), 0);
    return totalWeight;
  }

  /**
   * @private
   * @param {!Array<!AuditResult>} results
   * @return {!Object<!AuditResult>}
   */
  static _remapResultsByName(results) {
    const remapped = {};
    results.forEach(r => {
      if (remapped[r.name]) {
        throw new Error(`Cannot remap: ${r.name} already exists`);
      }

      remapped[r.name] = r;
    });
    return remapped;
  }

  /**
   * Converts each raw audit output to a weighted value for the aggregation.
   * @private
   * @param {!AuditResult} result The audit's output value.
   * @param {!AggregationCriterion} expected The aggregation's expected value and weighting for this result.
   * @param {!string} name The name of the audit.
   * @return {number} The weighted result.
   */
  static _convertToWeight(result, expected, name) {
    let weight = 0;

    if (typeof expected === 'undefined' ||
        typeof expected.expectedValue === 'undefined' ||
        typeof expected.weight === 'undefined') {
      const msg =
          `aggregations: ${name} audit does not contain expectedValue or weight properties`;
      throw new Error(msg);
    }

    if (typeof result === 'undefined' ||
        typeof result.score === 'undefined') {
      let msg =
          `${name} audit result is undefined or does not contain score property`;
      if (result && result.debugString) {
        msg += ': ' + result.debugString;
      }
      throw new Error(msg);
    }

    if (typeof result.score !== typeof expected.expectedValue) {
      const expectedType = typeof expected.expectedValue;
      const resultType = typeof result.rawValue;
      let msg = `Expected expectedValue of type ${expectedType}, got ${resultType}`;
      if (result.debugString) {
        msg += ': ' + result.debugString;
      }
      throw new Error(msg);
    }

    switch (typeof expected.expectedValue) {
      case 'boolean':
        weight = this._convertBooleanToWeight(result.score,
            expected.expectedValue, expected.weight);
        break;

      case 'number':
        weight = this._convertNumberToWeight(result.score, expected.expectedValue, expected.weight);
        break;

      default:
        weight = 0;
        break;
    }

    return weight;
  }

  /**
   * Converts a numeric result to a weight.
   * @param {number} resultValue The result.
   * @param {number} expectedValue The expected value.
   * @param {number} weight The weight to assign.
   * @return {number} The final weight.
   */
  static _convertNumberToWeight(resultValue, expectedValue, weight) {
    return (resultValue / expectedValue) * weight;
  }

  /**
   * Converts a boolean result to a weight.
   * @param {boolean} resultValue The result.
   * @param {boolean} expectedValue The expected value.
   * @param {number} weight The weight to assign.
   * @return {number} The final weight.
   */
  static _convertBooleanToWeight(resultValue, expectedValue, weight) {
    return (resultValue === expectedValue) ? weight : 0;
  }

  /**
   * Compares the set of audit results to the expected values.
   * @param {!Array<!AuditResult>} results The audit results.
   * @param {!Array<!AggregationItem>} items The aggregation's expected values and weighting.
   * @param {!boolean} aggregationIsScored Whether or not the aggregation is scored.
   * @return {!Array<!AggregationResultItem>} The aggregation score.
   */
  static compare(results, items, aggregationIsScored) {
    return items.map(item => {
      const expectedNames = Object.keys(item.audits);

      // Filter down and remap the results to something more comparable to
      // the expected set of results.
      const filteredAndRemappedResults =
          Aggregate._remapResultsByName(
            Aggregate._filterResultsByAuditNames(results, item.audits)
          );

      const subItems = [];
      let overallScore = 0;
      let maxScore = 1;

      // Step through each item in the expected results, and add them
      // to the overall score and add each to the subItems list.
      expectedNames.forEach(e => {
        /* istanbul ignore if */
        // TODO(paullewis): Remove once coming soon audits have landed.
        if (item.audits[e].comingSoon) {
          subItems.push({
            score: '¯\\_(ツ)_/¯', // TODO(samthor): Patch going to Closure, String.raw is badly typed
            name: 'coming-soon',
            category: item.audits[e].category,
            description: item.audits[e].description,
            comingSoon: true
          });

          return;
        }

        if (!filteredAndRemappedResults[e]) {
          return;
        }

        subItems.push(filteredAndRemappedResults[e].name);

        // Only add to the score if this aggregation contributes to the
        // overall score.
        if (!aggregationIsScored) {
          return;
        }

        overallScore += Aggregate._convertToWeight(
            filteredAndRemappedResults[e],
            item.audits[e],
            e);
      });

      if (aggregationIsScored) {
        maxScore = Aggregate._getTotalWeight(item.audits);
      }

      return {
        overall: (overallScore / maxScore),
        name: item.name,
        description: item.description,
        subItems: subItems
      };
    });
  }

  /**
   * Aggregates all the results.
   * @param {!Aggregation} aggregation
   * @param {!Array<!AuditResult>} results
   * @return {!AggregationResult}
   */
  static aggregate(aggregation, auditResults) {
    return {
      name: aggregation.name,
      description: aggregation.description,
      scored: aggregation.scored,
      categorizable: aggregation.categorizable,
      score: Aggregate.compare(auditResults, aggregation.items, aggregation.scored)
    };
  }
}

module.exports = Aggregate;

},{}],2:[function(require,module,exports){
(function (__dirname){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const defaultConfigPath = './default.json';
const defaultConfig = require('./default.json');
const recordsFromLogs = require('../lib/network-recorder').recordsFromLogs;

const GatherRunner = require('../gather/gather-runner');
const log = require('../lib/log');
const path = require('path');
const Audit = require('../audits/audit');

// cleanTrace is run to remove duplicate TracingStartedInPage events,
// and to change TracingStartedInBrowser events into TracingStartedInPage.
// This is done by searching for most occuring threads and basing new events
// off of those.
function cleanTrace(trace) {
  const traceEvents = trace.traceEvents;
  // Keep track of most occuring threads
  const threads = [];
  const countsByThread = {};
  const traceStartEvents = [];
  const makeMockEvent = (evt, ts) => {
    return {
      pid: evt.pid,
      tid: evt.tid,
      ts: ts || 0,  // default to 0 for now
      ph: 'I',
      cat: 'disabled-by-default-devtools.timeline',
      name: 'TracingStartedInPage',
      args: {
        data: {
          page: evt.frame
        }
      },
      s: 't'
    };
  };

  let frame;
  let data;
  let name;
  let counter;

  traceEvents.forEach((evt, idx) => {
    if (evt.name.startsWith('TracingStartedIn')) {
      traceStartEvents.push(idx);
    }

    // find the event's frame
    data = evt.args && (evt.args.data || evt.args.beginData || evt.args.counters);
    frame = (evt.args && evt.args.frame) || data && (data.frame || data.page);

    if (!frame) {
      return;
    }

    // Increase occurences count of the frame
    name = `pid${evt.pid}-tid${evt.tid}-frame${frame}`;
    counter = countsByThread[name];
    if (!counter) {
      counter = {
        pid: evt.pid,
        tid: evt.tid,
        frame: frame,
        count: 0
      };
      countsByThread[name] = counter;
      threads.push(counter);
    }
    counter.count++;
  });

  // find most active thread (and frame)
  threads.sort((a, b) => b.count - a.count);
  const mostActiveFrame = threads[0];

  // Remove all current TracingStartedIn* events, storing
  // the first events ts.
  const ts = traceEvents[traceStartEvents[0]] && traceEvents[traceStartEvents[0]].ts;

  // account for offset after removing items
  let i = 0;
  for (const dup of traceStartEvents) {
    traceEvents.splice(dup - i, 1);
    i++;
  }

  // Add a new TracingStartedInPage event based on most active thread
  // and using TS of first found TracingStartedIn* event
  traceEvents.unshift(makeMockEvent(mostActiveFrame, ts));

  return trace;
}

function validatePasses(passes, audits, rootPath) {
  if (!Array.isArray(passes)) {
    return;
  }
  const requiredGatherers = getGatherersNeededByAudits(audits);

  // Log if we are running gathers that are not needed by the audits listed in the config
  passes.forEach(pass => {
    pass.gatherers.forEach(gatherer => {
      const GathererClass = GatherRunner.getGathererClass(gatherer, rootPath);
      const isGatherRequiredByAudits = requiredGatherers.has(GathererClass.name);
      if (isGatherRequiredByAudits === false) {
        const msg = `${GathererClass.name} gatherer requested, however no audit requires it.`;
        log.warn('config', msg);
      }
    });
  });

  // Log if multiple passes require trace or network recording and could overwrite one another.
  const usedNames = new Set();
  passes.forEach((pass, index) => {
    if (!pass.recordNetwork && !pass.recordTrace) {
      return;
    }

    const passName = pass.passName || Audit.DEFAULT_PASS;
    if (usedNames.has(passName)) {
      log.warn('config', `passes[${index}] may overwrite trace or network ` +
          `data of earlier pass without a unique passName (repeated name: ${passName}.`);
    }
    usedNames.add(passName);
  });
}

function getGatherersNeededByAudits(audits) {
  // It's possible we didn't get given any audits (but existing audit results), in which case
  // there is no need to do any work here.
  if (!audits) {
    return new Set();
  }

  return audits.reduce((list, audit) => {
    audit.meta.requiredArtifacts.forEach(artifact => list.add(artifact));
    return list;
  }, new Set());
}

function requireAudits(audits, configPath) {
  if (!audits) {
    return null;
  }
  const Runner = require('../runner');
  const coreList = Runner.getAuditList();

  return audits.map(nameOrAuditClass => {
    let AuditClass;
    if (typeof nameOrAuditClass === 'string') {
      const name = nameOrAuditClass;
      // See if the audit is a Lighthouse core audit.
      const coreAudit = coreList.find(a => a === `${name}.js`);
      let requirePath = `../audits/${name}`;
      if (!coreAudit) {
        // Otherwise, attempt to find it elsewhere. This throws if not found.
        requirePath = Runner.resolvePlugin(name, configPath, 'audit');
      }
      AuditClass = require(requirePath);
      assertValidAudit(AuditClass, name);
    } else {
      AuditClass = nameOrAuditClass;
      assertValidAudit(AuditClass);
    }

    return AuditClass;
  });
}

function assertValidAudit(auditDefinition, auditName) {
  auditName = auditName || (auditDefinition.meta && auditDefinition.meta.name) || 'audit';
  if (typeof auditDefinition.audit !== 'function') {
    throw new Error(`${auditName} has no audit() method.`);
  }

  if (typeof auditDefinition.meta.name !== 'string') {
    throw new Error(`${auditName} has no meta.name property, or the property is not a string.`);
  }

  if (typeof auditDefinition.meta.category !== 'string') {
    throw new Error(`${auditName} has no meta.category property, or the property is not a string.`);
  }

  if (typeof auditDefinition.meta.description !== 'string') {
    throw new Error(
      `${auditName} has no meta.description property, or the property is not a string.`
    );
  }

  if (!Array.isArray(auditDefinition.meta.requiredArtifacts)) {
    throw new Error(
      `${auditName} has no meta.requiredArtifacts property, or the property is not an array.`
    );
  }

  if (typeof auditDefinition.generateAuditResult !== 'function') {
    throw new Error(
      `${auditName} has no generateAuditResult() method. ` +
        'Did you inherit from the proper base class?'
    );
  }
}

function expandArtifacts(artifacts) {
  if (!artifacts) {
    return null;
  }
  // currently only trace logs and performance logs should be imported
  if (artifacts.traces) {
    Object.keys(artifacts.traces).forEach(key => {
      log.log('info', 'Normalizng trace contents into expected state...');
      let trace = require(artifacts.traces[key]);
      // Before Chrome 54.0.2816 (codereview.chromium.org/2161583004), trace was
      // an array of trace events. After this point, trace is an object with a
      // traceEvents property. Normalize to new format.
      if (Array.isArray(trace)) {
        trace = {
          traceEvents: trace
        };
      }
      trace = cleanTrace(trace);

      artifacts.traces[key] = trace;
    });
  }

  if (artifacts.performanceLog) {
    if (typeof artifacts.performanceLog === 'string') {
      // Support older format of a single performance log.
      const log = require(artifacts.performanceLog);
      artifacts.networkRecords = {
        [Audit.DEFAULT_PASS]: recordsFromLogs(log)
      };
    } else {
      artifacts.networkRecords = {};
      Object.keys(artifacts.performanceLog).forEach(key => {
        const log = require(artifacts.performanceLog[key]);
        artifacts.networkRecords[key] = recordsFromLogs(log);
      });
    }
  }

  return artifacts;
}

class Config {
  /**
   * @constructor
   * @param {!LighthouseConfig} configJSON
   * @param {string=} configPath The absolute path to the config file, if there is one.
   */
  constructor(configJSON, configPath) {
    if (!configJSON) {
      configJSON = defaultConfig;
      configPath = path.resolve(__dirname, defaultConfigPath);
    }

    if (configPath && !path.isAbsolute(configPath)) {
      throw new Error('configPath must be an absolute path.');
    }

    // We don't want to mutate the original config object
    const inputConfig = configJSON;
    configJSON = JSON.parse(JSON.stringify(inputConfig));
    // Copy arrays that could contain plugins to allow for programmatic
    // injection of plugins.
    if (Array.isArray(inputConfig.passes)) {
      configJSON.passes.forEach((pass, i) => {
        pass.gatherers = Array.from(inputConfig.passes[i].gatherers);
      });
    }
    if (Array.isArray(inputConfig.audits)) {
      configJSON.audits = Array.from(inputConfig.audits);
    }
    // Store the directory of the config path, if one was provided.
    this._configDir = configPath ? path.dirname(configPath) : undefined;

    this._passes = configJSON.passes || null;
    this._auditResults = configJSON.auditResults || null;
    if (this._auditResults && !Array.isArray(this._auditResults)) {
      throw new Error('config.auditResults must be an array');
    }

    this._aggregations = configJSON.aggregations || null;

    this._audits = requireAudits(configJSON.audits, this._configDir);
    this._artifacts = expandArtifacts(configJSON.artifacts);

    // validatePasses must follow after audits are required
    validatePasses(configJSON.passes, this._audits, this._configDir);
  }

  /** @type {string} */
  get configDir() {
    return this._configDir;
  }

  /** @type {Array<!Pass>} */
  get passes() {
    return this._passes;
  }

  /** @type {Array<!Audit>} */
  get audits() {
    return this._audits;
  }

  /** @type {Array<!AuditResult>} */
  get auditResults() {
    return this._auditResults;
  }

  /** @type {Array<!Artifacts>} */
  get artifacts() {
    return this._artifacts;
  }

  /** @type {Array<!Aggregation>} */
  get aggregations() {
    return this._aggregations;
  }
}

module.exports = Config;

}).call(this,"/../lighthouse-core/config")
},{"../audits/audit":"../audits/audit","../gather/gather-runner":16,"../lib/log":21,"../lib/network-recorder":23,"../runner":27,"./default.json":3,"path":198}],3:[function(require,module,exports){
module.exports={
  "passes": [{
    "recordNetwork": true,
    "recordTrace": true,
    "gatherers": [
      "url",
      "https",
      "viewport",
      "theme-color",
      "manifest",
      "accessibility",
      "content-width",
      "cache-contents",
      "geolocation-on-start"
    ]
  },
  {
    "passName": "offlinePass",
    "recordNetwork": true,
    "gatherers": [
      "service-worker",
      "offline"
    ]
  },
  {
    "gatherers": [
      "http-redirect",
      "html-without-javascript"
    ]
  }],

  "audits": [
    "is-on-https",
    "redirects-http",
    "service-worker",
    "works-offline",
    "viewport",
    "manifest-display",
    "without-javascript",
    "first-meaningful-paint",
    "speed-index-metric",
    "estimated-input-latency",
    "time-to-interactive",
    "user-timings",
    "screenshots",
    "critical-request-chains",
    "manifest-exists",
    "manifest-background-color",
    "manifest-theme-color",
    "manifest-icons-min-192",
    "manifest-icons-min-144",
    "manifest-name",
    "manifest-short-name",
    "manifest-short-name-length",
    "manifest-start-url",
    "meta-theme-color",
    "aria-valid-attr",
    "aria-allowed-attr",
    "color-contrast",
    "image-alt",
    "label",
    "tabindex",
    "content-width",
    "geolocation-on-start"
  ],

  "aggregations": [{
    "name": "Progressive Web App",
    "description": "These audits validate the aspects of a Progressive Web App.",
    "scored": true,
    "categorizable": true,
    "items": [{
      "name": "App can load on offline/flaky connections",
      "description": "Ensuring your web app can respond when the network connection is unavailable or flaky is critical to providing your users a good experience. This is achieved through use of a <a href=\"https://developers.google.com/web/fundamentals/primers/service-worker/\">Service Worker</a>.",
      "audits": {
        "service-worker": {
          "expectedValue": true,
          "weight": 1
        },
        "works-offline": {
          "expectedValue": true,
          "weight": 1
        },
        "cache-start-url": {
          "expectedValue": true,
          "weight": 1
        }
      }
    },{
      "name": "Page load performance is fast",
      "description": "Users notice if sites and apps don't perform well. These top-level metrics capture the most important perceived performance concerns.",
      "audits": {
        "first-meaningful-paint": {
          "expectedValue": 100,
          "weight": 1
        },
        "speed-index-metric": {
          "expectedValue": 100,
          "weight": 1
        },
        "estimated-input-latency": {
          "expectedValue": 100,
          "weight": 1
        },
        "time-to-interactive": {
          "expectedValue": 100,
          "weight": 1
        },
        "scrolling-60fps": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Content scrolls at 60fps",
          "category": "UX"
        },
        "touch-150ms": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Touch input gets a response in < 150ms",
          "category": "UX"
        },
        "fmp-no-jank": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "App is interactive without jank after the first meaningful paint",
          "category": "UX"
        }
      }
    }, {
      "name": "Site is progressively enhanced",
      "description": "Progressive enhancement means that everyone can access the basic content and functionality of a page in any browser, and those without certain browser features may receive a reduced but still functional experience.",
      "audits": {
        "without-javascript": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }, {
      "name": "Network connection is secure",
      "description": "Security is an important part of the web for both developers and users. Moving forward, Transport Layer Security (TLS) support will be required for many APIs.",
      "audits": {
        "is-on-https": {
          "expectedValue": true,
          "weight": 1
        },
        "redirects-http": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }, {
      "name": "User can be prompted to Add to Homescreen",
      "description": "While users can manually add your site to their homescreen in the browser menu, the <a href=\"https://developers.google.com/web/updates/2015/03/increasing-engagement-with-app-install-banners-in-chrome-for-android?hl=en\">prompt (aka app install banner)</a> will proactively prompt the user to install the app if the below requirements are met and the user has visited your site at least twice (with at least five minutes between visits).",
      "see": "https://github.com/GoogleChrome/lighthouse/issues/23",
      "audits": {
        "service-worker": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-exists": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-start-url": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-icons-min-144": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-short-name": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }, {
      "name": "Installed web app will launch with custom splash screen",
      "description": "A default splash screen will be constructed, but meeting these requirements guarantee a high-quality and customizable <a href=\"https://developers.google.com/web/updates/2015/10/splashscreen?hl=en\">splash screen</a> the user sees between tapping the home screen icon and your app’s first paint.",
      "see": "https://github.com/GoogleChrome/lighthouse/issues/24",
      "audits": {
        "manifest-exists": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-name": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-background-color": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-theme-color": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-icons-min-192": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }, {
      "name": "Address bar matches brand colors",
      "description": "The browser address bar can be themed to match your site. A theme-color <a href=\"https://developers.google.com/web/updates/2014/11/Support-for-theme-color-in-Chrome-39-for-Android\">meta tag</a> will upgrade the address bar when a user browses the site, and the <a href=\"https://developers.google.com/web/updates/2015/08/using-manifest-to-set-sitewide-theme-color\">manifest theme-color</a> will apply the same theme site-wide once it's been added to homescreen.",
      "audits": {
        "manifest-exists": {
          "expectedValue": true,
          "weight": 1
        },
        "theme-color-meta": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-theme-color": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }, {
      "name": "Design is mobile-friendly",
      "description": "Users increasingly experience your app on mobile devices, so it's important to ensure that the experience can adapt to smaller screens.",
      "audits": {
        "viewport": {
          "expectedValue": true,
          "weight": 1
        },
        "content-width": {
          "expectedValue": true,
          "weight": 1
        }
      }
    }]
  },{
    "name": "Best Practices",
    "description": "These audits do not affect your score but are worth a look.",
    "scored": false,
    "categorizable": false,
    "items": [{
      "audits": {
        "aria-allowed-attr": {
          "expectedValue": true,
          "weight": 1
        },
        "aria-valid-attr": {
          "expectedValue": true,
          "weight": 1
        },
        "color-contrast": {
          "expectedValue": true,
          "weight": 1
        },
        "image-alt": {
          "expectedValue": true,
          "weight": 1
        },
        "label": {
          "expectedValue": true,
          "weight": 1
        },
        "tabindex": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-short-name-length": {
          "expectedValue": true,
          "weight": 1
        },
        "manifest-display": {
          "expectedValue": true,
          "weight": 1
        },
        "geolocation-on-start": {
          "expectedValue": true,
          "weight": 1
        },
        "serviceworker-push": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Service worker makes use of push notifications, if appropriate",
          "category": "UX"
        },
        "tap-targets": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Tap targets are appropriately sized for touch",
          "category": "UX"
        },
        "payments-autocomplete": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Payment forms marked up with [autocomplete] attributes",
          "category": "UX"
        },
        "login-autocomplete": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Login forms marked up with [autocomplete] attributes",
          "category": "UX"
        },
        "input-type": {
          "expectedValue": true,
          "weight": 0,
          "comingSoon": true,
          "description": "Input fields use appropriate [type] attributes for custom keyboards",
          "category": "UX"
        }
      }
    }]
  },{
    "name": "Performance Metrics",
    "description": "These encapsulate your app's performance.",
    "scored": false,
    "categorizable": false,
    "items": [{
      "audits": {
        "critical-request-chains": {
          "expectedValue": 0,
          "weight": 1
        },
        "user-timings": {
          "expectedValue": 0,
          "weight": 1
        }
      }
    }]
  }]
}

},{}],4:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const path = require('path');

const Formatter = require('./formatter');
const html = "<style>\n.axe-violation {\n  color: #D0021B;\n}\n\n.axe-violation__help {\n  color: #76B530;\n}\n\n.axe-violation__help-minor,\n.axe-violation__help-moderate {\n  color: #F5A623;\n}\n\n.axe-violation__help-serious,\n.axe-violation__help--critical {\n  color: #D0021B;\n}\n</style>\n<div class=\"axe-violation\">\n  <details>\n    <summary>\n      <a class=\"axe-violation__help--{{ this.impact }}\" href=\"{{ this.helpUrl }}\" target=\"_blank\">{{ this.help }}</a>\n    </summary>\n    <ul>\n    {{#each this.nodes}}\n      <li><code>{{ this.target }}</code></li>\n    {{/each}}\n    </ul>\n  </details>\n</div>\n";

class Accessibilty extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return function(info) {
          if (info === null ||
              typeof info === 'undefined' ||
              typeof info.impact === 'undefined' ||
              typeof info.helpUrl === 'undefined' ||
              typeof info.nodes === 'undefined' ||
              !Array.isArray(info.nodes)) {
            return '';
          }

          const output = `      - Rating: ${info.impact}\n` +
          `      - See: ${info.helpUrl}\n` +
          `      - Nodes: ${info.nodes.length} nodes identified (see HTML output for details)\n`;
          return output;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }
}

module.exports = Accessibilty;

},{"./formatter":7,"path":198}],5:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const url = require('url');
const path = require('path');

const Formatter = require('./formatter');
const html = "<style>\n.tree-marker {\n  width: 12px;\n  height: 26px;\n  display: block;\n  float: left;\n  background-position: top left;\n}\n\n.horiz-down {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPmhvcml6LWRvd248L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0iaG9yaXotZG93biIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSg3LjAwMDAwMCwgMTMuMDAwMDAwKSByb3RhdGUoLTI3MC4wMDAwMDApIHRyYW5zbGF0ZSgtNy4wMDAwMDAsIC0xMy4wMDAwMDApICIgeD0iNiIgeT0iNCIgd2lkdGg9IjIiIGhlaWdodD0iMTgiPjwvcmVjdD4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzkiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDguMDAwMDAwLCAxOS4wMDAwMDApIHJvdGF0ZSgtMjcwLjAwMDAwMCkgdHJhbnNsYXRlKC04LjAwMDAwMCwgLTE5LjAwMDAwMCkgIiB4PSIxIiB5PSIxOCIgd2lkdGg9IjE0IiBoZWlnaHQ9IjIiPjwvcmVjdD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==');\n}\n\n.right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnJpZ2h0PC90aXRsZT4KICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPgogICAgPGRlZnM+PC9kZWZzPgogICAgPGcgaWQ9IlBhZ2UtMSIgc3Ryb2tlPSJub25lIiBzdHJva2Utd2lkdGg9IjEiIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+CiAgICAgICAgPGcgaWQ9InJpZ2h0IiBmaWxsPSIjRDhEOEQ4Ij4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzgiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDguMDAwMDAwLCAxMy4wMDAwMDApIHJvdGF0ZSgtMjcwLjAwMDAwMCkgdHJhbnNsYXRlKC04LjAwMDAwMCwgLTEzLjAwMDAwMCkgIiB4PSI3IiB5PSI1IiB3aWR0aD0iMiIgaGVpZ2h0PSIxNiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.up-right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnVwLXJpZ2h0PC90aXRsZT4KICAgIDxkZXNjPkNyZWF0ZWQgd2l0aCBTa2V0Y2guPC9kZXNjPgogICAgPGRlZnM+PC9kZWZzPgogICAgPGcgaWQ9IlBhZ2UtMSIgc3Ryb2tlPSJub25lIiBzdHJva2Utd2lkdGg9IjEiIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+CiAgICAgICAgPGcgaWQ9InVwLXJpZ2h0IiBmaWxsPSIjRDhEOEQ4Ij4KICAgICAgICAgICAgPHJlY3QgaWQ9IlJlY3RhbmdsZS0xMzgiIHg9IjciIHk9IjAiIHdpZHRoPSIyIiBoZWlnaHQ9IjE0Ij48L3JlY3Q+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM5IiB4PSI5IiB5PSIxMiIgd2lkdGg9IjciIGhlaWdodD0iMiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.vert-right {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnZlcnQtcmlnaHQ8L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0idmVydC1yaWdodCIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB4PSI3IiB5PSIwIiB3aWR0aD0iMiIgaGVpZ2h0PSIyNyI+PC9yZWN0PgogICAgICAgICAgICA8cmVjdCBpZD0iUmVjdGFuZ2xlLTEzOSIgeD0iOSIgeT0iMTIiIHdpZHRoPSI3IiBoZWlnaHQ9IjIiPjwvcmVjdD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==');\n}\n\n.vert {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMjZweCIgdmlld0JveD0iMCAwIDE2IDI2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPnZlcnQ8L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0idmVydCIgZmlsbD0iI0Q4RDhEOCI+CiAgICAgICAgICAgIDxyZWN0IGlkPSJSZWN0YW5nbGUtMTM4IiB4PSI3IiB5PSIwIiB3aWR0aD0iMiIgaGVpZ2h0PSIyNiI+PC9yZWN0PgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+');\n}\n\n.space {\n  background: url('data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE2cHgiIGhlaWdodD0iMTZweCIgdmlld0JveD0iMCAwIDE2IDE2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCAzLjcuMiAoMjgyNzYpIC0gaHR0cDovL3d3dy5ib2hlbWlhbmNvZGluZy5jb20vc2tldGNoIC0tPgogICAgPHRpdGxlPmhvcml6LWRvd248L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0iaG9yaXotZG93biI+PC9nPgogICAgPC9nPgo8L3N2Zz4=');\n}\n\n.cnc-tree {\n  font-size: 14px;\n  width: 100%;\n  overflow-x: auto;\n}\n\n.cnc-node {\n  height: 26px;\n  line-height: 26px;\n  white-space: nowrap;\n}\n\n.cnc-node__tree-value {\n  margin-left: 10px;\n}\n\n.cnc-node__chain-duration {\n  font-weight: bold;\n}\n\n.cnc-node__tree-hostname {\n  color: #999;\n}\n\n</style>\n\n{{#*inline \"writeNode\"}}\n  <div class=\"cnc-node\" title=\"{{ @key }}\">\n    <span class=\"cnc-node__tree-marker\">\n    {{#each treeMarkers as |separator| }}\n      {{#separator}}\n      <span class=\"tree-marker vert\"></span>\n      <span class=\"tree-marker space\"></span>\n      {{else}}\n      <span class=\"tree-marker space\"></span>\n      <span class=\"tree-marker space\"></span>\n      {{/separator}}\n    {{/each}}\n    {{#isLastChild}}\n      <span class=\"tree-marker up-right\"></span>\n      <span class=\"tree-marker right\"></span>\n    {{else}}\n      <span class=\"tree-marker vert-right\"></span>\n      <span class=\"tree-marker right\"></span>\n    {{/isLastChild}}\n\n    {{#hasChildren}}\n      <span class=\"tree-marker horiz-down\"></span>\n    {{else}}\n      <span class=\"tree-marker right\"></span>\n    {{/hasChildren}}\n    </span>\n\n    <span class=\"cnc-node__tree-value\">\n      {{#parseURL this.node.request.url }}\n        <span class=\"cnc-node__tree-file\">{{ this.file }}</span>\n        <span class=\"cnc-node__tree-hostname\">({{ this.hostname }})</span>\n      {{/parseURL}}\n      {{#unless hasChildren}}\n        - <span class=\"cnc-node__chain-duration\">{{chainDuration startTime this.node.request.endTime }}ms, {{formatTransferSize this.transferSize}}KB</span>\n      {{/unless}}\n    </span>\n  </div>\n\n  {{#each this.node.children as |child| }}\n    {{#createContextFor ../node.children @key ../treeMarkers ../isLastChild ../startTime ../transferSize }}\n      {{> writeNode this }}\n    {{/createContextFor }}\n  {{/each}}\n{{/inline}}\n\n<div class=\"cnc-tree\">\n  <div>Longest request chain (shorter is better): <strong>{{longestChain this}}</strong></div>\n  <div>Longest chain duration (shorter is better): <strong>{{formatTime (longestDuration this)}}ms</strong></div>\n  <div>Longest chain transfer size (smaller is better): <strong>{{formatTransferSize (longestChainTransferSize this)}}KB</strong></div>\n  <div>\n    <div>Initial navigation</div>\n    {{#createTreeRenderContext this}}\n      {{#each this.tree }}\n        {{#createContextFor ../tree @key undefined undefined ../startTime ../transferSize }}\n          {{> writeNode this }}\n        {{/createContextFor}}\n      {{/each}}\n    {{/createTreeRenderContext}}\n  </div>\n</div>\n";

class CriticalRequestChains extends Formatter {

  /**
   * gets the formatter for the CLI Printer and the HTML report.
   */
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return function(info) {
          if (info === null ||
              typeof info === 'undefined') {
            return '';
          }

          const longestChain = CriticalRequestChains._getLongestChainLength(info);
          const longestDuration =
              CriticalRequestChains._getLongestChainDuration(info).toFixed(2);
          const longestTransferSize = CriticalRequestChains.formatTransferSize(
              CriticalRequestChains._getLongestChainTransferSize(info));
          const urlTree = CriticalRequestChains._createURLTreeOutput(info);

          const output = `    - Longest request chain (shorter is better): ${longestChain}\n` +
          `    - Longest chain duration (shorter is better): ${longestDuration}ms\n` +
          `    - Longest chain transfer size (smaller is better): ${longestTransferSize}KB\n` +
          '    - Initial navigation\n' +
              '      ' + urlTree.replace(/\n/g, '\n      ') + '\n';
          return output;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }

  static _traverse(tree, cb) {
    function walk(node, depth, startTime, transferSize) {
      const children = Object.keys(node);
      if (children.length === 0) {
        return;
      }

      if (!transferSize) {
        transferSize = 0;
      }

      children.forEach(id => {
        const child = node[id];
        if (!startTime) {
          startTime = child.request.startTime;
        }

        // Call the callback with the info for this child.
        cb({
          depth,
          id,
          node: child,
          chainDuration: (child.request.endTime - startTime) * 1000,
          chainTransferSize: (transferSize + child.request.transferSize)
        });

        // Carry on walking.
        walk(child.children, depth + 1, startTime);
      }, '');
    }

    walk(tree, 0);
  }

  static _getLongestChainLength(tree) {
    let longestChain = 0;
    this._traverse(tree, opts => {
      const depth = opts.depth;
      if (depth > longestChain) {
        longestChain = depth;
      }
    });

    // Always return the longest chain + 1 because the depth is zero indexed.
    return (longestChain + 1);
  }

  static _getLongestChainDuration(tree) {
    let longestChainDuration = 0;
    this._traverse(tree, opts => {
      const duration = opts.chainDuration;
      if (duration > longestChainDuration) {
        longestChainDuration = duration;
      }
    });
    return longestChainDuration;
  }

  static _getLongestChainTransferSize(tree) {
    let transferSize = 0;
    this._traverse(tree, opts => {
      const chainTransferSize = opts.chainTransferSize;
      if (chainTransferSize > transferSize) {
        transferSize = chainTransferSize;
      }
    });
    return transferSize;
  }

  /**
   * Converts the tree into an ASCII tree.
   */
  static _createURLTreeOutput(tree) {
    function write(opts) {
      const node = opts.node;
      const depth = opts.depth;
      const treeMarkers = opts.treeMarkers;
      let startTime = opts.startTime;
      const transferSize = opts.transferSize;

      return Object.keys(node).reduce((output, id, currentIndex, arr) => {
        // Test if this node has children, and if it's the last child.
        const hasChildren = (Object.keys(node[id].children).length > 0);
        const isLastChild = (currentIndex === arr.length - 1);

        // If the parent is the last child then don't drop the vertical bar.
        const ancestorTreeMarker = treeMarkers.reduce((markers, marker) => {
          return markers + (marker ? '┃ ' : '  ');
        }, '');

        // Copy the tree markers so that we don't change by reference.
        const newTreeMakers = treeMarkers.slice(0);

        // Add on the new entry.
        newTreeMakers.push(!isLastChild);

        // Create the appropriate tree marker based on the depth of this
        // node as well as whether or not it has children and is itself the last child.
        const treeMarker = ancestorTreeMarker +
            (isLastChild ? '┗━' : '┣━') +
            (hasChildren ? '┳' : '━');

        const parsedURL = CriticalRequestChains.parseURL(node[id].request.url);

        if (!startTime) {
          startTime = node[id].request.startTime;
        }

        const duration = ((node[id].request.endTime - startTime) * 1000).toFixed(2);
        const chainTransferSize = transferSize + node[id].request.transferSize;
        const formattedTransferSize = CriticalRequestChains.formatTransferSize(chainTransferSize);

        // Return the previous output plus this new node, and recursively write its children.
        return output + `${treeMarker} ${parsedURL.file} (${parsedURL.hostname})` +
            // If this node has children, write them out. Othewise write the chain time.
            (hasChildren ? '' : ` - ${duration}ms, ${formattedTransferSize}KB`) + '\n' +
            write({
              node: node[id].children,
              depth: depth + 1,
              treeMarkers: newTreeMakers,
              startTime,
              transferSize: chainTransferSize
            });
      }, '');
    }

    return write({
      node: tree,
      depth: 0,
      treeMarkers: [],
      startTime: 0,
      transferSize: 0
    });
  }

  static formatTime(time) {
    return time.toFixed(2);
  }

  static formatTransferSize(size) {
    return (size / 1024).toFixed(2);
  }

  static parseURL(resourceURL, opts) {
    const MAX_FILENAME_LENGTH = 64;
    const parsedResourceURL = url.parse(resourceURL);
    const hostname = parsedResourceURL.hostname;
    // Handle 'about:*' URLs specially since they have no path.
    let file = parsedResourceURL.protocol === 'about:' ? parsedResourceURL.href :
        // Otherwise, remove any query strings from the path.
        parsedResourceURL.path.replace(/\?.*/, '')
        // And grab the last two parts.
        .split('/').slice(-2).join('/');

    if (file.length > MAX_FILENAME_LENGTH) {
      file = file.slice(0, MAX_FILENAME_LENGTH) + '...';
    }

    const parsedURL = {
      file,
      hostname
    };

    // If we get passed the opts parameter, this is Handlebars, so we
    // need to return the object back via the opts.fn so it becomes the context.
    if (opts) {
      return opts.fn(parsedURL);
    }

    return parsedURL;
  }

  static getHelpers() {
    return {
      longestChain(info) {
        return CriticalRequestChains._getLongestChainLength(info);
      },

      longestDuration(info) {
        return CriticalRequestChains._getLongestChainDuration(info);
      },

      longestChainTransferSize(info) {
        return CriticalRequestChains._getLongestChainTransferSize(info);
      },

      chainDuration(startTime, endTime) {
        return ((endTime - startTime) * 1000).toFixed(2);
      },

      formatTransferSize: CriticalRequestChains.formatTransferSize,

      parseURL: CriticalRequestChains.parseURL,

      formatTime: CriticalRequestChains.formatTime,

      /**
       * Helper function for Handlebars that creates the context for each node
       * based on its parent. Calculates if this node is the last child, whether
       * it has any children itself and what the tree looks like all the way back
       * up to the root, so the tree markers can be drawn correctly.
       */
      createContextFor(parent, id, treeMarkers, parentIsLastChild, startTime, transferSize, opts) {
        const node = parent[id];
        const siblings = Object.keys(parent);
        const isLastChild = siblings.indexOf(id) === (siblings.length - 1);
        const hasChildren = Object.keys(node.children).length > 0;

        // Copy the tree markers so that we don't change by reference.
        const newTreeMarkers = Array.isArray(treeMarkers) ? treeMarkers.slice(0) : [];

        // Add on the new entry.
        if (typeof parentIsLastChild !== 'undefined') {
          newTreeMarkers.push(!parentIsLastChild);
        }

        return opts.fn({
          node,
          isLastChild,
          hasChildren,
          startTime,
          transferSize: (transferSize + node.request.transferSize),
          treeMarkers: newTreeMarkers
        });
      },

      createTreeRenderContext(tree, opts) {
        const transferSize = 0;
        let startTime = 0;
        const rootNodes = Object.keys(tree);

        if (rootNodes.length > 0) {
          startTime = tree[rootNodes[0]].request.startTime;
        }

        return opts.fn({
          tree,
          startTime,
          transferSize
        });
      }
    };
  }
}

module.exports = CriticalRequestChains;

},{"./formatter":7,"path":198,"url":204}],6:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Formatter = require('./formatter');
const path = require('path');

const html = "<style>\n  .input-latency-measures {\n    font-size: 14px\n  }\n</style>\n\n<div>\n  <div class=\"input-latency-measures\">\n    <div>90% probability of input latency at <strong>{{ninetiethTime this}}ms</strong> or shorter.<div>\n    <div>\n      ({{#each this}}{{percentile this.percentile}}%: {{fixedTenths this.time}}ms{{#unless @last}}, {{/unless}}{{/each}})\n    </div>\n  </div>\n</div>\n";

class EstimatedInputLatencyFormatter extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return function(percentiles) {
          if (!percentiles || !Array.isArray(percentiles)) {
            return '';
          }

          const ninetieth = percentiles.find(result => result.percentile === 0.9);
          const time = ninetieth.time.toFixed(1);
          const allResults = percentiles.map(result => {
            const percentile = Math.round(result.percentile * 100);
            const time = result.time.toFixed(1);
            return `${percentile}%: ${time}ms`;
          }).join(', ');

          const output = `    - 90% probability of input latency at ${time}ms or shorter.\n` +
              `      (${allResults})\n`;

          return output;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }

  static getHelpers() {
    return {
      ninetiethTime(percentiles) {
        if (!Array.isArray(percentiles)) {
          return;
        }

        const ninetieth = percentiles.find(result => result.percentile === 0.9);
        return ninetieth.time.toFixed(1);
      },
      percentile(value) {
        return Math.round(value * 100);
      },
      fixedTenths(value) {
        return value.toFixed(1);
      }
    };
  }
}

module.exports = EstimatedInputLatencyFormatter;

},{"./formatter":7,"path":198}],7:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

class Formatter {

  static get CAPITAL_LETTERS() {
    return /([A-Z])/g;
  }

  static get SUPPORTED_FORMATS() {
    // Get the available formatters if they don't already exist.
    if (!this._formatters) {
      this._getFormatters();
    }

    // From the formatters we can establish a master list of supported format names.
    if (!this._supportedFormatsNames) {
      this._generateSupportedFormats();
    }

    return this._supportedFormatsNames;
  }

  static _getFormatters() {
    this._formatters = {
      accessibility: require('./accessibility'),
      criticalRequestChains: require('./critical-request-chains'),
      estimatedInputLatency: require('./estimated-input-latency'),
      urllist: require('./url-list'),
      null: require('./null-formatter'),
      speedline: require('./speedline-formatter'),
      userTimings: require('./user-timings')
    };
  }

  static _generateSupportedFormats() {
    const formatNames = Object.keys(this._formatters);
    this._supportedFormatsNames = formatNames.reduce((prev, format) => {
      // Reformulates names like criticalNetworkChains to CRITICAL_NETWORK_CHAINS so they appear
      // like a bunch of constants.
      const formatName = format.replace(Formatter.CAPITAL_LETTERS, '_$1').toUpperCase();
      prev[formatName] = format;
      return prev;
    }, {});
  }

  static getByName(name) {
    if (!this._formatters) {
      this._getFormatters();
    }

    if (!this._formatters[name]) {
      throw new Error(`Unknown formatter: ${name}`);
    }

    return this._formatters[name];
  }

  static getFormatter() {
    throw new Error('Formatter must implement getPrettyFormatter()');
  }

  /**
   * Optional function to get any Handlebars helpers this formatter expects to need.
   */
  static getHelpers() {}
}

module.exports = Formatter;

},{"./accessibility":4,"./critical-request-chains":5,"./estimated-input-latency":6,"./null-formatter":8,"./speedline-formatter":9,"./url-list":10,"./user-timings":11}],8:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Formatter = require('./formatter');

class NullFormatter extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return _ => '';

      case 'html':
        return '';

      default:
        throw new Error('Unknown formatter type');
    }
  }
}

module.exports = NullFormatter;

},{"./formatter":7}],9:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Formatter = require('./formatter');
const path = require('path');

const html = "<style>\n  .speedline-measures {\n    font-size: 14px\n  }\n</style>\n\n<div>\n  <div class=\"speedline-measures\">\n    <div>First Visual Change: <strong>{{this.first}}ms</strong></div>\n    <div>Last Visual Change: <strong>{{this.complete}}ms</strong></div>\n  </div>\n</div>\n";

class SpeedlineFormatter extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return function(info) {
          if (!info || !Array.isArray(info.frames)) {
            return '';
          }

          const output = `    - First Visual Change: ${info.first}ms\n` +
          `    - Last Visual Change: ${info.complete}ms\n`;

          return output;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }
}

module.exports = SpeedlineFormatter;

},{"./formatter":7,"path":198}],10:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Formatter = require('./formatter');
const path = require('path');

const html = "<style>\n  .http-resources {\n    font-size: 14px;\n  }\n  .http-resource__url {\n    margin-right: 8px;\n  }\n  .http-resource__protocol,\n  .http-resource__code {\n    color: #999;\n  }\n</style>\n\n<div>\n  <details class=\"http-resources\">\n    <summary>URLs</summary>\n    {{#each this}}\n      <div class=\"http-resource\">\n        <span class=\"http-resource__url\">{{this.url}}</span>\n        {{#if this.label}}\n          <span class=\"http-resource__protocol\">({{this.label}})</span>\n        {{/if}}\n        {{#if this.code}}\n          <pre class=\"http-resource__code\">{{this.code}}</pre>\n        {{/if}}\n      </div>\n    {{/each}}\n  </details>\n</div>\n";

class UrlList extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return resources => {
          if (!Array.isArray(resources)) {
            return '';
          }

          let output = '';
          resources.forEach(resource => {
            output += `      ${resource.url}`;
            if (resource.label) {
              output += ` (${resource.label})`;
            }
            output += '\n';
          });
          return output;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }
}

module.exports = UrlList;

},{"./formatter":7,"path":198}],11:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const Formatter = require('./formatter');
const path = require('path');

const html = "<style>\n  .ut-measures {\n    font-size: 14px\n  }\n\n  .ut-measure_listing-duration {\n    font-weight: bold\n  }\n</style>\n\n<div>\n  <div class=\"ut-measures\">\n    {{#each this}}\n      <div>\n        {{#if this.isMark}}\n          <span class=\"ut-measure_listing-duration\">Mark: {{ decimal this.startTime }}ms</span> - {{ this.name }}\n        {{else}}\n          <span class=\"ut-measure_listing-duration\">Measure {{ decimal this.duration }}ms</span> - {{ this.name }}\n        {{/if}}\n      </div>\n    {{/each}}\n  </div>\n</div>\n";

class UserTimings extends Formatter {
  static getFormatter(type) {
    switch (type) {
      case 'pretty':
        return events => {
          if (!Array.isArray(events)) {
            return '';
          }

          const measuresStr = events.filter(e => !e.isMark).reduce((prev, event) => {
            let output = prev + `    - measure ${event.name}: \t`;
            output += `duration: ${event.duration.toFixed(1)}ms,\t`;
            output += `start: ${event.startTime.toFixed(1)}ms,\tend: ${event.endTime.toFixed(1)}`;
            return output + '\n';
          }, '');
          const marksStr = events.filter(e => e.isMark).reduce((prev, event) => {
            return prev + `    - mark ${event.name}: \t time: ${event.startTime.toFixed(1)}ms\n`;
          }, '');
          return measuresStr + marksStr;
        };

      case 'html':
        // Returns a handlebars string to be used by the Report.
        return html;

      default:
        throw new Error('Unknown formatter type');
    }
  }
}

module.exports = UserTimings;

},{"./formatter":7,"path":198}],12:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const EventEmitter = require('events').EventEmitter;
const log = require('../../lib/log.js');

class Connection {

  constructor() {
    this._lastCommandId = 0;
    /** @type {!Map<number, {resolve: function(*), reject: function(*), method: string}>}*/
    this._callbacks = new Map();
    this._eventEmitter = new EventEmitter();
  }

  /**
   * @return {!Promise}
   */
  connect() {
    return Promise.reject(new Error('Not implemented'));
  }

  /**
   * @return {!Promise}
   */
  disconnect() {
    return Promise.reject(new Error('Not implemented'));
  }

  /**
   * Call protocol methods
   * @param {!string} method
   * @param {!Object} params
   * @return {!Promise}
   */
  sendCommand(method, params) {
    log.formatProtocol('method => browser', {method, params}, 'verbose');
    const id = ++this._lastCommandId;
    params = params || {};
    const message = JSON.stringify({id, method, params});
    this.sendRawMessage(message);
    return new Promise((resolve, reject) => {
      this._callbacks.set(id, {resolve, reject, method});
    });
  }

  /**
   * Bind listeners for connection events
   * @param {!string} eventName
   * @param {function(...)} cb
   */
  on(eventName, cb) {
    if (eventName !== 'notification') {
      throw new Error('Only supports "notification" events');
    }
    this._eventEmitter.on(eventName, cb);
  }

  /* eslint-disable no-unused-vars */

  /**
   * @param {string} message
   * @protected
   */
  sendRawMessage(message) {
    return Promise.reject(new Error('Not implemented'));
  }

  /* eslint-enable no-unused-vars */

  /**
   * @param {string} message
   * @protected
   */
  handleRawMessage(message) {
    const object = JSON.parse(message);
    // Remote debugging protocol is JSON RPC 2.0 compiant. In terms of that transport,
    // responses to the commands carry "id" property, while notifications do not.
    if (object.id) {
      const callback = this._callbacks.get(object.id);
      this._callbacks.delete(object.id);
      if (object.error) {
        log.formatProtocol('method <= browser ERR',
            {method: callback.method, params: object.result}, 'error');
        callback.reject(object.result);
        return;
      }
      log.formatProtocol('method <= browser OK',
          {method: callback.method, params: object.result}, 'verbose');
      callback.resolve(object.result);
      return;
    }
    log.formatProtocol('method <= browser EVENT',
        {method: object.method, params: object.result}, 'verbose');
    this.emitNotification(object.method, object.params);
  }

  /**
   * @param {!string} command
   * @param {!Object} params
   * @protected
   */
  emitNotification(method, params) {
    this._eventEmitter.emit('notification', {method, params});
  }

  /**
   * @protected
   */
  dispose() {
    this._eventEmitter.removeAllListeners();
    this._eventEmitter = null;
  }
}

module.exports = Connection;

},{"../../lib/log.js":21,"events":195}],13:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const NetworkRecorder = require('../../lib/network-recorder');
const emulation = require('../../lib/emulation');
const Element = require('../../lib/element');
const EventEmitter = require('events').EventEmitter;
const parseURL = require('url').parse;

const log = require('../../lib/log.js');

const MAX_WAIT_FOR_FULLY_LOADED = 25 * 1000;
const PAUSE_AFTER_LOAD = 500;

class Driver {

  /**
   * @param {!Connection} connection
   */
  constructor(connection) {
    this._traceEvents = [];
    this._traceCategories = Driver.traceCategories;
    this._eventEmitter = new EventEmitter();
    this._connection = connection;
    connection.on('notification', event => this._eventEmitter.emit(event.method, event.params));
  }

  static get traceCategories() {
    return [
      '-*', // exclude default
      'toplevel',
      'blink.console',
      'blink.user_timing',
      'benchmark',
      'netlog',
      'devtools.timeline',
      'disabled-by-default-blink.debug.layout',
      'disabled-by-default-devtools.timeline',
      'disabled-by-default-devtools.timeline.frame',
      'disabled-by-default-devtools.timeline.stack',
      // 'disabled-by-default-v8.cpu_profile',  // these would include JS stack samples, but
      // 'disabled-by-default-v8.cpu_profile.hires', // will take the trace from 5MB -> 100MB
      'disabled-by-default-devtools.screenshot'
    ];
  }

  /**
   * @return {!Promise<null>}
   */
  connect() {
    return this._connection.connect();
  }

  disconnect() {
    return this._connection.disconnect();
  }

  /**
   * Bind listeners for protocol events
   * @param {!string} eventName
   * @param {function(...)} cb
   */
  on(eventName, cb) {
    if (this._eventEmitter === null) {
      throw new Error('connect() must be called before attempting to listen to events.');
    }

    // log event listeners being bound
    log.formatProtocol('listen for event =>', {method: eventName}, 'verbose');
    this._eventEmitter.on(eventName, cb);
  }

  /**
   * Bind a one-time listener for protocol events. Listener is removed once it
   * has been called.
   * @param {!string} eventName
   * @param {function(...)} cb
   */
  once(eventName, cb) {
    if (this._eventEmitter === null) {
      throw new Error('connect() must be called before attempting to listen to events.');
    }
    // log event listeners being bound
    log.formatProtocol('listen once for event =>', {method: eventName}, 'verbose');
    this._eventEmitter.once(eventName, cb);
  }

  /**
   * Unbind event listeners
   * @param {!string} eventName
   * @param {function(...)} cb
   */
  off(eventName, cb) {
    if (this._eventEmitter === null) {
      throw new Error('connect() must be called before attempting to remove an event listener.');
    }

    this._eventEmitter.removeListener(eventName, cb);
  }

  /**
   * Call protocol methods
   * @param {!string} method
   * @param {!Object} params
   * @return {!Promise}
   */
  sendCommand(method, params) {
    return this._connection.sendCommand(method, params);
  }

  evaluateScriptOnLoad(scriptSource) {
    return this.sendCommand('Page.addScriptToEvaluateOnLoad', {
      scriptSource
    });
  }

  /**
   * Evaluate an expression in the context of the current page. Expression must
   * evaluate to a Promise. Returns a promise that resolves on asyncExpression's
   * resolved value.
   * @param {string} asyncExpression
   * @return {!Promise<*>}
   */
  evaluateAsync(asyncExpression) {
    return new Promise((resolve, reject) => {
      // If this gets to 60s and it hasn't been resolved, reject the Promise.
      const asyncTimeout = setTimeout(
        (_ => reject(new Error('The asynchronous expression exceeded the allotted time of 60s'))),
        60000
      );
      this.sendCommand('Runtime.evaluate', {
        expression: asyncExpression,
        includeCommandLineAPI: true,
        awaitPromise: true,
        returnByValue: true
      }).then(result => {
        clearTimeout(asyncTimeout);
        resolve(result.result.value);
      }).catch(reject);
    });
  }

  getSecurityState() {
    return new Promise((resolve, reject) => {
      this.once('Security.securityStateChanged', data => {
        this.sendCommand('Security.disable')
          .then(_ => resolve(data), reject);
      });

      this.sendCommand('Security.enable').catch(reject);
    });
  }

  getServiceWorkerVersions() {
    return new Promise((resolve, reject) => {
      this.once('ServiceWorker.workerVersionUpdated', data => {
        this.sendCommand('ServiceWorker.disable')
          .then(_ => resolve(data), reject);
      });

      this.sendCommand('ServiceWorker.enable').catch(reject);
    });
  }

  /**
   * If our main document URL redirects, we will update options.url accordingly
   * As such, options.url will always represent the post-redirected URL.
   * options.initialUrl is the pre-redirect URL that things started with
   */
  enableUrlUpdateIfRedirected(opts) {
    this._networkRecorder.on('requestloaded', redirectRequest => {
      // Quit if this is not a redirected request
      if (!redirectRequest.redirectSource) {
        return;
      }
      const earlierRequest = redirectRequest.redirectSource;
      if (earlierRequest.url === opts.url) {
        opts.url = redirectRequest.url;
      }
    });
  }

  /**
   * Returns a promise that resolves when the network has been idle for
   * `pauseAfterLoadMs` ms and a method to cancel internal network listeners and
   * timeout.
   * @param {string} pauseAfterLoadMs
   * @return {{promise: !Promise, cancel: function()}}
   * @private
   */
  _waitForNetworkIdle(pauseAfterLoadMs) {
    let idleTimeout;
    let cancel;

    const promise = new Promise((resolve, reject) => {
      const onIdle = () => {
        // eslint-disable-next-line no-use-before-define
        this._networkRecorder.once('networkbusy', onBusy);
        idleTimeout = setTimeout(_ => {
          cancel();
          resolve();
        }, pauseAfterLoadMs);
      };

      const onBusy = () => {
        this._networkRecorder.once('networkidle', onIdle);
        clearTimeout(idleTimeout);
      };

      cancel = () => {
        clearTimeout(idleTimeout);
        this._networkRecorder.removeListener('networkbusy', onBusy);
        this._networkRecorder.removeListener('networkidle', onIdle);
      };

      if (this._networkRecorder.isIdle()) {
        onIdle();
      } else {
        onBusy();
      }
    });

    return {
      promise,
      cancel
    };
  }

  /**
   * Return a promise that resolves `pauseAfterLoadMs` after the load event
   * fires and a method to cancel internal listeners and timeout.
   * @param {number} pauseAfterLoadMs
   * @return {{promise: !Promise, cancel: function()}}
   * @private
   */
  _waitForLoadEvent(pauseAfterLoadMs) {
    let loadListener;
    let loadTimeout;

    const promise = new Promise((resolve, reject) => {
      loadListener = function() {
        loadTimeout = setTimeout(resolve, pauseAfterLoadMs);
      };
      this.once('Page.loadEventFired', loadListener);
    });
    const cancel = () => {
      this.off('Page.loadEventFired', loadListener);
      clearTimeout(loadTimeout);
    };

    return {
      promise,
      cancel
    };
  }

  /**
   * Returns a promise that resolves when:
   * - it's been pauseAfterLoadMs milliseconds after both onload and the network
   * has gone idle, or
   * - MAX_WAIT_FOR_FULLY_LOADED milliseconds have passed.
   * See https://github.com/GoogleChrome/lighthouse/issues/627 for more.
   * @param {number} pauseAfterLoadMs
   * @return {!Promise}
   * @private
   */
  _waitForFullyLoaded(pauseAfterLoadMs) {
    let maxTimeoutHandle;

    // Listener for onload. Resolves pauseAfterLoadMs ms after load.
    const waitForLoadEvent = this._waitForLoadEvent(pauseAfterLoadMs);
    // Network listener. Resolves when the network has been idle for pauseAfterLoadMs.
    const waitForNetworkIdle = this._waitForNetworkIdle(pauseAfterLoadMs);

    // Wait for both load promises. Resolves on cleanup function the clears load
    // timeout timer.
    const loadPromise = Promise.all([
      waitForLoadEvent.promise,
      waitForNetworkIdle.promise
    ]).then(_ => {
      return function() {
        log.verbose('Driver', 'loadEventFired and network considered idle');
        clearTimeout(maxTimeoutHandle);
      };
    });

    // Last resort timeout. Resolves MAX_WAIT_FOR_FULLY_LOADED ms from now on
    // cleanup function that removes loadEvent and network idle listeners.
    const maxTimeoutPromise = new Promise((resolve, reject) => {
      maxTimeoutHandle = setTimeout(resolve, MAX_WAIT_FOR_FULLY_LOADED);
    }).then(_ => {
      return function() {
        log.warn('Driver', 'Timed out waiting for page load. Moving on...');
        waitForLoadEvent.cancel();
        waitForNetworkIdle.cancel();
      };
    });

    // Wait for load or timeout and run the cleanup function the winner returns.
    return Promise.race([
      loadPromise,
      maxTimeoutPromise
    ]).then(cleanup => cleanup());
  }

  /**
   * Navigate to the given URL. Use of this method directly isn't advised: if
   * the current page is already at the given URL, navigation will not occur and
   * so the returned promise will only resolve after the MAX_WAIT_FOR_FULLY_LOADED
   * timeout. See https://github.com/GoogleChrome/lighthouse/pull/185 for one
   * possible workaround.
   * @param {string} url
   * @param {!Object} options
   * @return {!Promise}
   */
  gotoURL(url, options) {
    const _options = options || {};
    const waitForLoad = _options.waitForLoad || false;
    const disableJS = _options.disableJavaScript || false;
    const pauseAfterLoadMs = (_options.flags && _options.flags.pauseAfterLoad) || PAUSE_AFTER_LOAD;

    return this.sendCommand('Page.enable')
      .then(_ => this.sendCommand('Emulation.setScriptExecutionDisabled', {value: disableJS}))
      .then(_ => this.sendCommand('Page.navigate', {url}))
      .then(_ => waitForLoad && this._waitForFullyLoaded(pauseAfterLoadMs));
  }

  reloadForCleanStateIfNeeded() {
    return Promise.resolve();
  }

  /**
   * @param {string} selector Selector to find in the DOM
   * @return {!Promise<Element>} The found element, or null, resolved in a promise
   */
  querySelector(selector) {
    return this.sendCommand('DOM.getDocument')
      .then(result => result.root.nodeId)
      .then(nodeId => this.sendCommand('DOM.querySelector', {
        nodeId,
        selector
      }))
      .then(element => {
        if (element.nodeId === 0) {
          return null;
        }
        return new Element(element, this);
      });
  }

  beginTrace() {
    const tracingOpts = {
      categories: this._traceCategories.join(','),
      transferMode: 'ReturnAsStream',
      options: 'sampling-frequency=10000'  // 1000 is default and too slow.
    };

    return this.sendCommand('Page.enable')
      .then(_ => this.sendCommand('Tracing.start', tracingOpts));
  }

  endTrace() {
    return new Promise((resolve, reject) => {
      // When the tracing has ended this will fire with a stream handle.
      this.once('Tracing.tracingComplete', streamHandle => {
        this._readTraceFromStream(streamHandle)
            .then(traceContents => resolve(traceContents), reject);
      });

      // Issue the command to stop tracing.
      this.sendCommand('Tracing.end').catch(reject);
    });
  }

  _readTraceFromStream(streamHandle) {
    return new Promise((resolve, reject) => {
      // COMPAT: We've found `result` not retaining its value in this scenario when it's
      // declared with `let`. Observed in Chrome 50 and 52. While investigating the V8 bug
      // further, we'll use a plain `var` declaration.
      var isEOF = false;
      var result = '';

      const readArguments = {
        handle: streamHandle.stream
      };

      const onChunkRead = response => {
        if (isEOF) {
          return;
        }

        result += response.data;

        if (response.eof) {
          isEOF = true;
          return resolve(JSON.parse(result));
        }

        return this.sendCommand('IO.read', readArguments).then(onChunkRead);
      };

      this.sendCommand('IO.read', readArguments).then(onChunkRead).catch(reject);
    });
  }

  beginNetworkCollect(opts) {
    return new Promise((resolve, reject) => {
      this._networkRecords = [];
      this._networkRecorder = new NetworkRecorder(this._networkRecords);
      this.enableUrlUpdateIfRedirected(opts);

      this.on('Network.requestWillBeSent', this._networkRecorder.onRequestWillBeSent);
      this.on('Network.requestServedFromCache', this._networkRecorder.onRequestServedFromCache);
      this.on('Network.responseReceived', this._networkRecorder.onResponseReceived);
      this.on('Network.dataReceived', this._networkRecorder.onDataReceived);
      this.on('Network.loadingFinished', this._networkRecorder.onLoadingFinished);
      this.on('Network.loadingFailed', this._networkRecorder.onLoadingFailed);
      this.on('Network.resourceChangedPriority', this._networkRecorder.onResourceChangedPriority);

      this.sendCommand('Network.enable').then(resolve, reject);
    });
  }

  endNetworkCollect() {
    return new Promise((resolve, reject) => {
      this.off('Network.requestWillBeSent', this._networkRecorder.onRequestWillBeSent);
      this.off('Network.requestServedFromCache', this._networkRecorder.onRequestServedFromCache);
      this.off('Network.responseReceived', this._networkRecorder.onResponseReceived);
      this.off('Network.dataReceived', this._networkRecorder.onDataReceived);
      this.off('Network.loadingFinished', this._networkRecorder.onLoadingFinished);
      this.off('Network.loadingFailed', this._networkRecorder.onLoadingFailed);
      this.off('Network.resourceChangedPriority', this._networkRecorder.onResourceChangedPriority);

      resolve(this._networkRecords);

      this._networkRecorder = null;
      this._networkRecords = [];
    });
  }

  enableRuntimeEvents() {
    return this.sendCommand('Runtime.enable');
  }

  beginEmulation() {
    return Promise.all([
      emulation.enableNexus5X(this),
      emulation.enableNetworkThrottling(this)
    ]);
  }

  /**
   * Emulate internet disconnection.
   * @return {!Promise}
   */
  goOffline() {
    return this.sendCommand('Network.enable').then(_ => emulation.goOffline(this));
  }

  /**
   * Enable internet connection, using emulated mobile settings if
   * `options.flags.mobile` is true.
   * @param {!Object} options
   * @return {!Promise}
   */
  goOnline(options) {
    return this.sendCommand('Network.enable').then(_ => {
      if (options.flags.mobile) {
        return emulation.enableNetworkThrottling(this);
      }

      return emulation.disableNetworkThrottling(this);
    });
  }

  cleanAndDisableBrowserCaches() {
    return Promise.all([
      this.clearBrowserCache(),
      this.disableBrowserCache()
    ]);
  }

  clearBrowserCache() {
    return this.sendCommand('Network.clearBrowserCache');
  }

  disableBrowserCache() {
    return this.sendCommand('Network.setCacheDisabled', {cacheDisabled: true});
  }

  clearDataForOrigin(url) {
    const parsedURL = parseURL(url);
    const origin = `${parsedURL.protocol}//${parsedURL.hostname}` +
      (parsedURL.port ? `:${parsedURL.port}` : '');

    // Clear all types of storage except cookies, so the user isn't logged out.
    //   https://chromedevtools.github.io/debugger-protocol-viewer/tot/Storage/#type-StorageType
    const typesToClear = [
      'appcache',
      // 'cookies',
      'file_systems',
      'indexeddb',
      'local_storage',
      'shader_cache',
      'websql',
      'service_workers',
      'cache_storage'
    ].join(',');

    return this.sendCommand('Storage.clearDataForOrigin', {
      origin: origin,
      storageTypes: typesToClear
    });
  }

  /**
   * Keeps track of calls to a JS function and returns a list of {url, line, col}
   * of the usage. Should be called before page load (in beforePass).
   * @param {string} funcName The function name to track ('Date.now', 'console.time').
   * @return {function(): !Promise<!Array<{url: string, line: number, col: number}>>}
   *     Call this method when you want results.
   */
  captureFunctionCallSites(funcName) {
    const globalVarToPopulate = `window['__${funcName}StackTraces']`;
    const collectUsage = () => {
      return this.evaluateAsync(
          `__returnResults(Array.from(${globalVarToPopulate}).map(item => JSON.parse(item)))`);
    };

    const funcBody = captureJSCallUsage.toString();

    this.evaluateScriptOnLoad(`
        ${globalVarToPopulate} = new Set();
        (${funcName} = ${funcBody}(${funcName}, ${globalVarToPopulate}))`);

    return collectUsage;
  }
}

/**
 * Tracks function call usage. Used by captureJSCalls to inject code into the page.
 * @param {function(...*): *} funcRef The function call to track.
 * @param {!Set} set An empty set to populate with stack traces. Should be
 *     on the global object.
 * @return {function(...*): *} A wrapper around the original function.
 */
function captureJSCallUsage(funcRef, set) {
  const originalFunc = funcRef;
  const originalPrepareStackTrace = Error.prepareStackTrace;

  return function() {
    // Note: this function runs in the context of the page that is being audited.

    const args = [...arguments]; // callee's arguments.

    // See v8's Stack Trace API https://github.com/v8/v8/wiki/Stack-Trace-API#customizing-stack-traces
    Error.prepareStackTrace = function(error, structStackTrace) {
      // First frame is the function we injected (the one that just threw).
      // Second, is the actual callsite of the funcRef we're after.
      const callFrame = structStackTrace[1];
      const file = callFrame.getFileName();
      const line = callFrame.getLineNumber();
      const col = callFrame.getColumnNumber();
      const stackTrace = structStackTrace.slice(1).map(
          callsite => callsite.toString());
      return {url: file, args, line, col, stackTrace}; // return value is e.stack
    };
    const e = new Error(`__called ${funcRef.name}__`);
    set.add(JSON.stringify(e.stack));

    // Restore prepareStackTrace so future errors use v8's formatter and not
    // our custom one.
    Error.prepareStackTrace = originalPrepareStackTrace;

    return originalFunc.apply(this, arguments);
  };
}

module.exports = Driver;

},{"../../lib/element":18,"../../lib/emulation":19,"../../lib/log.js":21,"../../lib/network-recorder":23,"events":195,"url":204}],14:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Connection = require('./connection.js');
const log = require('../../lib/log.js');

/* globals chrome */

class ExtensionConnection extends Connection {

  constructor() {
    super();
    this._tabId = null;

    this._onEvent = this._onEvent.bind(this);
    this._onUnexpectedDetach = this._onUnexpectedDetach.bind(this);
  }

  _onEvent(source, method, params) {
    // log events received
    log.log('<=', method, params);
    this.emitNotification(method, params);
  }

  _onUnexpectedDetach(debuggee, detachReason) {
    this._detachCleanup();
    throw new Error('Lighthouse detached from browser: ' + detachReason);
  }

  _detachCleanup() {
    this._tabId = null;
    chrome.debugger.onEvent.removeListener(this._onEvent);
    chrome.debugger.onDetach.removeListener(this._onUnexpectedDetach);
    this.dispose();
  }

  /**
   * @override
   * @return {!Promise}
   */
  connect() {
    if (this._tabId !== null) {
      return Promise.resolve();
    }

    return this._queryCurrentTab()
      .then(tab => {
        const tabId = this._tabId = tab.id;
        chrome.debugger.onEvent.addListener(this._onEvent);
        chrome.debugger.onDetach.addListener(this._onUnexpectedDetach);

        return new Promise((resolve, reject) => {
          chrome.debugger.attach({tabId}, '1.1', _ => {
            if (chrome.runtime.lastError) {
              return reject(chrome.runtime.lastError);
            }
            resolve(tabId);
          });
        });
      });
  }

  /**
   * @override
   * @return {!Promise}
   */
  disconnect() {
    if (this._tabId === null) {
      return Promise.resolve();
    }

    const tabId = this._tabId;
    return new Promise((resolve, reject) => {
      chrome.debugger.detach({tabId}, _ => {
        if (chrome.runtime.lastError) {
          return reject(chrome.runtime.lastError);
        }
        resolve();
      });
    }).then(_ => this._detachCleanup());
  }

  reloadForCleanStateIfNeeded(options) {
    // Reload the page to remove any side-effects (like disabling JavaScript).
    const status = 'Reloading page to reset state';
    log.log('status', status);
    return this.gotoURL(options.url).then(_ => {
      log.log('statusEnd', status);
    });
  }

  /**
   * @override
   * @param {!string} method
   * @param {!Object} params
   * @return {!Promise}
   */
  sendCommand(command, params) {
    return new Promise((resolve, reject) => {
      log.formatProtocol('method => browser', {method: command, params: params}, 'verbose');
      if (!this._tabId) {
        log.error('No tabId set for sendCommand');
      }
      chrome.debugger.sendCommand({tabId: this._tabId}, command, params, result => {
        if (chrome.runtime.lastError) {
          log.formatProtocol('method <= browser ERR', {method: command, params: result}, 'error');
          return reject(chrome.runtime.lastError);
        }

        if (result.wasThrown) {
          log.formatProtocol('method <= browser ERR', {method: command, params: result}, 'error');
          return reject(result.exceptionDetails);
        }

        log.formatProtocol('method <= browser OK', {method: command, params: result}, 'verbose');
        resolve(result);
      });
    });
  }

  _queryCurrentTab() {
    return new Promise((resolve, reject) => {
      const queryOpts = {
        active: true,
        lastFocusedWindow: true,
        windowType: 'normal'
      };

      chrome.tabs.query(queryOpts, (tabs => {
        if (chrome.runtime.lastError) {
          return reject(chrome.runtime.lastError);
        }
        if (tabs.length === 0) {
          const message = 'Couldn\'t resolve current tab. Please file a bug.';
          return reject(new Error(message));
        }
        resolve(tabs[0]);
      }));
    });
  }

  /**
   * Used by lighthouse-background to kick off the run on the current page
   */
  getCurrentTabURL() {
    return this._queryCurrentTab().then(tab => tab.url);
  }
}

module.exports = ExtensionConnection;

},{"../../lib/log.js":21,"./connection.js":12}],15:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Connection = require('./connection.js');

/* eslint-disable no-unused-vars */

/**
 * @interface
 */
class Port {
  /**
   * @param {!string} eventName, 'message', 'close'
   * @param {function(string|undefined)} cb
   */
  on(eventName, cb) { }

  /**
   * @param {string} message
   */
  send(message) { }

  close() { }
}

/* eslint-enable no-unused-vars */

class RawConnection extends Connection {
  constructor(port) {
    super();
    this._port = port;
    this._port.on('message', this.handleRawMessage.bind(this));
    this._port.on('close', this.dispose.bind(this));
  }

  /**
   * @override
   * @return {!Promise}
   */
  connect() {
    return Promise.resolve();
  }

  /**
   * @override
   */
  disconnect() {
    this._port.close();
    return Promise.resolve();
  }

  /**
   * @override
   * @param {string} message
   */
  sendRawMessage(message) {
    this._port.send(message);
  }
}

module.exports = RawConnection;

},{"./connection.js":12}],16:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const log = require('../lib/log.js');
const Audit = require('../audits/audit');
const path = require('path');

/**
 * Class that drives browser to load the page and runs gatherer lifecycle hooks.
 * Execution sequence when GatherRunner.run() is called:
 *
 * 1. Setup
 *   A. driver.connect()
 *   B. GatherRunner.setupDriver()
 *     i. beginEmulation
 *     ii. cleanAndDisableBrowserCaches
 *     iii. clearDataForOrigin
 *
 * 2. For each pass in the config:
 *   A. GatherRunner.beforePass()
 *     i. navigate to about:blank
 *     ii. all gatherer's beforePass()
 *   B. GatherRunner.pass()
 *     i. GatherRunner.loadPage()
 *       b. beginTrace (if requested) & beginNetworkCollect
 *       c. navigate to options.url (and wait for onload)
 *     ii. all gatherer's pass()
 *   C. GatherRunner.afterPass()
 *     i. endTrace (if requested) & endNetworkCollect
 *     ii. all gatherer's afterPass()
 *
 * 3. Teardown
 *   A. reloadForCleanStateIfNeeded
 *   B. driver.disconnect()
 *   C. collect all artifacts and return them
 */
class GatherRunner {
  /**
   * Loads about:blank and waits there briefly. Since a Page.reload command does
   * not let a service worker take over, we navigate away and then come back to
   * reload. We do not `waitForLoad` on about:blank since a page load event is
   * never fired on it.
   * @param {!Driver} driver
   * @return {!Promise}
   */
  static loadBlank(driver) {
    return driver.gotoURL('about:blank')
      .then(_ => new Promise((resolve, reject) => setTimeout(resolve, 300)));
  }

  /**
   * Loads options.url with specified options.
   * @param {!Driver} driver
   * @param {!Object} options
   * @return {!Promise}
   */
  static loadPage(driver, options) {
    return Promise.resolve()
      // Begin tracing only if requested by config.
      .then(_ => options.config.recordTrace && driver.beginTrace())
      // Network is always recorded for internal use, even if not saved as artifact.
      .then(_ => driver.beginNetworkCollect(options))
      // Navigate.
      .then(_ => driver.gotoURL(options.url, {
        waitForLoad: true,
        disableJavaScript: !!options.disableJavaScript,
        flags: options.flags,
      }));
  }

  static setupDriver(driver, options) {
    log.log('status', 'Initializing…');
    // Enable emulation if required.
    return Promise.resolve(options.flags.mobile && driver.beginEmulation())
      .then(_ => driver.enableRuntimeEvents())
      .then(_ => driver.cleanAndDisableBrowserCaches())
      .then(_ => driver.clearDataForOrigin(options.url));
  }

  /**
   * Navigates to about:blank and calls beforePass() on gatherers before tracing
   * has started and before navigation to the target page.
   * @param {!Object} options
   * @return {!Promise}
   */
  static beforePass(options) {
    const pass = GatherRunner.loadBlank(options.driver);

    return options.config.gatherers.reduce((chain, gatherer) => {
      return chain.then(_ => {
        return gatherer.beforePass(options);
      });
    }, pass);
  }

  /**
   * Navigates to requested URL and then runs pass() on gatherers while trace
   * (if requested) is still being recorded.
   * @param {!Object} options
   * @return {!Promise}
   */
  static pass(options) {
    const driver = options.driver;
    const config = options.config;
    const gatherers = config.gatherers;

    const gatherernames = gatherers.map(g => g.name).join(', ');
    const status = 'Loading page & waiting for onload';
    log.log('status', status, gatherernames);

    const pass = GatherRunner.loadPage(driver, options).then(_ => {
      log.log('statusEnd', status);
    });

    return gatherers.reduce((chain, gatherer) => {
      return chain.then(_ => gatherer.pass(options));
    }, pass);
  }

  /**
   * Ends tracing and collects trace data (if requested for this pass), and runs
   * afterPass() on gatherers with trace data passed in. Promise resolves with
   * object containing trace and network data.
   * @param {!Object} options
   * @return {!Promise}
   */
  static afterPass(options) {
    const driver = options.driver;
    const config = options.config;
    const gatherers = config.gatherers;
    const passData = {};

    let pass = Promise.resolve();

    if (config.recordTrace) {
      pass = pass.then(_ => {
        log.log('status', 'Retrieving trace');
        return driver.endTrace();
      }).then(traceContents => {
        // Before Chrome 54.0.2816 (codereview.chromium.org/2161583004),
        // traceContents was an array of trace events; after, traceContents is
        // an object with a traceEvents property. Normalize to object form.
        passData.trace = Array.isArray(traceContents) ?
            {traceEvents: traceContents} : traceContents;
        log.verbose('statusEnd', 'Retrieving trace');
      });
    }

    const status = 'Retrieving network records';
    pass = pass.then(_ => {
      log.log('status', status);
      return driver.endNetworkCollect();
    }).then(networkRecords => {
      // Network records only given to gatherers if requested by config.
      config.recordNetwork && (passData.networkRecords = networkRecords);
      log.verbose('statusEnd', status);
    });

    pass = gatherers.reduce((chain, gatherer) => {
      const status = `Retrieving: ${gatherer.name}`;
      return chain.then(_ => {
        log.log('status', status);
        return gatherer.afterPass(options, passData);
      }).then(ret => {
        log.verbose('statusEnd', status);
        return ret;
      });
    }, pass);

    // Resolve on tracing data using passName from config.
    return pass.then(_ => passData);
  }

  static run(passes, options) {
    const driver = options.driver;
    const tracingData = {
      traces: {},
      networkRecords: {}
    };

    if (typeof options.url !== 'string' || options.url.length === 0) {
      return Promise.reject(new Error('You must provide a url to the driver'));
    }

    if (typeof options.flags === 'undefined') {
      options.flags = {};
    }

    if (typeof options.config === 'undefined') {
      return Promise.reject(new Error('You must provide a config'));
    }

    // Default mobile emulation and page loading to true.
    // The extension will switch these off initially.
    if (typeof options.flags.mobile === 'undefined') {
      options.flags.mobile = true;
    }

    passes = this.instantiateGatherers(passes, options.config.configDir);

    return driver.connect()
      .then(_ => GatherRunner.setupDriver(driver, options))

      // Run each pass
      .then(_ => {
        // If the main document redirects, we'll update this to keep track
        let urlAfterRedirects;
        return passes.reduce((chain, config, passIndex) => {
          const runOptions = Object.assign({}, options, {config});
          return chain
            .then(_ => GatherRunner.beforePass(runOptions))
            .then(_ => GatherRunner.pass(runOptions))
            .then(_ => GatherRunner.afterPass(runOptions))
            .then(passData => {
              // If requested by config, merge trace and network data for this
              // pass into tracingData.
              const passName = config.passName || Audit.DEFAULT_PASS;
              config.recordTrace && (tracingData.traces[passName] = passData.trace);
              config.recordNetwork &&
                  (tracingData.networkRecords[passName] = passData.networkRecords);

              if (passIndex === 0) {
                urlAfterRedirects = runOptions.url;
              }
            });
        }, Promise.resolve()).then(_ => {
          options.url = urlAfterRedirects;
        });
      })
      .then(_ => {
        // We dont need to hold up the reporting for the reload/disconnect,
        // so we will not return a promise in here.
        driver.reloadForCleanStateIfNeeded(options).then(_ => {
          log.log('status', 'Disconnecting from browser...');
          driver.disconnect();
        });
      })
      .then(_ => {
        // Collate all the gatherer results.
        const computedArtifacts = this.instantiateComputedArtifacts();
        const artifacts = Object.assign({}, computedArtifacts, tracingData);

        passes.forEach(pass => {
          pass.gatherers.forEach(gatherer => {
            if (typeof gatherer.artifact === 'undefined') {
              throw new Error(`${gatherer.constructor.name} failed to provide an artifact.`);
            }

            artifacts[gatherer.name] = gatherer.artifact;
          });
        });
        return artifacts;
      });
  }

  static getGathererClass(nameOrGathererClass, configPath) {
    const Runner = require('../runner');
    const coreList = Runner.getGathererList();

    let GathererClass;
    if (typeof nameOrGathererClass === 'string') {
      const name = nameOrGathererClass;

      // See if the gatherer is a Lighthouse core gatherer.
      const coreGatherer = coreList.find(a => a === `${name}.js`);
      let requirePath = `./gatherers/${name}`;
      if (!coreGatherer) {
        // Otherwise, attempt to find it elsewhere. This throws if not found.
        requirePath = Runner.resolvePlugin(name, configPath, 'gatherer');
      }

      GathererClass = require(requirePath);

      this.assertValidGatherer(GathererClass, name);
    } else {
      GathererClass = nameOrGathererClass;
      this.assertValidGatherer(GathererClass);
    }

    return GathererClass;
  }

  static assertValidGatherer(GathererDefinition, gathererName) {
    const gathererInstance = new GathererDefinition();
    gathererName = gathererName || gathererInstance.name || 'gatherer';

    if (typeof gathererInstance.beforePass !== 'function') {
      throw new Error(`${gathererName} has no beforePass() method.`);
    }

    if (typeof gathererInstance.pass !== 'function') {
      throw new Error(`${gathererName} has no pass() method.`);
    }

    if (typeof gathererInstance.afterPass !== 'function') {
      throw new Error(`${gathererName} has no afterPass() method.`);
    }

    if (typeof gathererInstance.artifact !== 'object') {
      throw new Error(`${gathererName} has no artifact property.`);
    }
  }

  static instantiateComputedArtifacts() {
    const computedArtifacts = {};
    ["computed-artifact.js","critical-request-chains.js","pushed-requests.js","screenshots.js","speedline.js"].forEach(function(file) {
      // Drop `.js` suffix to keep browserify import happy.
      file = file.replace(/\.js$/, '');
      const ArtifactClass = require('./computed/' + file);
      const artifact = new ArtifactClass();
      // define the request* function that will be exposed on `artifacts`
      computedArtifacts['request' + artifact.name] = artifact.request.bind(artifact);
    });
    return computedArtifacts;
  }

  static instantiateGatherers(passes, rootPath) {
    return passes.map(pass => {
      pass.gatherers = pass.gatherers.map(gatherer => {
        // If this is already instantiated, don't do anything else.
        if (typeof gatherer !== 'string') {
          return gatherer;
        }

        const GathererClass = GatherRunner.getGathererClass(gatherer, rootPath);
        return new GathererClass();
      });

      return pass;
    });
  }
}

module.exports = GatherRunner;

},{"../audits/audit":"../audits/audit","../lib/log.js":21,"../runner":27,"path":198}],17:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const log = require('./log.js');

class ConsoleQuieter {

  static mute(opts) {
    ConsoleQuieter._logs = ConsoleQuieter._logs || [];

    console.log = function() {
      ConsoleQuieter._logs.push({type: 'log', args: arguments, prefix: opts.prefix});
    };
    console.warn = function() {
      ConsoleQuieter._logs.push({type: 'warn', args: arguments, prefix: opts.prefix});
    };
    console.error = function() {
      ConsoleQuieter._logs.push({type: 'error', args: arguments, prefix: opts.prefix});
    };
  }

  static unmuteAndFlush() {
    console.log = ConsoleQuieter._consolelog;
    console.warn = ConsoleQuieter._consolewarn;
    console.error = ConsoleQuieter._consoleerror;

    ConsoleQuieter._logs.forEach(entry => {
      log.verbose(`${entry.prefix}-${entry.type}`, ...entry.args);
    });
    ConsoleQuieter._logs = [];
  }
}

ConsoleQuieter._consolelog = console.log.bind(console);
ConsoleQuieter._consolewarn = console.warn.bind(console);
ConsoleQuieter._consoleerror = console.error.bind(console);

module.exports = ConsoleQuieter;

},{"./log.js":21}],18:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

class Element {

  constructor(element, driver) {
    if (!element || !driver) {
      throw Error('Driver and element required to create Element');
    }
    this.driver = driver;
    this.element = element;
  }

  /**
   * @param {!string} name Attribute name
   * @return {!Promise<?string>} The attribute value or null if not found
   */
  getAttribute(name) {
    return this.driver
      .sendCommand('DOM.getAttributes', {
        nodeId: this.element.nodeId
      })
      /**
       * @param {!{attributes: !Array<!string>}} resp The element attribute names & values are interleaved
       */
      .then(resp => {
        const attrIndex = resp.attributes.indexOf(name);
        if (attrIndex === -1) {
          return null;
        }
        return resp.attributes[attrIndex + 1];
      });
  }
}

module.exports = Element;

},{}],19:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/**
 * Nexus 5X metrics adapted from emulated_devices/module.json
 */
const NEXUS5X_EMULATION_METRICS = {
  mobile: true,
  screenWidth: 412,
  screenHeight: 732,
  width: 412,
  height: 732,
  positionX: 0,
  positionY: 0,
  scale: 1,
  deviceScaleFactor: 2.625,
  fitWindow: false,
  screenOrientation: {
    angle: 0,
    type: 'portraitPrimary'
  }
};

const NEXUS5X_USERAGENT = {
  userAgent: 'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36' +
    '(KHTML, like Gecko) Chrome/52.0.2743.8 Mobile Safari/537.36'
};

const TYPICAL_MOBILE_THROTTLING_METRICS = {
  latency: 150, // 150ms
  downloadThroughput: 1.6 * 1024 * 1024 / 8, // 1.6Mbps
  uploadThroughput: 750 * 1024 / 8, // 750Kbps
  offline: false
};

const OFFLINE_METRICS = {
  offline: true,
  // values of 0 remove any active throttling. crbug.com/456324#c9
  latency: 0,
  downloadThroughput: 0,
  uploadThroughput: 0
};

const NO_THROTTLING_METRICS = {
  latency: 0,
  downloadThroughput: 0,
  uploadThroughput: 0,
  offline: false
};

function enableNexus5X(driver) {
  /**
   * Finalizes touch emulation by enabling `"ontouchstart" in window` feature detect
   * to work. Messy hack, though copied verbatim from DevTools' emulation/TouchModel.js
   * where it's been working for years. addScriptToEvaluateOnLoad runs before any of the
   * page's JavaScript executes.
   */
  /* eslint-disable no-proto */ /* global window, document */ /* istanbul ignore next */
  const injectedTouchEventsFunction = function() {
    const touchEvents = ['ontouchstart', 'ontouchend', 'ontouchmove', 'ontouchcancel'];
    var recepients = [window.__proto__, document.__proto__];
    for (var i = 0; i < touchEvents.length; ++i) {
      for (var j = 0; j < recepients.length; ++j) {
        if (!(touchEvents[i] in recepients[j])) {
          Object.defineProperty(recepients[j], touchEvents[i], {
            value: null, writable: true, configurable: true, enumerable: true
          });
        }
      }
    }
  };
  /* eslint-enable */

  return Promise.all([
    driver.sendCommand('Emulation.setDeviceMetricsOverride', NEXUS5X_EMULATION_METRICS),
    // Network.enable must be called for UA overriding to work
    driver.sendCommand('Network.enable'),
    driver.sendCommand('Network.setUserAgentOverride', NEXUS5X_USERAGENT),
    driver.sendCommand('Emulation.setTouchEmulationEnabled', {
      enabled: true,
      configuration: 'mobile'
    }),
    driver.sendCommand('Page.addScriptToEvaluateOnLoad', {
      scriptSource: '(' + injectedTouchEventsFunction.toString() + ')()'
    })
  ]);
}

function enableNetworkThrottling(driver) {
  return driver.sendCommand('Network.emulateNetworkConditions', TYPICAL_MOBILE_THROTTLING_METRICS);
}

function disableNetworkThrottling(driver) {
  return driver.sendCommand('Network.emulateNetworkConditions', NO_THROTTLING_METRICS);
}

function goOffline(driver) {
  return driver.sendCommand('Network.emulateNetworkConditions', OFFLINE_METRICS);
}

module.exports = {
  enableNexus5X,
  enableNetworkThrottling,
  disableNetworkThrottling,
  goOffline
};

},{}],20:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/**
 * @param {!Manifest=} manifest
 * @return {boolean} Does the manifest have any icons?
 */
function doExist(manifest) {
  if (!manifest || !manifest.icons) {
    return false;
  }
  if (manifest.icons.value.length === 0) {
    return false;
  }
  return true;
}

/**
 * @param {number} sizeRequirement
 * @param {!Manifest} manifest
 * @return {!Array<string>} Value of satisfactory sizes (eg. ['192x192', '256x256'])
 */
function sizeAtLeast(sizeRequirement, manifest) {
  // An icon can be provided for a single size, or for multiple sizes.
  // To handle both, we flatten all found sizes into a single array.
  const iconValues = manifest.icons.value;
  const nestedSizes = iconValues.map(icon => icon.value.sizes.value);
  const flattenedSizes = [].concat.apply([], nestedSizes);

  return flattenedSizes
      // First, filter out any undefined values, in case an icon was defined without a size
      .filter(size => typeof size === 'string')
      // discard sizes that are not AAxBB (eg. "any")
      .filter(size => /\d+x\d+/.test(size))
      .filter(size => {
        // Split the '24x24' strings into ['24','24'] arrays
        const sizeStrs = size.split(/x/i);
        // Cast the ['24','24'] strings into [24,24] numbers
        const sizeNums = [parseFloat(sizeStrs[0]), parseFloat(sizeStrs[1])];
        // Only keep sizes that are as big as our required size
        const areIconsBigEnough = sizeNums[0] >= sizeRequirement && sizeNums[1] >= sizeRequirement;
        // Square is required: https://code.google.com/p/chromium/codesearch#chromium/src/chrome/browser/manifest/manifest_icon_selector.cc&q=ManifestIconSelector::IconSizesContainsBiggerThanMinimumSize&sq=package:chromium
        const areIconsSquare = sizeNums[0] === sizeNums[1];
        return areIconsBigEnough && areIconsSquare;
      });
}

module.exports = {
  doExist,
  sizeAtLeast
};

},{}],21:[function(require,module,exports){
(function (process){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const debug = require('debug');
const EventEmitter = require('events').EventEmitter;

function setLevel(level) {
  if (level === 'verbose') {
    debug.enable('*');
  } else if (level === 'error') {
    debug.enable('*:error');
  } else {
    debug.enable('*, -*:verbose');
  }
}

const loggers = {};
function _log(title, logargs) {
  const args = [...logargs].slice(1);
  if (!loggers[title]) {
    loggers[title] = debug(title);
  }
  return loggers[title](...args);
}

class Emitter extends EventEmitter {
  /**
   * Fires off all status updates. Listen with
   * `require('lib/log').events.addListener('status', callback)`
   */
  issueStatus(title, args) {
    if (title === 'status' || title === 'statusEnd') {
      this.emit(title, args);
    }
  }

  /**
   * Fires off all warnings. Listen with
   * `require('lib/log').events.addListener('warning', callback)`
   */
  issueWarning(args) {
    this.emit('warning', args);
  }
}

/**
 * A simple formatting utility for event logging.
 * @param {string} prefix
 * @param {!Object} data A JSON-serializable object of event data to log.
 * @param {string=} level Optional logging level. Defaults to 'log'.
 */
function formatProtocol(prefix, data, level) {
  const columns = (!process || process.browser) ? Infinity : process.stdout.columns;
  const maxLength = columns - data.method.length - prefix.length - 18;
  // IO.read blacklisted here to avoid logging megabytes of trace data
  const snippet = (data.params && data.method !== 'IO.read') ?
      JSON.stringify(data.params).substr(0, maxLength) : '';
  level = level || 'log';
  _log(`${prefix}:${level}`, prefix, data.method, snippet);
}

module.exports = {
  setLevel,
  formatProtocol,
  events: new Emitter(),
  log(title) {
    this.events.issueStatus(title, arguments);
    return _log(title, arguments);
  },

  warn(title) {
    this.events.issueWarning(arguments);
    return _log(`${title}:warn`, arguments);
  },

  error(title) {
    return _log(`${title}:error`, arguments);
  },

  verbose(title) {
    this.events.issueStatus(title, arguments);
    return _log(`${title}:verbose`, arguments);
  }
};

}).call(this,require('_process'))
},{"_process":199,"debug":234,"events":195}],22:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const url = require('url');
const validateColor = require('./web-inspector').Color.parse;

const ALLOWED_DISPLAY_VALUES = [
  'fullscreen',
  'standalone',
  'minimal-ui',
  'browser'
];
/**
 * All display-mode fallbacks, including when unset, lead to default display mode 'browser'.
 * @see https://w3c.github.io/manifest/#dfn-default-display-mode
 */
const DEFAULT_DISPLAY_MODE = 'browser';

const ALLOWED_ORIENTATION_VALUES = [
  'any',
  'natural',
  'landscape',
  'portrait',
  'portrait-primary',
  'portrait-secondary',
  'landscape-primary',
  'landscape-secondary'
];

function parseString(raw, trim) {
  let value;
  let debugString;

  if (typeof raw === 'string') {
    value = trim ? raw.trim() : raw;
  } else {
    if (raw !== undefined) {
      debugString = 'ERROR: expected a string.';
    }
    value = undefined;
  }

  return {
    raw,
    value,
    debugString
  };
}

function parseColor(raw) {
  const color = parseString(raw);

  // Finished if color missing or not a string.
  if (color.value === undefined) {
    return color;
  }

  // Use DevTools's color parser to check CSS3 Color parsing.
  const validatedColor = validateColor(color.raw);
  if (!validatedColor) {
    color.value = undefined;
    color.debugString = 'ERROR: color parsing failed.';
  }

  return color;
}

function parseName(jsonInput) {
  return parseString(jsonInput.name, true);
}

function parseShortName(jsonInput) {
  return parseString(jsonInput.short_name, true);
}

/**
 * Returns whether the urls are of the same origin. See https://html.spec.whatwg.org/#same-origin
 * @param {string} url1
 * @param {string} url2
 * @return {boolean}
 */
function checkSameOrigin(url1, url2) {
  const parsed1 = url.parse(url1);
  const parsed2 = url.parse(url2);

  return parsed1.protocol === parsed2.protocol &&
      parsed1.hostname === parsed2.hostname &&
      parsed1.port === parsed2.port;
}

/**
 * https://w3c.github.io/manifest/#start_url-member
 */
function parseStartUrl(jsonInput, manifestUrl, documentUrl) {
  const raw = jsonInput.start_url;

  // 8.10(3) - discard the empty string and non-strings.
  if (raw === '') {
    return {
      raw,
      value: documentUrl,
      debugString: 'ERROR: start_url string empty'
    };
  }
  const parsedAsString = parseString(raw);
  if (!parsedAsString.value) {
    parsedAsString.value = documentUrl;
    return parsedAsString;
  }

  // 8.10(4) - construct URL with raw as input and manifestUrl as the base.
  let startUrl;
  try {
    // TODO(bckenny): need better URL constructor to do this properly. See
    // https://github.com/GoogleChrome/lighthouse/issues/602
    startUrl = url.resolve(manifestUrl, raw);
  } catch (e) {
    // 8.10(5) - discard invalid URLs.
    return {
      raw,
      value: documentUrl,
      debugString: 'ERROR: invalid start_url relative to ${manifestUrl}'
    };
  }

  // 8.10(6) - discard start_urls that are not same origin as documentUrl.
  if (!checkSameOrigin(startUrl, documentUrl)) {
    return {
      raw,
      value: documentUrl,
      debugString: 'ERROR: start_url must be same-origin as document'
    };
  }

  return {
    raw,
    value: startUrl
  };
}

function parseDisplay(jsonInput) {
  const display = parseString(jsonInput.display, true);

  if (!display.value) {
    display.value = DEFAULT_DISPLAY_MODE;
    return display;
  }

  display.value = display.value.toLowerCase();
  if (ALLOWED_DISPLAY_VALUES.indexOf(display.value) === -1) {
    display.debugString = 'ERROR: \'display\' has invalid value ' + display.value +
        ` will fall back to ${DEFAULT_DISPLAY_MODE}.`;
    display.value = DEFAULT_DISPLAY_MODE;
  }

  return display;
}

function parseOrientation(jsonInput) {
  const orientation = parseString(jsonInput.orientation, true);

  if (orientation.value &&
      ALLOWED_ORIENTATION_VALUES.indexOf(orientation.value.toLowerCase()) === -1) {
    orientation.value = undefined;
    orientation.debugString = 'ERROR: \'orientation\' has an invalid value, will be ignored.';
  }

  return orientation;
}

function parseIcon(raw, manifestUrl) {
  // 9.4(3)
  const src = parseString(raw.src, true);
  // 9.4(4) - discard if trimmed value is the empty string.
  if (src.value === '') {
    src.value = undefined;
  }
  if (src.value) {
    // TODO(bckenny): need better URL constructor to do this properly. See
    // https://github.com/GoogleChrome/lighthouse/issues/602
    // 9.4(4) - construct URL with manifest URL as the base
    src.value = url.resolve(manifestUrl, src.value);
  }

  const type = parseString(raw.type, true);

  const density = {
    raw: raw.density,
    value: 1,
    debugString: undefined
  };
  if (density.raw !== undefined) {
    density.value = parseFloat(density.raw);
    if (isNaN(density.value) || !isFinite(density.value) || density.value <= 0) {
      density.value = 1;
      density.debugString = 'ERROR: icon density cannot be NaN, +∞, or less than or equal to +0.';
    }
  }

  const sizes = parseString(raw.sizes);
  if (sizes.value !== undefined) {
    const set = new Set();
    sizes.value.trim().split(/\s+/).forEach(size => set.add(size.toLowerCase()));
    sizes.value = set.size > 0 ? Array.from(set) : undefined;
  }

  return {
    raw,
    value: {
      src,
      type,
      density,
      sizes
    },
    debugString: undefined
  };
}

function parseIcons(jsonInput, manifestUrl) {
  const raw = jsonInput.icons;

  if (raw === undefined) {
    return {
      raw,
      value: [],
      debugString: undefined
    };
  }

  if (!Array.isArray(raw)) {
    return {
      raw,
      value: [],
      debugString: 'ERROR: \'icons\' expected to be an array but is not.'
    };
  }

  // TODO(bckenny): spec says to skip icons missing `src`, so debug messages on
  // individual icons are lost. Warn instead?
  const value = raw
    // 9.6(3)(1)
    .filter(icon => icon.src !== undefined)
    // 9.6(3)(2)(1)
    .map(icon => parseIcon(icon, manifestUrl))
    // 9.6(3)(2)(2)
    .filter(parsedIcon => parsedIcon.value.src.value !== undefined);

  return {
    raw,
    value,
    debugString: undefined
  };
}

function parseApplication(raw) {
  const platform = parseString(raw.platform, true);
  const id = parseString(raw.id, true);

  // 10.2.(2) and 10.2.(3)
  const appUrl = parseString(raw.url, true);
  if (appUrl.value) {
    try {
      // TODO(bckenny): need better URL constructor to do this properly. See
      // https://github.com/GoogleChrome/lighthouse/issues/602
      // 10.2.(4) - attempt to construct URL.
      appUrl.value = url.parse(appUrl.value).href;
    } catch (e) {
      appUrl.value = undefined;
      appUrl.debugString = 'ERROR: invalid application URL ${raw.url}';
    }
  }

  return {
    raw,
    value: {
      platform,
      id,
      url: appUrl
    },
    debugString: undefined
  };
}

function parseRelatedApplications(jsonInput) {
  const raw = jsonInput.related_applications;

  if (raw === undefined) {
    return {
      raw,
      value: undefined,
      debugString: undefined
    };
  }

  if (!Array.isArray(raw)) {
    return {
      raw,
      value: undefined,
      debugString: 'ERROR: \'related_applications\' expected to be an array but is not.'
    };
  }

  // TODO(bckenny): spec says to skip apps missing `platform`, so debug messages
  // on individual apps are lost. Warn instead?
  const value = raw
    .filter(application => !!application.platform)
    .map(parseApplication)
    .filter(parsedApp => !!parsedApp.value.id.value || !!parsedApp.value.url.value);

  return {
    raw,
    value,
    debugString: undefined
  };
}

function parsePreferRelatedApplications(jsonInput) {
  const raw = jsonInput.prefer_related_applications;
  let value;
  let debugString;

  if (typeof raw === 'boolean') {
    value = raw;
  } else {
    if (raw !== undefined) {
      debugString = 'ERROR: \'prefer_related_applications\' expected to be a boolean.';
    }
    value = undefined;
  }

  return {
    raw,
    value,
    debugString
  };
}

function parseThemeColor(jsonInput) {
  return parseColor(jsonInput.theme_color);
}

function parseBackgroundColor(jsonInput) {
  return parseColor(jsonInput.background_color);
}

/**
 * Parse a manifest from the given inputs.
 * @param {string} string Manifest JSON string.
 * @param {string} manifestUrl URL of manifest file.
 * @param {string} documentUrl URL of document containing manifest link element.
 * @return {!ManifestNode<(!Manifest|undefined)>}
 */
function parse(string, manifestUrl, documentUrl) {
  if (manifestUrl === undefined || documentUrl === undefined) {
    throw new Error('Manifest and document URLs required for manifest parsing.');
  }

  let jsonInput;

  try {
    jsonInput = JSON.parse(string);
  } catch (e) {
    return {
      raw: string,
      value: undefined,
      debugString: 'ERROR: file isn\'t valid JSON: ' + e
    };
  }

  /* eslint-disable camelcase */
  const manifest = {
    name: parseName(jsonInput),
    short_name: parseShortName(jsonInput),
    start_url: parseStartUrl(jsonInput, manifestUrl, documentUrl),
    display: parseDisplay(jsonInput),
    orientation: parseOrientation(jsonInput),
    icons: parseIcons(jsonInput, manifestUrl),
    related_applications: parseRelatedApplications(jsonInput),
    prefer_related_applications: parsePreferRelatedApplications(jsonInput),
    theme_color: parseThemeColor(jsonInput),
    background_color: parseBackgroundColor(jsonInput)
  };
  /* eslint-enable camelcase */

  return {
    raw: string,
    value: manifest,
    debugString: undefined
  };
}

module.exports = parse;

},{"./web-inspector":26,"url":204}],23:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const NetworkManager = require('./web-inspector').NetworkManager;
const EventEmitter = require('events').EventEmitter;
const log = require('../lib/log.js');

class NetworkRecorder extends EventEmitter {
  constructor(recordArray) {
    super();

    this._records = recordArray;
    this.networkManager = NetworkManager.createWithFakeTarget();

    this.startedRequestCount = 0;
    this.finishedRequestCount = 0;

    this.networkManager.addEventListener(this.EventTypes.RequestStarted,
        this.onRequestStarted.bind(this));
    this.networkManager.addEventListener(this.EventTypes.RequestFinished,
        this.onRequestFinished.bind(this));

    this.onRequestWillBeSent = this.onRequestWillBeSent.bind(this);
    this.onRequestServedFromCache = this.onRequestServedFromCache.bind(this);
    this.onResponseReceived = this.onResponseReceived.bind(this);
    this.onDataReceived = this.onDataReceived.bind(this);
    this.onLoadingFinished = this.onLoadingFinished.bind(this);
    this.onLoadingFailed = this.onLoadingFailed.bind(this);
    this.onResourceChangedPriority = this.onResourceChangedPriority.bind(this);
  }

  get EventTypes() {
    return NetworkManager.Events;
  }

  activeRequestCount() {
    return this.startedRequestCount - this.finishedRequestCount;
  }

  isIdle() {
    return this.activeRequestCount() === 0;
  }

  /**
   * Listener for the NetworkManager's RequestStarted event, which includes both
   * web socket and normal request creation.
   * @private
   */
  onRequestStarted() {
    this.startedRequestCount++;

    const activeCount = this.activeRequestCount();
    log.verbose('NetworkRecorder', `Request started. ${activeCount} requests in progress` +
        ` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);

    // If only one request in progress, emit event that we've transitioned from
    // idle to busy.
    if (activeCount === 1) {
      this.emit('networkbusy');
    }
  }

  /**
   * Listener for the NetworkManager's RequestFinished event, which includes
   * request finish, failure, and redirect, as well as the closing of web
   * sockets.
   * @param {!WebInspector.NetworkRequest} request
   * @private
   */
  onRequestFinished(request) {
    this.finishedRequestCount++;
    this._records.push(request.data);
    this.emit('requestloaded', request.data);

    const activeCount = this.activeRequestCount();
    log.verbose('NetworkRecorder', `Request finished. ${activeCount} requests in progress` +
        ` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);

    // If no requests in progress, emit event that we've transitioned from busy
    // to idle.
    if (this.isIdle()) {
      this.emit('networkidle');
    }
  }

  // There are a few differences between the debugging protocol naming and
  // the parameter naming used in NetworkManager. These are noted below.

  onRequestWillBeSent(data) {
    // NOTE: data.timestamp -> time, data.type -> resourceType
    this.networkManager._dispatcher.requestWillBeSent(data.requestId,
        data.frameId, data.loaderId, data.documentURL, data.request,
        data.timestamp, data.wallTime, data.initiator, data.redirectResponse,
        data.type);
  }

  onRequestServedFromCache(data) {
    this.networkManager._dispatcher.requestServedFromCache(data.requestId);
  }

  onResponseReceived(data) {
    // NOTE: data.timestamp -> time, data.type -> resourceType
    this.networkManager._dispatcher.responseReceived(data.requestId,
        data.frameId, data.loaderId, data.timestamp, data.type, data.response);
  }

  onDataReceived(data) {
    // NOTE: data.timestamp -> time
    this.networkManager._dispatcher.dataReceived(data.requestId, data.timestamp,
        data.dataLength, data.encodedDataLength);
  }

  onLoadingFinished(data) {
    // NOTE: data.timestamp -> finishTime
    this.networkManager._dispatcher.loadingFinished(data.requestId,
        data.timestamp, data.encodedDataLength);
  }

  onLoadingFailed(data) {
    // NOTE: data.timestamp -> time, data.type -> resourceType,
    // data.errorText -> localizedDescription
    this.networkManager._dispatcher.loadingFailed(data.requestId,
        data.timestamp, data.type, data.errorText, data.canceled,
        data.blockedReason);
  }

  onResourceChangedPriority(data) {
    this.networkManager._dispatcher.resourceChangedPriority(data.requestId,
        data.newPriority, data.timestamp);
  }

  static recordsFromLogs(logs) {
    const records = [];
    const nr = new NetworkRecorder(records);
    const dispatcher = method => {
      switch (method) {
        case 'Network.requestWillBeSent': return nr.onRequestWillBeSent;
        case 'Network.requestServedFromCache': return nr.onRequestServedFromCache;
        case 'Network.responseReceived': return nr.onResponseReceived;
        case 'Network.dataReceived': return nr.onDataReceived;
        case 'Network.loadingFinished': return nr.onLoadingFinished;
        case 'Network.loadingFailed': return nr.onLoadingFailed;
        case 'Network.resourceChangedPriority': return nr.onResourceChangedPriority;
        default: return () => {};
      }
    };

    logs.forEach(networkEvent => {
      dispatcher(networkEvent.method)(networkEvent.params);
    });

    return records;
  }
}

module.exports = NetworkRecorder;

},{"../lib/log.js":21,"./web-inspector":26,"events":195}],24:[function(require,module,exports){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

const WebInspector = require('../web-inspector');
const ConsoleQuieter = require('../console-quieter');

// Polyfill the bottom-up and topdown tree sorting.
const TimelineModelTreeView =
    require('devtools-timeline-model/lib/timeline-model-treeview.js')(WebInspector);

class TimelineModel {

  constructor(events) {
    this.init(events);
  }

  init(events) {
    // (devtools) tracing model
    this._tracingModel =
        new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage('tracing'));
    // timeline model
    this._timelineModel =
        new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());

    if (typeof events === 'string') {
      events = JSON.parse(events);
    }
    if (events.hasOwnProperty('traceEvents')) {
      events = events.traceEvents;
    }

    // populate with events
    this._tracingModel.reset();

    ConsoleQuieter.mute({prefix: 'timelineModel'});
    this._tracingModel.addEvents(events);
    this._tracingModel.tracingComplete();
    this._timelineModel.setEvents(this._tracingModel);
    ConsoleQuieter.unmuteAndFlush();

    return this;
  }

  _createAggregator() {
    return WebInspector.AggregatedTimelineTreeView.prototype._createAggregator();
  }

  timelineModel() {
    return this._timelineModel;
  }

  tracingModel() {
    return this._tracingModel;
  }

  topDown() {
    var filters = [];
    filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());
    filters.push(new WebInspector.ExcludeTopLevelFilter());
    var nonessentialEvents = [
      WebInspector.TimelineModel.RecordType.EventDispatch,
      WebInspector.TimelineModel.RecordType.FunctionCall,
      WebInspector.TimelineModel.RecordType.TimerFire
    ];
    filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));

    var topDown = WebInspector.TimelineProfileTree.buildTopDown(
        this._timelineModel.mainThreadEvents(),
        filters, /* startTime */ 0, /* endTime */ Infinity,
        WebInspector.TimelineAggregator.eventId);
    return topDown;
  }

  bottomUp() {
    var topDown = this.topDown();
    var noGrouping = WebInspector.TimelineAggregator.GroupBy.None;
    var noGroupAggregator = this._createAggregator().groupFunction(noGrouping);
    return WebInspector.TimelineProfileTree.buildBottomUp(topDown, noGroupAggregator);
  }

 /**
  * @param  {!string} grouping Allowed values: None Category Subdomain Domain URL EventName
  * @return {!WebInspector.TimelineProfileTree.Node} A grouped and sorted tree
  */
  bottomUpGroupBy(grouping) {
    var topDown = this.topDown();

    var groupSetting = WebInspector.TimelineAggregator.GroupBy[grouping];
    var groupingAggregator = this._createAggregator().groupFunction(groupSetting);
    var bottomUpGrouped =
        WebInspector.TimelineProfileTree.buildBottomUp(topDown, groupingAggregator);

    // sort the grouped tree, in-place
    new TimelineModelTreeView(bottomUpGrouped).sortingChanged('self', 'desc');
    return bottomUpGrouped;
  }

  frameModel() {
    var frameModel = new WebInspector.TimelineFrameModel(event =>
      WebInspector.TimelineUIUtils.eventStyle(event).category.name
    );
    frameModel.addTraceEvents({ /* target */ },
      this._timelineModel.inspectedTargetEvents(), this._timelineModel.sessionId() || '');
    return frameModel;
  }

  filmStripModel() {
    return new WebInspector.FilmStripModel(this._tracingModel);
  }

  interactionModel() {
    var irModel = new WebInspector.TimelineIRModel();
    irModel.populate(this._timelineModel);
    return irModel;
  }

}

module.exports = TimelineModel;

},{"../console-quieter":17,"../web-inspector":26,"devtools-timeline-model/lib/timeline-model-treeview.js":236}],25:[function(require,module,exports){
(function (global){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

'use strict';

if (typeof global.window === 'undefined') {
  global.window = global;
}

// The ideal input response latency, the time between the input task and the
// first frame of the response.
const BASE_RESPONSE_LATENCY = 16;

// we need gl-matrix and jszip for traceviewer
// since it has internal forks for isNode and they get mixed up during
// browserify, we require them locally here and global-ize them.

// from catapult/tracing/tracing/base/math.html
const glMatrixModule = require('gl-matrix');
Object.keys(glMatrixModule).forEach(exportName => {
  global[exportName] = glMatrixModule[exportName];
});
// from catapult/tracing/tracing/extras/importer/jszip.html
global.JSZip = require('jszip/dist/jszip.min.js');
global.mannwhitneyu = {};

global.HTMLImportsLoader = {};
global.HTMLImportsLoader.hrefToAbsolutePath = function(path) {
  if (path === '/gl-matrix-min.js') {
    return '../../../lib/empty-stub.js';
  }
  if (path === '/jszip.min.js') {
    return 'jszip/dist/jszip.min.js';
  }
  if (path === '/mannwhitneyu.js') {
    return '../../../lib/empty-stub.js';
  }
};

require('../../third_party/traceviewer-js/');
const traceviewer = global.tr;

class TraceProcessor {
  get RESPONSE() {
    return 'Response';
  }

  get ANIMATION() {
    return 'Animation';
  }

  get LOAD() {
    return 'Load';
  }

  // Create the importer and import the trace contents to a model.
  init(trace) {
    const io = new traceviewer.importer.ImportOptions();
    io.showImportWarnings = false;
    io.pruneEmptyContainers = false;
    io.shiftWorldToZero = true;

    const model = new traceviewer.Model();
    const importer = new traceviewer.importer.Import(model, io);
    importer.importTraces([trace]);

    return model;
  }

  /**
   * Find a main thread from supplied model with matching processId and
   * threadId.
   * @param {!Object} model TraceProcessor Model
   * @param {number} processId
   * @param {number} threadId
   * @return {!Object}
   * @private
   */
  static _findMainThreadFromIds(model, processId, threadId) {
    const modelHelper = model.getOrCreateHelper(traceviewer.model.helpers.ChromeModelHelper);
    const renderHelpers = traceviewer.b.dictionaryValues(modelHelper.rendererHelpers);
    const mainThread = renderHelpers.find(helper => {
      return helper.mainThread &&
        helper.pid === processId &&
        helper.mainThread.tid === threadId;
    }).mainThread;

    return mainThread;
  }

  /**
   * Calculate duration at specified percentiles for given population of
   * durations.
   * If one of the durations overlaps the end of the window, the full
   * duration should be in the duration array, but the length not included
   * within the window should be given as `clippedLength`. For instance, if a
   * 50ms duration occurs 10ms before the end of the window, `50` should be in
   * the `durations` array, and `clippedLength` should be set to 40.
   * @see https://docs.google.com/document/d/18gvP-CBA2BiBpi3Rz1I1ISciKGhniTSZ9TY0XCnXS7E/preview
   * @param {!Array<number>} durations Array of durations, sorted in ascending order.
   * @param {number} totalTime Total time (in ms) of interval containing durations.
   * @param {!Array<number>} percentiles Array of percentiles of interest, in ascending order.
   * @param {number=} clippedLength Optional length clipped from a duration overlapping end of window. Default of 0.
   * @return {!Array<{percentile: number, time: number}>}
   * @private
   */
  static _riskPercentiles(durations, totalTime, percentiles, clippedLength) {
    clippedLength = clippedLength || 0;

    let busyTime = 0;
    for (let i = 0; i < durations.length; i++) {
      busyTime += durations[i];
    }
    busyTime -= clippedLength;

    // Start with idle time already complete.
    let completedTime = totalTime - busyTime;
    let duration = 0;
    let cdfTime = completedTime;
    const results = [];

    let durationIndex = -1;
    let remainingCount = durations.length + 1;
    if (clippedLength > 0) {
      // If there was a clipped duration, one less in count since one hasn't started yet.
      remainingCount--;
    }

    // Find percentiles of interest, in order.
    for (const percentile of percentiles) {
      // Loop over durations, calculating a CDF value for each until it is above
      // the target percentile.
      const percentileTime = percentile * totalTime;
      while (cdfTime < percentileTime && durationIndex < durations.length - 1) {
        completedTime += duration;
        remainingCount -= (duration < 0 ? -1 : 1);

        if (clippedLength > 0 && clippedLength < durations[durationIndex + 1]) {
          duration = -clippedLength;
          clippedLength = 0;
        } else {
          durationIndex++;
          duration = durations[durationIndex];
        }

        // Calculate value of CDF (multiplied by totalTime) for the end of this duration.
        cdfTime = completedTime + Math.abs(duration) * remainingCount;
      }

      // Negative results are within idle time (0ms wait by definition), so clamp at zero.
      results.push({
        percentile,
        time: Math.max(0, (percentileTime - completedTime) / remainingCount) + BASE_RESPONSE_LATENCY
      });
    }

    return results;
  }

  /**
   * Calculates the maximum queueing time (in ms) of high priority tasks for
   * selected percentiles within a window of the main thread.
   * @see https://docs.google.com/document/d/18gvP-CBA2BiBpi3Rz1I1ISciKGhniTSZ9TY0XCnXS7E/preview
   * @param {!traceviewer.Model} model
   * @param {{traceEvents: !Array<!Object>}} trace
   * @param {number=} startTime Optional start time (in ms) of range of interest. Defaults to trace start.
   * @param {number=} endTime Optional end time (in ms) of range of interest. Defaults to trace end.
   * @param {!Array<number>=} percentiles Optional array of percentiles to compute. Defaults to [0.5, 0.75, 0.9, 0.99, 1].
   * @return {!Array<{percentile: number, time: number}>}
   */
  static getRiskToResponsiveness(model, trace, startTime, endTime, percentiles) {
    // Range of responsiveness we care about. Default to bounds of model.
    startTime = startTime === undefined ? model.bounds.min : startTime;
    endTime = endTime === undefined ? model.bounds.max : endTime;
    const totalTime = endTime - startTime;
    if (percentiles) {
      percentiles.sort((a, b) => a - b);
    } else {
      percentiles = [0.5, 0.75, 0.9, 0.99, 1];
    }

    // Find the main thread via the first TracingStartedInPage event in the trace
    const startEvent = trace.traceEvents.find(event => {
      return event.name === 'TracingStartedInPage';
    });
    const mainThread = TraceProcessor._findMainThreadFromIds(model, startEvent.pid, startEvent.tid);

    // Find durations of all slices in range of interest.
    // TODO(bckenny): filter for top level slices ourselves?
    const durations = [];
    let clippedLength = 0;
    mainThread.sliceGroup.topLevelSlices.forEach(slice => {
      // Discard slices outside range.

      if (slice.end <= startTime || slice.start >= endTime) {
        return;
      }

      // Clip any at edges of range.
      let duration = slice.duration;
      let sliceStart = slice.start;
      if (sliceStart < startTime) {
        // Any part of task before window can be discarded.
        sliceStart = startTime;
        duration = slice.end - sliceStart;
      }
      if (slice.end > endTime) {
        // Any part of task after window must be clipped but accounted for.
        clippedLength = duration - (endTime - sliceStart);
      }

      durations.push(duration);
    });
    durations.sort((a, b) => a - b);

    // Actual calculation of percentiles done in _riskPercentiles.
    return TraceProcessor._riskPercentiles(durations, totalTime, percentiles, clippedLength);
  }

  /**
   * Uses traceviewer's statistics package to create a log-normal distribution.
   * Specified by providing the median value, at which the score will be 0.5,
   * and the falloff, the initial point of diminishing returns where any
   * improvement in value will yield increasingly smaller gains in score. Both
   * values should be in the same units (e.g. milliseconds). See
   *   https://www.desmos.com/calculator/tx1wcjk8ch
   * for an interactive view of the relationship between these parameters and
   * the typical parameterization (location and shape) of the log-normal
   * distribution.
   * @param {number} median
   * @param {number} falloff
   * @return {!Statistics.LogNormalDistribution}
   */
  static getLogNormalDistribution(median, falloff) {
    const location = Math.log(median);

    // The "falloff" value specified the location of the smaller of the positive
    // roots of the third derivative of the log-normal CDF. Calculate the shape
    // parameter in terms of that value and the median.
    const logRatio = Math.log(falloff / median);
    const shape = 0.5 * Math.sqrt(1 - 3 * logRatio -
        Math.sqrt((logRatio - 3) * (logRatio - 3) - 8));

    return new traceviewer.b.Statistics.LogNormalDistribution(location, shape);
  }
}

module.exports = TraceProcessor;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../third_party/traceviewer-js/":79,"gl-matrix":237,"jszip/dist/jszip.min.js":251}],26:[function(require,module,exports){
(function (global){
/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

/**
 * Stubbery to allow portions of the DevTools frontend to be used in lighthouse. `WebInspector`
 * technically lives on the global object but should be accessed through a normal `require` call.
 */
module.exports = (function() {
  if (global.WebInspector) {
    return global.WebInspector;
  }

  // Global pollution.
  // Check below is to make it worker-friendly where global is worker's self.
  if (global.self !== global) {
    global.self = global;
  }

  if (typeof global.window === 'undefined') {
    global.window = global;
  }

  global.Runtime = {};
  global.Runtime.experiments = {
    isEnabled(experimentName) {
      switch (experimentName) {
        case 'timelineLatencyInfo':
          return true;
        default:
          return false;
      }
    }
  };
  global.Runtime.queryParam = function(arg) {
    switch (arg) {
      case 'remoteFrontend':
        return false;
      case 'ws':
        return false;
      default:
        throw Error('Mock queryParam case not implemented.');
    }
  };

  global.TreeElement = {};
  global.WorkerRuntime = {};

  global.Protocol = {
    Agents() {}
  };

  global.WebInspector = {};
  const WebInspector = global.WebInspector;
  WebInspector._moduleSettings = {
    cacheDisabled: {
      addChangeListener() {},
      get() {
        return false;
      }
    },
    monitoringXHREnabled: {
      addChangeListener() {},
      get() {
        return false;
      }
    },
    showNativeFunctionsInJSProfile: {
      addChangeListener() {},
      get() {
        return true;
      }
    }
  };
  WebInspector.moduleSetting = function(settingName) {
    return this._moduleSettings[settingName];
  };

  // Enum from chromium//src/third_party/WebKit/Source/core/loader/MixedContentChecker.h
  global.NetworkAgent = {
    RequestMixedContentType: {
      Blockable: 'blockable',
      OptionallyBlockable: 'optionally-blockable',
      None: 'none'
    },
    BlockedReason: {
      CSP: 'csp',
      MixedContent: 'mixed-content',
      Origin: 'origin',
      Inspector: 'inspector',
      Other: 'other'
    },
    InitiatorType: {
      Other: 'other',
      Parser: 'parser',
      Redirect: 'redirect',
      Script: 'script'
    }
  };

  // Enum from SecurityState enum in protocol's Security domain
  global.SecurityAgent = {
    SecurityState: {
      Unknown: 'unknown',
      Neutral: 'neutral',
      Insecure: 'insecure',
      Warning: 'warning',
      Secure: 'secure',
      Info: 'info'
    }
  };
  // From https://chromium.googlesource.com/chromium/src/third_party/WebKit/Source/devtools/+/master/protocol.json#93
  global.PageAgent = {
    ResourceType: {
      Document: 'document',
      Stylesheet: 'stylesheet',
      Image: 'image',
      Media: 'media',
      Font: 'font',
      Script: 'script',
      TextTrack: 'texttrack',
      XHR: 'xhr',
      Fetch: 'fetch',
      EventSource: 'eventsource',
      WebSocket: 'websocket',
      Manifest: 'manifest',
      Other: 'other'
    }
  };
  // Dependencies for network-recorder
  require('chrome-devtools-frontend/front_end/common/Object.js');
  require('chrome-devtools-frontend/front_end/common/ParsedURL.js');
  require('chrome-devtools-frontend/front_end/common/ResourceType.js');
  require('chrome-devtools-frontend/front_end/common/UIString.js');
  require('chrome-devtools-frontend/front_end/platform/utilities.js');
  require('chrome-devtools-frontend/front_end/sdk/Target.js');
  require('chrome-devtools-frontend/front_end/sdk/TargetManager.js');
  require('chrome-devtools-frontend/front_end/sdk/NetworkManager.js');
  require('chrome-devtools-frontend/front_end/sdk/NetworkRequest.js');

  // Dependencies for timeline-model
  WebInspector.targetManager = {
    observeTargets() { },
    addEventListener() { }
  };
  WebInspector.settings = {
    createSetting() {
      return {
        get() {
          return false;
        },
        addChangeListener() {}
      };
    }
  };
  WebInspector.console = {
    error() {}
  };
  WebInspector.VBox = function() {};
  WebInspector.HBox = function() {};
  WebInspector.ViewportDataGrid = function() {};
  WebInspector.ViewportDataGridNode = function() {};
  global.WorkerRuntime.Worker = function() {};

  require('chrome-devtools-frontend/front_end/common/SegmentedRange.js');
  require('chrome-devtools-frontend/front_end/bindings/TempFile.js');
  require('chrome-devtools-frontend/front_end/sdk/TracingModel.js');
  require('chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js');
  require('chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js');
  require('chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js');
  require('chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js');
  require('chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js');
  require('chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js');
  require('chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js');
  require('chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js');
  require('chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js');
  require('chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js');
  require('chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js');
  require('chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js');

  // DevTools makes a few assumptions about using backing storage to hold traces.
  WebInspector.DeferredTempFile = function() {};
  WebInspector.DeferredTempFile.prototype = {
    write: function() {},
    finishWriting: function() {}
  };

  // Mock for WebInspector code that writes to console.
  WebInspector.ConsoleMessage = function() {};
  WebInspector.ConsoleMessage.MessageSource = {
    Network: 'network'
  };
  WebInspector.ConsoleMessage.MessageLevel = {
    Log: 'log'
  };
  WebInspector.ConsoleMessage.MessageType = {
    Log: 'log'
  };

  // Mock NetworkLog
  WebInspector.NetworkLog = function(target) {
    this._requests = new Map();
    target.networkManager.addEventListener(
      WebInspector.NetworkManager.Events.RequestStarted, this._onRequestStarted, this);
  };

  WebInspector.NetworkLog.prototype = {
    requestForURL: function(url) {
      return this._requests.get(url) || null;
    },

    _onRequestStarted: function(event) {
      var request = event.data;
      if (this._requests.has(request.url)) {
        return;
      }
      this._requests.set(request.url, request);
    }
  };

  // Dependencies for color parsing.
  require('chrome-devtools-frontend/front_end/common/Color.js');

  /**
   * Creates a new WebInspector NetworkManager using a mocked Target.
   * @return {!WebInspector.NetworkManager}
   */
  WebInspector.NetworkManager.createWithFakeTarget = function() {
    // Mocked-up WebInspector Target for NetworkManager
    const fakeNetworkAgent = {
      enable() {}
    };
    const fakeConsoleModel = {
      addMessage() {},
      target() {}
    };
    const fakeTarget = {
      _modelByConstructor: new Map(),
      get consoleModel() {
        return fakeConsoleModel;
      },
      networkAgent() {
        return fakeNetworkAgent;
      },
      registerNetworkDispatcher() { },
      model() { }
    };

    fakeTarget.networkManager = new WebInspector.NetworkManager(fakeTarget);
    fakeTarget.networkLog = new WebInspector.NetworkLog(fakeTarget);

    WebInspector.NetworkLog.fromTarget = () => {
      return fakeTarget.networkLog;
    };

    return fakeTarget.networkManager;
  };

  // Dependencies for CSS parsing.
  require('chrome-devtools-frontend/front_end/common/TextRange.js');
  const gonzales = require('chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js');
  require('chrome-devtools-frontend/front_end/gonzales/SCSSParser.js');

  // Mostly taken from from chrome-devtools-frontend/front_end/gonzales/SCSSParser.js.
  WebInspector.SCSSParser.prototype.parse = function(content) {
    var ast = null;
    try {
      ast = gonzales.parse(content, {syntax: 'css'});
    } catch (e) {
      return [];
    }

    /** @type {!{properties: !Array<!Gonzales.Node>, node: !Gonzales.Node}} */
    var rootBlock = {
      properties: [],
      node: ast
    };
    /** @type {!Array<!{properties: !Array<!Gonzales.Node>, node: !Gonzales.Node}>} */
    var blocks = [rootBlock];
    ast.selectors = [];
    WebInspector.SCSSParser.extractNodes(ast, blocks, rootBlock);

    return ast;
  };

  return WebInspector;
})();

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"chrome-devtools-frontend/front_end/bindings/TempFile.js":206,"chrome-devtools-frontend/front_end/common/Color.js":207,"chrome-devtools-frontend/front_end/common/Object.js":208,"chrome-devtools-frontend/front_end/common/ParsedURL.js":209,"chrome-devtools-frontend/front_end/common/ResourceType.js":210,"chrome-devtools-frontend/front_end/common/SegmentedRange.js":211,"chrome-devtools-frontend/front_end/common/TextRange.js":212,"chrome-devtools-frontend/front_end/common/UIString.js":213,"chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js":214,"chrome-devtools-frontend/front_end/gonzales/SCSSParser.js":215,"chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js":216,"chrome-devtools-frontend/front_end/platform/utilities.js":217,"chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js":218,"chrome-devtools-frontend/front_end/sdk/NetworkManager.js":219,"chrome-devtools-frontend/front_end/sdk/NetworkRequest.js":220,"chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js":221,"chrome-devtools-frontend/front_end/sdk/Target.js":222,"chrome-devtools-frontend/front_end/sdk/TargetManager.js":223,"chrome-devtools-frontend/front_end/sdk/TracingModel.js":224,"chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js":225,"chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js":226,"chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js":227,"chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js":228,"chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js":229,"chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js":230,"chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js":231,"chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js":232,"chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js":233}],27:[function(require,module,exports){
(function (process,__dirname){
/**
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

const Driver = require('./gather/drivers/driver.js');
const GatherRunner = require('./gather/gather-runner');
const Aggregate = require('./aggregator/aggregate');
const assetSaver = require('./lib/asset-saver');
const log = require('./lib/log');

const path = require('path');
const url = require('url');

class Runner {
  static run(connection, opts) {
    // Clean opts input.
    opts.flags = opts.flags || {};

    // Default mobile emulation and page loading to true.
    // The extension will switch these off initially.
    if (typeof opts.flags.mobile === 'undefined') {
      opts.flags.mobile = true;
    }

    const config = opts.config;

    // save the initialUrl provided by the user
    opts.initialUrl = opts.url;
    if (typeof opts.initialUrl !== 'string' || opts.initialUrl.length === 0) {
      return Promise.reject(new Error('You must provide a url to the driver'));
    }
    const parsedURL = url.parse(opts.url);
    // canonicalize URL with any trailing slashes neccessary
    opts.url = url.format(parsedURL);

    if (!parsedURL.protocol || !parsedURL.hostname) {
      const err = new Error('The url provided should have a proper protocol and hostname.');
      return Promise.reject(err);
    }
    // If the URL isn't https and is also not localhost complain to the user.
    if (!parsedURL.protocol.includes('https') && parsedURL.hostname !== 'localhost') {
      log.warn('Lighthouse', 'The URL provided should be on HTTPS');
      log.warn('Lighthouse', 'Performance stats will be skewed redirecting from HTTP to HTTPS.');
    }

    // Check that there are passes & audits...
    const validPassesAndAudits = config.passes && config.audits;

    // ... or that there are artifacts & audits.
    const validArtifactsAndAudits = config.artifacts && config.audits;

    // Make a run, which can be .then()'d with whatever needs to run (based on the config).
    let run = Promise.resolve();

    // If there are passes run the GatherRunner and gather the artifacts. If not, we will need
    // to check that there are artifacts specified in the config, and throw if not.
    if (validPassesAndAudits || validArtifactsAndAudits) {
      if (validPassesAndAudits) {
        opts.driver = opts.driverMock || new Driver(connection);
        // Finally set up the driver to gather.
        run = run.then(_ => GatherRunner.run(config.passes, opts));
      } else if (validArtifactsAndAudits) {
        run = run.then(_ => {
          return Object.assign(GatherRunner.instantiateComputedArtifacts(), config.artifacts);
        });
      }

      // Ignoring these two flags for coverage as this functionality is not exposed by the module.
      /* istanbul ignore next */
      if (opts.flags.saveArtifacts) {
        run = run.then(artifacts => {
          opts.flags.saveArtifacts && assetSaver.saveArtifacts(artifacts);
          return artifacts;
        });
      }
      if (opts.flags.saveAssets) {
        run = run.then(artifacts => {
          return assetSaver.saveAssets(opts, artifacts)
            .then(_ => artifacts);
        });
      }

      // Now run the audits.
      const auditResults = [];
      run = run.then(artifacts => config.audits.reduce((chain, audit) => {
        const status = `Evaluating: ${audit.meta.description}`;
        // Run each audit sequentially, the auditResults array has all our fine work
        return chain.then(_ => {
          log.log('status', status);
          return audit.audit(artifacts);
        }).then(ret => {
          log.verbose('statusEnd', status);
          auditResults.push(ret);
        });
      }, Promise.resolve()).then(_ => auditResults));
    } else if (config.auditResults) {
      // If there are existing audit results, surface those here.
      run = run.then(_ => config.auditResults);
    } else {
      const err = Error(
          'The config must provide passes and audits, artifacts and audits, or auditResults');
      return Promise.reject(err);
    }

    // Format and aggregate results before returning.
    run = run
      .then(auditResults => {
        const formattedAudits = auditResults.reduce((formatted, audit) => {
          formatted[audit.name] = audit;
          return formatted;
        }, {});

        // Only run aggregations if needed.
        let aggregations = [];
        if (config.aggregations) {
          aggregations = config.aggregations.map(a => Aggregate.aggregate(a, auditResults));
        }

        return {
          lighthouseVersion: require('../package').version,
          generatedTime: (new Date()).toJSON(),
          initialUrl: opts.initialUrl,
          url: opts.url,
          audits: formattedAudits,
          aggregations
        };
      });

    return run;
  }

  /**
   * Returns list of audit names for external querying.
   * @return {!Array<string>}
   */
  static getAuditList() {
    return ["aria-allowed-attr.js","aria-valid-attr.js","audit.js","cache-start-url.js","color-contrast.js","content-width.js","critical-request-chains.js","dobetterweb","estimated-input-latency.js","first-meaningful-paint.js","geolocation-on-start.js","image-alt.js","is-on-https.js","label.js","manifest-background-color.js","manifest-display.js","manifest-exists.js","manifest-icons-min-144.js","manifest-icons-min-192.js","manifest-name.js","manifest-short-name-length.js","manifest-short-name.js","manifest-start-url.js","manifest-theme-color.js","meta-theme-color.js","redirects-http.js","screenshots.js","service-worker.js","speed-index-metric.js","tabindex.js","time-to-interactive.js","user-timings.js","viewport.js","without-javascript.js","works-offline.js"]
        .filter(f => /\.js$/.test(f));
  }

  /**
   * Returns list of gatherer names for external querying.
   * @return {!Array<string>}
   */
  static getGathererList() {
    return ["accessibility.js","cache-contents.js","content-width.js","dobetterweb","gatherer.js","geolocation-on-start.js","html-without-javascript.js","html.js","http-redirect.js","https.js","manifest.js","offline.js","service-worker.js","styles.js","theme-color.js","url.js","viewport.js"]
        .filter(f => /\.js$/.test(f));
  }

  /**
   * Resolves the location of the specified plugin and returns an absolute
   * string path to the file. Used for loading custom audits and gatherers.
   * Throws an error if no plugin is found.
   * @param {string} plugin
   * @param {string=} configDir The absolute path to the directory of the config file, if there is one.
   * @param {string=} category Optional plugin category (e.g. 'audit') for better error messages.
   * @return {string}
   * @throws {Error}
   */
  static resolvePlugin(plugin, configDir, category) {
    // First try straight `require()`. Unlikely to be specified relative to this
    // file, but adds support for Lighthouse plugins in npm modules as
    // `require()` walks up parent directories looking inside any node_modules/
    // present. Also handles absolute paths.
    try {
      return require.resolve(plugin);
    } catch (e) {}

    // See if the plugin resolves relative to the current working directory.
    // Most useful to handle the case of invoking Lighthouse as a module, since
    // then the config is an object and so has no path.
    const cwdPath = path.resolve(process.cwd(), plugin);
    try {
      return require.resolve(cwdPath);
    } catch (e) {}

    const errorString = 'Unable to locate ' +
        (category ? `${category}: ` : '') +
        `${plugin} (tried to require() from '${__dirname}' and load from '${cwdPath}'`;

    if (!configDir) {
      throw new Error(errorString + ')');
    }

    // Finally, try looking up relative to the config file path. Just like the
    // relative path passed to `require()` is found relative to the file it's
    // in, this allows plugin paths to be specified relative to the config file.
    const relativePath = path.resolve(configDir, plugin);
    try {
      return require.resolve(relativePath);
    } catch (requireError) {}

    throw new Error(errorString + ` and '${relativePath}')`);
  }
}

module.exports = Runner;

}).call(this,require('_process'),"/../lighthouse-core")
},{"../package":256,"./aggregator/aggregate":1,"./gather/drivers/driver.js":13,"./gather/gather-runner":16,"./lib/asset-saver":193,"./lib/log":21,"_process":199,"path":198,"url":204}],28:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

'use strict';

/**
 * The global object.
 * @type {!Object}
 * @const
 */

/** Platform, package, object property, and Event support. */

global.tr = function () {
  if (global.tr) {
    console.warn('Base was multiply initialized. First init wins.');
    return global.tr;
  }

  /**
   * Builds an object structure for the provided namespace path,
   * ensuring that names that already exist are not overwritten. For
   * example:
   * 'a.b.c' -> a = {};a.b={};a.b.c={};
   * @param {string} name Name of the object that this file defines.
   * @private
   */
  function exportPath(name) {
    var parts = name.split('.');
    var cur = global;

    for (var part; parts.length && (part = parts.shift());) {
      if (part in cur) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
    return cur;
  };

  function isExported(name) {
    var parts = name.split('.');
    var cur = global;

    for (var part; parts.length && (part = parts.shift());) {
      if (part in cur) {
        cur = cur[part];
      } else {
        return false;
      }
    }
    return true;
  }

  function isDefined(name) {
    var parts = name.split('.');

    var curObject = global;

    for (var i = 0; i < parts.length; i++) {
      var partName = parts[i];
      var nextObject = curObject[partName];
      if (nextObject === undefined) return false;
      curObject = nextObject;
    }
    return true;
  }

  var panicElement = undefined;
  var rawPanicMessages = [];
  function showPanicElementIfNeeded() {
    if (panicElement) return;

    var panicOverlay = document.createElement('div');
    panicOverlay.style.backgroundColor = 'white';
    panicOverlay.style.border = '3px solid red';
    panicOverlay.style.boxSizing = 'border-box';
    panicOverlay.style.color = 'black';
    panicOverlay.style.display = '-webkit-flex';
    panicOverlay.style.height = '100%';
    panicOverlay.style.left = 0;
    panicOverlay.style.padding = '8px';
    panicOverlay.style.position = 'fixed';
    panicOverlay.style.top = 0;
    panicOverlay.style.webkitFlexDirection = 'column';
    panicOverlay.style.width = '100%';

    panicElement = document.createElement('div');
    panicElement.style.webkitFlex = '1 1 auto';
    panicElement.style.overflow = 'auto';
    panicOverlay.appendChild(panicElement);

    if (!document.body) {
      setTimeout(function () {
        document.body.appendChild(panicOverlay);
      }, 150);
    } else {
      document.body.appendChild(panicOverlay);
    }
  }

  function showPanic(panicTitle, panicDetails) {
    if (tr.isHeadless) {
      if (panicDetails instanceof Error) throw panicDetails;
      throw new Error('Panic: ' + panicTitle + ':\n' + panicDetails);
    }

    if (panicDetails instanceof Error) panicDetails = panicDetails.stack;

    showPanicElementIfNeeded();
    var panicMessageEl = document.createElement('div');
    panicMessageEl.innerHTML = '<h2 id="message"></h2>' + '<pre id="details"></pre>';
    panicMessageEl.querySelector('#message').textContent = panicTitle;
    panicMessageEl.querySelector('#details').textContent = panicDetails;
    panicElement.appendChild(panicMessageEl);

    rawPanicMessages.push({
      title: panicTitle,
      details: panicDetails
    });
  }

  function hasPanic() {
    return rawPanicMessages.length !== 0;
  }
  function getPanicText() {
    return rawPanicMessages.map(function (msg) {
      return msg.title;
    }).join(', ');
  }

  function exportTo(namespace, fn) {
    var obj = exportPath(namespace);
    var exports = fn();

    for (var propertyName in exports) {
      // Maybe we should check the prototype chain here? The current usage
      // pattern is always using an object literal so we only care about own
      // properties.
      var propertyDescriptor = Object.getOwnPropertyDescriptor(exports, propertyName);
      if (propertyDescriptor) Object.defineProperty(obj, propertyName, propertyDescriptor);
    }
  };

  /**
   * Initialization which must be deferred until run-time.
   */
  function initialize() {
    if (global.isVinn) {
      tr.isVinn = true;
    } else if (global.process && global.process.versions.node) {
      tr.isNode = true;
    } else {
      tr.isVinn = false;
      tr.isNode = false;
      tr.doc = document;

      tr.isMac = /Mac/.test(navigator.platform);
      tr.isWindows = /Win/.test(navigator.platform);
      tr.isChromeOS = /CrOS/.test(navigator.userAgent);
      tr.isLinux = /Linux/.test(navigator.userAgent);
    }
    tr.isHeadless = tr.isVinn || tr.isNode;
  }

  return {
    initialize: initialize,

    exportTo: exportTo,
    isExported: isExported,
    isDefined: isDefined,

    showPanic: showPanic,
    hasPanic: hasPanic,
    getPanicText: getPanicText
  };
}();

tr.initialize();
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],29:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {

  function Base64() {}

  function b64ToUint6(nChr) {
    if (nChr > 64 && nChr < 91) return nChr - 65;
    if (nChr > 96 && nChr < 123) return nChr - 71;
    if (nChr > 47 && nChr < 58) return nChr + 4;
    if (nChr === 43) return 62;
    if (nChr === 47) return 63;
    return 0;
  }

  Base64.getDecodedBufferLength = function (input) {
    return input.length * 3 + 1 >> 2;
  };

  Base64.EncodeArrayBufferToString = function (input) {
    // http://stackoverflow.com/questions/9267899/
    var binary = '';
    var bytes = new Uint8Array(input);
    var len = bytes.byteLength;
    for (var i = 0; i < len; i++) binary += String.fromCharCode(bytes[i]);
    return btoa(binary);
  };

  Base64.DecodeToTypedArray = function (input, output) {

    var nInLen = input.length;
    var nOutLen = nInLen * 3 + 1 >> 2;
    var nMod3 = 0;
    var nMod4 = 0;
    var nUint24 = 0;
    var nOutIdx = 0;

    if (nOutLen > output.byteLength) throw new Error('Output buffer too small to decode.');

    for (var nInIdx = 0; nInIdx < nInLen; nInIdx++) {
      nMod4 = nInIdx & 3;
      nUint24 |= b64ToUint6(input.charCodeAt(nInIdx)) << 18 - 6 * nMod4;
      if (nMod4 === 3 || nInLen - nInIdx === 1) {
        for (nMod3 = 0; nMod3 < 3 && nOutIdx < nOutLen; nMod3++, nOutIdx++) {
          output.setUint8(nOutIdx, nUint24 >>> (16 >>> nMod3 & 24) & 255);
        }
        nUint24 = 0;
      }
    }
    return nOutIdx - 1;
  };

  /*
   * Wrapper of btoa
   * The reason is that window object has a builtin btoa,
   * but we also want to use btoa when it is headless.
   * For example we want to use it in a mapper
   */
  Base64.btoa = function (input) {
    return btoa(input);
  };

  /*
   * Wrapper of atob
   * The reason is that window object has a builtin atob,
   * but we also want to use atob when it is headless.
   * For example we want to use it in a mapper
   */
  Base64.atob = function (input) {
    return atob(input);
  };

  return {
    Base64: Base64
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],30:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

/**
 * @fileoverview Helper code for working with tracing categories.
 *
 */
global.tr.exportTo('tr.b', function () {

  // Cached values for getCategoryParts.
  var categoryPartsFor = {};

  /**
   * Categories are stored in comma-separated form, e.g: 'a,b' meaning
   * that the event is part of the a and b category.
   *
   * This function returns the category split by string, caching the
   * array for performance.
   *
   * Do not mutate the returned array!!!!
   */
  function getCategoryParts(category) {
    var parts = categoryPartsFor[category];
    if (parts !== undefined) return parts;
    parts = category.split(',');
    categoryPartsFor[category] = parts;
    return parts;
  }

  return {
    getCategoryParts: getCategoryParts
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],31:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  function clamp01(value) {
    return Math.max(0, Math.min(1, value));
  }

  function Color(opt_r, opt_g, opt_b, opt_a) {
    this.r = Math.floor(opt_r) || 0;
    this.g = Math.floor(opt_g) || 0;
    this.b = Math.floor(opt_b) || 0;
    this.a = opt_a;
  }

  Color.fromString = function (str) {
    var tmp;
    var values;
    if (str.substr(0, 4) == 'rgb(') {
      tmp = str.substr(4, str.length - 5);
      values = tmp.split(',').map(function (v) {
        return v.replace(/^\s+/, '', 'g');
      });
      if (values.length != 3) throw new Error('Malformatted rgb-expression');
      return new Color(parseInt(values[0]), parseInt(values[1]), parseInt(values[2]));
    } else if (str.substr(0, 5) == 'rgba(') {
      tmp = str.substr(5, str.length - 6);
      values = tmp.split(',').map(function (v) {
        return v.replace(/^\s+/, '', 'g');
      });
      if (values.length != 4) throw new Error('Malformatted rgb-expression');
      return new Color(parseInt(values[0]), parseInt(values[1]), parseInt(values[2]), parseFloat(values[3]));
    } else if (str[0] == '#' && str.length == 7) {
      return new Color(parseInt(str.substr(1, 2), 16), parseInt(str.substr(3, 2), 16), parseInt(str.substr(5, 2), 16));
    } else {
      throw new Error('Unrecognized string format.');
    }
  };

  Color.lerp = function (a, b, percent) {
    if (a.a !== undefined && b.a !== undefined) return Color.lerpRGBA(a, b, percent);
    return Color.lerpRGB(a, b, percent);
  };

  Color.lerpRGB = function (a, b, percent) {
    return new Color((b.r - a.r) * percent + a.r, (b.g - a.g) * percent + a.g, (b.b - a.b) * percent + a.b);
  };

  Color.lerpRGBA = function (a, b, percent) {
    return new Color((b.r - a.r) * percent + a.r, (b.g - a.g) * percent + a.g, (b.b - a.b) * percent + a.b, (b.a - a.a) * percent + a.a);
  };

  Color.fromDict = function (dict) {
    return new Color(dict.r, dict.g, dict.b, dict.a);
  };

  /**
   * Converts an HSL triplet with alpha to an RGB color.
   * |h| Hue value in [0, 1].
   * |s| Saturation value in [0, 1].
   * |l| Lightness in [0, 1].
   * |a| Alpha in [0, 1]
   */
  Color.fromHSLExplicit = function (h, s, l, a) {
    var r, g, b;
    function hue2rgb(p, q, t) {
      if (t < 0) t += 1;
      if (t > 1) t -= 1;
      if (t < 1 / 6) return p + (q - p) * 6 * t;
      if (t < 1 / 2) return q;
      if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
      return p;
    }

    if (s === 0) {
      r = g = b = l;
    } else {
      var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      var p = 2 * l - q;
      r = hue2rgb(p, q, h + 1 / 3);
      g = hue2rgb(p, q, h);
      b = hue2rgb(p, q, h - 1 / 3);
    }

    return new Color(Math.floor(r * 255), Math.floor(g * 255), Math.floor(b * 255), a);
  };

  Color.fromHSL = function (hsl) {
    return Color.fromHSLExplicit(hsl.h, hsl.s, hsl.l, hsl.a);
  };

  Color.prototype = {
    clone: function () {
      var c = new Color();
      c.r = this.r;
      c.g = this.g;
      c.b = this.b;
      c.a = this.a;
      return c;
    },

    blendOver: function (bgColor) {
      var oneMinusThisAlpha = 1 - this.a;
      var outA = this.a + bgColor.a * oneMinusThisAlpha;
      var bgBlend = bgColor.a * oneMinusThisAlpha / bgColor.a;
      return new Color(this.r * this.a + bgColor.r * bgBlend, this.g * this.a + bgColor.g * bgBlend, this.b * this.a + bgColor.b * bgBlend, outA);
    },

    brighten: function (opt_k) {
      var k;
      k = opt_k || 0.45;

      return new Color(Math.min(255, this.r + Math.floor(this.r * k)), Math.min(255, this.g + Math.floor(this.g * k)), Math.min(255, this.b + Math.floor(this.b * k)), this.a);
    },

    lighten: function (k, opt_maxL) {
      var maxL = opt_maxL !== undefined ? opt_maxL : 1.0;
      var hsl = this.toHSL();
      hsl.l = clamp01(hsl.l + k);
      return Color.fromHSL(hsl);
    },

    darken: function (opt_k) {
      var k;
      if (opt_k !== undefined) k = opt_k;else k = 0.45;

      return new Color(Math.min(255, this.r - Math.floor(this.r * k)), Math.min(255, this.g - Math.floor(this.g * k)), Math.min(255, this.b - Math.floor(this.b * k)), this.a);
    },

    desaturate: function (opt_desaturateFactor) {
      var desaturateFactor;
      if (opt_desaturateFactor !== undefined) desaturateFactor = opt_desaturateFactor;else desaturateFactor = 1;

      var hsl = this.toHSL();
      hsl.s = clamp01(hsl.s * (1 - desaturateFactor));
      return Color.fromHSL(hsl);
    },

    withAlpha: function (a) {
      return new Color(this.r, this.g, this.b, a);
    },

    toString: function () {
      if (this.a !== undefined) {
        return 'rgba(' + this.r + ',' + this.g + ',' + this.b + ',' + this.a + ')';
      }
      return 'rgb(' + this.r + ',' + this.g + ',' + this.b + ')';
    },

    /**
     * Returns a dict {h, s, l, a} with:
     * |h| Hue value in [0, 1].
     * |s| Saturation value in [0, 1].
     * |l| Lightness in [0, 1].
     * |a| Alpha in [0, 1]
     */
    toHSL: function () {
      var r = this.r / 255;
      var g = this.g / 255;
      var b = this.b / 255;

      var max = Math.max(r, g, b);
      var min = Math.min(r, g, b);

      var h, s;
      var l = (max + min) / 2;
      if (min === max) {
        h = 0;
        s = 0;
      } else {
        var delta = max - min;
        if (l > 0.5) s = delta / (2 - max - min);else s = delta / (max + min);

        if (r === max) {
          h = (g - b) / delta;
          if (g < b) h += 6;
        } else if (g === max) {
          h = 2 + (b - r) / delta;
        } else {
          h = 4 + (r - g) / delta;
        }
        h /= 6;
      }

      return { h: h, s: s, l: l, a: this.a };
    },

    toStringWithAlphaOverride: function (alpha) {
      return 'rgba(' + this.r + ',' + this.g + ',' + this.b + ',' + alpha + ')';
    }
  };

  return {
    Color: Color
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],32:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./color.js");
require("./iteration_helpers.js");

'use strict';

/**
 * @fileoverview Provides color scheme related functions.
 */
global.tr.exportTo('tr.b', function () {
  // Basic constants...
  var generalPurposeColors = [new tr.b.Color(122, 98, 135), new tr.b.Color(150, 83, 105), new tr.b.Color(44, 56, 189), new tr.b.Color(99, 86, 147), new tr.b.Color(104, 129, 107), new tr.b.Color(130, 178, 55), new tr.b.Color(87, 109, 147), new tr.b.Color(111, 145, 88), new tr.b.Color(81, 152, 131), new tr.b.Color(142, 91, 111), new tr.b.Color(81, 163, 70), new tr.b.Color(148, 94, 86), new tr.b.Color(144, 89, 118), new tr.b.Color(83, 150, 97), new tr.b.Color(105, 94, 139), new tr.b.Color(89, 144, 122), new tr.b.Color(105, 119, 128), new tr.b.Color(96, 128, 137), new tr.b.Color(145, 88, 145), new tr.b.Color(88, 145, 144), new tr.b.Color(90, 100, 143), new tr.b.Color(121, 97, 136), new tr.b.Color(111, 160, 73), new tr.b.Color(112, 91, 142), new tr.b.Color(86, 147, 86), new tr.b.Color(63, 100, 170), new tr.b.Color(81, 152, 107), new tr.b.Color(60, 164, 173), new tr.b.Color(143, 72, 161), new tr.b.Color(159, 74, 86)];

  var reservedColorsByName = {
    thread_state_uninterruptible: new tr.b.Color(182, 125, 143),
    thread_state_iowait: new tr.b.Color(255, 140, 0),
    thread_state_running: new tr.b.Color(126, 200, 148),
    thread_state_runnable: new tr.b.Color(133, 160, 210),
    thread_state_sleeping: new tr.b.Color(240, 240, 240),
    thread_state_unknown: new tr.b.Color(199, 155, 125),

    background_memory_dump: new tr.b.Color(0, 180, 180),
    light_memory_dump: new tr.b.Color(0, 0, 180),
    detailed_memory_dump: new tr.b.Color(180, 0, 180),

    generic_work: new tr.b.Color(125, 125, 125),

    good: new tr.b.Color(0, 125, 0),
    bad: new tr.b.Color(180, 125, 0),
    terrible: new tr.b.Color(180, 0, 0),

    black: new tr.b.Color(0, 0, 0),

    rail_response: new tr.b.Color(67, 135, 253),
    rail_animation: new tr.b.Color(244, 74, 63),
    rail_idle: new tr.b.Color(238, 142, 0),
    rail_load: new tr.b.Color(13, 168, 97),
    startup: new tr.b.Color(230, 230, 0),

    used_memory_column: new tr.b.Color(0, 0, 255),
    older_used_memory_column: new tr.b.Color(153, 204, 255),
    tracing_memory_column: new tr.b.Color(153, 153, 153),

    heap_dump_stack_frame: new tr.b.Color(128, 128, 128),
    heap_dump_object_type: new tr.b.Color(0, 0, 255),
    heap_dump_child_node_arrow: new tr.b.Color(204, 102, 0),

    cq_build_running: new tr.b.Color(255, 255, 119),
    cq_build_passed: new tr.b.Color(153, 238, 102),
    cq_build_failed: new tr.b.Color(238, 136, 136),
    cq_build_abandoned: new tr.b.Color(187, 187, 187),

    cq_build_attempt_runnig: new tr.b.Color(222, 222, 75),
    cq_build_attempt_passed: new tr.b.Color(103, 218, 35),
    cq_build_attempt_failed: new tr.b.Color(197, 81, 81)
  };

  // Some constants we'll need for later lookups.
  var numGeneralPurposeColorIds = generalPurposeColors.length;
  var numReservedColorIds = tr.b.dictionaryLength(reservedColorsByName);
  var numColorsPerVariant = numGeneralPurposeColorIds + numReservedColorIds;

  function ColorScheme() {}

  /*
   * A flat array of tr.b.Color values of the palette, and their variants.
   *
   * This array is made up of a set of base colors, repeated N times to form
   * a set of variants on that base color.
   *
   * Within the base colors, there are "general purpose" colors,
   * which can be used for random color selection, and
   * reserved colors, which are used when specific colors
   * need to be used, e.g. where red is desired.
   *
   * The variants are automatically generated from the base colors. The 0th
   * variant is the default apeparance of the color, and the varaiants are
   * mutations of that color, e.g. several brightening levels and desaturations.
   *
   * For example, a very simple version of this array looks like the following:
   *     0: Generic Color 0
   *     1: Generic Color 1
   *     2: Named Color 'foo'
   *     3: Brightened Generic Color 0
   *     4: Brightened Generic Color 1
   *     5: Brightened Named Color 'foo'
   */
  var paletteBase = [];
  paletteBase.push.apply(paletteBase, generalPurposeColors);
  paletteBase.push.apply(paletteBase, tr.b.dictionaryValues(reservedColorsByName));
  ColorScheme.colors = [];
  ColorScheme.properties = {};
  ColorScheme.properties = {
    numColorsPerVariant: numColorsPerVariant
  };

  function pushVariant(func) {
    var variantColors = paletteBase.map(func);
    ColorScheme.colors.push.apply(ColorScheme.colors, variantColors);
  }

  // Basic colors.
  pushVariant(function (c) {
    return c;
  });

  // Brightened variants.
  ColorScheme.properties.brightenedOffsets = [];
  ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.lighten(0.3, 0.9);
  });

  ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.lighten(0.48, 0.9);
  });

  ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.lighten(0.65, 0.9);
  });

  // Desaturated variants.
  ColorScheme.properties.dimmedOffsets = [];
  ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.desaturate();
  });
  ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.desaturate(0.5);
  });
  ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);
  pushVariant(function (c) {
    return c.desaturate(0.3);
  });

  /**
   * A toString'd representation of ColorScheme.colors.
   */
  ColorScheme.colorsAsStrings = ColorScheme.colors.map(function (c) {
    return c.toString();
  });

  // Build reservedColorNameToIdMap.
  var reservedColorNameToIdMap = function () {
    var m = new Map();
    var i = generalPurposeColors.length;
    tr.b.iterItems(reservedColorsByName, function (key, value) {
      m.set(key, i++);
    });
    return m;
  }();

  /**
   * @param {String} name The color name.
   * @return {Number} The color ID for the given color name.
   */
  ColorScheme.getColorIdForReservedName = function (name) {
    var id = reservedColorNameToIdMap.get(name);
    if (id === undefined) throw new Error('Unrecognized color ') + name;
    return id;
  };

  ColorScheme.getColorForReservedNameAsString = function (reservedName) {
    var id = ColorScheme.getColorIdForReservedName(reservedName);
    return ColorScheme.colorsAsStrings[id];
  };

  /**
   * Computes a simplistic hashcode of the provide name. Used to chose colors
   * for slices.
   * @param {string} name The string to hash.
   */
  ColorScheme.getStringHash = function (name) {
    var hash = 0;
    for (var i = 0; i < name.length; ++i) hash = (hash + 37 * hash + 11 * name.charCodeAt(i)) % 0xFFFFFFFF;
    return hash;
  };

  // Previously computed string color IDs. They are based on a stable hash, so
  // it is safe to save them throughout the program time.
  var stringColorIdCache = new Map();

  /**
   * @return {Number} A color ID that is stably associated to the provided via
   * the getStringHash method. The color ID will be chosen from the general
   * purpose ID space only, e.g. no reserved ID will be used.
   */
  ColorScheme.getColorIdForGeneralPurposeString = function (string) {
    if (stringColorIdCache.get(string) === undefined) {
      var hash = ColorScheme.getStringHash(string);
      stringColorIdCache.set(string, hash % numGeneralPurposeColorIds);
    }
    return stringColorIdCache.get(string);
  };

  return {
    ColorScheme: ColorScheme
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./color.js":31,"./iteration_helpers.js":41}],33:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./event_target.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var Event;
  if (tr.isHeadless) {
    /**
     * Creates a new event to be used with tr.b.EventTarget or DOM EventTarget
     * objects.
     * @param {string} type The name of the event.
     * @param {boolean=} opt_bubbles Whether the event bubbles.
     *     Default is false.
     * @param {boolean=} opt_preventable Whether the default action of the event
     *     can be prevented.
     * @constructor
     * @extends {Event}
     */
    function HeadlessEvent(type, opt_bubbles, opt_preventable) {
      this.type = type;
      this.bubbles = opt_bubbles !== undefined ? !!opt_bubbles : false;
      this.cancelable = opt_preventable !== undefined ? !!opt_preventable : false;

      this.defaultPrevented = false;
      this.cancelBubble = false;
    };

    HeadlessEvent.prototype = {
      preventDefault: function () {
        this.defaultPrevented = true;
      },

      stopPropagation: function () {
        this.cancelBubble = true;
      }
    };
    Event = HeadlessEvent;
  } else {
    /**
     * Creates a new event to be used with tr.b.EventTarget or DOM EventTarget
     * objects.
     * @param {string} type The name of the event.
     * @param {boolean=} opt_bubbles Whether the event bubbles.
     *     Default is false.
     * @param {boolean=} opt_preventable Whether the default action of the event
     *     can be prevented.
     * @constructor
     * @extends {Event}
     */
    function TrEvent(type, opt_bubbles, opt_preventable) {
      var e = tr.doc.createEvent('Event');
      e.initEvent(type, !!opt_bubbles, !!opt_preventable);
      e.__proto__ = global.Event.prototype;
      return e;
    };

    TrEvent.prototype = {
      __proto__: global.Event.prototype
    };
    Event = TrEvent;
  }

  /**
   * Dispatches a simple event on an event target.
   * @param {!EventTarget} target The event target to dispatch the event on.
   * @param {string} type The type of the event.
   * @param {boolean=} opt_bubbles Whether the event bubbles or not.
   * @param {boolean=} opt_cancelable Whether the default action of the event
   *     can be prevented.
   * @param {!Object=} opt_fields
   *
   * @return {boolean} If any of the listeners called {@code preventDefault}
   *     during the dispatch this will return false.
   */
  function dispatchSimpleEvent(target, type, opt_bubbles, opt_cancelable, opt_fields) {
    var e = new tr.b.Event(type, opt_bubbles, opt_cancelable);
    if (opt_fields) {
      tr.b.iterItems(opt_fields, function (name, value) {
        e[name] = value;
      });
    }
    return target.dispatchEvent(e);
  }

  return {
    Event: Event,
    dispatchSimpleEvent: dispatchSimpleEvent
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./event_target.js":34}],34:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

/**
 * @fileoverview This contains an implementation of the EventTarget interface
 * as defined by DOM Level 2 Events.
 */
global.tr.exportTo('tr.b', function () {

  /**
   * Creates a new EventTarget. This class implements the DOM level 2
   * EventTarget interface and can be used wherever those are used.
   * @constructor
   */
  function EventTarget() {}
  EventTarget.decorate = function (target) {
    for (var k in EventTarget.prototype) {
      if (k == 'decorate') continue;
      var v = EventTarget.prototype[k];
      if (typeof v !== 'function') continue;
      target[k] = v;
    }
  };

  EventTarget.prototype = {

    /**
     * Adds an event listener to the target.
     * @param {string} type The name of the event.
     * @param {!Function|{handleEvent:Function}} handler The handler for the
     *     event. This is called when the event is dispatched.
     */
    addEventListener: function (type, handler) {
      if (!this.listeners_) this.listeners_ = Object.create(null);
      if (!(type in this.listeners_)) {
        this.listeners_[type] = [handler];
      } else {
        var handlers = this.listeners_[type];
        if (handlers.indexOf(handler) < 0) handlers.push(handler);
      }
    },

    /**
     * Removes an event listener from the target.
     * @param {string} type The name of the event.
     * @param {!Function|{handleEvent:Function}} handler The handler for the
     *     event.
     */
    removeEventListener: function (type, handler) {
      if (!this.listeners_) return;
      if (type in this.listeners_) {
        var handlers = this.listeners_[type];
        var index = handlers.indexOf(handler);
        if (index >= 0) {
          // Clean up if this was the last listener.
          if (handlers.length == 1) delete this.listeners_[type];else handlers.splice(index, 1);
        }
      }
    },

    /**
     * Dispatches an event and calls all the listeners that are listening to
     * the type of the event.
     * @param {!cr.event.Event} event The event to dispatch.
     * @return {boolean} Whether the default action was prevented. If someone
     *     calls preventDefault on the event object then this returns false.
     */
    dispatchEvent: function (event) {
      if (!this.listeners_) return true;

      // Since we are using DOM Event objects we need to override some of the
      // properties and methods so that we can emulate this correctly.
      var self = this;
      event.__defineGetter__('target', function () {
        return self;
      });
      var realPreventDefault = event.preventDefault;
      event.preventDefault = function () {
        realPreventDefault.call(this);
        this.rawReturnValue = false;
      };

      var type = event.type;
      var prevented = 0;
      if (type in this.listeners_) {
        // Clone to prevent removal during dispatch
        var handlers = this.listeners_[type].concat();
        for (var i = 0, handler; handler = handlers[i]; i++) {
          if (handler.handleEvent) prevented |= handler.handleEvent.call(handler, event) === false;else prevented |= handler.call(this, event) === false;
        }
      }

      return !prevented && event.rawReturnValue;
    },

    hasEventListener: function (type) {
      return this.listeners_[type] !== undefined;
    }
  };

  var EventTargetHelper = {
    decorate: function (target) {
      for (var k in EventTargetHelper) {
        if (k == 'decorate') continue;
        var v = EventTargetHelper[k];
        if (typeof v !== 'function') continue;
        target[k] = v;
      }
      target.listenerCounts_ = {};
    },

    addEventListener: function (type, listener, useCapture) {
      this.__proto__.addEventListener.call(this, type, listener, useCapture);
      if (this.listenerCounts_[type] === undefined) this.listenerCounts_[type] = 0;
      this.listenerCounts_[type]++;
    },

    removeEventListener: function (type, listener, useCapture) {
      this.__proto__.removeEventListener.call(this, type, listener, useCapture);
      this.listenerCounts_[type]--;
    },

    hasEventListener: function (type) {
      return this.listenerCounts_[type] > 0;
    }
  };

  // Export
  return {
    EventTarget: EventTarget,
    EventTargetHelper: EventTargetHelper
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],35:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./event_target.js");
require("./extension_registry_base.js");
require("./extension_registry_basic.js");
require("./extension_registry_type_based.js");
require("./iteration_helpers.js");

'use strict';

/**
 * @fileoverview Helper code for defining extension registries, which can be
 * used to make a part of trace-viewer extensible.
 *
 * This file provides two basic types of extension registries:
 * - Generic: register a type with metadata, query for those types based on
 *            a predicate
 *
 * - TypeName-based: register a type that handles some combination
 *                   of tracing categories or typeNames, then query
 *                   for it based on a category, typeName or both.
 *
 * When you register subtypes, you pass the constructor for the
 * subtype, and any metadata you want associated with the subtype. Use metadata
 * instead of stuffing fields onto the constructor. E.g.:
 *     registry.register(MySubclass, {titleWhenShownInTabStrip: 'MySub'})
 *
 * Some registries want a default object that is returned when a more precise
 * subtype has been registered. To provide one, set the defaultConstructor
 * option on the registry options.
 *
 * TODO: Extension registry used to make reference to mandatoryBaseType but it
 * was never enforced. We may want to add it back in the future in order to
 * enforce the types that can be put into a given registry.
 */
global.tr.exportTo('tr.b', function () {

  function decorateExtensionRegistry(registry, registryOptions) {
    if (registry.register) throw new Error('Already has registry');

    registryOptions.freeze();
    if (registryOptions.mode == tr.b.BASIC_REGISTRY_MODE) {
      tr.b._decorateBasicExtensionRegistry(registry, registryOptions);
    } else if (registryOptions.mode == tr.b.TYPE_BASED_REGISTRY_MODE) {
      tr.b._decorateTypeBasedExtensionRegistry(registry, registryOptions);
    } else {
      throw new Error('Unrecognized mode');
    }

    // Make it an event target.
    if (registry.addEventListener === undefined) tr.b.EventTarget.decorate(registry);
  }

  return {
    decorateExtensionRegistry: decorateExtensionRegistry
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./event_target.js":34,"./extension_registry_base.js":36,"./extension_registry_basic.js":37,"./extension_registry_type_based.js":38,"./iteration_helpers.js":41}],36:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  function RegisteredTypeInfo(constructor, metadata) {
    this.constructor = constructor;
    this.metadata = metadata;
  };

  var BASIC_REGISTRY_MODE = 'BASIC_REGISTRY_MODE';
  var TYPE_BASED_REGISTRY_MODE = 'TYPE_BASED_REGISTRY_MODE';
  var ALL_MODES = { BASIC_REGISTRY_MODE: true, TYPE_BASED_REGISTRY_MODE: true };

  function ExtensionRegistryOptions(mode) {
    if (mode === undefined) throw new Error('Mode is required');
    if (!ALL_MODES[mode]) throw new Error('Not a mode.');

    this.mode_ = mode;
    this.defaultMetadata_ = {};
    this.defaultConstructor_ = undefined;
    this.defaultTypeInfo_ = undefined;
    this.frozen_ = false;
  }
  ExtensionRegistryOptions.prototype = {
    freeze: function () {
      if (this.frozen_) throw new Error('Frozen');
      this.frozen_ = true;
    },

    get mode() {
      return this.mode_;
    },

    get defaultMetadata() {
      return this.defaultMetadata_;
    },

    set defaultMetadata(defaultMetadata) {
      if (this.frozen_) throw new Error('Frozen');
      this.defaultMetadata_ = defaultMetadata;
      this.defaultTypeInfo_ = undefined;
    },

    get defaultConstructor() {
      return this.defaultConstructor_;
    },

    set defaultConstructor(defaultConstructor) {
      if (this.frozen_) throw new Error('Frozen');
      this.defaultConstructor_ = defaultConstructor;
      this.defaultTypeInfo_ = undefined;
    },

    get defaultTypeInfo() {
      if (this.defaultTypeInfo_ === undefined && this.defaultConstructor_) {
        this.defaultTypeInfo_ = new RegisteredTypeInfo(this.defaultConstructor, this.defaultMetadata);
      }
      return this.defaultTypeInfo_;
    },

    validateConstructor: function (constructor) {
      if (!this.mandatoryBaseClass) return;
      var curProto = constructor.prototype.__proto__;
      var ok = false;
      while (curProto) {
        if (curProto === this.mandatoryBaseClass.prototype) {
          ok = true;
          break;
        }
        curProto = curProto.__proto__;
      }
      if (!ok) throw new Error(constructor + 'must be subclass of ' + registry);
    }
  };

  return {
    BASIC_REGISTRY_MODE: BASIC_REGISTRY_MODE,
    TYPE_BASED_REGISTRY_MODE: TYPE_BASED_REGISTRY_MODE,

    ExtensionRegistryOptions: ExtensionRegistryOptions,
    RegisteredTypeInfo: RegisteredTypeInfo
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],37:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./event.js");
require("./extension_registry_base.js");

'use strict';

global.tr.exportTo('tr.b', function () {

  var RegisteredTypeInfo = tr.b.RegisteredTypeInfo;
  var ExtensionRegistryOptions = tr.b.ExtensionRegistryOptions;

  function decorateBasicExtensionRegistry(registry, extensionRegistryOptions) {
    var savedStateStack = [];
    registry.registeredTypeInfos_ = [];

    registry.register = function (constructor, opt_metadata) {
      if (registry.findIndexOfRegisteredConstructor(constructor) !== undefined) throw new Error('Handler already registered for ' + constructor);

      extensionRegistryOptions.validateConstructor(constructor);

      var metadata = {};
      for (var k in extensionRegistryOptions.defaultMetadata) metadata[k] = extensionRegistryOptions.defaultMetadata[k];
      if (opt_metadata) {
        for (var k in opt_metadata) metadata[k] = opt_metadata[k];
      }

      var typeInfo = new RegisteredTypeInfo(constructor, metadata);

      var e = new tr.b.Event('will-register');
      e.typeInfo = typeInfo;
      registry.dispatchEvent(e);

      registry.registeredTypeInfos_.push(typeInfo);

      e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.pushCleanStateBeforeTest = function () {
      savedStateStack.push(registry.registeredTypeInfos_);
      registry.registeredTypeInfos_ = [];

      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };
    registry.popCleanStateAfterTest = function () {
      registry.registeredTypeInfos_ = savedStateStack[0];
      savedStateStack.splice(0, 1);

      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.findIndexOfRegisteredConstructor = function (constructor) {
      for (var i = 0; i < registry.registeredTypeInfos_.length; i++) if (registry.registeredTypeInfos_[i].constructor == constructor) return i;
      return undefined;
    };

    registry.unregister = function (constructor) {
      var foundIndex = registry.findIndexOfRegisteredConstructor(constructor);
      if (foundIndex === undefined) throw new Error(constructor + ' not registered');
      registry.registeredTypeInfos_.splice(foundIndex, 1);

      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.getAllRegisteredTypeInfos = function () {
      return registry.registeredTypeInfos_;
    };

    registry.findTypeInfo = function (constructor) {
      var foundIndex = this.findIndexOfRegisteredConstructor(constructor);
      if (foundIndex !== undefined) return this.registeredTypeInfos_[foundIndex];
      return undefined;
    };

    registry.findTypeInfoMatching = function (predicate, opt_this) {
      opt_this = opt_this ? opt_this : undefined;
      for (var i = 0; i < registry.registeredTypeInfos_.length; ++i) {
        var typeInfo = registry.registeredTypeInfos_[i];
        if (predicate.call(opt_this, typeInfo)) return typeInfo;
      }
      return extensionRegistryOptions.defaultTypeInfo;
    };

    registry.findTypeInfoWithName = function (name) {
      if (typeof name !== 'string') throw new Error('Name is not a string.');
      var typeInfo = registry.findTypeInfoMatching(function (ti) {
        return ti.constructor.name === name;
      });
      if (typeInfo) return typeInfo;
      return undefined;
    };
  }

  return {
    _decorateBasicExtensionRegistry: decorateBasicExtensionRegistry
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./event.js":33,"./extension_registry_base.js":36}],38:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./category_util.js");
require("./event.js");
require("./extension_registry_base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var getCategoryParts = tr.b.getCategoryParts;

  var RegisteredTypeInfo = tr.b.RegisteredTypeInfo;
  var ExtensionRegistryOptions = tr.b.ExtensionRegistryOptions;

  function decorateTypeBasedExtensionRegistry(registry, extensionRegistryOptions) {
    var savedStateStack = [];

    registry.registeredTypeInfos_ = [];

    registry.categoryPartToTypeInfoMap_ = new Map();
    registry.typeNameToTypeInfoMap_ = new Map();

    registry.register = function (constructor, metadata) {

      extensionRegistryOptions.validateConstructor(constructor);

      var typeInfo = new RegisteredTypeInfo(constructor, metadata || extensionRegistryOptions.defaultMetadata);

      typeInfo.typeNames = [];
      typeInfo.categoryParts = [];
      if (metadata && metadata.typeName) typeInfo.typeNames.push(metadata.typeName);
      if (metadata && metadata.typeNames) {
        typeInfo.typeNames.push.apply(typeInfo.typeNames, metadata.typeNames);
      }
      if (metadata && metadata.categoryParts) {
        typeInfo.categoryParts.push.apply(typeInfo.categoryParts, metadata.categoryParts);
      }

      if (typeInfo.typeNames.length === 0 && typeInfo.categoryParts.length === 0) throw new Error('typeName or typeNames must be provided');

      // Sanity checks...
      typeInfo.typeNames.forEach(function (typeName) {
        if (registry.typeNameToTypeInfoMap_.has(typeName)) throw new Error('typeName ' + typeName + ' already registered');
      });
      typeInfo.categoryParts.forEach(function (categoryPart) {
        if (registry.categoryPartToTypeInfoMap_.has(categoryPart)) {
          throw new Error('categoryPart ' + categoryPart + ' already registered');
        }
      });

      var e = new tr.b.Event('will-register');
      e.typeInfo = typeInfo;
      registry.dispatchEvent(e);

      // Actual registration.
      typeInfo.typeNames.forEach(function (typeName) {
        registry.typeNameToTypeInfoMap_.set(typeName, typeInfo);
      });
      typeInfo.categoryParts.forEach(function (categoryPart) {
        registry.categoryPartToTypeInfoMap_.set(categoryPart, typeInfo);
      });
      registry.registeredTypeInfos_.push(typeInfo);

      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.pushCleanStateBeforeTest = function () {
      savedStateStack.push({
        registeredTypeInfos: registry.registeredTypeInfos_,
        typeNameToTypeInfoMap: registry.typeNameToTypeInfoMap_,
        categoryPartToTypeInfoMap: registry.categoryPartToTypeInfoMap_
      });
      registry.registeredTypeInfos_ = [];
      registry.typeNameToTypeInfoMap_ = new Map();
      registry.categoryPartToTypeInfoMap_ = new Map();
      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.popCleanStateAfterTest = function () {
      var state = savedStateStack[0];
      savedStateStack.splice(0, 1);

      registry.registeredTypeInfos_ = state.registeredTypeInfos;
      registry.typeNameToTypeInfoMap_ = state.typeNameToTypeInfoMap;
      registry.categoryPartToTypeInfoMap_ = state.categoryPartToTypeInfoMap;
      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.unregister = function (constructor) {
      var typeInfoIndex = -1;
      for (var i = 0; i < registry.registeredTypeInfos_.length; i++) {
        if (registry.registeredTypeInfos_[i].constructor == constructor) {
          typeInfoIndex = i;
          break;
        }
      }
      if (typeInfoIndex === -1) throw new Error(constructor + ' not registered');

      var typeInfo = registry.registeredTypeInfos_[typeInfoIndex];
      registry.registeredTypeInfos_.splice(typeInfoIndex, 1);
      typeInfo.typeNames.forEach(function (typeName) {
        registry.typeNameToTypeInfoMap_.delete(typeName);
      });
      typeInfo.categoryParts.forEach(function (categoryPart) {
        registry.categoryPartToTypeInfoMap_.delete(categoryPart);
      });
      var e = new tr.b.Event('registry-changed');
      registry.dispatchEvent(e);
    };

    registry.getTypeInfo = function (category, typeName) {
      if (category) {
        var categoryParts = getCategoryParts(category);
        for (var i = 0; i < categoryParts.length; i++) {
          var categoryPart = categoryParts[i];
          var typeInfo = registry.categoryPartToTypeInfoMap_.get(categoryPart);
          if (typeInfo !== undefined) return typeInfo;
        }
      }
      var typeInfo = registry.typeNameToTypeInfoMap_.get(typeName);
      if (typeInfo !== undefined) return typeInfo;

      return extensionRegistryOptions.defaultTypeInfo;
    };

    // TODO(nduca): Remove or rename.
    registry.getConstructor = function (category, typeName) {
      var typeInfo = registry.getTypeInfo(category, typeName);
      if (typeInfo) return typeInfo.constructor;
      return undefined;
    };
  }

  return {
    _decorateTypeBasedExtensionRegistry: decorateTypeBasedExtensionRegistry
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./category_util.js":30,"./event.js":33,"./extension_registry_base.js":36}],39:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var nextGUID = 1;

  var UUID4_PATTERN = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx';

  var GUID = {
    /* Allocate an integer GUID.
     *
     * These GUIDs are not unique between loads, but are fast to generate, and
     * consume very little memory.
     *
     * @return {number} globally unique id.
     */
    allocateSimple: function () {
      return nextGUID++;
    },

    /* Return the last GUID allocated without allocating a new one.
     *
     * @return {number} last guid.
     */
    getLastSimpleGuid: function () {
      return nextGUID - 1;
    },

    /* Generate a random string UUID.
     *
     * Version 4 random UUIDs are practically guaranteed to be unique between
     * loads, so they can be serialized and compared with results from other
     * loads. These are slower to generate and consume more memory than simple
     * GUIDs.
     *
     * @return {string} universally unique id.
     */
    allocateUUID4: function () {
      return UUID4_PATTERN.replace(/[xy]/g, function (c) {
        var r = parseInt(Math.random() * 16);
        if (c === 'y') r = (r & 3) + 8;
        return r.toString(16);
      });
    }
  };

  return {
    GUID: GUID
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],40:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  function max(a, b) {
    if (a === undefined) return b;
    if (b === undefined) return a;
    return Math.max(a, b);
  }

  /**
   * This class implements an interval tree.
   *    See: http://wikipedia.org/wiki/Interval_tree
   *
   * Internally the tree is a Red-Black tree. The insertion/colour is done using
   * the Left-leaning Red-Black Trees algorithm as described in:
   *       http://www.cs.princeton.edu/~rs/talks/LLRB/LLRB.pdf
   *
   * @param {function} beginPositionCb Callback to retrieve the begin position.
   * @param {function} endPositionCb Callback to retrieve the end position.
   *
   * @constructor
   */
  function IntervalTree(beginPositionCb, endPositionCb) {
    this.beginPositionCb_ = beginPositionCb;
    this.endPositionCb_ = endPositionCb;

    this.root_ = undefined;
    this.size_ = 0;
  }

  IntervalTree.prototype = {
    /**
     * Insert events into the interval tree.
     *
     * @param {Object} datum The object to insert.
     */
    insert: function (datum) {
      var startPosition = this.beginPositionCb_(datum);
      var endPosition = this.endPositionCb_(datum);

      var node = new IntervalTreeNode(datum, startPosition, endPosition);
      this.size_++;

      this.root_ = this.insertNode_(this.root_, node);
      this.root_.colour = Colour.BLACK;
      return datum;
    },

    insertNode_: function (root, node) {
      if (root === undefined) return node;

      if (root.leftNode && root.leftNode.isRed && root.rightNode && root.rightNode.isRed) this.flipNodeColour_(root);

      if (node.key < root.key) root.leftNode = this.insertNode_(root.leftNode, node);else if (node.key === root.key) root.merge(node);else root.rightNode = this.insertNode_(root.rightNode, node);

      if (root.rightNode && root.rightNode.isRed && (root.leftNode === undefined || !root.leftNode.isRed)) root = this.rotateLeft_(root);

      if (root.leftNode && root.leftNode.isRed && root.leftNode.leftNode && root.leftNode.leftNode.isRed) root = this.rotateRight_(root);

      return root;
    },

    rotateRight_: function (node) {
      var sibling = node.leftNode;
      node.leftNode = sibling.rightNode;
      sibling.rightNode = node;
      sibling.colour = node.colour;
      node.colour = Colour.RED;
      return sibling;
    },

    rotateLeft_: function (node) {
      var sibling = node.rightNode;
      node.rightNode = sibling.leftNode;
      sibling.leftNode = node;
      sibling.colour = node.colour;
      node.colour = Colour.RED;
      return sibling;
    },

    flipNodeColour_: function (node) {
      node.colour = this.flipColour_(node.colour);
      node.leftNode.colour = this.flipColour_(node.leftNode.colour);
      node.rightNode.colour = this.flipColour_(node.rightNode.colour);
    },

    flipColour_: function (colour) {
      return colour === Colour.RED ? Colour.BLACK : Colour.RED;
    },

    /* The high values are used to find intersection. It should be called after
     * all of the nodes are inserted. Doing it each insert is _slow_. */
    updateHighValues: function () {
      this.updateHighValues_(this.root_);
    },

    /* There is probably a smarter way to do this by starting from the inserted
     * node, but need to handle the rotations correctly. Went the easy route
     * for now. */
    updateHighValues_: function (node) {
      if (node === undefined) return undefined;

      node.maxHighLeft = this.updateHighValues_(node.leftNode);
      node.maxHighRight = this.updateHighValues_(node.rightNode);

      return max(max(node.maxHighLeft, node.highValue), node.maxHighRight);
    },

    validateFindArguments_: function (queryLow, queryHigh) {
      if (queryLow === undefined || queryHigh === undefined) throw new Error('queryLow and queryHigh must be defined');
      if (typeof queryLow !== 'number' || typeof queryHigh !== 'number') throw new Error('queryLow and queryHigh must be numbers');
    },

    /**
     * Retrieve all overlapping intervals.
     *
     * @param {number} queryLow The low value for the intersection interval.
     * @param {number} queryHigh The high value for the intersection interval.
     * @return {Array} All [begin, end] pairs inside intersecting intervals.
     */
    findIntersection: function (queryLow, queryHigh) {
      this.validateFindArguments_(queryLow, queryHigh);
      if (this.root_ === undefined) return [];

      var ret = [];
      this.root_.appendIntersectionsInto_(ret, queryLow, queryHigh);
      return ret;
    },

    /**
     * Returns the number of nodes in the tree.
     */
    get size() {
      return this.size_;
    },

    /**
     * Returns the root node in the tree.
     */
    get root() {
      return this.root_;
    },

    /**
     * Dumps out the [lowValue, highValue] pairs for each node in depth-first
     * order.
     */
    dump_: function () {
      if (this.root_ === undefined) return [];
      return this.root_.dump();
    }
  };

  var Colour = {
    RED: 'red',
    BLACK: 'black'
  };

  function IntervalTreeNode(datum, lowValue, highValue) {
    this.lowValue_ = lowValue;

    this.data_ = [{
      datum: datum,
      high: highValue,
      low: lowValue
    }];

    this.colour_ = Colour.RED;

    this.parentNode_ = undefined;
    this.leftNode_ = undefined;
    this.rightNode_ = undefined;

    this.maxHighLeft_ = undefined;
    this.maxHighRight_ = undefined;
  }

  IntervalTreeNode.prototype = {
    appendIntersectionsInto_: function (ret, queryLow, queryHigh) {
      /* This node starts has a start point at or further right then queryHigh
       * so we know this node is out and all right children are out. Just need
       * to check left */
      if (this.lowValue_ >= queryHigh) {
        if (!this.leftNode_) return;
        return this.leftNode_.appendIntersectionsInto_(ret, queryLow, queryHigh);
      }

      /* If we have a maximum left high value that is bigger then queryLow we
       * need to check left for matches */
      if (this.maxHighLeft_ > queryLow) {
        this.leftNode_.appendIntersectionsInto_(ret, queryLow, queryHigh);
      }

      /* We know that this node starts before queryHigh, if any of it's data
       * ends after queryLow we need to add those nodes */
      if (this.highValue > queryLow) {
        for (var i = this.data.length - 1; i >= 0; --i) {
          /* data nodes are sorted by high value, so as soon as we see one
           * before low value we're done. */
          if (this.data[i].high < queryLow) break;

          ret.push(this.data[i].datum);
        }
      }

      /* check for matches in the right tree */
      if (this.rightNode_) {
        this.rightNode_.appendIntersectionsInto_(ret, queryLow, queryHigh);
      }
    },

    get colour() {
      return this.colour_;
    },

    set colour(colour) {
      this.colour_ = colour;
    },

    get key() {
      return this.lowValue_;
    },

    get lowValue() {
      return this.lowValue_;
    },

    get highValue() {
      return this.data_[this.data_.length - 1].high;
    },

    set leftNode(left) {
      this.leftNode_ = left;
    },

    get leftNode() {
      return this.leftNode_;
    },

    get hasLeftNode() {
      return this.leftNode_ !== undefined;
    },

    set rightNode(right) {
      this.rightNode_ = right;
    },

    get rightNode() {
      return this.rightNode_;
    },

    get hasRightNode() {
      return this.rightNode_ !== undefined;
    },

    set parentNode(parent) {
      this.parentNode_ = parent;
    },

    get parentNode() {
      return this.parentNode_;
    },

    get isRootNode() {
      return this.parentNode_ === undefined;
    },

    set maxHighLeft(high) {
      this.maxHighLeft_ = high;
    },

    get maxHighLeft() {
      return this.maxHighLeft_;
    },

    set maxHighRight(high) {
      this.maxHighRight_ = high;
    },

    get maxHighRight() {
      return this.maxHighRight_;
    },

    get data() {
      return this.data_;
    },

    get isRed() {
      return this.colour_ === Colour.RED;
    },

    merge: function (node) {
      for (var i = 0; i < node.data.length; i++) this.data_.push(node.data[i]);
      this.data_.sort(function (a, b) {
        return a.high - b.high;
      });
    },

    dump: function () {
      var ret = {};
      if (this.leftNode_) ret['left'] = this.leftNode_.dump();

      ret['data'] = this.data_.map(function (d) {
        return [d.low, d.high];
      });

      if (this.rightNode_) ret['right'] = this.rightNode_.dump();

      return ret;
    }
  };

  return {
    IntervalTree: IntervalTree
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],41:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {

  /**
   * Converts any object which is either (a) an iterable, or (b) an
   * "array-ish" object (has length property and can be indexed into)
   * into an array.
   */
  function asArray(x) {
    var values = [];
    if (x[Symbol.iterator]) for (var value of x) values.push(value);else for (var i = 0; i < x.length; i++) values.push(x[i]);
    return values;
  }

  /**
   * Returns the only element in the iterable. If the iterable is empty or has
   * more than one element, an error is thrown.
   */
  function getOnlyElement(iterable) {
    var iterator = iterable[Symbol.iterator]();

    var firstIteration = iterator.next();
    if (firstIteration.done) throw new Error('getOnlyElement was passed an empty iterable.');

    var secondIteration = iterator.next();
    if (!secondIteration.done) throw new Error('getOnlyElement was passed an iterable with multiple elements.');

    return firstIteration.value;
  }

  /**
   * Returns the first element in the iterable. If the iterable is empty, an
   * error is thrown.
   */
  function getFirstElement(iterable) {
    var iterator = iterable[Symbol.iterator]();
    var result = iterator.next();
    if (result.done) throw new Error('getFirstElement was passed an empty iterable.');

    return result.value;
  }

  function compareArrays(x, y, elementCmp) {
    var minLength = Math.min(x.length, y.length);
    for (var i = 0; i < minLength; i++) {
      var tmp = elementCmp(x[i], y[i]);
      if (tmp) return tmp;
    }
    if (x.length == y.length) return 0;

    if (x[i] === undefined) return -1;

    return 1;
  }

  /**
   * Compares two values when one or both might be undefined. Undefined
   * values are sorted after defined.
   */
  function comparePossiblyUndefinedValues(x, y, cmp, opt_this) {
    if (x !== undefined && y !== undefined) return cmp.call(opt_this, x, y);
    if (x !== undefined) return -1;
    if (y !== undefined) return 1;
    return 0;
  }

  /**
   * Compares two numeric values when one or both might be undefined or NaNs.
   * Undefined / NaN values are sorted after others.
   */
  function compareNumericWithNaNs(x, y) {
    if (!isNaN(x) && !isNaN(y)) return x - y;
    if (isNaN(x)) return 1;
    if (isNaN(y)) return -1;
    return 0;
  }

  function concatenateArrays() /*arguments*/{
    var values = [];
    for (var i = 0; i < arguments.length; i++) {
      if (!(arguments[i] instanceof Array)) throw new Error('Arguments ' + i + 'is not an array');
      values.push.apply(values, arguments[i]);
    }
    return values;
  }

  function concatenateObjects() /*arguments*/{
    var result = {};
    for (var i = 0; i < arguments.length; i++) {
      var object = arguments[i];
      for (var j in object) {
        result[j] = object[j];
      }
    }
    return result;
  }

  function cloneDictionary(dict) {
    var clone = {};
    for (var k in dict) {
      clone[k] = dict[k];
    }
    return clone;
  }

  function dictionaryKeys(dict) {
    var keys = [];
    for (var key in dict) keys.push(key);
    return keys;
  }

  function dictionaryValues(dict) {
    var values = [];
    for (var key in dict) values.push(dict[key]);
    return values;
  }

  function dictionaryLength(dict) {
    var n = 0;
    for (var key in dict) n++;
    return n;
  }

  function dictionaryContainsValue(dict, value) {
    for (var key in dict) if (dict[key] === value) return true;
    return false;
  }

  /**
   * Returns true if all the elements of the iterable pass the predicate.
   */
  function every(iterable, predicate) {
    for (var x of iterable) if (!predicate(x)) return false;
    return true;
  }

  /**
   * Returns a new dictionary with items grouped by the return value of the
   * specified function being called on each item.
   * @param {!Array.<!*>} ary The array being iterated through
   * @param {!function(!*):!*} callback The mapping function between the array
   * value and the map key.
   * @param {*=} opt_this
   */
  function group(ary, callback, opt_this, opt_arrayConstructor) {
    var arrayConstructor = opt_arrayConstructor || Array;
    var results = {};
    for (var element of ary) {
      var key = callback.call(opt_this, element);
      if (!(key in results)) results[key] = new arrayConstructor();
      results[key].push(element);
    }
    return results;
  }

  /**
   * Returns a new Map with items grouped by the return value of the
   * specified function being called on each item.
   * @param {!Array.<!*>} ary The array being iterated through
   * @param {!function(!*):!*} callback The mapping function between the array
   * value and the map key.
   * @param {*=} opt_this
   */
  function groupIntoMap(ary, callback, opt_this, opt_arrayConstructor) {
    var arrayConstructor = opt_arrayConstructor || Array;
    var results = new Map();
    for (var element of ary) {
      var key = callback.call(opt_this, element);
      var items = results.get(key);
      if (items === undefined) {
        items = new arrayConstructor();
        results.set(key, items);
      }
      items.push(element);
    }
    return results;
  }

  function iterItems(dict, fn, opt_this) {
    opt_this = opt_this || this;
    var keys = Object.keys(dict);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      fn.call(opt_this, key, dict[key]);
    }
  }

  /**
   * Create a new dictionary with the same keys as the original dictionary
   * mapped to the results of the provided function called on the corresponding
   * entries in the original dictionary, i.e. result[key] = fn(key, dict[key])
   * for all keys in dict (own enumerable properties only).
   *
   * Example:
   *   var srcDict = {a: 10, b: 15};
   *   var dstDict = mapItems(srcDict, function(k, v) { return 2 * v; });
   *   // srcDict is unmodified and dstDict is now equal to {a: 20, b: 30}.
   */
  function mapItems(dict, fn, opt_this) {
    opt_this = opt_this || this;
    var result = {};
    var keys = Object.keys(dict);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      result[key] = fn.call(opt_this, key, dict[key]);
    }
    return result;
  }

  function filterItems(dict, predicate, opt_this) {
    opt_this = opt_this || this;
    var result = {};
    var keys = Object.keys(dict);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = dict[key];
      if (predicate.call(opt_this, key, value)) result[key] = value;
    }
    return result;
  }

  function iterObjectFieldsRecursively(object, func) {
    if (!(object instanceof Object)) return;

    if (object instanceof Array) {
      for (var i = 0; i < object.length; i++) {
        func(object, i, object[i]);
        iterObjectFieldsRecursively(object[i], func);
      }
      return;
    }

    for (var key in object) {
      var value = object[key];
      func(object, key, value);
      iterObjectFieldsRecursively(value, func);
    }
  }

  /**
   * Convert an array of dictionaries to a dictionary of arrays.
   *
   * The keys of the resulting dictionary are a union of the keys of all
   * dictionaries in the provided array. Each array in the resulting dictionary
   * has the same length as the provided array and contains the values of its
   * key in the dictionaries in the provided array. Example:
   *
   *   INPUT:
   *
   *     [
   *       {a: 6, b: 5      },
   *       undefined,
   *       {a: 4, b: 3, c: 2},
   *       {      b: 1, c: 0}
   *     ]
   *
   *   OUTPUT:
   *
   *     {
   *       a: [6,         undefined, 4, undefined],
   *       b: [5,         undefined, 3, 1        ],
   *       c: [undefined, undefined, 2, 0        ]
   *     }
   *
   * @param {!Array} array Array of items to be inverted. If opt_dictGetter
   *     is not provided, all elements of the array must be either undefined,
   *     or dictionaries.
   * @param {?(function(*): (!Object|undefined))=} opt_dictGetter Optional
   *     function mapping defined elements of array to dictionaries.
   * @param {*=} opt_this Optional 'this' context for opt_dictGetter.
   */
  function invertArrayOfDicts(array, opt_dictGetter, opt_this) {
    opt_this = opt_this || this;
    var result = {};
    for (var i = 0; i < array.length; i++) {
      var item = array[i];
      if (item === undefined) continue;
      var dict = opt_dictGetter ? opt_dictGetter.call(opt_this, item) : item;
      if (dict === undefined) continue;
      for (var key in dict) {
        var valueList = result[key];
        if (valueList === undefined) result[key] = valueList = new Array(array.length);
        valueList[i] = dict[key];
      }
    }
    return result;
  }

  /**
   * Convert an array to a dictionary.
   *
   * Every element in the array is mapped in the dictionary to the key returned
   * by the provided function:
   *
   *   dictionary[valueToKeyFn(element)] = element;
   *
   * @param {!Array} array Arbitrary array.
   * @param {function(*): string} valueToKeyFn Function mapping array elements
   *     to dictionary keys.
   * @param {*=} opt_this Optional 'this' context for valueToKeyFn.
   */
  function arrayToDict(array, valueToKeyFn, opt_this) {
    opt_this = opt_this || this;
    var result = {};
    var length = array.length;
    for (var i = 0; i < length; i++) {
      var value = array[i];
      var key = valueToKeyFn.call(opt_this, value);
      result[key] = value;
    }
    return result;
  }

  /** Returns the value passed in. */
  function identity(d) {
    return d;
  }

  /**
   * Returns the index of the first element in |ary| for which |opt_func|
   * returns a truthy value.
   *
   * @param {!Array} ary The array being searched
   * @param {function(*): *=} opt_func The test function which accepts an array
   *     element and returns a value that is coerced to a boolean. Defaults to
   *     the identity function.
   * @param {*=} opt_this Optional 'this' context for opt_func.
   */
  function findFirstIndexInArray(ary, opt_func, opt_this) {
    var func = opt_func || identity;
    for (var i = 0; i < ary.length; i++) {
      if (func.call(opt_this, ary[i], i)) return i;
    }
    return -1;
  }

  /**
   * Returns the value of the first element in |ary| for which |opt_func|
   * returns a truthy value.
   *
   * @param {!Array} ary The array being searched.
   * @param {function(*): *=} opt_func The test function which accepts an array
   *     element and returns a value that is coerced to a boolean. Defaults to
   *     the identity function.
   * @param {*=} opt_this Optional 'this' context for opt_func.
   */
  function findFirstInArray(ary, opt_func, opt_this) {
    var i = findFirstIndexInArray(ary, opt_func, opt_func);
    if (i === -1) return undefined;
    return ary[i];
  }

  /**
   * Returns the key of the first dictionary entry for which |opt_func| returns
   * a truthy value.
   *
   * @param {!Object} dict The dictionary being searched.
   * @param {function(*, *): *=} opt_func The test function which accepts a
   *     dictionary key as its first parameter, the corresponding dictionary
   *     value as its second parameter, and returns a value that is coerced to a
   *     boolean. Defaults to the identity function (which returns the key).
   * @param {*=} opt_this Optional 'this' context for opt_func.
   */
  function findFirstKeyInDictMatching(dict, opt_func, opt_this) {
    var func = opt_func || identity;
    for (var key in dict) {
      if (func.call(opt_this, key, dict[key])) return key;
    }
    return undefined;
  }

  /** Returns the values in an ES6 Map object. */
  function mapValues(map) {
    var values = [];
    for (var value of map.values()) values.push(value);
    return values;
  }

  /**
   * Calls |fn| on each entry in an ES6 Map.
   *
   * @param {!Map} The map whose entries are being processed.
   * @param {function(*, *): *} The function which accepts a map key as its
   *     first parameter and a map value as its second parameter. Any return
   *     value is ignored.
   * @param {*=} opt_this Optional 'this' context for fn.
   */
  function iterMapItems(map, fn, opt_this) {
    opt_this = opt_this || this;
    for (var key of map.keys()) fn.call(opt_this, key, map.get(key));
  }

  return {
    asArray: asArray,
    concatenateArrays: concatenateArrays,
    concatenateObjects: concatenateObjects,
    compareArrays: compareArrays,
    comparePossiblyUndefinedValues: comparePossiblyUndefinedValues,
    compareNumericWithNaNs: compareNumericWithNaNs,
    cloneDictionary: cloneDictionary,
    dictionaryLength: dictionaryLength,
    dictionaryKeys: dictionaryKeys,
    dictionaryValues: dictionaryValues,
    dictionaryContainsValue: dictionaryContainsValue,
    every: every,
    getOnlyElement: getOnlyElement,
    getFirstElement: getFirstElement,
    group: group,
    groupIntoMap: groupIntoMap,
    iterItems: iterItems,
    mapItems: mapItems,
    filterItems: filterItems,
    iterObjectFieldsRecursively: iterObjectFieldsRecursively,
    invertArrayOfDicts: invertArrayOfDicts,
    arrayToDict: arrayToDict,
    identity: identity,
    findFirstIndexInArray: findFirstIndexInArray,
    findFirstInArray: findFirstInArray,
    findFirstKeyInDictMatching: findFirstKeyInDictMatching,
    mapValues: mapValues,
    iterMapItems: iterMapItems
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],42:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

// In node, the script-src for gl-matrix-min above brings in glmatrix into
// a module, instead of into the global scope. Whereas, Tracing code
// assumes that glMatrix is in the global scope. So, in Node only, we
// require() it in, and then take all its exports and shove them into the
// global scope by hand.
(function () {
  if (tr.isNode) {
    var glMatrixAbsPath = HTMLImportsLoader.hrefToAbsolutePath('/gl-matrix-min.js');
    var glMatrixModule = require(glMatrixAbsPath);
    for (var exportName in glMatrixModule) {
      global[exportName] = glMatrixModule[exportName];
    }
  }
})(this);

'use strict';

global.tr.exportTo('tr.b', function () {
  /* Returns true when x and y are within delta of each other. */
  function approximately(x, y, delta) {
    if (delta === undefined) delta = 1e-9;
    return Math.abs(x - y) < delta;
  }

  function clamp(x, lo, hi) {
    return Math.min(Math.max(x, lo), hi);
  }

  function lerp(percentage, lo, hi) {
    var range = hi - lo;
    return lo + percentage * range;
  }

  function normalize(value, lo, hi) {
    return (value - lo) / (hi - lo);
  }

  function deg2rad(deg) {
    return Math.PI * deg / 180.0;
  }

  /* The Gauss error function gives the probability that a measurement (which is
   * under the influence of normally distributed errors with standard deviation
   * sigma = 1) is less than x from the mean value of the standard normal
   * distribution.
   * https://www.desmos.com/calculator/t1v4bdpske
   *
   * @param {number} x A tolerance for error.
   * @return {number} The probability that a measurement is less than |x| from
   * the mean value of the standard normal distribution.
   */
  function erf(x) {
    // save the sign of x
    // erf(-x) = -erf(x);
    var sign = x >= 0 ? 1 : -1;
    x = Math.abs(x);

    // constants
    var a1 = 0.254829592;
    var a2 = -0.284496736;
    var a3 = 1.421413741;
    var a4 = -1.453152027;
    var a5 = 1.061405429;
    var p = 0.3275911;

    // Abramowitz and Stegun formula 7.1.26
    // maximum error: 1.5e-7
    var t = 1.0 / (1.0 + p * x);
    var y = 1.0 - ((((a5 * t + a4) * t + a3) * t + a2) * t + a1) * t * Math.exp(-x * x);
    return sign * y;
  }

  var tmpVec2 = vec2.create();
  var tmpVec2b = vec2.create();
  var tmpVec4 = vec4.create();
  var tmpMat2d = mat2d.create();

  vec2.createFromArray = function (arr) {
    if (arr.length != 2) throw new Error('Should be length 2');
    var v = vec2.create();
    vec2.set(v, arr[0], arr[1]);
    return v;
  };

  vec2.createXY = function (x, y) {
    var v = vec2.create();
    vec2.set(v, x, y);
    return v;
  };

  vec2.toString = function (a) {
    return '[' + a[0] + ', ' + a[1] + ']';
  };

  vec2.addTwoScaledUnitVectors = function (out, u1, scale1, u2, scale2) {
    // out = u1 * scale1 + u2 * scale2
    vec2.scale(tmpVec2, u1, scale1);
    vec2.scale(tmpVec2b, u2, scale2);
    vec2.add(out, tmpVec2, tmpVec2b);
  };

  vec2.interpolatePiecewiseFunction = function (points, x) {
    if (x < points[0][0]) return points[0][1];
    for (var i = 1; i < points.length; ++i) {
      if (x < points[i][0]) {
        var percent = normalize(x, points[i - 1][0], points[i][0]);
        return lerp(percent, points[i - 1][1], points[i][1]);
      }
    }
    return points[points.length - 1][1];
  };

  vec3.createXYZ = function (x, y, z) {
    var v = vec3.create();
    vec3.set(v, x, y, z);
    return v;
  };

  vec3.toString = function (a) {
    return 'vec3(' + a[0] + ', ' + a[1] + ', ' + a[2] + ')';
  };

  mat2d.translateXY = function (out, x, y) {
    vec2.set(tmpVec2, x, y);
    mat2d.translate(out, out, tmpVec2);
  };

  mat2d.scaleXY = function (out, x, y) {
    vec2.set(tmpVec2, x, y);
    mat2d.scale(out, out, tmpVec2);
  };

  vec4.unitize = function (out, a) {
    out[0] = a[0] / a[3];
    out[1] = a[1] / a[3];
    out[2] = a[2] / a[3];
    out[3] = 1;
    return out;
  };

  vec2.copyFromVec4 = function (out, a) {
    vec4.unitize(tmpVec4, a);
    vec2.copy(out, tmpVec4);
  };

  return {
    approximately: approximately,
    clamp: clamp,
    lerp: lerp,
    normalize: normalize,
    deg2rad: deg2rad,
    erf: erf
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],43:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

/**
 * @fileoverview Multi-dimensional view data structure.
 *
 * A multi-dimensional view provides a hierarchical representation of a
 * collection of multi-dimensional paths with associated scalar values. Unlike
 * separate single-dimensional views (e.g. one tree for each dimension),
 * multi-dimensional views facilitate aggregation over combinations of
 * substrings of the path dimensions (rather than just substrings of a single
 * path dimension).
 *
 * Every view consists of multi-dimensional nodes (see MultiDimensionalViewNode
 * for more details). This file also provides a builder class for constructing
 * top-down and bottom-up representations of arbitrary collections of
 * multi-dimensional paths (see MultiDimensionalViewBuilder for more details).
 *
 * Example: Given the following collection of two dimensional paths:
 *
 *   <===================== Path =====================>   <== Total values ===>
 *    <------- dimension 0 ------->  <- dimension 1 ->    <- v 0 ->  <- v 1 ->
 *   [['Run()', 'Exec()', 'Call()'], ['Obj', 'View']  ]: [1        , 3
 *   [['Run()', 'Exec()', 'Call()'], ['Obj', 'Widget']]: [2        , 5
 *   [['Run()', 'Exec()', 'Load()'], ['Obj']          ]: [4        , 11
 *   [['Run()', 'Exec()']          , ['int']          ]: [8        , 7
 *   [['Run()']                    , ['Obj', 'Window']]: [16       , 0
 *   [['Stop()']                   , ['Obj']          ]: [32       , 13
 *
 * a multi-dimensional view provides a recursive breakdown of the aggregated
 * values, e.g. (total values shown in square brackets):
 *
 *   (root): [63, 39]
 *     |
 *     | break down by 0th dimension
 *     v
 *   Run():  [31, 26]
 *     |
 *     | break down by 0th dimension
 *     v
 *   Exec(): [15, 26]
 *     |
 *     | break down by 1st dimension
 *     v
 *   Obj:    [7, 19]
 *     |
 *     | break down by 0th dimension again
 *     v
 *   Call(): [3, 8]
 *     |
 *     | break down by 1st dimension again
 *     v
 *   View:   [1, 3]
 *
 * Observe that the recursive breakdown above is over both dimensions.
 * Furthermore, the underlying single-dimension paths (Run() -> Exec() -> Call()
 * and Obj -> View) can be arbitrarily interleaved in the breakdown.
 */
global.tr.exportTo('tr.b', function () {

  /**
   * Node of a multi-dimensional view.
   *
   * The structure of a view is encoded in the nodes using links to their
   * children wrt each dimension. The diagram below shows how the nodes
   * corresponding to the following four two-dimensional view paths:
   *
   *   1. [['A', 'B'], ['1', '2']]
   *   2. [['A', 'C'], ['1', '2']]
   *   3. [['A', 'B'], ['1', '3']]
   *   4. [['A', 'C'], ['1', '3']]
   *
   * can be reached from the root of a two-dimensional view using these links
   * ('*' stands for undefined):
   *
   *                       +---------------------+
   *                       | title: [*,*] (root) |
   *                       +---------------------+
   *                     children wrt    children wrt
   *                    0th dimension    1st dimension
   *                              |        :
   *              _______A________|        :........1.........
   *             |                                           :
   *             v                                           v
   *         +--------------+                     +--------------+
   *         | title: [A,*] |                     | title: [*,1] |
   *         +--------------+                     +--------------+
   *    children wrt   children wrt         children wrt   children wrt
   *   0th dimension   1st dimension       0th dimension   1st dimension
   *           | |       :.....1......    _____A_____|       : :
   *        _B_| |__C__              :   |             ...2..: :.3..
   *       |           |             :   |             :           :
   *       v           v             v   v             v           v
   *   +-------+   +-------+       +-------+       +-------+   +-------+
   *   | [B,*] |   | [C,*] |       | [A,1] |       | [*,2] |   | [*,3] |
   *   +-------+   +-------+       +-------+       +-------+   +-------+
   *       :        ___:_____B______| | : :......3.....|....       |
   *       :.1..   |   :.1..    __C___| :...2...    _A_|   :    _A_|
   *           :   |       :   |               :   |       :   |
   *           v   v       v   v               v   v       v   v
   *         +-------+   +-------+           +-------+   +-------+
   *         | [B,1] |   | [C,1] |           | [A,2] |   | [A,3] |
   *         +-------+   +-------+           +-------+   +-------+
   *           :   :       :   :.......3.......||..........   ||
   *           :   :..3....:................   BC         :   BC
   *           :     ______:_______________:___||         :   ||
   *           2    |      2        _______:____|   ______:___||
   *           :    |      :       |       :       |      :    |
   *           v    v      v       v       v       v      v    v
   *       +----------+   +----------+   +----------+   +----------+
   *       |  [B,2]   |   |  [C,2]   |   |  [B,3]   |   |  [C,3]   |
   *       | (node 1) |   | (node 2) |   | (node 3) |   | (node 4) |
   *       +----------+   +----------+   +----------+   +----------+
   *
   * The self/total values of a node represents the aggregated values of all
   * paths (in the collection from which the view was built) matching the node
   * excluding/including the node's descendants.
   *
   * Terminology examples:
   *
   *   - Children of [A,*] wrt 0th dimension: [B,*], [C,*]
   *   - Children of [A,*] (wrt all dimensions): [B,*], [C,*], [A,1]
   *   - Descendants of [A,*] wrt 1st dimension: [A,1], [A,2], [A,3]
   *   - Single-dimensional descendants of [A,*]: [A,1], [A,2], [A,3], [B,*],
   *     [C,*]
   *   - Descendants of [A,*] (wrt all dimensions): [A,1], [A,2], [A,3], [B,*],
   *     [C,*], [B,1], [C,1], [B,2], [C,2], [B,3], [C,3]
   *
   * @{constructor}
   */
  function MultiDimensionalViewNode(title, valueCount) {
    // List of titles of this node wrt each dimension.
    this.title = title;

    // Map from child name to child node for each dimension.
    var dimensions = title.length;
    this.children = new Array(dimensions);
    for (var i = 0; i < dimensions; i++) this.children[i] = new Map();

    // For each value index (from 0 to |valueCount| - 1), we store the self and
    // total values together with a Boolean flag whether the value is only a
    // lower bound (i.e. aggregated from children rather than provided
    // directly).
    this.values = new Array(valueCount);
    for (var v = 0; v < valueCount; v++) this.values[v] = { self: 0, total: 0, totalState: NOT_PROVIDED };
  }

  /**
   * States of total values stored in multi-dimensional view nodes.
   *
   * @enum
   */
  MultiDimensionalViewNode.TotalState = {
    // Neither total nor self value was provided for either the node or any of
    // its descendants.
    NOT_PROVIDED: 0,

    // The total value was NOT provided for the node, but the self value was
    // provided for the node or the total or self value was provided for at
    // least one of its descendants.
    LOWER_BOUND: 1,

    // The total value was provided for the node.
    EXACT: 2
  };
  // Cache the total value states to avoid repeated object field lookups.
  var NOT_PROVIDED = MultiDimensionalViewNode.TotalState.NOT_PROVIDED;
  var LOWER_BOUND = MultiDimensionalViewNode.TotalState.LOWER_BOUND;
  var EXACT = MultiDimensionalViewNode.TotalState.EXACT;

  MultiDimensionalViewNode.prototype = {
    /** Duck type <tr-ui-b-table> rows. */
    get subRows() {
      return tr.b.mapValues(this.children[0]);
    }
  };

  /**
   * Builder for multi-dimensional views.
   *
   * Given a collection of multi-dimensional paths, a builder can be used to
   * construct the following three representations of the paths:
   *
   *   1. Top-down tree view
   *      A multi-dimensional path in the view corresponds to all paths in the
   *      collection that have it as their prefix.
   *
   *   2. Top-down heavy view
   *      A multi-dimensional path in the view corresponds to all paths in the
   *      collection that have it as their substring
   *
   *   3. Bottom-up heavy view
   *      A multi-dimensional path in the view corresponds to all paths in the
   *      collection that have it as their substring reversed.
   *
   * For example, the following collection of 2-dimensional paths (with single
   * values):
   *
   *                  2-dimensional path                | self
   *    Time (0th dimension) | Activity (1st dimension) | value
   *   ========================+========================+=======
   *    Saturday             | Cooking                  |   1 h
   *    Saturday             | Sports -> Football       |   2 h
   *    Sunday               | Sports -> Basketball     |   3 h
   *
   * gives rise to the following top-down tree view, which aggregates the
   * scalar values over prefixes of the given paths:
   *
   *                              +---------+
   *                              |    *    |
   *                              |    *    |
   *                              | self=0  |
   *                              | total=6 |
   *                              +---------+
   *                                | : | :
   *         _________Cooking_______| : | :............Sunday............
   *        |                         : |                               :
   *        |            ...Saturday..: |_Sports_                       :
   *        |            :                       |                      :
   *        v            v                       v                      v
   *   +---------+  +---------+            +---------+             +---------+
   *   |    *    |  |   Sat   |            |    *    |             |   Sun   |
   *   | Cooking |  |    *    |            | Sports  |             |    *    |
   *   | self=0  |  | self=0  |            | self=0  |             | self=0  |
   *   | total=1 |  | total=3 |            | total=5 |             | total=3 |
   *   +---------+  +---------+            +---------+             +---------+
   *      :          |   |                   : | | :                     |
   *    Saturday     | Sports                : | | :                  Sports
   *      :          |   |  .....Saturday....: | | :.....Sunday.......   |
   *      :    _Cook_|   |  :            _Foot_| |_Bask_             :   |
   *      :   |          |  :           |               |            :   |
   *      v   v          v  v           v               v            v   v
   *   +---------+  +---------+  +------------+  +--------------+  +---------+
   *   |   Sat   |  |   Sat   |  |     *      |  |      *       |  |   Sun   |
   *   | Cooking |  | Sports  |  | S/Football |  | S/Basketball |  | Sports  |
   *   | self=1  |  | self=0  |  | self=0     |  | self=0       |  | self=0  |
   *   | total=1 |  | total=2 |  | total=2    |  | total=3      |  | total=3 |
   *   +---------+  +---------+  +------------+  +--------------+  +---------+
   *                    |              :                 :               |
   *                    |_Foot_  ..Sat.:                 :.Sun..   _Bask_|
   *                           | :                             :  |
   *                           v v                             v  v
   *                     +------------+                   +--------------+
   *                     |    Sat     |                   |     Sun      |
   *                     | S/Football |                   | S/Basketball |
   *                     | self=2     |                   | self=3       |
   *                     | total=2    |                   | total=3      |
   *                     +------------+                   +--------------+
   *
   * To build a multi-dimensional view of a collection of multi-dimensional
   * paths, you create a builder, add the paths to it and then use it to
   * construct the view. For example, the following code generates the
   * 2-dimensional top-down tree view shown above:
   *
   *   var builder = new MultiDimensionalViewBuilder(2);
   *   builder.addPath([['Saturday'], ['Cooking']], [1], SELF);
   *   builder.addPath([['Saturday'], ['Sports', 'Football']], [2], SELF);
   *   builder.addPath([['Sunday'], ['Sports', 'Basketball']], [3], SELF);
   *   var treeViewRoot = builder.buildTopDownTreeView();
   *
   * The heavy views can be constructed analogously (by calling
   * buildTopDownHeavyView() or buildBottomUpHeavyView() at the end instead).
   *
   * Note that the same builder can be used to construct both the tree and
   * heavy views (for the same collection of paths). However, no more paths can
   * be added once either view has been built.
   *
   * @{constructor}
   */
  function MultiDimensionalViewBuilder(dimensions, valueCount) {
    if (typeof dimensions !== 'number' || dimensions < 0) throw new Error('Dimensions must be a non-negative number');
    this.dimensions_ = dimensions;

    if (typeof valueCount !== 'number' || valueCount < 0) throw new Error('Number of values must be a non-negative number');
    this.valueCount_ = valueCount;

    this.buildRoot_ = this.createRootNode_();
    this.topDownTreeViewRoot_ = undefined;
    this.topDownHeavyViewRoot_ = undefined;
    this.bottomUpHeavyViewNode_ = undefined;

    this.maxDimensionDepths_ = new Array(dimensions);
    for (var d = 0; d < dimensions; d++) this.maxDimensionDepths_[d] = 0;
  }

  /** @{enum} */
  MultiDimensionalViewBuilder.ValueKind = {
    SELF: 0,
    TOTAL: 1
  };

  /**
   * Types of multi-dimensional views provided by MultiDimensionalViewBuilder.
   *
   * @enum
   */
  MultiDimensionalViewBuilder.ViewType = {
    TOP_DOWN_TREE_VIEW: 0,
    TOP_DOWN_HEAVY_VIEW: 1,
    BOTTOM_UP_HEAVY_VIEW: 2
  };

  MultiDimensionalViewBuilder.prototype = {
    /**
     * Add values associated with a multi-dimensional path to the tree.
     *
     * The path must have the same number of dimensions as the builder. Its
     * elements must be single-dimension paths (lists of strings) of arbitrary
     * length (empty for the root of the given dimension). Starting from the
     * root of the tree, each single-dimension path is traversed from left to
     * right to reach the node corresponding to the whole path.
     *
     * The length of the provided list of values must be equal to the builder's
     * value count. The builder supports adding both kinds of values
     * (self/total) wrt all value indices for an arbitrary multi-dimensional
     * path. The rationale for adding total values (in addition to/instead of
     * self values) is to cater for missing sub-paths. Example: Consider the
     * following collection of single-dimensional paths (with single values):
     *
     *   [['Loop::Run()', 'Execute()', 'FunctionBig']]:       self=99000
     *   [['Loop::Run()', 'Execute()', 'FunctionSmall1']]:    self=1
     *   [['Loop::Run()', 'Execute()', 'FunctionSmall2']]:    self=1
     *   ...
     *   [['Loop::Run()', 'Execute()', 'FunctionSmall1000']]: self=1
     *
     * If we required that only self values could be added to the builder, then
     * all of the 1001 paths would need to be provided (most likely in a trace)
     * to obtain the correct total of [['Loop::Run()', 'Execute()']]. However,
     * since we allow adding total values as well, only the following 2 paths
     * need to be provided to get the correct numbers explaining 99% of the
     * aggregated total value:
     *
     *   [['Loop::Run()', 'Execute()']]:                total=100000
     *   [['Loop::Run()', 'Execute()', 'FunctionBig']]: self=99000
     *
     * In other words, the long tail containing 1000 small paths need not be
     * dumped (greatly reducing the size of a trace where applicable).
     *
     * Important: No paths can be added to a builder once either view has been
     * built!
     */
    addPath: function (path, values, valueKind) {
      if (this.buildRoot_ === undefined) {
        throw new Error('Paths cannot be added after either view has been built');
      }
      if (path.length !== this.dimensions_) throw new Error('Path must be ' + this.dimensions_ + '-dimensional');
      if (values.length !== this.valueCount_) throw new Error('Must provide ' + this.valueCount_ + ' values');

      var isTotal;
      switch (valueKind) {
        case MultiDimensionalViewBuilder.ValueKind.SELF:
          isTotal = false;
          break;
        case MultiDimensionalViewBuilder.ValueKind.TOTAL:
          isTotal = true;
          break;
        default:
          throw new Error('Invalid value kind: ' + valueKind);
      }

      var node = this.buildRoot_;
      for (var d = 0; d < path.length; d++) {
        var singleDimensionPath = path[d];
        var singleDimensionPathLength = singleDimensionPath.length;
        this.maxDimensionDepths_[d] = Math.max(this.maxDimensionDepths_[d], singleDimensionPathLength);
        for (var i = 0; i < singleDimensionPathLength; i++) node = this.getOrCreateChildNode_(node, d, singleDimensionPath[i]);
      }

      for (var v = 0; v < this.valueCount_; v++) {
        var addedValue = values[v];
        if (addedValue === undefined) continue;
        var nodeValue = node.values[v];
        if (isTotal) {
          nodeValue.total += addedValue;
          nodeValue.totalState = EXACT;
        } else {
          nodeValue.self += addedValue;
          nodeValue.totalState = Math.max(nodeValue.totalState, LOWER_BOUND);
        }
      }
    },

    buildView: function (viewType) {
      switch (viewType) {
        case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_TREE_VIEW:
          return this.buildTopDownTreeView();
        case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_HEAVY_VIEW:
          return this.buildTopDownHeavyView();
        case MultiDimensionalViewBuilder.ViewType.BOTTOM_UP_HEAVY_VIEW:
          return this.buildBottomUpHeavyView();
        default:
          throw new Error('Unknown multi-dimensional view type: ' + viewType);
      }
    },

    /**
     * Build the top-down tree view of the multi-dimensional view.
     *
     * Note that no more paths can be added to the builder once either view has
     * been built.
     */
    buildTopDownTreeView: function () {
      if (this.topDownTreeViewRoot_ === undefined) {
        var treeViewRoot = this.buildRoot_;
        this.buildRoot_ = undefined;

        this.setUpMissingChildRelationships_(treeViewRoot, 0 /* firstDimensionToSetUp */);
        this.finalizeTotalValues_(treeViewRoot, 0 /* firstDimensionToFinalize */
        , new WeakMap() /* dimensionalSelfSumsMap */);

        this.topDownTreeViewRoot_ = treeViewRoot;
      }

      return this.topDownTreeViewRoot_;
    },

    /**
     * Build the top-down heavy view of the multi-dimensional view.
     *
     * Note that no more paths can be added to the builder once either view has
     * been built.
     */
    buildTopDownHeavyView: function () {
      if (this.topDownHeavyViewRoot_ === undefined) {
        this.topDownHeavyViewRoot_ = this.buildGenericHeavyView_(this.addDimensionToTopDownHeavyViewNode_.bind(this));
      }
      return this.topDownHeavyViewRoot_;
    },

    /**
     * Build the bottom-up heavy view of the multi-dimensional view.
     *
     * Note that no more paths can be added to the builder once either view has
     * been built.
     */
    buildBottomUpHeavyView: function () {
      if (this.bottomUpHeavyViewNode_ === undefined) {
        this.bottomUpHeavyViewNode_ = this.buildGenericHeavyView_(this.addDimensionToBottomUpHeavyViewNode_.bind(this));
      }
      return this.bottomUpHeavyViewNode_;
    },

    createRootNode_: function () {
      return new MultiDimensionalViewNode(new Array(this.dimensions_) /* title */, this.valueCount_);
    },

    getOrCreateChildNode_: function (parentNode, dimension, childDimensionTitle) {
      if (dimension < 0 || dimension >= this.dimensions_) throw new Error('Invalid dimension');

      var dimensionChildren = parentNode.children[dimension];

      var childNode = dimensionChildren.get(childDimensionTitle);
      if (childNode !== undefined) return childNode;

      var childTitle = parentNode.title.slice();
      childTitle[dimension] = childDimensionTitle;
      childNode = new MultiDimensionalViewNode(childTitle, this.valueCount_);
      dimensionChildren.set(childDimensionTitle, childNode);

      return childNode;
    },

    /**
     * Set up missing child relationships.
     *
     * When an arbitrary multi-dimensional path [path1, path2, ..., pathN] is
     * added to the build tree (see addPath), only the nodes on the path1 ->
     * path2 -> ... -> pathN chain are created (i.e. no interleavings of the
     * single-dimensional paths are added to the tree). This method recursively
     * adds all the missing paths.
     *
     * Two-dimensional example:
     *
     *    Initial build tree   .       After path      .  After missing child
     *        (root only)      .    [[A, B], [1, 2]]   .   relationships were
     *                         .       was added       .        set up
     *                         .                       .
     *           +---+         .         +---+         .         +---+
     *           |*,*|         .         |*,*|         .         |*,*|
     *           +---+         .         +---+         .         +---+
     *                         .         A             .         A   1
     *                         .         |             .         |   :
     *                         .         v             .         v   V
     *                         .     +---+             .     +---+   +---+
     *                         .     |A,*|             .     |A,*|   |*,1|
     *                         .     +---+             .     +---+   +---+
     *                         .     B                 .     B   1   A   2
     *                         .     |                 .     |   :   |   :
     *                         .     v                 .     v   v   v   v
     *                         . +---+                 . +---+   +---+   +---+
     *                         . |B,*|                 . |B,*|   |A,1|   |*,2|
     *                         . +---+                 . +---+   +---+   +---+
     *                         .     1                 .     1   B   2   A
     *                         .     :                 .     :   |   :   |
     *                         .     v                 .     v   v   v   v
     *                         .     +---+             .     +---+   +---+
     *                         .     |B,1|             .     |B,1|   |A,2|
     *                         .     +---+             .     +---+   +---+
     *                         .         2             .         2   B
     *                         .         :             .         :   |
     *                         .         v             .         v   V
     *                         .         +---+         .         +---+
     *                         .         |B,2|         .         |B,2|
     *                         .         +---+         .         +---+
     */
    setUpMissingChildRelationships_: function (node, firstDimensionToSetUp) {
      // Missing child relationships of this node wrt dimensions 0, ...,
      // (firstDimensionToSetUp - 1) and all descendants of the associated
      // children have already been set up. Now we do the same for dimensions
      // firstDimensionToSetUp, ..., (this.dimensions_ - 1).
      for (var d = firstDimensionToSetUp; d < this.dimensions_; d++) {
        // Step 1. Gather the names of all children wrt the current dimension.
        var currentDimensionChildTitles = new Set(node.children[d].keys());
        for (var i = 0; i < d; i++) {
          for (var previousDimensionChildNode of node.children[i].values()) {
            for (var previousDimensionGrandChildTitle of previousDimensionChildNode.children[d].keys()) {
              currentDimensionChildTitles.add(previousDimensionGrandChildTitle);
            }
          }
        }

        // Step 2. Add missing children wrt the current dimension and
        // recursively set up its missing child relationships.
        for (var currentDimensionChildTitle of currentDimensionChildTitles) {
          // Add a missing child (if it doesn't exist).
          var currentDimensionChildNode = this.getOrCreateChildNode_(node, d, currentDimensionChildTitle);

          // Set-up child relationships (of the child node) wrt dimensions 0,
          // ..., d - 1.
          for (var i = 0; i < d; i++) {
            for (var previousDimensionChildNode of node.children[i].values()) {
              var previousDimensionGrandChildNode = previousDimensionChildNode.children[d].get(currentDimensionChildTitle);
              if (previousDimensionGrandChildNode !== undefined) {
                currentDimensionChildNode.children[i].set(previousDimensionChildNode.title[i], previousDimensionGrandChildNode);
              }
            }
          }

          // Set-up child relationships (of the child node) wrt dimensions d,
          // ..., (this.dimensions_ - 1).
          this.setUpMissingChildRelationships_(currentDimensionChildNode, d);
        }
      }
    },

    /**
     * Finalize the total values of a multi-dimensional tree.
     *
     * The intermediate builder tree, a node of which we want to finalize
     * recursively, already has the right shape. The only thing that needs to
     * be done is to propagate self and total values from subsumed child nodes
     * in each dimension and update total value states appropriately.
     *
     * To derive the expression for the lower bound on the total value wrt
     * value index V (from 1 to |this.valueCount_| - 1), we rely on the
     * following assumptions:
     *
     *   1. Self/total values associated with different value indices are
     *      independent. From this point onwards, "self/total value" refers to
     *      self/total value wrt the fixed value index V.
     *
     *   2. Each node's self value does NOT overlap with the self or total value
     *      of any other node.
     *
     *   3. The total values of a node's children wrt a single dimension (e.g.
     *      [path1/A, path2] and [path1/B, path2]) do NOT overlap.
     *
     *   4. The total values of a node's children wrt different dimensions
     *      (e.g. [path1/A, path2] and [path1, path2/1]) MIGHT overlap.
     *
     * As a consequence of assumptions 1 and 3, the total value of a node can
     * be split into the part that cannot overlap (so-called "self-sum") and
     * the part that can overlap (so-called "residual"):
     *
     *   total(N, V) = selfSum(N, V) + residual(N, V)                   (A)
     *
     * where the self-sum is calculated as the sum of the node's self value
     * plus the sum of its descendants' self values (summed over all
     * dimensions):
     *
     *   selfSum(N, V) = self(N, V) + sum over all descendants C of N {
     *       self(C, V)                                                 (B)
     *   }
     *
     * Observe that the residual of a node does not include any self value (of
     * any node in the view). Furthermore, by assumption 2, we derive that the
     * residuals of a node's children wrt a single dimension don't overlap. On
     * the other hand, the residuals of a node's children wrt different
     * dimensions might overlap. This gives us the following lower bound on the
     * residual of a node:
     *
     *   residual(N, V) >= minResidual(N, V) = max over dimensions D {
     *       sum over children C of N at dimension D {
     *           residual(C, V)                                         (C)
     *       }
     *   })
     *
     * By combining equation (A) and inequality (C), we get a lower bound on
     * the total value of a node:
     *
     *   total(N, V) >= selfSum(N, V) + minResidual(N, V)
     *
     * For example, given a two-dimensional node [path1, path2] with self value
     * 10 and four children (2 wrt each dimension):
     *
     *    Child            | Self value | Total value
     *   ==================+============+=============
     *    [path1/A, path2] |         21 |          30
     *    [path1/B, path2] |         25 |          32
     *    [path1, path2/1] |         3  |          15
     *    [path1, path2/2] |         40 |          41
     *
     * and assuming that the children have no further descendants (i.e. their
     * residual values are equal to the differences between their total and
     * self values), the lower bound on the total value of [path1, path2] is:
     *
     *   total([path1, path2], 0)
     *       >= selfSum([path1, path2], 0) +
     *          minResidual([path1, path2], 0)
     *        = self([path1, path2], 0) +
     *          sum over all descendants C of [path1, path2] {
     *              self (C, 0)
     *          } +
     *          max over dimensions D {
     *              sum over children C of [path1, path2] at dimension D {
     *                  residual(C, 0)
     *              }
     *          }
     *        = self([path1, path2], 0) +
     *          ((self([path1/A, path2], 0) + self([path1/B, path2], 0)) +
     *           (self([path1, path2/1], 0) + self([path1, path2/2], 0))) +
     *          max(residual([path1/A, path2], 0) +
     *              residual([path1/B, path2], 0),
     *              residual([path1, path2/1], 0) +
     *              residual([path1, path2/2], 0))
     *        = 10 +
     *          ((21 + 25) + (3 + 40)) +
     *          max((30 - 21) + (32 - 25), (15 - 3) + (41 - 40))
     *        = 115
     *
     * To reduce the complexity of the calculation, we keep a temporary list of
     * dimensional self-sums for each node that we have already visited. For a
     * given node, the Kth element in the list is equal to the self size of the
     * node plus the sum of self sizes of all its descendants wrt dimensions 0
     * to K (inclusive). The list has two important properties:
     *
     *   1. The last element in the list is equal to the self-sum of the
     *      associated node (equation (B)).
     *
     *   2. The calculation of the list can be performed recursively using the
     *      lists of the associated node's children (avoids square complexity
     *      in the size of the graph):
     *
     *        dimensionalSelfSum(N, V)[D] =
     *            self(N, V) +
     *            sum I = 0 to D {
     *                sum over children C of N at dimension I {
     *                    dimensionalSelfSum(C, V)[I]
     *                }
     *            }
     *
     * This method also (recursively) ensures that, for each value index V, if
     * at least one of the descendants C of node N has at least a LOWER_BOUND
     * on total(C, V), then the N will also be marked as having a LOWER_BOUND
     * on total(N, V) (unless N contains the EXACT value of total(N, V), in
     * which case its relevant totalState won't be modified).
     */
    finalizeTotalValues_: function (node, firstDimensionToFinalize, dimensionalSelfSumsMap) {
      // Dimension D -> Value index V -> dimensionalSelfSum(|node|, V)[D].
      var dimensionalSelfSums = new Array(this.dimensions_);

      // Value index V -> minResidual(|node|, V).
      var minResidual = new Array(this.valueCount_);
      for (var v = 0; v < this.valueCount_; v++) minResidual[v] = 0;

      // Value index V -> |node| value V.
      var nodeValues = node.values;

      // Value index V -> dimensionalSelfSum(|node|, V)[|d|].
      var nodeSelfSums = new Array(this.valueCount_);
      for (var v = 0; v < this.valueCount_; v++) nodeSelfSums[v] = nodeValues[v].self;

      for (var d = 0; d < this.dimensions_; d++) {
        // Value index V -> sum over children C of |node| at dimension |d| {
        // residual(C, V) }.
        var childResidualSums = new Array(this.valueCount_);
        for (var v = 0; v < this.valueCount_; v++) childResidualSums[v] = 0;

        for (var childNode of node.children[d].values()) {
          if (d >= firstDimensionToFinalize) this.finalizeTotalValues_(childNode, d, dimensionalSelfSumsMap);
          // Dimension D -> Value index V ->
          // dimensionalSelfSum(|childNode|, V)[D].
          var childNodeSelfSums = dimensionalSelfSumsMap.get(childNode);
          var childNodeValues = childNode.values;
          for (var v = 0; v < this.valueCount_; v++) {
            nodeSelfSums[v] += childNodeSelfSums[d][v];
            var residual = childNodeValues[v].total - childNodeSelfSums[this.dimensions_ - 1][v];
            childResidualSums[v] += residual;
            if (childNodeValues[v].totalState > NOT_PROVIDED) {
              nodeValues[v].totalState = Math.max(nodeValues[v].totalState, LOWER_BOUND);
            }
          }
        }

        dimensionalSelfSums[d] = nodeSelfSums.slice();
        for (var v = 0; v < this.valueCount_; v++) minResidual[v] = Math.max(minResidual[v], childResidualSums[v]);
      }

      for (var v = 0; v < this.valueCount_; v++) {
        nodeValues[v].total = Math.max(nodeValues[v].total, nodeSelfSums[v] + minResidual[v]);
      }

      if (dimensionalSelfSumsMap.has(node)) throw new Error('Internal error: Node finalized more than once');
      dimensionalSelfSumsMap.set(node, dimensionalSelfSums);
    },

    /**
     * Build a generic heavy view of the multi-dimensional view.
     */
    buildGenericHeavyView_: function (treeViewNodeHandler) {
      // 1. Clone the root node of the top-down tree view node (except
      // children).
      var treeViewRoot = this.buildTopDownTreeView();
      var heavyViewRoot = this.createRootNode_();
      heavyViewRoot.values = treeViewRoot.values;

      // 2. Create recursion depth trackers (to avoid total value
      // double-counting).
      var recursionDepthTrackers = new Array(this.dimensions_);
      for (var d = 0; d < this.dimensions_; d++) {
        recursionDepthTrackers[d] = new RecursionDepthTracker(this.maxDimensionDepths_[d], d);
      }

      // 3. Add all paths associated with the single-dimensional descendants of
      // the top-down tree view root node to the heavy view root node
      // (depending on the type of the target heavy view).
      this.addDimensionsToGenericHeavyViewNode_(treeViewRoot, heavyViewRoot, 0 /* startDimension */, recursionDepthTrackers, false /* previousDimensionsRecursive */, treeViewNodeHandler);

      // 4. Set up missing child relationships.
      this.setUpMissingChildRelationships_(heavyViewRoot, 0 /* firstDimensionToSetUp */);

      return heavyViewRoot;
    },

    /**
     * Add all paths associated with the single-dimensional descendants of a
     * top-down tree-view node wrt multiple dimensions to a generic heavy-view
     * node (depending on the type of the target heavy view).
     */
    addDimensionsToGenericHeavyViewNode_: function (treeViewParentNode, heavyViewParentNode, startDimension, recursionDepthTrackers, previousDimensionsRecursive, treeViewNodeHandler) {
      for (var d = startDimension; d < this.dimensions_; d++) {
        this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewParentNode, heavyViewParentNode, d, recursionDepthTrackers, previousDimensionsRecursive, treeViewNodeHandler);
      }
    },

    /**
     * Add all paths associated with the descendants of a top-down tree-view
     * node wrt a single dimension to a generic heavy-view node (depending on
     * the type of the target heavy view).
     */
    addDimensionDescendantsToGenericHeavyViewNode_: function (treeViewParentNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive, treeViewNodeHandler) {
      var treeViewChildren = treeViewParentNode.children[currentDimension];
      var recursionDepthTracker = recursionDepthTrackers[currentDimension];
      for (var treeViewChildNode of treeViewChildren.values()) {
        recursionDepthTracker.push(treeViewChildNode);

        // Add all paths associated with the child node to the heavy view-node
        // parent node.
        treeViewNodeHandler(treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive);

        // Recursively add all paths associated with the descendants of the
        // tree view child node wrt the current dimension to the heavy-view
        // parent node.
        this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive, treeViewNodeHandler);

        recursionDepthTracker.pop();
      }
    },

    /**
     * Add a top-down tree-view child node together with its single-dimensional
     * subtree to a top-down heavy-view parent node (tree-view node handler for
     * top-down heavy view).
     *
     * Sample resulting top-down heavy view:
     *
     *       +----------------+                    +-----------------+
     *       |     source     |                    |   destination   |
     *       | tree-view root |  ===============>  | heavy-view root |
     *       |     self=0     |                    |     self=0      |
     *       |    total=48    |                    |    total=48     |
     *       +----------------+                    +-----------------+
     *         |            |                  ______|      |      |______
     *         v            v                 v             v             v
     *    +----------+ +----------+      +----------+ +----------+ +----------+
     *    |    A*    | |    B     |      |    A***  | |    B     | |    C     |
     *    | self=10  | | self=12  |      | self=13  | | self=13  | | self=2   |
     *    | total=30 | | total=18 |      | total=30 | | total=34 | | total=7  |
     *    +----------+ +----------+      +----------+ +----------+ +----------+
     *         |                              :            :   :.........
     *         v                              v            v            v
     *    +----------+                   ............ ............ ............
     *    |    B     |                   :    B     : :    A     : :    C     :
     *    | self=1   |                   : self=1   : : self=3   : : self=2   :
     *    | total=16 |                   : total=16 : : total=8  : : total=7  :
     *    +----------+                   ............ ............ ............
     *         |   |________                  :   :.........
     *         v            v                 v            v
     *    +----------+ +----------+      ............ ............
     *    |    A**   | |    C     |      :    A     : :    C     :
     *    | self=3   | | self=2   |      : self=3   : : self=2   :
     *    | total=8  | | total=7  |      : total=8  : : total=7  :
     *    +----------+ +----------+      ............ ............
     *
     * Observe that care needs to be taken when dealing with recursion to avoid
     * double-counting, e.g. the total value of A** (8) was not added to the
     * total value of A*** (30) because it is already included in the total
     * value of A* (30) (which was also added to A***). That is why we need to
     * keep track of the path we traversed along the current dimension (to
     * determine whether total value should be added or not).
     */
    addDimensionToTopDownHeavyViewNode_: function (treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive) {
      this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive, 1 /* subTreeDepth */);
    },

    addDimensionToTopDownHeavyViewNodeRecursively_: function (treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive, subTreeDepth) {
      var recursionDepthTracker = recursionDepthTrackers[currentDimension];
      var currentDimensionRecursive = subTreeDepth <= recursionDepthTracker.recursionDepth;
      var currentOrPreviousDimensionsRecursive = currentDimensionRecursive || previousDimensionsRecursive;

      var dimensionTitle = treeViewChildNode.title[currentDimension];
      var heavyViewChildNode = this.getOrCreateChildNode_(heavyViewParentNode, currentDimension, dimensionTitle);

      this.addNodeValues_(treeViewChildNode, heavyViewChildNode, !currentOrPreviousDimensionsRecursive /* addTotal */);

      // Add the descendants of the tree-view child node wrt the next
      // dimensions as children of the heavy-view child node.
      this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode, heavyViewChildNode, currentDimension + 1, recursionDepthTrackers, currentOrPreviousDimensionsRecursive, this.addDimensionToTopDownHeavyViewNode_.bind(this));

      for (var treeViewGrandChildNode of treeViewChildNode.children[currentDimension].values()) {
        recursionDepthTracker.push(treeViewGrandChildNode);

        // Recursively add the tree-view grandchild node to the heavy-view
        // child node.
        this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewGrandChildNode, heavyViewChildNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive, subTreeDepth + 1);

        recursionDepthTracker.pop();
      }
    },

    /**
     * Add a top-down tree-view child node together with all its ancestors wrt
     * the given dimension as descendants of a bottom-up heavy-view parent node
     * in the reverse order (tree-view node handler for bottom-up heavy view).
     *
     * Sample resulting bottom-up heavy view:
     *
     *       +----------------+                    +-----------------+
     *       |     source     |                    |   destination   |
     *       | tree-view root |  ===============>  | heavy-view root |
     *       |     self=0     |                    |     self=0      |
     *       |    total=48    |                    |    total=48     |
     *       +----------------+                    +-----------------+
     *         |            |                  ______|      |      |______
     *         v            v                 v             v             v
     *    +----------+ +----------+      +----------+ +----------+ +----------+
     *    |    A*    | |    B     |      |    A***  | |    B     | |    C     |
     *    | self=10  | | self=12  |      | self=13  | | self=13  | | self=2   |
     *    | total=30 | | total=18 |      | total=30 | | total=34 | | total=7  |
     *    +----------+ +----------+      +----------+ +----------+ +----------+
     *         |                              :            :            :
     *         v                              v            v            v
     *    +----------+                   ............ ............ ............
     *    |    B#    |                   :    B     : :    A     : :    B##   :
     *    | self=1   |                   : self=3   : : self=1   : : self=2   :
     *    | total=16 |                   : total=8  : : total=16 : : total=7  :
     *    +----------+                   ............ ............ ............
     *         |   |________                  :                         :
     *         v            v                 v                         v
     *    +----------+ +----------+      ............              ............
     *    |    A**   | |    C     |      :    A     :              :    A     :
     *    | self=3   | | self=2   |      : self=3   :              : self=2   :
     *    | total=8  | | total=7  |      : total=8  :              : total=7  :
     *    +----------+ +----------+      ............              ............
     *
     * Similarly to the construction of the top-down heavy view, care needs to
     * be taken when dealing with recursion to avoid double-counting, e.g. the
     * total value of A** (8) was not added to the total value of A*** (30)
     * because it is already included in the total value of A* (30) (which was
     * also added to A***). That is why we need to keep track of the path we
     * traversed along the current dimension (to determine whether total value
     * should be added or not).
     *
     * Note that when we add an ancestor (B#) of a top-down tree-view node (C)
     * to the bottom-up heavy view, the values of the original tree-view node
     * (C) (rather than the ancestor's values) are added to the corresponding
     * heavy-view node (B##).
     */
    addDimensionToBottomUpHeavyViewNode_: function (treeViewChildNode, heavyViewParentNode, currentDimension, recursionDepthTrackers, previousDimensionsRecursive) {
      var recursionDepthTracker = recursionDepthTrackers[currentDimension];
      var bottomIndex = recursionDepthTracker.bottomIndex;
      var topIndex = recursionDepthTracker.topIndex;
      var firstNonRecursiveIndex = bottomIndex + recursionDepthTracker.recursionDepth;
      var viewNodePath = recursionDepthTracker.viewNodePath;

      var trackerAncestorNode = recursionDepthTracker.trackerAncestorNode;
      var heavyViewDescendantNode = heavyViewParentNode;
      for (var i = bottomIndex; i < topIndex; i++) {
        var treeViewAncestorNode = viewNodePath[i];
        var dimensionTitle = treeViewAncestorNode.title[currentDimension];
        heavyViewDescendantNode = this.getOrCreateChildNode_(heavyViewDescendantNode, currentDimension, dimensionTitle);

        var currentDimensionRecursive = i < firstNonRecursiveIndex;
        var currentOrPreviousDimensionsRecursive = currentDimensionRecursive || previousDimensionsRecursive;

        // The self and total values are taken from the original top-down tree
        // view child node (rather than the ancestor node).
        this.addNodeValues_(treeViewChildNode, heavyViewDescendantNode, !currentOrPreviousDimensionsRecursive);

        // Add the descendants of the tree-view child node wrt the next
        // dimensions as children of the heavy-view child node.
        this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode, heavyViewDescendantNode, currentDimension + 1, recursionDepthTrackers, currentOrPreviousDimensionsRecursive, this.addDimensionToBottomUpHeavyViewNode_.bind(this));
      }
    },

    addNodeValues_: function (sourceNode, targetNode, addTotal) {
      var targetNodeValues = targetNode.values;
      var sourceNodeValues = sourceNode.values;
      for (var v = 0; v < this.valueCount_; v++) {
        var targetNodeValue = targetNodeValues[v];
        var sourceNodeValue = sourceNodeValues[v];
        targetNodeValue.self += sourceNodeValue.self;
        if (addTotal) {
          targetNodeValue.total += sourceNodeValue.total;
          if (sourceNodeValue.totalState > NOT_PROVIDED) {
            targetNodeValue.totalState = Math.max(targetNodeValue.totalState, LOWER_BOUND);
          }
        }
      }
    }
  };

  /**
   * Recursion depth tracker.
   *
   * This class tracks the recursion depth of the current stack (updated via
   * the push and pop methods). The recursion depth of a stack is the lengh of
   * its longest leaf suffix that is repeated within the stack itself.
   *
   * For example, the recursion depth of the stack A -> B -> C -> A -> B -> B
   * -> C (where C is the leaf node) is 2 because the suffix B -> C is repeated
   * within it.
   *
   * @{constructor}
   */
  function RecursionDepthTracker(maxDepth, dimension) {
    this.titlePath = new Array(maxDepth);
    this.viewNodePath = new Array(maxDepth);
    this.bottomIndex = this.topIndex = maxDepth;

    this.dimension_ = dimension;
    this.currentTrackerNode_ = this.createNode_(0 /* recursionDepth */, undefined /* parent */);
  }

  RecursionDepthTracker.prototype = {
    push: function (viewNode) {
      if (this.bottomIndex === 0) throw new Error('Cannot push to a full tracker');
      var title = viewNode.title[this.dimension_];
      this.bottomIndex--;
      this.titlePath[this.bottomIndex] = title;
      this.viewNodePath[this.bottomIndex] = viewNode;

      var childTrackerNode = this.currentTrackerNode_.children.get(title);
      if (childTrackerNode !== undefined) {
        // Child node already exists, so we don't need to calculate anything.
        this.currentTrackerNode_ = childTrackerNode;
        return;
      }

      // Child node doesn't exist yet, so we need to calculate its recursion
      // depth.
      var maxLengths = zFunction(this.titlePath, this.bottomIndex);
      var recursionDepth = 0;
      for (var i = 0; i < maxLengths.length; i++) recursionDepth = Math.max(recursionDepth, maxLengths[i]);

      childTrackerNode = this.createNode_(recursionDepth, this.currentTrackerNode_);
      this.currentTrackerNode_.children.set(title, childTrackerNode);
      this.currentTrackerNode_ = childTrackerNode;
    },

    pop: function () {
      if (this.bottomIndex === this.topIndex) throw new Error('Cannot pop from an empty tracker');

      this.titlePath[this.bottomIndex] = undefined;
      this.viewNodePath[this.bottomIndex] = undefined;
      this.bottomIndex++;

      this.currentTrackerNode_ = this.currentTrackerNode_.parent;
    },

    get recursionDepth() {
      return this.currentTrackerNode_.recursionDepth;
    },

    createNode_: function (recursionDepth, parent) {
      return {
        recursionDepth: recursionDepth,
        parent: parent,
        children: new Map()
      };
    }
  };

  /**
   * Calculate the Z-function of (a suffix of) a list.
   *
   * Z-function: Given a list (or a string) of length n, for each index i from
   * 1 to n - 1, find the length z[i] of the longest substring starting at
   * position i which is also a prefix of the list. This function returns the
   * list of maximum lengths z.
   *
   * Mathematically, for each i from 1 to n - 1, z[i] is the maximum value such
   * that [list[0], ..., list[i - 1]] = [list[i], ..., list[i + z[i] - 1]].
   * z[0] is defined to be zero for convenience.
   *
   * Example:
   *
   *   Input (list): ['A', 'B', 'A', 'C', 'A', 'B', 'A']
   *   Output (z):   [ 0 ,  0 ,  1 ,  0 ,  3 ,  0 ,  1 ]
   *
   * Unlike the brute-force approach (which is O(n^2) in the worst case), the
   * complexity of this implementation is linear in the size of the list, i.e.
   * O(n).
   *
   * Source: http://e-maxx-eng.github.io/string/z-function.html
   */
  function zFunction(list, startIndex) {
    var n = list.length - startIndex;
    if (n === 0) return [];

    var z = new Array(n);
    z[0] = 0;

    for (var i = 1, left = 0, right = 0; i < n; ++i) {
      var maxLength;
      if (i <= right) maxLength = Math.min(right - i + 1, z[i - left]);else maxLength = 0;

      while (i + maxLength < n && list[startIndex + maxLength] === list[startIndex + i + maxLength]) {
        ++maxLength;
      }

      if (i + maxLength - 1 > right) {
        left = i;
        right = i + maxLength - 1;
      }

      z[i] = maxLength;
    }

    return z;
  }

  return {
    MultiDimensionalViewBuilder: MultiDimensionalViewBuilder,
    MultiDimensionalViewNode: MultiDimensionalViewNode,

    // Exports below are for testing only.
    RecursionDepthTracker: RecursionDepthTracker,
    zFunction: zFunction
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],44:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var PERCENTILE_PRECISION = 1e-7;
  /**
   * A function that consists of linear pieces.
   * See https://en.wikipedia.org/wiki/Piecewise_linear_function.
   * @constructor
   */
  function PiecewiseLinearFunction() {
    this.pieces = [];
  }

  PiecewiseLinearFunction.prototype = {
    /**
     * Push a linear piece defined by linear interpolation between.
     * (x1, y1) and (x2, y2).
     * Pieces must be pushed in the order of increasing x coordinate.
     */
    push: function (x1, y1, x2, y2) {
      if (x1 >= x2) throw new Error('Invalid segment');
      if (this.pieces.length > 0 && this.pieces[this.pieces.length - 1].x2 > x1) {
        throw new Error('Potentially overlapping segments');
      }
      if (x1 < x2) this.pieces.push(new Piece(x1, y1, x2, y2));
    },

    /**
     *  Returns the size of the set A such that for all x in A: f(x) < y.
     */
    partBelow: function (y) {
      return this.pieces.reduce((acc, p) => acc + p.partBelow(y), 0);
    },

    get min() {
      return this.pieces.reduce((acc, p) => Math.min(acc, p.min), Infinity);
    },

    get max() {
      return this.pieces.reduce((acc, p) => Math.max(acc, p.max), -Infinity);
    },

    get average() {
      var weightedSum = 0;
      var totalWeight = 0;
      this.pieces.forEach(function (piece) {
        weightedSum += piece.width * piece.average;
        totalWeight += piece.width;
      });
      if (totalWeight === 0) return 0;
      return weightedSum / totalWeight;
    },

    /**
    * Returns the minimum possible value y such that the percentage of x points
    * that have f(x) <= y is approximately equal to the given |percent|.
    */
    percentile: function (percent) {
      if (!(percent >= 0 && percent <= 1)) throw new Error('percent must be [0,1]');
      var lower = this.min;
      var upper = this.max;
      var total = this.partBelow(upper);
      if (total === 0) return 0;
      while (upper - lower > PERCENTILE_PRECISION) {
        var middle = (lower + upper) / 2;
        var below = this.partBelow(middle);
        if (below / total < percent) lower = middle;else upper = middle;
      }
      return (lower + upper) / 2;
    }
  };

  /**
  * A linear segment from (x1, y1) to (x2, y2).
  * @constructor
  */
  function Piece(x1, y1, x2, y2) {
    this.x1 = x1;
    this.y1 = y1;
    this.x2 = x2;
    this.y2 = y2;
  }

  Piece.prototype = {
    /**
    * The total length of all x points such that f(x) < y.
    * More formally:
    * max(x2 - x1) such that for all x in [x1 .. x2]: f(x) < y.
    */
    partBelow: function (y) {
      var width = this.width;
      if (width === 0) return 0;
      var minY = this.min;
      var maxY = this.max;
      if (y >= maxY) return width;
      if (y < minY) return 0;
      return (y - minY) / (maxY - minY) * width;
    },

    get min() {
      return Math.min(this.y1, this.y2);
    },

    get max() {
      return Math.max(this.y1, this.y2);
    },

    get average() {
      return (this.y1 + this.y2) / 2;
    },

    get width() {
      return this.x2 - this.x1;
    }
  };

  return {
    PiecewiseLinearFunction: PiecewiseLinearFunction
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],45:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./math.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var tmpVec2s = [];
  for (var i = 0; i < 8; i++) tmpVec2s[i] = vec2.create();

  var tmpVec2a = vec4.create();
  var tmpVec4a = vec4.create();
  var tmpVec4b = vec4.create();
  var tmpMat4 = mat4.create();
  var tmpMat4b = mat4.create();

  var p00 = vec2.createXY(0, 0);
  var p10 = vec2.createXY(1, 0);
  var p01 = vec2.createXY(0, 1);
  var p11 = vec2.createXY(1, 1);

  var lerpingVecA = vec2.create();
  var lerpingVecB = vec2.create();
  function lerpVec2(out, a, b, amt) {
    vec2.scale(lerpingVecA, a, amt);
    vec2.scale(lerpingVecB, b, 1 - amt);
    vec2.add(out, lerpingVecA, lerpingVecB);
    vec2.normalize(out, out);
    return out;
  }

  /**
   * @constructor
   */
  function Quad() {
    this.p1 = vec2.create();
    this.p2 = vec2.create();
    this.p3 = vec2.create();
    this.p4 = vec2.create();
  }

  Quad.fromXYWH = function (x, y, w, h) {
    var q = new Quad();
    vec2.set(q.p1, x, y);
    vec2.set(q.p2, x + w, y);
    vec2.set(q.p3, x + w, y + h);
    vec2.set(q.p4, x, y + h);
    return q;
  };

  Quad.fromRect = function (r) {
    return new Quad.fromXYWH(r.x, r.y, r.width, r.height);
  };

  Quad.from4Vecs = function (p1, p2, p3, p4) {
    var q = new Quad();
    vec2.set(q.p1, p1[0], p1[1]);
    vec2.set(q.p2, p2[0], p2[1]);
    vec2.set(q.p3, p3[0], p3[1]);
    vec2.set(q.p4, p4[0], p4[1]);
    return q;
  };

  Quad.from8Array = function (arr) {
    if (arr.length != 8) throw new Error('Array must be 8 long');
    var q = new Quad();
    q.p1[0] = arr[0];
    q.p1[1] = arr[1];
    q.p2[0] = arr[2];
    q.p2[1] = arr[3];
    q.p3[0] = arr[4];
    q.p3[1] = arr[5];
    q.p4[0] = arr[6];
    q.p4[1] = arr[7];
    return q;
  };

  Quad.prototype = {
    pointInside: function (point) {
      return pointInImplicitQuad(point, this.p1, this.p2, this.p3, this.p4);
    },

    boundingRect: function () {
      var x0 = Math.min(this.p1[0], this.p2[0], this.p3[0], this.p4[0]);
      var y0 = Math.min(this.p1[1], this.p2[1], this.p3[1], this.p4[1]);

      var x1 = Math.max(this.p1[0], this.p2[0], this.p3[0], this.p4[0]);
      var y1 = Math.max(this.p1[1], this.p2[1], this.p3[1], this.p4[1]);

      return new tr.b.Rect.fromXYWH(x0, y0, x1 - x0, y1 - y0);
    },

    clone: function () {
      var q = new Quad();
      vec2.copy(q.p1, this.p1);
      vec2.copy(q.p2, this.p2);
      vec2.copy(q.p3, this.p3);
      vec2.copy(q.p4, this.p4);
      return q;
    },

    scale: function (s) {
      var q = new Quad();
      this.scaleFast(q, s);
      return q;
    },

    scaleFast: function (dstQuad, s) {
      vec2.copy(dstQuad.p1, this.p1, s);
      vec2.copy(dstQuad.p2, this.p2, s);
      vec2.copy(dstQuad.p3, this.p3, s);
      vec2.copy(dstQuad.p3, this.p3, s);
    },

    isRectangle: function () {
      // Simple rectangle check. Note: will not handle out-of-order components.
      var bounds = this.boundingRect();
      return bounds.x == this.p1[0] && bounds.y == this.p1[1] && bounds.width == this.p2[0] - this.p1[0] && bounds.y == this.p2[1] && bounds.width == this.p3[0] - this.p1[0] && bounds.height == this.p3[1] - this.p2[1] && bounds.x == this.p4[0] && bounds.height == this.p4[1] - this.p2[1];
    },

    projectUnitRect: function (rect) {
      var q = new Quad();
      this.projectUnitRectFast(q, rect);
      return q;
    },

    projectUnitRectFast: function (dstQuad, rect) {
      var v12 = tmpVec2s[0];
      var v14 = tmpVec2s[1];
      var v23 = tmpVec2s[2];
      var v43 = tmpVec2s[3];
      var l12, l14, l23, l43;

      vec2.sub(v12, this.p2, this.p1);
      l12 = vec2.length(v12);
      vec2.scale(v12, v12, 1 / l12);

      vec2.sub(v14, this.p4, this.p1);
      l14 = vec2.length(v14);
      vec2.scale(v14, v14, 1 / l14);

      vec2.sub(v23, this.p3, this.p2);
      l23 = vec2.length(v23);
      vec2.scale(v23, v23, 1 / l23);

      vec2.sub(v43, this.p3, this.p4);
      l43 = vec2.length(v43);
      vec2.scale(v43, v43, 1 / l43);

      var b12 = tmpVec2s[0];
      var b14 = tmpVec2s[1];
      var b23 = tmpVec2s[2];
      var b43 = tmpVec2s[3];
      lerpVec2(b12, v12, v43, rect.y);
      lerpVec2(b43, v12, v43, 1 - rect.bottom);
      lerpVec2(b14, v14, v23, rect.x);
      lerpVec2(b23, v14, v23, 1 - rect.right);

      vec2.addTwoScaledUnitVectors(tmpVec2a, b12, l12 * rect.x, b14, l14 * rect.y);
      vec2.add(dstQuad.p1, this.p1, tmpVec2a);

      vec2.addTwoScaledUnitVectors(tmpVec2a, b12, l12 * -(1.0 - rect.right), b23, l23 * rect.y);
      vec2.add(dstQuad.p2, this.p2, tmpVec2a);

      vec2.addTwoScaledUnitVectors(tmpVec2a, b43, l43 * -(1.0 - rect.right), b23, l23 * -(1.0 - rect.bottom));
      vec2.add(dstQuad.p3, this.p3, tmpVec2a);

      vec2.addTwoScaledUnitVectors(tmpVec2a, b43, l43 * rect.left, b14, l14 * -(1.0 - rect.bottom));
      vec2.add(dstQuad.p4, this.p4, tmpVec2a);
    },

    toString: function () {
      return 'Quad(' + vec2.toString(this.p1) + ', ' + vec2.toString(this.p2) + ', ' + vec2.toString(this.p3) + ', ' + vec2.toString(this.p4) + ')';
    }
  };

  function sign(p1, p2, p3) {
    return (p1[0] - p3[0]) * (p2[1] - p3[1]) - (p2[0] - p3[0]) * (p1[1] - p3[1]);
  }

  function pointInTriangle2(pt, p1, p2, p3) {
    var b1 = sign(pt, p1, p2) < 0.0;
    var b2 = sign(pt, p2, p3) < 0.0;
    var b3 = sign(pt, p3, p1) < 0.0;
    return b1 == b2 && b2 == b3;
  }

  function pointInImplicitQuad(point, p1, p2, p3, p4) {
    return pointInTriangle2(point, p1, p2, p3) || pointInTriangle2(point, p1, p3, p4);
  }

  return {
    pointInTriangle2: pointInTriangle2,
    pointInImplicitQuad: pointInImplicitQuad,
    Quad: Quad
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./math.js":42}],46:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./utils.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS = 10;
  // The maximum amount of time that we allow for a task to get scheduled
  // in idle time before forcing the task to run.
  var REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS = 100;

  // Setting this to true will cause stack traces to get dumped into the
  // tasks. When an exception happens the original stack will be printed.
  //
  // NOTE: This should never be set committed as true.
  var recordRAFStacks = false;

  var pendingPreAFs = [];
  var pendingRAFs = [];
  var pendingIdleCallbacks = [];
  var currentRAFDispatchList = undefined;

  var rafScheduled = false;
  var idleWorkScheduled = false;

  function scheduleRAF() {
    if (rafScheduled) return;
    rafScheduled = true;
    if (tr.isHeadless) {
      Promise.resolve().then(function () {
        processRequests(false, 0);
      }, function (e) {
        console.log(e.stack);
        throw e;
      });
    } else {
      if (window.requestAnimationFrame) {
        window.requestAnimationFrame(processRequests.bind(this, false));
      } else {
        var delta = Date.now() - window.performance.now();
        window.webkitRequestAnimationFrame(function (domTimeStamp) {
          processRequests(false, domTimeStamp - delta);
        });
      }
    }
  }

  function nativeRequestIdleCallbackSupported() {
    return !tr.isHeadless && window.requestIdleCallback;
  }

  function scheduleIdleWork() {
    if (idleWorkScheduled) return;
    if (!nativeRequestIdleCallbackSupported()) {
      scheduleRAF();
      return;
    }
    idleWorkScheduled = true;
    window.requestIdleCallback(function (deadline, didTimeout) {
      processIdleWork(false /* forceAllTasksToRun */, deadline);
    }, { timeout: REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS });
  }

  function onAnimationFrameError(e, opt_stack) {
    console.log(e.stack);
    if (tr.isHeadless) throw e;

    if (opt_stack) console.log(opt_stack);

    if (e.message) console.error(e.message, e.stack);else console.error(e);
  }

  function runTask(task, frameBeginTime) {
    try {
      task.callback.call(task.context, frameBeginTime);
    } catch (e) {
      tr.b.onAnimationFrameError(e, task.stack);
    }
  }

  function processRequests(forceAllTasksToRun, frameBeginTime) {
    rafScheduled = false;

    var currentPreAFs = pendingPreAFs;
    currentRAFDispatchList = pendingRAFs;
    pendingPreAFs = [];
    pendingRAFs = [];
    var hasRAFTasks = currentPreAFs.length || currentRAFDispatchList.length;

    for (var i = 0; i < currentPreAFs.length; i++) runTask(currentPreAFs[i], frameBeginTime);

    while (currentRAFDispatchList.length > 0) runTask(currentRAFDispatchList.shift(), frameBeginTime);
    currentRAFDispatchList = undefined;

    if (!hasRAFTasks && !nativeRequestIdleCallbackSupported() || forceAllTasksToRun) {
      // We assume that we want to do a fixed maximum amount of optional work
      // per frame. Hopefully rAF will eventually pass this in for us.
      var rafCompletionDeadline = frameBeginTime + ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS;
      processIdleWork(forceAllTasksToRun, {
        timeRemaining: function () {
          return rafCompletionDeadline - window.performance.now();
        }
      });
    }

    if (pendingIdleCallbacks.length > 0) scheduleIdleWork();
  }

  function processIdleWork(forceAllTasksToRun, deadline) {
    idleWorkScheduled = false;
    while (pendingIdleCallbacks.length > 0) {
      runTask(pendingIdleCallbacks.shift());
      // Check timer after running at least one idle task to avoid buggy
      // window.performance.now() on some platforms from blocking the idle
      // task queue.
      if (!forceAllTasksToRun && (tr.isHeadless || deadline.timeRemaining() <= 0)) {
        break;
      }
    }

    if (pendingIdleCallbacks.length > 0) scheduleIdleWork();
  }

  function getStack_() {
    if (!recordRAFStacks) return '';

    var stackLines = tr.b.stackTrace();
    // Strip off getStack_.
    stackLines.shift();
    return stackLines.join('\n');
  }

  function requestPreAnimationFrame(callback, opt_this) {
    pendingPreAFs.push({
      callback: callback,
      context: opt_this || global,
      stack: getStack_() });
    scheduleRAF();
  }

  function requestAnimationFrameInThisFrameIfPossible(callback, opt_this) {
    if (!currentRAFDispatchList) {
      requestAnimationFrame(callback, opt_this);
      return;
    }
    currentRAFDispatchList.push({
      callback: callback,
      context: opt_this || global,
      stack: getStack_() });
    return;
  }

  function requestAnimationFrame(callback, opt_this) {
    pendingRAFs.push({
      callback: callback,
      context: opt_this || global,
      stack: getStack_() });
    scheduleRAF();
  }

  function requestIdleCallback(callback, opt_this) {
    pendingIdleCallbacks.push({
      callback: callback,
      context: opt_this || global,
      stack: getStack_() });
    scheduleIdleWork();
  }

  function forcePendingRAFTasksToRun(frameBeginTime) {
    if (!rafScheduled) return;
    processRequests(false, frameBeginTime);
  }

  function forceAllPendingTasksToRunForTest() {
    if (!rafScheduled && !idleWorkScheduled) return;
    processRequests(true, 0);
  }

  return {
    onAnimationFrameError: onAnimationFrameError,
    requestPreAnimationFrame: requestPreAnimationFrame,
    requestAnimationFrame: requestAnimationFrame,
    requestAnimationFrameInThisFrameIfPossible: requestAnimationFrameInThisFrameIfPossible,
    requestIdleCallback: requestIdleCallback,
    forcePendingRAFTasksToRun: forcePendingRAFTasksToRun,
    forceAllPendingTasksToRunForTest: forceAllPendingTasksToRunForTest
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./utils.js":59}],47:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./iteration_helpers.js");
require("./math.js");

'use strict';

/**
 * @fileoverview Quick range computations.
 */
global.tr.exportTo('tr.b', function () {

  function Range() {
    this.isEmpty_ = true;
    this.min_ = undefined;
    this.max_ = undefined;
  }

  Range.prototype = {
    __proto__: Object.prototype,

    reset: function () {
      this.isEmpty_ = true;
      this.min_ = undefined;
      this.max_ = undefined;
    },

    get isEmpty() {
      return this.isEmpty_;
    },

    addRange: function (range) {
      if (range.isEmpty) return;
      this.addValue(range.min);
      this.addValue(range.max);
    },

    addValue: function (value) {
      if (this.isEmpty_) {
        this.max_ = value;
        this.min_ = value;
        this.isEmpty_ = false;
        return;
      }
      this.max_ = Math.max(this.max_, value);
      this.min_ = Math.min(this.min_, value);
    },

    set min(min) {
      this.isEmpty_ = false;
      this.min_ = min;
    },

    get min() {
      if (this.isEmpty_) return undefined;
      return this.min_;
    },

    get max() {
      if (this.isEmpty_) return undefined;
      return this.max_;
    },

    set max(max) {
      this.isEmpty_ = false;
      this.max_ = max;
    },

    get range() {
      if (this.isEmpty_) return undefined;
      return this.max_ - this.min_;
    },

    get center() {
      return (this.min_ + this.max_) * 0.5;
    },

    get duration() {
      if (this.isEmpty_) return 0;
      return this.max_ - this.min_;
    },

    normalize: function (x) {
      return tr.b.normalize(x, this.min, this.max);
    },

    lerp: function (x) {
      return tr.b.lerp(x, this.min, this.max);
    },

    equals: function (that) {
      if (this.isEmpty && that.isEmpty) return true;
      if (this.isEmpty != that.isEmpty) return false;
      return tr.b.approximately(this.min, that.min) && tr.b.approximately(this.max, that.max);
    },

    containsExplicitRangeInclusive: function (min, max) {
      if (this.isEmpty) return false;
      return this.min_ <= min && max <= this.max_;
    },

    containsExplicitRangeExclusive: function (min, max) {
      if (this.isEmpty) return false;
      return this.min_ < min && max < this.max_;
    },

    intersectsExplicitRangeInclusive: function (min, max) {
      if (this.isEmpty) return false;
      return this.min_ <= max && min <= this.max_;
    },

    intersectsExplicitRangeExclusive: function (min, max) {
      if (this.isEmpty) return false;
      return this.min_ < max && min < this.max_;
    },

    containsRangeInclusive: function (range) {
      if (range.isEmpty) return false;
      return this.containsExplicitRangeInclusive(range.min_, range.max_);
    },

    containsRangeExclusive: function (range) {
      if (range.isEmpty) return false;
      return this.containsExplicitRangeExclusive(range.min_, range.max_);
    },

    intersectsRangeInclusive: function (range) {
      if (range.isEmpty) return false;
      return this.intersectsExplicitRangeInclusive(range.min_, range.max_);
    },

    intersectsRangeExclusive: function (range) {
      if (range.isEmpty) return false;
      return this.intersectsExplicitRangeExclusive(range.min_, range.max_);
    },

    findExplicitIntersectionDuration: function (min, max) {
      var min = Math.max(this.min, min);
      var max = Math.min(this.max, max);
      if (max < min) return 0;
      return max - min;
    },

    findIntersection: function (range) {
      if (this.isEmpty || range.isEmpty) return new Range();

      var min = Math.max(this.min, range.min);
      var max = Math.min(this.max, range.max);

      if (max < min) return new Range();

      return Range.fromExplicitRange(min, max);
    },

    toJSON: function () {
      if (this.isEmpty_) return { isEmpty: true };
      return {
        isEmpty: false,
        max: this.max,
        min: this.min
      };
    },

    /**
     * Returns a slice of the input array that intersects with this range
     * inclusively.
     * If the range does not have a min, it is treated as unbounded from below.
     * Similarly, if max is undefined, the range is unbounded from above.
     *
     * @param {Array} array The array of elements to be filtered.
     * @param {Funcation=} opt_keyFunc A function that extracts a numeric value,
     *        to be used in comparisons, from an element of the array. If not
     *        specified, array elements themselves will be used.
     * @param {Object=} opt_this An optional this argument to be passed to
     *        opt_keyFunc.
     */
    filterArray: function (array, opt_keyFunc, opt_this) {
      if (this.isEmpty_) return [];
      // Binary search. |test| is a function that should return true when we
      // need to explore the left branch and false to explore the right branch.
      function binSearch(test) {
        var i0 = 0;
        var i1 = array.length;
        while (i0 < i1) {
          var i = Math.trunc((i0 + i1) / 2);
          if (test(i)) i1 = i; // Explore the left branch.
          else i0 = i + 1; // Explore the right branch.
        }
        return i1;
      }

      var keyFunc = opt_keyFunc || tr.b.identity;
      function getValue(index) {
        return keyFunc.call(opt_this, array[index]);
      }

      var first = binSearch(function (i) {
        return this.min_ === undefined || this.min_ <= getValue(i);
      }.bind(this));
      var last = binSearch(function (i) {
        return this.max_ !== undefined && this.max_ < getValue(i);
      }.bind(this));
      return array.slice(first, last);
    }
  };

  Range.fromDict = function (d) {
    if (d.isEmpty === true) {
      return new Range();
    } else if (d.isEmpty === false) {
      var range = new Range();
      range.min = d.min;
      range.max = d.max;
      return range;
    } else {
      throw new Error('Not a range');
    }
  };

  Range.fromExplicitRange = function (min, max) {
    var range = new Range();
    range.min = min;
    range.max = max;
    return range;
  };

  Range.compareByMinTimes = function (a, b) {
    if (!a.isEmpty && !b.isEmpty) return a.min_ - b.min_;

    if (a.isEmpty && !b.isEmpty) return -1;

    if (!a.isEmpty && b.isEmpty) return 1;

    return 0;
  };

  Range.PERCENT_RANGE = Range.fromExplicitRange(0, 1);
  Object.freeze(Range.PERCENT_RANGE);

  return {
    Range: Range
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./iteration_helpers.js":41,"./math.js":42}],48:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./iteration_helpers.js");

'use strict';

/**
 * @fileoverview Provides event merging functionality for grouping/analysis.
 */
global.tr.exportTo('tr.b', function () {
  function convertEventsToRanges(events) {
    return events.map(function (event) {
      return tr.b.Range.fromExplicitRange(event.start, event.end);
    });
  }

  function mergeRanges(inRanges, mergeThreshold, mergeFunction) {
    var remainingEvents = inRanges.slice();
    remainingEvents.sort(function (x, y) {
      return x.min - y.min;
    });

    if (remainingEvents.length <= 1) {
      var merged = [];
      if (remainingEvents.length == 1) {
        merged.push(mergeFunction(remainingEvents));
      }
      return merged;
    }

    var mergedEvents = [];

    var currentMergeBuffer = [];
    var rightEdge;
    function beginMerging() {
      currentMergeBuffer.push(remainingEvents[0]);
      remainingEvents.splice(0, 1);
      rightEdge = currentMergeBuffer[0].max;
    }

    function flushCurrentMergeBuffer() {
      if (currentMergeBuffer.length == 0) return;

      mergedEvents.push(mergeFunction(currentMergeBuffer));
      currentMergeBuffer = [];

      // Refill merge buffer if needed.
      if (remainingEvents.length != 0) beginMerging();
    }

    beginMerging();

    while (remainingEvents.length) {
      var currentEvent = remainingEvents[0];

      var distanceFromRightEdge = currentEvent.min - rightEdge;
      if (distanceFromRightEdge < mergeThreshold) {
        rightEdge = Math.max(rightEdge, currentEvent.max);
        remainingEvents.splice(0, 1);
        currentMergeBuffer.push(currentEvent);
        continue;
      }

      // Too big a gap.
      flushCurrentMergeBuffer();
    }
    flushCurrentMergeBuffer();

    return mergedEvents;
  }

  // Pass in |opt_totalRange| in order to find empty ranges before the first of
  // |inRanges| and after the last of |inRanges|.
  function findEmptyRangesBetweenRanges(inRanges, opt_totalRange) {
    if (opt_totalRange && opt_totalRange.isEmpty) opt_totalRange = undefined;

    var emptyRanges = [];
    if (!inRanges.length) {
      if (opt_totalRange) emptyRanges.push(opt_totalRange);
      return emptyRanges;
    }

    inRanges = inRanges.slice();
    inRanges.sort(function (x, y) {
      return x.min - y.min;
    });
    if (opt_totalRange && opt_totalRange.min < inRanges[0].min) {
      emptyRanges.push(tr.b.Range.fromExplicitRange(opt_totalRange.min, inRanges[0].min));
    }

    inRanges.forEach(function (range, index) {
      for (var otherIndex = 0; otherIndex < inRanges.length; ++otherIndex) {
        if (index === otherIndex) continue;
        var other = inRanges[otherIndex];

        if (other.min > range.max) {
          // |inRanges| is sorted, so |other| is the first range after |range|,
          // and there is an empty range between them.
          emptyRanges.push(tr.b.Range.fromExplicitRange(range.max, other.min));
          return;
        }
        // Otherwise, |other| starts before |range| ends, so |other| might
        // possibly contain the end of |range|.

        if (other.max > range.max) {
          // |other| does contain the end of |range|, so no empty range starts
          // at the end of this |range|.
          return;
        }
      }
      if (opt_totalRange && range.max < opt_totalRange.max) {
        emptyRanges.push(tr.b.Range.fromExplicitRange(range.max, opt_totalRange.max));
      }
    });
    return emptyRanges;
  }

  return {
    convertEventsToRanges: convertEventsToRanges,
    findEmptyRangesBetweenRanges: findEmptyRangesBetweenRanges,
    mergeRanges: mergeRanges
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./iteration_helpers.js":41}],49:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./math.js");

'use strict';

global.tr.exportTo('tr.b', function () {

  /**
   * Tracks a 2D bounding box.
   * @constructor
   */
  function Rect() {
    this.x = 0;
    this.y = 0;
    this.width = 0;
    this.height = 0;
  };
  Rect.fromXYWH = function (x, y, w, h) {
    var rect = new Rect();
    rect.x = x;
    rect.y = y;
    rect.width = w;
    rect.height = h;
    return rect;
  };
  Rect.fromArray = function (ary) {
    if (ary.length != 4) throw new Error('ary.length must be 4');
    var rect = new Rect();
    rect.x = ary[0];
    rect.y = ary[1];
    rect.width = ary[2];
    rect.height = ary[3];
    return rect;
  };

  Rect.prototype = {
    __proto__: Object.prototype,

    get left() {
      return this.x;
    },

    get top() {
      return this.y;
    },

    get right() {
      return this.x + this.width;
    },

    get bottom() {
      return this.y + this.height;
    },

    toString: function () {
      return 'Rect(' + this.x + ', ' + this.y + ', ' + this.width + ', ' + this.height + ')';
    },

    toArray: function () {
      return [this.x, this.y, this.width, this.height];
    },

    clone: function () {
      var rect = new Rect();
      rect.x = this.x;
      rect.y = this.y;
      rect.width = this.width;
      rect.height = this.height;
      return rect;
    },

    enlarge: function (pad) {
      var rect = new Rect();
      this.enlargeFast(rect, pad);
      return rect;
    },

    enlargeFast: function (out, pad) {
      out.x = this.x - pad;
      out.y = this.y - pad;
      out.width = this.width + 2 * pad;
      out.height = this.height + 2 * pad;
      return out;
    },

    size: function () {
      return { width: this.width, height: this.height };
    },

    scale: function (s) {
      var rect = new Rect();
      this.scaleFast(rect, s);
      return rect;
    },

    scaleSize: function (s) {
      return Rect.fromXYWH(this.x, this.y, this.width * s, this.height * s);
    },

    scaleFast: function (out, s) {
      out.x = this.x * s;
      out.y = this.y * s;
      out.width = this.width * s;
      out.height = this.height * s;
      return out;
    },

    translate: function (v) {
      var rect = new Rect();
      this.translateFast(rect, v);
      return rect;
    },

    translateFast: function (out, v) {
      out.x = this.x + v[0];
      out.y = this.x + v[1];
      out.width = this.width;
      out.height = this.height;
      return out;
    },

    asUVRectInside: function (containingRect) {
      var rect = new Rect();
      rect.x = (this.x - containingRect.x) / containingRect.width;
      rect.y = (this.y - containingRect.y) / containingRect.height;
      rect.width = this.width / containingRect.width;
      rect.height = this.height / containingRect.height;
      return rect;
    },

    intersects: function (that) {
      var ok = true;
      ok &= this.x < that.right;
      ok &= this.right > that.x;
      ok &= this.y < that.bottom;
      ok &= this.bottom > that.y;
      return ok;
    },

    equalTo: function (rect) {
      return rect && this.x === rect.x && this.y === rect.y && this.width === rect.width && this.height === rect.height;
    }
  };

  return {
    Rect: Rect
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./math.js":42}],50:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  /***
  * An object of this class computes basic statistics online in O(1).
  * Usage:
  * 1. Create an instance.
  * 2. Add numbers using the |add| method.
  * 3. Query statistics.
  * 4. Repeat from step 2.
  */
  class RunningStatistics {
    constructor() {
      this.mean_ = 0;
      this.count_ = 0;
      this.max_ = -Infinity;
      this.min_ = Infinity;
      this.sum_ = 0;
      this.variance_ = 0;

      // Mean of logarithms of absolute values of samples, or undefined if any
      // samples were <= 0.
      this.meanlogs_ = 0;
    }

    get count() {
      return this.count_;
    }

    get geometricMean() {
      if (this.meanlogs_ === undefined) return 0;
      return Math.exp(this.meanlogs_);
    }

    get mean() {
      if (this.count_ == 0) return undefined;
      return this.mean_;
    }

    get max() {
      return this.max_;
    }

    get min() {
      return this.min_;
    }

    get sum() {
      return this.sum_;
    }

    get variance() {
      if (this.count_ == 0) return undefined;
      if (this.count_ == 1) return 0;
      return this.variance_ / (this.count_ - 1);
    }

    get stddev() {
      if (this.count_ == 0) return undefined;
      return Math.sqrt(this.variance);
    }

    add(x) {
      this.count_++;
      this.max_ = Math.max(this.max_, x);
      this.min_ = Math.min(this.min_, x);
      this.sum_ += x;

      // The geometric mean is computed using the arithmetic mean of logarithms.
      if (x <= 0) this.meanlogs_ = undefined;else if (this.meanlogs_ !== undefined) this.meanlogs_ += (Math.log(Math.abs(x)) - this.meanlogs_) / this.count;

      // The following uses Welford's algorithm for computing running mean
      // and variance. See http://www.johndcook.com/blog/standard_deviation.
      if (this.count_ === 1) {
        this.mean_ = x;
        this.variance_ = 0;
      } else {
        var oldMean = this.mean_;
        var oldVariance = this.variance_;
        // Using the 2nd formula for updating the mean yields better precision
        // but it doesn't work for the case oldMean is Infinity. Hence we handle
        // that case separately.
        if (oldMean === Infinity || oldMean === -Infinity) {
          this.mean_ = this.sum_ / this.count_;
        } else {
          this.mean_ = oldMean + (x - oldMean) / this.count_;
        }
        this.variance_ = oldVariance + (x - oldMean) * (x - this.mean_);
      }
    }

    merge(other) {
      var result = new RunningStatistics();
      result.count_ = this.count_ + other.count_;
      result.sum_ = this.sum_ + other.sum_;
      result.min_ = Math.min(this.min_, other.min_);
      result.max_ = Math.max(this.max_, other.max_);
      if (result.count === 0) {
        result.mean_ = 0;
        result.variance_ = 0;
        result.meanlogs_ = 0;
      } else {
        // Combine the mean and the variance using the formulas from
        // https://goo.gl/ddcAep.
        result.mean_ = result.sum / result.count;
        var deltaMean = (this.mean || 0) - (other.mean || 0);
        result.variance_ = this.variance_ + other.variance_ + this.count * other.count * deltaMean * deltaMean / result.count;

        // Merge the arithmetic means of logarithms of absolute values of
        // samples, weighted by counts.
        if (this.meanlogs_ === undefined || other.meanlogs_ === undefined) {
          result.meanlogs_ = undefined;
        } else {
          result.meanlogs_ = (this.count * this.meanlogs_ + other.count * other.meanlogs_) / result.count;
        }
      }
      return result;
    }

    asDict() {
      if (!this.count) {
        return [];
      }
      // It's more efficient to serialize these fields in an array. If you
      // add any other fields, you should re-evaluate whether it would be more
      // efficient to serialize as a dict.
      return [this.count_, this.max_, this.meanlogs_, this.mean_, this.min_, this.sum_, this.variance_];
    }

    static fromDict(dict) {
      var result = new RunningStatistics();
      if (dict.length != 7) {
        return result;
      }

      var _dict = _slicedToArray(dict, 7);

      result.count_ = _dict[0];
      result.max_ = _dict[1];
      result.meanlogs_ = _dict[2];
      result.mean_ = _dict[3];
      result.min_ = _dict[4];
      result.sum_ = _dict[5];
      result.variance_ = _dict[6];

      return result;
    }
  }

  return {
    RunningStatistics: RunningStatistics
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],51:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./color.js");
require("./iteration_helpers.js");
require("./math.js");

'use strict';
global.tr.exportTo('tr.b', function () {
  /**
   * Generate pretty colors!
   * http://basecase.org/env/on-rainbows
   * https://mycarta.wordpress.com/2012/10/06/the-rainbow-is-deadlong-live-the-rainbow-part-3/
   *
   * Set brightness = 0 to always generate black.
   * Set brightness = 2 to always generate white.
   * Set brightness = 1 to generate saturated colors.
   *
   * @constructor
   * @param {number=} opt_a alpha opacity in [0,1]
   * @param {number=} opt_brightness in [0,2]
   */
  function SinebowColorGenerator(opt_a, opt_brightness) {
    this.a_ = opt_a === undefined ? 1 : opt_a;
    this.brightness_ = opt_brightness === undefined ? 1 : opt_brightness;
    this.colorIndex_ = 0;
    this.keyToColor = {};
  }

  SinebowColorGenerator.prototype = {
    colorForKey: function (key) {
      if (!this.keyToColor[key]) this.keyToColor[key] = this.nextColor();
      return this.keyToColor[key];
    },

    nextColor: function () {
      var components = SinebowColorGenerator.nthColor(this.colorIndex_++);
      return tr.b.Color.fromString(SinebowColorGenerator.calculateColor(components[0], components[1], components[2], this.a_, this.brightness_));
    }
  };

  SinebowColorGenerator.PHI = (1 + Math.sqrt(5)) / 2;

  SinebowColorGenerator.sinebow_ = function (h) {
    h += 0.5;
    h = -h;
    var r = Math.sin(Math.PI * h);
    var g = Math.sin(Math.PI * (h + 1 / 3));
    var b = Math.sin(Math.PI * (h + 2 / 3));
    r *= r;g *= g;b *= b;
    // Roughly correct for human perception.
    // https://en.wikipedia.org/wiki/Luma_%28video%29
    // Multiply by 2 to normalize all values to 0.5.
    // (Halfway between black and white.)
    var y = 2 * (0.2989 * r + 0.5870 * g + 0.1140 * b);
    r /= y;g /= y;b /= y;
    return [256 * r, 256 * g, 256 * b];
  };

  SinebowColorGenerator.nthColor = function (n) {
    return SinebowColorGenerator.sinebow_(n * this.PHI);
  };

  SinebowColorGenerator.calculateColor = function (r, g, b, a, brightness) {
    if (brightness <= 1) {
      r *= brightness;
      g *= brightness;
      b *= brightness;
    } else {
      r = tr.b.lerp(tr.b.normalize(brightness, 1, 2), r, 255);
      g = tr.b.lerp(tr.b.normalize(brightness, 1, 2), g, 255);
      b = tr.b.lerp(tr.b.normalize(brightness, 1, 2), b, 255);
    }
    r = Math.round(r);
    g = Math.round(g);
    b = Math.round(b);
    return 'rgba(' + r + ',' + g + ',' + b + ', ' + a + ')';
  };

  return {
    SinebowColorGenerator: SinebowColorGenerator
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./color.js":31,"./iteration_helpers.js":41,"./math.js":42}],52:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

/**
 * @fileoverview Helper functions for doing intersections and iteration
 * over sorted arrays and intervals.
 *
 */
global.tr.exportTo('tr.b', function () {
  /**
   * Finds the first index in the array whose value is >= loVal.
   *
   * The key for the search is defined by the mapFn. This array must
   * be prearranged such that ary.map(mapFn) would also be sorted in
   * ascending order.
   *
   * @param {Array} ary An array of arbitrary objects.
   * @param {function():*} mapFn Callback that produces a key value
   *     from an element in ary.
   * @param {number} loVal Value for which to search.
   * @return {Number} Offset o into ary where all ary[i] for i <= o
   *     are < loVal, or ary.length if loVal is greater than all elements in
   *     the array.
   */
  function findLowIndexInSortedArray(ary, mapFn, loVal) {
    if (ary.length == 0) return 1;

    var low = 0;
    var high = ary.length - 1;
    var i, comparison;
    var hitPos = -1;
    while (low <= high) {
      i = Math.floor((low + high) / 2);
      comparison = mapFn(ary[i]) - loVal;
      if (comparison < 0) {
        low = i + 1;continue;
      } else if (comparison > 0) {
        high = i - 1;continue;
      } else {
        hitPos = i;
        high = i - 1;
      }
    }
    // return where we hit, or failing that the low pos
    return hitPos != -1 ? hitPos : low;
  }

  // From devtools/front_end/platform/utilities.js upperBound
  function findHighIndexInSortedArray(ary, mapFn, loVal, hiVal) {
    var lo = loVal || 0;
    var hi = hiVal !== undefined ? hiVal : ary.length;
    while (lo < hi) {
      var mid = lo + hi >> 1;
      if (mapFn(ary[mid]) >= 0) lo = mid + 1;else hi = mid;
    }
    return hi;
  }

  /**
   * Finds an index in an array of intervals that either intersects
   * the provided loVal, or if no intersection is found, -1 or ary.length.
   *
   * The array of intervals is defined implicitly via two mapping functions
   * over the provided ary. mapLoFn determines the lower value of the interval,
   * mapWidthFn the width. Intersection is lower-inclusive, e.g. [lo,lo+w).
   *
   * The array of intervals formed by this mapping must be non-overlapping and
   * sorted in ascending order by loVal.
   *
   * @param {Array} ary An array of objects that can be converted into sorted
   *     nonoverlapping ranges [x,y) using the mapLoFn and mapWidth.
   * @param {function():*} mapLoFn Callback that produces the low value for the
   *     interval represented by an  element in the array.
   * @param {function():*} mapWidthFn Callback that produces the width for the
   *     interval represented by an  element in the array.
   * @param {number} loVal The low value for the search.
   * @return {Number} An index in the array that intersects or is first-above
   *     loVal, -1 if none found and loVal is below than all the intervals,
   *     ary.length if loVal is greater than all the intervals.
   */
  function findIndexInSortedIntervals(ary, mapLoFn, mapWidthFn, loVal) {
    var first = findLowIndexInSortedArray(ary, mapLoFn, loVal);
    if (first == 0) {
      if (loVal >= mapLoFn(ary[0]) && loVal < mapLoFn(ary[0]) + mapWidthFn(ary[0], 0)) {
        return 0;
      } else {
        return -1;
      }
    } else if (first < ary.length) {
      if (loVal >= mapLoFn(ary[first]) && loVal < mapLoFn(ary[first]) + mapWidthFn(ary[first], first)) {
        return first;
      } else if (loVal >= mapLoFn(ary[first - 1]) && loVal < mapLoFn(ary[first - 1]) + mapWidthFn(ary[first - 1], first - 1)) {
        return first - 1;
      } else {
        return ary.length;
      }
    } else if (first == ary.length) {
      if (loVal >= mapLoFn(ary[first - 1]) && loVal < mapLoFn(ary[first - 1]) + mapWidthFn(ary[first - 1], first - 1)) {
        return first - 1;
      } else {
        return ary.length;
      }
    } else {
      return ary.length;
    }
  }

  /**
   * Finds an index in an array of sorted closed intervals that either
   * intersects the provided val, or if no intersection is found, -1 or
   *  ary.length.
   *
   * The array of intervals is defined implicitly via two mapping functions
   * over the provided ary. mapLoFn determines the lower value of the interval,
   * mapHiFn the high. Intersection is closed, e.g. [lo,hi], unlike with
   * findIndexInSortedIntervals, which is right-open.
   *
   * The array of intervals formed by this mapping must be non-overlapping, and
   * sorted in ascending order by val.
   *
   * @param {Array} ary An array of objects that can be converted into sorted
   *     nonoverlapping ranges [x,y) using the mapLoFn and mapWidth.
   * @param {function():*} mapLoFn Callback that produces the low value for the
   *     interval represented by an  element in the array.
   * @param {function():*} mapHiFn Callback that produces the high for the
   *     interval represented by an  element in the array.
   * @param {number} val The value for the search.
   * @return {Number} An index in the array that intersects or is first-above
   *     val, -1 if none found and val is below than all the intervals,
   *     ary.length if val is greater than all the intervals.
   */
  function findIndexInSortedClosedIntervals(ary, mapLoFn, mapHiFn, val) {
    var i = findLowIndexInSortedArray(ary, mapLoFn, val);
    if (i === 0) {
      if (val >= mapLoFn(ary[0], 0) && val <= mapHiFn(ary[0], 0)) {
        return 0;
      } else {
        return -1;
      }
    } else if (i < ary.length) {
      if (val >= mapLoFn(ary[i - 1], i - 1) && val <= mapHiFn(ary[i - 1], i - 1)) {
        return i - 1;
      } else if (val >= mapLoFn(ary[i], i) && val <= mapHiFn(ary[i], i)) {
        return i;
      } else {
        return ary.length;
      }
    } else if (i == ary.length) {
      if (val >= mapLoFn(ary[i - 1], i - 1) && val <= mapHiFn(ary[i - 1], i - 1)) {
        return i - 1;
      } else {
        return ary.length;
      }
    } else {
      return ary.length;
    }
  }

  /**
   * Calls cb for all intervals in the implicit array of intervals
   * defnied by ary, mapLoFn and mapHiFn that intersect the range
   * [loVal,hiVal)
   *
   * This function uses the same scheme as findLowIndexInSortedArray
   * to define the intervals. The same restrictions on sortedness and
   * non-overlappingness apply.
   *
   * @param {Array} ary An array of objects that can be converted into sorted
   * nonoverlapping ranges [x,y) using the mapLoFn and mapWidth.
   * @param {function():*} mapLoFn Callback that produces the low value for the
   * interval represented by an element in the array.
   * @param {function():*} mapWidthFn Callback that produces the width for the
   * interval represented by an element in the array.
   * @param {number} loVal The low value for the search, inclusive.
   * @param {number} hiVal The high value for the search, non inclusive.
   * @param {function():*} cb The function to run for intersecting intervals.
   */
  function iterateOverIntersectingIntervals(ary, mapLoFn, mapWidthFn, loVal, hiVal, cb) {
    if (ary.length == 0) return;

    if (loVal > hiVal) return;

    var i = findLowIndexInSortedArray(ary, mapLoFn, loVal);
    if (i == -1) {
      return;
    }
    if (i > 0) {
      var hi = mapLoFn(ary[i - 1]) + mapWidthFn(ary[i - 1], i - 1);
      if (hi >= loVal) {
        cb(ary[i - 1], i - 1);
      }
    }
    if (i == ary.length) {
      return;
    }

    for (var n = ary.length; i < n; i++) {
      var lo = mapLoFn(ary[i]);
      if (lo >= hiVal) break;
      cb(ary[i], i);
    }
  }

  /**
   * Non iterative version of iterateOverIntersectingIntervals.
   *
   * @return {Array} Array of elements in ary that intersect loVal, hiVal.
   */
  function getIntersectingIntervals(ary, mapLoFn, mapWidthFn, loVal, hiVal) {
    var tmp = [];
    iterateOverIntersectingIntervals(ary, mapLoFn, mapWidthFn, loVal, hiVal, function (d) {
      tmp.push(d);
    });
    return tmp;
  }

  /**
   * Finds the element in the array whose value is closest to |val|.
   *
   * The same restrictions on sortedness as for findLowIndexInSortedArray apply.
   *
   * @param {Array} ary An array of arbitrary objects.
   * @param {function():*} mapFn Callback that produces a key value
   *     from an element in ary.
   * @param {number} val Value for which to search.
   * @param {number} maxDiff Maximum allowed difference in value between |val|
   *     and an element's value.
   * @return {object} Object in the array whose value is closest to |val|, or
   *     null if no object is within range.
   */
  function findClosestElementInSortedArray(ary, mapFn, val, maxDiff) {
    if (ary.length === 0) return null;

    var aftIdx = findLowIndexInSortedArray(ary, mapFn, val);
    var befIdx = aftIdx > 0 ? aftIdx - 1 : 0;

    if (aftIdx === ary.length) aftIdx -= 1;

    var befDiff = Math.abs(val - mapFn(ary[befIdx]));
    var aftDiff = Math.abs(val - mapFn(ary[aftIdx]));

    if (befDiff > maxDiff && aftDiff > maxDiff) return null;

    var idx = befDiff < aftDiff ? befIdx : aftIdx;
    return ary[idx];
  }

  /**
   * Finds the closest interval in the implicit array of intervals
   * defined by ary, mapLoFn and mapHiFn.
   *
   * This function uses the same scheme as findLowIndexInSortedArray
   * to define the intervals. The same restrictions on sortedness and
   * non-overlappingness apply.
   *
   * @param {Array} ary An array of objects that can be converted into sorted
   *     nonoverlapping ranges [x,y) using the mapLoFn and mapHiFn.
   * @param {function():*} mapLoFn Callback that produces the low value for the
   *     interval represented by an element in the array.
   * @param {function():*} mapHiFn Callback that produces the high for the
   *     interval represented by an element in the array.
   * @param {number} val The value for the search.
   * @param {number} maxDiff Maximum allowed difference in value between |val|
   *     and an interval's low or high value.
   * @return {interval} Interval in the array whose high or low value is closest
   *     to |val|, or null if no interval is within range.
   */
  function findClosestIntervalInSortedIntervals(ary, mapLoFn, mapHiFn, val, maxDiff) {
    if (ary.length === 0) return null;

    var idx = findLowIndexInSortedArray(ary, mapLoFn, val);
    if (idx > 0) idx -= 1;

    var hiInt = ary[idx];
    var loInt = hiInt;

    if (val > mapHiFn(hiInt) && idx + 1 < ary.length) loInt = ary[idx + 1];

    var loDiff = Math.abs(val - mapLoFn(loInt));
    var hiDiff = Math.abs(val - mapHiFn(hiInt));

    if (loDiff > maxDiff && hiDiff > maxDiff) return null;

    if (loDiff < hiDiff) return loInt;else return hiInt;
  }

  return {
    findLowIndexInSortedArray: findLowIndexInSortedArray,
    findHighIndexInSortedArray: findHighIndexInSortedArray,
    findIndexInSortedIntervals: findIndexInSortedIntervals,
    findIndexInSortedClosedIntervals: findIndexInSortedClosedIntervals,
    iterateOverIntersectingIntervals: iterateOverIntersectingIntervals,
    getIntersectingIntervals: getIntersectingIntervals,
    findClosestElementInSortedArray: findClosestElementInSortedArray,
    findClosestIntervalInSortedIntervals: findClosestIntervalInSortedIntervals
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],53:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./math.js");
require("./range.js");

'use strict';

// In node, the script-src for mannwhitneyu above brings in mannwhitneyui
// into a module, instead of into the global scope. Whereas this file
// assumes that mannwhitneyu is in the global scope. So, in Node only, we
// require() it in, and then take all its exports and shove them into the
// global scope by hand.
(function () {
  if (tr.isNode) {
    var mwuAbsPath = HTMLImportsLoader.hrefToAbsolutePath('/mannwhitneyu.js');
    var mwuModule = require(mwuAbsPath);
    for (var exportName in mwuModule) {
      global[exportName] = mwuModule[exportName];
    }
  }
})(this);

'use strict';

// TODO(charliea): Remove:
/* eslint-disable catapult-camelcase */

global.tr.exportTo('tr.b', function () {
  var identity = x => x;

  var Statistics = {};

  /* Returns the quotient, or zero if the denominator is zero.*/
  Statistics.divideIfPossibleOrZero = function (numerator, denominator) {
    if (denominator === 0) return 0;
    return numerator / denominator;
  };

  Statistics.sum = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var ret = 0;
    var i = 0;
    for (var elt of ary) ret += func.call(opt_this, elt, i++);
    return ret;
  };

  Statistics.mean = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var sum = 0;
    var i = 0;

    for (var elt of ary) sum += func.call(opt_this, elt, i++);

    if (i === 0) return undefined;

    return sum / i;
  };

  Statistics.geometricMean = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var i = 0;
    var logsum = 0;

    // The geometric mean is expressed as the arithmetic mean of logarithms
    // in order to prevent overflow.
    for (var elt of ary) {
      var x = func.call(opt_this, elt, i++);
      if (x <= 0) return 0;
      logsum += Math.log(Math.abs(x));
    }

    if (i === 0) return 1;

    return Math.exp(logsum / i);
  };

  // Returns undefined if the sum of the weights is zero.
  Statistics.weightedMean = function (ary, weightCallback, opt_valueCallback, opt_this) {
    var valueCallback = opt_valueCallback || identity;
    var numerator = 0;
    var denominator = 0;
    var i = -1;

    for (var elt of ary) {
      i++;
      var value = valueCallback.call(opt_this, elt, i);
      if (value === undefined) continue;
      var weight = weightCallback.call(opt_this, elt, i, value);
      numerator += weight * value;
      denominator += weight;
    }

    if (denominator === 0) return undefined;

    return numerator / denominator;
  };

  Statistics.variance = function (ary, opt_func, opt_this) {
    if (ary.length === 0) return undefined;
    if (ary.length === 1) return 0;
    var func = opt_func || identity;
    var mean = Statistics.mean(ary, func, opt_this);
    var sumOfSquaredDistances = Statistics.sum(ary, function (d, i) {
      var v = func.call(this, d, i) - mean;
      return v * v;
    }, opt_this);
    return sumOfSquaredDistances / (ary.length - 1);
  };

  Statistics.stddev = function (ary, opt_func, opt_this) {
    if (ary.length == 0) return undefined;
    return Math.sqrt(Statistics.variance(ary, opt_func, opt_this));
  };

  Statistics.max = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var ret = -Infinity;
    var i = 0;
    for (var elt of ary) ret = Math.max(ret, func.call(opt_this, elt, i++));
    return ret;
  };

  Statistics.min = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var ret = Infinity;
    var i = 0;
    for (var elt of ary) ret = Math.min(ret, func.call(opt_this, elt, i++));
    return ret;
  };

  Statistics.range = function (ary, opt_func, opt_this) {
    var func = opt_func || identity;
    var ret = new tr.b.Range();
    var i = 0;
    for (var elt of ary) ret.addValue(func.call(opt_this, elt, i++));
    return ret;
  };

  Statistics.percentile = function (ary, percent, opt_func, opt_this) {
    if (!(percent >= 0 && percent <= 1)) throw new Error('percent must be [0,1]');

    var func = opt_func || identity;
    var tmp = new Array(ary.length);
    var i = 0;
    for (var elt of ary) tmp[i] = func.call(opt_this, elt, i++);
    tmp.sort((a, b) => a - b);
    var idx = Math.floor((ary.length - 1) * percent);
    return tmp[idx];
  };

  /**
   * Sorts the samples, and map them linearly to the range [0,1].
   *
   * They're mapped such that for the N samples, the first sample is 0.5/N and
   * the last sample is (N-0.5)/N.
   *
   * Background: The discrepancy of the sample set i/(N-1); i=0, ..., N-1 is
   * 2/N, twice the discrepancy of the sample set (i+1/2)/N; i=0, ..., N-1. In
   * our case we don't want to distinguish between these two cases, as our
   * original domain is not bounded (it is for Monte Carlo integration, where
   * discrepancy was first used).
   **/
  Statistics.normalizeSamples = function (samples) {
    if (samples.length === 0) {
      return {
        normalized_samples: samples,
        scale: 1.0
      };
    }
    // Create a copy to make sure that we don't mutate original |samples| input.
    samples = samples.slice().sort(function (a, b) {
      return a - b;
    });
    var low = Math.min.apply(null, samples);
    var high = Math.max.apply(null, samples);
    var newLow = 0.5 / samples.length;
    var newHigh = (samples.length - 0.5) / samples.length;
    if (high - low === 0.0) {
      // Samples is an array of 0.5 in this case.
      samples = Array.apply(null, new Array(samples.length)).map(function () {
        return 0.5;
      });
      return {
        normalized_samples: samples,
        scale: 1.0
      };
    }
    var scale = (newHigh - newLow) / (high - low);
    for (var i = 0; i < samples.length; i++) {
      samples[i] = (samples[i] - low) * scale + newLow;
    }
    return {
      normalized_samples: samples,
      scale: scale
    };
  };

  /**
   * Computes the discrepancy of a set of 1D samples from the interval [0,1].
   *
   * The samples must be sorted. We define the discrepancy of an empty set
   * of samples to be zero.
   *
   * http://en.wikipedia.org/wiki/Low-discrepancy_sequence
   * http://mathworld.wolfram.com/Discrepancy.html
   */
  Statistics.discrepancy = function (samples, opt_locationCount) {
    if (samples.length === 0) return 0.0;

    var maxLocalDiscrepancy = 0;
    var invSampleCount = 1.0 / samples.length;
    var locations = [];
    // For each location, stores the number of samples less than that location.
    var countLess = [];
    // For each location, stores the number of samples less than or equal to
    // that location.
    var countLessEqual = [];

    if (opt_locationCount !== undefined) {
      // Generate list of equally spaced locations.
      var sampleIndex = 0;
      for (var i = 0; i < opt_locationCount; i++) {
        var location = i / (opt_locationCount - 1);
        locations.push(location);
        while (sampleIndex < samples.length && samples[sampleIndex] < location) {
          sampleIndex += 1;
        }
        countLess.push(sampleIndex);
        while (sampleIndex < samples.length && samples[sampleIndex] <= location) {
          sampleIndex += 1;
        }
        countLessEqual.push(sampleIndex);
      }
    } else {
      // Populate locations with sample positions. Append 0 and 1 if necessary.
      if (samples[0] > 0.0) {
        locations.push(0.0);
        countLess.push(0);
        countLessEqual.push(0);
      }
      for (var i = 0; i < samples.length; i++) {
        locations.push(samples[i]);
        countLess.push(i);
        countLessEqual.push(i + 1);
      }
      if (samples[-1] < 1.0) {
        locations.push(1.0);
        countLess.push(samples.length);
        countLessEqual.push(samples.length);
      }
    }

    // Compute discrepancy as max(overshoot, -undershoot), where
    // overshoot = max(countClosed(i, j)/N - length(i, j)) for all i < j,
    // undershoot = min(countOpen(i, j)/N - length(i, j)) for all i < j,
    // N = len(samples),
    // countClosed(i, j) is the number of points between i and j
    // including ends,
    // countOpen(i, j) is the number of points between i and j excluding ends,
    // length(i, j) is locations[i] - locations[j].

    // The following algorithm is modification of Kadane's algorithm,
    // see https://en.wikipedia.org/wiki/Maximum_subarray_problem.

    // The maximum of (countClosed(k, i-1)/N - length(k, i-1)) for any k < i-1.
    var maxDiff = 0;
    // The minimum of (countOpen(k, i-1)/N - length(k, i-1)) for any k < i-1.
    var minDiff = 0;
    for (var i = 1; i < locations.length; i++) {
      var length = locations[i] - locations[i - 1];
      var countClosed = countLessEqual[i] - countLess[i - 1];
      var countOpen = countLess[i] - countLessEqual[i - 1];
      // Number of points that are added if we extend a closed range that
      // ends at location (i-1).
      var countClosedIncrement = countLessEqual[i] - countLessEqual[i - 1];
      // Number of points that are added if we extend an open range that
      // ends at location (i-1).
      var countOpenIncrement = countLess[i] - countLess[i - 1];

      // Either extend the previous optimal range or start a new one.
      maxDiff = Math.max(countClosedIncrement * invSampleCount - length + maxDiff, countClosed * invSampleCount - length);
      minDiff = Math.min(countOpenIncrement * invSampleCount - length + minDiff, countOpen * invSampleCount - length);

      maxLocalDiscrepancy = Math.max(maxDiff, -minDiff, maxLocalDiscrepancy);
    }
    return maxLocalDiscrepancy;
  };

  /**
   * A discrepancy based metric for measuring timestamp jank.
   *
   * timestampsDiscrepancy quantifies the largest area of jank observed in a
   * series of timestamps.  Note that this is different from metrics based on
   * the max_time_interval. For example, the time stamp series A = [0,1,2,3,5,6]
   *  and B = [0,1,2,3,5,7] have the same max_time_interval = 2, but
   * Discrepancy(B) > Discrepancy(A).
   *
   * Two variants of discrepancy can be computed:
   *
   * Relative discrepancy is following the original definition of
   * discrepancy. It characterized the largest area of jank, relative to the
   * duration of the entire time stamp series.  We normalize the raw results,
   * because the best case discrepancy for a set of N samples is 1/N (for
   * equally spaced samples), and we want our metric to report 0.0 in that
   * case.
   *
   * Absolute discrepancy also characterizes the largest area of jank, but its
   * value wouldn't change (except for imprecisions due to a low
   * |interval_multiplier|) if additional 'good' intervals were added to an
   * exisiting list of time stamps.  Its range is [0,inf] and the unit is
   * milliseconds.
   *
   * The time stamp series C = [0,2,3,4] and D = [0,2,3,4,5] have the same
   * absolute discrepancy, but D has lower relative discrepancy than C.
   *
   * |timestamps| may be a list of lists S = [S_1, S_2, ..., S_N], where each
   * S_i is a time stamp series. In that case, the discrepancy D(S) is:
   * D(S) = max(D(S_1), D(S_2), ..., D(S_N))
   **/
  Statistics.timestampsDiscrepancy = function (timestamps, opt_absolute, opt_locationCount) {
    if (timestamps.length === 0) return 0.0;

    if (opt_absolute === undefined) opt_absolute = true;

    if (Array.isArray(timestamps[0])) {
      var rangeDiscrepancies = timestamps.map(function (r) {
        return Statistics.timestampsDiscrepancy(r);
      });
      return Math.max.apply(null, rangeDiscrepancies);
    }

    var s = Statistics.normalizeSamples(timestamps);
    var samples = s.normalized_samples;
    var sampleScale = s.scale;
    var discrepancy = Statistics.discrepancy(samples, opt_locationCount);
    var invSampleCount = 1.0 / samples.length;
    if (opt_absolute === true) {
      // Compute absolute discrepancy
      discrepancy /= sampleScale;
    } else {
      // Compute relative discrepancy
      discrepancy = tr.b.clamp((discrepancy - invSampleCount) / (1.0 - invSampleCount), 0.0, 1.0);
    }
    return discrepancy;
  };

  /**
   * A discrepancy based metric for measuring duration jank.
   *
   * DurationsDiscrepancy computes a jank metric which measures how irregular a
   * given sequence of intervals is. In order to minimize jank, each duration
   * should be equally long. This is similar to how timestamp jank works,
   * and we therefore reuse the timestamp discrepancy function above to compute
   * a similar duration discrepancy number.
   *
   * Because timestamp discrepancy is defined in terms of timestamps, we first
   * convert the list of durations to monotonically increasing timestamps.
   *
   * Args:
   *  durations: List of interval lengths in milliseconds.
   *  absolute: See TimestampsDiscrepancy.
   *  opt_locationCount: See TimestampsDiscrepancy.
   **/
  Statistics.durationsDiscrepancy = function (durations, opt_absolute, opt_locationCount) {
    if (durations.length === 0) return 0.0;

    var timestamps = durations.reduce(function (prev, curr, index, array) {
      prev.push(prev[prev.length - 1] + curr);
      return prev;
    }, [0]);
    return Statistics.timestampsDiscrepancy(timestamps, opt_absolute, opt_locationCount);
  };

  /**
   * Modifies |samples| in-place to reduce its length down to |count|.
   *
   * @param {!Array} samples
   * @param {number} count
   * @return {!Array}
   */
  Statistics.uniformlySampleArray = function (samples, count) {
    if (samples.length <= count) {
      return samples;
    }
    while (samples.length > count) {
      var i = parseInt(Math.random() * samples.length);
      samples.splice(i, 1);
    }
    return samples;
  };

  /**
   * A mechanism to uniformly sample elements from an arbitrary long stream.
   *
   * Call this method every time a new element is obtained from the stream,
   * passing always the same |samples| array and the |numSamples| you desire.
   * Also pass in the current |streamLength|, which is the same as the index of
   * |newElement| within that stream.
   *
   * The |samples| array will possibly be updated, replacing one of its element
   * with |newElements|. The length of |samples| will not be more than
   * |numSamples|.
   *
   * This method guarantees that after |streamLength| elements have been
   * processed each one has equal probability of being in |samples|. The order
   * of samples is not preserved though.
   *
   * Args:
   *  samples: Array of elements that have already been selected. Start with [].
   *  streamLength: The current length of the stream, up to |newElement|.
   *  newElement: The element that was just extracted from the stream.
   *  numSamples: The total number of samples desired.
   **/
  Statistics.uniformlySampleStream = function (samples, streamLength, newElement, numSamples) {
    if (streamLength <= numSamples) {
      if (samples.length >= streamLength) samples[streamLength - 1] = newElement;else samples.push(newElement);
      return;
    }

    var probToKeep = numSamples / streamLength;
    if (Math.random() > probToKeep) return; // New sample was rejected.

    // Keeping it, replace an alement randomly.
    var index = Math.floor(Math.random() * numSamples);
    samples[index] = newElement;
  };

  /**
   * A mechanism to merge two arrays of uniformly sampled elements in a way that
   * ensures elements in the final array are still sampled uniformly.
   *
   * This works similarly to sampleStreamUniform. The |samplesA| array will be
   * updated, some of its elements replaced by elements from |samplesB| in a
   * way that ensure that elements will be sampled uniformly.
   *
   * Args:
   *  samplesA: Array of uniformly sampled elements, will be updated.
   *  streamLengthA: The length of the stream from which |samplesA| was sampled.
   *  samplesB: Other array of uniformly sampled elements, will NOT be updated.
   *  streamLengthB: The length of the stream from which |samplesB| was sampled.
   *  numSamples: The total number of samples desired, both in |samplesA| and
   *      |samplesB|.
   **/
  Statistics.mergeSampledStreams = function (samplesA, streamLengthA, samplesB, streamLengthB, numSamples) {
    if (streamLengthB < numSamples) {
      // samplesB has not reached max capacity so every sample of stream B were
      // chosen with certainty. Add them one by one into samplesA.
      var nbElements = Math.min(streamLengthB, samplesB.length);
      for (var i = 0; i < nbElements; ++i) {
        Statistics.uniformlySampleStream(samplesA, streamLengthA + i + 1, samplesB[i], numSamples);
      }
      return;
    }
    if (streamLengthA < numSamples) {
      // samplesA has not reached max capacity so every sample of stream A were
      // chosen with certainty. Add them one by one into samplesB.
      var nbElements = Math.min(streamLengthA, samplesA.length);
      var tempSamples = samplesB.slice();
      for (var i = 0; i < nbElements; ++i) {
        Statistics.uniformlySampleStream(tempSamples, streamLengthB + i + 1, samplesA[i], numSamples);
      }
      // Copy that back into the first vector.
      for (var i = 0; i < tempSamples.length; ++i) {
        samplesA[i] = tempSamples[i];
      }
      return;
    }

    // Both sample arrays are at max capacity, use the power of maths!
    // Elements in samplesA have been selected with probability
    // numSamples / streamLengthA. Same for samplesB. For each index of the
    // array we keep samplesA[i] with probability
    //   P = streamLengthA / (streamLengthA + streamLengthB)
    // and replace it with samplesB[i] with probability 1-P.
    // The total probability of keeping it is therefore
    //   numSamples / streamLengthA *
    //                      streamLengthA / (streamLengthA + streamLengthB)
    //   = numSamples / (streamLengthA + streamLengthB)
    // A similar computation shows we have the same probability of keeping any
    // element in samplesB. Magic!
    var nbElements = Math.min(numSamples, samplesB.length);
    var probOfSwapping = streamLengthB / (streamLengthA + streamLengthB);
    for (var i = 0; i < nbElements; ++i) {
      if (Math.random() < probOfSwapping) {
        samplesA[i] = samplesB[i];
      }
    }
  };

  /* Continuous distributions are defined by probability density functions.
   *
   * Random variables are referred to by capital letters: X, Y, Z.
   * Particular values from these distributions are referred to by lowercase
   * letters like |x|.
   * The probability that |X| ever exactly equals |x| is P(X==x) = 0.
   *
   * For a discrete probability distribution, see tr.v.Histogram.
   */
  function Distribution() {}

  Distribution.prototype = {
    /* The probability density of the random variable at value |x| is the
     * relative likelihood for this random variable to take on the given value
     * |x|.
     *
     * @param {number} x A value from the random distribution.
     * @return {number} probability density at x.
     */
    computeDensity: function (x) {
      throw Error('Not implemented');
    },

    /* A percentile is the probability that a sample from the distribution is
     * less than the given value |x|. This function is monotonically increasing.
     *
     * @param {number} x A value from the random distribution.
     * @return {number} P(X<x).
     */
    computePercentile: function (x) {
      throw Error('Not implemented');
    },

    /* A complementary percentile is the probability that a sample from the
     * distribution is greater than the given value |x|. This function is
     * monotonically decreasing.
     *
     * @param {number} x A value from the random distribution.
     * @return {number} P(X>x).
     */
    computeComplementaryPercentile: function (x) {
      return 1 - this.computePercentile(x);
    },

    /* Compute the mean of the probability distribution.
     *
     * @return {number} mean.
     */
    get mean() {
      throw Error('Not implemented');
    },

    /* The mode of a distribution is the most likely value.
     * The maximum of the computeDensity() function is at this mode.
     * @return {number} mode.
     */
    get mode() {
      throw Error('Not implemented');
    },

    /* The median is the center value of the distribution.
     * computePercentile(median) = computeComplementaryPercentile(median) = 0.5
     *
     * @return {number} median.
     */
    get median() {
      throw Error('Not implemented');
    },

    /* The standard deviation is a measure of how dispersed or spread out the
     * distribution is (this statistic has the same units as the values).
     *
     * @return {number} standard deviation.
     */
    get standardDeviation() {
      throw Error('Not implemented');
    },

    /* An alternative measure of how spread out the distribution is,
     * the variance is the square of the standard deviation.
     * @return {number} variance.
     */
    get variance() {
      throw Error('Not implemented');
    }
  };

  Statistics.UniformDistribution = function (opt_range) {
    if (!opt_range) opt_range = tr.b.Range.fromExplicitRange(0, 1);
    this.range = opt_range;
  };

  Statistics.UniformDistribution.prototype = {
    __proto__: Distribution.prototype,

    computeDensity: function (x) {
      return 1 / this.range.range;
    },

    computePercentile: function (x) {
      return tr.b.normalize(x, this.range.min, this.range.max);
    },

    get mean() {
      return this.range.center;
    },

    get mode() {
      return undefined;
    },

    get median() {
      return this.mean;
    },

    get standardDeviation() {
      return Math.sqrt(this.variance);
    },

    get variance() {
      return Math.pow(this.range.range, 2) / 12;
    }
  };

  /* The Normal or Gaussian distribution, or bell curve, is common in complex
   * processes such as are found in many of the natural sciences.  If Z is the
   * standard normal distribution with mean = 0 and variance = 1, then the
   * general normal distribution is Y = mean + Z*sqrt(variance).
   * https://www.desmos.com/calculator/tqtbjm4s3z
   */
  Statistics.NormalDistribution = function (opt_mean, opt_variance) {
    this.mean_ = opt_mean || 0;
    this.variance_ = opt_variance || 1;
    this.standardDeviation_ = Math.sqrt(this.variance_);
  };

  Statistics.NormalDistribution.prototype = {
    __proto__: Distribution.prototype,

    computeDensity: function (x) {
      var scale = 1.0 / (this.standardDeviation * Math.sqrt(2.0 * Math.PI));
      var exponent = -Math.pow(x - this.mean, 2) / (2.0 * this.variance);
      return scale * Math.exp(exponent);
    },

    computePercentile: function (x) {
      var standardizedX = (x - this.mean) / Math.sqrt(2.0 * this.variance);
      return (1.0 + tr.b.erf(standardizedX)) / 2.0;
    },

    get mean() {
      return this.mean_;
    },

    get median() {
      return this.mean;
    },

    get mode() {
      return this.mean;
    },

    get standardDeviation() {
      return this.standardDeviation_;
    },

    get variance() {
      return this.variance_;
    }
  };

  /* The log-normal distribution is a continuous probability distribution of a
   * random variable whose logarithm is normally distributed.
   * If Y is the general normal distribution, then X = exp(Y) is the general
   * log-normal distribution.
   * X will have different parameters from Y,
   * so the mean of Y is called the "location" of X,
   * and the standard deviation of Y is called the "shape" of X.
   * The standard lognormal distribution exp(Z) has location = 0 and shape = 1.
   * https://www.desmos.com/calculator/tqtbjm4s3z
   */
  Statistics.LogNormalDistribution = function (opt_location, opt_shape) {
    this.normalDistribution_ = new Statistics.NormalDistribution(opt_location, Math.pow(opt_shape || 1, 2));
  };

  Statistics.LogNormalDistribution.prototype = {
    __proto__: Statistics.NormalDistribution.prototype,

    computeDensity: function (x) {
      return this.normalDistribution_.computeDensity(Math.log(x)) / x;
    },

    computePercentile: function (x) {
      return this.normalDistribution_.computePercentile(Math.log(x));
    },

    get mean() {
      return Math.exp(this.normalDistribution_.mean + this.normalDistribution_.variance / 2);
    },

    get variance() {
      var nm = this.normalDistribution_.mean;
      var nv = this.normalDistribution_.variance;
      return Math.exp(2 * (nm + nv)) - Math.exp(2 * nm + nv);
    },

    get standardDeviation() {
      return Math.sqrt(this.variance);
    },

    get median() {
      return Math.exp(this.normalDistribution_.mean);
    },

    get mode() {
      return Math.exp(this.normalDistribution_.mean - this.normalDistribution_.variance);
    }
  };

  /**
   * Instead of describing a LogNormalDistribution in terms of its "location"
   * and "shape", it can also be described in terms of its median
   * and the point at which its complementary cumulative distribution
   * function bends between the linear-ish region in the middle and the
   * exponential-ish region. When the distribution is used to compute
   * percentiles for log-normal random processes such as latency, as the latency
   * improves, it hits a point of diminishing returns, when it becomes
   * relatively difficult to improve the score further. This point of
   * diminishing returns is the first x-intercept of the third derivative of the
   * CDF, which is the second derivative of the PDF.
   *
   * https://www.desmos.com/calculator/cg5rnftabn
   *
   * @param {number} median The median of the distribution.
   * @param {number} diminishingReturns The point of diminishing returns.
   * @return {LogNormalDistribution}
   */
  Statistics.LogNormalDistribution.fromMedianAndDiminishingReturns = function (median, diminishingReturns) {
    diminishingReturns = Math.log(diminishingReturns / median);
    var shape = Math.sqrt(1 - 3 * diminishingReturns - Math.sqrt(Math.pow(diminishingReturns - 3, 2) - 8)) / 2;
    var location = Math.log(median);
    return new Statistics.LogNormalDistribution(location, shape);
  };

  // p-values less than this indicate statistical significance.
  Statistics.DEFAULT_ALPHA = 0.05;

  /** @enum */
  Statistics.Significance = {
    INSIGNIFICANT: -1,
    DONT_CARE: 0,
    SIGNIFICANT: 1
  };

  /**
   * @typedef {Object} HypothesisTestResult
   * @property {number} p
   * @property {number} U
   * @property {!tr.b.Statistics.Significance} significance
   */

  /**
   * @param {!Array.<number>} a
   * @param {!Array.<number>} b
   * @param {number=} opt_alpha
   * @return {!HypothesisTestResult}
   */
  Statistics.mwu = function (a, b, opt_alpha) {
    var result = mannwhitneyu.test(a, b);
    var alpha = opt_alpha || Statistics.DEFAULT_ALPHA;
    result.significance = result.p < alpha ? Statistics.Significance.SIGNIFICANT : Statistics.Significance.INSIGNIFICANT;
    return result;
  };

  return {
    Statistics: Statistics
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./math.js":42,"./range.js":47}],54:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./raf.js");
require("./timing.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var Timing = tr.b.Timing;
  /**
   * A task is a combination of a run callback, a set of subtasks, and an after
   * task.
   *
   * When executed, a task does the following things:
   * 1. Runs its callback
   * 2. Runs its subtasks
   * 3. Runs its after callback.
   *
   * The list of subtasks and after task can be mutated inside step #1 but as
   * soon as the task's callback returns, the subtask list and after task is
   * fixed and cannot be changed again.
   *
   * Use task.after().after().after() to describe the toplevel passes that make
   * up your computation. Then, use subTasks to add detail to each subtask as it
   * runs. For example:
   *    var pieces = [];
   *    taskA = new Task(function() { pieces = getPieces(); });
   *    taskA.after(function(taskA) {
   *      pieces.forEach(function(piece) {
   *        taskA.subTask(function(taskB) { piece.process(); }, this);
   *      });
   *    });
   *
   * @constructor
   */
  function Task(runCb, thisArg) {
    if (runCb !== undefined && thisArg === undefined) throw new Error('Almost certainly, you meant to pass a thisArg.');
    this.runCb_ = runCb;
    this.thisArg_ = thisArg;
    this.afterTask_ = undefined;
    this.subTasks_ = [];
  }

  Task.prototype = {
    get name() {
      return this.runCb_.name;
    },

    /*
     * See constructor documentation on semantics of subtasks.
     */
    subTask: function (cb, thisArg) {
      if (cb instanceof Task) this.subTasks_.push(cb);else this.subTasks_.push(new Task(cb, thisArg));
      return this.subTasks_[this.subTasks_.length - 1];
    },

    /**
     * Runs the current task and returns the task that should be executed next.
     */
    run: function () {
      if (this.runCb_ !== undefined) this.runCb_.call(this.thisArg_, this);
      var subTasks = this.subTasks_;
      this.subTasks_ = undefined; // Prevent more subTasks from being posted.

      if (!subTasks.length) return this.afterTask_;

      // If there are subtasks, then we want to execute all the subtasks and
      // then this task's afterTask. To make this happen, we update the
      // afterTask of all the subtasks so the point upward to each other, e.g.
      // subTask[0].afterTask to subTask[1] and so on. Then, the last subTask's
      // afterTask points at this task's afterTask.
      for (var i = 1; i < subTasks.length; i++) subTasks[i - 1].afterTask_ = subTasks[i];
      subTasks[subTasks.length - 1].afterTask_ = this.afterTask_;
      return subTasks[0];
    },

    /*
     * See constructor documentation on semantics of after tasks.
     */
    after: function (cb, thisArg) {
      if (this.afterTask_) throw new Error('Has an after task already');
      if (cb instanceof Task) this.afterTask_ = cb;else this.afterTask_ = new Task(cb, thisArg);
      return this.afterTask_;
    },

    /*
     * See constructor documentation on semantics of after tasks.
     * Note: timedAfter doesn't work when a task throws an exception.
     * This is because task system doesn't support catching currently.
     * At the time of writing, this is considered to be an acceptable tradeoff.
     */
    timedAfter: function (groupName, cb, thisArg, opt_args) {
      if (cb.name === '') throw new Error('Anonymous Task is not allowed');
      return this.namedTimedAfter(groupName, cb.name, cb, thisArg, opt_args);
    },

    /*
     * See constructor documentation on semantics of after tasks.
     * Note: namedTimedAfter doesn't work when a task throws an exception.
     * This is because task system doesn't support catching currently.
     * At the time of writing, this is considered to be an acceptable tradeoff.
     */
    namedTimedAfter: function (groupName, name, cb, thisArg, opt_args) {
      if (this.afterTask_) throw new Error('Has an after task already');
      var realTask;
      if (cb instanceof Task) realTask = cb;else realTask = new Task(cb, thisArg);
      this.afterTask_ = new Task(function (task) {
        var markedTask = Timing.mark(groupName, name, opt_args);
        task.subTask(realTask, thisArg);
        task.subTask(function () {
          markedTask.end();
        }, thisArg);
      }, thisArg);
      return this.afterTask_;
    },

    /*
     * Adds a task after the chain of tasks.
     */
    enqueue: function (cb, thisArg) {
      var lastTask = this;
      while (lastTask.afterTask_) lastTask = lastTask.afterTask_;
      return lastTask.after(cb, thisArg);
    }
  };

  Task.RunSynchronously = function (task) {
    var curTask = task;
    while (curTask) curTask = curTask.run();
  };

  /**
   * Runs a task using raf.requestIdleCallback, returning
   * a promise for its completion.
   */
  Task.RunWhenIdle = function (task) {
    return new Promise(function (resolve, reject) {
      var curTask = task;
      function runAnother() {
        try {
          curTask = curTask.run();
        } catch (e) {
          reject(e);
          console.error(e.stack);
          return;
        }

        if (curTask) {
          tr.b.requestIdleCallback(runAnother);
          return;
        }

        resolve();
      }
      tr.b.requestIdleCallback(runAnother);
    });
  };

  return {
    Task: Task
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./raf.js":46,"./timing.js":56}],55:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./unit_scale.js");

'use strict';

/**
 * @fileoverview Time currentDisplayUnit
 */
global.tr.exportTo('tr.b', function () {
  var msDisplayMode = {
    scale: 1e-3,
    suffix: 'ms',
    // Compares a < b with adjustments to precision errors.
    roundedLess: function (a, b) {
      return Math.round(a * 1000) < Math.round(b * 1000);
    },
    formatSpec: {
      unit: 's',
      unitPrefix: tr.b.UnitScale.Metric.MILLI,
      minimumFractionDigits: 3
    }
  };

  var nsDisplayMode = {
    scale: 1e-9,
    suffix: 'ns',
    // Compares a < b with adjustments to precision errors.
    roundedLess: function (a, b) {
      return Math.round(a * 1000000) < Math.round(b * 1000000);
    },
    formatSpec: {
      unit: 's',
      unitPrefix: tr.b.UnitScale.Metric.NANO,
      maximumFractionDigits: 0
    }
  };

  var TimeDisplayModes = {
    ns: nsDisplayMode,
    ms: msDisplayMode
  };

  return {
    TimeDisplayModes: TimeDisplayModes
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./unit_scale.js":58}],56:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");
require("./base64.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var Base64 = tr.b.Base64;

  function computeUserTimingMarkName(groupName, functionName, opt_args) {
    if (groupName === undefined) throw new Error('getMeasureString should have group name');
    if (functionName === undefined) throw new Error('getMeasureString should have function name');
    var userTimingMarkName = groupName + ':' + functionName;
    if (opt_args !== undefined) {
      userTimingMarkName += '/';
      userTimingMarkName += Base64.btoa(JSON.stringify(opt_args));
    }
    return userTimingMarkName;
  }

  function Timing() {}

  Timing.nextMarkNumber = 0;

  Timing.mark = function (groupName, functionName, opt_args) {
    if (tr.isHeadless) {
      return {
        end: function () {}
      };
    }
    var userTimingMarkName = computeUserTimingMarkName(groupName, functionName, opt_args);
    var markBeginName = 'tvcm.mark' + Timing.nextMarkNumber++;
    var markEndName = 'tvcm.mark' + Timing.nextMarkNumber++;
    window.performance.mark(markBeginName);
    return {
      end: function () {
        window.performance.mark(markEndName);
        window.performance.measure(userTimingMarkName, markBeginName, markEndName);
      }
    };
  };

  Timing.wrap = function (groupName, callback, opt_args) {
    if (groupName === undefined) throw new Error('Timing.wrap should have group name');
    if (callback.name === '') throw new Error('Anonymous function is not allowed');
    return Timing.wrapNamedFunction(groupName, callback.name, callback, opt_args);
  };

  Timing.wrapNamedFunction = function (groupName, functionName, callback, opt_args) {
    function timedNamedFunction() {
      var markedTime = Timing.mark(groupName, functionName, opt_args);
      try {
        callback.apply(this, arguments);
      } finally {
        markedTime.end();
      }
    }
    return timedNamedFunction;
  };

  function TimedNamedPromise(groupName, name, executor, opt_args) {
    var markedTime = Timing.mark(groupName, name, opt_args);
    var promise = new Promise(executor);
    promise.then(function (result) {
      markedTime.end();
      return result;
    }, function (e) {
      markedTime.end();
      throw e;
    });
    return promise;
  }

  return {
    _computeUserTimingMarkName: computeUserTimingMarkName, // export for testing
    TimedNamedPromise: TimedNamedPromise,
    Timing: Timing
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28,"./base64.js":29}],57:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./event.js");
require("./event_target.js");
require("./iteration_helpers.js");
require("./time_display_modes.js");
require("./unit_scale.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  var TimeDisplayModes = tr.b.TimeDisplayModes;

  var PLUS_MINUS_SIGN = String.fromCharCode(177);

  function max(a, b) {
    if (a === undefined) return b;
    if (b === undefined) return a;
    return a.scale > b.scale ? a : b;
  }

  /** @enum */
  var ImprovementDirection = {
    DONT_CARE: 0,
    BIGGER_IS_BETTER: 1,
    SMALLER_IS_BETTER: 2
  };

  /** @constructor */
  function Unit(unitName, jsonName, basePrefix, isDelta, improvementDirection, formatSpec) {
    this.unitName = unitName;
    this.jsonName = jsonName;
    this.basePrefix = basePrefix;
    this.isDelta = isDelta;
    this.improvementDirection = improvementDirection;
    this.formatSpec_ = formatSpec;

    // Example: powerInWattsDelta_biggerIsBetter -> powerInWatts.
    this.baseUnit = undefined;

    // Example: energyInJoules_smallerIsBetter ->
    // energyInJoulesDelta_smallerIsBetter.
    this.correspondingDeltaUnit = undefined;
  }

  Unit.prototype = {
    asJSON: function () {
      return this.jsonName;
    },

    get unitString() {
      // TODO(benjhayden): Refactor with format() and test.
      var formatSpec = this.formatSpec_;
      if (typeof formatSpec === 'function') formatSpec = formatSpec();
      if (!formatSpec.unit) {
        return '';
      }

      var unitString = '';
      var unitPrefix = formatSpec.unitPrefix;
      if (unitPrefix !== undefined) {
        var selectedPrefix;
        if (unitPrefix instanceof Array) {
          selectedPrefix = unitPrefix[0];
        } else {
          selectedPrefix = unitPrefix;
        }
        unitString += selectedPrefix.symbol || '';
      }
      unitString += formatSpec.unit;

      return unitString;
    },

    format: function (value, opt_context) {
      var context = opt_context || {};
      var formatSpec = this.formatSpec_;
      if (typeof formatSpec === 'function') formatSpec = formatSpec();

      function resolveProperty(propertyName) {
        if (propertyName in context) return context[propertyName];else if (propertyName in formatSpec) return formatSpec[propertyName];else return undefined;
      }

      var signString = '';
      if (value < 0) {
        signString = '-';
        value = -value; // Treat positive and negative values symmetrically.
      } else if (this.isDelta) {
        signString = value === 0 ? PLUS_MINUS_SIGN : '+';
      }

      var unitString = '';
      if (formatSpec.unit) {
        if (formatSpec.unitHasPrecedingSpace !== false) unitString += ' ';
        var unitPrefix = resolveProperty('unitPrefix');
        if (unitPrefix !== undefined) {
          var selectedPrefix;
          if (unitPrefix instanceof Array) {
            var i = 0;
            while (i < unitPrefix.length - 1 && value / unitPrefix[i + 1].value >= 1) {
              i++;
            }
            selectedPrefix = unitPrefix[i];
          } else {
            selectedPrefix = unitPrefix;
          }
          unitString += selectedPrefix.symbol || '';
          value = tr.b.convertUnit(value, this.basePrefix, selectedPrefix);
        } else {
          value = tr.b.convertUnit(value, this.basePrefix, tr.b.UnitScale.Metric.NONE);
        }
        unitString += formatSpec.unit;
      }

      var minimumFractionDigits = resolveProperty('minimumFractionDigits');
      var maximumFractionDigits = resolveProperty('maximumFractionDigits');

      // If the context overrides only one of the two |*FractionDigits|
      // properties and the other one is provided by the unit, we might need to
      // shift the other property so that
      // |minimumFractionDigits| <= |maximumFractionDigits|.
      if (minimumFractionDigits > maximumFractionDigits) {
        if ('minimumFractionDigits' in context && !('maximumFractionDigits' in context)) {
          // Only minimumFractionDigits was overriden by context.
          maximumFractionDigits = minimumFractionDigits;
        } else if ('maximumFractionDigits' in context && !('minimumFractionDigits' in context)) {
          // Only maximumFractionDigits was overriden by context.
          minimumFractionDigits = maximumFractionDigits;
        }
      }

      var numberString = value.toLocaleString(undefined, {
        minimumFractionDigits: minimumFractionDigits,
        maximumFractionDigits: maximumFractionDigits
      });

      return signString + numberString + unitString;
    }
  };

  Unit.reset = function () {
    Unit.currentTimeDisplayMode = TimeDisplayModes.ms;
  };

  Unit.timestampFromUs = function (us) {
    return tr.b.convertUnit(us, tr.b.UnitScale.Metric.MICRO, tr.b.UnitScale.Metric.MILLI);
  };

  Object.defineProperty(Unit, 'currentTimeDisplayMode', {
    get: function () {
      return Unit.currentTimeDisplayMode_;
    },
    // Use tr-v-ui-preferred-display-unit element instead of directly setting.
    set: function (value) {
      if (Unit.currentTimeDisplayMode_ === value) return;

      Unit.currentTimeDisplayMode_ = value;
      Unit.dispatchEvent(new tr.b.Event('display-mode-changed'));
    }
  });

  Unit.didPreferredTimeDisplayUnitChange = function () {
    var largest = undefined;
    var els = tr.b.findDeepElementsMatching(document.body, 'tr-v-ui-preferred-display-unit');
    els.forEach(function (el) {
      largest = max(largest, el.preferredTimeDisplayMode);
    });

    Unit.currentDisplayUnit = largest === undefined ? TimeDisplayModes.ms : largest;
  };

  Unit.byName = {};
  Unit.byJSONName = {};

  Unit.fromJSON = function (object) {
    var u = Unit.byJSONName[object];
    if (u) {
      return u;
    }
    throw new Error('Unrecognized unit');
  };

  /**
   * Define all combinations of a unit with isDelta and improvementDirection
   * flags. For example, the following code:
   *
   *   Unit.define({
   *     baseUnitName: 'powerInWatts'
   *     baseJsonName: 'W'
   *     formatSpec: {
   *       // Specification of how the unit should be formatted (unit symbol,
   *       // unit prefix, fraction digits, etc), or a function returning such
   *       // a specification.
   *     }
   *   });
   *
   * generates the following six units (JSON names shown in parentheses):
   *
   *   Unit.byName.powerInWatts (W)
   *   Unit.byName.powerInWatts_smallerIsBetter (W_smallerIsBetter)
   *   Unit.byName.powerInWatts_biggerIsBetter (W_biggerIsBetter)
   *   Unit.byName.powerInWattsDelta (WDelta)
   *   Unit.byName.powerInWattsDelta_smallerIsBetter (WDelta_smallerIsBetter)
   *   Unit.byName.powerInWattsDelta_biggerIsBetter (WDelta_biggerIsBetter)
   *
   * with the appropriate flags and formatting code (including +/- prefixes
   * for deltas).
   */
  Unit.define = function (params) {
    var definedUnits = [];

    tr.b.iterItems(ImprovementDirection, function (_, improvementDirection) {
      var regularUnit = Unit.defineUnitVariant_(params, false, improvementDirection);
      var deltaUnit = Unit.defineUnitVariant_(params, true, improvementDirection);

      regularUnit.correspondingDeltaUnit = deltaUnit;
      deltaUnit.correspondingDeltaUnit = deltaUnit;
      definedUnits.push(regularUnit, deltaUnit);
    });

    var baseUnit = Unit.byName[params.baseUnitName];
    definedUnits.forEach(u => u.baseUnit = baseUnit);
  };

  Unit.nameSuffixForImprovementDirection = function (improvementDirection) {
    switch (improvementDirection) {
      case ImprovementDirection.DONT_CARE:
        return '';
      case ImprovementDirection.BIGGER_IS_BETTER:
        return '_biggerIsBetter';
      case ImprovementDirection.SMALLER_IS_BETTER:
        return '_smallerIsBetter';
      default:
        throw new Error('Unknown improvement direction: ' + improvementDirection);
    }
  };

  Unit.defineUnitVariant_ = function (params, isDelta, improvementDirection) {
    var nameSuffix = isDelta ? 'Delta' : '';
    nameSuffix += Unit.nameSuffixForImprovementDirection(improvementDirection);

    var unitName = params.baseUnitName + nameSuffix;
    var jsonName = params.baseJsonName + nameSuffix;
    if (Unit.byName[unitName] !== undefined) throw new Error('Unit \'' + unitName + '\' already exists');
    if (Unit.byJSONName[jsonName] !== undefined) throw new Error('JSON unit \'' + jsonName + '\' alread exists');

    var basePrefix = params.basePrefix ? params.basePrefix : tr.b.UnitScale.Metric.NONE;
    var unit = new Unit(unitName, jsonName, basePrefix, isDelta, improvementDirection, params.formatSpec);
    Unit.byName[unitName] = unit;
    Unit.byJSONName[jsonName] = unit;

    return unit;
  };

  tr.b.EventTarget.decorate(Unit);
  Unit.reset();

  // Known display units follow.
  //////////////////////////////////////////////////////////////////////////////

  Unit.define({
    baseUnitName: 'timeDurationInMs',
    baseJsonName: 'ms',
    basePrefix: tr.b.UnitScale.Metric.MILLI,
    formatSpec: function () {
      return Unit.currentTimeDisplayMode_.formatSpec;
    }
  });

  Unit.define({
    baseUnitName: 'timeStampInMs',
    baseJsonName: 'tsMs',
    basePrefix: tr.b.UnitScale.Metric.MILLI,
    formatSpec: function () {
      return Unit.currentTimeDisplayMode_.formatSpec;
    }
  });

  Unit.define({
    baseUnitName: 'normalizedPercentage',
    baseJsonName: 'n%',
    formatSpec: {
      unit: '%',
      unitPrefix: { value: 0.01 },
      unitHasPrecedingSpace: false,
      minimumFractionDigits: 3,
      maximumFractionDigits: 3
    }
  });

  Unit.define({
    baseUnitName: 'sizeInBytes',
    baseJsonName: 'sizeInBytes',
    formatSpec: {
      unit: 'B',
      unitPrefix: tr.b.UnitScale.Binary.AUTO,
      minimumFractionDigits: 1,
      maximumFractionDigits: 1
    }
  });

  Unit.define({
    baseUnitName: 'energyInJoules',
    baseJsonName: 'J',
    formatSpec: {
      unit: 'J',
      minimumFractionDigits: 3
    }
  });

  Unit.define({
    baseUnitName: 'powerInWatts',
    baseJsonName: 'W',
    formatSpec: {
      unit: 'W',
      minimumFractionDigits: 3
    }
  });

  Unit.define({
    baseUnitName: 'unitlessNumber',
    baseJsonName: 'unitless',
    formatSpec: {
      minimumFractionDigits: 3,
      maximumFractionDigits: 3
    }
  });

  Unit.define({
    baseUnitName: 'count',
    baseJsonName: 'count',
    formatSpec: {
      minimumFractionDigits: 0,
      maximumFractionDigits: 0
    }
  });

  Unit.define({
    baseUnitName: 'sigma',
    baseJsonName: 'sigma',
    formatSpec: {
      unit: String.fromCharCode(963),
      minimumFractionDigits: 1,
      maximumFractionDigits: 1
    }
  });

  return {
    ImprovementDirection: ImprovementDirection,
    Unit: Unit
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./event.js":33,"./event_target.js":34,"./iteration_helpers.js":41,"./time_display_modes.js":55,"./unit_scale.js":58}],58:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./iteration_helpers.js");

'use strict';

var GREEK_SMALL_LETTER_MU = String.fromCharCode(956);

global.tr.exportTo('tr.b', function () {

  var UnitScale = {};

  function defineUnitScale(name, prefixes) {
    if (UnitScale[name] !== undefined) throw new Error('Unit scale \'' + name + '\' already exists');
    if (prefixes.AUTO !== undefined) {
      throw new Error('\'AUTO\' unit prefix will be added automatically ' + 'for unit scale \'' + name + '\'');
    }

    // If the 'AUTO' unit prefix is used, the prefix that results in
    // the absolute formatted value being as close to the [1, 1024) interval as
    // possible is used. Example: 1023 and 1024 bytes are displayed as
    // "1,023.0 B" and "1.0 KiB", respectively.
    prefixes.AUTO = tr.b.dictionaryValues(prefixes);
    prefixes.AUTO.sort((a, b) => a.value - b.value);

    UnitScale[name] = prefixes;
  }

  /**
   * Converts |value| from |fromPrefix| (e.g. kilo) to |toPrefix| (e.g. mega).
   *
   * Returns undefined if |value| is undefined.
   * |fromPrefix| and |toPrefix| need not come from the same UnitScale.
   *
   * @param {(undefined|number)} value
   * @param {!object} fromPrefix
   * @param {!object} toPrefix
   * @return {(undefined|number)}
   */
  function convertUnit(value, fromPrefix, toPrefix) {
    if (value === undefined) return undefined;
    return value * (fromPrefix.value / toPrefix.value);
  }

  // See https://en.wikipedia.org/wiki/Binary_prefix.
  defineUnitScale('Binary', {
    NONE: { value: Math.pow(1024, 0), symbol: '' },
    KIBI: { value: Math.pow(1024, 1), symbol: 'Ki' },
    MEBI: { value: Math.pow(1024, 2), symbol: 'Mi' },
    GIBI: { value: Math.pow(1024, 3), symbol: 'Gi' },
    TEBI: { value: Math.pow(1024, 4), symbol: 'Ti' }
  });

  // See https://en.wikipedia.org/wiki/Metric_prefix.
  defineUnitScale('Metric', {
    NANO: { value: 1e-9, symbol: 'n' },
    MICRO: { value: 1e-6, symbol: GREEK_SMALL_LETTER_MU },
    MILLI: { value: 1e-3, symbol: 'm' },
    NONE: { value: 1, symbol: '' },
    KILO: { value: 1e3, symbol: 'k' },
    MEGA: { value: 1e6, symbol: 'M' },
    GIGA: { value: 1e9, symbol: 'G' }
  });

  return {
    UnitScale: UnitScale,
    convertUnit: convertUnit
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./iteration_helpers.js":41}],59:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./base.js");

'use strict';

global.tr.exportTo('tr.b', function () {
  /**
   * Adds a {@code getInstance} static method that always return the same
   * instance object.
   * @param {!Function} ctor The constructor for the class to add the static
   *     method to.
   */
  function addSingletonGetter(ctor) {
    ctor.getInstance = function () {
      return ctor.instance_ || (ctor.instance_ = new ctor());
    };
  }

  function deepCopy(value) {
    if (!(value instanceof Object)) {
      if (value === undefined || value === null) return value;
      if (typeof value == 'string') return value.substring();
      if (typeof value == 'boolean') return value;
      if (typeof value == 'number') return value;
      throw new Error('Unrecognized: ' + typeof value);
    }

    var object = value;
    if (object instanceof Array) {
      var res = new Array(object.length);
      for (var i = 0; i < object.length; i++) res[i] = deepCopy(object[i]);
      return res;
    }

    if (object.__proto__ != Object.prototype) throw new Error('Can only clone simple types');
    var res = {};
    for (var key in object) {
      res[key] = deepCopy(object[key]);
    }
    return res;
  }

  function normalizeException(e) {
    if (e === undefined || e === null) {
      return {
        typeName: 'UndefinedError',
        message: 'Unknown: null or undefined exception',
        stack: 'Unknown'
      };
    }

    if (typeof e == 'string') {
      return {
        typeName: 'StringError',
        message: e,
        stack: [e]
      };
    }

    var typeName;
    if (e.name) {
      typeName = e.name;
    } else if (e.constructor) {
      if (e.constructor.name) {
        typeName = e.constructor.name;
      } else {
        typeName = 'AnonymousError';
      }
    } else {
      typeName = 'ErrorWithNoConstructor';
    }

    var msg = e.message ? e.message : 'Unknown';
    return {
      typeName: typeName,
      message: msg,
      stack: e.stack ? e.stack : [msg]
    };
  }

  function stackTraceAsString() {
    return new Error().stack + '';
  }
  function stackTrace() {
    var stack = stackTraceAsString();
    stack = stack.split('\n');
    return stack.slice(2);
  }

  function getUsingPath(path, fromDict) {
    var parts = path.split('.');
    var cur = fromDict;

    for (var part; parts.length && (part = parts.shift());) {
      if (!parts.length) {
        return cur[part];
      } else if (part in cur) {
        cur = cur[part];
      } else {
        return undefined;
      }
    }
    return undefined;
  }

  /**
   * Format date as a string "YYYY-MM-DD HH:mm:ss". The timezone is implicitly
   * UTC. This format is based on the ISO format, but without milliseconds and
   * the 'T' is replaced with a space for legibility.
   *
   * @param {!Date} date
   * @return {string}
   */
  function formatDate(date) {
    return date.toISOString().replace('T', ' ').slice(0, 19);
  }

  return {
    addSingletonGetter: addSingletonGetter,

    deepCopy: deepCopy,

    normalizeException: normalizeException,
    stackTrace: stackTrace,
    stackTraceAsString: stackTraceAsString,
    formatDate: formatDate,

    getUsingPath: getUsingPath
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./base.js":28}],60:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/extension_registry.js");

'use strict';

/**
 * @fileoverview Base class for auditors.
 */
global.tr.exportTo('tr.c', function () {
  function Auditor(model) {
    this.model_ = model;
  }

  Auditor.prototype = {
    __proto__: Object.prototype,

    get model() {
      return this.model_;
    },

    /**
     * Called by the Model after baking slices. May modify model.
     */
    runAnnotate: function () {},

    /**
     * Called by import to install userFriendlyCategoryDriver.
     */
    installUserFriendlyCategoryDriverIfNeeded: function () {},

    /**
     * Called by the Model after importing. Should not modify model, except
     * for adding interaction ranges and audits.
     */
    runAudit: function () {}
  };

  var options = new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);
  options.defaultMetadata = {};
  options.mandatoryBaseClass = Auditor;
  tr.b.decorateExtensionRegistry(Auditor, options);

  return {
    Auditor: Auditor
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/extension_registry.js":35}],61:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2012 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");

'use strict';

global.tr.exportTo('tr.c', function () {
  function makeCaseInsensitiveRegex(pattern) {
    // See https://developer.mozilla.org/en/docs/Web/JavaScript/Guide/
    // Regular_Expressions.
    pattern = pattern.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    return new RegExp(pattern, 'i');
  }

  /**
   * @constructor The generic base class for filtering a Model based on
   * various rules. The base class returns true for everything.
   */
  function Filter() {}

  Filter.prototype = {
    __proto__: Object.prototype,

    matchCounter: function (counter) {
      return true;
    },

    matchCpu: function (cpu) {
      return true;
    },

    matchProcess: function (process) {
      return true;
    },

    matchSlice: function (slice) {
      return true;
    },

    matchThread: function (thread) {
      return true;
    }
  };

  /**
   * @constructor A filter that matches objects by their name or category
   * case insensitive.
   * .findAllObjectsMatchingFilter
   */
  function TitleOrCategoryFilter(text) {
    Filter.call(this);
    this.regex_ = makeCaseInsensitiveRegex(text);

    if (!text.length) throw new Error('Filter text is empty.');
  }
  TitleOrCategoryFilter.prototype = {
    __proto__: Filter.prototype,

    matchSlice: function (slice) {
      if (slice.title === undefined && slice.category === undefined) return false;

      return this.regex_.test(slice.title) || !!slice.category && this.regex_.test(slice.category);
    }
  };

  /**
   * @constructor A filter that matches objects with the exact given title.
   */
  function ExactTitleFilter(text) {
    Filter.call(this);
    this.text_ = text;

    if (!text.length) throw new Error('Filter text is empty.');
  }
  ExactTitleFilter.prototype = {
    __proto__: Filter.prototype,

    matchSlice: function (slice) {
      return slice.title === this.text_;
    }
  };

  /**
   * @constructor A filter that matches objects by their full text contents
   * (title, category, args). Note that for performance this filter applies a
   * regex against all the keys of the slice arguments instead of recursing
   * through any embedded sub-objects.
   */
  function FullTextFilter(text) {
    Filter.call(this);
    this.regex_ = makeCaseInsensitiveRegex(text);
    this.titleOrCategoryFilter_ = new TitleOrCategoryFilter(text);
  }
  FullTextFilter.prototype = {
    __proto__: Filter.prototype,

    matchObject_: function (obj) {
      for (var key in obj) {
        if (!obj.hasOwnProperty(key)) continue;
        if (this.regex_.test(key)) return true;
        if (this.regex_.test(obj[key])) return true;
      }
      return false;
    },

    matchSlice: function (slice) {
      if (this.titleOrCategoryFilter_.matchSlice(slice)) return true;
      return this.matchObject_(slice.args);
    }
  };

  return {
    Filter: Filter,
    TitleOrCategoryFilter: TitleOrCategoryFilter,
    ExactTitleFilter: ExactTitleFilter,
    FullTextFilter: FullTextFilter
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28}],62:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../../model/async_slice.js");
require("../../../model/event_set.js");
require("../../../model/helpers/chrome_model_helper.js");

'use strict';

global.tr.exportTo('tr.e.cc', function () {
  var AsyncSlice = tr.model.AsyncSlice;
  var EventSet = tr.model.EventSet;

  var UI_COMP_NAME = 'INPUT_EVENT_LATENCY_UI_COMPONENT';
  var ORIGINAL_COMP_NAME = 'INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT';
  var BEGIN_COMP_NAME = 'INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT';
  var END_COMP_NAME = 'INPUT_EVENT_LATENCY_TERMINATED_FRAME_SWAP_COMPONENT';

  var MAIN_RENDERER_THREAD_NAME = 'CrRendererMain';
  var COMPOSITOR_THREAD_NAME = 'Compositor';

  var POSTTASK_FLOW_EVENT = 'disabled-by-default-toplevel.flow';
  var IPC_FLOW_EVENT = 'disabled-by-default-ipc.flow';

  var INPUT_EVENT_TYPE_NAMES = {
    CHAR: 'Char',
    CLICK: 'GestureClick',
    CONTEXT_MENU: 'ContextMenu',
    FLING_CANCEL: 'GestureFlingCancel',
    FLING_START: 'GestureFlingStart',
    KEY_DOWN: 'KeyDown',
    KEY_DOWN_RAW: 'RawKeyDown',
    KEY_UP: 'KeyUp',
    LATENCY_SCROLL_UPDATE: 'ScrollUpdate',
    MOUSE_DOWN: 'MouseDown',
    MOUSE_ENTER: 'MouseEnter',
    MOUSE_LEAVE: 'MouseLeave',
    MOUSE_MOVE: 'MouseMove',
    MOUSE_UP: 'MouseUp',
    MOUSE_WHEEL: 'MouseWheel',
    PINCH_BEGIN: 'GesturePinchBegin',
    PINCH_END: 'GesturePinchEnd',
    PINCH_UPDATE: 'GesturePinchUpdate',
    SCROLL_BEGIN: 'GestureScrollBegin',
    SCROLL_END: 'GestureScrollEnd',
    SCROLL_UPDATE: 'GestureScrollUpdate',
    SCROLL_UPDATE_RENDERER: 'ScrollUpdate',
    SHOW_PRESS: 'GestureShowPress',
    TAP: 'GestureTap',
    TAP_CANCEL: 'GestureTapCancel',
    TAP_DOWN: 'GestureTapDown',
    TOUCH_CANCEL: 'TouchCancel',
    TOUCH_END: 'TouchEnd',
    TOUCH_MOVE: 'TouchMove',
    TOUCH_START: 'TouchStart',
    UNKNOWN: 'UNKNOWN'
  };

  function InputLatencyAsyncSlice() {
    AsyncSlice.apply(this, arguments);
    this.associatedEvents_ = new EventSet();
    this.typeName_ = undefined;
    if (!this.isLegacyEvent) this.determineModernTypeName_();
  }

  InputLatencyAsyncSlice.prototype = {
    __proto__: AsyncSlice.prototype,

    // Legacy InputLatencyAsyncSlices involve a top-level slice titled
    // "InputLatency" containing a subSlice whose title starts with
    // "InputLatency:". Modern InputLatencyAsyncSlices involve a single
    // top-level slice whose title starts with "InputLatency::".
    // Legacy subSlices are not available at construction time, so
    // determineLegacyTypeName_() must be called at get time.
    // So this returns false for the legacy subSlice events titled like
    // "InputLatency:Foo" even though they are technically legacy events.
    get isLegacyEvent() {
      return this.title === 'InputLatency';
    },

    get typeName() {
      if (!this.typeName_) this.determineLegacyTypeName_();
      return this.typeName_;
    },

    checkTypeName_: function () {
      if (!this.typeName_) throw 'Unable to determine typeName';
      var found = false;
      for (var typeName in INPUT_EVENT_TYPE_NAMES) {
        if (this.typeName === INPUT_EVENT_TYPE_NAMES[typeName]) {
          found = true;
          break;
        }
      }
      if (!found) this.typeName_ = INPUT_EVENT_TYPE_NAMES.UNKNOWN;
    },

    determineModernTypeName_: function () {
      // This method works both on modern events titled like
      // "InputLatency::Foo" and also on the legacy subSlices titled like
      // "InputLatency:Foo". Modern events' titles contain 2 colons, whereas the
      // legacy subSlices events contain 1 colon.

      var lastColonIndex = this.title.lastIndexOf(':');
      if (lastColonIndex < 0) return;

      var characterAfterLastColonIndex = lastColonIndex + 1;
      this.typeName_ = this.title.slice(characterAfterLastColonIndex);

      // Check that the determined typeName is known.
      this.checkTypeName_();
    },

    determineLegacyTypeName_: function () {
      // Iterate over all descendent subSlices.
      for (var subSlice of this.enumerateAllDescendents()) {

        // If |subSlice| is not an InputLatencyAsyncSlice, then ignore it.
        var subSliceIsAInputLatencyAsyncSlice = subSlice instanceof InputLatencyAsyncSlice;
        if (!subSliceIsAInputLatencyAsyncSlice) continue;

        // If |subSlice| does not have a typeName, then ignore it.
        if (!subSlice.typeName) continue;

        // If |this| already has a typeName and |subSlice| has a different
        // typeName, then explode!
        if (this.typeName_ && subSlice.typeName_) {
          var subSliceHasDifferentTypeName = this.typeName_ !== subSlice.typeName_;
          if (subSliceHasDifferentTypeName) {
            throw 'InputLatencyAsyncSlice.determineLegacyTypeName_() ' + ' found multiple typeNames';
          }
        }

        // The typeName of |this| top-level event is whatever the typeName of
        // |subSlice| is. Set |this.typeName_| to the subSlice's typeName.
        this.typeName_ = subSlice.typeName_;
      }

      // If typeName could not be determined, then explode!
      if (!this.typeName_) throw 'InputLatencyAsyncSlice.determineLegacyTypeName_() failed';

      // Check that the determined typeName is known.
      this.checkTypeName_();
    },

    getRendererHelper: function (sourceSlices) {
      var traceModel = this.startThread.parent.model;
      var modelHelper = traceModel.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
      if (!modelHelper) return undefined;

      var mainThread = undefined;
      var compositorThread = undefined;

      for (var i in sourceSlices) {
        if (sourceSlices[i].parentContainer.name === MAIN_RENDERER_THREAD_NAME) mainThread = sourceSlices[i].parentContainer;else if (sourceSlices[i].parentContainer.name === COMPOSITOR_THREAD_NAME) compositorThread = sourceSlices[i].parentContainer;

        if (mainThread && compositorThread) break;
      }

      var rendererHelpers = modelHelper.rendererHelpers;

      var pids = Object.keys(rendererHelpers);
      for (var i = 0; i < pids.length; i++) {
        var pid = pids[i];
        var rendererHelper = rendererHelpers[pid];
        if (rendererHelper.mainThread === mainThread || rendererHelper.compositorThread === compositorThread) return rendererHelper;
      }

      return undefined;
    },

    addEntireSliceHierarchy: function (slice) {
      this.associatedEvents_.push(slice);
      slice.iterateAllSubsequentSlices(function (subsequentSlice) {
        this.associatedEvents_.push(subsequentSlice);
      }, this);
    },

    addDirectlyAssociatedEvents: function (flowEvents) {
      var slices = [];

      flowEvents.forEach(function (flowEvent) {
        this.associatedEvents_.push(flowEvent);
        var newSource = flowEvent.startSlice.mostTopLevelSlice;
        if (slices.indexOf(newSource) === -1) slices.push(newSource);
      }, this);

      var lastFlowEvent = flowEvents[flowEvents.length - 1];
      var lastSource = lastFlowEvent.endSlice.mostTopLevelSlice;
      if (slices.indexOf(lastSource) === -1) slices.push(lastSource);

      return slices;
    },

    // Find the Latency::ScrollUpdate slice that corresponds to the
    // InputLatency::GestureScrollUpdate slice.
    // The C++ CL that makes this connection is at:
    // https://codereview.chromium.org/1178963003
    addScrollUpdateEvents: function (rendererHelper) {
      if (!rendererHelper || !rendererHelper.compositorThread) return;

      var compositorThread = rendererHelper.compositorThread;
      var gestureScrollUpdateStart = this.start;
      var gestureScrollUpdateEnd = this.end;

      var allCompositorAsyncSlices = compositorThread.asyncSliceGroup.slices;

      for (var i in allCompositorAsyncSlices) {
        var slice = allCompositorAsyncSlices[i];

        if (slice.title !== 'Latency::ScrollUpdate') continue;

        var parentId = slice.args.data.INPUT_EVENT_LATENCY_FORWARD_SCROLL_UPDATE_TO_MAIN_COMPONENT.sequence_number;

        if (parentId === undefined) {
          // Old trace, we can only rely on the timestamp to find the slice
          if (slice.start < gestureScrollUpdateStart || slice.start >= gestureScrollUpdateEnd) continue;
        } else {
          // New trace, we can definitively find the latency slice by comparing
          // its sequence number with gesture id
          if (parseInt(parentId) !== parseInt(this.id)) continue;
        }

        slice.associatedEvents.forEach(function (event) {
          this.associatedEvents_.push(event);
        }, this);
        break;
      }
    },

    // Return true if the slice hierarchy is tracked by LatencyInfo of other
    // input latency events. If the slice hierarchy is tracked by both, this
    // function still returns true.
    belongToOtherInputs: function (slice, flowEvents) {
      var fromOtherInputs = false;

      slice.iterateEntireHierarchy(function (subsequentSlice) {
        if (fromOtherInputs) return;

        subsequentSlice.inFlowEvents.forEach(function (inflow) {
          if (fromOtherInputs) return;

          if (inflow.category.indexOf('input') > -1) {
            if (flowEvents.indexOf(inflow) === -1) fromOtherInputs = true;
          }
        }, this);
      }, this);

      return fromOtherInputs;
    },

    // Return true if |event| triggers slices of other inputs.
    triggerOtherInputs: function (event, flowEvents) {
      if (event.outFlowEvents === undefined || event.outFlowEvents.length === 0) return false;

      // Once we fix the bug of flow event binding, there should exist one and
      // only one outgoing flow (PostTask) from ScheduleBeginImplFrameDeadline
      // and PostComposite.
      var flow = event.outFlowEvents[0];

      if (flow.category !== POSTTASK_FLOW_EVENT || !flow.endSlice) return false;

      var endSlice = flow.endSlice;
      if (this.belongToOtherInputs(endSlice.mostTopLevelSlice, flowEvents)) return true;

      return false;
    },

    // Follow outgoing flow of subsequentSlices in the current hierarchy.
    // We also handle cases where different inputs interfere with each other.
    followSubsequentSlices: function (event, queue, visited, flowEvents) {
      var stopFollowing = false;
      var inputAck = false;

      event.iterateAllSubsequentSlices(function (slice) {
        if (stopFollowing) return;

        // Do not follow TaskQueueManager::RunTask because it causes
        // many false events to be included.
        if (slice.title === 'TaskQueueManager::RunTask') return;

        // Do not follow ScheduledActionSendBeginMainFrame because the real
        // main thread BeginMainFrame is already traced by LatencyInfo flow.
        if (slice.title === 'ThreadProxy::ScheduledActionSendBeginMainFrame') return;

        // Do not follow ScheduleBeginImplFrameDeadline that triggers an
        // OnBeginImplFrameDeadline that is tracked by another LatencyInfo.
        if (slice.title === 'Scheduler::ScheduleBeginImplFrameDeadline') {
          if (this.triggerOtherInputs(slice, flowEvents)) return;
        }

        // Do not follow PostComposite that triggers CompositeImmediately
        // that is tracked by another LatencyInfo.
        if (slice.title === 'CompositorImpl::PostComposite') {
          if (this.triggerOtherInputs(slice, flowEvents)) return;
        }

        // Stop following the rest of the current slice hierarchy if
        // FilterAndSendWebInputEvent occurs after ProcessInputEventAck.
        if (slice.title === 'InputRouterImpl::ProcessInputEventAck') inputAck = true;
        if (inputAck && slice.title === 'InputRouterImpl::FilterAndSendWebInputEvent') stopFollowing = true;

        this.followCurrentSlice(slice, queue, visited);
      }, this);
    },

    // Follow outgoing flow events of the current slice.
    followCurrentSlice: function (event, queue, visited) {
      event.outFlowEvents.forEach(function (outflow) {
        if ((outflow.category === POSTTASK_FLOW_EVENT || outflow.category === IPC_FLOW_EVENT) && outflow.endSlice) {
          this.associatedEvents_.push(outflow);

          var nextEvent = outflow.endSlice.mostTopLevelSlice;
          if (!visited.contains(nextEvent)) {
            visited.push(nextEvent);
            queue.push(nextEvent);
          }
        }
      }, this);
    },

    backtraceFromDraw: function (beginImplFrame, visited) {
      var pendingEventQueue = [];
      pendingEventQueue.push(beginImplFrame.mostTopLevelSlice);

      while (pendingEventQueue.length !== 0) {
        var event = pendingEventQueue.pop();

        this.addEntireSliceHierarchy(event);

        // TODO(yuhao): For now, we backtrace all the way to the source input.
        // But is this really needed? I will have an entry in the design
        // doc to discuss this.
        event.inFlowEvents.forEach(function (inflow) {
          if (inflow.category === POSTTASK_FLOW_EVENT && inflow.startSlice) {
            var nextEvent = inflow.startSlice.mostTopLevelSlice;
            if (!visited.contains(nextEvent)) {
              visited.push(nextEvent);
              pendingEventQueue.push(nextEvent);
            }
          }
        }, this);
      }
    },

    sortRasterizerSlices: function (rasterWorkerThreads, sortedRasterizerSlices) {
      rasterWorkerThreads.forEach(function (rasterizer) {
        Array.prototype.push.apply(sortedRasterizerSlices, rasterizer.sliceGroup.slices);
      }, this);

      sortedRasterizerSlices.sort(function (a, b) {
        if (a.start !== b.start) return a.start - b.start;
        return a.guid - b.guid;
      });
    },

    // Find rasterization slices that have the source_prepare_tiles_id
    // same as the prepare_tiles_id of TileManager::PrepareTiles
    // The C++ CL that makes this connection is at:
    // https://codereview.chromium.org/1208683002/
    addRasterizationEvents: function (prepareTiles, rendererHelper, visited, flowEvents, sortedRasterizerSlices) {
      if (!prepareTiles.args.prepare_tiles_id) return;

      if (!rendererHelper || !rendererHelper.rasterWorkerThreads) return;

      var rasterWorkerThreads = rendererHelper.rasterWorkerThreads;
      var prepareTileId = prepareTiles.args.prepare_tiles_id;
      var pendingEventQueue = [];

      // Collect all the rasterizer tasks. Return the cached copy if possible.
      if (sortedRasterizerSlices.length === 0) this.sortRasterizerSlices(rasterWorkerThreads, sortedRasterizerSlices);

      // TODO(yuhao): Once TaskSetFinishedTaskImpl also get the prepareTileId
      // we can simply track by checking id rather than counting.
      var numFinishedTasks = 0;
      var RASTER_TASK_TITLE = 'RasterizerTaskImpl::RunOnWorkerThread';
      var IMAGEDECODE_TASK_TITLE = 'ImageDecodeTaskImpl::RunOnWorkerThread';
      var FINISHED_TASK_TITLE = 'TaskSetFinishedTaskImpl::RunOnWorkerThread';

      for (var i = 0; i < sortedRasterizerSlices.length; i++) {
        var task = sortedRasterizerSlices[i];

        if (task.title === RASTER_TASK_TITLE || task.title === IMAGEDECODE_TASK_TITLE) {
          if (task.args.source_prepare_tiles_id === prepareTileId) this.addEntireSliceHierarchy(task.mostTopLevelSlice);
        } else if (task.title === FINISHED_TASK_TITLE) {
          if (task.start > prepareTiles.start) {
            pendingEventQueue.push(task.mostTopLevelSlice);
            if (++numFinishedTasks === 3) break;
          }
        }
      }

      // Trace PostTask from rasterizer tasks.
      while (pendingEventQueue.length != 0) {
        var event = pendingEventQueue.pop();

        this.addEntireSliceHierarchy(event);
        this.followSubsequentSlices(event, pendingEventQueue, visited, flowEvents);
      }
    },

    addOtherCausallyRelatedEvents: function (rendererHelper, sourceSlices, flowEvents, sortedRasterizerSlices) {
      var pendingEventQueue = [];
      // Keep track of visited nodes when traversing a DAG
      var visitedEvents = new EventSet();
      var beginImplFrame = undefined;
      var prepareTiles = undefined;
      var sortedRasterizerSlices = [];

      sourceSlices.forEach(function (sourceSlice) {
        if (!visitedEvents.contains(sourceSlice)) {
          visitedEvents.push(sourceSlice);
          pendingEventQueue.push(sourceSlice);
        }
      }, this);

      while (pendingEventQueue.length != 0) {
        var event = pendingEventQueue.pop();

        // Push the current event chunk into associatedEvents.
        this.addEntireSliceHierarchy(event);

        this.followCurrentSlice(event, pendingEventQueue, visitedEvents);

        this.followSubsequentSlices(event, pendingEventQueue, visitedEvents, flowEvents);

        // The rasterization work (CompositorTileWorker thread) and the
        // Compositor tile manager are connect by the prepare_tiles_id
        // instead of flow events.
        var COMPOSITOR_PREPARE_TILES = 'TileManager::PrepareTiles';
        prepareTiles = event.findDescendentSlice(COMPOSITOR_PREPARE_TILES);
        if (prepareTiles) this.addRasterizationEvents(prepareTiles, rendererHelper, visitedEvents, flowEvents, sortedRasterizerSlices);

        // OnBeginImplFrameDeadline could be triggered by other inputs.
        // For now, we backtrace from it.
        // TODO(yuhao): There are more such slices that we need to backtrace
        var COMPOSITOR_ON_BIFD = 'Scheduler::OnBeginImplFrameDeadline';
        beginImplFrame = event.findDescendentSlice(COMPOSITOR_ON_BIFD);
        if (beginImplFrame) this.backtraceFromDraw(beginImplFrame, visitedEvents);
      }

      // A separate pass on GestureScrollUpdate.
      // Scroll update doesn't go through the main thread, but the compositor
      // may go back to the main thread if there is an onscroll event handler.
      // This is captured by a different flow event, which does not have the
      // same ID as the Input Latency Event, but it is technically causally
      // related to the GestureScrollUpdate input. Add them manually for now.
      var INPUT_GSU = 'InputLatency::GestureScrollUpdate';
      if (this.title === INPUT_GSU) this.addScrollUpdateEvents(rendererHelper);
    },

    get associatedEvents() {
      if (this.associatedEvents_.length !== 0) return this.associatedEvents_;

      var modelIndices = this.startThread.parent.model.modelIndices;
      var flowEvents = modelIndices.getFlowEventsWithId(this.id);

      if (flowEvents.length === 0) return this.associatedEvents_;

      // Step 1: Get events that are directly connected by the LatencyInfo
      // flow events. This gives us a small set of events that are guaranteed
      // to be associated with the input, but are almost certain incomplete.
      // We call this set "source" event set.
      // This step returns the "source" event set (sourceSlices), which is then
      // used in the second step.
      var sourceSlices = this.addDirectlyAssociatedEvents(flowEvents);

      // Step 2: Start from the previously constructed "source" event set, we
      // follow the toplevel (i.e., PostTask) and IPC flow events. Any slices
      // that are reachable from the "source" event set via PostTasks or IPCs
      // are conservatively considered associated with the input event.
      // We then deal with specific cases where flow events either over include
      // or miss capturing slices.
      var rendererHelper = this.getRendererHelper(sourceSlices);
      this.addOtherCausallyRelatedEvents(rendererHelper, sourceSlices, flowEvents);

      return this.associatedEvents_;
    },

    get inputLatency() {
      if (!('data' in this.args)) return undefined;

      var data = this.args.data;
      if (!(END_COMP_NAME in data)) return undefined;

      var latency = 0;
      var endTime = data[END_COMP_NAME].time;
      if (ORIGINAL_COMP_NAME in data) {
        latency = endTime - data[ORIGINAL_COMP_NAME].time;
      } else if (UI_COMP_NAME in data) {
        latency = endTime - data[UI_COMP_NAME].time;
      } else if (BEGIN_COMP_NAME in data) {
        latency = endTime - data[BEGIN_COMP_NAME].time;
      } else {
        throw new Error('No valid begin latency component');
      }
      return latency;
    }
  };

  var eventTypeNames = ['Char', 'ContextMenu', 'GestureClick', 'GestureFlingCancel', 'GestureFlingStart', 'GestureScrollBegin', 'GestureScrollEnd', 'GestureScrollUpdate', 'GestureShowPress', 'GestureTap', 'GestureTapCancel', 'GestureTapDown', 'GesturePinchBegin', 'GesturePinchEnd', 'GesturePinchUpdate', 'KeyDown', 'KeyUp', 'MouseDown', 'MouseEnter', 'MouseLeave', 'MouseMove', 'MouseUp', 'MouseWheel', 'RawKeyDown', 'ScrollUpdate', 'TouchCancel', 'TouchEnd', 'TouchMove', 'TouchStart'];
  var allTypeNames = ['InputLatency'];
  eventTypeNames.forEach(function (eventTypeName) {
    // Old style.
    allTypeNames.push('InputLatency:' + eventTypeName);

    // New style.
    allTypeNames.push('InputLatency::' + eventTypeName);
  });

  AsyncSlice.subTypes.register(InputLatencyAsyncSlice, {
    typeNames: allTypeNames,
    categoryParts: ['latencyInfo']
  });

  return {
    InputLatencyAsyncSlice: InputLatencyAsyncSlice,
    INPUT_EVENT_TYPE_NAMES: INPUT_EVENT_TYPE_NAMES
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../../model/async_slice.js":103,"../../../model/event_set.js":120,"../../../model/helpers/chrome_model_helper.js":127}],63:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/event.js");
require("../../base/iteration_helpers.js");
require("../../base/sinebow_color_generator.js");

'use strict';

global.tr.exportTo('tr.e.chrome', function () {
  var SAME_AS_PARENT = 'same-as-parent';

  var TITLES_FOR_USER_FRIENDLY_CATEGORY = {
    composite: ['CompositingInputsUpdater::update', 'ThreadProxy::SetNeedsUpdateLayers', 'LayerTreeHost::UpdateLayers::CalcDrawProps', 'UpdateLayerTree'],

    gc: ['minorGC', 'majorGC', 'MajorGC', 'MinorGC', 'V8.GCScavenger', 'V8.GCIncrementalMarking', 'V8.GCIdleNotification', 'V8.GCContext', 'V8.GCCompactor', 'V8GCController::traceDOMWrappers'],

    iframe_creation: ['WebLocalFrameImpl::createChildframe'],

    imageDecode: ['Decode Image', 'ImageFrameGenerator::decode', 'ImageFrameGenerator::decodeAndScale'],

    input: ['HitTest', 'ScrollableArea::scrollPositionChanged', 'EventHandler::handleMouseMoveEvent'],

    layout: ['FrameView::invalidateTree', 'FrameView::layout', 'FrameView::performLayout', 'FrameView::performPostLayoutTasks', 'FrameView::performPreLayoutTasks', 'Layer::updateLayerPositionsAfterLayout', 'Layout', 'LayoutView::hitTest', 'ResourceLoadPriorityOptimizer::updateAllImageResourcePriorities', 'WebViewImpl::layout'],

    parseHTML: ['ParseHTML', 'HTMLDocumentParser::didReceiveParsedChunkFromBackgroundParser', 'HTMLDocumentParser::processParsedChunkFromBackgroundParser'],

    raster: ['DisplayListRasterSource::PerformSolidColorAnalysis', 'Picture::Raster', 'RasterBufferImpl::Playback', 'RasterTask', 'RasterizerTaskImpl::RunOnWorkerThread', 'SkCanvas::drawImageRect()', 'SkCanvas::drawPicture()', 'SkCanvas::drawTextBlob()', 'TileTaskWorkerPool::PlaybackToMemory'],

    record: ['ContentLayerDelegate::paintContents', 'DeprecatedPaintLayerCompositor::updateIfNeededRecursive', 'DeprecatedPaintLayerCompositor::updateLayerPositionsAfterLayout', 'Paint', 'Picture::Record', 'PictureLayer::Update', 'RenderLayer::updateLayerPositionsAfterLayout'],

    style: ['CSSParserImpl::parseStyleSheet.parse', 'CSSParserImpl::parseStyleSheet.tokenize', 'Document::updateStyle', 'Document::updateStyleInvalidationIfNeeded', 'ParseAuthorStyleSheet', 'RuleSet::addRulesFromSheet', 'StyleElement::processStyleSheet', 'StyleEngine::createResolver', 'StyleSheetContents::parseAuthorStyleSheet', 'UpdateLayoutTree'],

    script_parse_and_compile: ['v8.parseOnBackground', 'V8.ScriptCompiler'],

    script_execute: ['V8.Execute', 'WindowProxy::initialize'],

    resource_loading: ['ResourceFetcher::requestResource', 'ResourceDispatcher::OnReceivedData', 'ResourceDispatcher::OnRequestComplete', 'ResourceDispatcher::OnReceivedResponse', 'Resource::appendData'],

    // Where do these go?
    renderer_misc: ['DecodeFont', 'ThreadState::completeSweep' // blink_gc
    ],

    // TODO(fmeawad): https://github.com/catapult-project/catapult/issues/2572
    v8_runtime: [
      // Dynamically populated.
    ],

    [SAME_AS_PARENT]: ['SyncChannel::Send']
  };

  var COLOR_FOR_USER_FRIENDLY_CATEGORY = new tr.b.SinebowColorGenerator();
  var USER_FRIENDLY_CATEGORY_FOR_TITLE = new Map();

  for (var category in TITLES_FOR_USER_FRIENDLY_CATEGORY) {
    TITLES_FOR_USER_FRIENDLY_CATEGORY[category].forEach(function (title) {
      USER_FRIENDLY_CATEGORY_FOR_TITLE.set(title, category);
    });
  }

  // keys: event.category part
  // values: user friendly category
  var USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY = {
    netlog: 'net',
    overhead: 'overhead',
    startup: 'startup',
    gpu: 'gpu'
  };

  function ChromeUserFriendlyCategoryDriver() {}

  ChromeUserFriendlyCategoryDriver.fromEvent = function (event) {
    var userFriendlyCategory = USER_FRIENDLY_CATEGORY_FOR_TITLE.get(event.title);
    if (userFriendlyCategory) {
      if (userFriendlyCategory == SAME_AS_PARENT) {
        if (event.parentSlice) return ChromeUserFriendlyCategoryDriver.fromEvent(event.parentSlice);
      } else {
        return userFriendlyCategory;
      }
    }

    var eventCategoryParts = tr.b.getCategoryParts(event.category);
    for (var i = 0; i < eventCategoryParts.length; ++i) {
      var eventCategory = eventCategoryParts[i];
      userFriendlyCategory = USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY[eventCategory];
      if (userFriendlyCategory) return userFriendlyCategory;
    }

    return 'other';
  };

  ChromeUserFriendlyCategoryDriver.getColor = function (ufc) {
    return COLOR_FOR_USER_FRIENDLY_CATEGORY.colorForKey(ufc);
  };

  ChromeUserFriendlyCategoryDriver.ALL_TITLES = ['other'];
  for (var category in TITLES_FOR_USER_FRIENDLY_CATEGORY) {
    if (category === SAME_AS_PARENT) continue;
    ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);
  }
  for (var category of tr.b.dictionaryValues(USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY)) {
    ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);
  }
  ChromeUserFriendlyCategoryDriver.ALL_TITLES.sort();

  // Prime the color generator by iterating through all UFCs in alphabetical
  // order.
  for (var category of ChromeUserFriendlyCategoryDriver.ALL_TITLES) ChromeUserFriendlyCategoryDriver.getColor(category);

  return {
    ChromeUserFriendlyCategoryDriver: ChromeUserFriendlyCategoryDriver
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/event.js":33,"../../base/iteration_helpers.js":41,"../../base/sinebow_color_generator.js":51}],64:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../model/source_info/js_source_info.js");

'use strict';

/**
 * @fileoverview TraceCodeEntry is a wrapper around the V8 CodeEntry that
 * extracts extra context information for each item. This includes things like
 * the source file, line and if the function is a native method or not.
 */
global.tr.exportTo('tr.e.importer', function () {
  function TraceCodeEntry(address, size, name, scriptId) {
    this.id_ = tr.b.GUID.allocateSimple();
    this.address_ = address;
    this.size_ = size;

    // Stolen from DevTools TimelineJSProfileProcessor._buildCallFrame
    // Code states:
    // (empty) -> compiled
    //    ~    -> optimizable
    //    *    -> optimized
    var rePrefix = /^(\w*:)?([*~]?)(.*)$/m;
    var tokens = rePrefix.exec(name);
    var prefix = tokens[1];
    var state = tokens[2];
    var body = tokens[3];

    if (state === '*') {
      state = tr.model.source_info.JSSourceState.OPTIMIZED;
    } else if (state === '~') {
      state = tr.model.source_info.JSSourceState.OPTIMIZABLE;
    } else if (state === '') {
      state = tr.model.source_info.JSSourceState.COMPILED;
    } else {
      console.warning('Unknown v8 code state ' + state);
      state = tr.model.source_info.JSSourceState.UNKNOWN;
    }

    var rawName;
    var rawUrl;
    if (prefix === 'Script:') {
      rawName = '';
      rawUrl = body;
    } else {
      var spacePos = body.lastIndexOf(' ');
      rawName = spacePos !== -1 ? body.substr(0, spacePos) : body;
      rawUrl = spacePos !== -1 ? body.substr(spacePos + 1) : '';
    }

    function splitLineAndColumn(url) {
      var lineColumnRegEx = /(?::(\d+))?(?::(\d+))?$/;
      var lineColumnMatch = lineColumnRegEx.exec(url);
      var lineNumber;
      var columnNumber;

      if (typeof lineColumnMatch[1] === 'string') {
        lineNumber = parseInt(lineColumnMatch[1], 10);
        // Immediately convert line and column to 0-based numbers.
        lineNumber = isNaN(lineNumber) ? undefined : lineNumber - 1;
      }
      if (typeof lineColumnMatch[2] === 'string') {
        columnNumber = parseInt(lineColumnMatch[2], 10);
        columnNumber = isNaN(columnNumber) ? undefined : columnNumber - 1;
      }

      return {
        url: url.substring(0, url.length - lineColumnMatch[0].length),
        lineNumber: lineNumber,
        columnNumber: columnNumber
      };
    }

    var nativeSuffix = ' native';
    var isNative = rawName.endsWith(nativeSuffix);
    this.name_ = isNative ? rawName.slice(0, -nativeSuffix.length) : rawName;

    var urlData = splitLineAndColumn(rawUrl);
    var url = urlData.url || '';
    var line = urlData.lineNumber || 0;
    var column = urlData.columnNumber || 0;

    this.sourceInfo_ = new tr.model.source_info.JSSourceInfo(url, line, column, isNative, scriptId, state);
  };

  TraceCodeEntry.prototype = {
    get id() {
      return this.id_;
    },

    get sourceInfo() {
      return this.sourceInfo_;
    },

    get name() {
      return this.name_;
    },

    set address(address) {
      this.address_ = address;
    },

    get address() {
      return this.address_;
    },

    set size(size) {
      this.size_ = size;
    },

    get size() {
      return this.size_;
    }
  };

  return {
    TraceCodeEntry: TraceCodeEntry
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../model/source_info/js_source_info.js":153}],65:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./trace_code_entry.js");

'use strict';

global.tr.exportTo('tr.e.importer', function () {
  // This code is a tracification of:
  // devtools/front_end/timeline/TimelineJSProfile.js
  function TraceCodeMap() {
    this.banks_ = new Map();
  }

  TraceCodeMap.prototype = {
    addEntry: function (addressHex, size, name, scriptId) {
      var entry = new tr.e.importer.TraceCodeEntry(this.getAddress_(addressHex), size, name, scriptId);

      this.addEntry_(addressHex, entry);
    },

    moveEntry: function (oldAddressHex, newAddressHex, size) {
      var entry = this.getBank_(oldAddressHex).removeEntry(this.getAddress_(oldAddressHex));
      if (!entry) return;

      entry.address = this.getAddress_(newAddressHex);
      entry.size = size;
      this.addEntry_(newAddressHex, entry);
    },

    lookupEntry: function (addressHex) {
      return this.getBank_(addressHex).lookupEntry(this.getAddress_(addressHex));
    },

    addEntry_: function (addressHex, entry) {
      // FIXME: Handle bank spanning addresses ...
      this.getBank_(addressHex).addEntry(entry);
    },

    getAddress_: function (addressHex) {
      // 13 hex digits == 52 bits, double mantissa fits 53 bits.
      var bankSizeHexDigits = 13;
      addressHex = addressHex.slice(2); // cut 0x prefix.
      return parseInt(addressHex.slice(-bankSizeHexDigits), 16);
    },

    getBank_: function (addressHex) {
      addressHex = addressHex.slice(2); // cut 0x prefix.

      // 13 hex digits == 52 bits, double mantissa fits 53 bits.
      var bankSizeHexDigits = 13;
      var maxHexDigits = 16;
      var bankName = addressHex.slice(-maxHexDigits, -bankSizeHexDigits);
      var bank = this.banks_.get(bankName);
      if (!bank) {
        bank = new TraceCodeBank();
        this.banks_.set(bankName, bank);
      }
      return bank;
    }
  };

  function TraceCodeBank() {
    this.entries_ = [];
  }

  TraceCodeBank.prototype = {
    removeEntry: function (address) {
      // findLowIndexInSortedArray returns 1 for empty. Just handle the
      // empty list and bail early.
      if (this.entries_.length === 0) return undefined;

      var index = tr.b.findLowIndexInSortedArray(this.entries_, function (entry) {
        return entry.address;
      }, address);
      var entry = this.entries_[index];
      if (!entry || entry.address !== address) return undefined;

      this.entries_.splice(index, 1);
      return entry;
    },

    lookupEntry: function (address) {
      var index = tr.b.findHighIndexInSortedArray(this.entries_, function (e) {
        return address - e.address;
      }) - 1;
      var entry = this.entries_[index];
      return entry && address < entry.address + entry.size ? entry : undefined;
    },

    addEntry: function (newEntry) {
      // findLowIndexInSortedArray returns 1 for empty list. Just push the
      // new address as it's the only item.
      if (this.entries_.length === 0) this.entries_.push(newEntry);

      var endAddress = newEntry.address + newEntry.size;
      var lastIndex = tr.b.findLowIndexInSortedArray(this.entries_, function (entry) {
        return entry.address;
      }, endAddress);
      var index;
      for (index = lastIndex - 1; index >= 0; --index) {
        var entry = this.entries_[index];
        var entryEndAddress = entry.address + entry.size;
        if (entryEndAddress <= newEntry.address) break;
      }
      ++index;
      this.entries_.splice(index, lastIndex - index, newEntry);
    }
  };

  return {
    TraceCodeMap: TraceCodeMap
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./trace_code_entry.js":64}],66:[function(require,module,exports){
(function (global){
"use strict";/**
Copyright (c) 2012 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/require("../../base/base64.js");require("../../base/color_scheme.js");require("../../base/range.js");require("../../base/unit.js");require("../../base/utils.js");require("./trace_code_entry.js");require("./trace_code_map.js");require("./v8/codemap.js");require("../../importer/context_processor.js");require("../../importer/importer.js");require("../../model/comment_box_annotation.js");require("../../model/constants.js");require("../../model/container_memory_dump.js");require("../../model/counter_series.js");require("../../model/flow_event.js");require("../../model/global_memory_dump.js");require("../../model/heap_dump.js");require("../../model/instant_event.js");require("../../model/memory_allocator_dump.js");require("../../model/model.js");require("../../model/process_memory_dump.js");require("../../model/rect_annotation.js");require("../../model/scoped_id.js");require("../../model/slice_group.js");require("../../model/vm_region.js");require("../../model/x_marker_annotation.js");require("../../value/numeric.js");'use strict';/**
 * @fileoverview TraceEventImporter imports TraceEvent-formatted data
 * into the provided model.
 */global.tr.exportTo('tr.e.importer',function(){var Base64=tr.b.Base64;var deepCopy=tr.b.deepCopy;var ColorScheme=tr.b.ColorScheme;function getEventColor(event,opt_customName){if(event.cname)return ColorScheme.getColorIdForReservedName(event.cname);else if(opt_customName||event.name){return ColorScheme.getColorIdForGeneralPurposeString(opt_customName||event.name);}}var PRODUCER='producer';var CONSUMER='consumer';var STEP='step';var BACKGROUND=tr.model.ContainerMemoryDump.LevelOfDetail.BACKGROUND;var LIGHT=tr.model.ContainerMemoryDump.LevelOfDetail.LIGHT;var DETAILED=tr.model.ContainerMemoryDump.LevelOfDetail.DETAILED;var MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER=[undefined,BACKGROUND,LIGHT,DETAILED];var GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX='global/';var ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX='ClockSyncEvent.';// Map from raw memory dump byte stat names to model byte stat names. See
// //base/trace_event/process_memory_maps.cc in Chromium.
var BYTE_STAT_NAME_MAP={'pc':'privateCleanResident','pd':'privateDirtyResident','sc':'sharedCleanResident','sd':'sharedDirtyResident','pss':'proportionalResident','sw':'swapped'};// See tr.model.MemoryAllocatorDump 'weak' field and
// base::trace_event::MemoryAllocatorDump::Flags::WEAK in the Chromium
// codebase.
var WEAK_MEMORY_ALLOCATOR_DUMP_FLAG=1<<0;// Object type name patterns for various compilers.
var OBJECT_TYPE_NAME_PATTERNS=[{// Clang.
prefix:'const char *WTF::getStringWithTypeName() [T = ',suffix:']'},{// GCC.
prefix:'const char* WTF::getStringWithTypeName() [with T = ',suffix:']'},{// Microsoft Visual C++
prefix:'const char *__cdecl WTF::getStringWithTypeName<',suffix:'>(void)'}];// The list of fields on the trace that are known to contain subtraces.
var SUBTRACE_FIELDS=new Set(['powerTraceAsString','systemTraceEvents']);// The complete list of fields on the trace that should not be treated as
// trace metadata.
var NON_METADATA_FIELDS=new Set(['samples','stackFrames','traceAnnotations','traceEvents']);// TODO(charliea): Replace this with the spread (...) operator in literal
// above once v8 is updated to a sufficiently recent version (>M45).
for(var subtraceField in SUBTRACE_FIELDS)NON_METADATA_FIELDS.add(subtraceField);function TraceEventImporter(model,eventData){this.importPriority=1;this.model_=model;this.events_=undefined;this.sampleEvents_=undefined;this.stackFrameEvents_=undefined;this.subtraces_=[];this.eventsWereFromString_=false;this.softwareMeasuredCpuCount_=undefined;this.allAsyncEvents_=[];this.allFlowEvents_=[];this.allObjectEvents_=[];this.contextProcessorPerThread={};this.traceEventSampleStackFramesByName_={};this.v8ProcessCodeMaps_={};this.v8ProcessRootStackFrame_={};this.v8SamplingData_=[];// For tracking async events that is used to create back-compat clock sync
// event.
this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;// Dump ID -> PID -> [process memory dump events].
this.allMemoryDumpEvents_={};// PID -> Object type ID -> Object type name.
this.objectTypeNameMap_={};// For old Chrome traces with no clock domain metadata, just use a
// placeholder clock domain.
this.clockDomainId_=tr.model.ClockDomainId.UNKNOWN_CHROME_LEGACY;// A function able to transform timestamps in |clockDomainId| to timestamps
// in the model clock domain.
this.toModelTime_=undefined;if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();// If the event data begins with a [, then we know it should end with a ].
// The reason we check for this is because some tracing implementations
// cannot guarantee that a ']' gets written to the trace file. So, we are
// forgiving and if this is obviously the case, we fix it up before
// throwing the string at JSON.parse.
if(eventData[0]==='['){eventData=eventData.replace(/\s*,\s*$/,'');if(eventData[eventData.length-1]!==']')eventData=eventData+']';}this.events_=JSON.parse(eventData);this.eventsWereFromString_=true;}else{this.events_=eventData;}this.traceAnnotations_=this.events_.traceAnnotations;// Some trace_event implementations put the actual trace events
// inside a container. E.g { ... , traceEvents: [ ] }
// If we see that, just pull out the trace events.
if(this.events_.traceEvents){var container=this.events_;this.events_=this.events_.traceEvents;// Some trace authors store subtraces as specific properties of the trace.
for(var subtraceField of SUBTRACE_FIELDS)if(container[subtraceField])this.subtraces_.push(container[subtraceField]);// Sampling data.
this.sampleEvents_=container.samples;this.stackFrameEvents_=container.stackFrames;// Some implementations specify displayTimeUnit
if(container.displayTimeUnit){var unitName=container.displayTimeUnit;var unit=tr.b.TimeDisplayModes[unitName];if(unit===undefined){throw new Error('Unit '+unitName+' is not supported.');}this.model_.intrinsicTimeUnit=unit;}// Any other fields in the container should be treated as metadata.
for(var fieldName in container){if(NON_METADATA_FIELDS.has(fieldName))continue;this.model_.metadata.push({name:fieldName,value:container[fieldName]});if(fieldName==='metadata'){var metadata=container[fieldName];if(metadata['highres-ticks'])this.model_.isTimeHighResolution=metadata['highres-ticks'];if(metadata['clock-domain'])this.clockDomainId_=metadata['clock-domain'];}}}}/**
   * @return {boolean} Whether obj is a TraceEvent array.
   */TraceEventImporter.canImport=function(eventData){// May be encoded JSON. But we dont want to parse it fully yet.
// Use a simple heuristic:
//   - eventData that starts with [ are probably trace_event
//   - eventData that starts with { are probably trace_event
// May be encoded JSON. Treat files that start with { as importable by us.
if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();return eventData[0]==='{'||eventData[0]==='[';}// Might just be an array of events
if(eventData instanceof Array&&eventData.length&&eventData[0].ph)return true;// Might be an object with a traceEvents field in it.
if(eventData.traceEvents){if(eventData.traceEvents instanceof Array){if(eventData.traceEvents.length&&eventData.traceEvents[0].ph)return true;if(eventData.samples.length&&eventData.stackFrames!==undefined)return true;}}return false;};TraceEventImporter.prototype={__proto__:tr.importer.Importer.prototype,get importerName(){return'TraceEventImporter';},extractSubtraces:function(){// Because subtraces can be quite large, we need to make sure that we
// don't hold a reference to the memory.
var subtraces=this.subtraces_;this.subtraces_=[];return subtraces;},/**
     * Deep copying is only needed if the trace was given to us as events.
     */deepCopyIfNeeded_:function(obj){if(obj===undefined)obj={};if(this.eventsWereFromString_)return obj;return deepCopy(obj);},/**
     * Always perform deep copying.
     */deepCopyAlways_:function(obj){if(obj===undefined)obj={};return deepCopy(obj);},/**
     * Helper to process an async event.
     */processAsyncEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allAsyncEvents_.push({sequenceNumber:this.allAsyncEvents_.length,event:event,thread:thread});},/**
     * Helper to process a flow event.
     */processFlowEvent:function(event,opt_slice){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allFlowEvents_.push({refGuid:tr.b.GUID.getLastSimpleGuid(),sequenceNumber:this.allFlowEvents_.length,event:event,slice:opt_slice,// slice for events that have flow info
thread:thread});},/**
     * Helper that creates and adds samples to a Counter object based on
     * 'C' phase events.
     */processCounterEvent:function(event){var ctrName;if(event.id!==undefined)ctrName=event.name+'['+event.id+']';else ctrName=event.name;var ctr=this.model_.getOrCreateProcess(event.pid).getOrCreateCounter(event.cat,ctrName);var reservedColorId=event.cname?getEventColor(event):undefined;// Initialize the counter's series fields if needed.
if(ctr.numSeries===0){for(var seriesName in event.args){var colorId=reservedColorId||getEventColor(event,ctr.name+'.'+seriesName);ctr.addSeries(new tr.model.CounterSeries(seriesName,colorId));}if(ctr.numSeries===0){this.model_.importWarning({type:'counter_parse_error',message:'Expected counter '+event.name+' to have at least one argument to use as a value.'});// Drop the counter.
delete ctr.parent.counters[ctr.name];return;}}var ts=this.toModelTimeFromUs_(event.ts);ctr.series.forEach(function(series){var val=event.args[series.name]?event.args[series.name]:0;series.addCounterSample(ts,val);});},scopedIdForEvent_:function(event){return new tr.model.ScopedId(event.scope||tr.model.OBJECT_DEFAULT_SCOPE,event.id);},processObjectEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allObjectEvents_.push({sequenceNumber:this.allObjectEvents_.length,event:event,thread:thread});if(thread.guid in this.contextProcessorPerThread){var processor=this.contextProcessorPerThread[thread.guid];var scopedId=this.scopedIdForEvent_(event);if(event.ph==='D')processor.destroyContext(scopedId);// The context processor maintains a cache of unique context objects and
// active context sets to reduce memory usage. If an object is modified,
// we should invalidate this cache, because otherwise context sets from
// before and after the modification may erroneously point to the same
// context snapshot (as both are the same set/object instances).
processor.invalidateContextCacheForSnapshot(scopedId);}},processContextEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(!(thread.guid in this.contextProcessorPerThread)){this.contextProcessorPerThread[thread.guid]=new tr.importer.ContextProcessor(this.model_);}var scopedId=this.scopedIdForEvent_(event);var contextType=event.name;var processor=this.contextProcessorPerThread[thread.guid];if(event.ph==='('){processor.enterContext(contextType,scopedId);}else if(event.ph===')'){processor.leaveContext(contextType,scopedId);}else{this.model_.importWarning({type:'unknown_context_phase',message:'Unknown context event phase: '+event.ph+'.'});}},setContextsFromThread_:function(thread,slice){if(thread.guid in this.contextProcessorPerThread){slice.contexts=this.contextProcessorPerThread[thread.guid].activeContexts;}},processDurationEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var ts=this.toModelTimeFromUs_(event.ts);if(!thread.sliceGroup.isTimestampValidForBeginOrEnd(ts)){this.model_.importWarning({type:'duration_parse_error',message:'Timestamps are moving backward.'});return;}if(event.ph==='B'){var slice=thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));slice.startStackFrame=this.getStackFrameForEvent_(event);this.setContextsFromThread_(thread,slice);}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){if(event.s!==undefined&&event.s!=='t')throw new Error('This should never happen');thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts));slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=undefined;}else{if(!thread.sliceGroup.openSliceCount){this.model_.importWarning({type:'duration_parse_error',message:'E phase event without a matching B phase event.'});return;}var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts),getEventColor(event));if(event.name&&slice.title!=event.name){this.model_.importWarning({type:'title_match_error',message:'Titles do not match. Title is '+slice.title+' in openSlice, and is '+event.name+' in endSlice'});}slice.endStackFrame=this.getStackFrameForEvent_(event);this.mergeArgsInto_(slice.args,event.args,slice.title);}},mergeArgsInto_:function(dstArgs,srcArgs,eventName){for(var arg in srcArgs){if(dstArgs[arg]!==undefined){this.model_.importWarning({type:'arg_merge_error',message:'Different phases of '+eventName+' provided values for argument '+arg+'.'+' The last provided value will be used.'});}dstArgs[arg]=this.deepCopyIfNeeded_(srcArgs[arg]);}},processCompleteEvent:function(event){// Preventing the overhead slices from making it into the model. This
// only applies to legacy traces, as the overhead traces have been
// removed from the chromium code.
if(event.cat!==undefined&&event.cat.indexOf('trace_event_overhead')>-1)return undefined;var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(event.flow_out){if(event.flow_in)event.flowPhase=STEP;else event.flowPhase=PRODUCER;}else if(event.flow_in){event.flowPhase=CONSUMER;}var slice=thread.sliceGroup.pushCompleteSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.maybeToModelTimeFromUs_(event.dur),this.maybeToModelTimeFromUs_(event.tts),this.maybeToModelTimeFromUs_(event.tdur),this.deepCopyIfNeeded_(event.args),event.argsStripped,getEventColor(event),event.bind_id);slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=this.getStackFrameForEvent_(event,true);this.setContextsFromThread_(thread,slice);return slice;},processJitCodeEvent:function(event){if(this.v8ProcessCodeMaps_[event.pid]===undefined)this.v8ProcessCodeMaps_[event.pid]=new tr.e.importer.TraceCodeMap();var map=this.v8ProcessCodeMaps_[event.pid];var data=event.args.data;// TODO(dsinclair): There are _a lot_ of JitCode events so I'm skipping
// the display for now. Can revisit later if we want to show them.
// Handle JitCodeMoved and JitCodeAdded event.
if(event.name==='JitCodeMoved')map.moveEntry(data.code_start,data.new_code_start,data.code_len);else// event.name === 'JitCodeAdded'
map.addEntry(data.code_start,data.code_len,data.name,data.script_id);},processMetadataEvent:function(event){// V8 JIT events are currently logged as phase 'M' so we need to
// separate them out and handle specially.
if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}// The metadata events aren't useful without args.
if(event.argsStripped)return;if(event.name==='process_name'){var process=this.model_.getOrCreateProcess(event.pid);process.name=event.args.name;}else if(event.name==='process_labels'){var process=this.model_.getOrCreateProcess(event.pid);var labels=event.args.labels.split(',');for(var i=0;i<labels.length;i++)process.addLabelIfNeeded(labels[i]);}else if(event.name==='process_sort_index'){var process=this.model_.getOrCreateProcess(event.pid);process.sortIndex=event.args.sort_index;}else if(event.name==='thread_name'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.name=event.args.name;}else if(event.name==='thread_sort_index'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.sortIndex=event.args.sort_index;}else if(event.name==='num_cpus'){var n=event.args.number;// Not all render processes agree on the cpu count in trace_event. Some
// processes will report 1, while others will report the actual cpu
// count. To deal with this, take the max of what is reported.
if(this.softwareMeasuredCpuCount_!==undefined)n=Math.max(n,this.softwareMeasuredCpuCount_);this.softwareMeasuredCpuCount_=n;}else if(event.name==='stackFrames'){var stackFrames=event.args.stackFrames;if(stackFrames===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No stack frames found in a \''+event.name+'\' metadata event'});}else{this.importStackFrames_(stackFrames,'p'+event.pid+':');}}else if(event.name==='typeNames'){var objectTypeNameMap=event.args.typeNames;if(objectTypeNameMap===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No mapping from object type IDs to names found in a \''+event.name+'\' metadata event'});}else{this.importObjectTypeNameMap_(objectTypeNameMap,event.pid);}}else if(event.name==='TraceConfig'){this.model_.metadata.push({name:'TraceConfig',value:event.args.value});}else{this.model_.importWarning({type:'metadata_parse_error',message:'Unrecognized metadata name: '+event.name});}},processInstantEvent:function(event){// V8 JIT events were logged as phase 'I' in the old format,
// so we need to separate them out and handle specially.
if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}// Thread-level instant events are treated as zero-duration slices.
if(event.s==='t'||event.s===undefined){this.processDurationEvent(event);return;}var constructor;switch(event.s){case'g':constructor=tr.model.GlobalInstantEvent;break;case'p':constructor=tr.model.ProcessInstantEvent;break;default:this.model_.importWarning({type:'instant_parse_error',message:'I phase event with unknown "s" field value.'});return;}var instantEvent=new constructor(event.cat,event.name,getEventColor(event),this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args));switch(instantEvent.type){case tr.model.InstantEventType.GLOBAL:this.model_.instantEvents.push(instantEvent);break;case tr.model.InstantEventType.PROCESS:var process=this.model_.getOrCreateProcess(event.pid);process.instantEvents.push(instantEvent);break;default:throw new Error('Unknown instant event type: '+event.s);}},processV8Sample:function(event){var data=event.args.data;// As-per DevTools, the backend sometimes creates bogus samples. Skip it.
if(data.vm_state==='js'&&!data.stack.length)return;var rootStackFrame=this.v8ProcessRootStackFrame_[event.pid];if(!rootStackFrame){rootStackFrame=new tr.model.StackFrame(undefined/* parent */,'v8-root-stack-frame'/* id */,'v8-root-stack-frame'/* title */,0/* colorId */);this.v8ProcessRootStackFrame_[event.pid]=rootStackFrame;}function findChildWithEntryID(stackFrame,entryID){return tr.b.findFirstInArray(stackFrame.children,function(child){return child.entryID===entryID;});}var model=this.model_;function addStackFrame(lastStackFrame,entry){var childFrame=findChildWithEntryID(lastStackFrame,entry.id);if(childFrame)return childFrame;var frame=new tr.model.StackFrame(lastStackFrame,tr.b.GUID.allocateSimple(),entry.name,ColorScheme.getColorIdForGeneralPurposeString(entry.name),entry.sourceInfo);frame.entryID=entry.id;model.addStackFrame(frame);return frame;}var lastStackFrame=rootStackFrame;// There are several types of v8 sample events, gc, native, compiler, etc.
// Some of these types have stacks and some don't, we handle those two
// cases differently. For types that don't have any stack frames attached
// we synthesize one based on the type of thing that's happening so when
// we view all the samples we'll see something like 'external' or 'gc'
// as a fraction of the time spent.
if(data.stack.length>0&&this.v8ProcessCodeMaps_[event.pid]){var map=this.v8ProcessCodeMaps_[event.pid];// Stacks have the leaf node first, flip them around so the root
// comes first.
data.stack.reverse();for(var i=0;i<data.stack.length;i++){var entry=map.lookupEntry(data.stack[i]);if(entry===undefined){entry={id:'unknown',name:'unknown',sourceInfo:undefined};}lastStackFrame=addStackFrame(lastStackFrame,entry);}}else{var entry={id:data.vm_state,name:data.vm_state,sourceInfo:undefined};lastStackFrame=addStackFrame(lastStackFrame,entry);}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined/* cpu */,thread,'V8 Sample',this.toModelTimeFromUs_(event.ts),lastStackFrame,1/* weight */,this.deepCopyIfNeeded_(event.args));this.model_.samples.push(sample);},processTraceSampleEvent:function(event){if(event.name==='V8Sample'){this.v8SamplingData_.push(event);return;}var stackFrame=this.getStackFrameForEvent_(event);if(stackFrame===undefined){stackFrame=this.traceEventSampleStackFramesByName_[event.name];}if(stackFrame===undefined){var id='te-'+tr.b.GUID.allocateSimple();stackFrame=new tr.model.StackFrame(undefined,id,event.name,ColorScheme.getColorIdForGeneralPurposeString(event.name));this.model_.addStackFrame(stackFrame);this.traceEventSampleStackFramesByName_[event.name]=stackFrame;}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined,thread,'Trace Event Sample',this.toModelTimeFromUs_(event.ts),stackFrame,1,this.deepCopyIfNeeded_(event.args));this.setContextsFromThread_(thread,sample);this.model_.samples.push(sample);},processMemoryDumpEvent:function(event){if(event.ph!=='v')throw new Error('Invalid memory dump event phase "'+event.ph+'".');var dumpId=event.id;if(dumpId===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase \''+event.ph+'\') without a dump ID.'});return;}var pid=event.pid;if(pid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase\''+event.ph+'\', dump ID \''+dumpId+'\') without a PID.'});return;}// Dump ID -> PID -> [process memory dump events].
var allEvents=this.allMemoryDumpEvents_;// PID -> [process memory dump events].
var dumpIdEvents=allEvents[dumpId];if(dumpIdEvents===undefined)allEvents[dumpId]=dumpIdEvents={};// [process memory dump events].
var processEvents=dumpIdEvents[pid];if(processEvents===undefined)dumpIdEvents[pid]=processEvents=[];processEvents.push(event);},processClockSyncEvent:function(event){if(event.ph!=='c')throw new Error('Invalid clock sync event phase "'+event.ph+'".');var syncId=event.args.sync_id;if(syncId===undefined){this.model_.importWarning({type:'clock_sync_parse_error',message:'Clock sync at time '+event.ts+' without an ID.'});return;}if(event.args&&event.args.issue_ts!==undefined){// When Chrome is the tracing controller and is the requester of the
// clock sync, the clock sync event looks like:
//
//   {
//     "args": {
//       "sync_id": "abc123",
//       "issue_ts": 12340
//     }
//     "ph": "c"
//     "ts": 12345
//     ...
//   }
this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.args.issue_ts),tr.b.Unit.timestampFromUs(event.ts));}else{// When Chrome is a tracing agent and is the recipient of the clock
// sync request, the clock sync event looks like:
//
//   {
//     "args": { "sync_id": "abc123" }
//     "ph": "c"
//     "ts": 12345
//     ...
//   }
this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.ts));}},// Because the order of Jit code events and V8 samples are not guaranteed,
// We store them in an array, sort by timestamp, and then process them.
processV8Events:function(){this.v8SamplingData_.sort(function(a,b){if(a.ts!==b.ts)return a.ts-b.ts;if(a.ph==='M'||a.ph==='I')return-1;else if(b.ph==='M'||b.ph==='I')return 1;return 0;});var length=this.v8SamplingData_.length;for(var i=0;i<length;++i){var event=this.v8SamplingData_[i];if(event.ph==='M'||event.ph==='I'){this.processJitCodeEvent(event);}else if(event.ph==='P'){this.processV8Sample(event);}}},initBackcompatClockSyncEventTracker_:function(event){if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='S')this.asyncClockSyncStart_=event;if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='F')this.asyncClockSyncFinish_=event;if(this.asyncClockSyncStart_==undefined||this.asyncClockSyncFinish_==undefined)return;// Older version of Chrome doesn't support clock sync API, hence
// telemetry get around it by marking the clock sync events with
// console.time & console.timeEnd. When we encounter async events
// with named started with 'ClockSyncEvent.' prefix, create a
// synthetic clock sync events based on their timestamps.
var syncId=this.asyncClockSyncStart_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length);if(syncId!==this.asyncClockSyncFinish_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length)){throw new Error('Inconsistent clock sync id of async clock sync '+'events.');}var clockSyncEvent={ph:'c',args:{sync_id:syncId,issue_ts:this.asyncClockSyncStart_.ts},ts:this.asyncClockSyncFinish_.ts};this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;return clockSyncEvent;},importClockSyncMarkers:function(){var asyncClockSyncStart,asyncClockSyncFinish;for(var i=0;i<this.events_.length;i++){var event=this.events_[i];var possibleBackCompatClockSyncEvent=this.initBackcompatClockSyncEventTracker_(event);if(possibleBackCompatClockSyncEvent)this.processClockSyncEvent(possibleBackCompatClockSyncEvent);if(event.ph!=='c')continue;var eventSizeInBytes=this.model_.importOptions.trackDetailedModelStats?JSON.stringify(event).length:undefined;this.model_.stats.willProcessBasicTraceEvent('clock_sync',event.cat,event.name,event.ts,eventSizeInBytes);this.processClockSyncEvent(event);}},/**
     * Walks through the events_ list and outputs the structures discovered to
     * model_.
     */importEvents:function(){if(this.stackFrameEvents_)this.importStackFrames_(this.stackFrameEvents_,'g');if(this.traceAnnotations_)this.importAnnotations_();var importOptions=this.model_.importOptions;var trackDetailedModelStats=importOptions.trackDetailedModelStats;var modelStats=this.model_.stats;var events=this.events_;for(var eI=0;eI<events.length;eI++){var event=events[eI];if(event.args==='__stripped__'){event.argsStripped=true;event.args=undefined;}var eventSizeInBytes;if(trackDetailedModelStats)eventSizeInBytes=JSON.stringify(event).length;else eventSizeInBytes=undefined;if(event.ph==='B'||event.ph==='E'){modelStats.willProcessBasicTraceEvent('begin_end (non-compact)',event.cat,event.name,event.ts,eventSizeInBytes);this.processDurationEvent(event);}else if(event.ph==='X'){modelStats.willProcessBasicTraceEvent('begin_end (compact)',event.cat,event.name,event.ts,eventSizeInBytes);var slice=this.processCompleteEvent(event);// TODO(yuhaoz): If Chrome supports creating other events with flow,
// we will need to call processFlowEvent for them also.
// https://github.com/catapult-project/catapult/issues/1259
if(slice!==undefined&&event.bind_id!==undefined)this.processFlowEvent(event,slice);}else if(event.ph==='b'||event.ph==='e'||event.ph==='n'||event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){modelStats.willProcessBasicTraceEvent('async',event.cat,event.name,event.ts,eventSizeInBytes);this.processAsyncEvent(event);// Note, I is historic. The instant event marker got changed, but we
// want to support loading old trace files so we have both I and i.
}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){modelStats.willProcessBasicTraceEvent('instant',event.cat,event.name,event.ts,eventSizeInBytes);this.processInstantEvent(event);}else if(event.ph==='P'){modelStats.willProcessBasicTraceEvent('samples',event.cat,event.name,event.ts,eventSizeInBytes);this.processTraceSampleEvent(event);}else if(event.ph==='C'){modelStats.willProcessBasicTraceEvent('counters',event.cat,event.name,event.ts,eventSizeInBytes);this.processCounterEvent(event);}else if(event.ph==='M'){modelStats.willProcessBasicTraceEvent('metadata',event.cat,event.name,event.ts,eventSizeInBytes);this.processMetadataEvent(event);}else if(event.ph==='N'||event.ph==='D'||event.ph==='O'){modelStats.willProcessBasicTraceEvent('objects',event.cat,event.name,event.ts,eventSizeInBytes);this.processObjectEvent(event);}else if(event.ph==='s'||event.ph==='t'||event.ph==='f'){modelStats.willProcessBasicTraceEvent('flows',event.cat,event.name,event.ts,eventSizeInBytes);this.processFlowEvent(event);}else if(event.ph==='v'){modelStats.willProcessBasicTraceEvent('memory_dumps',event.cat,event.name,event.ts,eventSizeInBytes);this.processMemoryDumpEvent(event);}else if(event.ph==='('||event.ph===')'){this.processContextEvent(event);}else if(event.ph==='c'){// No-op. Clock sync events have already been processed in
// importClockSyncMarkers().
}else{modelStats.willProcessBasicTraceEvent('unknown',event.cat,event.name,event.ts,eventSizeInBytes);this.model_.importWarning({type:'parse_error',message:'Unrecognized event phase: '+event.ph+' ('+event.name+')'});}}this.processV8Events();// Remove all the root stack frame children as they should
// already be added.
tr.b.iterItems(this.v8ProcessRootStackFrame_,function(name,frame){frame.removeAllChildren();});},importStackFrames_:function(rawStackFrames,idPrefix){var model=this.model_;for(var id in rawStackFrames){var rawStackFrame=rawStackFrames[id];var fullId=idPrefix+id;var textForColor=rawStackFrame.category?rawStackFrame.category:rawStackFrame.name;var stackFrame=new tr.model.StackFrame(undefined/* parentFrame */,fullId,rawStackFrame.name,ColorScheme.getColorIdForGeneralPurposeString(textForColor));model.addStackFrame(stackFrame);}for(var id in rawStackFrames){var fullId=idPrefix+id;var stackFrame=model.stackFrames[fullId];if(stackFrame===undefined)throw new Error('Internal error');var rawStackFrame=rawStackFrames[id];var parentId=rawStackFrame.parent;var parentStackFrame;if(parentId===undefined){parentStackFrame=undefined;}else{var parentFullId=idPrefix+parentId;parentStackFrame=model.stackFrames[parentFullId];if(parentStackFrame===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'Missing parent frame with ID '+parentFullId+' for stack frame \''+stackFrame.name+'\' (ID '+fullId+').'});}}stackFrame.parentFrame=parentStackFrame;}},importObjectTypeNameMap_:function(rawObjectTypeNameMap,pid){if(pid in this.objectTypeNameMap_){this.model_.importWarning({type:'metadata_parse_error',message:'Mapping from object type IDs to names provided for pid='+pid+' multiple times.'});return;}var objectTypeNamePrefix=undefined;var objectTypeNameSuffix=undefined;var objectTypeNameMap={};for(var objectTypeId in rawObjectTypeNameMap){var rawObjectTypeName=rawObjectTypeNameMap[objectTypeId];// If we haven't figured out yet which compiler the object type names
// come from, we try to do it now.
if(objectTypeNamePrefix===undefined){for(var i=0;i<OBJECT_TYPE_NAME_PATTERNS.length;i++){var pattern=OBJECT_TYPE_NAME_PATTERNS[i];if(rawObjectTypeName.startsWith(pattern.prefix)&&rawObjectTypeName.endsWith(pattern.suffix)){objectTypeNamePrefix=pattern.prefix;objectTypeNameSuffix=pattern.suffix;break;}}}if(objectTypeNamePrefix!==undefined&&rawObjectTypeName.startsWith(objectTypeNamePrefix)&&rawObjectTypeName.endsWith(objectTypeNameSuffix)){// With compiler-specific prefix and suffix (automatically annotated
// object types).
objectTypeNameMap[objectTypeId]=rawObjectTypeName.substring(objectTypeNamePrefix.length,rawObjectTypeName.length-objectTypeNameSuffix.length);}else{// Without compiler-specific prefix and suffix (manually annotated
// object types and '[unknown]').
objectTypeNameMap[objectTypeId]=rawObjectTypeName;}}this.objectTypeNameMap_[pid]=objectTypeNameMap;},importAnnotations_:function(){for(var id in this.traceAnnotations_){var annotation=tr.model.Annotation.fromDictIfPossible(this.traceAnnotations_[id]);if(!annotation){this.model_.importWarning({type:'annotation_warning',message:'Unrecognized traceAnnotation typeName \"'+this.traceAnnotations_[id].typeName+'\"'});continue;}this.model_.addAnnotation(annotation);}},/**
     * Called by the Model after all other importers have imported their
     * events.
     */finalizeImport:function(){if(this.softwareMeasuredCpuCount_!==undefined){this.model_.kernel.softwareMeasuredCpuCount=this.softwareMeasuredCpuCount_;}this.createAsyncSlices_();this.createFlowSlices_();this.createExplicitObjects_();this.createImplicitObjects_();this.createMemoryDumps_();},/* Events can have one or more stack frames associated with them, but
     * that frame might be encoded either as a stack trace of program counters,
     * or as a direct stack frame reference. This handles either case and
     * if found, returns the stackframe.
     */getStackFrameForEvent_:function(event,opt_lookForEndEvent){var sf;var stack;if(opt_lookForEndEvent){sf=event.esf;stack=event.estack;}else{sf=event.sf;stack=event.stack;}if(stack!==undefined&&sf!==undefined){this.model_.importWarning({type:'stack_frame_and_stack_error',message:'Event at '+event.ts+' cannot have both a stack and a stackframe.'});return undefined;}if(stack!==undefined)return this.model_.resolveStackToStackFrame_(event.pid,stack);if(sf===undefined)return undefined;var stackFrame=this.model_.stackFrames['g'+sf];if(stackFrame===undefined){this.model_.importWarning({type:'sample_import_error',message:'No frame for '+sf});return;}return stackFrame;},resolveStackToStackFrame_:function(pid,stack){// TODO(alph,fmeawad): Add codemap resolution code here.
return undefined;},importSampleData:function(){if(!this.sampleEvents_)return;var m=this.model_;// If this is the only importer, then fake-create the threads.
var events=this.sampleEvents_;if(this.events_.length===0){for(var i=0;i<events.length;i++){var event=events[i];m.getOrCreateProcess(event.tid).getOrCreateThread(event.tid);}}var threadsByTid={};m.getAllThreads().forEach(function(t){threadsByTid[t.tid]=t;});for(var i=0;i<events.length;i++){var event=events[i];var thread=threadsByTid[event.tid];if(thread===undefined){m.importWarning({type:'sample_import_error',message:'Thread '+events.tid+'not found'});continue;}var cpu;if(event.cpu!==undefined)cpu=m.kernel.getOrCreateCpu(event.cpu);var stackFrame=this.getStackFrameForEvent_(event);var sample=new tr.model.Sample(cpu,thread,event.name,this.toModelTimeFromUs_(event.ts),stackFrame,event.weight);m.samples.push(sample);}},createAsyncSlices_:function(){if(this.allAsyncEvents_.length===0)return;this.allAsyncEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!==0)return d;return x.sequenceNumber-y.sequenceNumber;});var legacyEvents=[];// Group nestable async events by ID. Events with the same ID should
// belong to the same parent async event.
var nestableAsyncEventsByKey={};var nestableMeasureAsyncEventsByKey={};for(var i=0;i<this.allAsyncEvents_.length;i++){var asyncEventState=this.allAsyncEvents_[i];var event=asyncEventState.event;if(event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){legacyEvents.push(asyncEventState);continue;}if(event.cat===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'cat parameter.'});continue;}if(event.name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'name parameter.'});continue;}if(event.id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require an '+'id parameter.'});continue;}if(event.cat==='blink.user_timing'){var matched=/([^\/:]+):([^\/:]+)\/?(.*)/.exec(event.name);if(matched!==null){var key=matched[1]+':'+event.cat;event.args=JSON.parse(Base64.atob(matched[3])||'{}');if(nestableMeasureAsyncEventsByKey[key]===undefined)nestableMeasureAsyncEventsByKey[key]=[];nestableMeasureAsyncEventsByKey[key].push(asyncEventState);continue;}}var key=event.cat+':'+event.id;if(nestableAsyncEventsByKey[key]===undefined)nestableAsyncEventsByKey[key]=[];nestableAsyncEventsByKey[key].push(asyncEventState);}// Handle legacy async events.
this.createLegacyAsyncSlices_(legacyEvents);// Parse nestable measure async events into AsyncSlices.
this.createNestableAsyncSlices_(nestableMeasureAsyncEventsByKey);// Parse nestable async events into AsyncSlices.
this.createNestableAsyncSlices_(nestableAsyncEventsByKey);},createLegacyAsyncSlices_:function(legacyEvents){if(legacyEvents.length===0)return;legacyEvents.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var asyncEventStatesByNameThenID={};for(var i=0;i<legacyEvents.length;i++){var asyncEventState=legacyEvents[i];var event=asyncEventState.event;var name=event.name;if(name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require a name '+' parameter.'});continue;}var id=event.id;if(id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require an id parameter.'});continue;}// TODO(simonjam): Add a synchronous tick on the appropriate thread.
if(event.ph==='S'){if(asyncEventStatesByNameThenID[name]===undefined)asyncEventStatesByNameThenID[name]={};if(asyncEventStatesByNameThenID[name][id]){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', a slice of the same id '+id+' was alrady open.'});continue;}asyncEventStatesByNameThenID[name][id]=[];asyncEventStatesByNameThenID[name][id].push(asyncEventState);}else{if(asyncEventStatesByNameThenID[name]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' was open.'});continue;}if(asyncEventStatesByNameThenID[name][id]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' with id='+id+' was open.'});continue;}var events=asyncEventStatesByNameThenID[name][id];events.push(asyncEventState);if(event.ph==='F'){// Create a slice from start to end.
var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,name);var slice=new asyncSliceConstructor(events[0].event.cat,name,getEventColor(events[0].event),this.toModelTimeFromUs_(events[0].event.ts),tr.b.concatenateObjects(events[0].event.args,events[events.length-1].event.args),this.toModelTimeFromUs_(event.ts-events[0].event.ts),true,undefined,undefined,events[0].event.argsStripped);slice.startThread=events[0].thread;slice.endThread=asyncEventState.thread;slice.id=id;var stepType=events[1].event.ph;var isValid=true;// Create subSlices for each step. Skip the start and finish events,
// which are always first and last respectively.
for(var j=1;j<events.length-1;++j){if(events[j].event.ph==='T'||events[j].event.ph==='p'){isValid=this.assertStepTypeMatches_(stepType,events[j]);if(!isValid)break;}if(events[j].event.ph==='S'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step before the start event.'});continue;}if(events[j].event.ph==='F'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step after the finish event.'});continue;}var startIndex=j+(stepType==='T'?0:-1);var endIndex=startIndex+1;var subName=events[j].event.name;if(!events[j].event.argsStripped&&(events[j].event.ph==='T'||events[j].event.ph==='p'))subName=subName+':'+events[j].event.args.step;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,subName);var subSlice=new asyncSliceConstructor(events[0].event.cat,subName,getEventColor(event,subName+j),this.toModelTimeFromUs_(events[startIndex].event.ts),this.deepCopyIfNeeded_(events[j].event.args),this.toModelTimeFromUs_(events[endIndex].event.ts-events[startIndex].event.ts),undefined,undefined,events[startIndex].event.argsStripped);subSlice.startThread=events[startIndex].thread;subSlice.endThread=events[endIndex].thread;subSlice.id=id;slice.subSlices.push(subSlice);}if(isValid){// Add |slice| to the start-thread's asyncSlices.
slice.startThread.asyncSliceGroup.push(slice);}delete asyncEventStatesByNameThenID[name][id];}}}},createNestableAsyncSlices_:function(nestableEventsByKey){for(var key in nestableEventsByKey){var eventStateEntries=nestableEventsByKey[key];// Stack of enclosing BEGIN events.
var parentStack=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];// If this is the end of an event, match it to the start.
if(eventStateEntry.event.ph==='e'){// Walk up the parent stack to find the corresponding BEGIN for
// this END.
var parentIndex=-1;for(var k=parentStack.length-1;k>=0;--k){if(parentStack[k].event.name===eventStateEntry.event.name){parentIndex=k;break;}}if(parentIndex===-1){// Unmatched end.
eventStateEntry.finished=false;}else{parentStack[parentIndex].end=eventStateEntry;// Pop off all enclosing unmatched BEGINs util parentIndex.
while(parentIndex<parentStack.length){parentStack.pop();}}}// Inherit the current parent.
if(parentStack.length>0)eventStateEntry.parentEntry=parentStack[parentStack.length-1];if(eventStateEntry.event.ph==='b'){parentStack.push(eventStateEntry);}}var topLevelSlices=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];// Skip matched END, as its slice will be created when we
// encounter its corresponding BEGIN.
if(eventStateEntry.event.ph==='e'&&eventStateEntry.finished===undefined){continue;}var startState=undefined;var endState=undefined;var sliceArgs=eventStateEntry.event.args||{};var sliceError=undefined;if(eventStateEntry.event.ph==='n'){startState=eventStateEntry;endState=eventStateEntry;}else if(eventStateEntry.event.ph==='b'){if(eventStateEntry.end===undefined){// Unmatched BEGIN. End it when last event with this ID ends.
eventStateEntry.end=eventStateEntries[eventStateEntries.length-1];sliceError='Slice has no matching END. End time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async BEGIN event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});}else{// Include args for both END and BEGIN for a matched pair.
function concatenateArguments(args1,args2){if(args1.params===undefined||args2.params===undefined)return tr.b.concatenateObjects(args1,args2);// Make an argument object to hold the combined params.
var args3={};args3.params=tr.b.concatenateObjects(args1.params,args2.params);return tr.b.concatenateObjects(args1,args2,args3);}var endArgs=eventStateEntry.end.event.args||{};sliceArgs=concatenateArguments(sliceArgs,endArgs);}startState=eventStateEntry;endState=eventStateEntry.end;}else{// Unmatched END. Start it at the first event with this ID starts.
sliceError='Slice has no matching BEGIN. Start time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async END event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});startState=eventStateEntries[0];endState=eventStateEntry;}var isTopLevel=eventStateEntry.parentEntry===undefined;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(eventStateEntry.event.cat,eventStateEntry.event.name);var threadStart=undefined;var threadDuration=undefined;if(startState.event.tts&&startState.event.use_async_tts){threadStart=this.toModelTimeFromUs_(startState.event.tts);if(endState.event.tts){var threadEnd=this.toModelTimeFromUs_(endState.event.tts);threadDuration=threadEnd-threadStart;}}var slice=new asyncSliceConstructor(eventStateEntry.event.cat,eventStateEntry.event.name,getEventColor(endState.event),this.toModelTimeFromUs_(startState.event.ts),sliceArgs,this.toModelTimeFromUs_(endState.event.ts-startState.event.ts),isTopLevel,threadStart,threadDuration,startState.event.argsStripped);slice.startThread=startState.thread;slice.endThread=endState.thread;slice.startStackFrame=this.getStackFrameForEvent_(startState.event);slice.endStackFrame=this.getStackFrameForEvent_(endState.event);slice.id=key;if(sliceError!==undefined)slice.error=sliceError;eventStateEntry.slice=slice;// Add the slice to the topLevelSlices array if there is no parent.
// Otherwise, add the slice to the subSlices of its parent.
if(isTopLevel){topLevelSlices.push(slice);}else if(eventStateEntry.parentEntry.slice!==undefined){eventStateEntry.parentEntry.slice.subSlices.push(slice);}}for(var si=0;si<topLevelSlices.length;si++){topLevelSlices[si].startThread.asyncSliceGroup.push(topLevelSlices[si]);}}},assertStepTypeMatches_:function(stepType,event){if(stepType!=event.event.ph){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had both begin and end steps, which is not allowed.'});return false;}return true;},createFlowSlices_:function(){if(this.allFlowEvents_.length===0)return;var that=this;function validateFlowEvent(){if(event.name===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require a name parameter.'});return false;}// Support Flow API v1.
if(event.ph==='s'||event.ph==='f'||event.ph==='t'){if(event.id===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require an id parameter.'});return false;}return true;}// Support Flow API v2.
if(event.bind_id){if(event.flow_in===undefined&&event.flow_out===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow producer or consumer require flow_in or flow_out.'});return false;}return true;}return false;}var createFlowEvent=function(thread,event,opt_slice){var startSlice,flowId,flowStartTs;if(event.bind_id){// Support Flow API v2.
startSlice=opt_slice;flowId=event.bind_id;flowStartTs=this.toModelTimeFromUs_(event.ts+event.dur);}else{// Support Flow API v1.
var ts=this.toModelTimeFromUs_(event.ts);startSlice=thread.sliceGroup.findSliceAtTs(ts);if(startSlice===undefined)return undefined;flowId=event.id;flowStartTs=ts;}var flowEvent=new tr.model.FlowEvent(event.cat,flowId,event.name,getEventColor(event),flowStartTs,that.deepCopyAlways_(event.args));flowEvent.startSlice=startSlice;flowEvent.startStackFrame=that.getStackFrameForEvent_(event);flowEvent.endStackFrame=undefined;startSlice.outFlowEvents.push(flowEvent);return flowEvent;}.bind(this);var finishFlowEventWith=function(flowEvent,thread,event,refGuid,bindToParent,opt_slice){var endSlice;if(event.bind_id){// Support Flow API v2.
endSlice=opt_slice;}else{// Support Flow API v1.
var ts=this.toModelTimeFromUs_(event.ts);if(bindToParent){endSlice=thread.sliceGroup.findSliceAtTs(ts);}else{endSlice=thread.sliceGroup.findNextSliceAfter(ts,refGuid);}if(endSlice===undefined)return false;}endSlice.inFlowEvents.push(flowEvent);flowEvent.endSlice=endSlice;flowEvent.duration=this.toModelTimeFromUs_(event.ts)-flowEvent.start;flowEvent.endStackFrame=that.getStackFrameForEvent_(event);that.mergeArgsInto_(flowEvent.args,event.args,flowEvent.title);return true;}.bind(this);function processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice){var flowEvent=flowIdToEvent[event.bind_id];if(flowEvent===undefined){that.model_.importWarning({type:'flow_slice_ordering_error',message:'Flow consumer '+event.bind_id+' does not have '+'a flow producer'});return false;}else if(flowEvent.endSlice){// One flow producer can have more than one flow consumers.
// In this case, create a new flow event using the flow producer.
var flowProducer=flowEvent.startSlice;flowEvent=createFlowEvent(undefined,sliceGuidToEvent[flowProducer.guid],flowProducer);}var ok=finishFlowEventWith(flowEvent,undefined,event,refGuid,undefined,slice);if(ok){that.model_.flowEvents.push(flowEvent);}else{that.model_.importWarning({type:'flow_slice_end_error',message:'Flow consumer '+event.bind_id+' does not end '+'at an actual slice, so cannot be created.'});return false;}return true;}function processFlowProducer(flowIdToEvent,flowStatus,event,slice){if(flowIdToEvent[event.bind_id]&&flowStatus[event.bind_id]){// Can't open the same flow again while it's still open.
// This is essentially the multi-producer case which we don't support
that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' already seen'});return false;}var flowEvent=createFlowEvent(undefined,event,slice);if(!flowEvent){that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' does not start'+'a flow'});return false;}flowIdToEvent[event.bind_id]=flowEvent;}// Actual import.
this.allFlowEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var flowIdToEvent={};var sliceGuidToEvent={};var flowStatus={};// true: open; false: closed.
for(var i=0;i<this.allFlowEvents_.length;++i){var data=this.allFlowEvents_[i];var refGuid=data.refGuid;var event=data.event;var thread=data.thread;if(!validateFlowEvent(event))continue;// Support for Flow API v2.
if(event.bind_id){var slice=data.slice;sliceGuidToEvent[slice.guid]=event;if(event.flowPhase===PRODUCER){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;// open the flow.
}else{if(!processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice))continue;flowStatus[event.bind_id]=false;// close the flow.
if(event.flowPhase===STEP){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;// open the flow again.
}}continue;}// Support for Flow API v1.
var flowEvent;if(event.ph==='s'){if(flowIdToEvent[event.id]){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' already seen when '+'encountering start of flow event.'});continue;}flowEvent=createFlowEvent(thread,event);if(!flowEvent){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' does not start '+'at an actual slice, so cannot be created.'});continue;}flowIdToEvent[event.id]=flowEvent;}else if(event.ph==='t'||event.ph==='f'){flowEvent=flowIdToEvent[event.id];if(flowEvent===undefined){this.model_.importWarning({type:'flow_slice_ordering_error',message:'Found flow phase '+event.ph+' for id: '+event.id+' but no flow start found.'});continue;}var bindToParent=event.ph==='t';if(event.ph==='f'){if(event.bp===undefined){// TODO(yuhaoz): In flow V2, there is no notion of binding point.
// Removal of binding point is tracked in
// https://github.com/google/trace-viewer/issues/991.
if(event.cat.indexOf('input')>-1)bindToParent=true;else if(event.cat.indexOf('ipc.flow')>-1)bindToParent=true;}else{if(event.bp!=='e'){this.model_.importWarning({type:'flow_slice_bind_point_error',message:'Flow event with invalid binding point (event.bp).'});continue;}bindToParent=true;}}var ok=finishFlowEventWith(flowEvent,thread,event,refGuid,bindToParent);if(ok){that.model_.flowEvents.push(flowEvent);}else{this.model_.importWarning({type:'flow_slice_end_error',message:'event id '+event.id+' does not end '+'at an actual slice, so cannot be created.'});}flowIdToEvent[event.id]=undefined;// If this is a step, then create another flow event.
if(ok&&event.ph==='t'){flowEvent=createFlowEvent(thread,event);flowIdToEvent[event.id]=flowEvent;}}}},/**
     * This function creates objects described via the N, D, and O phase
     * events.
     */createExplicitObjects_:function(){if(this.allObjectEvents_.length===0)return;var processEvent=function(objectEventState){var event=objectEventState.event;var scopedId=this.scopedIdForEvent_(event);var thread=objectEventState.thread;if(event.name===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an name parameter.'});}if(scopedId.id===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an id parameter.'});}var process=thread.parent;var ts=this.toModelTimeFromUs_(event.ts);var instance;if(event.ph==='N'){try{instance=process.objects.idWasCreated(scopedId,event.cat,event.name,ts);}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing create of '+scopedId+' at ts='+ts+': '+e});return;}}else if(event.ph==='O'){if(event.args.snapshot===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+scopedId+' at ts='+ts+': '+'Snapshots must have args: {snapshot: ...}'});return;}var snapshot;try{var args=this.deepCopyIfNeeded_(event.args.snapshot);var cat;if(args.cat){cat=args.cat;delete args.cat;}else{cat=event.cat;}var baseTypename;if(args.base_type){baseTypename=args.base_type;delete args.base_type;}else{baseTypename=undefined;}snapshot=process.objects.addSnapshot(scopedId,cat,event.name,ts,args,baseTypename);snapshot.snapshottedOnThread=thread;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing snapshot of '+scopedId+' at ts='+ts+': '+e});return;}instance=snapshot.objectInstance;}else if(event.ph==='D'){try{process.objects.idWasDeleted(scopedId,event.cat,event.name,ts);var instanceMap=process.objects.getOrCreateInstanceMap_(scopedId);instance=instanceMap.lastInstance;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing delete of '+scopedId+' at ts='+ts+': '+e});return;}}if(instance)instance.colorId=getEventColor(event,instance.typeName);}.bind(this);this.allObjectEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var allObjectEvents=this.allObjectEvents_;for(var i=0;i<allObjectEvents.length;i++){var objectEventState=allObjectEvents[i];try{processEvent.call(this,objectEventState);}catch(e){this.model_.importWarning({type:'object_parse_error',message:e.message});}}},createImplicitObjects_:function(){tr.b.iterItems(this.model_.processes,function(pid,process){this.createImplicitObjectsForProcess_(process);},this);},// Here, we collect all the snapshots that internally contain a
// Javascript-level object inside their args list that has an "id" field,
// and turn that into a snapshot of the instance referred to by id.
createImplicitObjectsForProcess_:function(process){function processField(referencingObject,referencingObjectFieldName,referencingObjectFieldValue,containingSnapshot){if(!referencingObjectFieldValue)return;if(referencingObjectFieldValue instanceof tr.model.ObjectSnapshot)return null;if(referencingObjectFieldValue.id===undefined)return;var implicitSnapshot=referencingObjectFieldValue;var rawId=implicitSnapshot.id;var m=/(.+)\/(.+)/.exec(rawId);if(!m)throw new Error('Implicit snapshots must have names.');delete implicitSnapshot.id;var name=m[1];var id=m[2];var res;var cat;if(implicitSnapshot.cat!==undefined)cat=implicitSnapshot.cat;else cat=containingSnapshot.objectInstance.category;var baseTypename;if(implicitSnapshot.base_type)baseTypename=implicitSnapshot.base_type;else baseTypename=undefined;var scope=containingSnapshot.objectInstance.scopedId.scope;try{res=process.objects.addSnapshot(new tr.model.ScopedId(scope,id),cat,name,containingSnapshot.ts,implicitSnapshot,baseTypename);}catch(e){this.model_.importWarning({type:'object_snapshot_parse_error',message:'While processing implicit snapshot of '+rawId+' at ts='+containingSnapshot.ts+': '+e});return;}res.objectInstance.hasImplicitSnapshots=true;res.containingSnapshot=containingSnapshot;res.snapshottedOnThread=containingSnapshot.snapshottedOnThread;referencingObject[referencingObjectFieldName]=res;if(!(res instanceof tr.model.ObjectSnapshot))throw new Error('Created object must be instanceof snapshot');return res.args;}/**
       * Iterates over the fields in the object, calling func for every
       * field/value found.
       *
       * @return {object} If the function does not want the field's value to be
       * iterated, return null. If iteration of the field value is desired, then
       * return either undefined (if the field value did not change) or the new
       * field value if it was changed.
       */function iterObject(object,func,containingSnapshot,thisArg){if(!(object instanceof Object))return;if(object instanceof Array){for(var i=0;i<object.length;i++){var res=func.call(thisArg,object,i,object[i],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[i],func,containingSnapshot,thisArg);}return;}for(var key in object){var res=func.call(thisArg,object,key,object[key],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[key],func,containingSnapshot,thisArg);}}// TODO(nduca): We may need to iterate the instances in sorted order by
// creationTs.
process.objects.iterObjectInstances(function(instance){instance.snapshots.forEach(function(snapshot){if(snapshot.args.id!==undefined)throw new Error('args cannot have an id field inside it');iterObject(snapshot.args,processField,snapshot,this);},this);},this);},createMemoryDumps_:function(){for(var dumpId in this.allMemoryDumpEvents_)this.createGlobalMemoryDump_(this.allMemoryDumpEvents_[dumpId],dumpId);},createGlobalMemoryDump_:function(dumpIdEvents,dumpId){// 1. Create a GlobalMemoryDump for the provided process memory dump
// the events, all of which have the same dump ID.
// Calculate the range of the global memory dump.
var globalRange=new tr.b.Range();for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++)globalRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));}if(globalRange.isEmpty)throw new Error('Internal error: Global memory dump without events');// Create the global memory dump.
var globalMemoryDump=new tr.model.GlobalMemoryDump(this.model_,globalRange.min);globalMemoryDump.duration=globalRange.range;this.model_.globalMemoryDumps.push(globalMemoryDump);var globalMemoryAllocatorDumpsByFullName={};var levelsOfDetail={};var allMemoryAllocatorDumpsByGuid={};// 2. Create a ProcessMemoryDump for each PID in the provided process
// memory dump events. Everything except for edges between memory
// allocator dumps is parsed from the process memory dump trace events at
// this step.
for(var pid in dumpIdEvents){this.createProcessMemoryDump_(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,dumpIdEvents[pid],pid,dumpId);}// 3. Set the level of detail and memory allocator dumps of the
// GlobalMemoryDump, which come from the process memory dump trace
// events parsed in the prebvious step.
globalMemoryDump.levelOfDetail=levelsOfDetail.global;// Find the root allocator dumps and establish the parent links of
// the global memory dump.
globalMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(globalMemoryAllocatorDumpsByFullName);// 4. Finally, parse the edges between all memory allocator dumps within
// the GlobalMemoryDump. This can only be done once all memory allocator
// dumps have been parsed (i.e. it is necessary to iterate over the
// process memory dump trace events once more).
this.parseMemoryDumpAllocatorEdges_(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId);},createProcessMemoryDump_:function(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,processEvents,pid,dumpId){// Calculate the range of the process memory dump.
var processRange=new tr.b.Range();for(var i=0;i<processEvents.length;i++)processRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));if(processRange.isEmpty)throw new Error('Internal error: Process memory dump without events');// Create the process memory dump.
var process=this.model_.getOrCreateProcess(pid);var processMemoryDump=new tr.model.ProcessMemoryDump(globalMemoryDump,process,processRange.min);processMemoryDump.duration=processRange.range;process.memoryDumps.push(processMemoryDump);globalMemoryDump.processMemoryDumps[pid]=processMemoryDump;var processMemoryAllocatorDumpsByFullName={};// Parse all process memory dump trace events for the newly created
// ProcessMemoryDump.
for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'\'dumps\' field not found in a process memory dump'+' event for PID='+pid+' and dump ID='+dumpId+'.'});continue;}// Totals, VM regions, and heap dumps for the newly created
// ProcessMemoryDump should be present in at most one event, so they
// can be added to the ProcessMemoryDump immediately.
this.parseMemoryDumpTotals_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpVmRegions_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpHeapDumps_(processMemoryDump,dumps,pid,dumpId);// All process memory dump trace events for the newly created
// ProcessMemoryDump must be processed before level of detail and
// allocator dumps can be added to it.
this.parseMemoryDumpLevelOfDetail_(levelsOfDetail,dumps,pid,dumpId);this.parseMemoryDumpAllocatorDumps_(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId);}if(levelsOfDetail.process===undefined){// Infer level of detail from the presence of VM regions in legacy
// traces (where raw process memory dump events don't contain the
// level_of_detail field). These traces will not have BACKGROUND mode.
levelsOfDetail.process=processMemoryDump.vmRegions?DETAILED:LIGHT;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'global',levelsOfDetail.process)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for global memory'+' dump (dump ID='+dumpId+').'});}processMemoryDump.levelOfDetail=levelsOfDetail.process;delete levelsOfDetail.process;// Reused for all process dumps.
// Find the root allocator dumps and establish the parent links of
// the process memory dump.
processMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(processMemoryAllocatorDumpsByFullName);},parseMemoryDumpTotals_:function(processMemoryDump,dumps,pid,dumpId){var rawTotals=dumps.process_totals;if(rawTotals===undefined)return;if(processMemoryDump.totals!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Process totals provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var totals={};var platformSpecificTotals=undefined;for(var rawTotalName in rawTotals){var rawTotalValue=rawTotals[rawTotalName];if(rawTotalValue===undefined)continue;// Total resident bytes.
if(rawTotalName==='resident_set_bytes'){totals.residentBytes=parseInt(rawTotalValue,16);continue;}// Peak resident bytes.
if(rawTotalName==='peak_resident_set_bytes'){totals.peakResidentBytes=parseInt(rawTotalValue,16);continue;}if(rawTotalName==='is_peak_rss_resetable'){totals.arePeakResidentBytesResettable=!!rawTotalValue;continue;}// OS-specific totals (e.g. private resident on Mac).
if(platformSpecificTotals===undefined){platformSpecificTotals={};totals.platformSpecific=platformSpecificTotals;}platformSpecificTotals[rawTotalName]=parseInt(rawTotalValue,16);}// Either both peak_resident_set_bytes and is_peak_rss_resetable should
// be present in the trace, or neither.
if(totals.peakResidentBytes===undefined&&totals.arePeakResidentBytesResettable!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field peak_resident_set_bytes found'+' but is_peak_rss_resetable not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}if(totals.arePeakResidentBytesResettable!==undefined&&totals.peakResidentBytes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field is_peak_rss_resetable found'+' but peak_resident_set_bytes not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}processMemoryDump.totals=totals;},parseMemoryDumpVmRegions_:function(processMemoryDump,dumps,pid,dumpId){var rawProcessMmaps=dumps.process_mmaps;if(rawProcessMmaps===undefined)return;var rawVmRegions=rawProcessMmaps.vm_regions;if(rawVmRegions===undefined)return;if(processMemoryDump.vmRegions!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'VM regions provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}// See //base/trace_event/process_memory_maps.cc in Chromium.
var vmRegions=new Array(rawVmRegions.length);for(var i=0;i<rawVmRegions.length;i++){var rawVmRegion=rawVmRegions[i];var byteStats={};var rawByteStats=rawVmRegion.bs;for(var rawByteStatName in rawByteStats){var rawByteStatValue=rawByteStats[rawByteStatName];if(rawByteStatValue===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Byte stat \''+rawByteStatName+'\' of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for '+'PID='+pid+' and dump ID='+dumpId+' does not have a value.'});continue;}var byteStatName=BYTE_STAT_NAME_MAP[rawByteStatName];if(byteStatName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown byte stat name \''+rawByteStatName+'\' ('+rawByteStatValue+') of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}byteStats[byteStatName]=parseInt(rawByteStatValue,16);}vmRegions[i]=new tr.model.VMRegion(parseInt(rawVmRegion.sa,16),// startAddress
parseInt(rawVmRegion.sz,16),// sizeInBytes
rawVmRegion.pf,// protectionFlags
rawVmRegion.mf,// mappedFile
byteStats);}processMemoryDump.vmRegions=tr.model.VMRegionClassificationNode.fromRegions(vmRegions);},parseMemoryDumpHeapDumps_:function(processMemoryDump,dumps,pid,dumpId){var rawHeapDumps=dumps.heaps;if(rawHeapDumps===undefined)return;if(processMemoryDump.heapDumps!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Heap dumps provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var model=this.model_;var idPrefix='p'+pid+':';var heapDumps={};var objectTypeNameMap=this.objectTypeNameMap_[pid];if(objectTypeNameMap===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing mapping from object type IDs to names.'});}for(var allocatorName in rawHeapDumps){var entries=rawHeapDumps[allocatorName].entries;if(entries===undefined||entries.length===0){this.model_.importWarning({type:'memory_dump_parse_error',message:'No heap entries in a '+allocatorName+' heap dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}// The old format always starts with a {size: <total>} entry.
// See https://goo.gl/WYStil
// TODO(petrcermak): Remove support for the old format once the new
// format has been around long enough.
var isOldFormat=entries[0].bt===undefined;if(!isOldFormat&&objectTypeNameMap===undefined){// Mapping from object type IDs to names must be provided in the new
// format.
continue;}var heapDump=new tr.model.HeapDump(processMemoryDump,allocatorName);for(var i=0;i<entries.length;i++){var entry=entries[i];var leafStackFrameIndex=entry.bt;var leafStackFrame;// There are two possible mappings from leaf stack frame indices
// (provided in the trace) to the corresponding stack frames
// depending on the format.
if(isOldFormat){// Old format:
//   Undefined index        -> / (root)
//   Defined index for /A/B -> /A/B/<self>
if(leafStackFrameIndex===undefined){leafStackFrame=undefined/* root */;}else{// Get the leaf stack frame corresponding to the provided index.
var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined/* root */;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}// Inject an artificial <self> leaf stack frame.
leafStackFrameId+=':self';if(model.stackFrames[leafStackFrameId]!==undefined){// The frame might already exist if there are multiple process
// memory dumps (for the same process) in the trace.
leafStackFrame=model.stackFrames[leafStackFrameId];}else{leafStackFrame=new tr.model.StackFrame(leafStackFrame,leafStackFrameId,'<self>',undefined/* colorId */);model.addStackFrame(leafStackFrame);}}}else{// New format:
//   Undefined index        -> (invalid value)
//   Defined index for /A/B -> /A/B
if(leafStackFrameIndex===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing stack frame ID of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}// Get the leaf stack frame corresponding to the provided index.
var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined/* root */;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}}var objectTypeId=entry.type;var objectTypeName;if(objectTypeId===undefined){objectTypeName=undefined/* total over all types */;}else if(objectTypeNameMap===undefined){// This can only happen when the old format is used.
continue;}else{objectTypeName=objectTypeNameMap[objectTypeId];if(objectTypeName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing object type name (ID '+objectTypeId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for pid='+pid+'.'});continue;}}var size=parseInt(entry.size,16);var count=entry.count===undefined?undefined:parseInt(entry.count,16);heapDump.addEntry(leafStackFrame,objectTypeName,size,count);}// Throw away heap dumps with no entries. This can happen if all raw
// entries in the trace are skipped for some reason (e.g. invalid leaf
// stack frame ID).
if(heapDump.entries.length>0)heapDumps[allocatorName]=heapDump;}if(Object.keys(heapDumps).length>0)processMemoryDump.heapDumps=heapDumps;},parseMemoryDumpLevelOfDetail_:function(levelsOfDetail,dumps,pid,dumpId){var rawLevelOfDetail=dumps.level_of_detail;var level;switch(rawLevelOfDetail){case'background':level=BACKGROUND;break;case'light':level=LIGHT;break;case'detailed':level=DETAILED;break;case undefined:level=undefined;break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'unknown raw level of detail \''+rawLevelOfDetail+'\' of process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'process',level)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for process memory'+' dump for PID='+pid+' (dump ID='+dumpId+').'});}},updateMemoryDumpLevelOfDetail_:function(levelsOfDetail,scope,level){// If all process memory dump events have the same level of detail (for
// the particular 'process' or 'global' scope), return true.
if(!(scope in levelsOfDetail)||level===levelsOfDetail[scope]){levelsOfDetail[scope]=level;return true;}// If the process memory dump events have different levels of detail (for
// the particular 'process' or 'global' scope), use the highest level and
// return false.
if(MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(level)>MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(levelsOfDetail[scope])){levelsOfDetail[scope]=level;}return false;},parseMemoryDumpAllocatorDumps_:function(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId){var rawAllocatorDumps=dumps.allocators;if(rawAllocatorDumps===undefined)return;// Construct the MemoryAllocatorDump objects without parent links
// and add them to the processMemoryAllocatorDumpsByName and
// globalMemoryAllocatorDumpsByName indices appropriately.
for(var fullName in rawAllocatorDumps){var rawAllocatorDump=rawAllocatorDumps[fullName];// Every memory allocator dump should have a GUID. If not, then
// it cannot be associated with any edges.
var guid=rawAllocatorDump.guid;if(guid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' for PID='+pid+' and dump ID='+dumpId+' does not have a GUID.'});}// A memory allocator dump can have optional flags.
var flags=rawAllocatorDump.flags||0;var isWeakDump=!!(flags&WEAK_MEMORY_ALLOCATOR_DUMP_FLAG);// Determine if this is a global memory allocator dump (check if
// it's prefixed with 'global/').
var containerMemoryDump;var dstIndex;if(fullName.startsWith(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX)){// Global memory allocator dump.
fullName=fullName.substring(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX.length);containerMemoryDump=globalMemoryDump;dstIndex=globalMemoryAllocatorDumpsByFullName;}else{// Process memory allocator dump.
containerMemoryDump=processMemoryDump;dstIndex=processMemoryAllocatorDumpsByFullName;}// Construct or retrieve a memory allocator dump with the provided
// GUID.
var allocatorDump=allMemoryAllocatorDumpsByGuid[guid];if(allocatorDump===undefined){if(fullName in dstIndex){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple GUIDs provided for'+' memory allocator dump '+fullName+': '+dstIndex[fullName].guid+', '+guid+' (ignored) for'+' PID='+pid+' and dump ID='+dumpId+'.'});continue;}allocatorDump=new tr.model.MemoryAllocatorDump(containerMemoryDump,fullName,guid);allocatorDump.weak=isWeakDump;dstIndex[fullName]=allocatorDump;if(guid!==undefined)allMemoryAllocatorDumpsByGuid[guid]=allocatorDump;}else{// A memory allocator dump with this GUID has already been
// dumped (so we will only add new attributes). Check that it
// belonged to the same process or was also global.
if(allocatorDump.containerMemoryDump!==containerMemoryDump){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' dumped in different contexts.'});continue;}// Check that the names of the memory allocator dumps match.
if(allocatorDump.fullName!==fullName){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump with GUID='+guid+' for PID='+pid+' and dump ID='+dumpId+' has multiple names: '+allocatorDump.fullName+', '+fullName+' (ignored).'});continue;}if(!isWeakDump){// A MemoryAllocatorDump is non-weak if at least one process dumped
// it without WEAK_MEMORY_ALLOCATOR_DUMP_FLAG.
allocatorDump.weak=false;}}// Add all new attributes to the memory allocator dump.
var attributes=rawAllocatorDump.attrs;if(attributes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' does not have attributes.'});attributes={};}for(var attrName in attributes){var attrArgs=attributes[attrName];var attrType=attrArgs.type;var attrValue=attrArgs.value;switch(attrType){case'scalar':if(attrName in allocatorDump.numerics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for scalar attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}var unit=attrArgs.units==='bytes'?tr.b.Unit.byName.sizeInBytes_smallerIsBetter:tr.b.Unit.byName.unitlessNumber_smallerIsBetter;var value=parseInt(attrValue,16);allocatorDump.addNumeric(attrName,new tr.v.ScalarNumeric(unit,value));break;case'string':if(attrName in allocatorDump.diagnostics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for string attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}allocatorDump.addDiagnostic(attrName,attrValue);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown type provided for attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+': '+attrType});break;}}}},inferMemoryAllocatorDumpTree_:function(memoryAllocatorDumpsByFullName){var rootAllocatorDumps=[];var fullNames=Object.keys(memoryAllocatorDumpsByFullName);fullNames.sort();for(var i=0;i<fullNames.length;i++){var fullName=fullNames[i];var allocatorDump=memoryAllocatorDumpsByFullName[fullName];// This is a loop because we might need to build implicit
// ancestors in case they were not present in the trace.
while(true){var lastSlashIndex=fullName.lastIndexOf('/');if(lastSlashIndex===-1){// If the dump is a root, add it to the top-level
// rootAllocatorDumps list.
rootAllocatorDumps.push(allocatorDump);break;}// If the dump is not a root, find its parent.
var parentFullName=fullName.substring(0,lastSlashIndex);var parentAllocatorDump=memoryAllocatorDumpsByFullName[parentFullName];// If the parent dump does not exist yet, we build an implicit
// one and continue up the ancestor chain.
var parentAlreadyExisted=true;if(parentAllocatorDump===undefined){parentAlreadyExisted=false;parentAllocatorDump=new tr.model.MemoryAllocatorDump(allocatorDump.containerMemoryDump,parentFullName);if(allocatorDump.weak!==false){// If we are inferring a parent dump (e.g. 'root/parent') of a
// current dump (e.g. 'root/parent/current') which is weak (or
// was also inferred and we don't know yet whether it's weak or
// not), then we clear the weak flag on the parent dump because
// we don't know yet whether it should be weak or non-weak:
//
//   * We can't mark the parent as non-weak straightaway because
//     the parent might have no non-weak descendants (in which
//     case we want the inferred parent to be weak, so that it
//     would be later removed like the current dump).
//   * We can't mark the parent as weak immediately either. If we
//     did and later encounter a non-weak child of the parent
//     (e.g. 'root/parent/another_child'), then we couldn't
//     retroactively mark the inferred parent dump as non-weak
//     because we couldn't tell whether the parent dump was
//     dumped in the trace as weak (in which case it should stay
//     weak and be subsequently removed) or whether it was
//     inferred as weak (in which case it should be changed to
//     non-weak).
//
// Therefore, we defer marking the inferred parent as
// weak/non-weak. If an inferred parent dump does not have any
// non-weak child, it will be marked as weak at the end of this
// method.
//
// Note that this should not be confused with the recursive
// propagation of the weak flag from parent dumps to their
// children and from owned dumps to their owners, which is
// performed in GlobalMemoryDump.prototype.removeWeakDumps().
parentAllocatorDump.weak=undefined;}memoryAllocatorDumpsByFullName[parentFullName]=parentAllocatorDump;}// Setup the parent <-> children relationships
allocatorDump.parent=parentAllocatorDump;parentAllocatorDump.children.push(allocatorDump);// If the parent already existed, then its ancestors were/will be
// constructed in another iteration of the forEach loop.
if(parentAlreadyExisted){if(!allocatorDump.weak){// If the current dump is non-weak, then we must ensure that all
// its inferred ancestors are also non-weak.
while(parentAllocatorDump!==undefined&&parentAllocatorDump.weak===undefined){parentAllocatorDump.weak=false;parentAllocatorDump=parentAllocatorDump.parent;}}break;}fullName=parentFullName;allocatorDump=parentAllocatorDump;}}// All inferred ancestor dumps that have a non-weak child have already
// been marked as non-weak. We now mark the rest as weak.
for(var fullName in memoryAllocatorDumpsByFullName){var allocatorDump=memoryAllocatorDumpsByFullName[fullName];if(allocatorDump.weak===undefined)allocatorDump.weak=true;}return rootAllocatorDumps;},parseMemoryDumpAllocatorEdges_:function(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId){for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined)continue;var rawEdges=dumps.allocators_graph;if(rawEdges===undefined)continue;for(var j=0;j<rawEdges.length;j++){var rawEdge=rawEdges[j];var sourceGuid=rawEdge.source;var sourceDump=allMemoryAllocatorDumpsByGuid[sourceGuid];if(sourceDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing source memory allocator dump (GUID='+sourceGuid+').'});continue;}var targetGuid=rawEdge.target;var targetDump=allMemoryAllocatorDumpsByGuid[targetGuid];if(targetDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing target memory allocator dump (GUID='+targetGuid+').'});continue;}var importance=rawEdge.importance;var edge=new tr.model.MemoryAllocatorDumpLink(sourceDump,targetDump,importance);switch(rawEdge.type){case'ownership':if(sourceDump.owns!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+sourceDump.fullName+' (GUID='+sourceGuid+') already owns a memory'+' allocator dump ('+sourceDump.owns.target.fullName+').'});}else{sourceDump.owns=edge;targetDump.ownedBy.push(edge);}break;case'retention':sourceDump.retains.push(edge);targetDump.retainedBy.push(edge);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Invalid edge type: '+rawEdge.type+' (PID='+pid+', dump ID='+dumpId+', source='+sourceGuid+', target='+targetGuid+', importance='+importance+').'});}}}}},/**
     * Converts |ts| (in microseconds) to a timestamp in the model clock domain
     * (in milliseconds).
     */toModelTimeFromUs_:function(ts){if(!this.toModelTime_){this.toModelTime_=this.model_.clockSyncManager.getModelTimeTransformer(this.clockDomainId_);}return this.toModelTime_(tr.b.Unit.timestampFromUs(ts));},/**
     * Converts |ts| (in microseconds) to a timestamp in the model clock domain
     * (in milliseconds). If |ts| is undefined, undefined is returned.
     */maybeToModelTimeFromUs_:function(ts){if(ts===undefined)return undefined;return this.toModelTimeFromUs_(ts);}};tr.importer.Importer.register(TraceEventImporter);return{TraceEventImporter:TraceEventImporter};});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/base64.js":29,"../../base/color_scheme.js":32,"../../base/range.js":47,"../../base/unit.js":57,"../../base/utils.js":59,"../../importer/context_processor.js":70,"../../importer/importer.js":76,"../../model/comment_box_annotation.js":106,"../../model/constants.js":108,"../../model/container_memory_dump.js":109,"../../model/counter_series.js":112,"../../model/flow_event.js":121,"../../model/global_memory_dump.js":123,"../../model/heap_dump.js":124,"../../model/instant_event.js":130,"../../model/memory_allocator_dump.js":134,"../../model/model.js":135,"../../model/process_memory_dump.js":145,"../../model/rect_annotation.js":146,"../../model/scoped_id.js":148,"../../model/slice_group.js":152,"../../model/vm_region.js":168,"../../model/x_marker_annotation.js":169,"../../value/numeric.js":190,"./trace_code_entry.js":64,"./trace_code_map.js":65,"./v8/codemap.js":67}],67:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2012 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./splaytree.js");

'use strict';

/**
 * @fileoverview Map addresses to dynamically created functions.
 */
global.tr.exportTo('tr.e.importer.v8', function () {
  /**
   * Constructs a mapper that maps addresses into code entries.
   *
   * @constructor
   */
  function CodeMap() {
    /**
     * Dynamic code entries. Used for JIT compiled code.
     */
    this.dynamics_ = new tr.e.importer.v8.SplayTree();

    /**
     * Name generator for entries having duplicate names.
     */
    this.dynamicsNameGen_ = new tr.e.importer.v8.CodeMap.NameGenerator();

    /**
     * Static code entries. Used for statically compiled code.
     */
    this.statics_ = new tr.e.importer.v8.SplayTree();

    /**
     * Libraries entries. Used for the whole static code libraries.
     */
    this.libraries_ = new tr.e.importer.v8.SplayTree();

    /**
     * Map of memory pages occupied with static code.
     */
    this.pages_ = [];
  }

  /**
   * The number of alignment bits in a page address.
   */
  CodeMap.PAGE_ALIGNMENT = 12;

  /**
   * Page size in bytes.
   */
  CodeMap.PAGE_SIZE = 1 << CodeMap.PAGE_ALIGNMENT;

  /**
   * Adds a dynamic (i.e. moveable and discardable) code entry.
   *
   * @param {number} start The starting address.
   * @param {CodeMap.CodeEntry} codeEntry Code entry object.
   */
  CodeMap.prototype.addCode = function (start, codeEntry) {
    this.deleteAllCoveredNodes_(this.dynamics_, start, start + codeEntry.size);
    this.dynamics_.insert(start, codeEntry);
  };

  /**
   * Moves a dynamic code entry. Throws an exception if there is no dynamic
   * code entry with the specified starting address.
   *
   * @param {number} from The starting address of the entry being moved.
   * @param {number} to The destination address.
   */
  CodeMap.prototype.moveCode = function (from, to) {
    var removedNode = this.dynamics_.remove(from);
    this.deleteAllCoveredNodes_(this.dynamics_, to, to + removedNode.value.size);
    this.dynamics_.insert(to, removedNode.value);
  };

  /**
   * Discards a dynamic code entry. Throws an exception if there is no dynamic
   * code entry with the specified starting address.
   *
   * @param {number} start The starting address of the entry being deleted.
   */
  CodeMap.prototype.deleteCode = function (start) {
    var removedNode = this.dynamics_.remove(start);
  };

  /**
   * Adds a library entry.
   *
   * @param {number} start The starting address.
   * @param {CodeMap.CodeEntry} codeEntry Code entry object.
   */
  CodeMap.prototype.addLibrary = function (start, codeEntry) {
    this.markPages_(start, start + codeEntry.size);
    this.libraries_.insert(start, codeEntry);
  };

  /**
   * Adds a static code entry.
   *
   * @param {number} start The starting address.
   * @param {CodeMap.CodeEntry} codeEntry Code entry object.
   */
  CodeMap.prototype.addStaticCode = function (start, codeEntry) {
    this.statics_.insert(start, codeEntry);
  };

  /**
   * @private
   */
  CodeMap.prototype.markPages_ = function (start, end) {
    for (var addr = start; addr <= end; addr += CodeMap.PAGE_SIZE) {
      this.pages_[addr >>> CodeMap.PAGE_ALIGNMENT] = 1;
    }
  };

  /**
   * @private
   */
  CodeMap.prototype.deleteAllCoveredNodes_ = function (tree, start, end) {
    var toDelete = [];
    var addr = end - 1;
    while (addr >= start) {
      var node = tree.findGreatestLessThan(addr);
      if (!node) break;
      var start2 = node.key,
          end2 = start2 + node.value.size;
      if (start2 < end && start < end2) toDelete.push(start2);
      addr = start2 - 1;
    }
    for (var i = 0, l = toDelete.length; i < l; ++i) tree.remove(toDelete[i]);
  };

  /**
   * @private
   */
  CodeMap.prototype.isAddressBelongsTo_ = function (addr, node) {
    return addr >= node.key && addr < node.key + node.value.size;
  };

  /**
   * @private
   */
  CodeMap.prototype.findInTree_ = function (tree, addr) {
    var node = tree.findGreatestLessThan(addr);
    return node && this.isAddressBelongsTo_(addr, node) ? node.value : null;
  };

  /**
   * Finds a code entry that contains the specified address in static libraries.
   *
   * @param {number} addr Address.
   */
  CodeMap.prototype.findEntryInLibraries = function (addr) {
    var pageAddr = addr >>> CodeMap.PAGE_ALIGNMENT;
    if (pageAddr in this.pages_) return this.findInTree_(this.libraries_, addr);
    return undefined;
  };

  /**
   * Finds a code entry that contains the specified address. Both static and
   * dynamic code entries are considered.
   *
   * @param {number} addr Address.
   */
  CodeMap.prototype.findEntry = function (addr) {
    var pageAddr = addr >>> CodeMap.PAGE_ALIGNMENT;
    if (pageAddr in this.pages_) {
      // Static code entries can contain "holes" of unnamed code.
      // In this case, the whole library is assigned to this address.
      return this.findInTree_(this.statics_, addr) || this.findInTree_(this.libraries_, addr);
    }
    var min = this.dynamics_.findMin();
    var max = this.dynamics_.findMax();
    if (max != null && addr < max.key + max.value.size && addr >= min.key) {
      var dynaEntry = this.findInTree_(this.dynamics_, addr);
      if (dynaEntry == null) return null;
      // Dedupe entry name.
      if (!dynaEntry.nameUpdated_) {
        dynaEntry.name = this.dynamicsNameGen_.getName(dynaEntry.name);
        dynaEntry.nameUpdated_ = true;
      }
      return dynaEntry;
    }
    return null;
  };

  /**
   * Returns a dynamic code entry using its starting address.
   *
   * @param {number} addr Address.
   */
  CodeMap.prototype.findDynamicEntryByStartAddress = function (addr) {
    var node = this.dynamics_.find(addr);
    return node ? node.value : null;
  };

  /**
   * Returns an array of all dynamic code entries.
   */
  CodeMap.prototype.getAllDynamicEntries = function () {
    return this.dynamics_.exportValues();
  };

  /**
   * Returns an array of pairs of all dynamic code entries and their addresses.
   */
  CodeMap.prototype.getAllDynamicEntriesWithAddresses = function () {
    return this.dynamics_.exportKeysAndValues();
  };

  /**
   * Returns an array of all static code entries.
   */
  CodeMap.prototype.getAllStaticEntries = function () {
    return this.statics_.exportValues();
  };

  /**
   * Returns an array of all libraries entries.
   */
  CodeMap.prototype.getAllLibrariesEntries = function () {
    return this.libraries_.exportValues();
  };

  /**
   * Enum for code state regarding its dynamic optimization.
   *
   * @enum {number}
   */
  CodeMap.CodeState = {
    COMPILED: 0,
    OPTIMIZABLE: 1,
    OPTIMIZED: 2
  };

  /**
   * Creates a code entry object.
   *
   * @param {number} size Code entry size in bytes.
   * @param {string=} opt_name Code entry name.
   * @constructor
   */
  CodeMap.CodeEntry = function (size, opt_name, opt_type) {
    this.id = tr.b.GUID.allocateSimple();
    this.size = size;
    this.name_ = opt_name || '';
    this.type = opt_type || '';
    this.nameUpdated_ = false;
  };

  CodeMap.CodeEntry.prototype = {
    __proto__: Object.prototype,

    get name() {
      return this.name_;
    },

    set name(value) {
      this.name_ = value;
    },

    toString: function () {
      this.name_ + ': ' + this.size.toString(16);
    }
  };

  CodeMap.CodeEntry.TYPE = {
    SHARED_LIB: 'SHARED_LIB',
    CPP: 'CPP'
  };

  /**
   * Creates a dynamic code entry.
   *
   * @param {number} size Code size.
   * @param {string} type Code type.
   * @param {CodeMap.FunctionEntry} func Shared function entry.
   * @param {CodeMap.CodeState} state Code optimization state.
   * @constructor
   */
  CodeMap.DynamicFuncCodeEntry = function (size, type, func, state) {
    CodeMap.CodeEntry.call(this, size, '', type);
    this.func = func;
    this.state = state;
  };

  CodeMap.DynamicFuncCodeEntry.STATE_PREFIX = ['', '~', '*'];

  CodeMap.DynamicFuncCodeEntry.prototype = {
    __proto__: CodeMap.CodeEntry.prototype,

    /**
     * Returns node name.
     */
    get name() {
      return CodeMap.DynamicFuncCodeEntry.STATE_PREFIX[this.state] + this.func.name;
    },

    set name(value) {
      this.name_ = value;
    },

    /**
     * Returns raw node name (without type decoration).
     */
    getRawName: function () {
      return this.func.getName();
    },

    isJSFunction: function () {
      return true;
    },

    toString: function () {
      return this.type + ': ' + this.name + ': ' + this.size.toString(16);
    }
  };

  /**
   * Creates a shared function object entry.
   *
   * @param {string} name Function name.
   * @constructor
   */
  CodeMap.FunctionEntry = function (name) {
    CodeMap.CodeEntry.call(this, 0, name);
  };

  CodeMap.FunctionEntry.prototype = {
    __proto__: CodeMap.CodeEntry.prototype,

    /**
     * Returns node name.
     */
    get name() {
      var name = this.name_;
      if (name.length == 0) {
        name = '<anonymous>';
      } else if (name.charAt(0) == ' ') {
        // An anonymous function with location: " aaa.js:10".
        name = '<anonymous>' + name;
      }
      return name;
    },

    set name(value) {
      this.name_ = value;
    }
  };

  CodeMap.NameGenerator = function () {
    this.knownNames_ = {};
  };

  CodeMap.NameGenerator.prototype.getName = function (name) {
    if (!(name in this.knownNames_)) {
      this.knownNames_[name] = 0;
      return name;
    }
    var count = ++this.knownNames_[name];
    return name + ' {' + count + '}';
  };
  return {
    CodeMap: CodeMap
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./splaytree.js":68}],68:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2012 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../../base/base.js");

'use strict';

/**
 * @fileoverview Splay tree used by CodeMap.
 */
global.tr.exportTo('tr.e.importer.v8', function () {
  /**
   * Constructs a Splay tree.  A splay tree is a self-balancing binary
   * search tree with the additional property that recently accessed
   * elements are quick to access again. It performs basic operations
   * such as insertion, look-up and removal in O(log(n)) amortized time.
   *
   * @constructor
   */
  function SplayTree() {};

  /**
   * Pointer to the root node of the tree.
   *
   * @type {SplayTree.Node}
   * @private
   */
  SplayTree.prototype.root_ = null;

  /**
   * @return {boolean} Whether the tree is empty.
   */
  SplayTree.prototype.isEmpty = function () {
    return !this.root_;
  };

  /**
   * Inserts a node into the tree with the specified key and value if
   * the tree does not already contain a node with the specified key. If
   * the value is inserted, it becomes the root of the tree.
   *
   * @param {number} key Key to insert into the tree.
   * @param {*} value Value to insert into the tree.
   */
  SplayTree.prototype.insert = function (key, value) {
    if (this.isEmpty()) {
      this.root_ = new SplayTree.Node(key, value);
      return;
    }
    // Splay on the key to move the last node on the search path for
    // the key to the root of the tree.
    this.splay_(key);
    if (this.root_.key == key) {
      return;
    }
    var node = new SplayTree.Node(key, value);
    if (key > this.root_.key) {
      node.left = this.root_;
      node.right = this.root_.right;
      this.root_.right = null;
    } else {
      node.right = this.root_;
      node.left = this.root_.left;
      this.root_.left = null;
    }
    this.root_ = node;
  };

  /**
   * Removes a node with the specified key from the tree if the tree
   * contains a node with this key. The removed node is returned. If the
   * key is not found, an exception is thrown.
   *
   * @param {number} key Key to find and remove from the tree.
   * @return {SplayTree.Node} The removed node.
   */
  SplayTree.prototype.remove = function (key) {
    if (this.isEmpty()) {
      throw Error('Key not found: ' + key);
    }
    this.splay_(key);
    if (this.root_.key != key) {
      throw Error('Key not found: ' + key);
    }
    var removed = this.root_;
    if (!this.root_.left) {
      this.root_ = this.root_.right;
    } else {
      var right = this.root_.right;
      this.root_ = this.root_.left;
      // Splay to make sure that the new root has an empty right child.
      this.splay_(key);
      // Insert the original right child as the right child of the new
      // root.
      this.root_.right = right;
    }
    return removed;
  };

  /**
   * Returns the node having the specified key or null if the tree doesn't
   * contain a node with the specified key.
   *
   *
   * @param {number} key Key to find in the tree.
   * @return {SplayTree.Node} Node having the specified key.
   */
  SplayTree.prototype.find = function (key) {
    if (this.isEmpty()) {
      return null;
    }
    this.splay_(key);
    return this.root_.key == key ? this.root_ : null;
  };

  /**
   * @return {SplayTree.Node} Node having the minimum key value.
   */
  SplayTree.prototype.findMin = function () {
    if (this.isEmpty()) {
      return null;
    }
    var current = this.root_;
    while (current.left) {
      current = current.left;
    }
    return current;
  };

  /**
   * @return {SplayTree.Node} Node having the maximum key value.
   */
  SplayTree.prototype.findMax = function (opt_startNode) {
    if (this.isEmpty()) {
      return null;
    }
    var current = opt_startNode || this.root_;
    while (current.right) {
      current = current.right;
    }
    return current;
  };

  /**
   * @return {SplayTree.Node} Node having the maximum key value that
   *     is less or equal to the specified key value.
   */
  SplayTree.prototype.findGreatestLessThan = function (key) {
    if (this.isEmpty()) {
      return null;
    }
    // Splay on the key to move the node with the given key or the last
    // node on the search path to the top of the tree.
    this.splay_(key);
    // Now the result is either the root node or the greatest node in
    // the left subtree.
    if (this.root_.key <= key) {
      return this.root_;
    } else if (this.root_.left) {
      return this.findMax(this.root_.left);
    } else {
      return null;
    }
  };

  /**
   * @return {Array<*>} An array containing all the values of tree's nodes
   * paired with keys.
   *
   */
  SplayTree.prototype.exportKeysAndValues = function () {
    var result = [];
    this.traverse_(function (node) {
      result.push([node.key, node.value]);
    });
    return result;
  };

  /**
   * @return {Array<*>} An array containing all the values of tree's nodes.
   */
  SplayTree.prototype.exportValues = function () {
    var result = [];
    this.traverse_(function (node) {
      result.push(node.value);
    });
    return result;
  };

  /**
   * Perform the splay operation for the given key. Moves the node with
   * the given key to the top of the tree.  If no node has the given
   * key, the last node on the search path is moved to the top of the
   * tree. This is the simplified top-down splaying algorithm from:
   * "Self-adjusting Binary Search Trees" by Sleator and Tarjan
   *
   * @param {number} key Key to splay the tree on.
   * @private
   */
  SplayTree.prototype.splay_ = function (key) {
    if (this.isEmpty()) {
      return;
    }
    // Create a dummy node.  The use of the dummy node is a bit
    // counter-intuitive: The right child of the dummy node will hold
    // the L tree of the algorithm.  The left child of the dummy node
    // will hold the R tree of the algorithm.  Using a dummy node, left
    // and right will always be nodes and we avoid special cases.
    var dummy, left, right;
    dummy = left = right = new SplayTree.Node(null, null);
    var current = this.root_;
    while (true) {
      if (key < current.key) {
        if (!current.left) {
          break;
        }
        if (key < current.left.key) {
          // Rotate right.
          var tmp = current.left;
          current.left = tmp.right;
          tmp.right = current;
          current = tmp;
          if (!current.left) {
            break;
          }
        }
        // Link right.
        right.left = current;
        right = current;
        current = current.left;
      } else if (key > current.key) {
        if (!current.right) {
          break;
        }
        if (key > current.right.key) {
          // Rotate left.
          var tmp = current.right;
          current.right = tmp.left;
          tmp.left = current;
          current = tmp;
          if (!current.right) {
            break;
          }
        }
        // Link left.
        left.right = current;
        left = current;
        current = current.right;
      } else {
        break;
      }
    }
    // Assemble.
    left.right = current.left;
    right.left = current.right;
    current.left = dummy.right;
    current.right = dummy.left;
    this.root_ = current;
  };

  /**
   * Performs a preorder traversal of the tree.
   *
   * @param {function(SplayTree.Node)} f Visitor function.
   * @private
   */
  SplayTree.prototype.traverse_ = function (f) {
    var nodesToVisit = [this.root_];
    while (nodesToVisit.length > 0) {
      var node = nodesToVisit.shift();
      if (node == null) {
        continue;
      }
      f(node);
      nodesToVisit.push(node.left);
      nodesToVisit.push(node.right);
    }
  };

  /**
   * Constructs a Splay tree node.
   *
   * @param {number} key Key.
   * @param {*} value Value.
   */
  SplayTree.Node = function (key, value) {
    this.key = key;
    this.value = value;
  };

  /**
   * @type {SplayTree.Node}
   */
  SplayTree.Node.prototype.left = null;

  /**
   * @type {SplayTree.Node}
   */
  SplayTree.Node.prototype.right = null;

  return {
    SplayTree: SplayTree
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../../base/base.js":28}],69:[function(require,module,exports){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

/**
The lean config is just enough to import uncompressed, trace-event-formatted
json blobs.
**/

require("./importer/trace_event_importer.js");
require("../model/model.js");
},{"../model/model.js":135,"./importer/trace_event_importer.js":66}],70:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  /**
   * The context processor consumes context events and maintains a set of
   * active contexts for a single thread.
   *
   * @constructor
   */
  function ContextProcessor(model) {
    this.model_ = model;
    this.activeContexts_ = [];
    this.stackPerType_ = {};
    // Cache of unique context objects.
    this.contextCache_ = {};
    // Cache of unique context object sets.
    this.contextSetCache_ = {};
    this.cachedEntryForActiveContexts_ = undefined;
    // All seen context object snapshots.
    this.seenSnapshots_ = {};
  };

  ContextProcessor.prototype = {
    enterContext: function (contextType, scopedId) {
      var newActiveContexts = [this.getOrCreateContext_(contextType, scopedId)];
      for (var oldContext of this.activeContexts_) {
        if (oldContext.type === contextType) {
          // If a previous context of the same type is active, it is removed
          // and pushed onto the stack for this type.
          this.pushContext_(oldContext);
        } else {
          // Otherwise the old context is it is still active.
          newActiveContexts.push(oldContext);
        }
      }
      this.activeContexts_ = newActiveContexts;
      this.cachedEntryForActiveContexts_ = undefined;
    },

    leaveContext: function (contextType, scopedId) {
      this.leaveContextImpl_(context => context.type === contextType && context.snapshot.scope === scopedId.scope && context.snapshot.idRef === scopedId.id);
    },

    destroyContext: function (scopedId) {
      // Remove all matching contexts from stacks.
      tr.b.iterItems(this.stackPerType_, function (contextType, stack) {
        // Perform in-place filtering instead of Array.prototype.filter to
        // prevent creating a new array.
        var newLength = 0;
        for (var i = 0; i < stack.length; ++i) {
          if (stack[i].snapshot.scope !== scopedId.scope || stack[i].snapshot.idRef !== scopedId.id) {
            stack[newLength++] = stack[i];
          }
        }
        stack.length = newLength;
      });

      // Remove all matching contexts from active context set.
      this.leaveContextImpl_(context => context.snapshot.scope === scopedId.scope && context.snapshot.idRef === scopedId.id);
    },

    leaveContextImpl_: function (predicate) {
      var newActiveContexts = [];
      for (var oldContext of this.activeContexts_) {
        if (predicate(oldContext)) {
          // If we left this context, remove it from the active set and
          // restore any previous context of the same type.
          var previousContext = this.popContext_(oldContext.type);
          if (previousContext) newActiveContexts.push(previousContext);
        } else {
          newActiveContexts.push(oldContext);
        }
      }
      this.activeContexts_ = newActiveContexts;
      this.cachedEntryForActiveContexts_ = undefined;
    },

    getOrCreateContext_: function (contextType, scopedId) {
      var context = {
        type: contextType,
        snapshot: {
          scope: scopedId.scope,
          idRef: scopedId.id
        }
      };
      var key = this.getContextKey_(context);
      if (key in this.contextCache_) return this.contextCache_[key];
      this.contextCache_[key] = context;
      var snapshotKey = this.getSnapshotKey_(scopedId);
      this.seenSnapshots_[snapshotKey] = true;
      return context;
    },

    pushContext_: function (context) {
      if (!(context.type in this.stackPerType_)) this.stackPerType_[context.type] = [];
      this.stackPerType_[context.type].push(context);
    },

    popContext_: function (contextType) {
      if (!(contextType in this.stackPerType_)) return undefined;
      return this.stackPerType_[contextType].pop();
    },

    getContextKey_: function (context) {
      return [context.type, context.snapshot.scope, context.snapshot.idRef].join('\x00');
    },

    getSnapshotKey_: function (scopedId) {
      return [scopedId.scope, scopedId.idRef].join('\x00');
    },

    get activeContexts() {
      // Keep a single instance for each unique set of active contexts to
      // reduce memory usage.
      if (this.cachedEntryForActiveContexts_ === undefined) {
        var key = [];
        for (var context of this.activeContexts_) key.push(this.getContextKey_(context));
        key.sort();
        key = key.join('\x00');
        if (key in this.contextSetCache_) {
          this.cachedEntryForActiveContexts_ = this.contextSetCache_[key];
        } else {
          this.activeContexts_.sort(function (a, b) {
            var keyA = this.getContextKey_(a);
            var keyB = this.getContextKey_(b);
            if (keyA < keyB) return -1;
            if (keyA > keyB) return 1;
            return 0;
          }.bind(this));
          this.contextSetCache_[key] = Object.freeze(this.activeContexts_);
          this.cachedEntryForActiveContexts_ = this.contextSetCache_[key];
        }
      }
      return this.cachedEntryForActiveContexts_;
    },

    invalidateContextCacheForSnapshot: function (scopedId) {
      var snapshotKey = this.getSnapshotKey_(scopedId);
      if (!(snapshotKey in this.seenSnapshots_)) return;
      this.contextCache_ = {};
      this.contextSetCache_ = {};
      this.cachedEntryForActiveContexts_ = undefined;
      this.activeContexts_ = this.activeContexts_.map(function (context) {
        // Do not alter unrelated contexts.
        if (context.snapshot.scope !== scopedId.scope || context.snapshot.idRef !== scopedId.id) return context;
        // Replace the invalidated context by a deep copy.
        return {
          type: context.type,
          snapshot: {
            scope: context.snapshot.scope,
            idRef: context.snapshot.idRef
          }
        };
      });
      this.seenSnapshots_ = {};
    }
  };

  return {
    ContextProcessor: ContextProcessor
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28}],71:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("./importer.js");

'use strict';

/**
 * @fileoverview Base class for trace data importers.
 */
global.tr.exportTo('tr.importer', function () {
  /**
   * Importer for empty strings and arrays.
   * @constructor
   */
  function EmptyImporter(events) {
    this.importPriority = 0;
  };

  EmptyImporter.canImport = function (eventData) {
    if (eventData instanceof Array && eventData.length == 0) return true;
    if (typeof eventData === 'string' || eventData instanceof String) {
      return eventData.length == 0;
    }
    return false;
  };

  EmptyImporter.prototype = {
    __proto__: tr.importer.Importer.prototype,

    get importerName() {
      return 'EmptyImporter';
    }
  };

  tr.importer.Importer.register(EmptyImporter);

  return {
    EmptyImporter: EmptyImporter
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"./importer.js":76}],72:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/range_utils.js");
require("../extras/chrome/cc/input_latency_async_slice.js");
require("./proto_expectation.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  var ProtoExpectation = tr.importer.ProtoExpectation;

  var INPUT_TYPE = tr.e.cc.INPUT_EVENT_TYPE_NAMES;

  var KEYBOARD_TYPE_NAMES = [INPUT_TYPE.CHAR, INPUT_TYPE.KEY_DOWN_RAW, INPUT_TYPE.KEY_DOWN, INPUT_TYPE.KEY_UP];
  var MOUSE_RESPONSE_TYPE_NAMES = [INPUT_TYPE.CLICK, INPUT_TYPE.CONTEXT_MENU];
  var MOUSE_WHEEL_TYPE_NAMES = [INPUT_TYPE.MOUSE_WHEEL];
  var MOUSE_DRAG_TYPE_NAMES = [INPUT_TYPE.MOUSE_DOWN, INPUT_TYPE.MOUSE_MOVE, INPUT_TYPE.MOUSE_UP];
  var TAP_TYPE_NAMES = [INPUT_TYPE.TAP, INPUT_TYPE.TAP_CANCEL, INPUT_TYPE.TAP_DOWN];
  var PINCH_TYPE_NAMES = [INPUT_TYPE.PINCH_BEGIN, INPUT_TYPE.PINCH_END, INPUT_TYPE.PINCH_UPDATE];
  var FLING_TYPE_NAMES = [INPUT_TYPE.FLING_CANCEL, INPUT_TYPE.FLING_START];
  var TOUCH_TYPE_NAMES = [INPUT_TYPE.TOUCH_END, INPUT_TYPE.TOUCH_MOVE, INPUT_TYPE.TOUCH_START];
  var SCROLL_TYPE_NAMES = [INPUT_TYPE.SCROLL_BEGIN, INPUT_TYPE.SCROLL_END, INPUT_TYPE.SCROLL_UPDATE];
  var ALL_HANDLED_TYPE_NAMES = [].concat(KEYBOARD_TYPE_NAMES, MOUSE_RESPONSE_TYPE_NAMES, MOUSE_WHEEL_TYPE_NAMES, MOUSE_DRAG_TYPE_NAMES, PINCH_TYPE_NAMES, TAP_TYPE_NAMES, FLING_TYPE_NAMES, TOUCH_TYPE_NAMES, SCROLL_TYPE_NAMES);

  var RENDERER_FLING_TITLE = 'InputHandlerProxy::HandleGestureFling::started';
  var PLAYBACK_EVENT_TITLE = 'VideoPlayback';

  var CSS_ANIMATION_TITLE = 'Animation';

  /**
   * If there's less than this much time between the end of one event and the
   * start of the next, then they might be merged.
   * There was not enough thought given to this value, so if you have any slight
   * reason to change it, then please do so. It might also be good to split this
   * into multiple values.
   */
  var INPUT_MERGE_THRESHOLD_MS = 200;
  var ANIMATION_MERGE_THRESHOLD_MS = 32; // 2x 60FPS frames

  /**
   * If two MouseWheel events begin this close together, then they're an
   * Animation, not two responses.
   */
  var MOUSE_WHEEL_THRESHOLD_MS = 40;

  /**
   * If two MouseMoves are more than this far apart, then they're two Responses,
   * not Animation.
   */
  var MOUSE_MOVE_THRESHOLD_MS = 40;

  // Strings used to name IRs.
  var KEYBOARD_IR_NAME = 'Keyboard';
  var MOUSE_IR_NAME = 'Mouse';
  var MOUSEWHEEL_IR_NAME = 'MouseWheel';
  var TAP_IR_NAME = 'Tap';
  var PINCH_IR_NAME = 'Pinch';
  var FLING_IR_NAME = 'Fling';
  var TOUCH_IR_NAME = 'Touch';
  var SCROLL_IR_NAME = 'Scroll';
  var CSS_IR_NAME = 'CSS';
  var WEBGL_IR_NAME = 'WebGL';
  var VIDEO_IR_NAME = 'Video';

  // TODO(benjhayden) Find a better home for this.
  function compareEvents(x, y) {
    if (x.start !== y.start) return x.start - y.start;
    if (x.end !== y.end) return x.end - y.end;
    if (x.guid && y.guid) return x.guid - y.guid;
    return 0;
  }

  function forEventTypesIn(events, typeNames, cb, opt_this) {
    events.forEach(function (event) {
      if (typeNames.indexOf(event.typeName) >= 0) {
        cb.call(opt_this, event);
      }
    });
  }

  function causedFrame(event) {
    return event.associatedEvents.some(x => x.title === tr.model.helpers.IMPL_RENDERING_STATS);
  }

  function getSortedFrameEventsByProcess(modelHelper) {
    var frameEventsByPid = {};
    tr.b.iterItems(modelHelper.rendererHelpers, function (pid, rendererHelper) {
      frameEventsByPid[pid] = rendererHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE, modelHelper.model.bounds);
    });
    return frameEventsByPid;
  }

  function getSortedInputEvents(modelHelper) {
    var inputEvents = [];

    var browserProcess = modelHelper.browserHelper.process;
    var mainThread = browserProcess.findAtMostOneThreadNamed('CrBrowserMain');
    for (var slice of mainThread.asyncSliceGroup.getDescendantEvents()) {
      if (!slice.isTopLevel) continue;

      if (!(slice instanceof tr.e.cc.InputLatencyAsyncSlice)) continue;

      // TODO(beaudoin): This should never happen but it does. Investigate
      // the trace linked at in #1567 and remove that when it's fixed.
      if (isNaN(slice.start) || isNaN(slice.duration) || isNaN(slice.end)) continue;

      inputEvents.push(slice);
    }

    return inputEvents.sort(compareEvents);
  }

  function findProtoExpectations(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    // This order is not important. Handlers are independent.
    var handlers = [handleKeyboardEvents, handleMouseResponseEvents, handleMouseWheelEvents, handleMouseDragEvents, handleTapResponseEvents, handlePinchEvents, handleFlingEvents, handleTouchEvents, handleScrollEvents, handleCSSAnimations, handleWebGLAnimations, handleVideoAnimations];
    handlers.forEach(function (handler) {
      protoExpectations.push.apply(protoExpectations, handler(modelHelper, sortedInputEvents));
    });
    protoExpectations.sort(compareEvents);
    return protoExpectations;
  }

  /**
   * Every keyboard event is a Response.
   */
  function handleKeyboardEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    forEventTypesIn(sortedInputEvents, KEYBOARD_TYPE_NAMES, function (event) {
      var pe = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, KEYBOARD_IR_NAME);
      pe.pushEvent(event);
      protoExpectations.push(pe);
    });
    return protoExpectations;
  }

  /**
   * Some mouse events can be translated directly into Responses.
   */
  function handleMouseResponseEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    forEventTypesIn(sortedInputEvents, MOUSE_RESPONSE_TYPE_NAMES, function (event) {
      var pe = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, MOUSE_IR_NAME);
      pe.pushEvent(event);
      protoExpectations.push(pe);
    });
    return protoExpectations;
  }
  /**
   * MouseWheel events are caused either by a physical wheel on a physical
   * mouse, or by a touch-drag gesture on a track-pad. The physical wheel
   * causes MouseWheel events that are much more spaced out, and have no
   * chance of hitting 60fps, so they are each turned into separate Response
   * IRs. The track-pad causes MouseWheel events that are much closer
   * together, and are expected to be 60fps, so the first event in a sequence
   * is turned into a Response, and the rest are merged into an Animation.
   * NB this threshold uses the two events' start times, unlike
   * ProtoExpectation.isNear, which compares the end time of the previous event
   * with the start time of the next.
   */
  function handleMouseWheelEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    var prevEvent_ = undefined;
    forEventTypesIn(sortedInputEvents, MOUSE_WHEEL_TYPE_NAMES, function (event) {
      // Switch prevEvent in one place so that we can early-return later.
      var prevEvent = prevEvent_;
      prevEvent_ = event;

      if (currentPE && prevEvent.start + MOUSE_WHEEL_THRESHOLD_MS >= event.start) {
        if (currentPE.irType === ProtoExpectation.ANIMATION_TYPE) {
          currentPE.pushEvent(event);
        } else {
          currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, MOUSEWHEEL_IR_NAME);
          currentPE.pushEvent(event);
          protoExpectations.push(currentPE);
        }
        return;
      }
      currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, MOUSEWHEEL_IR_NAME);
      currentPE.pushEvent(event);
      protoExpectations.push(currentPE);
    });
    return protoExpectations;
  }

  /**
   * Down events followed closely by Up events are click Responses, but the
   * Response doesn't start until the Up event.
   *
   *     RRR
   * DDD UUU
   *
   * If there are any Move events in between a Down and an Up, then the Down
   * and the first Move are a Response, then the rest of the Moves are an
   * Animation:
   *
   * RRRRRRRAAAAAAAAAAAAAAAAAAAA
   * DDD MMM MMM MMM MMM MMM UUU
   */
  function handleMouseDragEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    var mouseDownEvent = undefined;
    forEventTypesIn(sortedInputEvents, MOUSE_DRAG_TYPE_NAMES, function (event) {
      switch (event.typeName) {
        case INPUT_TYPE.MOUSE_DOWN:
          if (causedFrame(event)) {
            var pe = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, MOUSE_IR_NAME);
            pe.pushEvent(event);
            protoExpectations.push(pe);
          } else {
            // Responses typically don't start until the mouse up event.
            // Add this MouseDown to the Response that starts at the MouseUp.
            mouseDownEvent = event;
          }
          break;

        // There may be more than 100ms between the start of the mouse down
        // and the start of the mouse up. Chrome and the web don't start to
        // respond until the mouse up. ResponseIRs start deducting comfort
        // at 100ms duration. If more than that 100ms duration is burned
        // through while waiting for the user to release the
        // mouse button, then ResponseIR will unfairly start deducting
        // comfort before Chrome even has a mouse up to respond to.
        // It is technically possible for a site to afford one response on
        // mouse down and another on mouse up, but that is an edge case. The
        // vast majority of mouse downs are not responses.

        case INPUT_TYPE.MOUSE_MOVE:
          if (!causedFrame(event)) {
            // Ignore MouseMoves that do not affect the screen. They are not
            // part of an interaction record by definition.
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
          } else if (!currentPE || !currentPE.isNear(event, MOUSE_MOVE_THRESHOLD_MS)) {
            // The first MouseMove after a MouseDown or after a while is a
            // Response.
            currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, MOUSE_IR_NAME);
            currentPE.pushEvent(event);
            if (mouseDownEvent) {
              currentPE.associatedEvents.push(mouseDownEvent);
              mouseDownEvent = undefined;
            }
            protoExpectations.push(currentPE);
          } else {
            // Merge this event into an Animation.
            if (currentPE.irType === ProtoExpectation.ANIMATION_TYPE) {
              currentPE.pushEvent(event);
            } else {
              currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, MOUSE_IR_NAME);
              currentPE.pushEvent(event);
              protoExpectations.push(currentPE);
            }
          }
          break;

        case INPUT_TYPE.MOUSE_UP:
          if (!mouseDownEvent) {
            var pe = new ProtoExpectation(causedFrame(event) ? ProtoExpectation.RESPONSE_TYPE : ProtoExpectation.IGNORED_TYPE, MOUSE_IR_NAME);
            pe.pushEvent(event);
            protoExpectations.push(pe);
            break;
          }

          if (currentPE) {
            currentPE.pushEvent(event);
          } else {
            currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, MOUSE_IR_NAME);
            if (mouseDownEvent) currentPE.associatedEvents.push(mouseDownEvent);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
          }
          mouseDownEvent = undefined;
          currentPE = undefined;
          break;
      }
    });
    if (mouseDownEvent) {
      currentPE = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
      currentPE.pushEvent(mouseDownEvent);
      protoExpectations.push(currentPE);
    }
    return protoExpectations;
  }

  /**
   * Solitary Tap events are simple Responses:
   *
   * RRR
   * TTT
   *
   * TapDowns are part of Responses.
   *
   * RRRRRRR
   * DDD TTT
   *
   * TapCancels are part of Responses, which seems strange. They always go
   * with scrolls, so they'll probably be merged with scroll Responses.
   * TapCancels can take a significant amount of time and account for a
   * significant amount of work, which should be grouped with the scroll IRs
   * if possible.
   *
   * RRRRRRR
   * DDD CCC
   **/
  function handleTapResponseEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    forEventTypesIn(sortedInputEvents, TAP_TYPE_NAMES, function (event) {
      switch (event.typeName) {
        case INPUT_TYPE.TAP_DOWN:
          currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, TAP_IR_NAME);
          currentPE.pushEvent(event);
          protoExpectations.push(currentPE);
          break;

        case INPUT_TYPE.TAP:
          if (currentPE) {
            currentPE.pushEvent(event);
          } else {
            // Sometimes we get Tap events with no TapDown, sometimes we get
            // TapDown events. Handle both.
            currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, TAP_IR_NAME);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
          }
          currentPE = undefined;
          break;

        case INPUT_TYPE.TAP_CANCEL:
          if (!currentPE) {
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
            break;
          }

          if (currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS)) {
            currentPE.pushEvent(event);
          } else {
            currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, TAP_IR_NAME);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
          }
          currentPE = undefined;
          break;
      }
    });
    return protoExpectations;
  }

  /**
   * The PinchBegin and the first PinchUpdate comprise a Response, then the
   * rest of the PinchUpdates comprise an Animation.
   *
   * RRRRRRRAAAAAAAAAAAAAAAAAAAA
   * BBB UUU UUU UUU UUU UUU EEE
   */
  function handlePinchEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    var sawFirstUpdate = false;
    var modelBounds = modelHelper.model.bounds;
    forEventTypesIn(sortedInputEvents, PINCH_TYPE_NAMES, function (event) {
      switch (event.typeName) {
        case INPUT_TYPE.PINCH_BEGIN:
          if (currentPE && currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS)) {
            currentPE.pushEvent(event);
            break;
          }
          currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, PINCH_IR_NAME);
          currentPE.pushEvent(event);
          currentPE.isAnimationBegin = true;
          protoExpectations.push(currentPE);
          sawFirstUpdate = false;
          break;

        case INPUT_TYPE.PINCH_UPDATE:
          // Like ScrollUpdates, the Begin and the first Update constitute a
          // Response, then the rest of the Updates constitute an Animation
          // that begins when the Response ends. If the user pauses in the
          // middle of an extended pinch gesture, then multiple Animations
          // will be created.
          if (!currentPE || currentPE.irType === ProtoExpectation.RESPONSE_TYPE && sawFirstUpdate || !currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS)) {
            currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, PINCH_IR_NAME);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
          } else {
            currentPE.pushEvent(event);
            sawFirstUpdate = true;
          }
          break;

        case INPUT_TYPE.PINCH_END:
          if (currentPE) {
            currentPE.pushEvent(event);
          } else {
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
          }
          currentPE = undefined;
          break;
      }
    });
    return protoExpectations;
  }

  /**
   * Flings are defined by 3 types of events: FlingStart, FlingCancel, and the
   * renderer fling event. Flings do not begin with a Response. Flings end
   * either at the beginning of a FlingCancel, or at the end of the renderer
   * fling event.
   *
   * AAAAAAAAAAAAAAAAAAAAAAAAAA
   * SSS
   *     RRRRRRRRRRRRRRRRRRRRRR
   *
   *
   * AAAAAAAAAAA
   * SSS        CCC
   */
  function handleFlingEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;

    function isRendererFling(event) {
      return event.title === RENDERER_FLING_TITLE;
    }
    var browserHelper = modelHelper.browserHelper;
    var flingEvents = browserHelper.getAllAsyncSlicesMatching(isRendererFling);

    forEventTypesIn(sortedInputEvents, FLING_TYPE_NAMES, function (event) {
      flingEvents.push(event);
    });
    flingEvents.sort(compareEvents);

    flingEvents.forEach(function (event) {
      if (event.title === RENDERER_FLING_TITLE) {
        if (currentPE) {
          currentPE.pushEvent(event);
        } else {
          currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, FLING_IR_NAME);
          currentPE.pushEvent(event);
          protoExpectations.push(currentPE);
        }
        return;
      }

      switch (event.typeName) {
        case INPUT_TYPE.FLING_START:
          if (currentPE) {
            console.error('Another FlingStart? File a bug with this trace!');
            currentPE.pushEvent(event);
          } else {
            currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, FLING_IR_NAME);
            currentPE.pushEvent(event);
            // Set end to an invalid value so that it can be noticed and fixed
            // later.
            currentPE.end = 0;
            protoExpectations.push(currentPE);
          }
          break;

        case INPUT_TYPE.FLING_CANCEL:
          if (currentPE) {
            currentPE.pushEvent(event);
            // FlingCancel events start when TouchStart events start, which is
            // typically when a Response starts. FlingCancel events end when
            // chrome acknowledges them, not when they update the screen. So
            // there might be one more frame during the FlingCancel, after
            // this Animation ends. That won't affect the scoring algorithms,
            // and it will make the IRs look more correct if they don't
            // overlap unnecessarily.
            currentPE.end = event.start;
            currentPE = undefined;
          } else {
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
          }
          break;
      }
    });
    // If there was neither a FLING_CANCEL nor a renderer fling after the
    // FLING_START, then assume that it ends at the end of the model, so set
    // the end of currentPE to the end of the model.
    if (currentPE && !currentPE.end) currentPE.end = modelHelper.model.bounds.max;
    return protoExpectations;
  }

  /**
   * The TouchStart and the first TouchMove comprise a Response, then the
   * rest of the TouchMoves comprise an Animation.
   *
   * RRRRRRRAAAAAAAAAAAAAAAAAAAA
   * SSS MMM MMM MMM MMM MMM EEE
   *
   * If there are no TouchMove events in between a TouchStart and a TouchEnd,
   * then it's just a Response.
   *
   * RRRRRRR
   * SSS EEE
   */
  function handleTouchEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    var sawFirstMove = false;
    forEventTypesIn(sortedInputEvents, TOUCH_TYPE_NAMES, function (event) {
      switch (event.typeName) {
        case INPUT_TYPE.TOUCH_START:
          if (currentPE) {
            // NB: currentPE will probably be merged with something from
            // handlePinchEvents(). Multiple TouchStart events without an
            // intervening TouchEnd logically implies that multiple fingers
            // are on the screen, so this is probably a pinch gesture.
            currentPE.pushEvent(event);
          } else {
            currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, TOUCH_IR_NAME);
            currentPE.pushEvent(event);
            currentPE.isAnimationBegin = true;
            protoExpectations.push(currentPE);
            sawFirstMove = false;
          }
          break;

        case INPUT_TYPE.TOUCH_MOVE:
          if (!currentPE) {
            currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, TOUCH_IR_NAME);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
            break;
          }

          // Like Scrolls and Pinches, the Response is defined to be the
          // TouchStart plus the first TouchMove, then the rest of the
          // TouchMoves constitute an Animation.
          if (sawFirstMove && currentPE.irType === ProtoExpectation.RESPONSE_TYPE || !currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS)) {
            // If there's already a touchmove in the currentPE or it's not
            // near event, then finish it and start a new animation.
            var prevEnd = currentPE.end;
            currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, TOUCH_IR_NAME);
            currentPE.pushEvent(event);
            // It's possible for there to be a gap between TouchMoves, but
            // that doesn't mean that there should be an Idle IR there.
            currentPE.start = prevEnd;
            protoExpectations.push(currentPE);
          } else {
            currentPE.pushEvent(event);
            sawFirstMove = true;
          }
          break;

        case INPUT_TYPE.TOUCH_END:
          if (!currentPE) {
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
            break;
          }
          if (currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS)) {
            currentPE.pushEvent(event);
          } else {
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
          }
          currentPE = undefined;
          break;
      }
    });
    return protoExpectations;
  }

  /**
   * The first ScrollBegin and the first ScrollUpdate comprise a Response,
   * then the rest comprise an Animation.
   *
   * RRRRRRRAAAAAAAAAAAAAAAAAAAA
   * BBB UUU UUU UUU UUU UUU EEE
   */
  function handleScrollEvents(modelHelper, sortedInputEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    var sawFirstUpdate = false;
    forEventTypesIn(sortedInputEvents, SCROLL_TYPE_NAMES, function (event) {
      switch (event.typeName) {
        case INPUT_TYPE.SCROLL_BEGIN:
          // Always begin a new PE even if there already is one, unlike
          // PinchBegin.
          currentPE = new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE, SCROLL_IR_NAME);
          currentPE.pushEvent(event);
          currentPE.isAnimationBegin = true;
          protoExpectations.push(currentPE);
          sawFirstUpdate = false;
          break;

        case INPUT_TYPE.SCROLL_UPDATE:
          if (currentPE) {
            if (currentPE.isNear(event, INPUT_MERGE_THRESHOLD_MS) && (currentPE.irType === ProtoExpectation.ANIMATION_TYPE || !sawFirstUpdate)) {
              currentPE.pushEvent(event);
              sawFirstUpdate = true;
            } else {
              currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, SCROLL_IR_NAME);
              currentPE.pushEvent(event);
              protoExpectations.push(currentPE);
            }
          } else {
            // ScrollUpdate without ScrollBegin.
            currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, SCROLL_IR_NAME);
            currentPE.pushEvent(event);
            protoExpectations.push(currentPE);
          }
          break;

        case INPUT_TYPE.SCROLL_END:
          if (!currentPE) {
            console.error('ScrollEnd without ScrollUpdate? ' + 'File a bug with this trace!');
            var pe = new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);
            pe.pushEvent(event);
            protoExpectations.push(pe);
            break;
          }
          currentPE.pushEvent(event);
          break;
      }
    });
    return protoExpectations;
  }

  /**
   * Returns proto expectations for video animation events.
   *
   * Video animations represent video playback, and are based on
   * VideoPlayback async events (going from the VideoFrameCompositor::Start
   * to VideoFrameCompositor::Stop calls)
   */
  function handleVideoAnimations(modelHelper, sortedInputEvents) {
    var events = [];
    for (var pid in modelHelper.rendererHelpers) {
      for (var asyncSlice of modelHelper.rendererHelpers[pid].mainThread.asyncSliceGroup.slices) {
        if (asyncSlice.title === PLAYBACK_EVENT_TITLE) events.push(asyncSlice);
      }
    }

    events.sort(tr.importer.compareEvents);

    var protoExpectations = [];
    for (var event of events) {
      var currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, VIDEO_IR_NAME);
      currentPE.start = event.start;
      currentPE.end = event.end;
      currentPE.pushEvent(event);
      protoExpectations.push(currentPE);
    }

    return protoExpectations;
  }

  /**
   * CSS Animations are merged into AnimationExpectations when they intersect.
   */
  function handleCSSAnimations(modelHelper, sortedInputEvents) {
    // First find all the top-level CSS Animation async events.
    var animationEvents = modelHelper.browserHelper.getAllAsyncSlicesMatching(function (event) {
      return event.title === CSS_ANIMATION_TITLE && event.isTopLevel && event.duration > 0;
    });

    // Time ranges where animations are actually running will be collected here.
    // Each element will contain {min, max, animation}.
    var animationRanges = [];

    // This helper function will be called when a time range is found
    // during which the animation is actually running.
    function pushAnimationRange(start, end, animation) {
      var range = tr.b.Range.fromExplicitRange(start, end);
      range.animation = animation;
      animationRanges.push(range);
    }

    animationEvents.forEach(function (animation) {
      if (animation.subSlices.length === 0) {
        pushAnimationRange(animation.start, animation.end, animation);
      } else {
        // Now run a state machine over the animation's subSlices, which
        // indicate the animations running/paused/finished states, in order to
        // find ranges where the animation was actually running.
        var start = undefined;
        animation.subSlices.forEach(function (sub) {
          if (sub.args.data.state === 'running' && start === undefined) {
            // It's possible for the state to alternate between running and
            // pending, but the animation is still running in that case,
            // so only set start if the state is changing from one of the halted
            // states.
            start = sub.start;
          } else if (sub.args.data.state === 'paused' || sub.args.data.state === 'idle' || sub.args.data.state === 'finished') {
            if (start === undefined) {
              // An animation was already running when the trace started.
              // (Actually, it's possible that the animation was in the 'idle'
              // state when tracing started, but that should be rare, and will
              // be fixed when async events are buffered.)
              // http: //crbug.com/565627
              start = modelHelper.model.bounds.min;
            }

            pushAnimationRange(start, sub.start, animation);
            start = undefined;
          }
        });

        // An animation was still running when the
        // top-level animation event ended.
        if (start !== undefined) pushAnimationRange(start, animation.end, animation);
      }
    });

    // Now we have a set of time ranges when css animations were actually
    // running.
    // Leave merging intersecting animations to mergeIntersectingAnimations(),
    // after findFrameEventsForAnimations removes frame-less animations.

    return animationRanges.map(function (range) {
      var protoExpectation = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, CSS_IR_NAME);
      protoExpectation.start = range.min;
      protoExpectation.end = range.max;
      protoExpectation.associatedEvents.push(range.animation);
      return protoExpectation;
    });
  }

  /**
   * Get all the events (prepareMailbox and serviceScriptedAnimations)
   * relevant to WebGL. Note that modelHelper is the helper object containing
   * the model, and mailboxEvents and animationEvents are arrays where the
   * events are being pushed into (DrawingBuffer::prepareMailbox events go
   * into mailboxEvents; PageAnimator::serviceScriptedAnimations events go
   * into animationEvents). The function does not return anything but
   * modifies mailboxEvents and animationEvents.
   */
  function findWebGLEvents(modelHelper, mailboxEvents, animationEvents) {
    for (var event of modelHelper.model.getDescendantEvents()) {
      if (event.title === 'DrawingBuffer::prepareMailbox') mailboxEvents.push(event);else if (event.title === 'PageAnimator::serviceScriptedAnimations') animationEvents.push(event);
    }
  }

  /**
   * Returns a list of events in mailboxEvents that have an event in
   * animationEvents close by (within ANIMATION_MERGE_THRESHOLD_MS).
   */
  function findMailboxEventsNearAnimationEvents(mailboxEvents, animationEvents) {
    if (animationEvents.length === 0) return [];

    mailboxEvents.sort(compareEvents);
    animationEvents.sort(compareEvents);
    var animationIterator = animationEvents[Symbol.iterator]();
    var animationEvent = animationIterator.next().value;

    var filteredEvents = [];

    // We iterate through the mailboxEvents. With each event, we check if
    // there is a animationEvent near it, and if so, add it to the result.
    for (var event of mailboxEvents) {
      // If the current animationEvent is too far before the mailboxEvent,
      // we advance until we get to the next animationEvent that is not too
      // far before the animationEvent.
      while (animationEvent && animationEvent.start < event.start - ANIMATION_MERGE_THRESHOLD_MS) animationEvent = animationIterator.next().value;

      // If there aren't any more animationEvents, then that means all the
      // remaining mailboxEvents are too far after the animationEvents, so
      // we can quit now.
      if (!animationEvent) break;

      // If there's a animationEvent close to the mailboxEvent, then we push
      // the current mailboxEvent onto the stack.
      if (animationEvent.start < event.start + ANIMATION_MERGE_THRESHOLD_MS) filteredEvents.push(event);
    }
    return filteredEvents;
  }

  /**
   * Merge consecutive mailbox events into a ProtoExpectation. Note: Only
   * the drawingBuffer::prepareMailbox events will end up in the
   * associatedEvents. The PageAnimator::serviceScriptedAnimations events
   * will not end up in the associatedEvents.
   */
  function createProtoExpectationsFromMailboxEvents(mailboxEvents) {
    var protoExpectations = [];
    var currentPE = undefined;
    for (var event of mailboxEvents) {
      if (currentPE === undefined || !currentPE.isNear(event, ANIMATION_MERGE_THRESHOLD_MS)) {
        currentPE = new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE, WEBGL_IR_NAME);
        currentPE.pushEvent(event);
        protoExpectations.push(currentPE);
      } else {
        currentPE.pushEvent(event);
      }
    }
    return protoExpectations;
  }

  // WebGL animations are identified by the DrawingBuffer::prepareMailbox
  // and PageAnimator::serviceScriptedAnimations events (one of each per frame)
  // and consecutive frames are merged into the same animation.
  function handleWebGLAnimations(modelHelper, sortedInputEvents) {
    // Get the prepareMailbox and scriptedAnimation events.
    var prepareMailboxEvents = [];
    var scriptedAnimationEvents = [];

    findWebGLEvents(modelHelper, prepareMailboxEvents, scriptedAnimationEvents);
    var webGLMailboxEvents = findMailboxEventsNearAnimationEvents(prepareMailboxEvents, scriptedAnimationEvents);

    return createProtoExpectationsFromMailboxEvents(webGLMailboxEvents);
  }

  function postProcessProtoExpectations(modelHelper, protoExpectations) {
    // protoExpectations is input only. Returns a modified set of
    // ProtoExpectations.  The order is important.
    protoExpectations = findFrameEventsForAnimations(modelHelper, protoExpectations);
    protoExpectations = mergeIntersectingResponses(protoExpectations);
    protoExpectations = mergeIntersectingAnimations(protoExpectations);
    protoExpectations = fixResponseAnimationStarts(protoExpectations);
    protoExpectations = fixTapResponseTouchAnimations(protoExpectations);
    return protoExpectations;
  }

  /**
   * TouchStarts happen at the same time as ScrollBegins.
   * It's easier to let multiple handlers create multiple overlapping
   * Responses and then merge them, rather than make the handlers aware of the
   * other handlers' PEs.
   *
   * For example:
   * RR
   *  RRR  -> RRRRR
   *    RR
   *
   * protoExpectations is input only.
   * Returns a modified set of ProtoExpectations.
   */
  function mergeIntersectingResponses(protoExpectations) {
    var newPEs = [];
    while (protoExpectations.length) {
      var pe = protoExpectations.shift();
      newPEs.push(pe);

      // Only consider Responses for now.
      if (pe.irType !== ProtoExpectation.RESPONSE_TYPE) continue;

      for (var i = 0; i < protoExpectations.length; ++i) {
        var otherPE = protoExpectations[i];

        if (otherPE.irType !== pe.irType) continue;

        if (!otherPE.intersects(pe)) continue;

        // Don't merge together Responses of the same type.
        // If handleTouchEvents wanted two of its Responses to be merged, then
        // it would have made them that way to begin with.
        var typeNames = pe.associatedEvents.map(function (event) {
          return event.typeName;
        });
        if (otherPE.containsTypeNames(typeNames)) continue;

        pe.merge(otherPE);
        protoExpectations.splice(i, 1);

        // Don't skip the next otherPE!
        --i;
      }
    }
    return newPEs;
  }

  /**
   * An animation is simply an expectation of 60fps between start and end.
   * If two animations overlap, then merge them.
   *
   * For example:
   * AA
   *  AAA  -> AAAAA
   *    AA
   *
   * protoExpectations is input only.
   * Returns a modified set of ProtoExpectations.
   */
  function mergeIntersectingAnimations(protoExpectations) {
    var newPEs = [];
    while (protoExpectations.length) {
      var pe = protoExpectations.shift();
      newPEs.push(pe);

      // Only consider Animations for now.
      if (pe.irType !== ProtoExpectation.ANIMATION_TYPE) continue;

      var isCSS = pe.containsSliceTitle(CSS_ANIMATION_TITLE);
      var isFling = pe.containsTypeNames([INPUT_TYPE.FLING_START]);
      var isVideo = pe.containsTypeNames([VIDEO_IR_NAME]);

      for (var i = 0; i < protoExpectations.length; ++i) {
        var otherPE = protoExpectations[i];

        if (otherPE.irType !== pe.irType) continue;

        // Don't merge CSS Animations with any other types.
        if (isCSS != otherPE.containsSliceTitle(CSS_ANIMATION_TITLE)) continue;

        if (isCSS) {
          if (!pe.isNear(otherPE, ANIMATION_MERGE_THRESHOLD_MS)) continue;
        } else if (!otherPE.intersects(pe)) {
          continue;
        }

        // Don't merge Fling Animations with any other types.
        if (isFling !== otherPE.containsTypeNames([INPUT_TYPE.FLING_START])) continue;

        // Don't merge Video Animations with any other types.
        if (isVideo !== otherPE.containsTypeNames([VIDEO_IR_NAME])) continue;

        pe.merge(otherPE);
        protoExpectations.splice(i, 1);
        // Don't skip the next otherPE!
        --i;
      }
    }
    return newPEs;
  }

  /**
   * The ends of responses frequently overlap the starts of animations.
   * Fix the animations to reflect the fact that the user can only start to
   * expect 60fps after the response.
   *
   * For example:
   * RRR   -> RRRAA
   *  AAAA
   *
   * protoExpectations is input only.
   * Returns a modified set of ProtoExpectations.
   */
  function fixResponseAnimationStarts(protoExpectations) {
    protoExpectations.forEach(function (ape) {
      // Only consider animations for now.
      if (ape.irType !== ProtoExpectation.ANIMATION_TYPE) return;

      protoExpectations.forEach(function (rpe) {
        // Only consider responses for now.
        if (rpe.irType !== ProtoExpectation.RESPONSE_TYPE) return;

        // Only consider responses that end during the animation.
        if (!ape.containsTimestampInclusive(rpe.end)) return;

        // Ignore Responses that are entirely contained by the animation.
        if (ape.containsTimestampInclusive(rpe.start)) return;

        // Move the animation start to the response end.
        ape.start = rpe.end;
      });
    });
    return protoExpectations;
  }

  /**
   * Merge Tap Responses that overlap Touch-only Animations.
   * https: *github.com/catapult-project/catapult/issues/1431
   */
  function fixTapResponseTouchAnimations(protoExpectations) {
    function isTapResponse(pe) {
      return pe.irType === ProtoExpectation.RESPONSE_TYPE && pe.containsTypeNames([INPUT_TYPE.TAP]);
    }
    function isTouchAnimation(pe) {
      return pe.irType === ProtoExpectation.ANIMATION_TYPE && pe.containsTypeNames([INPUT_TYPE.TOUCH_MOVE]) && !pe.containsTypeNames([INPUT_TYPE.SCROLL_UPDATE, INPUT_TYPE.PINCH_UPDATE]);
    }
    var newPEs = [];
    while (protoExpectations.length) {
      var pe = protoExpectations.shift();
      newPEs.push(pe);

      // protoExpectations are sorted by start time, and we don't know whether
      // the Tap Response or the Touch Animation will be first
      var peIsTapResponse = isTapResponse(pe);
      var peIsTouchAnimation = isTouchAnimation(pe);
      if (!peIsTapResponse && !peIsTouchAnimation) continue;

      for (var i = 0; i < protoExpectations.length; ++i) {
        var otherPE = protoExpectations[i];

        if (!otherPE.intersects(pe)) continue;

        if (peIsTapResponse && !isTouchAnimation(otherPE)) continue;

        if (peIsTouchAnimation && !isTapResponse(otherPE)) continue;

        // pe might be the Touch Animation, but the merged ProtoExpectation
        // should be a Response.
        pe.irType = ProtoExpectation.RESPONSE_TYPE;

        pe.merge(otherPE);
        protoExpectations.splice(i, 1);
        // Don't skip the next otherPE!
        --i;
      }
    }
    return newPEs;
  }

  function findFrameEventsForAnimations(modelHelper, protoExpectations) {
    var newPEs = [];
    var frameEventsByPid = getSortedFrameEventsByProcess(modelHelper);

    for (var pe of protoExpectations) {
      if (pe.irType !== ProtoExpectation.ANIMATION_TYPE) {
        newPEs.push(pe);
        continue;
      }

      var frameEvents = [];
      // TODO(benjhayden): Use frame blame contexts here.
      for (var pid of Object.keys(modelHelper.rendererHelpers)) {
        var range = tr.b.Range.fromExplicitRange(pe.start, pe.end);
        frameEvents.push.apply(frameEvents, range.filterArray(frameEventsByPid[pid], e => e.start));
      }

      // If a tree falls in a forest...
      // If there were not actually any frames while the animation was
      // running, then it wasn't really an animation, now, was it?
      // Philosophy aside, the system_health Animation metrics fail hard if
      // there are no frames in an AnimationExpectation.
      // Since WebGL animations don't generate this type of frame event,
      // don't remove them if it's a WebGL animation.
      // TODO(alexandermont): Identify what the correct frame event to
      // use here is.
      if (frameEvents.length === 0 && !pe.names.has(WEBGL_IR_NAME)) {
        pe.irType = ProtoExpectation.IGNORED_TYPE;
        newPEs.push(pe);
        continue;
      }

      pe.associatedEvents.addEventSet(frameEvents);
      newPEs.push(pe);
    }

    return newPEs;
  }

  /**
   * Check that none of the handlers accidentally ignored an input event.
   */
  function checkAllInputEventsHandled(sortedInputEvents, protoExpectations) {
    var handledEvents = [];
    protoExpectations.forEach(function (protoExpectation) {
      protoExpectation.associatedEvents.forEach(function (event) {
        // Ignore CSS Animations that might have multiple active ranges.
        if (event.title === CSS_ANIMATION_TITLE && event.subSlices.length > 0) return;

        if (handledEvents.indexOf(event) >= 0 && event.title !== tr.model.helpers.IMPL_RENDERING_STATS) {
          console.error('double-handled event', event.typeName, parseInt(event.start), parseInt(event.end), protoExpectation);
          return;
        }
        handledEvents.push(event);
      });
    });

    sortedInputEvents.forEach(function (event) {
      if (handledEvents.indexOf(event) < 0) {
        console.error('UNHANDLED INPUT EVENT!', event.typeName, parseInt(event.start), parseInt(event.end));
      }
    });
  }

  /**
   * Find ProtoExpectations, post-process them, convert them to real IRs.
   */
  function findInputExpectations(modelHelper) {
    var sortedInputEvents = getSortedInputEvents(modelHelper);
    var protoExpectations = findProtoExpectations(modelHelper, sortedInputEvents);
    protoExpectations = postProcessProtoExpectations(modelHelper, protoExpectations);
    checkAllInputEventsHandled(sortedInputEvents, protoExpectations);

    var irs = [];
    protoExpectations.forEach(function (protoExpectation) {
      var ir = protoExpectation.createInteractionRecord(modelHelper.model);
      if (ir) irs.push(ir);
    });
    return irs;
  }

  return {
    findInputExpectations: findInputExpectations,
    compareEvents: compareEvents,
    CSS_ANIMATION_TITLE: CSS_ANIMATION_TITLE
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/range_utils.js":48,"../extras/chrome/cc/input_latency_async_slice.js":62,"./proto_expectation.js":77}],73:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../model/user_model/load_expectation.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  // This global instant event marks the start of a navigation.
  var NAVIGATION_START = 'NavigationTiming navigationStart';

  // This render-process instant event marks the first contentful paint in a
  // main frame.
  var FIRST_CONTENTFUL_PAINT_TITLE = 'firstContentfulPaint';

  function findLoadExpectations(modelHelper) {
    var events = [];
    for (var event of modelHelper.model.getDescendantEvents()) {
      if (event.title === NAVIGATION_START || event.title === FIRST_CONTENTFUL_PAINT_TITLE) events.push(event);
    }
    events.sort(tr.importer.compareEvents);

    var loads = [];
    var startEvent = undefined;
    // TODO(alexandermont): What's supposed to happen if there are two
    // NAVIGATION_STARTs with no FIRST_CONTENTFUL_PAINT_TITLE between
    // them? Are you supposed to just "lose" the first NAVIGATION_START,
    // like what's happening now?
    for (var event of events) {
      if (event.title === NAVIGATION_START) {
        startEvent = event;
      } else if (event.title === FIRST_CONTENTFUL_PAINT_TITLE) {
        if (startEvent) {
          loads.push(new tr.model.um.LoadExpectation(modelHelper.model, tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL, startEvent.start, event.start - startEvent.start));
          startEvent = undefined;
        }
      }
    }

    // If the trace ended between navigation start and first contentful paint,
    // then make a LoadExpectation that ends at the end of the trace.
    if (startEvent) {
      loads.push(new tr.model.um.LoadExpectation(modelHelper.model, tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL, startEvent.start, modelHelper.model.bounds.max - startEvent.start));
    }

    return loads;
  }

  return {
    findLoadExpectations: findLoadExpectations
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../model/user_model/load_expectation.js":163}],74:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../model/user_model/startup_expectation.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  function getAllFrameEvents(modelHelper) {
    var frameEvents = [];
    frameEvents.push.apply(frameEvents, modelHelper.browserHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE, modelHelper.model.bounds));

    tr.b.iterItems(modelHelper.rendererHelpers, function (pid, renderer) {
      frameEvents.push.apply(frameEvents, renderer.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE, modelHelper.model.bounds));
    });
    return frameEvents.sort(tr.importer.compareEvents);
  }

  // If a thread contains a typical initialization slice, then the first event
  // on that thread is a startup event.
  function getStartupEvents(modelHelper) {
    function isStartupSlice(slice) {
      return slice.title === 'BrowserMainLoop::CreateThreads';
    }
    var events = modelHelper.browserHelper.getAllAsyncSlicesMatching(isStartupSlice);
    var deduper = new tr.model.EventSet();
    events.forEach(function (event) {
      var sliceGroup = event.parentContainer.sliceGroup;
      var slice = sliceGroup && sliceGroup.findFirstSlice();
      if (slice) deduper.push(slice);
    });
    return deduper.toArray();
  }

  // Match every event in |openingEvents| to the first following event from
  // |closingEvents| and return an array containing a load interaction record
  // for each pair.
  function findStartupExpectations(modelHelper) {
    var openingEvents = getStartupEvents(modelHelper);
    var closingEvents = getAllFrameEvents(modelHelper);
    var startups = [];
    openingEvents.forEach(function (openingEvent) {
      closingEvents.forEach(function (closingEvent) {
        // Ignore opening event that already have a closing event.
        if (openingEvent.closingEvent) return;

        // Ignore closing events that already belong to an opening event.
        if (closingEvent.openingEvent) return;

        // Ignore closing events before |openingEvent|.
        if (closingEvent.start <= openingEvent.start) return;

        // Ignore events from different threads.
        if (openingEvent.parentContainer.parent.pid !== closingEvent.parentContainer.parent.pid) return;

        // This is the first closing event for this opening event, record it.
        openingEvent.closingEvent = closingEvent;
        closingEvent.openingEvent = openingEvent;
        var se = new tr.model.um.StartupExpectation(modelHelper.model, openingEvent.start, closingEvent.end - openingEvent.start);
        se.associatedEvents.push(openingEvent);
        se.associatedEvents.push(closingEvent);
        startups.push(se);
      });
    });
    return startups;
  }

  return {
    findStartupExpectations: findStartupExpectations
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../model/user_model/startup_expectation.js":165}],75:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/timing.js");
require("./empty_importer.js");
require("./importer.js");
require("./user_model_builder.js");
require("../ui/base/overlay.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  var Timing = tr.b.Timing;

  function ImportOptions() {
    this.shiftWorldToZero = true;
    this.pruneEmptyContainers = true;
    this.showImportWarnings = true;
    this.trackDetailedModelStats = false;

    // Callback called after
    // importers run in which more data can be added to the model, before it is
    // finalized.
    this.customizeModelCallback = undefined;

    var auditorTypes = tr.c.Auditor.getAllRegisteredTypeInfos();
    this.auditorConstructors = auditorTypes.map(function (typeInfo) {
      return typeInfo.constructor;
    });
  }

  function Import(model, opt_options) {
    if (model === undefined) throw new Error('Must provide model to import into.');

    // TODO(dsinclair): Check the model is empty.

    this.importing_ = false;
    this.importOptions_ = opt_options || new ImportOptions();

    this.model_ = model;
    this.model_.importOptions = this.importOptions_;
  }

  Import.prototype = {
    __proto__: Object.prototype,

    /**
     * Imports the provided traces into the model. The eventData type
     * is undefined and will be passed to all the importers registered
     * via Importer.register. The first importer that returns true
     * for canImport(events) will be used to import the events.
     *
     * The primary trace is provided via the eventData variable. If multiple
     * traces are to be imported, specify the first one as events, and the
     * remainder in the opt_additionalEventData array.
     *
     * @param {Array} traces An array of eventData to be imported. Each
     * eventData should correspond to a single trace file and will be handled by
     * a separate importer.
     */
    importTraces: function (traces) {
      var progressMeter = {
        update: function (msg) {}
      };

      tr.b.Task.RunSynchronously(this.createImportTracesTask(progressMeter, traces));
    },

    /**
     * Imports a trace with the usual options from importTraces, but
     * does so using idle callbacks, putting up an import dialog
     * during the import process.
     */
    importTracesWithProgressDialog: function (traces) {
      if (tr.isHeadless) throw new Error('Cannot use this method in headless mode.');

      var overlay = tr.ui.b.Overlay();
      overlay.title = 'Importing...';
      overlay.userCanClose = false;
      overlay.msgEl = document.createElement('div');
      Polymer.dom(overlay).appendChild(overlay.msgEl);
      overlay.msgEl.style.margin = '20px';
      overlay.update = function (msg) {
        Polymer.dom(this.msgEl).textContent = msg;
      };
      overlay.visible = true;

      var promise = tr.b.Task.RunWhenIdle(this.createImportTracesTask(overlay, traces));
      promise.then(function () {
        overlay.visible = false;
      }, function (err) {
        overlay.visible = false;
      });
      return promise;
    },

    /**
     * Creates a task that will import the provided traces into the model,
     * updating the progressMeter as it goes. Parameters are as defined in
     * importTraces.
     */
    createImportTracesTask: function (progressMeter, traces) {
      if (this.importing_) throw new Error('Already importing.');
      this.importing_ = true;

      // Just some simple setup. It is useful to have a no-op first
      // task so that we can set up the lastTask = lastTask.after()
      // pattern that follows.
      var importTask = new tr.b.Task(function prepareImport() {
        progressMeter.update('I will now import your traces for you...');
      }, this);
      var lastTask = importTask;

      var importers = [];

      lastTask = lastTask.timedAfter('TraceImport', function createImports() {
        // Copy the traces array, we may mutate it.
        traces = traces.slice(0);
        progressMeter.update('Creating importers...');
        // Figure out which importers to use.
        for (var i = 0; i < traces.length; ++i) importers.push(this.createImporter_(traces[i]));

        // Some traces have other traces inside them. Before doing the full
        // import, ask the importer if it has any subtraces, and if so, create
        // importers for them, also.
        for (var i = 0; i < importers.length; i++) {
          var subtraces = importers[i].extractSubtraces();
          for (var j = 0; j < subtraces.length; j++) {
            try {
              traces.push(subtraces[j]);
              importers.push(this.createImporter_(subtraces[j]));
            } catch (error) {
              // TODO(kphanee): Log the subtrace file which has failed.
              console.warn(error.name + ': ' + error.message);
              continue;
            }
          }
        }

        if (traces.length && !this.hasEventDataDecoder_(importers)) {
          throw new Error('Could not find an importer for the provided eventData.');
        }

        // Sort them on priority. This ensures importing happens in a
        // predictable order, e.g. ftrace_importer before
        // trace_event_importer.
        importers.sort(function (x, y) {
          return x.importPriority - y.importPriority;
        });
      }, this);

      // We import clock sync markers before all other events. This is necessary
      // because we need the clock sync markers in order to know by how much we
      // need to shift the timestamps of other events.
      lastTask = lastTask.timedAfter('TraceImport', function importClockSyncMarkers(task) {
        importers.forEach(function (importer, index) {
          task.subTask(Timing.wrapNamedFunction('TraceImport', importer.importerName, function runImportClockSyncMarkersOnOneImporter() {
            progressMeter.update('Importing clock sync markers ' + (index + 1) + ' of ' + importers.length);
            importer.importClockSyncMarkers();
          }), this);
        }, this);
      }, this);

      // Run the import.
      lastTask = lastTask.timedAfter('TraceImport', function runImport(task) {
        importers.forEach(function (importer, index) {
          task.subTask(Timing.wrapNamedFunction('TraceImport', importer.importerName, function runImportEventsOnOneImporter() {
            progressMeter.update('Importing ' + (index + 1) + ' of ' + importers.length);
            importer.importEvents();
          }), this);
        }, this);
      }, this);

      // Run the cusomizeModelCallback if needed.
      if (this.importOptions_.customizeModelCallback) {
        lastTask = lastTask.timedAfter('TraceImport', function runCustomizeCallbacks(task) {
          this.importOptions_.customizeModelCallback(this.model_);
        }, this);
      }

      // Import sample data.
      lastTask = lastTask.timedAfter('TraceImport', function importSampleData(task) {
        importers.forEach(function (importer, index) {
          progressMeter.update('Importing sample data ' + (index + 1) + '/' + importers.length);
          importer.importSampleData();
        }, this);
      }, this);

      // Autoclose open slices and create subSlices.
      lastTask = lastTask.timedAfter('TraceImport', function runAutoclosers() {
        progressMeter.update('Autoclosing open slices...');
        this.model_.autoCloseOpenSlices();
        this.model_.createSubSlices();
      }, this);

      // Finalize import.
      lastTask = lastTask.timedAfter('TraceImport', function finalizeImport(task) {
        importers.forEach(function (importer, index) {
          progressMeter.update('Finalizing import ' + (index + 1) + '/' + importers.length);
          importer.finalizeImport();
        }, this);
      }, this);

      // Run preinit.
      lastTask = lastTask.timedAfter('TraceImport', function runPreinits() {
        progressMeter.update('Initializing objects (step 1/2)...');
        this.model_.preInitializeObjects();
      }, this);

      // Prune empty containers.
      if (this.importOptions_.pruneEmptyContainers) {
        lastTask = lastTask.timedAfter('TraceImport', function runPruneEmptyContainers() {
          progressMeter.update('Pruning empty containers...');
          this.model_.pruneEmptyContainers();
        }, this);
      }

      // Merge kernel and userland slices on each thread.
      lastTask = lastTask.timedAfter('TraceImport', function runMergeKernelWithuserland() {
        progressMeter.update('Merging kernel with userland...');
        this.model_.mergeKernelWithUserland();
      }, this);

      // Create auditors
      var auditors = [];
      lastTask = lastTask.timedAfter('TraceImport', function createAuditorsAndRunAnnotate() {
        progressMeter.update('Adding arbitrary data to model...');
        auditors = this.importOptions_.auditorConstructors.map(function (auditorConstructor) {
          return new auditorConstructor(this.model_);
        }, this);
        auditors.forEach(function (auditor) {
          auditor.runAnnotate();
          auditor.installUserFriendlyCategoryDriverIfNeeded();
        });
      }, this);

      lastTask = lastTask.timedAfter('TraceImport', function computeWorldBounds() {
        progressMeter.update('Computing final world bounds...');
        this.model_.computeWorldBounds(this.importOptions_.shiftWorldToZero);
      }, this);

      // Build the flow event interval tree.
      lastTask = lastTask.timedAfter('TraceImport', function buildFlowEventIntervalTree() {
        progressMeter.update('Building flow event map...');
        this.model_.buildFlowEventIntervalTree();
      }, this);

      // Join refs.
      lastTask = lastTask.timedAfter('TraceImport', function joinRefs() {
        progressMeter.update('Joining object refs...');
        this.model_.joinRefs();
      }, this);

      // Delete any undeleted objects.
      lastTask = lastTask.timedAfter('TraceImport', function cleanupUndeletedObjects() {
        progressMeter.update('Cleaning up undeleted objects...');
        this.model_.cleanupUndeletedObjects();
      }, this);

      // Sort global and process memory dumps.
      lastTask = lastTask.timedAfter('TraceImport', function sortMemoryDumps() {
        progressMeter.update('Sorting memory dumps...');
        this.model_.sortMemoryDumps();
      }, this);

      // Finalize memory dump graphs.
      lastTask = lastTask.timedAfter('TraceImport', function finalizeMemoryGraphs() {
        progressMeter.update('Finalizing memory dump graphs...');
        this.model_.finalizeMemoryGraphs();
      }, this);

      // Run initializers.
      lastTask = lastTask.timedAfter('TraceImport', function initializeObjects() {
        progressMeter.update('Initializing objects (step 2/2)...');
        this.model_.initializeObjects();
      }, this);

      // Build event indices mapping from an event id to all flow events.
      lastTask = lastTask.timedAfter('TraceImport', function buildEventIndices() {
        progressMeter.update('Building event indices...');
        this.model_.buildEventIndices();
      }, this);

      // Build the UserModel.
      lastTask = lastTask.timedAfter('TraceImport', function buildUserModel() {
        progressMeter.update('Building UserModel...');
        var userModelBuilder = new tr.importer.UserModelBuilder(this.model_);
        userModelBuilder.buildUserModel();
      }, this);

      // Sort Expectations.
      lastTask = lastTask.timedAfter('TraceImport', function sortExpectations() {
        progressMeter.update('Sorting user expectations...');
        this.model_.userModel.sortExpectations();
      }, this);

      // Run audits.
      lastTask = lastTask.timedAfter('TraceImport', function runAudits() {
        progressMeter.update('Running auditors...');
        auditors.forEach(function (auditor) {
          auditor.runAudit();
        });
      }, this);

      lastTask = lastTask.timedAfter('TraceImport', function sortAlerts() {
        progressMeter.update('Updating alerts...');
        this.model_.sortAlerts();
      }, this);

      lastTask = lastTask.timedAfter('TraceImport', function lastUpdateBounds() {
        progressMeter.update('Update bounds...');
        this.model_.updateBounds();
      }, this);

      lastTask = lastTask.timedAfter('TraceImport', function addModelWarnings() {
        progressMeter.update('Looking for warnings...');
        // Log an import warning if the clock is low resolution.
        if (!this.model_.isTimeHighResolution) {
          this.model_.importWarning({
            type: 'low_resolution_timer',
            message: 'Trace time is low resolution, trace may be unusable.',
            showToUser: true
          });
        }
      }, this);

      // Cleanup.
      lastTask.after(function () {
        this.importing_ = false;
      }, this);
      return importTask;
    },

    createImporter_: function (eventData) {
      var importerConstructor = tr.importer.Importer.findImporterFor(eventData);
      if (!importerConstructor) {
        throw new Error('Couldn\'t create an importer for the provided ' + 'eventData.');
      }
      return new importerConstructor(this.model_, eventData);
    },

    hasEventDataDecoder_: function (importers) {
      for (var i = 0; i < importers.length; ++i) {
        if (!importers[i].isTraceDataContainer()) return true;
      }

      return false;
    }
  };

  return {
    ImportOptions: ImportOptions,
    Import: Import
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/timing.js":56,"../ui/base/overlay.js":174,"./empty_importer.js":71,"./importer.js":76,"./user_model_builder.js":78}],76:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/extension_registry.js");

'use strict';

/**
 * @fileoverview Base class for trace data importers.
 */
global.tr.exportTo('tr.importer', function () {
  function Importer() {}

  Importer.prototype = {
    __proto__: Object.prototype,

    get importerName() {
      return 'Importer';
    },

    /**
     * Called by the Model to check whether the importer type stores the actual
     * trace data or just holds it as container for further extraction.
     */
    isTraceDataContainer: function () {
      return false;
    },

    /**
     * Called by the Model to extract one or more subtraces from the event data.
     */
    extractSubtraces: function () {
      return [];
    },

    /**
     * Called to import clock sync markers into the Model.
     */
    importClockSyncMarkers: function () {},

    /**
     * Called to import events into the Model.
     */
    importEvents: function () {},

    /**
     * Called to import sample data into the Model.
     */
    importSampleData: function () {},

    /**
     * Called by the Model after all other importers have imported their
     * events.
     */
    finalizeImport: function () {}
  };

  var options = new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);
  options.defaultMetadata = {};
  options.mandatoryBaseClass = Importer;
  tr.b.decorateExtensionRegistry(Importer, options);

  Importer.findImporterFor = function (eventData) {
    var typeInfo = Importer.findTypeInfoMatching(function (ti) {
      return ti.constructor.canImport(eventData);
    });
    if (typeInfo) return typeInfo.constructor;
    return undefined;
  };

  return {
    Importer: Importer
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/extension_registry.js":35}],77:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/range_utils.js");
require("../core/auditor.js");
require("../model/event_info.js");
require("../model/user_model/animation_expectation.js");
require("../model/user_model/response_expectation.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  // This is an intermediate data format between InputLatencyAsyncSlices and
  // Response and Animation IRs.
  function ProtoExpectation(irType, name) {
    this.irType = irType;
    this.names = new Set(name ? [name] : undefined);
    this.start = Infinity;
    this.end = -Infinity;
    this.associatedEvents = new tr.model.EventSet();
    this.isAnimationBegin = false;
  }

  ProtoExpectation.RESPONSE_TYPE = 'r';
  ProtoExpectation.ANIMATION_TYPE = 'a';

  // Explicitly ignore some input events to allow
  // UserModelBuilder.checkAllInputEventsHandled() to determine which events
  // were unintentionally ignored due to a bug.
  ProtoExpectation.IGNORED_TYPE = 'ignored';

  ProtoExpectation.prototype = {
    get isValid() {
      return this.end > this.start;
    },

    // Return true if any associatedEvent's typeName is in typeNames.
    containsTypeNames: function (typeNames) {
      return this.associatedEvents.some(x => typeNames.indexOf(x.typeName) >= 0);
    },

    containsSliceTitle: function (title) {
      return this.associatedEvents.some(x => title === x.title);
    },

    createInteractionRecord: function (model) {
      if (!this.isValid) {
        console.error('Invalid ProtoExpectation: ' + this.debug() + ' File a bug with this trace!');
        return undefined;
      }

      var initiatorTitles = [];
      this.names.forEach(function (name) {
        initiatorTitles.push(name);
      });
      initiatorTitles = initiatorTitles.sort().join(',');

      var duration = this.end - this.start;

      var ir = undefined;
      switch (this.irType) {
        case ProtoExpectation.RESPONSE_TYPE:
          ir = new tr.model.um.ResponseExpectation(model, initiatorTitles, this.start, duration, this.isAnimationBegin);
          break;
        case ProtoExpectation.ANIMATION_TYPE:
          ir = new tr.model.um.AnimationExpectation(model, initiatorTitles, this.start, duration);
          break;
      }
      if (!ir) return undefined;

      ir.sourceEvents.addEventSet(this.associatedEvents);

      function pushAssociatedEvents(event) {
        ir.associatedEvents.push(event);

        // |event| is either an InputLatencyAsyncSlice (which collects all of
        // its associated events transitively) or a CSS Animation (which doesn't
        // have any associated events). So this does not need to recurse.
        if (event.associatedEvents) ir.associatedEvents.addEventSet(event.associatedEvents);
      }

      this.associatedEvents.forEach(function (event) {
        pushAssociatedEvents(event);

        // Old-style InputLatencyAsyncSlices have subSlices.
        if (event.subSlices) event.subSlices.forEach(pushAssociatedEvents);
      });

      return ir;
    },

    // Merge the other ProtoExpectation into this one.
    // The irTypes need not match: ignored ProtoExpectations might be merged
    // into overlapping ProtoExpectations, and Touch-only Animations are merged
    // into Tap Responses.
    merge: function (other) {
      other.names.forEach(function (name) {
        this.names.add(name);
      }.bind(this));

      // Don't use pushEvent(), which would lose special start, end.
      this.associatedEvents.addEventSet(other.associatedEvents);
      this.start = Math.min(this.start, other.start);
      this.end = Math.max(this.end, other.end);
      if (other.isAnimationBegin) this.isAnimationBegin = true;
    },

    // Include |event| in this ProtoExpectation, expanding start/end to include
    // it.
    pushEvent: function (event) {
      // Usually, this method will be called while iterating over a list of
      // events sorted by start time, so this method won't usually change
      // this.start. However, this will sometimes be called for
      // ProtoExpectations created by previous handlers, in which case
      // event.start could possibly be before this.start.
      this.start = Math.min(this.start, event.start);
      this.end = Math.max(this.end, event.end);
      this.associatedEvents.push(event);
    },

    // Returns true if timestamp is contained in this ProtoExpectation.
    containsTimestampInclusive: function (timestamp) {
      return this.start <= timestamp && timestamp <= this.end;
    },

    // Return true if the other event intersects this ProtoExpectation.
    intersects: function (other) {
      // http://stackoverflow.com/questions/325933
      return other.start < this.end && other.end > this.start;
    },

    isNear: function (event, threshold) {
      return this.end + threshold > event.start;
    },

    // Return a string describing this ProtoExpectation for debugging.
    debug: function () {
      var debugString = this.irType + '(';
      debugString += parseInt(this.start) + ' ';
      debugString += parseInt(this.end);
      this.associatedEvents.forEach(function (event) {
        debugString += ' ' + event.typeName;
      });
      return debugString + ')';
    }
  };

  return {
    ProtoExpectation: ProtoExpectation
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/range_utils.js":48,"../core/auditor.js":60,"../model/event_info.js":118,"../model/user_model/animation_expectation.js":161,"../model/user_model/response_expectation.js":164}],78:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/range_utils.js");
require("../core/auditor.js");
require("../extras/chrome/cc/input_latency_async_slice.js");
require("./find_input_expectations.js");
require("./find_load_expectations.js");
require("./find_startup_expectations.js");
require("../model/event_info.js");
require("../model/ir_coverage.js");
require("../model/user_model/idle_expectation.js");

'use strict';

global.tr.exportTo('tr.importer', function () {
  var INSIGNIFICANT_MS = 1;

  function UserModelBuilder(model) {
    this.model = model;
    this.modelHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
  };

  UserModelBuilder.supportsModelHelper = function (modelHelper) {
    return modelHelper.browserHelper !== undefined;
  };

  UserModelBuilder.prototype = {
    buildUserModel: function () {
      if (!this.modelHelper || !this.modelHelper.browserHelper) return;

      var expectations = undefined;
      try {
        expectations = this.findUserExpectations();
        // There are not currently any known cases when this could throw.
      } catch (error) {
        this.model.importWarning({
          type: 'UserModelBuilder',
          message: error,
          showToUser: true
        });
        return;
      }
      expectations.forEach(function (expectation) {
        this.model.userModel.expectations.push(expectation);
      }, this);

      // TODO(benjhayden) Find Gestures here.
    },

    findUserExpectations: function () {
      var expectations = [];
      expectations.push.apply(expectations, tr.importer.findStartupExpectations(this.modelHelper));
      expectations.push.apply(expectations, tr.importer.findLoadExpectations(this.modelHelper));
      expectations.push.apply(expectations, tr.importer.findInputExpectations(this.modelHelper));
      // findIdleExpectations must be called last!
      expectations.push.apply(expectations, this.findIdleExpectations(expectations));
      this.collectUnassociatedEvents_(expectations);
      return expectations;
    },

    // Find all unassociated top-level ThreadSlices. If they start during an
    // Idle or Load IR, then add their entire hierarchy to that IR.
    collectUnassociatedEvents_: function (rirs) {
      var vacuumIRs = [];
      rirs.forEach(function (ir) {
        if (ir instanceof tr.model.um.IdleExpectation || ir instanceof tr.model.um.LoadExpectation || ir instanceof tr.model.um.StartupExpectation) vacuumIRs.push(ir);
      });
      if (vacuumIRs.length === 0) return;

      var allAssociatedEvents = tr.model.getAssociatedEvents(rirs);
      var unassociatedEvents = tr.model.getUnassociatedEvents(this.model, allAssociatedEvents);

      unassociatedEvents.forEach(function (event) {
        if (!(event instanceof tr.model.ThreadSlice)) return;

        if (!event.isTopLevel) return;

        for (var iri = 0; iri < vacuumIRs.length; ++iri) {
          var ir = vacuumIRs[iri];

          if (event.start >= ir.start && event.start < ir.end) {
            ir.associatedEvents.addEventSet(event.entireHierarchy);
            return;
          }
        }
      });
    },

    // Fill in the empty space between IRs with IdleIRs.
    findIdleExpectations: function (otherIRs) {
      if (this.model.bounds.isEmpty) return;
      var emptyRanges = tr.b.findEmptyRangesBetweenRanges(tr.b.convertEventsToRanges(otherIRs), this.model.bounds);
      var irs = [];
      var model = this.model;
      emptyRanges.forEach(function (range) {
        // Ignore insignificantly tiny idle ranges.
        if (range.max < range.min + INSIGNIFICANT_MS) return;
        irs.push(new tr.model.um.IdleExpectation(model, range.min, range.max - range.min));
      });
      return irs;
    }
  };

  function createCustomizeModelLinesFromModel(model) {
    var modelLines = [];
    modelLines.push('      audits.addEvent(model.browserMain,');
    modelLines.push('          {title: \'model start\', start: 0, end: 1});');

    var typeNames = {};
    for (var typeName in tr.e.cc.INPUT_EVENT_TYPE_NAMES) {
      typeNames[tr.e.cc.INPUT_EVENT_TYPE_NAMES[typeName]] = typeName;
    }

    var modelEvents = new tr.model.EventSet();
    model.userModel.expectations.forEach(function (ir, index) {
      modelEvents.addEventSet(ir.sourceEvents);
    });
    modelEvents = modelEvents.toArray();
    modelEvents.sort(tr.importer.compareEvents);

    modelEvents.forEach(function (event) {
      var startAndEnd = 'start: ' + parseInt(event.start) + ', ' + 'end: ' + parseInt(event.end) + '});';
      if (event instanceof tr.e.cc.InputLatencyAsyncSlice) {
        modelLines.push('      audits.addInputEvent(model, INPUT_TYPE.' + typeNames[event.typeName] + ',');
      } else if (event.title === 'RenderFrameImpl::didCommitProvisionalLoad') {
        modelLines.push('      audits.addCommitLoadEvent(model,');
      } else if (event.title === 'InputHandlerProxy::HandleGestureFling::started') {
        modelLines.push('      audits.addFlingAnimationEvent(model,');
      } else if (event.title === tr.model.helpers.IMPL_RENDERING_STATS) {
        modelLines.push('      audits.addFrameEvent(model,');
      } else if (event.title === tr.importer.CSS_ANIMATION_TITLE) {
        modelLines.push('      audits.addEvent(model.rendererMain, {');
        modelLines.push('        title: \'Animation\', ' + startAndEnd);
        return;
      } else {
        throw 'You must extend createCustomizeModelLinesFromModel()' + 'to support this event:\n' + event.title + '\n';
      }
      modelLines.push('          {' + startAndEnd);
    });

    modelLines.push('      audits.addEvent(model.browserMain,');
    modelLines.push('          {' + 'title: \'model end\', ' + 'start: ' + (parseInt(model.bounds.max) - 1) + ', ' + 'end: ' + parseInt(model.bounds.max) + '});');
    return modelLines;
  }

  function createExpectedIRLinesFromModel(model) {
    var expectedLines = [];
    var irCount = model.userModel.expectations.length;
    model.userModel.expectations.forEach(function (ir, index) {
      var irString = '      {';
      irString += 'title: \'' + ir.title + '\', ';
      irString += 'start: ' + parseInt(ir.start) + ', ';
      irString += 'end: ' + parseInt(ir.end) + ', ';
      irString += 'eventCount: ' + ir.sourceEvents.length;
      irString += '}';
      if (index < irCount - 1) irString += ',';
      expectedLines.push(irString);
    });
    return expectedLines;
  }

  function createIRFinderTestCaseStringFromModel(model) {
    var filename = window.location.hash.substr(1);
    var testName = filename.substr(filename.lastIndexOf('/') + 1);
    testName = testName.substr(0, testName.indexOf('.'));

    // createCustomizeModelLinesFromModel() throws an error if there's an
    // unsupported event.
    try {
      var testLines = [];
      testLines.push('  /*');
      testLines.push('    This test was generated from');
      testLines.push('    ' + filename + '');
      testLines.push('   */');
      testLines.push('  test(\'' + testName + '\', function() {');
      testLines.push('    var verifier = new UserExpectationVerifier();');
      testLines.push('    verifier.customizeModelCallback = function(model) {');
      testLines.push.apply(testLines, createCustomizeModelLinesFromModel(model));
      testLines.push('    };');
      testLines.push('    verifier.expectedIRs = [');
      testLines.push.apply(testLines, createExpectedIRLinesFromModel(model));
      testLines.push('    ];');
      testLines.push('    verifier.verify();');
      testLines.push('  });');
      return testLines.join('\n');
    } catch (error) {
      return error;
    }
  }

  return {
    UserModelBuilder: UserModelBuilder,
    createIRFinderTestCaseStringFromModel: createIRFinderTestCaseStringFromModel
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/range_utils.js":48,"../core/auditor.js":60,"../extras/chrome/cc/input_latency_async_slice.js":62,"../model/event_info.js":118,"../model/ir_coverage.js":131,"../model/user_model/idle_expectation.js":162,"./find_input_expectations.js":72,"./find_load_expectations.js":73,"./find_startup_expectations.js":74}],79:[function(require,module,exports){
"use strict";
/**
Copyright (c) 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./importer/import.js");
require("./model/model.js");
require("./extras/lean_config.js");
require("./metrics/all_metrics.js");
},{"./extras/lean_config.js":69,"./importer/import.js":75,"./metrics/all_metrics.js":80,"./model/model.js":135}],80:[function(require,module,exports){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("./blink/gc_metric.js");
require("./cpu_process_metric.js");
require("./sample_metric.js");
require("./system_health/clock_sync_latency_metric.js");
require("./system_health/hazard_metric.js");
require("./system_health/loading_metric.js");
require("./system_health/memory_metric.js");
require("./system_health/power_metric.js");
require("./system_health/responsiveness_metric.js");
require("./system_health/system_health_metrics.js");
require("./system_health/webview_startup_metric.js");
require("./tracing_metric.js");
require("./v8/execution_metric.js");
require("./v8/gc_metric.js");
require("./v8/v8_metrics.js");
},{"./blink/gc_metric.js":81,"./cpu_process_metric.js":82,"./sample_metric.js":84,"./system_health/clock_sync_latency_metric.js":85,"./system_health/hazard_metric.js":87,"./system_health/loading_metric.js":88,"./system_health/memory_metric.js":90,"./system_health/power_metric.js":91,"./system_health/responsiveness_metric.js":92,"./system_health/system_health_metrics.js":93,"./system_health/webview_startup_metric.js":95,"./tracing_metric.js":96,"./v8/execution_metric.js":97,"./v8/gc_metric.js":98,"./v8/v8_metrics.js":100}],81:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/range.js");
require("../../base/unit.js");
require("../metric_registry.js");
require("../v8/utils.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.blink', function () {
  // Maps the Blink GC events in timeline to telemetry friendly names.
  var BLINK_GC_EVENTS = {
    'BlinkGCMarking': 'blink-gc-marking',
    'ThreadState::completeSweep': 'blink-gc-complete-sweep',
    'ThreadState::performIdleLazySweep': 'blink-gc-idle-lazy-sweep'
  };

  function isBlinkGarbageCollectionEvent(event) {
    return event.title in BLINK_GC_EVENTS;
  }

  function blinkGarbageCollectionEventName(event) {
    return BLINK_GC_EVENTS[event.title];
  }

  function blinkGcMetric(values, model) {
    addDurationOfTopEvents(values, model);
    addTotalDurationOfTopEvents(values, model);
    addIdleTimesOfTopEvents(values, model);
    addTotalIdleTimesOfTopEvents(values, model);
  }

  tr.metrics.MetricRegistry.register(blinkGcMetric);

  var timeDurationInMs_smallerIsBetter = tr.b.Unit.byName.timeDurationInMs_smallerIsBetter;
  var percentage_biggerIsBetter = tr.b.Unit.byName.normalizedPercentage_biggerIsBetter;

  // 0.1 steps from 0 to 20 since it is the most common range.
  // Exponentially increasing steps from 20 to 200.
  var CUSTOM_BOUNDARIES = tr.v.HistogramBinBoundaries.createLinear(0, 20, 200).addExponentialBins(200, 100);

  function createNumericForTopEventTime(name) {
    var n = new tr.v.Histogram(name, timeDurationInMs_smallerIsBetter, CUSTOM_BOUNDARIES);
    n.customizeSummaryOptions({
      avg: true,
      count: true,
      max: true,
      min: false,
      std: true,
      sum: true,
      percentile: [0.90] });
    return n;
  }

  function createNumericForIdleTime(name) {
    var n = new tr.v.Histogram(name, timeDurationInMs_smallerIsBetter, CUSTOM_BOUNDARIES);
    n.customizeSummaryOptions({
      avg: true,
      count: false,
      max: true,
      min: false,
      std: false,
      sum: true,
      percentile: []
    });
    return n;
  }

  function createPercentage(name, numerator, denominator) {
    var histogram = new tr.v.Histogram(name, percentage_biggerIsBetter);
    if (denominator === 0) histogram.addSample(0);else histogram.addSample(numerator / denominator);
    return histogram;
  }

  /**
   * Example output:
   * - blink-gc-marking.
   */
  function addDurationOfTopEvents(values, model) {
    tr.metrics.v8.utils.groupAndProcessEvents(model, isBlinkGarbageCollectionEvent, blinkGarbageCollectionEventName, function (name, events) {
      var cpuDuration = createNumericForTopEventTime(name);
      events.forEach(function (event) {
        cpuDuration.addSample(event.cpuDuration);
      });
      values.addHistogram(cpuDuration);
    });
  }

  /**
   * Example output:
   * - blink-gc-total
   */
  function addTotalDurationOfTopEvents(values, model) {
    tr.metrics.v8.utils.groupAndProcessEvents(model, isBlinkGarbageCollectionEvent, event => 'blink-gc-total', function (name, events) {
      var cpuDuration = createNumericForTopEventTime(name);
      events.forEach(function (event) {
        cpuDuration.addSample(event.cpuDuration);
      });
      values.addHistogram(cpuDuration);
    });
  }

  /**
   * Example output:
   * - blink-gc-marking_idle_deadline_overrun,
   * - blink-gc-marking_outside_idle,
   * - blink-gc-marking_percentage_idle.
   */
  function addIdleTimesOfTopEvents(values, model) {
    tr.metrics.v8.utils.groupAndProcessEvents(model, isBlinkGarbageCollectionEvent, blinkGarbageCollectionEventName, function (name, events) {
      addIdleTimes(values, model, name, events);
    });
  }

  /**
   * Example output:
   * - blink-gc-total_idle_deadline_overrun,
   * - blink-gc-total_outside_idle,
   * - blink-gc-total_percentage_idle.
   */
  function addTotalIdleTimesOfTopEvents(values, model) {
    tr.metrics.v8.utils.groupAndProcessEvents(model, isBlinkGarbageCollectionEvent, event => 'blink-gc-total', function (name, events) {
      addIdleTimes(values, model, name, events);
    });
  }

  function addIdleTimes(values, model, name, events) {
    var cpuDuration = createNumericForIdleTime(name + '_cpu');
    var insideIdle = createNumericForIdleTime(name + '_inside_idle');
    var outsideIdle = createNumericForIdleTime(name + '_outside_idle');
    var idleDeadlineOverrun = createNumericForIdleTime(name + '_idle_deadline_overrun');
    events.forEach(function (event) {
      var idleTask = tr.metrics.v8.utils.findParent(event, tr.metrics.v8.utils.isIdleTask);
      var inside = 0;
      var overrun = 0;
      if (idleTask) {
        var allottedTime = idleTask['args']['allotted_time_ms'];
        if (event.duration > allottedTime) {
          overrun = event.duration - allottedTime;
          // Don't count time over the deadline as being inside idle time.
          // Since the deadline should be relative to wall clock we
          // compare allotted_time_ms with wall duration instead of thread
          // duration, and then assume the thread duration was inside idle
          // for the same percentage of time.
          inside = event.cpuDuration * allottedTime / event.duration;
        } else {
          inside = event.cpuDuration;
        }
      }
      cpuDuration.addSample(event.cpuDuration);
      insideIdle.addSample(inside);
      outsideIdle.addSample(event.cpuDuration - inside);
      idleDeadlineOverrun.addSample(overrun);
    });
    values.addHistogram(idleDeadlineOverrun);
    values.addHistogram(outsideIdle);
    var percentage = createPercentage(name + '_percentage_idle', insideIdle.sum, cpuDuration.sum);
    values.addHistogram(percentage);
  }

  return {
    blinkGcMetric: blinkGcMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/range.js":47,"../../base/unit.js":57,"../../value/histogram.js":189,"../metric_registry.js":83,"../v8/utils.js":99}],82:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

require("./metric_registry.js");
require("../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  function getCpuSnapshotsFromModel(model) {
    var snapshots = [];
    for (var pid in model.processes) {
      var snapshotInstances = model.processes[pid].objects.getAllInstancesNamed('CPUSnapshots');
      if (!snapshotInstances) continue;
      for (var object of snapshotInstances[0].snapshots) snapshots.push(object.args.processes);
    }
    return snapshots;
  }

  function getProcessSumsFromSnapshot(snapshot) {
    var processSums = new Map();
    for (var processData of snapshot) {
      var processName = processData.name;
      if (!processSums.has(processName)) processSums.set(processName, { sum: 0.0, paths: new Set() });
      processSums.get(processName).sum += parseFloat(processData.pCpu);
      // The process path may be missing on Windows because of AccessDenied
      // error thrown by psutil package used by CPU tracing agent.
      if (processData.path) processSums.get(processName).paths.add(processData.path);
    }
    return processSums;
  }

  function buildNumericsFromSnapshots(snapshots) {
    var processNumerics = new Map();
    for (var snapshot of snapshots) {
      var processSums = getProcessSumsFromSnapshot(snapshot);
      for (var _ref of processSums.entries()) {
        var _ref2 = _slicedToArray(_ref, 2);

        var processName = _ref2[0];
        var processData = _ref2[1];

        if (!processNumerics.has(processName)) {
          processNumerics.set(processName, {
            numeric: new tr.v.Histogram('cpu:percent:' + processName, tr.b.Unit.byName.normalizedPercentage_smallerIsBetter),
            paths: new Set()
          });
        }
        processNumerics.get(processName).numeric.addSample(processData.sum / 100.0);
        for (var path of processData.paths) processNumerics.get(processName).paths.add(path);
      }
    }
    return processNumerics;
  }

  function cpuProcessMetric(values, model) {
    var snapshots = getCpuSnapshotsFromModel(model);
    var processNumerics = buildNumericsFromSnapshots(snapshots);
    for (var _ref3 of processNumerics) {
      var _ref4 = _slicedToArray(_ref3, 2);

      var processName = _ref4[0];
      var processData = _ref4[1];

      var numeric = processData.numeric;
      // Treat missing snapshots as zeros. A process is missing from a snapshots
      // when its CPU usage was below minimum threshold when the snapshot was
      // taken.
      var missingSnapshotCount = snapshots.length - numeric.numValues;
      for (var i = 0; i < missingSnapshotCount; i++) numeric.addSample(0);
      numeric.diagnostics.set('paths', new tr.v.d.Generic([...processData.paths]));
      values.addHistogram(numeric);
    }
  }

  tr.metrics.MetricRegistry.register(cpuProcessMetric);

  return {
    cpuProcessMetric: cpuProcessMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../value/histogram.js":189,"./metric_registry.js":83}],83:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/base.js");
require("../base/extension_registry.js");
require("../base/iteration_helpers.js");

'use strict';

global.tr.exportTo('tr.metrics', function () {

  function MetricRegistry() {}

  var options = new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);
  options.defaultMetadata = {};
  tr.b.decorateExtensionRegistry(MetricRegistry, options);

  MetricRegistry.addEventListener('will-register', function (e) {
    var metric = e.typeInfo.constructor;
    if (!(metric instanceof Function)) throw new Error('Metrics must be functions');

    if (metric.length < 2) {
      throw new Error('Metrics take a ValueSet and a Model and ' + 'optionally an options dictionary');
    }
  });

  return {
    MetricRegistry: MetricRegistry
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/base.js":28,"../base/extension_registry.js":35,"../base/iteration_helpers.js":41}],84:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../base/range.js");
require("./metric_registry.js");
require("../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics', function () {
  function sampleMetric(values, model) {
    var hist = new tr.v.Histogram('foo', tr.b.Unit.byName.sizeInBytes_smallerIsBetter);
    hist.addSample(9);
    hist.addSample(91, { bar: new tr.v.d.Generic({ hello: 42 }) });

    for (var expectation of model.userModel.expectations) {
      if (expectation instanceof tr.model.um.ResponseExpectation) {} else if (expectation instanceof tr.model.um.AnimationExpectation) {} else if (expectation instanceof tr.model.um.IdleExpectation) {} else if (expectation instanceof tr.model.um.LoadExpectation) {}
    }

    var chromeHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);

    tr.b.iterItems(model.processes, function (pid, process) {});

    values.addHistogram(hist);
  }

  tr.metrics.MetricRegistry.register(sampleMetric);

  return {
    sampleMetric: sampleMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../base/range.js":47,"../value/histogram.js":189,"./metric_registry.js":83}],85:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../metric_registry.js");
require("./utils.js");
require("../../model/model.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  function syncIsComplete(markers) {
    return markers.length === 2;
  }

  function syncInvolvesTelemetry(markers) {
    for (var marker of markers) if (marker.domainId === tr.model.ClockDomainId.TELEMETRY) return true;

    return false;
  }

  function clockSyncLatencyMetric(values, model) {
    for (var markers of model.clockSyncManager.markersBySyncId.values()) {
      var latency = undefined;
      var targetDomain = undefined;
      if (!syncIsComplete(markers) || !syncInvolvesTelemetry(markers)) continue;

      for (var marker of markers) {
        var domain = marker.domainId;
        if (domain === tr.model.ClockDomainId.TELEMETRY) latency = marker.endTs - marker.startTs;else targetDomain = domain.toLowerCase();
      }

      var hist = new tr.v.Histogram('clock_sync_latency_' + targetDomain, tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, tr.v.HistogramBinBoundaries.createExponential(1e-3, 1e3, 30));
      hist.description = 'Clock sync latency for domain ' + targetDomain;
      hist.addSample(latency);
      values.addHistogram(hist);
    }
  }

  tr.metrics.MetricRegistry.register(clockSyncLatencyMetric);

  return {
    clockSyncLatencyMetric: clockSyncLatencyMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../model/model.js":135,"../../value/histogram.js":189,"../metric_registry.js":83,"./utils.js":94}],86:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../metric_registry.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  // Use a lower bound of 0.01 for the metric boundaries (when no CPU time
  // is consumed) and an upper bound of 50 (fifty cores are all active
  // for the entire time). We can't use zero exactly for the lower bound with an
  // exponential histogram.
  var CPU_TIME_PERCENTAGE_BOUNDARIES = tr.v.HistogramBinBoundaries.createExponential(0.01, 50, 200);

  /**
   * This metric measures total CPU time for Chrome processes, per second of
   *   clock time.
   * This metric requires only the 'toplevel' tracing category.
   *
   * @param {!tr.v.ValueSet} values
   * @param {!tr.model.Model} model
   * @param {!Object=} opt_options
   */
  function cpuTimeMetric(values, model, opt_options) {
    var rangeOfInterest = model.bounds;
    if (opt_options && opt_options.rangeOfInterest) rangeOfInterest = opt_options.rangeOfInterest;
    var allProcessCpuTime = 0;

    for (var pid in model.processes) {
      var process = model.processes[pid];
      var processCpuTime = 0;
      for (var tid in process.threads) {
        var thread = process.threads[tid];
        var threadCpuTime = 0;
        thread.sliceGroup.topLevelSlices.forEach(function (slice) {
          if (slice.duration === 0) return;
          if (!slice.cpuDuration) return;
          var sliceRange = tr.b.Range.fromExplicitRange(slice.start, slice.end);
          var intersection = rangeOfInterest.findIntersection(sliceRange);
          var fractionOfSliceInsideRangeOfInterest = intersection.duration / slice.duration;

          // We assume that if a slice doesn't lie entirely inside the range of
          // interest, then the CPU time is evenly distributed inside of the
          // slice.
          threadCpuTime += slice.cpuDuration * fractionOfSliceInsideRangeOfInterest;
        });
        processCpuTime += threadCpuTime;
      }
      allProcessCpuTime += processCpuTime;
    }

    // Normalize cpu time by clock time.
    var normalizedAllProcessCpuTime = 0;
    if (rangeOfInterest.duration > 0) {
      normalizedAllProcessCpuTime = allProcessCpuTime / rangeOfInterest.duration;
    }

    var unit = tr.b.Unit.byName.normalizedPercentage_smallerIsBetter;
    var cpuTimeHist = new tr.v.Histogram('cpu_time_percentage', unit, CPU_TIME_PERCENTAGE_BOUNDARIES);
    cpuTimeHist.description = 'Percent CPU utilization, normalized against a single core. Can be ' + 'greater than 100% if machine has multiple cores.';
    cpuTimeHist.addSample(normalizedAllProcessCpuTime);
    values.addHistogram(cpuTimeHist);
  }

  tr.metrics.MetricRegistry.register(cpuTimeMetric, {
    supportsRangeOfInterest: true
  });

  return {
    cpuTimeMetric: cpuTimeMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../value/histogram.js":189,"../metric_registry.js":83}],87:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../metric_registry.js");
require("./long_tasks_metric.js");
require("../../value/numeric.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  // The following math is easier if the units are seconds rather than ms,
  // so durations will be converted from ms to s.
  var MS_PER_S = 1000;

  // https://www.desmos.com/calculator/ysabhcc42g
  var RESPONSE_RISK = tr.b.Statistics.LogNormalDistribution.fromMedianAndDiminishingReturns(100 / MS_PER_S, 50 / MS_PER_S);

  /**
   * This helper function computes the risk that a task of the given duration
   * would impact the responsiveness of a speculative input.
   *
   * @param {number} durationMs
   * @return {number} task hazard
   */
  function computeResponsivenessRisk(durationMs) {
    // Returns 0 when the risk of impacting responsiveness is minimal.
    // Returns 1 when it is maximal.
    // durationMs is the duration of a long task.
    // It is at least LONG_TASK_MS.
    // The FAST_RESPONSE_HISTOGRAM was designed to permit both a 50ms task
    // when a Scroll Response begins, plus 16ms latency between the task
    // and the first frame of the scroll, without impacting the responsiveness
    // score.
    // Add 16ms to durationMs to simulate the standard (maximum ideal) scroll
    // response latency, and use the FAST_RESPONSE_HISTOGRAM to punish every ms
    // that the long task exceeds LONG_TASK_MS.

    durationMs += 16;

    // This returns a normalized percentage that
    // represents the fraction of users that would be satisfied with a
    // Scroll Response that takes durationMs to respond.
    // The risk of impacting responsiveness is approximated as the long task's
    // impact on a hypothetical Scroll Response that starts when the long task
    // starts, and then takes the standard 16ms to respond after the long task
    // finishes.
    // We imagine a Scroll Response instead of a Load or another type of
    // Response because the Scroll Response carries the strictest expectation.
    // The risk of impacting responsiveness is framed as the fraction of users
    // that would be *un*satisifed with the responsiveness of that hypothetical
    // Scroll Response. The fraction of users who are unsatisfied with something
    // is equal to 1 - the fraction of users who are satisfied with it.
    return RESPONSE_RISK.computePercentile(durationMs / MS_PER_S);
  }

  /**
   * This weighting function is similar to tr.metrics.sh.perceptualBlend,
   * but this version is appropriate for SmallerIsBetter metrics, whereas
   * that version is for BiggerIsBetter metrics.
   * (This would not be necessary if hazard were reframed as a BiggerIsBetter
   * metric such as "input readiness".)
   * Also, that version assumes that the 'ary' will be UserExpectations, whereas
   * this version assumes that the 'ary' will be scores.
   *
   * @param {number} hazardScore
   * @return {number} weight
   */
  function perceptualBlendSmallerIsBetter(hazardScore) {
    return Math.exp(hazardScore);
  }

  /**
   * Compute and return the normalized score for the risk that a speculative
   * input's responsiveness would have been impacted by long tasks on the given
   * thread in the given range.
   *
   * @param {tr.model.Thread} thread
   * @param {tr.b.Range=} opt_range
   * @return {number} hazard
   */
  function computeHazardForLongTasksInRangeOnThread(thread, opt_range) {
    var taskHazardScores = [];
    tr.metrics.sh.iterateLongTopLevelTasksOnThreadInRange(thread, opt_range, function (task) {
      taskHazardScores.push(computeResponsivenessRisk(task.duration));
    });
    return tr.b.Statistics.weightedMean(taskHazardScores, perceptualBlendSmallerIsBetter);
  }

  /**
   * Compute and return the normalized score for the risk that a speculative
   * input's responsiveness would have been impacted by long tasks.
   *
   * @param {tr.model.Model} model The model.
   * @return {number} hazard
   */
  function computeHazardForLongTasks(model) {
    var threadHazardScores = [];
    tr.metrics.sh.iterateRendererMainThreads(model, function (thread) {
      threadHazardScores.push(computeHazardForLongTasksInRangeOnThread(thread));
    });
    return tr.b.Statistics.weightedMean(threadHazardScores, perceptualBlendSmallerIsBetter);
  }

  /**
   * This EXPERIMENTAL metric computes a scalar normalized score that
   * represents the risk that a speculative input's responsiveness would have
   * been impacted by long tasks.
   * This metric requires only the 'toplevel' tracing category.
   */
  function hazardMetric(values, model) {
    var overallHazard = computeHazardForLongTasks(model);
    if (overallHazard === undefined) overallHazard = 0;

    var hist = new tr.v.Histogram('hazard', tr.b.Unit.byName.normalizedPercentage_smallerIsBetter);
    hist.addSample(overallHazard);
    values.addHistogram(hist);
  }

  tr.metrics.MetricRegistry.register(hazardMetric);

  return {
    hazardMetric: hazardMetric,
    computeHazardForLongTasksInRangeOnThread: computeHazardForLongTasksInRangeOnThread,
    computeHazardForLongTasks: computeHazardForLongTasks,
    computeResponsivenessRisk: computeResponsivenessRisk
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../value/numeric.js":190,"../metric_registry.js":83,"./long_tasks_metric.js":89}],88:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/category_util.js");
require("../../base/statistics.js");
require("../metric_registry.js");
require("./utils.js");
require("../../model/helpers/chrome_model_helper.js");
require("../../model/timed_event.js");
require("../../value/histogram.js");
require("../../value/numeric.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  var RESPONSIVENESS_THRESHOLD = 50;
  var INTERACTIVE_WINDOW_SIZE = 5 * 1000;
  var timeDurationInMs_smallerIsBetter = tr.b.Unit.byName.timeDurationInMs_smallerIsBetter;
  var RelatedEventSet = tr.v.d.RelatedEventSet;

  // TODO(ksakamoto): This should be a method of tr.model.Event or one of its
  // subclasses.
  function hasCategoryAndName(event, category, title) {
    return event.title === title && event.category && tr.b.getCategoryParts(event.category).indexOf(category) !== -1;
  }

  function findTargetRendererHelper(chromeHelper) {
    var largestPid = -1;
    for (var pid in chromeHelper.rendererHelpers) {
      var rendererHelper = chromeHelper.rendererHelpers[pid];
      if (rendererHelper.isChromeTracingUI) continue;
      if (pid > largestPid) largestPid = pid;
    }

    if (largestPid === -1) return undefined;

    return chromeHelper.rendererHelpers[largestPid];
  }

  function createBreakdownDiagnostic(rendererHelper, start, end) {
    var breakdownDict = rendererHelper.generateTimeBreakdownTree(start, end);

    var breakdownDiagnostic = new tr.v.d.Breakdown();
    breakdownDiagnostic.colorScheme = tr.v.d.COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER;

    for (var label in breakdownDict) {
      breakdownDiagnostic.set(label, breakdownDict[label].total);
    }
    return breakdownDiagnostic;
  }

  /**
   * A utility class for finding navigationStart event for given frame and
   * timestamp.
   * @constructor
   */
  function NavigationStartFinder(rendererHelper) {
    this.navigationStartsForFrameId_ = {};
    for (var ev of rendererHelper.mainThread.sliceGroup.childEvents()) {
      if (!hasCategoryAndName(ev, 'blink.user_timing', 'navigationStart')) continue;
      var frameIdRef = ev.args['frame'];
      var list = this.navigationStartsForFrameId_[frameIdRef];
      if (list === undefined) this.navigationStartsForFrameId_[frameIdRef] = list = [];
      list.unshift(ev);
    }
  }

  NavigationStartFinder.prototype = {
    findNavigationStartEventForFrameBeforeTimestamp: function (frameIdRef, ts) {
      var list = this.navigationStartsForFrameId_[frameIdRef];
      if (list === undefined) {
        console.warn('No navigationStartEvent found for frame id "' + frameIdRef + '"');
        return undefined;
      }
      var eventBeforeTimestamp;
      for (var ev of list) {
        if (ev.start > ts) continue;
        if (eventBeforeTimestamp === undefined) eventBeforeTimestamp = ev;
      }
      if (eventBeforeTimestamp === undefined) {
        console.warn('Failed to find navigationStartEvent.');
        return undefined;
      }
      return eventBeforeTimestamp;
    }
  };

  var FIRST_PAINT_BOUNDARIES = tr.v.HistogramBinBoundaries.createLinear(0, 1e3, 20) // 50ms step to 1s
  .addLinearBins(3e3, 20) // 100ms step to 3s
  .addExponentialBins(20e3, 20);

  function createHistogram(name) {
    var histogram = new tr.v.Histogram(name, timeDurationInMs_smallerIsBetter, FIRST_PAINT_BOUNDARIES);
    histogram.customizeSummaryOptions({
      avg: true,
      count: false,
      max: true,
      min: true,
      std: true,
      sum: false,
      percentile: [0.90, 0.95, 0.99]
    });
    return histogram;
  }

  function findFrameLoaderSnapshotAt(rendererHelper, frameIdRef, ts) {
    var snapshot;

    var objects = rendererHelper.process.objects;
    var frameLoaderInstances = objects.instancesByTypeName_['FrameLoader'];
    if (frameLoaderInstances === undefined) {
      console.warn('Failed to find FrameLoader for frameId "' + frameIdRef + '" at ts ' + ts + ', the trace maybe incomplete or from an old' + 'Chrome.');
      return undefined;
    }

    var snapshot;
    for (var instance of frameLoaderInstances) {
      if (!instance.isAliveAt(ts)) continue;
      var maybeSnapshot = instance.getSnapshotAt(ts);
      if (frameIdRef !== maybeSnapshot.args['frame']['id_ref']) continue;
      snapshot = maybeSnapshot;
    }

    return snapshot;
  }

  function findAllUserTimingEvents(rendererHelper, title) {
    var targetEvents = [];

    for (var ev of rendererHelper.process.getDescendantEvents()) {
      if (!hasCategoryAndName(ev, 'blink.user_timing', title)) continue;
      targetEvents.push(ev);
    }

    return targetEvents;
  }

  function findFirstMeaningfulPaintCandidates(rendererHelper) {
    var isTelemetryInternalEvent = prepareTelemetryInternalEventPredicate(rendererHelper);
    var candidatesForFrameId = {};
    for (var ev of rendererHelper.process.getDescendantEvents()) {
      if (!hasCategoryAndName(ev, 'loading', 'firstMeaningfulPaintCandidate')) continue;
      if (isTelemetryInternalEvent(ev)) continue;
      var frameIdRef = ev.args['frame'];
      if (frameIdRef === undefined) continue;
      var list = candidatesForFrameId[frameIdRef];
      if (list === undefined) candidatesForFrameId[frameIdRef] = list = [];
      list.push(ev);
    }
    return candidatesForFrameId;
  }

  function prepareTelemetryInternalEventPredicate(rendererHelper) {
    var ignoreRegions = [];

    var internalRegionStart;
    for (var slice of rendererHelper.mainThread.asyncSliceGroup.getDescendantEvents()) {
      if (!!slice.title.match(/^telemetry\.internal\.[^.]*\.start$/)) internalRegionStart = slice.start;
      if (!!slice.title.match(/^telemetry\.internal\.[^.]*\.end$/)) {
        var timedEvent = new tr.model.TimedEvent(internalRegionStart);
        timedEvent.duration = slice.end - internalRegionStart;
        ignoreRegions.push(timedEvent);
      }
    }

    return function isTelemetryInternalEvent(slice) {
      for (var region of ignoreRegions) if (region.bounds(slice)) return true;
      return false;
    };
  }

  var URL_BLACKLIST = ['about:blank',
  // Chrome on Android creates main frames with the below URL for plugins.
  'data:text/html,pluginplaceholderdata'];
  function shouldIgnoreURL(url) {
    return URL_BLACKLIST.indexOf(url) >= 0;
  }

  var METRICS = [{
    valueName: 'timeToFirstContentfulPaint',
    title: 'firstContentfulPaint',
    description: 'time to first contentful paint'
  }, {
    valueName: 'timeToOnload',
    title: 'loadEventStart',
    description: 'time to onload. ' + 'This is temporary metric used for PCv1/v2 sanity checking'
  }];

  function timeToFirstContentfulPaintMetric(values, model) {
    var chromeHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
    var rendererHelper = findTargetRendererHelper(chromeHelper);
    var isTelemetryInternalEvent = prepareTelemetryInternalEventPredicate(rendererHelper);
    var navigationStartFinder = new NavigationStartFinder(rendererHelper);

    for (var metric of METRICS) {
      var histogram = createHistogram(metric.valueName);
      histogram.description = metric.description;
      var targetEvents = findAllUserTimingEvents(rendererHelper, metric.title);
      for (var ev of targetEvents) {
        if (isTelemetryInternalEvent(ev)) continue;
        var frameIdRef = ev.args['frame'];
        var snapshot = findFrameLoaderSnapshotAt(rendererHelper, frameIdRef, ev.start);
        if (snapshot === undefined || !snapshot.args.isLoadingMainFrame) continue;
        var url = snapshot.args.documentLoaderURL;
        if (shouldIgnoreURL(url)) continue;
        var navigationStartEvent = navigationStartFinder.findNavigationStartEventForFrameBeforeTimestamp(frameIdRef, ev.start);
        // Ignore layout w/o preceding navigationStart, as they are not
        // attributed to any time-to-X metric.
        if (navigationStartEvent === undefined) continue;

        var timeToEvent = ev.start - navigationStartEvent.start;
        histogram.addSample(timeToEvent, { url: new tr.v.d.Generic(url) });
      }
      values.addHistogram(histogram);
    }
  }

  function addTimeToInteractiveSampleToHistogram(histogram, rendererHelper, navigationStart, firstMeaningfulPaint, url) {
    if (shouldIgnoreURL(url)) return;
    var navigationStartTime = navigationStart.start;
    var firstInteractive = Infinity;
    var firstInteractiveCandidate = firstMeaningfulPaint;
    var lastLongTaskEvent = undefined;
    // Find the first interactive point X after firstMeaningfulPaint so that
    // range [X, X + INTERACTIVE_WINDOW_SIZE] contains no
    // 'TaskQueueManager::ProcessTaskFromWorkQueues' slice which takes more than
    // RESPONSIVENESS_THRESHOLD.
    // For more details on why TaskQueueManager::ProcessTaskFromWorkQueue is
    // chosen as a proxy for all un-interruptable task on renderer thread, see
    // https://github.com/GoogleChrome/lighthouse/issues/489
    // TODO(nedn): replace this with just "var ev of rendererHelper..." once
    // canary binary is updated.
    // (https://github.com/catapult-project/catapult/issues/2586)
    for (var ev of [...rendererHelper.mainThread.sliceGroup.childEvents()]) {
      if (ev.start < firstInteractiveCandidate) continue;
      var interactiveDurationSoFar = ev.start - firstInteractiveCandidate;
      if (interactiveDurationSoFar >= INTERACTIVE_WINDOW_SIZE) {
        firstInteractive = firstInteractiveCandidate;
        break;
      }
      if (ev.title === 'TaskQueueManager::ProcessTaskFromWorkQueue' && ev.duration > RESPONSIVENESS_THRESHOLD) {
        firstInteractiveCandidate = ev.end - 50;
        lastLongTaskEvent = ev;
      }
    }
    var breakdownDiagnostic = createBreakdownDiagnostic(rendererHelper, navigationStartTime, firstInteractive);

    var timeToFirstInteractive = firstInteractive - navigationStartTime;
    histogram.addSample(timeToFirstInteractive, {
      "Start": new RelatedEventSet(navigationStart),
      "Last long task": new RelatedEventSet(lastLongTaskEvent),
      "Navigation infos": new tr.v.d.Generic({ url: url, pid: rendererHelper.pid,
        start: navigationStartTime, interactive: firstInteractive }),
      "Breakdown of [navStart, Interactive]": breakdownDiagnostic
    });
  }

  /**
   * Computes Time to first meaningful paint (TTFMP) & time to interactive (TTI)
   * from |model| and add it to |value|.
   *
   * First meaningful paint is the paint following the layout with the highest
   * "Layout Significance". The Layout Significance is computed inside Blink,
   * by FirstMeaningfulPaintDetector class. It logs
   * "firstMeaningfulPaintCandidate" event every time the Layout Significance
   * marks a record. TTFMP is the time between NavigationStart and the last
   * firstMeaningfulPaintCandidate event.
   *
   * Design doc: https://goo.gl/vpaxv6
   *
   * TTI is computed as the starting time of the timed window with size
   * INTERACTIVE_WINDOW_SIZE that happens after FMP in which there is no
   * uninterruptable task on the main thread with size more than
   * RESPONSIVENESS_THRESHOLD.
   *
   * Design doc: https://goo.gl/ISWndc
   */
  function timeToFirstMeaningfulPaintAndTimeToInteractiveMetrics(values, model) {
    var chromeHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
    var rendererHelper = findTargetRendererHelper(chromeHelper);
    var navigationStartFinder = new NavigationStartFinder(rendererHelper);
    var firstMeaningfulPaintHistogram = createHistogram('timeToFirstMeaningfulPaint');
    firstMeaningfulPaintHistogram.description = 'time to first meaningful paint';
    var firstInteractiveHistogram = createHistogram('timeToFirstInteractive');
    firstInteractiveHistogram.description = 'time to first interactive';

    function addFirstMeaningfulPaintSampleToHistogram(frameIdRef, navigationStart, fmpMarkerEvent) {
      var snapshot = findFrameLoaderSnapshotAt(rendererHelper, frameIdRef, fmpMarkerEvent.start);
      if (snapshot === undefined || !snapshot.args.isLoadingMainFrame) return;
      var url = snapshot.args.documentLoaderURL;
      if (shouldIgnoreURL(url)) return;

      var timeToFirstMeaningfulPaint = fmpMarkerEvent.start - navigationStart.start;
      var extraDiagnostic = {
        url: url,
        pid: rendererHelper.pid
      };
      var breakdownDiagnostic = createBreakdownDiagnostic(rendererHelper, navigationStart.start, fmpMarkerEvent.start);
      firstMeaningfulPaintHistogram.addSample(timeToFirstMeaningfulPaint, {
        "Breakdown of [navStart, FMP]": breakdownDiagnostic,
        "Start": new RelatedEventSet(navigationStart),
        "End": new RelatedEventSet(fmpMarkerEvent),
        "Navigation infos": new tr.v.d.Generic({ url: url, pid: rendererHelper.pid,
          start: navigationStart.start, fmp: fmpMarkerEvent.start })
      });
      return { firstMeaningfulPaint: fmpMarkerEvent.start, url: url };
    }

    var candidatesForFrameId = findFirstMeaningfulPaintCandidates(rendererHelper);

    for (var frameIdRef in candidatesForFrameId) {
      var navigationStart;
      var lastCandidate;

      // Iterate over the FMP candidates, remembering the last one.
      for (var ev of candidatesForFrameId[frameIdRef]) {
        var navigationStartForThisCandidate = navigationStartFinder.findNavigationStartEventForFrameBeforeTimestamp(frameIdRef, ev.start);
        // Ignore candidate w/o preceding navigationStart, as they are not
        // attributed to any TTFMP.
        if (navigationStartForThisCandidate === undefined) continue;

        if (navigationStart !== navigationStartForThisCandidate) {
          // New navigation is found. Compute TTFMP for current navigation, and
          // reset the state variables.
          if (navigationStart !== undefined && lastCandidate !== undefined) {
            data = addFirstMeaningfulPaintSampleToHistogram(frameIdRef, navigationStart, lastCandidate);
            if (data !== undefined) addTimeToInteractiveSampleToHistogram(firstInteractiveHistogram, rendererHelper, navigationStart, data.firstMeaningfulPaint, data.url);
          }
          navigationStart = navigationStartForThisCandidate;
        }
        lastCandidate = ev;
      }

      // Emit TTFMP for the last navigation.
      if (lastCandidate !== undefined) {
        var data = addFirstMeaningfulPaintSampleToHistogram(frameIdRef, navigationStart, lastCandidate);

        if (data !== undefined) addTimeToInteractiveSampleToHistogram(firstInteractiveHistogram, rendererHelper, navigationStart, data.firstMeaningfulPaint, data.url);
      }
    }

    values.addHistogram(firstMeaningfulPaintHistogram);
    values.addHistogram(firstInteractiveHistogram);
  }

  function loadingMetric(values, model) {
    timeToFirstContentfulPaintMetric(values, model);
    timeToFirstMeaningfulPaintAndTimeToInteractiveMetrics(values, model);
  }

  tr.metrics.MetricRegistry.register(loadingMetric);

  return {
    loadingMetric: loadingMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/category_util.js":30,"../../base/statistics.js":53,"../../model/helpers/chrome_model_helper.js":127,"../../model/timed_event.js":160,"../../value/histogram.js":189,"../../value/numeric.js":190,"../metric_registry.js":83,"./utils.js":94}],89:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../extras/chrome/chrome_user_friendly_category_driver.js");
require("../metric_registry.js");
require("../../model/helpers/chrome_model_helper.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  var LONG_TASK_MS = 50;

  // Anything longer than this should be so rare that its length beyond this is
  // uninteresting.
  var LONGEST_TASK_MS = 1000;

  /**
   * This helper function calls |cb| for each of the top-level tasks on the
   * given thread in the given range whose duration is longer than LONG_TASK_MS.
   *
   * @param {tr.model.Thread} thread
   * @param {tr.b.Range=} opt_range
   * @param {function()} cb
   * @param {Object=} opt_this
   */
  function iterateLongTopLevelTasksOnThreadInRange(thread, opt_range, cb, opt_this) {
    thread.sliceGroup.topLevelSlices.forEach(function (slice) {
      if (opt_range && !opt_range.intersectsExplicitRangeInclusive(slice.start, slice.end)) return;

      if (slice.duration < LONG_TASK_MS) return;

      cb.call(opt_this, slice);
    });
  }

  /**
   * This helper function calls |cb| for each of the main renderer threads in
   * the model.
   *
   * @param {tr.model.Model} model The model.
   * @param {function()} cb Callback.
   * @param {Object=} opt_this Context object.
   */
  function iterateRendererMainThreads(model, cb, opt_this) {
    var modelHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
    tr.b.dictionaryValues(modelHelper.rendererHelpers).forEach(function (rendererHelper) {
      if (!rendererHelper.mainThread) return;
      cb.call(opt_this, rendererHelper.mainThread);
    });
  }

  /**
   * This metric directly measures long tasks on renderer main threads.
   * This metric requires only the 'toplevel' tracing category.
   *
   * @param {!tr.v.ValueSet} values
   * @param {!tr.model.Model} model
   * @param {!Object=} opt_options
   */
  function longTasksMetric(values, model, opt_options) {
    var rangeOfInterest = opt_options ? opt_options.rangeOfInterest : undefined;
    var longTaskHist = new tr.v.Histogram('long tasks', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, tr.v.HistogramBinBoundaries.createLinear(LONG_TASK_MS, LONGEST_TASK_MS, 40));
    longTaskHist.description = 'durations of long tasks';
    var slices = new tr.model.EventSet();
    iterateRendererMainThreads(model, function (thread) {
      iterateLongTopLevelTasksOnThreadInRange(thread, rangeOfInterest, function (task) {
        longTaskHist.addSample(task.duration, { relatedEvents: new tr.v.d.RelatedEventSet([task]) });
        slices.push(task);
        slices.addEventSet(task.descendentSlices);
      });
    });
    values.addHistogram(longTaskHist);

    var sampleForEvent = undefined;
    var breakdown = tr.v.d.RelatedHistogramBreakdown.buildFromEvents(values, 'long tasks ', slices, e => model.getUserFriendlyCategoryFromEvent(e) || 'unknown', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, sampleForEvent, tr.v.HistogramBinBoundaries.createExponential(1, LONGEST_TASK_MS, 40));
    breakdown.colorScheme = tr.v.d.COLOR_SCHEME_CHROME_USER_FRIENDLY_CATEGORY_DRIVER;
    longTaskHist.diagnostics.set('category', breakdown);
  }

  tr.metrics.MetricRegistry.register(longTasksMetric, {
    supportsRangeOfInterest: true
  });

  return {
    longTasksMetric: longTasksMetric,
    iterateLongTopLevelTasksOnThreadInRange: iterateLongTopLevelTasksOnThreadInRange,
    iterateRendererMainThreads: iterateRendererMainThreads,
    LONG_TASK_MS: LONG_TASK_MS,
    LONGEST_TASK_MS: LONGEST_TASK_MS
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../extras/chrome/chrome_user_friendly_category_driver.js":63,"../../model/helpers/chrome_model_helper.js":127,"../../value/histogram.js":189,"../metric_registry.js":83}],90:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/iteration_helpers.js");
require("../../base/multi_dimensional_view.js");
require("../../base/range.js");
require("../../base/unit.js");
require("../metric_registry.js");
require("../../model/container_memory_dump.js");
require("../../model/helpers/chrome_model_helper.js");
require("../../model/memory_allocator_dump.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  var BACKGROUND = tr.model.ContainerMemoryDump.LevelOfDetail.BACKGROUND;
  var LIGHT = tr.model.ContainerMemoryDump.LevelOfDetail.LIGHT;
  var DETAILED = tr.model.ContainerMemoryDump.LevelOfDetail.DETAILED;
  var sizeInBytes_smallerIsBetter = tr.b.Unit.byName.sizeInBytes_smallerIsBetter;
  var count_smallerIsBetter = tr.b.Unit.byName.count_smallerIsBetter;
  var DISPLAYED_SIZE_NUMERIC_NAME = tr.model.MemoryAllocatorDump.DISPLAYED_SIZE_NUMERIC_NAME;

  var LEVEL_OF_DETAIL_NAMES = new Map();
  LEVEL_OF_DETAIL_NAMES.set(BACKGROUND, 'background');
  LEVEL_OF_DETAIL_NAMES.set(LIGHT, 'light');
  LEVEL_OF_DETAIL_NAMES.set(DETAILED, 'detailed');

  var BOUNDARIES_FOR_UNIT_MAP = new WeakMap();
  // For unitless numerics (process counts), we use 20 linearly scaled bins
  // from 0 to 20.
  BOUNDARIES_FOR_UNIT_MAP.set(count_smallerIsBetter, tr.v.HistogramBinBoundaries.createLinear(0, 20, 20));
  // For size numerics (subsystem and vm stats), we use 1 bin from 0 B to
  // 1 KiB and 4*24 exponentially scaled bins from 1 KiB to 16 GiB (=2^24 KiB).
  BOUNDARIES_FOR_UNIT_MAP.set(sizeInBytes_smallerIsBetter, new tr.v.HistogramBinBoundaries(0).addBinBoundary(1024 /* 1 KiB */).addExponentialBins(16 * 1024 * 1024 * 1024 /* 16 GiB */, 4 * 24));

  function memoryMetric(values, model, opt_options) {
    var rangeOfInterest = opt_options ? opt_options.rangeOfInterest : undefined;
    var browserNameToGlobalDumps = splitGlobalDumpsByBrowserName(model, rangeOfInterest);
    addGeneralMemoryDumpValues(browserNameToGlobalDumps, values);
    addDetailedMemoryDumpValues(browserNameToGlobalDumps, values);
    addMemoryDumpCountValues(browserNameToGlobalDumps, values);
  }

  /**
   * Splits the global memory dumps in |model| by browser name.
   *
   * @param {!tr.Model} model The trace model from which the global dumps
   *     should be extracted.
   * @param {!tr.b.Range=} opt_rangeOfInterest If proided, global memory dumps
   *     that do not inclusively intersect the range will be skipped.
   * @return {!Map<string, !Array<!tr.model.GlobalMemoryDump>} A map from
   *     browser names to the associated global memory dumps.
   */
  function splitGlobalDumpsByBrowserName(model, opt_rangeOfInterest) {
    var chromeModelHelper = model.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);
    var browserNameToGlobalDumps = new Map();
    var globalDumpToBrowserHelper = new WeakMap();

    // 1. For each browser process in the model, add its global memory dumps to
    // |browserNameToGlobalDumps|. |chromeModelHelper| can be undefined if
    // it fails to find any browser, renderer or GPU process (see
    // tr.model.helpers.ChromeModelHelper.supportsModel).
    if (chromeModelHelper) {
      chromeModelHelper.browserHelpers.forEach(function (helper) {
        // Retrieve the associated global memory dumps and check that they
        // haven't been classified as belonging to another browser process.
        var globalDumps = skipDumpsThatDoNotIntersectRange(helper.process.memoryDumps.map(d => d.globalMemoryDump), opt_rangeOfInterest);
        globalDumps.forEach(function (globalDump) {
          var existingHelper = globalDumpToBrowserHelper.get(globalDump);
          if (existingHelper !== undefined) {
            throw new Error('Memory dump ID clash across multiple browsers ' + 'with PIDs: ' + existingHelper.pid + ' and ' + helper.pid);
          }
          globalDumpToBrowserHelper.set(globalDump, helper);
        });

        makeKeyUniqueAndSet(browserNameToGlobalDumps, canonicalizeName(helper.browserName), globalDumps);
      });
    }

    // 2. If any global memory dump does not have any associated browser
    // process for some reason, associate it with an 'unknown_browser' browser
    // so that we don't lose the data.
    var unclassifiedGlobalDumps = skipDumpsThatDoNotIntersectRange(model.globalMemoryDumps.filter(g => !globalDumpToBrowserHelper.has(g)), opt_rangeOfInterest);
    if (unclassifiedGlobalDumps.length > 0) {
      makeKeyUniqueAndSet(browserNameToGlobalDumps, 'unknown_browser', unclassifiedGlobalDumps);
    }

    return browserNameToGlobalDumps;
  }

  function skipDumpsThatDoNotIntersectRange(dumps, opt_range) {
    if (!opt_range) return dumps;
    return dumps.filter(d => opt_range.intersectsExplicitRangeInclusive(d.start, d.end));
  }

  function canonicalizeName(name) {
    return name.toLowerCase().replace(' ', '_');
  }

  var USER_FRIENDLY_BROWSER_NAMES = {
    'chrome': 'Chrome',
    'webview': 'WebView',
    'unknown_browser': 'an unknown browser'
  };

  /**
   * Convert a canonical browser name used in value names to a user-friendly
   * name used in value descriptions.
   *
   * Examples:
   *
   *   CANONICAL BROWSER NAME -> USER-FRIENDLY NAME
   *   chrome                 -> Chrome
   *   unknown_browser        -> an unknown browser
   *   webview2               -> WebView(2)
   *   unexpected             -> 'unexpected' browser
   */
  function convertBrowserNameToUserFriendlyName(browserName) {
    for (var baseName in USER_FRIENDLY_BROWSER_NAMES) {
      if (!browserName.startsWith(baseName)) continue;
      var userFriendlyBaseName = USER_FRIENDLY_BROWSER_NAMES[baseName];
      var suffix = browserName.substring(baseName.length);
      if (suffix.length === 0) return userFriendlyBaseName;else if (/^\d+$/.test(suffix)) return userFriendlyBaseName + '(' + suffix + ')';
    }
    return '\'' + browserName + '\' browser';
  }

  function canonicalizeProcessName(rawProcessName) {
    if (!rawProcessName) return 'unknown_processes';
    var baseCanonicalName = canonicalizeName(rawProcessName);
    switch (baseCanonicalName) {
      case 'renderer':
        return 'renderer_processes'; // Intentionally plural.
      case 'browser':
        return 'browser_process';
      default:
        return baseCanonicalName;
    }
  }

  /**
   * Convert a canonical process name used in value names to a user-friendly
   * name used in value descriptions.
   */
  function convertProcessNameToUserFriendlyName(processName, opt_requirePlural) {
    switch (processName) {
      case 'browser_process':
        return opt_requirePlural ? 'browser processes' : 'the browser process';
      case 'renderer_processes':
        return 'renderer processes';
      case 'gpu_process':
        return opt_requirePlural ? 'GPU processes' : 'the GPU process';
      case 'ppapi_process':
        return opt_requirePlural ? 'PPAPI processes' : 'the PPAPI process';
      case 'all_processes':
        return 'all processes';
      case 'unknown_processes':
        return 'unknown processes';
      default:
        return '\'' + processName + '\' processes';
    }
  }

  /**
   * Function for adding entries with duplicate keys to a map without
   * overriding existing entries.
   *
   * This is achieved by appending numeric indices (2, 3, 4, ...) to duplicate
   * keys. Example:
   *
   *   var map = new Map();
   *   // map = Map {}.
   *
   *   makeKeyUniqueAndSet(map, 'key', 'a');
   *   // map = Map {"key" => "a"}.
   *
   *   makeKeyUniqueAndSet(map, 'key', 'b');
   *   // map = Map {"key" => "a", "key2" => "b"}.
   *                                ^^^^
   *   makeKeyUniqueAndSet(map, 'key', 'c');
   *   // map = Map {"key" => "a", "key2" => "b", "key3" => "c"}.
   *                                ^^^^           ^^^^
   */
  function makeKeyUniqueAndSet(map, key, value) {
    var uniqueKey = key;
    var nextIndex = 2;
    while (map.has(uniqueKey)) {
      uniqueKey = key + nextIndex;
      nextIndex++;
    }
    map.set(uniqueKey, value);
  }

  /**
   * Add general memory dump values calculated from all global memory dumps to
   * |values|. In particular, this function adds the following values:
   *
   *   * PROCESS COUNTS
   *     memory:{chrome, webview}:
   *         {browser_process, renderer_processes, ..., all_processes}:
   *         process_count
   *     type: tr.v.Histogram (over all matching global memory dumps)
   *     unit: count_smallerIsBetter
   *
   *   * MEMORY USAGE REPORTED BY CHROME
   *     memory:{chrome, webview}:
   *         {browser_process, renderer_processes, ..., all_processes}:
   *         reported_by_chrome[:{v8, malloc, ...}]:
   *         {effective_size, allocated_objects_size, locked_size}
   *     type: tr.v.Histogram (over all matching global memory dumps)
   *     unit: sizeInBytes_smallerIsBetter
   */
  function addGeneralMemoryDumpValues(browserNameToGlobalDumps, values) {
    addMemoryDumpValues(browserNameToGlobalDumps, gmd => true /* process all global memory dumps */
    , function (processDump, addProcessScalar) {
      // Increment memory:<browser-name>:<process-name>:process_count value.
      addProcessScalar({
        source: 'process_count',
        value: 1,
        unit: count_smallerIsBetter,
        descriptionPrefixBuilder: buildProcessCountDescriptionPrefix
      });

      if (processDump.totals !== undefined) {
        tr.b.iterItems(SYSTEM_TOTAL_VALUE_PROPERTIES, function (propertyName, propertySpec) {
          addProcessScalar({
            source: 'reported_by_os',
            property: propertyName,
            component: ['system_memory'],
            value: propertySpec.getPropertyFunction(processDump),
            unit: sizeInBytes_smallerIsBetter,
            descriptionPrefixBuilder: propertySpec.descriptionPrefixBuilder
          });
        });
      }

      // Add memory:<browser-name>:<process-name>:reported_by_chrome:...
      // values.
      if (processDump.memoryAllocatorDumps === undefined) return;
      processDump.memoryAllocatorDumps.forEach(function (rootAllocatorDump) {
        tr.b.iterItems(CHROME_VALUE_PROPERTIES, function (propertyName, descriptionPrefixBuilder) {
          addProcessScalar({
            source: 'reported_by_chrome',
            component: [rootAllocatorDump.name],
            property: propertyName,
            value: rootAllocatorDump.numerics[propertyName],
            descriptionPrefixBuilder: descriptionPrefixBuilder
          });
        });
        // Some dump providers add allocated objects size as
        // "allocated_objects" child dump.
        if (rootAllocatorDump.numerics['allocated_objects_size'] === undefined) {
          var allocatedObjectsDump = rootAllocatorDump.getDescendantDumpByFullName('allocated_objects');
          if (allocatedObjectsDump !== undefined) {
            addProcessScalar({
              source: 'reported_by_chrome',
              component: [rootAllocatorDump.name],
              property: 'allocated_objects_size',
              value: allocatedObjectsDump.numerics['size'],
              descriptionPrefixBuilder: CHROME_VALUE_PROPERTIES['allocated_objects_size']
            });
          }
        }
      });

      // Add memory:<browser-name>:<process-name>:reported_by_chrome:v8:
      //     {heap, allocated_by_malloc}:...
      addV8MemoryDumpValues(processDump, addProcessScalar);
    }, function (componentTree) {
      // Subtract memory:<browser-name>:<process-name>:reported_by_chrome:
      // tracing:<size-property> from memory:<browser-name>:<process-name>:
      // reported_by_chrome:<size-property> if applicable.
      var tracingNode = componentTree.children[1].get('tracing');
      if (tracingNode === undefined) return;
      for (var i = 0; i < componentTree.values.length; i++) componentTree.values[i].total -= tracingNode.values[i].total;
    }, values);
  }

  /**
   * Add memory dump values calculated from V8 components excluding
   * 'heap_spaces/other_spaces'.
   *
   * @param {!tr.model.ProcessMemoryDump} processDump The process memory dump.
   * @param {!function} addProcessScalar The callback for adding a scalar value.
   */
  function addV8MemoryDumpValues(processDump, addProcessScalar) {
    var v8Dump = processDump.getMemoryAllocatorDumpByFullName('v8');
    if (v8Dump === undefined) return;
    v8Dump.children.forEach(function (isolateDump) {
      // v8:allocated_by_malloc:...
      var mallocDump = isolateDump.getDescendantDumpByFullName('malloc');
      if (mallocDump !== undefined) {
        addV8ComponentValues(mallocDump, ['v8', 'allocated_by_malloc'], addProcessScalar);
      }
      // v8:heap:...
      var heapDump = isolateDump.getDescendantDumpByFullName('heap_spaces');
      if (heapDump !== undefined) {
        addV8ComponentValues(heapDump, ['v8', 'heap'], addProcessScalar);
        heapDump.children.forEach(function (spaceDump) {
          if (spaceDump.name === 'other_spaces') return;
          addV8ComponentValues(spaceDump, ['v8', 'heap', spaceDump.name], addProcessScalar);
        });
      }
    });

    // V8 generates bytecode when interpreting and code objects when
    // compiling the javascript. Total code size includes the size
    // of code and bytecode objects.
    addProcessScalar({
      source: 'reported_by_chrome',
      component: ['v8'],
      property: 'code_and_metadata_size',
      value: v8Dump.numerics['code_and_metadata_size'],
      descriptionPrefixBuilder: buildCodeAndMetadataSizeValueDescriptionPrefix
    });
    addProcessScalar({
      source: 'reported_by_chrome',
      component: ['v8'],
      property: 'code_and_metadata_size',
      value: v8Dump.numerics['bytecode_and_metadata_size'],
      descriptionPrefixBuilder: buildCodeAndMetadataSizeValueDescriptionPrefix
    });
  }

  /**
   * Add memory dump values calculated from the specified V8 component.
   *
   * @param {!tr.model.MemoryAllocatorDump} v8Dump The V8 memory dump.
   * @param {!Array<string>} componentPath The component path for reporting.
   * @param {!function} addProcessScalar The callback for adding a scalar value.
   */
  function addV8ComponentValues(componentDump, componentPath, addProcessScalar) {
    tr.b.iterItems(CHROME_VALUE_PROPERTIES, function (propertyName, descriptionPrefixBuilder) {
      addProcessScalar({
        source: 'reported_by_chrome',
        component: componentPath,
        property: propertyName,
        value: componentDump.numerics[propertyName],
        descriptionPrefixBuilder: descriptionPrefixBuilder
      });
    });
  }

  /**
   * Build a description prefix for a memory:<browser-name>:<process-name>:
   * process_count value.
   *
   * @param {!Array<string>} componentPath The underlying component path (must
   *     be empty).
   * @param {string} processName The canonical name of the process.
   * @return {string} Prefix for the value's description (always
   *     'total number of renderer processes').
   */
  function buildProcessCountDescriptionPrefix(componentPath, processName) {
    if (componentPath.length > 0) {
      throw new Error('Unexpected process count non-empty component path: ' + componentPath.join(':'));
    }
    return 'total number of ' + convertProcessNameToUserFriendlyName(processName, true /* opt_requirePlural */);
  }

  /**
   * Build a description prefix for a memory:<browser-name>:<process-name>:
   * reported_by_chrome:... value.
   *
   * @param {{
   *     userFriendlyPropertyName: string,
   *     userFriendlyPropertyNamePrefix: (string|undefined),
   *     totalUserFriendlyPropertyName: (string|undefined),
   *     componentPreposition: (string|undefined) }}
   *     formatSpec Specification of how the property should be formatted.
   * @param {!Array<string>} componentPath The underlying component path (e.g.
   *     ['malloc']).
   * @param {string} processName The canonical name of the process.
   * @return {string} Prefix for the value's description (e.g.
   *     'effective size of malloc in the browser process').
   */
  function buildChromeValueDescriptionPrefix(formatSpec, componentPath, processName) {
    var nameParts = [];
    if (componentPath.length === 0) {
      nameParts.push('total');
      if (formatSpec.totalUserFriendlyPropertyName) {
        nameParts.push(formatSpec.totalUserFriendlyPropertyName);
      } else {
        if (formatSpec.userFriendlyPropertyNamePrefix) nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);
        nameParts.push(formatSpec.userFriendlyPropertyName);
      }
      nameParts.push('reported by Chrome for');
    } else {
      if (formatSpec.componentPreposition === undefined) {
        // Use component name as an adjective
        // (e.g. 'size of V8 code and metadata').
        if (formatSpec.userFriendlyPropertyNamePrefix) nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);
        nameParts.push(componentPath.join(':'));
        nameParts.push(formatSpec.userFriendlyPropertyName);
      } else {
        // Use component name as a noun with a preposition
        // (e.g. 'size of all objects allocated BY MALLOC').
        if (formatSpec.userFriendlyPropertyNamePrefix) nameParts.push(formatSpec.userFriendlyPropertyNamePrefix);
        nameParts.push(formatSpec.userFriendlyPropertyName);
        nameParts.push(formatSpec.componentPreposition);
        if (componentPath[componentPath.length - 1] === 'allocated_by_malloc') {
          nameParts.push('objects allocated by malloc for');
          nameParts.push(componentPath.slice(0, componentPath.length - 1).join(':'));
        } else {
          nameParts.push(componentPath.join(':'));
        }
      }
      nameParts.push('in');
    }
    nameParts.push(convertProcessNameToUserFriendlyName(processName));
    return nameParts.join(' ');
  }

  // Specifications of properties reported by Chrome.
  var CHROME_VALUE_PROPERTIES = {
    'effective_size': buildChromeValueDescriptionPrefix.bind(undefined, {
      userFriendlyPropertyName: 'effective size',
      componentPreposition: 'of'
    }),
    'allocated_objects_size': buildChromeValueDescriptionPrefix.bind(undefined, {
      userFriendlyPropertyName: 'size of all objects allocated',
      totalUserFriendlyPropertyName: 'size of all allocated objects',
      componentPreposition: 'by'
    }),
    'locked_size': buildChromeValueDescriptionPrefix.bind(undefined, {
      userFriendlyPropertyName: 'locked (pinned) size',
      componentPreposition: 'of'
    }),
    'peak_size': buildChromeValueDescriptionPrefix.bind(undefined, {
      userFriendlyPropertyName: 'peak size',
      componentPreposition: 'of'
    })
  };

  var SYSTEM_TOTAL_VALUE_PROPERTIES = {
    'resident_size': {
      getPropertyFunction: function (processDump) {
        return processDump.totals.residentBytes;
      },
      descriptionPrefixBuilder: buildOsValueDescriptionPrefix.bind(undefined, 'resident set size (RSS)')
    },
    'peak_resident_size': {
      getPropertyFunction: function (processDump) {
        return processDump.totals.peakResidentBytes;
      },
      descriptionPrefixBuilder: buildOsValueDescriptionPrefix.bind(undefined, 'peak resident set size')
    }
  };

  /**
   * Add heavy memory dump values calculated from heavy global memory dumps to
   * |values|. In particular, this function adds the following values:
   *
   *   * MEMORY USAGE REPORTED BY THE OS
   *     memory:{chrome, webview}:
   *         {browser_process, renderer_processes, ..., all_processes}:
   *         reported_by_os:system_memory:[{ashmem, native_heap, java_heap}:]
   *         {proportional_resident_size, private_dirty_size}
   *     memory:{chrome, webview}:
   *         {browser_process, renderer_processes, ..., all_processes}:
   *         reported_by_os:gpu_memory:[{gl, graphics, ...}:]
   *         proportional_resident_size
   *     type: tr.v.Histogram (over matching heavy global memory dumps)
   *     unit: sizeInBytes_smallerIsBetter
   *
   *   * MEMORY USAGE REPORTED BY CHROME
   *     memory:{chrome, webview}:
   *         {browser_process, renderer_processes, ..., all_processes}:
   *         reported_by_chrome:v8:code_and_metadata_size
   *     type: tr.v.Histogram (over matching heavy global memory dumps)
   *     unit: sizeInBytes_smallerIsBetter
   */
  function addDetailedMemoryDumpValues(browserNameToGlobalDumps, values) {
    addMemoryDumpValues(browserNameToGlobalDumps, g => g.levelOfDetail === DETAILED, function (processDump, addProcessScalar) {
      // Add memory:<browser-name>:<process-name>:reported_by_os:
      // system_memory:... values.
      tr.b.iterItems(SYSTEM_VALUE_COMPONENTS, function (componentName, componentSpec) {
        tr.b.iterItems(SYSTEM_VALUE_PROPERTIES, function (propertyName, propertySpec) {
          var node = getDescendantVmRegionClassificationNode(processDump.vmRegions, componentSpec.classificationPath);
          var componentPath = ['system_memory'];
          if (componentName) componentPath.push(componentName);
          addProcessScalar({
            source: 'reported_by_os',
            component: componentPath,
            property: propertyName,
            value: node === undefined ? 0 : node.byteStats[propertySpec.byteStat] || 0,
            unit: sizeInBytes_smallerIsBetter,
            descriptionPrefixBuilder: propertySpec.descriptionPrefixBuilder
          });
        });
      });

      // Add memory:<browser-name>:<process-name>:reported_by_os:
      // gpu_memory:... values.
      var memtrackDump = processDump.getMemoryAllocatorDumpByFullName('gpu/android_memtrack');
      if (memtrackDump !== undefined) {
        var descriptionPrefixBuilder = SYSTEM_VALUE_PROPERTIES['proportional_resident_size'].descriptionPrefixBuilder;
        memtrackDump.children.forEach(function (memtrackChildDump) {
          var childName = memtrackChildDump.name;
          addProcessScalar({
            source: 'reported_by_os',
            component: ['gpu_memory', childName],
            property: 'proportional_resident_size',
            value: memtrackChildDump.numerics['memtrack_pss'],
            descriptionPrefixBuilder: descriptionPrefixBuilder
          });
        });
      }
    }, function (componentTree) {}, values);
  }

  // Specifications of components reported by the system.
  var SYSTEM_VALUE_COMPONENTS = {
    '': {
      classificationPath: []
    },
    'java_heap': {
      classificationPath: ['Android', 'Java runtime', 'Spaces'],
      userFriendlyName: 'the Java heap'
    },
    'ashmem': {
      classificationPath: ['Android', 'Ashmem'],
      userFriendlyName: 'ashmem'
    },
    'native_heap': {
      classificationPath: ['Native heap'],
      userFriendlyName: 'the native heap'
    }
  };

  // Specifications of properties reported by the system.
  var SYSTEM_VALUE_PROPERTIES = {
    'proportional_resident_size': {
      byteStat: 'proportionalResident',
      descriptionPrefixBuilder: buildOsValueDescriptionPrefix.bind(undefined, 'proportional resident size (PSS)')
    },
    'private_dirty_size': {
      byteStat: 'privateDirtyResident',
      descriptionPrefixBuilder: buildOsValueDescriptionPrefix.bind(undefined, 'private dirty size')
    }
  };

  /**
   * Build a description prefix for a memory:<browser-name>:<process-name>:
   * reported_by_os:... value.
   *
   * @param {string} userFriendlyPropertyName User-friendly name of the
   *     underlying property (e.g. 'private dirty size').
   * @param {!Array<string>} componentPath The underlying component path (e.g.
   *     ['system', 'java_heap']).
   * @param {string} processName The canonical name of the process.
   * @return {string} Prefix for the value's description (e.g.
   *     'total private dirty size of the Java heal in the GPU process').
   */
  function buildOsValueDescriptionPrefix(userFriendlyPropertyName, componentPath, processName) {
    if (componentPath.length > 2) {
      throw new Error('OS value component path for \'' + userFriendlyPropertyName + '\' too long: ' + componentPath.join(':'));
    }

    var nameParts = [];
    if (componentPath.length < 2) nameParts.push('total');

    nameParts.push(userFriendlyPropertyName);

    if (componentPath.length > 0) {
      switch (componentPath[0]) {
        case 'system_memory':
          if (componentPath.length > 1) {
            var userFriendlyComponentName = SYSTEM_VALUE_COMPONENTS[componentPath[1]].userFriendlyName;
            if (userFriendlyComponentName === undefined) {
              throw new Error('System value sub-component for \'' + userFriendlyPropertyName + '\' unknown: ' + componentPath.join(':'));
            }
            nameParts.push('of', userFriendlyComponentName, 'in');
          } else {
            nameParts.push('of system memory (RAM) used by');
          }
          break;

        case 'gpu_memory':
          if (componentPath.length > 1) {
            nameParts.push('of the', componentPath[1]);
            nameParts.push('Android memtrack component in');
          } else {
            nameParts.push('of GPU memory (Android memtrack) used by');
          }
          break;

        default:
          throw new Error('OS value component for \'' + userFriendlyPropertyName + '\' unknown: ' + componentPath.join(':'));
      }
    } else {
      nameParts.push('reported by the OS for');
    }

    nameParts.push(convertProcessNameToUserFriendlyName(processName));
    return nameParts.join(' ');
  }

  /**
   * Build a description prefix for a memory:<browser-name>:<process-name>:
   * reported_by_chrome:...:code_and_metadata_size value.
   *
   * @param {!Array<string>} componentPath The underlying component path (e.g.
   *     ['v8']).
   * @param {string} processName The canonical name of the process.
   * @return {string} Prefix for the value's description (e.g.
   *     'size of v8 code and metadata in').
   */
  function buildCodeAndMetadataSizeValueDescriptionPrefix(componentPath, processName) {
    return buildChromeValueDescriptionPrefix({
      userFriendlyPropertyNamePrefix: 'size of',
      userFriendlyPropertyName: 'code and metadata'
    }, componentPath, processName);
  }

  /**
   * Get the descendant of a VM region classification |node| specified by the
   * given |path| of child node titles. If |node| is undefined or such a
   * descendant does not exist, this function returns undefined.
   */
  function getDescendantVmRegionClassificationNode(node, path) {
    for (var i = 0; i < path.length; i++) {
      if (node === undefined) break;
      node = tr.b.findFirstInArray(node.children, c => c.title === path[i]);
    }
    return node;
  }

  /**
   * Add global memory dump counts to |values|. In particular, this function
   * adds the following values:
   *
   *   * DUMP COUNTS
   *     memory:{chrome, webview}:all_processes:dump_count[:{light, detailed}]
   *     type: tr.v.Histogram
   *     unit: count_smallerIsBetter
   *
   * Note that unlike all other values generated by the memory metric, the
   * global memory dump counts are NOT instances of tr.v.Histogram
   * because it doesn't make sense to aggregate them (they are already counts
   * over all global dumps associated with the relevant browser).
   */
  function addMemoryDumpCountValues(browserNameToGlobalDumps, values) {
    browserNameToGlobalDumps.forEach(function (globalDumps, browserName) {
      var totalDumpCount = 0;
      var levelOfDetailNameToDumpCount = {};
      LEVEL_OF_DETAIL_NAMES.forEach(function (levelOfDetailName) {
        levelOfDetailNameToDumpCount[levelOfDetailName] = 0;
      });

      globalDumps.forEach(function (globalDump) {
        totalDumpCount++;

        // Increment the level-of-detail-specific dump count (if possible).
        var levelOfDetailName = LEVEL_OF_DETAIL_NAMES.get(globalDump.levelOfDetail);
        if (!(levelOfDetailName in levelOfDetailNameToDumpCount)) return; // Unknown level of detail.
        levelOfDetailNameToDumpCount[levelOfDetailName]++;
      });

      // Add memory:<browser-name>:all_processes:dump_count[:<level>] values.
      reportMemoryDumpCountAsValue(browserName, undefined /* total */
      , totalDumpCount, values);
      tr.b.iterItems(levelOfDetailNameToDumpCount, function (levelOfDetailName, levelOfDetailDumpCount) {
        reportMemoryDumpCountAsValue(browserName, levelOfDetailName, levelOfDetailDumpCount, values);
      });
    });
  }

  /**
   * Add a tr.v.Histogram value to |values| reporting that the number of
   * |levelOfDetailName| memory dumps added by |browserName| was
   * |levelOfDetailCount|.
   */
  function reportMemoryDumpCountAsValue(browserName, levelOfDetailName, levelOfDetailDumpCount, values) {
    // Construct the name of the memory value.
    var nameParts = ['memory', browserName, 'all_processes', 'dump_count'];
    if (levelOfDetailName !== undefined) nameParts.push(levelOfDetailName);
    var name = nameParts.join(':');

    // Build the underlying histogram for the memory value.
    var histogram = new tr.v.Histogram(name, count_smallerIsBetter, BOUNDARIES_FOR_UNIT_MAP.get(count_smallerIsBetter));
    histogram.addSample(levelOfDetailDumpCount);

    // Build the options for the memory value.
    histogram.description = ['total number of', levelOfDetailName || 'all', 'memory dumps added by', convertBrowserNameToUserFriendlyName(browserName), 'to the trace'].join(' ');

    // Report the memory value.
    values.addHistogram(histogram);
  }

  /**
   * Add generic values extracted from process memory dumps and aggregated by
   * process name and component path into |values|.
   *
   * For each browser and set of global dumps in |browserNameToGlobalDumps|,
   * |customProcessDumpValueExtractor| is applied to every process memory dump
   * associated with the global memory dump. The second argument provided to the
   * callback is a function for adding extracted values:
   *
   *   function sampleProcessDumpCallback(processDump, addProcessValue) {
   *     ...
   *     addProcessScalar({
   *       source: 'reported_by_chrome',
   *       component: ['system', 'native_heap'],
   *       property: 'proportional_resident_size',
   *       value: pssExtractedFromProcessDump2,
   *       descriptionPrefixBuilder: function(componentPath) {
   *         return 'PSS of ' + componentPath.join('/') + ' in';
   *       }
   *     });
   *     ...
   *   }
   *
   * For each global memory dump, the extracted values are summed by process
   * name (browser_process, renderer_processes, ..., all_processes) and
   * component path (e.g. gpu is a sum of gpu:gl, gpu:graphics, ...). The sums
   * are then aggregated over all global memory dumps associated with the given
   * browser. For example, assuming that |customProcessDumpValueExtractor|
   * extracts 'proportional_resident_size' values for component paths
   * ['X', 'A'], ['X', 'B'] and ['Y'] under the same 'source' from each process
   * memory dump, the following values will be reported (for Chrome):
   *
   *    memory:chrome:browser_process:source:X:A:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A in all 'browser' process dumps in global dump 1,
   *          ...
   *          sum of X:A in all 'browser' process dumps in global dump N
   *        ]
   *
   *    memory:chrome:browser_process:source:X:B:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:B in all 'browser' process dumps in global dump 1,
   *          ...
   *          sum of X:B in all 'browser' process dumps in global dump N
   *        ]
   *
   *    memory:chrome:browser_process:source:X:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A+X:B in all 'browser' process dumps in global dump 1,
   *          ...
   *          sum of X:A+X:B in all 'browser' process dumps in global dump N
   *        ]
   *
   *    memory:chrome:browser_process:source:Y:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of Y in all 'browser' process dumps in global dump 1,
   *          ...
   *          sum of Y in all 'browser' process dumps in global dump N
   *        ]
   *
   *    memory:chrome:browser_process:source:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A+X:B+Y in all 'browser' process dumps in global dump 1,
   *          ...
   *          sum of X:A+X:B+Y in all 'browser' process dumps in global dump N
   *        ]
   *
   *    ...
   *
   *    memory:chrome:all_processes:source:X:A:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A in all process dumps in global dump 1,
   *          ...
   *          sum of X:A in all process dumps in global dump N,
   *    ]
   *
   *    memory:chrome:all_processes:source:X:B:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:B in all process dumps in global dump 1,
   *          ...
   *          sum of X:B in all process dumps in global dump N,
   *    ]
   *
   *    memory:chrome:all_processes:source:X:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A+X:B in all process dumps in global dump 1,
   *          ...
   *          sum of X:A+X:B in all process dumps in global dump N,
   *    ]
   *
   *    memory:chrome:all_processes:source:Y:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of Y in all process dumps in global dump 1,
   *          ...
   *          sum of Y in all process dumps in global dump N
   *    ]
   *
   *    memory:chrome:all_processes:source:proportional_resident_size :
   *        Histogram aggregated over [
   *          sum of X:A+X:B+Y in all process dumps in global dump 1,
   *          ...
   *          sum of X:A+X:B+Y in all process dumps in global dump N
   *        ]
   *
   * where global dumps 1 to N are the global dumps associated with the given
   * browser.
   *
   * @param {!Map<string, !Array<!tr.model.GlobalMemoryDump>}
   *     browserNameToGlobalDumps Map from browser names to arrays of global
   *     memory dumps. The generic values will be extracted from the associated
   *     process memory dumps.
   * @param {!function(!tr.model.GlobalMemoryDump): boolean}
   *     customGlobalDumpFilter Predicate for filtering global memory dumps.
   * @param {!function(
   *     !tr.model.ProcessMemoryDump,
   *     !function(!{
   *         source: string,
   *         componentPath: (!Array<string>|undefined),
   *         propertyName: (string|undefined),
   *         value: (!tr.v.Histogram|number|undefined),
   *         unit: (!tr.b.Unit|undefined),
   *         descriptionPrefixBuilder: (!function(!Array<string>): string)
   *     }))}
   *     customProcessDumpValueExtractor Callback for extracting values from a
   *     process memory dump.
   * @param {!function(!tr.b.MultiDimensionalViewNode)}
   *     customComponentTreeModifier Callback applied to every component tree
   *     wrt each process name.
   * @param {!tr.v.ValueSet} values List of values to which the
   *     resulting aggregated values are added.
   */
  function addMemoryDumpValues(browserNameToGlobalDumps, customGlobalDumpFilter, customProcessDumpValueExtractor, customComponentTreeModifier, values) {
    browserNameToGlobalDumps.forEach(function (globalDumps, browserName) {
      var filteredGlobalDumps = globalDumps.filter(customGlobalDumpFilter);
      var sourceToPropertyToData = extractDataFromGlobalDumps(filteredGlobalDumps, customProcessDumpValueExtractor);
      reportDataAsValues(sourceToPropertyToData, browserName, customComponentTreeModifier, values);
    });
  }

  /**
   * For each global memory dump in |globalDumps|, calculate per-process-name
   * sums of values extracted by |customProcessDumpValueExtractor| from the
   * associated process memory dumps.
   *
   * This function returns the following nested map structure:
   *
   *  Source name (Map key, e.g. 'reported_by_os')
   *    -> Property name (Map key, e.g. 'proportional_resident_size')
   *      -> {unit, descriptionPrefixBuilder, processAndComponentTreeBuilder}
   *
   *  where |processAndComponentTreeBuilder| is a
   *  tr.b.MultiDimensionalViewBuilder:
   *
   *  Browser name (0th dimension key, e.g. 'webview') x
   *    -> Component path (1st dimension keys, e.g. ['system', 'native_heap'])
   *      -> Sum of value over the processes (number).
   *
   * See addMemoryDumpValues for more details.
   */
  function extractDataFromGlobalDumps(globalDumps, customProcessDumpValueExtractor) {
    var sourceToPropertyToData = new Map();
    var dumpCount = globalDumps.length;
    globalDumps.forEach(function (globalDump, dumpIndex) {
      tr.b.iterItems(globalDump.processMemoryDumps, function (_, processDump) {
        extractDataFromProcessDump(processDump, sourceToPropertyToData, dumpIndex, dumpCount, customProcessDumpValueExtractor);
      });
    });
    return sourceToPropertyToData;
  }

  function extractDataFromProcessDump(processDump, sourceToPropertyToData, dumpIndex, dumpCount, customProcessDumpValueExtractor) {
    // Process name is typically 'browser', 'renderer', etc.
    var rawProcessName = processDump.process.name;
    var processNamePath = [canonicalizeProcessName(rawProcessName)];

    customProcessDumpValueExtractor(processDump, function addProcessScalar(spec) {
      if (spec.value === undefined) return;

      var component = spec.component || [];
      function createDetailsForErrorMessage() {
        var propertyUserFriendlyName = spec.property === undefined ? '(undefined)' : spec.property;
        var componentUserFriendlyName = component.length === 0 ? '(empty)' : component.join(':');
        return ['source=', spec.source, ', property=', propertyUserFriendlyName, ', component=', componentUserFriendlyName, ' in ', processDump.process.userFriendlyName].join('');
      }

      var value, unit;
      if (spec.value instanceof tr.v.ScalarNumeric) {
        value = spec.value.value;
        unit = spec.value.unit;
        if (spec.unit !== undefined) {
          throw new Error('Histogram value for ' + createDetailsForErrorMessage() + ' already specifies a unit');
        }
      } else {
        value = spec.value;
        unit = spec.unit;
      }

      var propertyToData = sourceToPropertyToData.get(spec.source);
      if (propertyToData === undefined) {
        propertyToData = new Map();
        sourceToPropertyToData.set(spec.source, propertyToData);
      }

      var data = propertyToData.get(spec.property);
      if (data === undefined) {
        data = {
          processAndComponentTreeBuilder: new tr.b.MultiDimensionalViewBuilder(2 /* dimensions (process name and component path) */
          , dumpCount /* valueCount */),
          unit: unit,
          descriptionPrefixBuilder: spec.descriptionPrefixBuilder
        };
        propertyToData.set(spec.property, data);
      } else if (data.unit !== unit) {
        throw new Error('Multiple units provided for ' + createDetailsForErrorMessage() + ':' + data.unit.unitName + ' and ' + unit.unitName);
      } else if (data.descriptionPrefixBuilder !== spec.descriptionPrefixBuilder) {
        throw new Error('Multiple description prefix builders provided for' + createDetailsForErrorMessage());
      }

      var values = new Array(dumpCount);
      values[dumpIndex] = value;

      data.processAndComponentTreeBuilder.addPath([processNamePath, component] /* path */, values, tr.b.MultiDimensionalViewBuilder.ValueKind.TOTAL /* valueKind */);
    });
  }

  function reportDataAsValues(sourceToPropertyToData, browserName, customComponentTreeModifier, values) {
    // For each source name (e.g. 'reported_by_os')...
    sourceToPropertyToData.forEach(function (propertyToData, sourceName) {
      // For each property name (e.g. 'effective_size')...
      propertyToData.forEach(function (data, propertyName) {
        var tree = data.processAndComponentTreeBuilder.buildTopDownTreeView();
        var unit = data.unit;
        var descriptionPrefixBuilder = data.descriptionPrefixBuilder;

        // Total over 'all' processes...
        customComponentTreeModifier(tree);
        reportComponentDataAsValues(browserName, sourceName, propertyName, 'all_processes', [] /* componentPath */, tree, unit, descriptionPrefixBuilder, values);

        // For each process name (e.g. 'renderer')...
        tree.children[0].forEach(function (processTree, processName) {
          if (processTree.children[0].size > 0) {
            throw new Error('Multi-dimensional view node for source=' + sourceName + ', property=' + (propertyName === undefined ? '(undefined)' : propertyName) + ', process=' + processName + ' has children wrt the process name dimension');
          }
          customComponentTreeModifier(processTree);
          reportComponentDataAsValues(browserName, sourceName, propertyName, processName, [] /* componentPath */, processTree, unit, descriptionPrefixBuilder, values);
        });
      });
    });
  }

  /**
   * For the given |browserName| (e.g. 'chrome'), |processName|
   * (e.g. 'gpu_process'), |propertyName| (e.g. 'effective_size'),
   * |componentPath| (e.g. ['v8']), add a tr.v.Histogram with |unit| aggregating
   * the total values of the associated |componentNode| across all timestamps
   * (corresponding to global memory dumps associated with the given browser)
   * to |values|.
   *
   * See addMemoryDumpValues for more details.
   */
  function reportComponentDataAsValues(browserName, sourceName, propertyName, processName, componentPath, componentNode, unit, descriptionPrefixBuilder, values) {
    // Construct the name of the memory value.
    var nameParts = ['memory', browserName, processName, sourceName].concat(componentPath);
    if (propertyName !== undefined) nameParts.push(propertyName);
    var name = nameParts.join(':');

    // Build the underlying numeric for the memory value.
    var numeric = buildMemoryNumericFromNode(name, componentNode, unit);

    // Build the options for the memory value.
    numeric.description = [descriptionPrefixBuilder(componentPath, processName), 'in', convertBrowserNameToUserFriendlyName(browserName)].join(' ');

    // Report the memory value.
    values.addHistogram(numeric);

    // Recursively report memory values for sub-components.
    var depth = componentPath.length;
    componentPath.push(undefined);
    componentNode.children[1].forEach(function (childNode, childName) {
      componentPath[depth] = childName;
      reportComponentDataAsValues(browserName, sourceName, propertyName, processName, componentPath, childNode, unit, descriptionPrefixBuilder, values);
    });
    componentPath.pop();
  }

  /**
   * Create a memory tr.v.Histogram with |unit| and add all total values in
   * |node| to it.
   */
  function buildMemoryNumericFromNode(name, node, unit) {
    var histogram = new tr.v.Histogram(name, unit, BOUNDARIES_FOR_UNIT_MAP.get(unit));
    node.values.forEach(v => histogram.addSample(v.total));
    return histogram;
  }

  tr.metrics.MetricRegistry.register(memoryMetric, {
    supportsRangeOfInterest: true
  });

  return {
    memoryMetric: memoryMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/iteration_helpers.js":41,"../../base/multi_dimensional_view.js":43,"../../base/range.js":47,"../../base/unit.js":57,"../../model/container_memory_dump.js":109,"../../model/helpers/chrome_model_helper.js":127,"../../model/memory_allocator_dump.js":134,"../../value/histogram.js":189,"../metric_registry.js":83}],91:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright 2016 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/statistics.js");
require("../metric_registry.js");
require("./loading_metric.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {

  // TODO(alexandermont): Per-frame power metric will be deprecated once
  // newer metrics come online.
  // Frame rate, used to divide power sample interval into frames
  // for purposes of per-frame power metric.
  var FRAMES_PER_SEC = 60;
  var FRAME_MS = tr.b.convertUnit(1.0 / FRAMES_PER_SEC, tr.b.UnitScale.Metric.NONE, tr.b.UnitScale.Metric.MILLI);

  /**
   * Returns power data for the specified interval in the form:
   * {
   *   duration: durationInMs,
   *   energy: energyInJ,
   *   power: powerInW
   * }
   */
  function getPowerData_(model, start, end) {
    var durationInMs = end - start;
    var durationInS = tr.b.convertUnit(durationInMs, tr.b.UnitScale.Metric.MILLI, tr.b.UnitScale.Metric.NONE);
    var energyInJ = model.device.powerSeries.getEnergyConsumedInJ(start, end);
    var powerInW = energyInJ / durationInS;
    return { duration: durationInMs, energy: energyInJ, power: powerInW };
  }

  // TODO(alexandermont): When LoadExpectation v1.0 is released,
  // update this function to use the new LoadExpectation rather
  // than calling loading_metric.html. If we set the end of the loading
  // RAIL stage to be the TTI, then we may not even need to treat the loading
  // events separately; we can just treat them like any other RAIL stage
  // (and the RAIL stage boundaries will be the intervals that we want.)
  /**
   * Returns the intervals of time between navigation event and time to
   * interactive.
   */
  function getNavigationTTIIntervals_(model) {
    var values = new tr.v.ValueSet();
    tr.metrics.sh.loadingMetric(values, model);
    var ttiValues = values.getValuesNamed('timeToFirstInteractive');
    var intervals = [];
    for (var bin of tr.b.getOnlyElement(ttiValues).allBins) {
      for (var diagnostics of bin.diagnosticMaps) {
        var breakdown = diagnostics.get('Navigation infos');
        intervals.push(tr.b.Range.fromExplicitRange(breakdown.value.start, breakdown.value.interactive));
      }
    }
    return intervals.sort((x, y) => x.min - y.min);
  }

  /**
   * Creates a histogram suitable for time data.
   */
  function makeTimeHistogram_(values, title, description) {
    var hist = new tr.v.Histogram(title + ':time', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter);
    hist.customizeSummaryOptions({
      avg: false,
      count: false,
      max: true,
      min: true,
      std: false,
      sum: true
    });
    hist.description = 'Time spent in ' + description;
    values.addHistogram(hist);
    return hist;
  }

  /**
   * Creates a histogram suitable for energy data.
   */
  function makeEnergyHistogram_(values, title, description) {
    var hist = new tr.v.Histogram(title + ':energy', tr.b.Unit.byName.energyInJoules_smallerIsBetter);
    hist.customizeSummaryOptions({
      avg: false,
      count: false,
      max: true,
      min: true,
      std: false,
      sum: true
    });
    hist.description = 'Energy consumed in ' + description;
    values.addHistogram(hist);
    return hist;
  }

  /**
   * Creates a histogram suitable for power data.
   */
  function makePowerHistogram_(values, title, description) {
    var hist = new tr.v.Histogram(title + ':power', tr.b.Unit.byName.powerInWatts_smallerIsBetter);
    hist.customizeSummaryOptions({
      avg: true,
      count: false,
      max: true,
      min: true,
      std: false,
      sum: false
    });
    hist.description = 'Energy consumption rate in ' + description;
    values.addHistogram(hist);
    return hist;
  }

  /**
   * Stores the power data in data into the given histograms for time, energy,
   * and power. If a histogram is undefined then the corresponding type of
   * data is not stored.
   *
   * @param {!Object} data - Power data (obtained from getPowerData_)
   * @param {tr.v.Histogram} timeHist - Histogram to store time data.
   * @param {tr.v.Histogram} energyHist - Histogram to store energy data.
   * @param {tr.v.Histogram} powerHist - Histogram to store power data.
   */
  function storePowerData_(data, timeHist, energyHist, powerHist) {
    if (timeHist !== undefined) timeHist.addSample(data.duration);
    if (energyHist !== undefined) energyHist.addSample(data.energy);
    if (powerHist !== undefined) powerHist.addSample(data.power);
  }

  function createHistograms_(model, values) {
    var hists = {};

    // "Generic" RAIL stage metrics. These give time, energy, and power
    // for each RAIL stage, indexed by name. For instance, "Tap Animation"
    // is different from "Tap, Touch Animation". There is one histogram
    // for each RAIL stage name; if there are multiple RAIL stages with
    // the same name, these are different samples in the histogram.
    hists.railStageToTimeHist = new Map();
    hists.railStageToEnergyHist = new Map();
    hists.railStageToPowerHist = new Map();

    // Metrics for scrolling. A scroll stage is any stage with the
    // string "Scroll" in its name. For instance, "Scroll Response",
    // "Scroll Animation", and "Scroll, Touch Animation" are all
    // scroll stages. Histograms for scroll metrics contain one
    // sample for each scroll stage.
    hists.scrollTimeHist = makeTimeHistogram_(values, 'scroll', 'scrolling');
    hists.scrollEnergyHist = makeEnergyHistogram_(values, 'scroll', 'scrolling');
    hists.scrollPowerHist = makePowerHistogram_(values, 'scroll', 'scrolling');

    // Metrics for loading. Loading intervals are defined by the intervals
    // between navigation and TTI (time-to-interactive) given by
    // getNavigationTTIIntervals_. We also have a metric for the energy
    // consumed after load.
    hists.loadTimeHist = makeTimeHistogram_(values, 'load', 'page loads');
    hists.loadEnergyHist = makeEnergyHistogram_(values, 'load', 'page loads');
    hists.afterLoadTimeHist = makeTimeHistogram_(values, 'after_load', 'period after load');
    hists.afterLoadPowerHist = makePowerHistogram_(values, 'after_load', 'period after load');

    // Metrics for video. A video stage is any stage with the string "Video"
    // in its name. Histograms for video metrics contain one sample for each
    // video stage. Only power metrics are available for video stages.
    hists.videoPowerHist = makePowerHistogram_(values, 'video', 'video playback');

    // Frame based power metric.
    hists.frameEnergyHist = makeEnergyHistogram_(values, 'per_frame', 'each frame');

    for (var exp of model.userModel.expectations) {
      var currTitle = exp.title.toLowerCase().replace(' ', '_');
      // If we haven't seen a RAIL stage with this title before,
      // we have to create a new set of histograms for the "generic"
      // RAIL stage metrics.
      if (!hists.railStageToTimeHist.has(currTitle)) {
        var timeHist = makeTimeHistogram_(values, currTitle, 'RAIL stage ' + currTitle);

        var energyHist = makeEnergyHistogram_(values, currTitle, 'RAIL stage ' + currTitle);

        var powerHist = makePowerHistogram_(values, currTitle, 'RAIL stage ' + currTitle);

        hists.railStageToTimeHist.set(currTitle, timeHist);
        hists.railStageToEnergyHist.set(currTitle, energyHist);
        hists.railStageToPowerHist.set(currTitle, powerHist);
      }
    }
    return hists;
  }

  /**
   * Process a single interaction record (RAIL stage) for power metric
   * purposes. This function only keeps track of metrics that are based
   * on the start and end time of the RAIL stages.
   */
  function processInteractionRecord_(exp, model, hists) {
    var currTitle = exp.title.toLowerCase().replace(' ', '_');
    var data = getPowerData_(model, exp.start, exp.end);

    // Add the samples for the "generic" RAIL stage metrics.
    storePowerData_(data, hists.railStageToTimeHist.get(currTitle), hists.railStageToEnergyHist.get(currTitle), hists.railStageToPowerHist.get(currTitle));

    // If this is a scroll stage, add the sample for the scroll metrics.
    if (exp.title.indexOf("Scroll") !== -1) {
      storePowerData_(data, hists.scrollTimeHist, hists.scrollEnergyHist, hists.scrollPowerHist);
    }

    // If this is a video stage, add the sample for the video metrics.
    if (exp.title.indexOf("Video") !== -1) storePowerData_(data, undefined, undefined, hists.videoPowerHist);
  }

  /**
   * Compute the loading power metric from the model and put the results
   * in |hists|. Note that this is not in processInteractionRecord_ because
   * the loading metric intervals don't correspond exactly to the RAIL stages.
   */
  function computeLoadingMetric_(model, hists) {
    var intervals = getNavigationTTIIntervals_(model);
    var lastLoadTime = undefined;
    for (var interval of intervals) {
      var loadData = getPowerData_(model, interval.min, interval.max);
      storePowerData_(loadData, hists.loadTimeHist, hists.loadEnergyHist, undefined);
      lastLoadTime = lastLoadTime == undefined ? interval.max : Math.max(lastLoadTime, interval.max);
    }
    if (lastLoadTime !== undefined) {
      var afterLoadData = getPowerData_(model, lastLoadTime, model.bounds.max);
      storePowerData_(afterLoadData, hists.afterLoadTimeHist, undefined, hists.afterLoadPowerHist);
    }
  }

  /**
   * Compute the per-frame power metrics and put the results in |hists|.
   */
  function computeFrameBasedPowerMetric_(model, hists) {
    model.device.powerSeries.updateBounds();
    var currentTime = model.device.powerSeries.bounds.min;
    while (currentTime < model.device.powerSeries.bounds.max) {
      var frameData = getPowerData_(model, currentTime, currentTime + FRAME_MS);
      hists.frameEnergyHist.addSample(frameData.energy);
      currentTime += FRAME_MS;
    }
  }

  function powerMetric(values, model) {
    if (!model.device.powerSeries) return;

    var hists = createHistograms_(model, values);
    for (var exp of model.userModel.expectations) processInteractionRecord_(exp, model, hists);

    // The following two metrics aren't based directly on the IR intervals,
    // and so need to be computed outside the processInteractionRecord_ loop.
    computeLoadingMetric_(model, hists);
    computeFrameBasedPowerMetric_(model, hists);
  }

  tr.metrics.MetricRegistry.register(powerMetric);

  return {
    powerMetric: powerMetric
  };
});
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"../../base/statistics.js":53,"../../value/histogram.js":189,"../metric_registry.js":83,"./loading_metric.js":88}],92:[function(require,module,exports){
(function (global){
"use strict";
/**
Copyright (c) 2015 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
**/

require("../../base/statistics.js");
require("../metric_registry.js");
require("./utils.js");
require("../../model/user_model/animation_expectation.js");
require("../../model/user_model/load_expectation.js");
require("../../model/user_model/response_expectation.js");
require("../../value/histogram.js");

'use strict';

global.tr.exportTo('tr.metrics.sh', function () {
  // In the case of Response, Load, and DiscreteAnimation IRs, Responsiveness is
  // derived from the time between when the user thinks they begin an interation
  // (expectedStart) and the time when the screen first changes to reflect the
  // interaction (actualEnd).  There may be a delay between expectedStart and
  // when chrome first starts processing the interaction (actualStart) if the
  // main thread is busy.  The user doesn't know when actualStart is, they only
  // know when expectedStart is. User responsiveness, by definition, considers
  // only what the user experiences, so "duration" is defined as actualEnd -
  // expectedStart.

  function computeAnimationThroughput(animationExpectation) {
    if (animationExpectation.frameEvents === undefined || animationExpectation.frameEvents.length === 0) throw new Error('Animation missing frameEvents ' + animationExpectation.stableId);

    var durationInS = tr.b.convertUnit(animationExpectation.duration, tr.b.UnitScale.Metric.MILLI, tr.b.UnitScale.Metric.NONE);
    return animationExpectation.frameEvents.length / durationInS;
  }

  function computeAnimationframeTimeDiscrepancy(animationExpectation) {
    if (animationExpectation.frameEvents === undefined || animationExpectation.frameEvents.length === 0) throw new Error('Animation missing frameEvents ' + animationExpectation.stableId);

    var frameTimestamps = animationExpectation.frameEvents;
    frameTimestamps = frameTimestamps.toArray().map(function (event) {
      return event.start;
    });

    var absolute = true;
    return tr.b.Statistics.timestampsDiscrepancy(frameTimestamps, absolute);
  }

  /**
   * @param {!tr.v.ValueSet} values
   * @param {!tr.model.Model} model
   * @param {!Object=} opt_options
   */
  function responsivenessMetric(values, model, opt_options) {
    var responseNumeric = new tr.v.Histogram('response latency', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, tr.v.HistogramBinBoundaries.createLinear(100, 1e3, 50));
    var throughputNumeric = new tr.v.Histogram('animation throughput', tr.b.Unit.byName.unitlessNumber_biggerIsBetter, tr.v.HistogramBinBoundaries.createLinear(10, 60, 10));
    var frameTimeDiscrepancyNumeric = new tr.v.Histogram('animation frameTimeDiscrepancy', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, tr.v.HistogramBinBoundaries.createLinear(0, 1e3, 50).addExponentialBins(1e4, 10));
    var latencyNumeric = new tr.v.Histogram('animation latency', tr.b.Unit.byName.timeDurationInMs_smallerIsBetter, tr.v.HistogramBinBoundaries.createLinear(0, 300, 60));

    model.userModel.expectations.forEach(function (ue) {
      if (opt_options && opt_options.rangeOfInterest && !opt_options.rangeOfInterest.intersectsExplicitRangeInclusive(ue.start, ue.end)) return;

      var sampleDiagnosticMap = tr.v.d.DiagnosticMap.fromObject({ relatedEvents: new tr.v.d.RelatedEventSet([ue]) });

      // Responsiveness is not defined for Idle or Startup expectations.
      if (ue instanceof tr.model.um.IdleExpectation) {
        return;
      } else if (ue instanceof tr.model.um.StartupExpectation) {
        return;
      } else if (ue instanceof tr.model.um.LoadExpectation) {
        // This is already covered by loadingMetric.
      } else if (ue instanceof tr.model.um.ResponseExpectation) {
        responseNumeric.addSample(ue.duration, sampleDiagnosticMap);
      } else if (ue instanceof tr.model.um.AnimationExpectation) {
        if (ue.frameEvents === undefined || ue.frameEvents.length === 0) {
          // Ignore animation stages that do not have associated frames:
          // https://github.com/catapult-project/catapult/issues/2446
          return;
        }
        var throughput = computeAnimationThroughput(ue);
        if (throughput === undefined) throw new Error('Missing throughput for ' + ue.stableId);

        throughputNumeric.addSample(throughput, sampleDiagnosticMap);

        var frameTimeDiscrepancy = computeAnimationframeTimeDiscrepancy(ue);
        if (frameTimeDiscrepancy === undefined) throw new Error('Missing frameTimeDiscrepancy for ' + ue.stableId);

        frameTimeDiscrepancyNumeric.addSample(frameTimeDiscrepancy, sampleDiagnosticMap);

        ue.associatedEvents.forEach(function (event) {
          if (!(event instanceof tr.e.cc.InputLatencyAsyncSlice)) return;

          latencyNumeric.addSample(event.duration, sampleDiagnosticMap);
        });
      } else {
        throw new Error('Unrecognized stage for ' + ue.stableId);
      }
    });

    [responseNumeric, throughputNumeric, frameTimeDiscrepancyNumeric, latencyNumeric].forEach(function (numeric) {
      numeric.customizeSummaryOptions({
        avg: true,
        max: true,
        min: true,
        std: true
      });
    });

    values.addHistogram(responseNumeric);
    values.addHistogram(throughputNumeric);
    values.addHistogram(frameTimeDiscrepancyNumeric);
    values.addHistogram(latencyNumeric);
  }

  tr.metrics.MetricRegistry.register(responsivenessMetric, {
    supportsRangeOfInterest: true
  });

  return {
    re