/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;

final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    private Comparator<T> comparator;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Ascii.checkNotNull(comparator);
    }

    @Override
    public final int compare(T a, T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public final int hashCode() {
        return this.comparator.hashCode();
    }

    public final String toString() {
        return this.comparator.toString();
    }
}

