use clap::{arg, Command};

use crate::cmd::{
    apply::apply_cmd, behead::behead_cmd, cat::cat_cmd, clipboard::clipboard_cmd, count::count_cmd,
    datefmt::datefmt_cmd, dedup::dedup_cmd, describegpt::describegpt_cmd, diff::diff_cmd,
    edit::edit_cmd, enumerate::enum_cmd, excel::excel_cmd, exclude::exclude_cmd,
    explode::explode_cmd, extdedup::extdedup_cmd, extsort::extsort_cmd, fetch::fetch_cmd,
    fetchpost::fetchpost_cmd, fill::fill_cmd, fixlengths::fixlengths_cmd, flatten::flatten_cmd,
    fmt::fmt_cmd, foreach::foreach_cmd, frequency::frequency_cmd, geocode::geocode_cmd,
    headers::headers_cmd, index::index_cmd, input::input_cmd, join::join_cmd, joinp::joinp_cmd,
    json::json_cmd, jsonl::jsonl_cmd, lens::lens_cmd, luau::luau_cmd, partition::partition_cmd,
    pro::pro_cmd, prompt::prompt_cmd, pseudo::pseudo_cmd, python::py_cmd, rename::rename_cmd,
    replace::replace_cmd, reverse::reverse_cmd, safenames::safenames_cmd, sample::sample_cmd,
    schema::schema_cmd, search::search_cmd, searchset::searchset_cmd, select::select_cmd,
    slice::slice_cmd, snappy::snappy_cmd, sniff::sniff_cmd, sort::sort_cmd,
    sortcheck::sortcheck_cmd, split::split_cmd, sqlp::sqlp_cmd, stats::stats_cmd, table::table_cmd,
    to::to_cmd, tojsonl::tojsonl_cmd, transpose::transpose_cmd, validate::validate_cmd,
};

pub fn build_cli() -> Command {
    Command::new("qsv")
        .args([
            arg!(--list),
            arg!(--envlist),
            arg!(--update),
            arg!(--updatenow),
            arg!(--version),
        ])
        .subcommands([
            apply_cmd(),
            behead_cmd(),
            cat_cmd(),
            clipboard_cmd(),
            count_cmd(),
            datefmt_cmd(),
            dedup_cmd(),
            describegpt_cmd(),
            diff_cmd(),
            edit_cmd(),
            enum_cmd(),
            excel_cmd(),
            exclude_cmd(),
            extdedup_cmd(),
            extsort_cmd(),
            explode_cmd(),
            fetch_cmd(),
            fetchpost_cmd(),
            fill_cmd(),
            fixlengths_cmd(),
            flatten_cmd(),
            fmt_cmd(),
            foreach_cmd(),
            frequency_cmd(),
            geocode_cmd(),
            headers_cmd(),
            index_cmd(),
            input_cmd(),
            join_cmd(),
            joinp_cmd(),
            json_cmd(),
            jsonl_cmd(),
            lens_cmd(),
            luau_cmd(),
            partition_cmd(),
            pro_cmd(),
            prompt_cmd(),
            pseudo_cmd(),
            py_cmd(),
            rename_cmd(),
            replace_cmd(),
            reverse_cmd(),
            safenames_cmd(),
            sample_cmd(),
            schema_cmd(),
            search_cmd(),
            searchset_cmd(),
            select_cmd(),
            slice_cmd(),
            snappy_cmd(),
            sniff_cmd(),
            sort_cmd(),
            sortcheck_cmd(),
            split_cmd(),
            sqlp_cmd(),
            stats_cmd(),
            table_cmd(),
            to_cmd(),
            tojsonl_cmd(),
            transpose_cmd(),
            validate_cmd(),
        ])
}
