// -*- mode: c++; indent-tabs-mode: nil -*-

/*  WebDavHandler.qm Copyright 2019 - 2021 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/


// minimum required Qore version


/** @mainpage WebDavHandler Module

    @tableofcontents

    @section webdavhandlerintro WebDavHandler Module Introduction

    This module provides a WebDavHandler server API.

    Classes provided by this module:
    - @ref WebDavHandler::AbstractWebDavHandler "AbstractWebDavHandler"
    - @ref WebDavHandler::AbstractWebDavPropertyHandler "AbstractWebDavPropertyHandler"
    - @ref WebDavHandler::DummyWebDavHandler "DummyWebDavHandler"
    - @ref WebDavHandler::FsWebDavHandler "FsWebDavHandler"
    - @ref WebDavHandler::InMemoryWebDavPropertyHandler "InMemoryWebDavPropertyHandler"
    - @ref WebDavHandler::WebDavHandlerProxy "WebDavHandlerProxy"

    @note The @ref WebDavHandler::FsWebDavHandler "FsWebDavHandler" class does not support any WebDAV locking
    functionality.

    @section webdavhandler_example WebDavHandler Example

    @code{.py}
%new-style
%require-types
%strict-args
%enable-all-warnings

%requires HttpServer
%requires FsUtil
%requires WebDavHandler

%exec-class Main

class Server inherits HttpServer {
    private {
        int verbose;
        int port;
    }

    constructor(WebDavHandler::AbstractWebDavHandler handler, int verbose = 0) : HttpServer(\log(), \log(), True) {
        self.verbose = verbose;
        setHandler("webdavhandler", "/", NOTHING, handler);
        setDefaultHandler("webdavhandler", handler);

        map addHttpMethod($1), handler.getHttpMethods();

        port = addListener(<HttpListenerOptionInfo>{"service": 0}).port;
    }

    # logger for http server
    log(string str) {
        if (verbose > 2) {
            printf("%N: %s\n", now_us(), vsprintf(str, argv));
        }
    }

    int getPort() {
        return port;
    }
}

class Main {
    constructor() {
        TmpDir tmp("tempdir-");

        WebDavHandler::FsWebDavHandler handler(tmp.path);

        Server srv(handler, m_options.verbose);

        printf("Using tmp path: %s; listening on port %d\n", tmp.path, srv.getPort());

        # wait forever - break with ctrl-C
        while (True) {
            sleep(99999999);
        }
    }
}
    @endcode

    @section webdavhandlerrelnotes Release Notes

    @subsection webdavhandler_v1_0 MapperUtil v1.0
    - initial release
*/

//! Main public WebDavHandler namespace
namespace WebDavHandler {
//! WebDavHandler namespace value
const DavNs = "DAV:";
};

