// -*- mode: c++; indent-tabs-mode: nil -*-
//! Qore SoapRequestDataProvider module definition

/** SoapRequestDataProvider.qc Copyright 2019 - 2020 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version
// assume local scope for variables, do not use "$" signs
// require type definitions everywhere
// strict argument handling
// enable all warnings

//! contains all public definitions in the SoapRequestDataProvider module
namespace SoapDataProvider {
//! The Soap data provider class
class SoapRequestDataProvider : public SoapDataProviderBase {

public:
        //! The SOAP client object for API calls
        __7_ SoapClient soapclient;

        //! If the request supports a list of hashes in the response and therefore the record API
        __7_ hash<string, AbstractDataField> record_type;

    //! Creates the object from the arguments
    constructor(WebService webservice, __7_ SoapClient soapclient, WSOperation op) ;


    //! Returns the data provider name
    string getName();


    //! Returns data provider info
    hash<DataProviderInfo> getInfo();


    //! Returns the description of the record type, if any
/** Returns the record type description for any successful response
    */
protected:
     __7_ hash<string, AbstractDataField> getRecordTypeImpl(__7_ hash<auto> search_options);
public:


    //! Returns the description of a successful request message, if any
protected:
     __7_ AbstractDataProviderType getRequestTypeImpl();
public:


    //! Returns the description of a response message, if this object represents a response message
/** If the object is a request message, then any successful response message should be returned here as well

        @return the response type for this response message

        @throw INVALID-OPERATION the data provider does not support the request API
    */
protected:
     __7_ AbstractDataProviderType getResponseTypeImpl();
public:


    //! Returns a hash of error responses, if any
protected:
     __7_ hash<string, AbstractDataProviderType> getErrorResponseTypesImpl();
public:


    //! Makes a request and returned the response
/** @param req the request to serialize and make according to the request type
        @param request_options the request options; will be processed by validateRequestOptions()

        @return the response to the request
    */
protected:
     auto doRequestImpl(auto req, __7_ hash<auto> request_options);
public:


    //! Returns an iterator for zero or more records matching the search options
/** @param where_cond the search criteria
        @param search_options the search options after processing by validateSearchOptions()

        This will execute the request and perform a default search on any record(s) returned
    */
protected:
     AbstractDataProviderRecordIterator searchRecordsImpl(__7_ hash<auto> where_cond, __7_ hash<auto> search_options);
public:


    //! Makes a REST request and returns the response
protected:
     hash<auto> doRequestIntern(auto req, __7_ hash<auto> options);
public:


    //! Returns a REST client for HTTP operations
protected:
     SoapClient getSoapClient();
public:


    //! Returns data provider static info
protected:
     hash<DataProviderInfo> getStaticInfoImpl();
public:


    //! Returns API options for the current operation
protected:
     __7_ hash<string, hash<DataProviderOptionInfo>> getApiOptions();
public:


    //! Returns the description of the record type, if any
private:
     __7_ hash<string, AbstractDataField> getRecordTypeIntern();
public:

};
};
