// -*- mode: c++; indent-tabs-mode: nil -*-
//! Qore SoapDataProvider module definition

/** SoapDataProviderBase.qc Copyright 2019 - 2020 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version
// assume local scope for variables, do not use "$" signs
// require type definitions everywhere
// strict argument handling
// enable all warnings

//! contains all public definitions in the SoapDataProvider module
namespace SoapDataProvider {
//! The Soap data provider base class
class SoapDataProviderBase : public AbstractDataProvider {

public:
protected:
        //! The WebService object
        WebService webservice;

        //! The operation object
        WSOperation op;

public:

    //! Creates the object from the arguments
    constructor(WebService webservice, WSOperation op);


    //! Returns data provider static info
protected:
     hash<DataProviderInfo> getStaticInfoImpl();
public:

};
};
