# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `convection_lorenz_bridge`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=convection_lorenz_bridge \
  --stan_samples=40000
```
"""

import numpy as np

IDENTITY_MEAN = np.array([
    -0.32005242194483935,
    -0.5232300347036102,
    -0.41531607060488407,
    -0.3607049943217887,
    -0.6946408569136675,
    -0.39620555997668394,
    -0.4275966479985892,
    -0.88548013737075,
    -0.37202569498449795,
    -0.5194210860125,
    -1.1101891233949999,
    -0.3452752139874993,
    -0.6376511490600001,
    -1.3821610663250001,
    -0.315583177629187,
    -0.7864671692875,
    -1.7153471346499998,
    -0.28125712673465353,
    -0.9721868311474999,
    -2.125583522525,
    -0.239378208606778,
    -1.2028627889249999,
    -2.6318541309,
    -0.1854149278464708,
    -1.4886425766000002,
    -3.2569463040000004,
    -0.11229921742158275,
    -1.8420624440249997,
    -4.028488795725001,
    -0.009393016593275374,
    -2.27947481235,
    -4.979454938849999,
    0.1394739429095136,
    -2.8196111182499997,
    -6.14959836655,
    0.3590388535913813,
    -3.4856687644249993,
    -7.58489333465,
    0.6866932449517232,
    -4.30562829155,
    -9.336765644749999,
    1.178869523771676,
    -5.311948032075,
    -11.4590856385,
    1.92014895101075,
    -6.541423614749999,
    -13.999940559750002,
    3.0353795784749997,
    -8.03318100095,
    -16.985271849,
    4.70537541795,
    -9.823657352875,
    -20.387313406249998,
    7.183751285374998,
    -11.936396921500002,
    -24.068372968750005,
    10.806715903374998,
    -14.36275561475,
    -27.690276902,
    15.976858618999998,
    -17.028148594249995,
    -30.5886415015,
    23.079582901000002,
    -19.740221742499998,
    -31.650759996499993,
    32.266677627250004,
    -22.12243320525,
    -29.331219631749995,
    43.042167546250006,
    -23.56434897975,
    -22.08742251575,
    53.724714334249995,
    -23.2691642045,
    -9.520453485649998,
    61.270381140999994,
    -20.51956407075,
    6.155641802024999,
    62.43682934225001,
    -15.184357781499997,
    20.169841364,
    56.585917319500005,
    -8.113225988624999,
    28.454733117,
    47.447260263749996,
    -0.7994181470062112,
    31.0475386405,
    40.3024717615,
    5.5701100068,
    30.626255461499994,
    37.65959062075,
]).reshape((30, 3))

IDENTITY_MEAN_STANDARD_ERROR = np.array([
    0.002618142388610553,
    0.003417998908790185,
    0.0071456997450876384,
    0.0014212135262833563,
    0.0018786804623429469,
    0.006766455579772389,
    0.0007857703112572406,
    0.001080902900156134,
    0.006410821323825943,
    0.00046816127590253,
    0.0007090946036492714,
    0.006076576143795799,
    0.0003403022471573733,
    0.0005839227595827175,
    0.005761671107553729,
    0.00032128966621657875,
    0.0005819099870435152,
    0.00546835872073056,
    0.0003501809927014006,
    0.0006325997917006528,
    0.005195199208874287,
    0.000396322898036143,
    0.0007109829786799278,
    0.004945117808295818,
    0.0004563577477363933,
    0.0008029099323354581,
    0.004718614538882115,
    0.000522072437252026,
    0.0009066997734636203,
    0.004517884303633858,
    0.0005975838879585192,
    0.0010264317270153077,
    0.004349092637344566,
    0.0006802869728028989,
    0.0011568762192828035,
    0.004216969934844887,
    0.0007720786710948246,
    0.0012959319370210126,
    0.0041279246781170086,
    0.0008741323491778938,
    0.0014380954250556655,
    0.004095026795962484,
    0.0009825483748746922,
    0.0015745990662131087,
    0.0041346035745233965,
    0.0010965132718541914,
    0.0016864514779417505,
    0.0042619144411048075,
    0.0012052102590061362,
    0.0017455722321716568,
    0.0044984459636871294,
    0.0013021716461926191,
    0.0017206239728653953,
    0.004859086564483558,
    0.0013656553366488931,
    0.001635623156115934,
    0.005337670073985338,
    0.0013678692864216922,
    0.001645961412909614,
    0.005878720462844858,
    0.0012804657683679673,
    0.002175090101311919,
    0.006325241389148166,
    0.0011414082306137469,
    0.0036023910376394574,
    0.006376596471748276,
    0.0011560404616905776,
    0.005724319862620074,
    0.005601391108253414,
    0.0016562036111363527,
    0.007714783679516545,
    0.004219987801376854,
    0.002643868288520864,
    0.008355916622086878,
    0.0042993283625278106,
    0.0036117697182425816,
    0.007002914757756423,
    0.006577488813531967,
    0.0040074525190132975,
    0.006023737834751119,
    0.0074914709720743464,
    0.003607185148315269,
    0.006957580892384618,
    0.0056316649854458835,
    0.003025049067628891,
    0.007739897619042211,
    0.0028452326832261315,
    0.0029936176892421482,
    0.00763436763211099,
    0.0016262563658474673,
]).reshape((30, 3))

IDENTITY_STANDARD_DEVIATION = np.array([
    0.4941360475356216,
    0.6403965353989608,
    0.8097131748779344,
    0.2680865999854413,
    0.34827470037275754,
    0.7669181887254061,
    0.14667687567551396,
    0.19235864568130073,
    0.7265018221624782,
    0.08297318719108634,
    0.11239808382230092,
    0.6884262021617353,
    0.05232543389706943,
    0.07694974360849129,
    0.6526718761717345,
    0.04137684953360021,
    0.0670919660042545,
    0.6191428004501166,
    0.04062519744076214,
    0.06924382205955244,
    0.5879093522463935,
    0.044090489467859366,
    0.07624339287242832,
    0.5590755876921317,
    0.04945235507476079,
    0.08557285198277804,
    0.5327296611790737,
    0.05589547627714847,
    0.09670628076221455,
    0.5090641407460903,
    0.06336100834657943,
    0.1096243553056778,
    0.48851954588692525,
    0.07196641498906178,
    0.12441575008456321,
    0.47155227635240715,
    0.08173565504117132,
    0.1411989802230645,
    0.45879906820784566,
    0.09285899195925838,
    0.16000577189176074,
    0.451149111001276,
    0.10533607446453996,
    0.1807365112775245,
    0.44993837448064006,
    0.11923490544957407,
    0.2026659861838894,
    0.45690753672044276,
    0.13432382552691724,
    0.22447353255556052,
    0.47457244410462246,
    0.1500838852439296,
    0.24397780961384363,
    0.5058155280967386,
    0.16534640727234218,
    0.2590509124933932,
    0.5535283665587514,
    0.1781990135676246,
    0.2721968840264251,
    0.6177699720606125,
    0.1858121454956043,
    0.3036141279056509,
    0.6910567687599997,
    0.1862629018234693,
    0.4005650644811375,
    0.7514633355285655,
    0.18464448273744632,
    0.5939345408294219,
    0.7606765060393228,
    0.20544478405777494,
    0.8441605102194238,
    0.6897370028150129,
    0.27762828503808845,
    1.0419384193744257,
    0.6127083332889269,
    0.38480937882523725,
    1.074387216527984,
    0.6998983650717889,
    0.47398581330993306,
    0.9777477317497661,
    0.7967406051959286,
    0.5056321896698337,
    0.9178888264964234,
    0.6621426452566082,
    0.4940165682599176,
    0.8917586477169097,
    0.35727691647958276,
    0.48543408316440234,
    0.8429694608254321,
    0.18094139419500194,
]).reshape((30, 3))
