# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `brownian_motion_unknown_scales_missing_middle_observations`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=brownian_motion_unknown_scales_missing_middle_observations \
  --stan_samples=20000
```
"""

import numpy as np

IDENTITY_INNOVATION_NOISE_SCALE_MEAN = np.array([
    0.11984811188,
]).reshape(())

IDENTITY_INNOVATION_NOISE_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.0006217427110662335,
]).reshape(())

IDENTITY_INNOVATION_NOISE_SCALE_STANDARD_DEVIATION = np.array([
    0.0466820841863065,
]).reshape(())

IDENTITY_LOCS_MEAN = np.array([
    0.10274263933826973,
    0.06093274017236995,
    -0.03870019307246051,
    -0.04362268251956746,
    -0.19021639426160203,
    -0.1856622001932033,
    -0.268515130178559,
    -0.260107840175646,
    -0.33343859777099,
    -0.2178855355883539,
    -0.27354818811729353,
    -0.3308308449366638,
    -0.382529765475104,
    -0.432800441460774,
    -0.4940068394726218,
    -0.548606013398624,
    -0.6044912464207985,
    -0.6556945323829905,
    -0.7083657832264301,
    -0.7639149713772999,
    -0.81898230194,
    -0.81053462256,
    -0.77714729583,
    -0.8268097140950001,
    -0.7768991113899999,
    -0.737410627885,
    -0.7740582032650001,
    -0.6294382937,
    -0.67029499304,
    -0.6432216001550001,
]).reshape((30,))

IDENTITY_LOCS_MEAN_STANDARD_ERROR = np.array([
    0.0009405131072736408,
    0.0005486528867378474,
    0.0003114476834287046,
    0.0006412277892027535,
    0.0006854475715429832,
    0.0003078197153769157,
    0.00047118892797200804,
    0.000269194245130316,
    0.0008046292228536764,
    0.0009997739913309622,
    0.0010489118835382062,
    0.0010372266133068682,
    0.001148757627046255,
    0.001182525124387168,
    0.0010569582397812805,
    0.0011620414255526525,
    0.0010453183327721767,
    0.0010311236390033458,
    0.0009012655936333598,
    0.0007196583421953809,
    0.0006105308717894598,
    0.00031982091533824987,
    0.00031883410927158325,
    0.0005715427457512273,
    0.00019000168854908683,
    0.00028494674169841363,
    0.00081181858008416,
    0.0008676835123945669,
    0.0002345009469366628,
    0.00025145183820300795,
]).reshape((30,))

IDENTITY_LOCS_STANDARD_DEVIATION = np.array([
    0.08623810763365827,
    0.07574472701409023,
    0.06866554848723205,
    0.07668282341777974,
    0.07843152706038613,
    0.068576508393855,
    0.07294698700640422,
    0.06860825141223148,
    0.08404231839409118,
    0.09871978459444246,
    0.1502560058940104,
    0.18455832942632247,
    0.2017484447727796,
    0.21099704000209868,
    0.21375294687899568,
    0.2155559325592436,
    0.20996137254177322,
    0.19722942827398696,
    0.17963794076075898,
    0.14308438220112546,
    0.08745916305987847,
    0.07332776115662062,
    0.07028602991206948,
    0.07570528683817498,
    0.0677268360754818,
    0.06851742649255362,
    0.08170311308862943,
    0.08550250851496419,
    0.07184739116387255,
    0.08213098593590987,
]).reshape((30,))

IDENTITY_OBSERVATION_NOISE_SCALE_MEAN = np.array([
    0.10105278383338949,
]).reshape(())

IDENTITY_OBSERVATION_NOISE_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.0006371659328958896,
]).reshape(())

IDENTITY_OBSERVATION_NOISE_SCALE_STANDARD_DEVIATION = np.array([
    0.04442651650456231,
]).reshape(())
