# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `brownian_motion_missing_middle_observations`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=brownian_motion_missing_middle_observations \
  --stan_samples=20000
```
"""

import numpy as np

IDENTITY_MEAN = np.array([
    0.05167758184616446,
    0.030125512461240678,
    -0.031253273044511067,
    -0.07060374562932761,
    -0.15811136619700633,
    -0.192327959970806,
    -0.24608410314198848,
    -0.2648031521125783,
    -0.29870570925666845,
    -0.26964555719658495,
    -0.31682207915630656,
    -0.3640896646524297,
    -0.4109848109303121,
    -0.4584409222423675,
    -0.5058064910225799,
    -0.5528789448342399,
    -0.6003133876002,
    -0.64792853817255,
    -0.6952332388839,
    -0.7426979098050001,
    -0.7900891142149999,
    -0.7981634453399999,
    -0.7891371704199999,
    -0.8025300098000001,
    -0.775166313675,
    -0.74707896299,
    -0.739319148115,
    -0.6698666236200002,
    -0.6674366914900001,
    -0.65289493587,
]).reshape((30,))

IDENTITY_MEAN_STANDARD_ERROR = np.array([
    0.00014626059172871908,
    0.00017973957085776722,
    0.00018641131747566925,
    0.00019223687816980907,
    0.0001959403538962206,
    0.00019622577843726133,
    0.00019876397625472308,
    0.0002030928889134197,
    0.0002187684992704361,
    0.00027062292779216193,
    0.0003923748243609261,
    0.00048424980588471065,
    0.0005484498540114756,
    0.0005945812259637517,
    0.0006166846376199287,
    0.0006132910301920586,
    0.0005902292580951748,
    0.0005502365300877461,
    0.0004854269126840255,
    0.00039687760549255785,
    0.0002724004269851616,
    0.00021684265284245937,
    0.00019698732090895984,
    0.0001905079956966474,
    0.0001896073979966042,
    0.00018869468703268838,
    0.00019282508622181553,
    0.00019960050368744632,
    0.00021452722325422763,
    0.00022613369953943728,
]).reshape((30,))

IDENTITY_STANDARD_DEVIATION = np.array([
    0.0719618757816398,
    0.08099903271693323,
    0.08328326308254738,
    0.08407406143017744,
    0.08424350259115948,
    0.08440305299569849,
    0.08475062283943205,
    0.0855221272386321,
    0.08873528295682498,
    0.09990514558311883,
    0.13269640507018457,
    0.15380572973263423,
    0.1679748827543528,
    0.176818598515493,
    0.18137557669189266,
    0.1814002460295171,
    0.17713165314754242,
    0.16811004096682022,
    0.15374583415208248,
    0.132561174689232,
    0.09982286650376815,
    0.08887761593633146,
    0.0857755866316838,
    0.08483688811970158,
    0.08462681160436991,
    0.08456369390314696,
    0.0847240499249728,
    0.08592170652847987,
    0.08983119794928614,
    0.10383783649994013,
]).reshape((30,))
