# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
# pylint: disable=line-too-long
r"""Synthetic dataset generated from the LogGaussianCoxProcess model.

This was generated using the following snippet:

```python
import tensorflow.compat.v2 as tf
tf.enable_v2_behavior()

import tensorflow_probability as tfp
from inference_gym.internal import array_to_source
from inference_gym import using_tensorflow as gym
import numpy as np

rng = np.random.RandomState(seed=1)

locations = np.stack(np.meshgrid(np.arange(10), np.arange(10)),
                     -1).astype(np.float64).reshape((-1, 2))
extents = np.ones(100)
dummy_counts = 100 * np.ones(100)

model = gym.targets.LogGaussianCoxProcess(
    train_locations=locations, train_extents=extents, train_counts=dummy_counts)
dataset = model._sample_dataset(seed=2)

sources = []
sources.append(
    array_to_source.array_to_source(
        'LOCATIONS', dataset['train_locations']))
sources.append(
    array_to_source.array_to_source(
        'EXTENTS', dataset['train_extents']))
sources.append(
    array_to_source.array_to_source(
        'COUNTS', dataset['train_counts']))

with open('/tmp/synthetic_log_gaussian_cox_process.py', 'w') as f:
  f.write("\n\n".join(sources))
```

Note that the final `_sample_dataset` is not reproducible, hence the output is
checked in.

"""

import numpy as np

LOCATIONS = np.array([
    0.,
    0.,
    1.,
    0.,
    2.,
    0.,
    3.,
    0.,
    4.,
    0.,
    5.,
    0.,
    6.,
    0.,
    7.,
    0.,
    8.,
    0.,
    9.,
    0.,
    0.,
    1.,
    1.,
    1.,
    2.,
    1.,
    3.,
    1.,
    4.,
    1.,
    5.,
    1.,
    6.,
    1.,
    7.,
    1.,
    8.,
    1.,
    9.,
    1.,
    0.,
    2.,
    1.,
    2.,
    2.,
    2.,
    3.,
    2.,
    4.,
    2.,
    5.,
    2.,
    6.,
    2.,
    7.,
    2.,
    8.,
    2.,
    9.,
    2.,
    0.,
    3.,
    1.,
    3.,
    2.,
    3.,
    3.,
    3.,
    4.,
    3.,
    5.,
    3.,
    6.,
    3.,
    7.,
    3.,
    8.,
    3.,
    9.,
    3.,
    0.,
    4.,
    1.,
    4.,
    2.,
    4.,
    3.,
    4.,
    4.,
    4.,
    5.,
    4.,
    6.,
    4.,
    7.,
    4.,
    8.,
    4.,
    9.,
    4.,
    0.,
    5.,
    1.,
    5.,
    2.,
    5.,
    3.,
    5.,
    4.,
    5.,
    5.,
    5.,
    6.,
    5.,
    7.,
    5.,
    8.,
    5.,
    9.,
    5.,
    0.,
    6.,
    1.,
    6.,
    2.,
    6.,
    3.,
    6.,
    4.,
    6.,
    5.,
    6.,
    6.,
    6.,
    7.,
    6.,
    8.,
    6.,
    9.,
    6.,
    0.,
    7.,
    1.,
    7.,
    2.,
    7.,
    3.,
    7.,
    4.,
    7.,
    5.,
    7.,
    6.,
    7.,
    7.,
    7.,
    8.,
    7.,
    9.,
    7.,
    0.,
    8.,
    1.,
    8.,
    2.,
    8.,
    3.,
    8.,
    4.,
    8.,
    5.,
    8.,
    6.,
    8.,
    7.,
    8.,
    8.,
    8.,
    9.,
    8.,
    0.,
    9.,
    1.,
    9.,
    2.,
    9.,
    3.,
    9.,
    4.,
    9.,
    5.,
    9.,
    6.,
    9.,
    7.,
    9.,
    8.,
    9.,
    9.,
    9.,
]).reshape((100, 2))


EXTENTS = np.array([
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
    1.,
]).reshape((100,))


COUNTS = np.array([
    116,
    83,
    64,
    126,
    123,
    81,
    102,
    77,
    149,
    154,
    149,
    124,
    47,
    157,
    91,
    99,
    95,
    83,
    75,
    189,
    111,
    62,
    86,
    43,
    83,
    131,
    89,
    114,
    80,
    73,
    82,
    115,
    101,
    81,
    100,
    66,
    119,
    134,
    159,
    84,
    77,
    153,
    123,
    56,
    145,
    49,
    156,
    99,
    113,
    116,
    102,
    123,
    100,
    78,
    61,
    93,
    80,
    118,
    52,
    71,
    113,
    86,
    57,
    91,
    74,
    100,
    89,
    70,
    65,
    52,
    60,
    90,
    82,
    62,
    139,
    126,
    65,
    128,
    112,
    92,
    197,
    72,
    146,
    162,
    124,
    80,
    103,
    89,
    80,
    78,
    136,
    118,
    83,
    29,
    132,
    85,
    92,
    104,
    89,
    133,
]).reshape((100,))
