/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.avro.mojo;

import org.codehaus.plexus.util.FileUtils;

import java.io.File;

/**
 * Test the Schema Mojo.
 *
 * @author saden
 */
public class TestSchemaMojo extends AbstractAvroMojoTest {

  protected File jodaTestPom = new File(getBasedir(), "src/test/resources/unit/schema/pom-joda.xml");
  protected File jsr310TestPom = new File(getBasedir(), "src/test/resources/unit/schema/pom-jsr310.xml");
  protected File injectingVelocityToolsTestPom = new File(getBasedir(),
      "src/test/resources/unit/schema/pom-injecting-velocity-tools.xml");

  public void testSchemaMojoJoda() throws Exception {
    SchemaMojo mojo = (SchemaMojo) lookupMojo("schema", jodaTestPom);

    assertNotNull(mojo);
    mojo.execute();

    File outputDir = new File(getBasedir(), "target/test-harness/schema-joda/test");
    String[] generatedFiles = new String[] { "PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java",
        "SchemaUser.java" };

    assertFilesExist(outputDir, generatedFiles);

    String schemaUserContent = FileUtils.fileRead(new File(outputDir, "SchemaUser.java"));
    assertTrue(schemaUserContent.contains("org.joda.time.DateTime"));
  }

  public void testSchemaMojoJsr310() throws Exception {
    SchemaMojo mojo = (SchemaMojo) lookupMojo("schema", jsr310TestPom);

    assertNotNull(mojo);
    mojo.execute();

    File outputDir = new File(getBasedir(), "target/test-harness/schema-jsr310/test");
    String[] generatedFiles = new String[] { "PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java",
        "SchemaUser.java" };

    assertFilesExist(outputDir, generatedFiles);

    String schemaUserContent = FileUtils.fileRead(new File(outputDir, "SchemaUser.java"));
    assertTrue(schemaUserContent.contains("java.time.Instant"));
  }

  public void testSetCompilerVelocityAdditionalTools() throws Exception {
    SchemaMojo mojo = (SchemaMojo) lookupMojo("schema", injectingVelocityToolsTestPom);

    assertNotNull(mojo);
    mojo.execute();

    File outputDir = new File(getBasedir(), "target/test-harness/schema/test");
    String[] generatedFiles = new String[] { "PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java",
        "SchemaUser.java" };

    assertFilesExist(outputDir, generatedFiles);

    String schemaUserContent = FileUtils.fileRead(new File(outputDir, "SchemaUser.java"));
    assertTrue(schemaUserContent.contains("It works!"));
  }
}
