from .. import Provider as LoremProvider


class Provider(LoremProvider):
    """Implement lorem provider for ``fa_IR`` locale.

    Word list is based on the source(s) below, and some words have been removed
    to make the word list appropriate for public testing.

    Sources:

    - https://1000mostcommonwords.com/1000-most-common-persian-words/
    """

    word_list = (
        "عنوان",
        "من",
        "خود",
        "که",
        "او",
        "بود",
        "برای",
        "در",
        "با",
        "آن‌ها",
        "بودن",
        "در",
        "یک",
        "دارند",
        "این",
        "از",
        "توسط",
        "داغ",
        "کلمه",
        "اما",
        "چه",
        "برخی",
        "است",
        "آن",
        "شما",
        "یا",
        "حال",
        "تر",
        "از",
        "به",
        "و",
        "دست",
        "در",
        "ما",
        "می‌توانید",
        "از",
        "دیگر",
        "بود",
        "که",
        "انجام",
        "شان",
        "زمان",
        "اگر",
        "خواهد‌شد",
        "چگونه",
        "گفت:",
        "پا",
        "هر",
        "بگو",
        "می‌کند",
        "مجموعه",
        "سه",
        "می‌خواهم",
        "هوا",
        "خوبی",
        "همچنین",
        "بازی",
        "کوچک",
        "پایان",
        "قراردادن",
        "خانه",
        "به‌عنوان",
        "دست",
        "بندر",
        "بزرگ",
        "طلسم",
        "اضافه",
        "حتی",
        "زمین",
        "اینجا",
        "باید",
        "بزرگ",
        "بالا",
        "ازجمله",
        "دنبال",
        "عمل",
        "بپرسید",
        "مردها",
        "تغییر",
        "رفت",
        "نور",
        "نوع",
        "خاموش",
        "نیاز",
        "خانه",
        "تصویر",
        "سعی‌کنید",
        "ما",
        "دوباره",
        "حیوانات",
        "نقطه",
        "مادر",
        "جهان",
        "در‌نزدیکی",
        "ساخت",
        "خود",
        "زمین",
        "پدر",
        "هر",
        "جدید",
        "کار",
        "بخش",
        "را",
        "دریافت",
        "محل",
        "ساخته",
        "زنده",
        "کمی",
        "تنها",
        "دور",
        "مرد",
        "سال",
        "آمد",
        "نمایش",
        "هر",
        "خوب",
        "را",
        "ما",
        "در",
        "بسیار",
        "فقط",
        "فرم",
        "حکم",
        "بزرگ",
        "می‌گویند",
        "کمک",
        "کم",
        "خط",
        "متفاوت",
        "علت",
        "بسیار",
        "متوسط",
        "قبل",
        "حرکت",
        "راست",
        "پسر",
        "قدیمی",
        "هم",
        "همان",
        "او",
        "همه",
        "وجوددارد",
        "بالا",
        "استفاده",
        "راه",
        "درمورد",
        "نوشتن",
        "را",
        "مانند",
        "تا",
        "این‌ها",
        "او",
        "طولانی",
        "را",
        "ببینید",
        "او",
        "دو",
        "دارد",
        "نگاه",
        "تر",
        "روز",
        "می‌تواند",
        "به",
        "آمده",
        "انجام",
        "تعداد",
        "صدا",
        "هیچ",
        "بیشترین",
        "مردم",
        "من",
        "روی",
        "می‌دانم",
        "اب",
        "تماس",
        "اولین",
        "که",
        "پایین",
        "سمت",
        "بوده",
        "ساعت",
        "سر",
        "ایستادن",
        "خود",
        "صفحه",
        "باید",
        "کشور",
        "یافت",
        "پاسخ",
        "مدرسه",
        "رشد",
        "مطالعه",
        "هنوز",
        "یادگیری",
        "کارخانه",
        "پوشش",
        "آفتاب",
        "چهار",
        "بین",
        "دولت",
        "چشم",
        "هرگز",
        "آخرین",
        "اجازه",
        "فکر",
        "شهرستان",
        "درخت",
        "صلیب",
        "مزرعه",
        "سخت",
        "شروع",
        "زور",
        "داستان",
        "اره",
        "بسیار",
        "دریا",
        "اواخر",
        "اجرا",
        "نکن",
        "مطبوعات",
        "نزدیک",
        "شب",
        "واقعی",
        "زندگی",
        "کم",
        "شمال",
        "کتاب",
        "حمل",
        "علم",
        "خوردن",
        "اتاق",
        "دوستان",
        "ایده",
        "ماهی",
        "کوه",
        "توقف",
        "پایه",
        "گوش",
        "اسب",
        "برش",
        "مطمئن",
        "تماشای",
        "رنگ",
        "صورت",
        "چوب",
        "اصلی",
        "باز",
        "باهم",
        "بعدی",
        "سفید",
        "کودکان",
        "شروع",
        "رو",
        "مثال",
        "آسان",
        "مقاله",
        "گروه",
        "همیشه",
        "موسیقی",
        "آن",
        "هردو",
        "علامت",
        "غالبا",
        "نامه",
        "مایل",
        "رودخانه",
        "اتومبیل",
        "پا",
        "مراقبت",
        "دوم",
        "کافی",
        "ساده",
        "دختر",
        "معمول",
        "جوان",
        "اماده",
        "بالا",
        "همیشه",
        "قرمز",
        "لیست",
        "هرچند",
        "احساس",
        "بحث",
        "پرنده",
        "بزودی",
        "بدن",
        "سگ",
        "خانواده",
        "مستقیم",
        "مطرح",
        "ترک",
        "آهنگ",
        "درب",
        "محصول",
        "کوتاه",
        "کلاس",
        "باد",
        "سوال",
        "کامل",
        "کشتی",
        "منطقه",
        "نیم",
        "سنگ",
        "منظور",
        "آتش",
        "جنوب",
        "مشکل",
        "قطعه",
        "گفت",
        "عبور",
        "بالا",
        "تمام",
        "پادشاه",
        "خیابان",
        "اینچ",
        "ضرب",
        "هیچ",
        "البته",
        "اقامت",
        "چرخ",
        "کامل",
        "نیروی",
        "آبی",
        "شی",
        "سطح",
        "عمیق",
        "ماه",
        "جزیره",
        "پا",
        "سیستم",
        "مشغول",
        "آزمون",
        "رکورد",
        "قایق",
        "مشترک",
        "طلا",
        "ممکن",
        "هواپیما",
        "جا",
        "خشک",
        "خنده",
        "هزار",
        "پیش",
        "فرار",
        "بررسی",
        "بازی",
        "شکل",
        "برابر",
        "داغ",
        "دست",
        "آورده",
        "حرارت",
        "برف",
        "لاستیک",
        "را",
        "بله",
        "دور",
        "پر",
        "شرق",
        "رنگ",
        "زبان",
        "درمیان",
        "واحد",
        "قدرت",
        "شهر",
        "خوب",
        "معین",
        "پرواز",
        "سقوط",
        "شود",
        "فریاد",
        "تاریک",
        "ماشین",
        "یادداشت",
        "صبر",
        "برنامه",
        "شکل",
        "ستاره",
        "جعبه",
        "اسم",
        "حوزه",
        "بقیه",
        "درست",
        "قادر",
        "پوند",
        "انجام",
        "زیبایی",
        "درایو",
        "شامل",
        "جلو",
        "آموزش",
        "هفته",
        "نهایی",
        "به",
        "سبز",
        "آه",
        "سریع",
        "توسعه",
        "اقیانوس",
        "گرم",
        "رایگان",
        "دقیقه",
        "قوی",
        "ویژه",
        "ذهن",
        "روشن",
        "دم",
        "محصول",
        "واقع",
        "فضا",
        "شنیده",
        "بهترین",
        "ساعت",
        "بهتر",
        "در",
        "صد",
        "پنج",
        "گام",
        "اوایل",
        "غرب",
        "زمین",
        "علاقه",
        "سریع",
        "فعل",
        "شش",
        "جدول",
        "سفر",
        "کمتر",
        "صبح",
        "ده",
        "ساده",
        "چند",
        "واکه",
        "جنگ",
        "دربرابر",
        "الگوی",
        "کند",
        "مرکز",
        "فرد",
        "پول",
        "خدمت",
        "جاده",
        "نقشه",
        "باران",
        "قانون",
        "حکومت",
        "کشیدن",
        "سرد",
        "اطلاع",
        "صدای",
        "انرژی",
        "شکار",
        "احتمالی",
        "تخت",
        "برادر",
        "سوار",
        "سلول",
        "باور",
        "شاید",
        "ناگهانی",
        "شمار",
        "مربع",
        "دلیل",
        "طول",
        "نمایندگی",
        "هنر",
        "موضوع",
        "منطقه",
        "اندازه",
        "کنند",
        "وزن",
        "عمومی",
        "یخ",
        "موضوع",
        "دایره",
        "جفت",
        "تقسیم",
        "هجاز",
        "نمد",
        "بزرگ",
        "توپ",
        "هنوز",
        "موج",
        "قلب",
        "ساعت",
        "حاضر",
        "سنگین",
        "رقص",
        "موتور",
        "موقعیت",
        "دست",
        "گسترده",
        "بادبان",
        "ماده",
        "بخش",
        "جنگل",
        "نشستن",
        "مسابقه",
        "پنجره",
        "فروشگاه",
        "تابستان",
        "قطار",
        "خواب",
        "ثابت",
        "تنها",
        "پا",
        "ورزش",
        "دیوار",
        "گرفتن",
        "کوه",
        "آرزو",
        "آسمان",
        "لذت",
        "زمستان",
        "شنبه",
        "وحشی",
        "ابزار",
        "شیشه‌ای",
        "چمن",
        "گاو",
        "کار",
        "لبه",
        "علامت",
        "بازدید",
        "گذشته",
        "نرم",
        "سرگرم",
        "روشن",
        "گاز",
        "ماه",
        "میلیون",
        "تحمل",
        "پایان",
        "شاد",
        "امیدوارم",
        "گل",
        "پوشاندن",
        "رفته",
        "تجارت",
        "ملودی",
        "سفر",
        "دفتر",
        "دریافت",
        "ردیف",
        "دهان",
        "دقیق",
        "نماد",
        "مرگ",
        "کمترین",
        "مشکل",
        "فریاد",
        "جز",
        "نوشت",
        "دانه",
        "تن",
        "عضویت",
        "تمیز",
        "استراحت",
        "خانم",
        "حیاط",
        "افزایش",
        "بد",
        "ضربه",
        "نفت",
        "خون",
        "رشد",
        "در‌صد",
        "مخلوط",
        "تیم",
        "سیم",
        "هزینه",
        "قهوه‌ای",
        "لباس",
        "باغ",
        "برابر",
        "ارسال",
        "کنید",
        "سقوط",
        "مناسب",
        "جریان",
        "عادلانه",
        "بانک",
        "ذخیره",
        "کنترل",
        "اعشاری",
        "گوش",
        "دیگر",
        "کاملا",
        "شکست",
        "مورد",
        "متوسط",
        "کشتن",
        "پسر",
        "دریاچه",
        "لحظه‌ای",
        "مقیاس",
        "باصدا",
        "بهار",
        "مشاهده",
        "کودک",
        "مستقیم",
        "همخوان",
        "کشور",
        "شیر",
        "سرعت",
        "روش",
        "عضو",
        "پرداخت",
        "سن",
        "بخش",
        "لباس",
        "ابر",
        "تعجب",
        "آرام",
        "سنگ",
        "کوچک",
        "صعود",
        "سرد",
        "طراحی",
        "ضعیف",
        "زیادی",
        "تجربه",
        "پایین",
        "کلید",
        "اهن",
        "تک",
        "چوب",
        "تخت",
        "بیست",
        "پوست",
        "لبخند",
        "چینی",
        "سوراخ",
        "کودک",
        "هشت",
        "روستای",
        "ملاقات",
        "ریشه",
        "خرید",
        "بالابردن",
        "حل",
        "فلز",
        "چه",
        "فشار",
        "هفت",
        "بند",
        "سوم",
        "باید",
        "مو",
        "توصیف",
        "آشپز",
        "طبقه",
        "یا",
        "نتیجه",
        "رایت",
        "تپه",
        "امن",
        "گربه",
        "قرن",
        "در‌نظر",
        "نوع",
        "قانون",
        "بیت",
        "ساحل",
        "کپی",
        "عبارت",
        "خاموش",
        "بلند",
        "شن",
        "خاک",
        "رول",
        "انگشت",
        "صنعت",
        "ارزش",
        "مبارزه",
        "دروغ",
        "تحریک",
        "طبیعی",
        "نظر",
        "احساس",
        "سرمایه",
        "نه",
        "صندلی",
        "خطر",
        "میوه",
        "غنی",
        "ضخامت",
        "سرباز",
        "روند",
        "کار",
        "عمل",
        "جداگانه",
        "دشوار",
        "دکتر",
        "لطفا",
        "محافظت",
        "ظهر",
        "محصول",
        "مدرن",
        "عنصر",
        "ضربه",
        "گوشه",
        "حزب",
        "عرضه",
        "که",
        "قرار",
        "حلقه",
        "شخصیت",
        "حشرات",
        "گرفتار",
        "دوره",
        "رادیو",
        "صحبت",
        "اتم",
        "انسانی",
        "تاریخ",
        "اثر",
        "برق",
        "انتظار",
        "استخوان",
        "نرده",
        "ارائه",
        "توافق",
        "بنابراین",
        "ملایم",
        "زن",
        "کاپیتان",
        "لازم",
        "تیز",
        "بال",
        "ایجاد",
        "همسایه",
        "شستشو",
        "خفاش",
        "نه",
        "جمعیت",
        "ذرت",
        "مقایسه",
        "شعر",
        "رشته",
        "زنگ",
        "گوشت",
        "مالیدن",
        "لوله",
        "معروف",
        "دلار",
        "جریان",
        "ترس",
        "نظر",
        "نازک",
        "مثلث",
        "سیاره",
        "عجله‌ای",
        "رئیس",
        "مستعمره",
        "ساعت",
        "معدن",
        "کراوات",
        "اصلی",
        "تازه",
        "جستجو",
        "ارسال",
        "زرد",
        "اسلحه",
        "اجازه",
        "چاپ",
        "مرده",
        "نقطه",
        "بیابان",
        "جریان",
        "آسانسور",
        "افزایش",
        "رسیدن",
        "کارشناس",
        "آهنگ",
        "ساحل",
        "بخش",
        "ورق",
        "ماده",
        "اتصال",
        "پست",
        "وتر",
        "چربی",
        "خوشحالم",
        "اصلی",
        "سهم",
        "ایستگاه",
        "پدر",
        "نان",
        "شارژ",
        "مناسب",
        "بار",
        "پیشنهاد",
        "بخش",
        "برده",
        "اردک",
        "فوری",
        "بازار",
        "درجه",
        "جمعیت",
        "جوجه",
        "عزیز",
        "دشمن",
        "پاسخ",
        "نوشابه",
        "پشتیبانی",
        "سخنرانی",
        "طبیعت",
        "دامنه",
        "بخار",
        "حرکت",
        "راه",
        "مایع",
        "دندانها",
        "پوسته",
        "گردن",
        "اکسیژن",
        "قند",
        "مرگ",
        "خوب",
        "مهارت",
        "زنان",
        "فصل",
        "مغناطیس",
        "نقره‌ای",
        "تشکر",
        "شاخه",
        "مسابقه",
        "پسوند",
        "ویژه",
        "انجیر",
        "ترس",
        "بزرگ",
        "خواهر",
        "فولاد",
        "بحث",
        "مشابه",
        "راهنمایی",
        "تجربه",
        "نمره",
        "سیب",
        "خریداری",
        "رهبری",
        "زمین",
        "کت",
        "جرم",
        "کارت",
        "گروه",
        "طناب",
        "لغزش",
        "برنده",
        "رویا",
        "شب",
        "شرایط",
        "خوراک",
        "ابزار",
        "کل",
        "اساسی",
        "بوی",
        "دره",
        "دو",
        "صندلی",
        "ادامه",
        "بلوک",
        "نمودار",
        "کلاه",
        "فروش",
        "موفقیت",
        "شرکت",
        "تفریق",
        "رویداد",
        "خاص",
        "معامله",
        "شنا",
        "مدت",
        "همسر",
        "کفش",
        "شانه",
        "گسترش",
        "ترتیب",
        "اردوگاه",
        "اختراع",
        "پنبه",
        "متولد",
        "تعیین",
        "کوارت",
        "نه",
        "کامیون",
        "سطح",
        "شانس",
        "فروشگاه",
        "کشش",
        "پرتاب",
        "درخشش",
        "خاصیت",
        "ستون",
        "مولکول",
        "اشتباه",
        "خاکستری",
        "تکرار",
        "نیاز",
        "پهن",
        "آماده",
        "نمک",
        "بینی",
        "جمع",
        "خشم",
        "ادعا",
        "قاره",
    )
