/*******************************************************************************
 * Copyright (c) 2018, College of William & Mary
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the College of William & Mary nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COLLEGE OF WILLIAM & MARY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PRIMME: https://github.com/primme/primme
 * Contact: Andreas Stathopoulos, a n d r e a s _at_ c s . w m . e d u
 *******************************************************************************
 *   NOTE: THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DON'T MODIFY
 ******************************************************************************/


#ifndef auxiliary_eigs_normal_H
#define auxiliary_eigs_normal_H
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Sprimme)
#  define Num_compute_residuals_Sprimme CONCAT(Num_compute_residuals_,WITH_KIND(SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Rprimme)
#  define Num_compute_residuals_Rprimme CONCAT(Num_compute_residuals_,WITH_KIND(REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SHprimme)
#  define Num_compute_residuals_SHprimme CONCAT(Num_compute_residuals_,WITH_KIND(HOST_SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RHprimme)
#  define Num_compute_residuals_RHprimme CONCAT(Num_compute_residuals_,WITH_KIND(HOST_REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SXprimme)
#  define Num_compute_residuals_SXprimme CONCAT(Num_compute_residuals_,WITH_KIND(XSCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RXprimme)
#  define Num_compute_residuals_RXprimme CONCAT(Num_compute_residuals_,WITH_KIND(XREAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Shprimme)
#  define Num_compute_residuals_Shprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Rhprimme)
#  define Num_compute_residuals_Rhprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Ssprimme)
#  define Num_compute_residuals_Ssprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Rsprimme)
#  define Num_compute_residuals_Rsprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Sdprimme)
#  define Num_compute_residuals_Sdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Rdprimme)
#  define Num_compute_residuals_Rdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Sqprimme)
#  define Num_compute_residuals_Sqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_Rqprimme)
#  define Num_compute_residuals_Rqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SXhprimme)
#  define Num_compute_residuals_SXhprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RXhprimme)
#  define Num_compute_residuals_RXhprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SXsprimme)
#  define Num_compute_residuals_SXsprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RXsprimme)
#  define Num_compute_residuals_RXsprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SXdprimme)
#  define Num_compute_residuals_SXdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RXdprimme)
#  define Num_compute_residuals_RXdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SXqprimme)
#  define Num_compute_residuals_SXqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RXqprimme)
#  define Num_compute_residuals_RXqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SHhprimme)
#  define Num_compute_residuals_SHhprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RHhprimme)
#  define Num_compute_residuals_RHhprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SHsprimme)
#  define Num_compute_residuals_SHsprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RHsprimme)
#  define Num_compute_residuals_RHsprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SHdprimme)
#  define Num_compute_residuals_SHdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RHdprimme)
#  define Num_compute_residuals_RHdprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_SHqprimme)
#  define Num_compute_residuals_SHqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_residuals_RHqprimme)
#  define Num_compute_residuals_RHqprimme CONCAT(Num_compute_residuals_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
int Num_compute_residuals_dprimme(PRIMME_INT m, int n, dummy_type_dprimme *eval,
      dummy_type_dprimme *Bx, PRIMME_INT ldBx, dummy_type_dprimme *Ax, PRIMME_INT ldAx, dummy_type_dprimme *r,
      PRIMME_INT ldr, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Sprimme)
#  define Num_update_VWXR_Sprimme CONCAT(Num_update_VWXR_,WITH_KIND(SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Rprimme)
#  define Num_update_VWXR_Rprimme CONCAT(Num_update_VWXR_,WITH_KIND(REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SHprimme)
#  define Num_update_VWXR_SHprimme CONCAT(Num_update_VWXR_,WITH_KIND(HOST_SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RHprimme)
#  define Num_update_VWXR_RHprimme CONCAT(Num_update_VWXR_,WITH_KIND(HOST_REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SXprimme)
#  define Num_update_VWXR_SXprimme CONCAT(Num_update_VWXR_,WITH_KIND(XSCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RXprimme)
#  define Num_update_VWXR_RXprimme CONCAT(Num_update_VWXR_,WITH_KIND(XREAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Shprimme)
#  define Num_update_VWXR_Shprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Rhprimme)
#  define Num_update_VWXR_Rhprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Ssprimme)
#  define Num_update_VWXR_Ssprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Rsprimme)
#  define Num_update_VWXR_Rsprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Sdprimme)
#  define Num_update_VWXR_Sdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Rdprimme)
#  define Num_update_VWXR_Rdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Sqprimme)
#  define Num_update_VWXR_Sqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_Rqprimme)
#  define Num_update_VWXR_Rqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SXhprimme)
#  define Num_update_VWXR_SXhprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RXhprimme)
#  define Num_update_VWXR_RXhprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SXsprimme)
#  define Num_update_VWXR_SXsprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RXsprimme)
#  define Num_update_VWXR_RXsprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SXdprimme)
#  define Num_update_VWXR_SXdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RXdprimme)
#  define Num_update_VWXR_RXdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SXqprimme)
#  define Num_update_VWXR_SXqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RXqprimme)
#  define Num_update_VWXR_RXqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SHhprimme)
#  define Num_update_VWXR_SHhprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RHhprimme)
#  define Num_update_VWXR_RHhprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SHsprimme)
#  define Num_update_VWXR_SHsprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RHsprimme)
#  define Num_update_VWXR_RHsprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SHdprimme)
#  define Num_update_VWXR_SHdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RHdprimme)
#  define Num_update_VWXR_RHdprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_SHqprimme)
#  define Num_update_VWXR_SHqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_update_VWXR_RHqprimme)
#  define Num_update_VWXR_RHqprimme CONCAT(Num_update_VWXR_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
int Num_update_VWXR_dprimme(dummy_type_dprimme *V, dummy_type_dprimme *W, dummy_type_dprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_dprimme *h, int nh, int ldh, dummy_type_dprimme *hVals,
      dummy_type_dprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_dprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_dprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_dprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_dprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_dprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_dprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_dprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_dprimme *G, int nG, int ldG,
      dummy_type_dprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Sprimme)
#  define convTestFun_Sprimme CONCAT(convTestFun_,WITH_KIND(SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Rprimme)
#  define convTestFun_Rprimme CONCAT(convTestFun_,WITH_KIND(REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SHprimme)
#  define convTestFun_SHprimme CONCAT(convTestFun_,WITH_KIND(HOST_SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RHprimme)
#  define convTestFun_RHprimme CONCAT(convTestFun_,WITH_KIND(HOST_REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SXprimme)
#  define convTestFun_SXprimme CONCAT(convTestFun_,WITH_KIND(XSCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RXprimme)
#  define convTestFun_RXprimme CONCAT(convTestFun_,WITH_KIND(XREAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Shprimme)
#  define convTestFun_Shprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Rhprimme)
#  define convTestFun_Rhprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Ssprimme)
#  define convTestFun_Ssprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Rsprimme)
#  define convTestFun_Rsprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Sdprimme)
#  define convTestFun_Sdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Rdprimme)
#  define convTestFun_Rdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Sqprimme)
#  define convTestFun_Sqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_Rqprimme)
#  define convTestFun_Rqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SXhprimme)
#  define convTestFun_SXhprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RXhprimme)
#  define convTestFun_RXhprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SXsprimme)
#  define convTestFun_SXsprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RXsprimme)
#  define convTestFun_RXsprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SXdprimme)
#  define convTestFun_SXdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RXdprimme)
#  define convTestFun_RXdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SXqprimme)
#  define convTestFun_SXqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RXqprimme)
#  define convTestFun_RXqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SHhprimme)
#  define convTestFun_SHhprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RHhprimme)
#  define convTestFun_RHhprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SHsprimme)
#  define convTestFun_SHsprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RHsprimme)
#  define convTestFun_RHsprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SHdprimme)
#  define convTestFun_SHdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RHdprimme)
#  define convTestFun_RHdprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_SHqprimme)
#  define convTestFun_SHqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(convTestFun_RHqprimme)
#  define convTestFun_RHqprimme CONCAT(convTestFun_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
int convTestFun_dprimme(dummy_type_dprimme eval, dummy_type_dprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Sprimme)
#  define monitorFun_Sprimme CONCAT(monitorFun_,WITH_KIND(SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Rprimme)
#  define monitorFun_Rprimme CONCAT(monitorFun_,WITH_KIND(REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SHprimme)
#  define monitorFun_SHprimme CONCAT(monitorFun_,WITH_KIND(HOST_SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RHprimme)
#  define monitorFun_RHprimme CONCAT(monitorFun_,WITH_KIND(HOST_REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SXprimme)
#  define monitorFun_SXprimme CONCAT(monitorFun_,WITH_KIND(XSCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RXprimme)
#  define monitorFun_RXprimme CONCAT(monitorFun_,WITH_KIND(XREAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Shprimme)
#  define monitorFun_Shprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Rhprimme)
#  define monitorFun_Rhprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Ssprimme)
#  define monitorFun_Ssprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Rsprimme)
#  define monitorFun_Rsprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Sdprimme)
#  define monitorFun_Sdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Rdprimme)
#  define monitorFun_Rdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Sqprimme)
#  define monitorFun_Sqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_Rqprimme)
#  define monitorFun_Rqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SXhprimme)
#  define monitorFun_SXhprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RXhprimme)
#  define monitorFun_RXhprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SXsprimme)
#  define monitorFun_SXsprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RXsprimme)
#  define monitorFun_RXsprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SXdprimme)
#  define monitorFun_SXdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RXdprimme)
#  define monitorFun_RXdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SXqprimme)
#  define monitorFun_SXqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RXqprimme)
#  define monitorFun_RXqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SHhprimme)
#  define monitorFun_SHhprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RHhprimme)
#  define monitorFun_RHhprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SHsprimme)
#  define monitorFun_SHsprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RHsprimme)
#  define monitorFun_RHsprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SHdprimme)
#  define monitorFun_SHdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RHdprimme)
#  define monitorFun_RHdprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_SHqprimme)
#  define monitorFun_SHqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(monitorFun_RHqprimme)
#  define monitorFun_RHqprimme CONCAT(monitorFun_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
int monitorFun_dprimme(dummy_type_dprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_dprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Sprimme)
#  define insertionSort_Sprimme CONCAT(insertionSort_,WITH_KIND(SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Rprimme)
#  define insertionSort_Rprimme CONCAT(insertionSort_,WITH_KIND(REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SHprimme)
#  define insertionSort_SHprimme CONCAT(insertionSort_,WITH_KIND(HOST_SCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RHprimme)
#  define insertionSort_RHprimme CONCAT(insertionSort_,WITH_KIND(HOST_REAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SXprimme)
#  define insertionSort_SXprimme CONCAT(insertionSort_,WITH_KIND(XSCALAR_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RXprimme)
#  define insertionSort_RXprimme CONCAT(insertionSort_,WITH_KIND(XREAL_SUF))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Shprimme)
#  define insertionSort_Shprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Rhprimme)
#  define insertionSort_Rhprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Ssprimme)
#  define insertionSort_Ssprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Rsprimme)
#  define insertionSort_Rsprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Sdprimme)
#  define insertionSort_Sdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Rdprimme)
#  define insertionSort_Rdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Sqprimme)
#  define insertionSort_Sqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_Rqprimme)
#  define insertionSort_Rqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SXhprimme)
#  define insertionSort_SXhprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RXhprimme)
#  define insertionSort_RXhprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,h),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SXsprimme)
#  define insertionSort_SXsprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RXsprimme)
#  define insertionSort_RXsprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SXdprimme)
#  define insertionSort_SXdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RXdprimme)
#  define insertionSort_RXdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SXqprimme)
#  define insertionSort_SXqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RXqprimme)
#  define insertionSort_RXqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SHhprimme)
#  define insertionSort_SHhprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RHhprimme)
#  define insertionSort_RHhprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SHsprimme)
#  define insertionSort_SHsprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RHsprimme)
#  define insertionSort_RHsprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,s),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SHdprimme)
#  define insertionSort_SHdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RHdprimme)
#  define insertionSort_RHdprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,d),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_SHqprimme)
#  define insertionSort_SHqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),KIND_C))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(insertionSort_RHqprimme)
#  define insertionSort_RHqprimme CONCAT(insertionSort_,CONCAT(CONCAT(CONCAT(,q),primme),KIND_C))
#endif
int insertionSort_dprimme(dummy_type_dprimme newVal, dummy_type_dprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_hprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_hprimme *Bx, PRIMME_INT ldBx, dummy_type_hprimme *Ax, PRIMME_INT ldAx, dummy_type_hprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_hprimme(dummy_type_hprimme *V, dummy_type_hprimme *W, dummy_type_hprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_sprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_hprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_hprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_hprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_hprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_hprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_hprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_hprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_hprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_sprimme *G, int nG, int ldG,
      dummy_type_sprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_hprimme(dummy_type_sprimme eval, dummy_type_hprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_hprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_hprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_kprimme_normal(PRIMME_INT m, int n, dummy_type_cprimme *eval,
      dummy_type_kprimme *Bx, PRIMME_INT ldBx, dummy_type_kprimme *Ax, PRIMME_INT ldAx, dummy_type_kprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_kprimme_normal(dummy_type_kprimme *V, dummy_type_kprimme *W, dummy_type_kprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_cprimme *hVals,
      dummy_type_kprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_kprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_kprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_kprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_kprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_kprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_kprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_kprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_kprimme_normal(dummy_type_cprimme eval, dummy_type_kprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_kprimme_normal(dummy_type_cprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_cprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_kprimme_normal(dummy_type_cprimme newVal, dummy_type_cprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_kprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_kprimme *Bx, PRIMME_INT ldBx, dummy_type_kprimme *Ax, PRIMME_INT ldAx, dummy_type_kprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_kprimme(dummy_type_kprimme *V, dummy_type_kprimme *W, dummy_type_kprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_kprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_kprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_kprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_kprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_kprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_kprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_kprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_kprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_kprimme(dummy_type_sprimme eval, dummy_type_kprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_kprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_kprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_sprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_sprimme *Bx, PRIMME_INT ldBx, dummy_type_sprimme *Ax, PRIMME_INT ldAx, dummy_type_sprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_sprimme(dummy_type_sprimme *V, dummy_type_sprimme *W, dummy_type_sprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_sprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_sprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_sprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_sprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_sprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_sprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_sprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_sprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_sprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_sprimme *G, int nG, int ldG,
      dummy_type_sprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_sprimme(dummy_type_sprimme eval, dummy_type_sprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_sprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_sprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_cprimme_normal(PRIMME_INT m, int n, dummy_type_cprimme *eval,
      dummy_type_cprimme *Bx, PRIMME_INT ldBx, dummy_type_cprimme *Ax, PRIMME_INT ldAx, dummy_type_cprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_cprimme_normal(dummy_type_cprimme *V, dummy_type_cprimme *W, dummy_type_cprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_cprimme *hVals,
      dummy_type_cprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_cprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_cprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_cprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_cprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_cprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_cprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_cprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_cprimme_normal(dummy_type_cprimme eval, dummy_type_cprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_cprimme_normal(dummy_type_cprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_cprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_cprimme_normal(dummy_type_cprimme newVal, dummy_type_cprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_cprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_cprimme *Bx, PRIMME_INT ldBx, dummy_type_cprimme *Ax, PRIMME_INT ldAx, dummy_type_cprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_cprimme(dummy_type_cprimme *V, dummy_type_cprimme *W, dummy_type_cprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_cprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_cprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_cprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_cprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_cprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_cprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_cprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_cprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_cprimme(dummy_type_sprimme eval, dummy_type_cprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_cprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_cprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_zprimme_normal(PRIMME_INT m, int n, dummy_type_zprimme *eval,
      dummy_type_zprimme *Bx, PRIMME_INT ldBx, dummy_type_zprimme *Ax, PRIMME_INT ldAx, dummy_type_zprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_zprimme_normal(dummy_type_zprimme *V, dummy_type_zprimme *W, dummy_type_zprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_zprimme *h, int nh, int ldh, dummy_type_zprimme *hVals,
      dummy_type_zprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_zprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_zprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_zprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_zprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_zprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_zprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_zprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_zprimme *G, int nG, int ldG,
      dummy_type_zprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_zprimme_normal(dummy_type_zprimme eval, dummy_type_zprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_zprimme_normal(dummy_type_zprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_zprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_zprimme_normal(dummy_type_zprimme newVal, dummy_type_zprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_zprimme(PRIMME_INT m, int n, dummy_type_dprimme *eval,
      dummy_type_zprimme *Bx, PRIMME_INT ldBx, dummy_type_zprimme *Ax, PRIMME_INT ldAx, dummy_type_zprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_zprimme(dummy_type_zprimme *V, dummy_type_zprimme *W, dummy_type_zprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_zprimme *h, int nh, int ldh, dummy_type_dprimme *hVals,
      dummy_type_zprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_zprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_zprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_zprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_zprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_zprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_zprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_zprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_zprimme *G, int nG, int ldG,
      dummy_type_zprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_zprimme(dummy_type_dprimme eval, dummy_type_zprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_zprimme(dummy_type_dprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_dprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_zprimme(dummy_type_dprimme newVal, dummy_type_dprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_hprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_magma_hprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_hprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_hprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_hprimme(dummy_type_magma_hprimme *V, dummy_type_magma_hprimme *W, dummy_type_magma_hprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_sprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_magma_hprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_hprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_hprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_hprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_hprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_hprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_hprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_hprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_sprimme *G, int nG, int ldG,
      dummy_type_sprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_hprimme(dummy_type_sprimme eval, dummy_type_magma_hprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_hprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_hprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_kprimme_normal(PRIMME_INT m, int n, dummy_type_cprimme *eval,
      dummy_type_magma_kprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_kprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_kprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_kprimme_normal(dummy_type_magma_kprimme *V, dummy_type_magma_kprimme *W, dummy_type_magma_kprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_cprimme *hVals,
      dummy_type_magma_kprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_kprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_kprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_kprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_kprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_kprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_kprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_kprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_kprimme_normal(dummy_type_cprimme eval, dummy_type_magma_kprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_kprimme_normal(dummy_type_cprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_cprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_kprimme_normal(dummy_type_cprimme newVal, dummy_type_cprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_kprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_magma_kprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_kprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_kprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_kprimme(dummy_type_magma_kprimme *V, dummy_type_magma_kprimme *W, dummy_type_magma_kprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_magma_kprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_kprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_kprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_kprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_kprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_kprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_kprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_kprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_kprimme(dummy_type_sprimme eval, dummy_type_magma_kprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_kprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_kprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_sprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_magma_sprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_sprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_sprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_sprimme(dummy_type_magma_sprimme *V, dummy_type_magma_sprimme *W, dummy_type_magma_sprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_sprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_magma_sprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_sprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_sprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_sprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_sprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_sprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_sprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_sprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_sprimme *G, int nG, int ldG,
      dummy_type_sprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_sprimme(dummy_type_sprimme eval, dummy_type_magma_sprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_sprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_sprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_cprimme_normal(PRIMME_INT m, int n, dummy_type_cprimme *eval,
      dummy_type_magma_cprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_cprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_cprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_cprimme_normal(dummy_type_magma_cprimme *V, dummy_type_magma_cprimme *W, dummy_type_magma_cprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_cprimme *hVals,
      dummy_type_magma_cprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_cprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_cprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_cprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_cprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_cprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_cprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_cprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_cprimme_normal(dummy_type_cprimme eval, dummy_type_magma_cprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_cprimme_normal(dummy_type_cprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_cprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_cprimme_normal(dummy_type_cprimme newVal, dummy_type_cprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_cprimme(PRIMME_INT m, int n, dummy_type_sprimme *eval,
      dummy_type_magma_cprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_cprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_cprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_cprimme(dummy_type_magma_cprimme *V, dummy_type_magma_cprimme *W, dummy_type_magma_cprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_cprimme *h, int nh, int ldh, dummy_type_sprimme *hVals,
      dummy_type_magma_cprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_cprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_cprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_cprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_cprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_sprimme *Rnorms,
      dummy_type_magma_cprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_cprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_cprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_sprimme *rnorms, int nrb, int nre,
      dummy_type_cprimme *G, int nG, int ldG,
      dummy_type_cprimme *H, int nH, int ldH,
      dummy_type_sprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_cprimme(dummy_type_sprimme eval, dummy_type_magma_cprimme *evec, int givenEvec, dummy_type_sprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_cprimme(dummy_type_sprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_sprimme *basisNorms, int numConverged,
      dummy_type_sprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_sprimme *lockedNorms,
      int inner_its, dummy_type_sprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_cprimme(dummy_type_sprimme newVal, dummy_type_sprimme *evals,
      dummy_type_sprimme newNorm, dummy_type_sprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_dprimme(PRIMME_INT m, int n, dummy_type_dprimme *eval,
      dummy_type_magma_dprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_dprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_dprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_dprimme(dummy_type_magma_dprimme *V, dummy_type_magma_dprimme *W, dummy_type_magma_dprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_dprimme *h, int nh, int ldh, dummy_type_dprimme *hVals,
      dummy_type_magma_dprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_dprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_dprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_dprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_dprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_magma_dprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_dprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_dprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_dprimme *G, int nG, int ldG,
      dummy_type_dprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_dprimme(dummy_type_dprimme eval, dummy_type_magma_dprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_dprimme(dummy_type_dprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_dprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_dprimme(dummy_type_dprimme newVal, dummy_type_dprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_zprimme_normal(PRIMME_INT m, int n, dummy_type_zprimme *eval,
      dummy_type_magma_zprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_zprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_zprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_zprimme_normal(dummy_type_magma_zprimme *V, dummy_type_magma_zprimme *W, dummy_type_magma_zprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_zprimme *h, int nh, int ldh, dummy_type_zprimme *hVals,
      dummy_type_magma_zprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_zprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_zprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_zprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_zprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_magma_zprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_zprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_zprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_zprimme *G, int nG, int ldG,
      dummy_type_zprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_zprimme_normal(dummy_type_zprimme eval, dummy_type_magma_zprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_zprimme_normal(dummy_type_zprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_zprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_zprimme_normal(dummy_type_zprimme newVal, dummy_type_zprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
int Num_compute_residuals_magma_zprimme(PRIMME_INT m, int n, dummy_type_dprimme *eval,
      dummy_type_magma_zprimme *Bx, PRIMME_INT ldBx, dummy_type_magma_zprimme *Ax, PRIMME_INT ldAx, dummy_type_magma_zprimme *r,
      PRIMME_INT ldr, primme_context ctx);
int Num_update_VWXR_magma_zprimme(dummy_type_magma_zprimme *V, dummy_type_magma_zprimme *W, dummy_type_magma_zprimme *BV, PRIMME_INT mV,
      int nV, PRIMME_INT ldV, dummy_type_zprimme *h, int nh, int ldh, dummy_type_dprimme *hVals,
      dummy_type_magma_zprimme *X0, int nX0b, int nX0e, PRIMME_INT ldX0,
      dummy_type_magma_zprimme *X1, int nX1b, int nX1e, PRIMME_INT ldX1,
      dummy_type_magma_zprimme *X2, int nX2b, int nX2e, PRIMME_INT ldX2,
      dummy_type_magma_zprimme *Wo, int nWob, int nWoe, PRIMME_INT ldWo,
      dummy_type_magma_zprimme *R, int nRb, int nRe, PRIMME_INT ldR, dummy_type_dprimme *Rnorms,
      dummy_type_magma_zprimme *BX0, int nBX0b, int nBX0e, PRIMME_INT ldBX0,
      dummy_type_magma_zprimme *BX1, int nBX1b, int nBX1e, PRIMME_INT ldBX1,
      dummy_type_magma_zprimme *BX2, int nBX2b, int nBX2e, PRIMME_INT ldBX2,
      dummy_type_dprimme *rnorms, int nrb, int nre,
      dummy_type_zprimme *G, int nG, int ldG,
      dummy_type_zprimme *H, int nH, int ldH,
      dummy_type_dprimme *xnorms, int nxb, int nxe,
      primme_context ctx);
int convTestFun_magma_zprimme(dummy_type_dprimme eval, dummy_type_magma_zprimme *evec, int givenEvec, dummy_type_dprimme rNorm,
      int *isconv, primme_context ctx);
int monitorFun_magma_zprimme(dummy_type_dprimme *basisEvals, int basisSize, int *basisFlags,
      int *iblock, int blockSize, dummy_type_dprimme *basisNorms, int numConverged,
      dummy_type_dprimme *lockedEvals, int numLocked, int *lockedFlags, dummy_type_dprimme *lockedNorms,
      int inner_its, dummy_type_dprimme LSRes, const char *msg, double time,
      primme_event event, double startTime, primme_context ctx);
int insertionSort_magma_zprimme(dummy_type_dprimme newVal, dummy_type_dprimme *evals,
      dummy_type_dprimme newNorm, dummy_type_dprimme *resNorms, int newFlag, int *flags, int *perm, int n,
      int initialShift, primme_params *primme);
#endif
