\page Installation Installation

In this page you can learn how to
\link ConfiguringPlumed configure\endlink,
\link CompilingPlumed compile\endlink,
and \link InstallingPlumed install\endlink
PLUMED.
For those of you who are impatient, the following might do the job:
\verbatim
> ./configure --prefix=/usr/local
> make -j 4
> make doc # this is optional and requires proper doxygen version installed
> make install
\endverbatim
Notice that `make install` is not strictly necessary  as plumed can be used from the compilation
directory. This is very useful so as to quickly test the implementation of new features.
However, we strongly recommend to perform a full install.

Once the above is completed the `plumed` executable should be in your execution path
and you will be able to use PLUMED to analyze
existing trajectories or play with the Lennard-Jones code that is included.
However, because PLUMED is mostly used to bias on the fly simulations
performed with serious molecular dynamics packages, 
you can find instructions about how to
\link Patching patch \endlink
your favorite MD code so that it can be combined with PLUMED below.
Again, if you are impatient, something like this will do the job:
\verbatim
> cd /md/root/dir
> plumed patch -p
\endverbatim
Then compile your MD code.
For some MD codes these instructions are insufficient.
It is thus recommended that you read the instructions
at the end of this page.
Notice that MD codes could in principle be "PLUMED ready"
in their official distribution. If your favorite MD code is available "PLUMED ready" 
you will have to compile PLUMED first, then (optionally) install it, then check the MD codes' manual to
discover how to link it.

\section SupportedCompilers Supported compilers

As of PLUMED 2.4, we require a compiler that supports C++11. The following compilers
(or later versions) should be sufficient:

- gcc 4.8.1
- clang 3.3
- intel 15

Notice that the `./configure` script verifies that your compiler supports C++11.
Some compilers do not declare full support, but implement anyway a number of C++11 features
sufficient to compile PLUMED (this is the case for instance of intel 15 compiler).
In case you see a warning about C++11 support during `./configure`
please make sure that PLUMED compiles correctly and, if possible, execute the regtests
(using `make regtest`). Notice that we regularily test a number of compilers on travis-ci,
and at least those compilers are guaranteed to be able to compile PLUMED correctly.

\section ConfiguringPlumed Configuring PLUMED

The `./configure` command 
just generates a Makefile.conf file and a sourceme.sh file.
In PLUMED 2.0 these files were pre-prepared and stored in the 
directory configurations/. The new ones generated by ./configure
are similar to the old ones but are not completely compatible.
In particular, some of the -D options have been changed in version 2.2,
and several new variables so as  to specify the installation directories have been added. For this reason,
you now should run `./configure` again.
Anyway, it should be easy to enforce a similar setup with autoconf by passing
the proper arguments on the command line.
If you have problems on your architecture, please
report them to the mailing list.

Useful command line options for ./configure can be found by typing
\verbatim
> ./configure --help
\endverbatim
PLUMED is made up of modules. Some of them are on by default, some others aren't.
Since version 2.3, the activation of modules should be made during configuration using the `--enable-modules`
option (see \ref mymodules).

Notice that some functionalities of PLUMED depend on external
libraries which are looked for by configure. You can typically
avoid looking for a library using the "disable" syntax, e.g.
\verbatim
> ./configure --disable-mpi --disable-matheval
\endverbatim

Notice that when mpi search is enabled (by default) compilers
such as "mpic++" and "mpicxx" are searched for first. On the other hand,
if mpi search is disabled ("./configure --disable-mpi") non-mpi
compilers are searched for. Notice that only a few of the
possible compiler name are searched. Thus, compilers such as
"g++-mp-4.8" should be explicitly requested with the CXX option.

You can better control which compiler is used by setting the
variables CXX and CC. E.g., to use Intel compilers use the following command:
\verbatim
> ./configure CXX=icpc CC=icc
\endverbatim
Notice that we are using icpc in this example, which is not an mpi compiler as a 
result mpi will not be enabled. Also consider that this is different with respect
to what some other configure script does in that variables such as MPICXX are
completely ignored here. In case you work on a machine where CXX is
set to a serial compiler and MPICXX to a MPI compiler, to
compile with MPI you should use
\verbatim
> ./configure CXX="$MPICXX"
\endverbatim

\warning
This procedure could be somehow confusing since many other programs behave in a different way.
The flag `--enable-mpi` is perfectly valid but is not needed here.
Autoconf will check if a code containing MPI calls can be compiled,
and if so it will enable it. `--disable-mpi` could be used if you are
using a compiler that supports MPI but you don't want PLUMED to  be compiled
with MPI support. Thus the correct way to enable MPI is to pass
to ./configure  the name of a C++ compiler that implements MPI using the CXX option.
In this way, MPI library is treated similarly to all the other libraries
that PLUMED tries to link by default.

To tune the compilation options you can use the CXXFLAGS variable:
\verbatim
> ./configure CXXFLAGS=-O3
\endverbatim

If you are implementing new functionality and want to build with debug flags 
in place so as to do some checking you can use
\verbatim
> ./configure --enable-debug
\endverbatim
This will perform some extra check during execution (possibly slowing down PLUMED)
and write full symbol tables in the executable (making the final executable  much larger).

The main goal of the automatic configure is to find the libraries.
When they are stored in unconventional places it is thus sensible to tell autoconf where 
to look! To do this there are some environment variable that can be used to instruct the linker
which directories it should search for libraries inside. These variables are compiler dependent,
but could have been set by the system administrator so that libraries are found
without any extra flag. Our suggested procedure is to 
first try to configure without any additional flags and to then check the log so as to see whether
or not the libraries were properly detected.

If a library is not found during configuration, you can try to use options to modify the
search path.
For example if your matheval libraries is in /opt/local (this is where MacPorts put it)
and configure is not able to find it you can try
\verbatim
> ./configure LDFLAGS=-L/opt/local/lib CPPFLAGS=-I/opt/local/include
\endverbatim
Notice that PLUMED will first try to link a routine from say matheval
without any additional flag, and then in case of failure will retry adding
"-lmatheval" to the LIBS options.
If also this does not work, the matheval library will be
disabled and some features will not be available.
This procedure allows you to use libraries
with custom names. So, if
your matheval library is called /opt/local/lib/libmymatheval.so you can 
link it with
\verbatim
> ./configure LDFLAGS=-L/opt/local/lib CPPFLAGS=-I/opt/local/include LIBS=-lmymatheval
\endverbatim
In this example, the linker will directly try to link `/opt/local/lib/libmymatheval.so`.
This rule is true for all the libraries, so that you will always be able to link
a specific version of a library by specifying it using the LIBS variable.

Since version 2.3.2, the search for the library functions passing to the linker a flag with the standard library name (in the matheval example,
it would be `-lmatheval`) can be skipped by using the option `--disable-libsearch`.
Notice that in this manner only libraries that are explicitly passed using the `LIBS` option will be linked. For instance
\verbatim
> ./configure --disable-libsearch LIBS=-lmatheval
\endverbatim
will make sure that only matheval is linked and, for instance, blas and lapack libraries are not.
This might be useful when installing PLUMED within package managers such as MacPorts to
make sure that only desired libraries are linked and thus to avoid to introduce spurious
dependencies. The only exception to this rule is `-ldl`, which is anyway a system library on Linux.

\warning On OSX it is common practice to hardcode the full path
to libraries in the libraries themselves. This means that, after having linked
a shared library, that specific shared library will be searched in the same
place (we do the same for the `libplumed.dylib` library, which has an install name hardcoded).
On the other hand, on Linux it is common pratice not to hardcode the full path.
This means that if you use the `LDFLAGS` option to specify the path
to the libraries you want to link to PLUMED (e.g. `./configure LDFLAGS="-L/path"`)
these libraries might not be found later.
The visible symptom is that `src/lib/plumed-shared` will not be linked correctly.
Although the file 'src/lib/plumed-shared' is not necessary, being
able to produce it means that it will be possible to link PLUMED dynamically
with MD codes later.
The easiest solution is to hardcode the library search path in this way:
\verbatim
> ./configure LDFLAGS="-L/path -Wl,-rpath,/path"
\endverbatim
Notice that as of PLUMED v2.4 it is possible to use the configure option `--enable-rpath`
to automatically hardcode the path defined in `LIBRARY_PATH`:
\verbatim
> ./configure LIBRARY_PATH=/path --enable-rpath
\endverbatim
In this way, the search path used at link time (`LIBRARY_PATH`) and the one saved in the `libplumed.so`
library will be consistent by construction.
In a typical environment configured using module framework (http://modules.sourceforge.net),
`LIBRARY_PATH` will be a variable containing the path to all the modules loaded at compilation
time.

PLUMED needs blas and lapack. These are treated slighty different from
other libraries. The search is done in the usual way (i.e., first
look for them without any link flag, then add "-lblas" and "-llapack", respectively).
As such  if you want to use a specific version of blas or lapack
you can make them available to configure by using
\verbatim
> ./configure LDFLAGS=-L/path/to/blas/lib LIBS=-lnameoflib
\endverbatim
If the functions of these libraries are not found, the compiler
looks for a version with a final underscore added.
Finally, since blas and lapack are compulsory in PLUMED,
you can use a internal version of these libraries that comes as part of PLUMED.
If all else fails the internal version of BLAS and LAPACK are the ones that will be
used by PLUMED.
If you wish to disable any search for external libraries
(e.g. because the system libraries have problems) this can be done with
\verbatim
> ./configure --disable-external-blas
\endverbatim
Notice that you can also disable external lapack only, that is use internal lapack with external blas
using
\verbatim
> ./configure --disable-external-lapack
\endverbatim
Since typically it is the blas library that can be heavily optimized, this configuration
should not provide significant slowing down and could be used on systems where
native lapack libraries have problems.


As a final resort, you can also edit the resulting Makefile.conf file.
Notable variables in this file include:
- DYNAMIC_LIB : these are the libraries needed to compile the PLUMED
library (e.g. -L/path/to/matheval -lmatheval etc). Notice that for the
PLUMED shared library to be compiled properly these should be dynamic
libraries. Also notice that PLUMED preferentially requires BLAS and LAPACK library;
see \ref BlasAndLapack for further info. Notice that the variables 
that you supply with `configure LIBS=something` will end up in this
variable. This is a bit misleading but is required to keep the configuration
files compatible with PLUMED 2.0.
- LIBS : these are the libraries needed when patching an MD code; typically only "-ldl" (needed to have functions for dynamic loading).
- CPPFLAGS : add here definition needed to enable specific optional functions;
e.g. use -D__PLUMED_HAS_MATHEVAL to enable the matheval library
- SOEXT : this gives the extension for shared libraries in your system, typically
"so" on unix, "dylib" on mac; If your system does not support dynamic libraries or, for some other reason, you would like only static executables you can
just set this variable to a blank ("SOEXT=").

\subsection BlasAndLapack BLAS and LAPACK

We tried to keep PLUMED as independent as possible from external libraries and as such those features
that require external libraries (e.g. Matheval) are optional. However, to have a properly working version
of plumed PLUMED you need BLAS and LAPACK libraries.  We would strongly recommend you download these libraries and 
install them separately so as to have the most efficient possible implementations of the functions contained within 
them.  However, if you cannot install blas and lapack, you can use the internal ones.
Since version 2.1, PLUMED uses a configure script to detect libraries. In case system LAPACK or BLAS
are not found on your system, PLUMED will use the internal replacement.

We have had a number of emails (and have struggled ourselves) with ensuring that PLUMED 
can link BLAS and LAPACK.  The following describes some of the pitfalls that you can fall
into and a set of sensible steps by which you can check whether or not you have set up the configuration
correctly.

Notice first of all that the DYNAMIC_LIB variable in the Makefile.conf
should contain the flag necessary to load the BLAS and LAPACK libraries.  Typically this will be
-llapack -lblas, in some case followed by -lgfortran.  Full path specification with -L may be necessary 
and on some machines the blas and lapack libraries may not be called -llapack and -lblas.
Everything will depend on your system configuration.

Some simple to fix further problems include:
- If the linker complains and suggests recompiling lapack with -fPIC, it means that you have static lapack libraries. Either install dynamic lapack libraries
or switch to static compilation of PLUMED by unsetting the SOEXT variable
in the configuration file.
- If the linker complains about other missing functions (typically starting with
  "for_" prefix) then you should also link some Fortran libraries. PLUMED
  is written in C++ and often C++ linkers do not include Fortran libraries by default.
  These libraries are required for lapack and blas to work. Please check the documentation of your compiler.
- If the linker complains that dsyevr_ cannot be found, try adding
  -DF77_NO_UNDERSCORE to CPPFLAGS
  Notice that "./configure" should automatically try this solution.

\subsection installation-vmdplugins VMD trajectory plugins

If you configure PLUMED with VMD's plugins you will be able to read
many more trajectory formats. To this aim,
you need to download the SOURCE of VMD, which contains
a plugins directory. Adapt build.sh and compile it. At
the end, you should get the molfile plugins compiled as a static
library `libmolfile_plugin.a`. Locate said file and `libmolfile_plugin.h`,
they should be in a directory called `/pathtovmdplugins/ARCH/molfile`
(e.g. `/pathtovmdplugins/MACOSXX86_64/molfile`). Also locate file `molfile_plugin.h`,
which should be in `/pathtovmdplugins/include`.
Then customize the configure command with something along the lines of:

\verbatim
./configure LDFLAGS="-L/pathtovmdplugins/ARCH/molfile" CPPFLAGS="-I/pathtovmdplugins/include -I/pathtovmdplugins/ARCH/molfile"
\endverbatim

Notice that it might be necessary to add to `LDFLAGS` the path to your TCL interpreter, e.g.

\verbatim
./configure LDFLAGS="-ltcl8.5 -L/mypathtotcl -L/pathtovmdplugins/ARCH/molfile" \
            CPPFLAGS="-I/pathtovmdplugins/include -I/pathtovmdplugins/ARCH/molfile"
\endverbatim

Then, rebuild plumed.

\section CompilingPlumed Compiling PLUMED

Once configured, PLUMED can be compiled using the following command:
\verbatim
> make -j 4
\endverbatim
This will compile the entire code and produce a number of files
in the 'src/lib' directory, including the executable 
'src/lib/plumed'. When shared libraries are enabled,
a shared libraries called 'src/lib/libKernel.so' should also be present.
Notice that the extension could be '.dylib' on a Mac.

In case you want to run PLUMED *without installing it* (i.e. from the compilation
directory), you can use the file 'sourceme.sh' that has been created by
the configure script in the main PLUMED directory.
This file can be "sourced" (presently only working for bash shell)
if you want to use PLUMED *before installing it* (i.e. from the compilation
directory). It is a good idea to source it now, so that you can play with the just compiled
PLUMED:
\verbatim
> source sourceme.sh
\endverbatim

Now
a "plumed" executable should be in your path. Try to type
\verbatim
> plumed -h
\endverbatim

\warning If you are cross compiling, the plumed executable
will not work. As a consequence, you won't be able to run regtests
or compile the manual. This is not a problem.

You can also check if PLUMED is correctly compiled by performing our regression tests.
Be warned that some of them fail because of the different numerical accuracy on different machines.
As of version 2.4, in order to test the `plumed` executable that you just compiled
(prior to installing it) you can use the following command
\verbatim
> make check
\endverbatim
On the other hand, in order to test the `plumed` executable that you just installed (see \ref InstallingPlumed)
you should type
\verbatim
> make installcheck
\endverbatim
In addition, similarly to previous versions of PLUMED, you can test the `plumed` executable
that is in your current path with
\verbatim
> cd regtest
> make
\endverbatim 
You can check the exact version they will use by using the command
\verbatim
> which plumed
\endverbatim
Thus, you can easily run the test suite using a different version of PLUMED
(maybe an earlier version that you already installed), just making sure that it can be 
found in the path. Clearly, if you test a given
version of PLUMED with a test suite from a different version you can expect two
possible kinds of innocuous errors:
- If `plumed` executable is older than the test suite, the tests might fail since they rely on
  some feature introduced in PLUMED in a newer version.
- If `plumed` executable is newer than the test suite, the tests might fail since some
  non-backward compatible change was made in PLUMED. We try to keep the number
  of non-backward compatible changes small, but as you can see in the \ref Changelog there
  are typically a few of them at every new major release.

\attention
Even though we regularly perform tests on [Travis-CI](http://travis-ci.org/plumed/plumed2),
it is possible that aggressive optimizations or even architecture dependent features
trigger bugs that did not show up on travis. So please always perform regtests when you install
PLUMED.

Notice that the compiled executable, which now sits in 'src/lib/plumed', relies
on other resource files present in the compilation directory.
This directory should thus stay in the correct place. One should thus not
rename or delete it. In fact the path to the PLUMED root directory is 
hardcoded in the plumed executable as can be verified using 
\verbatim
> plumed info --root
\endverbatim
In case you try to use the plumed executable without the compilation
directory in place (e.g. you move away the src/lib/plumed static executable
and delete or rename the compilation directory) PLUMED will 
not work correctly and will give you an
error message
\verbatim
> plumed help
ERROR: I cannot find /xxx/yyy/patches directory
\endverbatim
You can force plumed to run anyway by using the option --standalone-executable:
\verbatim
> plumed --standalone-executable help
\endverbatim
Many features will not be available if you run in this way. However, 
this is currently the only way to use the PLUMED static executable on Windows.

\section InstallingPlumed Installing PLUMED

It is strongly suggested to
install PLUMED in a predefined location.
This is done using
\verbatim
> make install
\endverbatim
This will allow you to remove the original compilation directory,
or to recompile a different PLUMED version in the same place.

To install PLUMED one should first decide the location.
The standard way to do it is during the configure step:
\verbatim
> ./configure --prefix=$HOME/opt
> make
> make install
\endverbatim
However, you can also change it after compilation setting
the variable `prefix`.
\verbatim
> ./configure
> make
> make install prefix=$HOME/opt
\endverbatim
If you didn't specify the `--prefix` option during configure, and you did not set the `prefix`
variable when installing, PLUMED will be installed in /usr/local.
The install command should be executed with root permissions (e.g. "sudo make install")
if you want to install PLUMED on a system directory.

Notice that upon installation PLUMED might need to relink a library.
This was always true until version 2.1, but in version 2.2 libraries should
only be relinked if one changes the install prefix during when typing `make install`.
If root user does not have access to compilers, "sudo -E make install" might solve
the issue.

Upon install, executables are copied to $prefix/bin, libraries to $prefix/lib,
include files to $prefix/include, and
documentation to $prefix/shared/doc/plumed. Additionally, a directory
$prefix/lib/plumed is created containing several other files, including
patch files, object files (for static patches), etc.
Notice also that these path can be further customized using standard autoconf
directories (e.g. `./configure --bindir=/usr/bin64`).

One should then set the environment properly. We suggest to do it using
the module framework (http://modules.sourceforge.net). An ad hoc generated
module file for PLUMED can be found in $prefix/lib/plumed/src/lib/modulefile
Just edit it as you wish and put it in your modulefile directory.
This will also allow you to install multiple PLUMED versions on your machine and to
switch amongst them. If you do not want to use modules, you can 
still have a look at the modulefile we did so as to know which
environment variables should be set for PLUMED to work correctly.

If the environment is properly configured one should be able to do
the following things:
- use the "plumed" executable from the command line. This is also possible before installing.
- link against the PLUMED library using the "-lplumed" flag for the linker. This allows
  one to use PLUMED library in general purpose programs
- use the PLUMED internal functionalities (C++ classes) including
  header files such as "#include <plumed/tools/Vector.h>". This is useful as it may be expedient to
  exploit the PLUMED library in general purpose programs

As a final note, if you want to install several PLUMED versions without using modules then you
should provide a different suffix and/or prefix at configure time:
\verbatim
> ./configure prefix=$HOME/opt --program-suffix=_2.2 --program-prefix=mpi-
> make install
\endverbatim
This will install a plumed executable named "mpi-plumed_2.2". All the other files will be renamed similarly,
e.g. the PLUMED library will be loaded with "-lmpi-plumed_2.2" and the PLUMED header files
will be included with "#include <mpi-plumed_2.2/tools/Vector.h>".
Notice that you can also use arbitrary scripts to edit the name of the executable
with the option --program-transform-name=PROGRAM
(see <a href="http://www.gnu.org/software/autoconf/manual/autoconf-2.69/html_node/Transformation-Examples.html#Transformation-Examples"> autoconf documentation </a> for more info).
These options are useful if you
do not want to set up modules, but we believe that using modules as described above is more flexible.

\section Patching Patching your MD code

A growing number of MD codes can use PLUMED without any modification.
If you are using one of these codes, refer to its manual to know how to activate PLUMED.
In case your MD code is not supporting PLUMED already, you should modify it.
We provide scripts to adjust some of the most popular MD codes
so as to provide PLUMED support.
At the present times we support patching the following list of codes:

@CODESL@

In the section \subpage CodeSpecificNotes you can find information specific for each MD code.

To patch your MD code, you should have already installed PLUMED properly.
This is necessary as you need to have the command "plumed" in your execution
path.  As described above this executible will be in your paths if plumed was 
installed or if you have run sourceme.sh

Once you have a compiled and working version of plumed, follow these steps to add it to
an MD code
- Configure and compile your MD enginge (look for the instructions in its documentation).
- Test if the MD code is working properly.
- Go to the root directory for the source code of the MD engine.
- Patch with PLUMED using:
\verbatim
> plumed patch -p
\endverbatim
The script will interactively ask which MD engine you are patching.
- Once you have patched recompile the MD code (if dependencies are set up properly in the MD engine,
  only modified files will be recompiled)

There are different options available when patching. You can check all of them using 
\verbatim
> plumed patch --help
\endverbatim
Particularly interesting options include:
- --static just link PLUMED as a collection of object files. This is only suggested if for external reasons you
  absolutely need a static executable. Notice that with this setting it is often more complicated to configure
  properly the MD code, since all the libraries that PLUMED depends on should be properly specified. The `./configure` script
  does its best in this sense, but sometime it cannot solve the problem. Additionally, this patching mode has been reported
  not to work properly on OSX.
- --shared (default) allows you to link PLUMED as a shared library. As a result when PLUMED is updated, there will be no need to recompile the MD code.
  This is way better than --static since the libraries that PLUMED depends on should be automatically linked.
  Notice that if you later remove the directory where PLUMED is installed also the MD code will not run anymore.
- --runtime allows you to choose the location of the PLUMED library at runtime by setting the variable PLUMED_KERNEL.
  This is probably the most flexible option, and we encourage system administrators to use this option when installing
  PLUMED on shared facilities. Indeed, using this setting it will be possible to update separately the PLUMED library
  and the MD code, leaving to the user the possibility to combine different versions at will. 
  We also recommend to use the provided modulefile (see above) to properly set the runtime environment.

Notice that it is not currently possible to link PLUMED as a static library (something like 'libplumed.a').
The reason for this is that PLUMED heavily relies on C++ static constructors that do not behave well in static libraries.
For this reason, to produce a static executable with an MD code + PLUMED we link PLUMED as a collection of object files.

If your MD code is not supported, you may want to implement an interface for
it. Refer to the <a href="../../developer-doc/html/index.html"> developer
manual </a>.

\section CrossCompiling Cross compiling

If you are compiling an executable from a different machine, then
`plumed` executable will not be available in the compilation environment.
This means that you won't be able to perform regtests on the machine
nor to compile the manual.
You can try to run the regtests on the computing nodes, but this might require some tweak
since often machines where people do cross compiling have architectures with limited capabilities
on the compute nodes. Also notice that many of the `plumed` options (e.g. patch) are implemented
as shell scripts launched from within the `plumed` executable. If the compute nodes have some limitation
(e.g. they do not allow to fork new processes) these options will not work. Anyway, the PLUMED library
in combination with an MD software should work if both PLUMED and the MD software have been properly compiled.

Also notice that it will not be possible
to use the command `plumed patch` on the machine where you are compiling.
You should thus use `plumed-patch` instead of `plumed patch` (notice that it should be written as a single word).

Try e.g.:
\verbatim
> plumed-patch --help
\endverbatim
This script provides a "shell only" implementation of `plumed patch` that will skip the launch of the `plumed` executable.

Notice that other command line tools will be available in the directory `prefix/lib/progname/`. If configuring with
default values this would be `/usr/local/lib/plumed/plumed-*`. These files are not included in the execution path (prefix/bin)
to avoid clashes, but can be executed also when plumed is cross compiled and the main plumed executable cannot be
launched.

\section Installation-macports Installing PLUMED with MacPorts

If you are using a Mac, notice that you can take advantage of a MacPorts package.
Installing a working plumed should be as easy as:
- Install [MacPorts](https://www.macports.org/)
- Type `sudo port install plumed`

Notice that plumed comes with many variants that can be inspected with the command

    > sudo port info plumed

Plumed uses variants to support different compilers.
For instance, you can install plumed with mpich using

    > sudo port install plumed +mpich

Using more recent clang instead of native compilers is recommended so as to
take advantage of openMP

    > sudo port install plumed +mpich +clang50

Notice that support for c++11 with gcc compilers is someway problematic within MacPorts
due to impossibility to use the system c++ library. For this reason, only clang compilers are supported
(see also [this discussion](https://github.com/macports/macports-ports/pull/1252)).

Variants can be also used to compile with debug flags (`+debug`), to pick a linear algebra library
(e.g. `+openblas`) and to enable all optional modules (`+allmodules`).
Notice that the default variant installed with `sudo port install plumed` is shipped as a precompiled
binary, which is significantly faster to install.

In addition, we provide a developer version (typically: a later version not yet considered as stable)
under the subport `plumed-devel` that can be installed with

    > sudo port install plumed-devel

`plumed-devel` also supports the same variants as `plumed` in order to customize the compilation.
`plumed-devel` and `plumed` cannot be installed at the same time.

It is also possible to install a plumed-patched version of gromacs.
For instance, you can use the following command to install
gromacs patched with plumed with clang-5.0 compiler and mpich:

    > sudo port install plumed +mpich +clang50
    > sudo port install gromacs-plumed +mpich +clang50

In case you want to combine gromacs with the unstable version of plumed, use this instead:

    > sudo port install plumed-devel +mpich +clang50
    > sudo port install gromacs-plumed +mpich +clang50

Notice that gromacs should be compiled using the same compiler
variant as plumed (in this example `+mpich +clang50`). In case this is not
true, compilation will fail.

Also notice that gromacs is patched with plumed in runtime mode
but that the path of libplumedKernel.dylib in the MacPorts tree
is hardcoded. As a consequence:

- If gromacs is run with `PLUMED_KERNEL` environment variable unset (or set to empty),
  then the MacPorts plumed is used.

- If gromacs is run with `PLUMED_KERNEL` environment variable pointing to another instance
  of the plumed library, the other instance is used.

This is especially useful if you are developing PLUMED since you will be able to install
gromacs once for all and combine it with your working version of PLUMED.

\section installingonacluster Installing PLUMED on a cluster

If you are installing PLUMED on a cluster and you want several users to take advantage of it
consider the following suggestions.

First of all, we highly recommend using the module file that PLUMED provides to set up the environment.
Just edit it as necessary to make it suitable for your environment.

Notice that PLUMED can take advantage of many additionaly features if specific libraries are available upon
compiling it. Install libmatheval first and check if PLUMED `./configure` is detecting it. Libmatheval is a must have with PLUMED.
If someone uses gromacs, install libxdrfile first and check if PLUMED `./configure` is detecting it.
PLUMED will be able to write trr/xtc file, simplifying analysis.

Try to patch all MD codes with the `--runtime` option. This will allow independent update of PLUMED and MD codes.
  Users will be able to combine any of the installed gromacs/amber/etc versions with any of the installed PLUMED versions.
Notice that it is sometime claimed that statically linked codes are faster. In our experience, this is not true.
In case you absolutely need a static executable, be ready to face non trivial linking issues. PLUMED is written in C++,
thus required the appropriate C++ library to be linked, and might require additional libraries (e.g. libmatheval).

Sometime we make small fixes on the patches. For this reason, keep track of which version of PLUMED you used
to patch each of the MD code. Perhaps you can call the MD code modules with names such as `gromacs/4.6.7p1`,
`gromacs/4.6.7p2` and write somewhere in the module file which version of PLUMED you used. Alternatively, call them
something like `gromacs/4.6.7p2.2.0`. In this way, when we report a bug on the mailing list, users will know if the version
they are using is affected by it.

Usually it is not necessary to install both a MPI and a non-MPI PLUMED version. PLUMED library only calls MPI functions
when the MD code is compiled with MPI. PLUMED executable calls MPI functions only when it is invoked without `--no-mpi`.
In many machines it is thus sufficient to run the plumed executable on the login node as
\verbatim
> plumed --no-mpi
\endverbatim
even though PLUMED was compiled with MPI and the login node does not support MPI.
The only case where you might need two different PLUMED installation for compute
and login node is when you are cross compiling.

PLUMED needs to be well optimized to run efficiently.
If you need a single PLUMED binary to run efficiency on machines with different levels of hardware (e.g.: some
of your workstations support AVX and some do not), with intel compiler you can use something like
\verbatim
./configure CXX=mpicxx CXXFLAGS="-O3 -axSSE2,AVX"
\endverbatim
It will take more time to compile but it will allow you to use a single module. Otherwise, you should install two
PLUMED version with different optimization levels.

Using modules, it is not necessary to make the PLUMED module explicitly dependent on the used library. Imagine a
scenario where you first installed a module `libmatheval`, then load it while you compile PLUMED. If you
provide the following option to configure `--enable-rpath`, the PLUMED executable and
library will remember where libmatheval is, without the need to load libmatheval module at runtime.
Notice that this trick often does not work for fundamental libraries such as C++ and MPI library. As a consequence,
usually the PLUMED module should load the compiler and MPI modules.

\attention
In case you found out how to compile PLUMED on some fancy architecture please share your tricks! You can
either post it in your blog, send it to the mailing list, or ask as to update this paragraph in the manual, we will
be happy to do so.

\section installinghints Other hints

We here collect a list of suggestions that might be useful on particular
machines.

- On Blue Gene Q (likely on AIX) the prelinking made with `ld -r` is not
  working properly. There is no easy way to detect this at configure time.
  If during `make` you receive an error in the form
\verbatim
ld: TOC section size exceeds 64k
\endverbatim
  please configure plumed again with the following flag
\verbatim
./configure --disable-ld-r
\endverbatim

\page CodeSpecificNotes Code specific notes

Here you can find instructions that are specific for patching each of the supported MD codes.
Notice that MD codes with native PLUMED support are not listed here.

@CODES@

