/* Return the name-within-directory of a file name.
   Copyright (C) 1996,97,98,2002 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/*
 * $Id: basename.c,v 1.1 2005-02-08 15:37:21 gerkey Exp $
 *
 * taken from glibc, modified slightly for standalone compilation, and used as
 * a fallback implementation when basename() is not available. - BPG
 */

#include <string.h>

#ifndef _LIBC
/* We cannot generally use the name `basename' since XPG defines an unusable
   variant of the function but we cannot use it.  */
# define basename gnu_basename
#endif

const char * basename( const char *filename )
{
  char *p = strrchr (filename, '/');
  return p ? p + 1 : (char *) filename;
}

#ifdef _LIBC
libc_hidden_def (basename)
#endif
