// a glimpse into rendering markup with XmlRenderer
import "pkl:xml"

function h1() = xml.Element("h1")
function ul() = xml.Element("ul")
function li() = xml.Element("li")
function strong() = (xml.Element("strong")) { isBlockFormat = false }
function comment(text: String) = xml.Comment(text)

hobbies {
  "swimming"
  "surfing"
  "fire making"
}

html {
  body {
    comment("this is a comment")
    (h1()) {
      "My " hobbies.toList().length " " (strong()) { "favorite" } " hobbies:"
    }
    (ul()) {
      for (hobby in hobbies) {
        (li()) { hobby }
      }
    }
  }
}

output {
  value = html
  renderer = new xml.Renderer {
    rootElementName = "html"
  }
}
