/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 42 "parser.php5.lemon"

#include "parser.php5.inc.h"

#line 12 "parser.php5.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    phvolt_TOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is phvolt_TOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    phvolt_ARG_SDECL     A static variable declaration for the %extra_argument
**    phvolt_ARG_PDECL     A parameter declaration for the %extra_argument
**    phvolt_ARG_STORE     Code to store %extra_argument into yypParser
**    phvolt_ARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 125
#define YYACTIONTYPE unsigned short int
#define phvolt_TOKENTYPE phvolt_parser_token*
typedef union {
  phvolt_TOKENTYPE yy0;
  zval* yy40;
  int yy249;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define phvolt_ARG_SDECL phvolt_parser_status *status;
#define phvolt_ARG_PDECL ,phvolt_parser_status *status
#define phvolt_ARG_FETCH phvolt_parser_status *status = yypParser->status
#define phvolt_ARG_STORE yypParser->status = status
#define YYNSTATE 348
#define YYNRULE 152
#define YYERRORSYMBOL 85
#define YYERRSYMDT yy249
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */    83,   93,  109,   61,   53,   55,   67,   63,   65,   73,
 /*    10 */    75,   77,   79,   69,   71,   49,   47,   51,   44,   41,
 /*    20 */    57,   90,   59,   85,   88,   89,   97,   81,   86,  231,
 /*    30 */    85,   88,   89,   97,   81,  286,   44,   41,   57,   90,
 /*    40 */    59,   85,   88,   89,   97,   81,  108,  285,  180,  201,
 /*    50 */   184,   83,   93,  182,   61,   53,   55,   67,   63,   65,
 /*    60 */    73,   75,   77,   79,   69,   71,   49,   47,   51,   44,
 /*    70 */    41,   57,   90,   59,   85,   88,   89,   97,   81,  223,
 /*    80 */   251,   83,   93,  181,   61,   53,   55,   67,   63,   65,
 /*    90 */    73,   75,   77,   79,   69,   71,   49,   47,   51,   44,
 /*   100 */    41,   57,   90,   59,   85,   88,   89,   97,   81,  314,
 /*   110 */   174,  321,  172,   37,   83,   93,  252,   61,   53,   55,
 /*   120 */    67,   63,   65,   73,   75,   77,   79,   69,   71,   49,
 /*   130 */    47,   51,   44,   41,   57,   90,   59,   85,   88,   89,
 /*   140 */    97,   81,  330,  325,   83,   93,  228,   61,   53,   55,
 /*   150 */    67,   63,   65,   73,   75,   77,   79,   69,   71,   49,
 /*   160 */    47,   51,   44,   41,   57,   90,   59,   85,   88,   89,
 /*   170 */    97,   81,  279,  260,   83,   93,   95,   61,   53,   55,
 /*   180 */    67,   63,   65,   73,   75,   77,   79,   69,   71,   49,
 /*   190 */    47,   51,   44,   41,   57,   90,   59,   85,   88,   89,
 /*   200 */    97,   81,   83,   93,  302,   61,   53,   55,   67,   63,
 /*   210 */    65,   73,   75,   77,   79,   69,   71,   49,   47,   51,
 /*   220 */    44,   41,   57,   90,   59,   85,   88,   89,   97,   81,
 /*   230 */    49,   47,   51,   44,   41,   57,   90,   59,   85,   88,
 /*   240 */    89,   97,   81,  304,  295,  313,  199,  103,  109,  346,
 /*   250 */   296,   83,   93,  205,   61,   53,   55,   67,   63,   65,
 /*   260 */    73,   75,   77,   79,   69,   71,   49,   47,   51,   44,
 /*   270 */    41,   57,   90,   59,   85,   88,   89,   97,   81,  129,
 /*   280 */   316,   83,   93,  145,   61,   53,   55,   67,   63,   65,
 /*   290 */    73,   75,   77,   79,   69,   71,   49,   47,   51,   44,
 /*   300 */    41,   57,   90,   59,   85,   88,   89,   97,   81,   90,
 /*   310 */    59,   85,   88,   89,   97,   81,  307,  308,  309,  310,
 /*   320 */   311,  312,  183,  184,   92,  215,  262,  273,   83,   93,
 /*   330 */   113,   61,   53,   55,   67,   63,   65,   73,   75,   77,
 /*   340 */    79,   69,   71,   49,   47,   51,   44,   41,   57,   90,
 /*   350 */    59,   85,   88,   89,   97,   81,  140,  140,  224,  271,
 /*   360 */   284,   56,   91,  235,  143,  102,  216,  344,  139,  139,
 /*   370 */   414,  197,  141,  118,  118,   83,   93,  118,   61,   53,
 /*   380 */    55,   67,   63,   65,   73,   75,   77,   79,   69,   71,
 /*   390 */    49,   47,   51,   44,   41,   57,   90,   59,   85,   88,
 /*   400 */    89,   97,   81,  171,   40,   83,   93,  415,   61,   53,
 /*   410 */    55,   67,   63,   65,   73,   75,   77,   79,   69,   71,
 /*   420 */    49,   47,   51,   44,   41,   57,   90,   59,   85,   88,
 /*   430 */    89,   97,   81,  237,   27,   83,   93,  481,   61,   53,
 /*   440 */    55,   67,   63,   65,   73,   75,   77,   79,   69,   71,
 /*   450 */    49,   47,   51,   44,   41,   57,   90,   59,   85,   88,
 /*   460 */    89,   97,   81,   83,   93,  320,   61,   53,   55,   67,
 /*   470 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   480 */    51,   44,   41,   57,   90,   59,   85,   88,   89,   97,
 /*   490 */    81,  240,  332,   83,   93,  289,   61,   53,   55,   67,
 /*   500 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   510 */    51,   44,   41,   57,   90,   59,   85,   88,   89,   97,
 /*   520 */    81,  200,  248,   83,   93,  169,   61,   53,   55,   67,
 /*   530 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   540 */    51,   44,   41,   57,   90,   59,   85,   88,   89,   97,
 /*   550 */    81,  291,  254,   83,   93,  280,   61,   53,   55,   67,
 /*   560 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   570 */    51,   44,   41,   57,   90,   59,   85,   88,   89,   97,
 /*   580 */    81,  339,  257,   83,   93,  292,   61,   53,   55,   67,
 /*   590 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   600 */    51,   44,   41,   57,   90,   59,   85,   88,   89,  213,
 /*   610 */    81,   83,   93,  293,   61,   53,   55,   67,   63,   65,
 /*   620 */    73,   75,   77,   79,   69,   71,   49,   47,   51,   44,
 /*   630 */    41,   57,   90,   59,   85,   88,   89,   97,   81,   93,
 /*   640 */   322,   61,   53,   55,   67,   63,   65,   73,   75,   77,
 /*   650 */    79,   69,   71,   49,   47,   51,   44,   41,   57,   90,
 /*   660 */    59,   85,   88,   89,   97,   81,   61,   53,   55,   67,
 /*   670 */    63,   65,   73,   75,   77,   79,   69,   71,   49,   47,
 /*   680 */    51,   44,   41,   57,   90,   59,   85,   88,   89,   97,
 /*   690 */    81,   53,   55,   67,   63,   65,   73,   75,   77,   79,
 /*   700 */    69,   71,   49,   47,   51,   44,   41,   57,   90,   59,
 /*   710 */    85,   88,   89,   97,   81,  501,    1,    2,  272,    4,
 /*   720 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   730 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   28,
 /*   740 */   272,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   750 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   760 */    23,  207,  272,    4,    5,    6,    7,    8,    9,   10,
 /*   770 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   780 */    21,   22,   23,   67,   63,   65,   73,   75,   77,   79,
 /*   790 */    69,   71,   49,   47,   51,   44,   41,   57,   90,   59,
 /*   800 */    85,   88,   89,   97,   81,  232,  272,    4,    5,    6,
 /*   810 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   820 */    17,   18,   19,   20,   21,   22,   23,  264,  272,    4,
 /*   830 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   840 */    15,   16,   17,   18,   19,   20,   21,   22,   23,  217,
 /*   850 */   272,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   860 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   870 */    23,  281,  272,    4,    5,    6,    7,    8,    9,   10,
 /*   880 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   890 */    21,   22,   23,  275,  272,    4,    5,    6,    7,    8,
 /*   900 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   910 */    19,   20,   21,   22,   23,  333,  272,    4,    5,    6,
 /*   920 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   930 */    17,   18,   19,   20,   21,   22,   23,  175,  272,    4,
 /*   940 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   950 */    15,   16,   17,   18,   19,   20,   21,   22,   23,  298,
 /*   960 */   272,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   970 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   980 */    23,  317,  272,    4,    5,    6,    7,    8,    9,   10,
 /*   990 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*  1000 */    21,   22,   23,  326,  272,    4,    5,    6,    7,    8,
 /*  1010 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1020 */    19,   20,   21,   22,   23,   34,  272,    4,    5,    6,
 /*  1030 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1040 */    17,   18,   19,   20,   21,   22,   23,  225,  272,    4,
 /*  1050 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1060 */    15,   16,   17,   18,   19,   20,   21,   22,   23,    3,
 /*  1070 */     4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
 /*  1080 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*  1090 */   241,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*  1100 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  1110 */    23,   25,  221,  341,  343,   38,  168,  170,   98,  294,
 /*  1120 */   179,  349,   24,  105,  480,  127,   98,  202,  242,   24,
 /*  1130 */   118,  135,  107,  214,  114,  118,  211,  340,  118,  135,
 /*  1140 */   222,  263,  229,   26,  236,  105,  246,  249,  167,  255,
 /*  1150 */   258,  261,  196,  268,  270,  118,  126,  118,   45,   42,
 /*  1160 */   118,  104,   70,   99,  118,   29,  101,  243,   45,   42,
 /*  1170 */   117,  104,  105,   99,  118,  119,  101,  323,  297,  238,
 /*  1180 */   336,  112,  118,  114,  118,  119,  238,  120,  121,  122,
 /*  1190 */   123,  124,  125,   98,  238,  239,  245,  120,  121,  122,
 /*  1200 */   123,  124,  125,  245,  337,  118,  130,  118,  176,   68,
 /*  1210 */   345,  245,  129,  155,  156,  157,  158,  159,  160,  161,
 /*  1220 */   110,  118,  238,  148,  149,  150,  151,  152,  153,  154,
 /*  1230 */   110,   25,  221,   30,   32,   38,  168,  170,  244,  245,
 /*  1240 */   179,   58,  173,  247,  348,   54,  203,  202,  204,  301,
 /*  1250 */   481,  304,  342,  118,  118,  118,  211,  118,  128,   31,
 /*  1260 */   222,  238,  229,   35,  236,  238,  246,  249,  208,  255,
 /*  1270 */   258,  261,  218,  268,  270,   33,  303,  250,  245,   25,
 /*  1280 */   221,  195,  245,   38,  168,  170,  206,  198,  179,  118,
 /*  1290 */   287,  137,  305,   72,   39,  202,  144,  306,  185,  187,
 /*  1300 */   189,  191,  193,  116,  211,  118,  118,  138,  222,  227,
 /*  1310 */   229,  226,  236,  178,  246,  249,  233,  255,  258,  261,
 /*  1320 */   238,  268,  270,  347,  220,  238,  274,   25,  221,  238,
 /*  1330 */   132,   38,  168,  170,  210,  265,  179,  245,  276,  253,
 /*  1340 */   267,  212,  245,  202,  142,  256,  245,  238,  282,  480,
 /*  1350 */   329,  118,  211,  118,  278,  269,  222,  118,  229,  234,
 /*  1360 */   236,  278,  246,  249,  245,  255,  258,  261,  238,  268,
 /*  1370 */   270,  278,  278,  238,  278,   25,  221,   36,  278,   38,
 /*  1380 */   168,  170,  278,  299,  179,  245,  318,  278,  278,   64,
 /*  1390 */   245,  202,  238,  278,  327,  238,  334,  278,  278,  278,
 /*  1400 */   211,  118,  278,  278,  222,  238,  229,  278,  236,  245,
 /*  1410 */   246,  249,  245,  255,  258,  261,  278,  268,  270,  278,
 /*  1420 */   278,  163,  245,   25,  221,  278,  315,   38,  168,  170,
 /*  1430 */   259,  335,  179,  118,  278,  278,  278,  278,  118,  202,
 /*  1440 */   238,  278,  118,  238,  278,  278,  278,  278,  211,  278,
 /*  1450 */   278,  238,  222,  238,  229,  278,  236,  245,  246,  249,
 /*  1460 */   245,  255,  258,  261,  278,  268,  270,   76,  245,   66,
 /*  1470 */   245,   25,  221,   62,  324,   38,  168,  170,  165,  118,
 /*  1480 */   179,  118,  278,  278,  278,  118,  118,  202,  278,  278,
 /*  1490 */   118,   52,  278,  278,  278,  278,  211,  219,  278,  278,
 /*  1500 */   222,  278,  229,  118,  236,  278,  246,  249,  278,  255,
 /*  1510 */   258,  261,  278,  268,  270,  186,  278,  133,  278,   25,
 /*  1520 */   221,   50,  331,   38,  168,  170,  188,  118,  179,  118,
 /*  1530 */   278,  278,  278,  118,  118,  202,  278,   60,  118,  278,
 /*  1540 */   278,   87,  278,  278,  211,  278,  278,  278,  222,  118,
 /*  1550 */   229,  283,  236,  118,  246,  249,  278,  255,  258,  261,
 /*  1560 */   278,  268,  270,   48,  278,  190,  278,   25,  221,   46,
 /*  1570 */   192,   38,  168,  170,  166,  118,  179,  118,   94,   84,
 /*  1580 */   278,  118,  118,  202,  278,   96,  118,  230,  278,   74,
 /*  1590 */   118,  118,  211,  278,  278,  278,  222,  118,  229,  118,
 /*  1600 */   236,  118,  246,  249,  278,  255,  258,  261,  277,  268,
 /*  1610 */   270,   82,  278,   80,  194,   25,  221,  338,  100,   38,
 /*  1620 */   168,  170,   78,  118,  179,  118,  118,  278,  278,  278,
 /*  1630 */   118,  202,  278,   43,  118,  278,  278,  278,  278,  278,
 /*  1640 */   211,  278,  278,  278,  222,  118,  229,  278,  236,  278,
 /*  1650 */   246,  249,  278,  255,  258,  261,  278,  268,  270,  278,
 /*  1660 */   278,  278,  278,   25,  221,  278,  278,   38,  168,  170,
 /*  1670 */   278,  278,  179,  278,  278,  278,  278,  278,  278,  202,
 /*  1680 */   278,  209,  278,  278,  278,  278,  278,  278,  211,  278,
 /*  1690 */   278,  278,  222,  278,  229,  278,  236,  278,  246,  249,
 /*  1700 */   278,  255,  258,  261,  278,  268,  270,  278,  278,  278,
 /*  1710 */   278,   25,  221,  278,  278,   38,  168,  170,  278,  278,
 /*  1720 */   179,  278,  278,  278,  278,  278,  278,  202,  278,  278,
 /*  1730 */   278,  278,  278,  278,  278,  278,  211,  278,  278,  278,
 /*  1740 */   222,  288,  229,  278,  236,  278,  246,  249,  278,  255,
 /*  1750 */   258,  261,  278,  268,  270,  278,  278,  278,  278,   25,
 /*  1760 */   221,  278,  278,   38,  168,  170,  278,  278,  179,  278,
 /*  1770 */   278,  278,  278,  278,  278,  202,  278,  278,  278,  278,
 /*  1780 */   278,  278,  278,  278,  211,  278,  278,  278,  222,  278,
 /*  1790 */   229,  278,  236,  278,  246,  249,  278,  255,  258,  261,
 /*  1800 */   266,  268,  270,  278,  278,  278,  278,   25,  221,  278,
 /*  1810 */   278,   38,  168,  170,  278,  328,  179,  278,  278,  278,
 /*  1820 */   278,  278,  278,  202,  278,  278,  278,  278,  278,  278,
 /*  1830 */   278,  278,  211,  278,  278,  278,  222,  278,  229,  278,
 /*  1840 */   236,  278,  246,  249,  278,  255,  258,  261,  278,  268,
 /*  1850 */   270,  278,  278,  278,  278,   25,  221,  278,  278,   38,
 /*  1860 */   168,  170,  278,  278,  179,  278,  278,  278,  278,  278,
 /*  1870 */   278,  202,  278,  300,  278,  278,  278,  278,  278,  278,
 /*  1880 */   211,  278,  278,  278,  222,  278,  229,  278,  236,  278,
 /*  1890 */   246,  249,  278,  255,  258,  261,  278,  268,  270,  278,
 /*  1900 */   278,  278,  278,   25,  221,  278,  278,   38,  168,  170,
 /*  1910 */   278,  177,  179,  278,  278,  278,  278,  278,  278,  202,
 /*  1920 */   278,  278,  278,  278,  278,  278,  278,  278,  211,  278,
 /*  1930 */   278,  278,  222,  278,  229,  278,  236,  278,  246,  249,
 /*  1940 */   278,  255,  258,  261,  278,  268,  270,  278,  278,  278,
 /*  1950 */   278,   25,  221,  278,  278,   38,  168,  170,  278,  319,
 /*  1960 */   179,  278,  278,  278,  278,  278,  278,  202,  278,  278,
 /*  1970 */   278,  278,  278,  278,  278,  278,  211,  278,  278,  278,
 /*  1980 */   222,  278,  229,  278,  236,  278,  246,  249,  278,  255,
 /*  1990 */   258,  261,  278,  268,  270,  278,  278,  278,  278,   25,
 /*  2000 */   221,  278,  278,   38,  168,  170,  278,  278,  179,  278,
 /*  2010 */   278,  278,  278,  278,  278,  202,  278,  278,  278,  278,
 /*  2020 */   278,  278,  278,  278,  211,  278,  278,  278,  222,  278,
 /*  2030 */   229,  278,  236,  278,  246,  249,  278,  255,  258,  261,
 /*  2040 */   278,  268,  270,  278,  164,  278,   45,   42,  278,  104,
 /*  2050 */   136,   99,  278,  162,  101,  278,   45,   42,  278,  104,
 /*  2060 */   278,   99,  278,  119,  101,  278,   45,   42,  278,  104,
 /*  2070 */   278,   99,  278,  119,  101,  120,  121,  122,  123,  124,
 /*  2080 */   125,  278,  278,  147,  278,  120,  121,  122,  123,  124,
 /*  2090 */   125,  278,  278,  278,  278,  146,  121,  122,  123,  124,
 /*  2100 */   125,  278,   45,   42,  278,  104,  278,   99,  110,  278,
 /*  2110 */   101,  278,   45,   42,  278,  104,  278,   99,  110,  119,
 /*  2120 */   101,  278,  278,  278,  278,  278,  278,  106,  110,  119,
 /*  2130 */   278,  120,  115,  122,  123,  124,  125,  278,  278,  134,
 /*  2140 */   278,  120,  131,  122,  123,  124,  125,  278,  278,   45,
 /*  2150 */    42,  278,  104,  278,   99,   45,   42,  101,  104,  278,
 /*  2160 */    99,  278,  278,  101,  110,  278,  119,  278,  278,  278,
 /*  2170 */   278,  278,  119,  278,  110,  278,  290,  278,  120,  131,
 /*  2180 */   122,  123,  124,  125,  120,  115,  122,  123,  124,  125,
 /*  2190 */   278,  278,  278,  278,  278,  278,   45,   42,  278,  104,
 /*  2200 */   278,   99,   45,   42,  101,  104,  278,   99,  278,  278,
 /*  2210 */   101,  110,  278,  119,  278,  278,  278,  110,  111,  119,
 /*  2220 */   278,  278,  278,  278,  278,  120,  121,  122,  123,  124,
 /*  2230 */   125,  120,  115,  122,  123,  124,  125,  278,  278,   45,
 /*  2240 */    42,  278,  104,  278,   99,  278,  278,  101,  278,  278,
 /*  2250 */   278,  278,  278,  278,  278,  278,  119,  278,  110,  278,
 /*  2260 */   278,  278,  278,  278,  110,  278,  278,  278,  120,  131,
 /*  2270 */   122,  123,  124,  125,  278,  278,  278,  278,  278,  278,
 /*  2280 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  2290 */   278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
 /*  2300 */   278,  110,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     3,    4,    2,    6,    7,    8,    9,   10,   11,   12,
 /*    10 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*    20 */    23,   24,   25,   26,   27,   28,   29,   30,    3,   32,
 /*    30 */    26,   27,   28,   29,   30,   38,   21,   22,   23,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   46,   50,  111,  112,
 /*    50 */   113,    3,    4,    2,    6,    7,    8,    9,   10,   11,
 /*    60 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*    70 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   38,
 /*    80 */    32,    3,    4,   32,    6,    7,    8,    9,   10,   11,
 /*    90 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   100 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   110 */    32,    2,    3,   32,    3,    4,   68,    6,    7,    8,
 /*   120 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   130 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   140 */    29,   30,   31,   32,    3,    4,   32,    6,    7,    8,
 /*   150 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   160 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   170 */    29,   30,  118,   32,    3,    4,    5,    6,    7,    8,
 /*   180 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   190 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   200 */    29,   30,    3,    4,    2,    6,    7,    8,    9,   10,
 /*   210 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   220 */    21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
 /*   230 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   240 */    28,   29,   30,   38,  114,  115,   38,   48,    2,   33,
 /*   250 */    48,    3,    4,   48,    6,    7,    8,    9,   10,   11,
 /*   260 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   270 */    22,   23,   24,   25,   26,   27,   28,   29,   30,    2,
 /*   280 */    32,    3,    4,   46,    6,    7,    8,    9,   10,   11,
 /*   290 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   300 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   24,
 /*   310 */    25,   26,   27,   28,   29,   30,   50,   51,   52,   53,
 /*   320 */    54,   55,  112,  113,   46,   48,   54,   55,    3,    4,
 /*   330 */    84,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   340 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   350 */    25,   26,   27,   28,   29,   30,   38,   38,   32,   32,
 /*   360 */    32,  110,  110,   32,   46,  110,   32,   32,   50,   50,
 /*   370 */    32,   46,  120,  122,  122,    3,    4,  122,    6,    7,
 /*   380 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   390 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   400 */    28,   29,   30,   38,   32,    3,    4,   32,    6,    7,
 /*   410 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   420 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   32,   32,    3,    4,   46,    6,    7,
 /*   440 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   450 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   460 */    28,   29,   30,    3,    4,   32,    6,    7,    8,    9,
 /*   470 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   480 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   490 */    30,   59,   32,    3,    4,   32,    6,    7,    8,    9,
 /*   500 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   510 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   520 */    30,  113,   32,    3,    4,   32,    6,    7,    8,    9,
 /*   530 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   540 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   550 */    30,   32,   32,    3,    4,   32,    6,    7,    8,    9,
 /*   560 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   570 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   580 */    30,   32,   32,    3,    4,    1,    6,    7,    8,    9,
 /*   590 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   600 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   610 */    30,    3,    4,   57,    6,    7,    8,    9,   10,   11,
 /*   620 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   630 */    22,   23,   24,   25,   26,   27,   28,   29,   30,    4,
 /*   640 */    38,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   650 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   660 */    25,   26,   27,   28,   29,   30,    6,    7,    8,    9,
 /*   670 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   680 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*   690 */    30,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   700 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   710 */    26,   27,   28,   29,   30,   86,   87,   88,   89,   90,
 /*   720 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   730 */   101,  102,  103,  104,  105,  106,  107,  108,  109,   88,
 /*   740 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   750 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   760 */   109,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   770 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   780 */   107,  108,  109,    9,   10,   11,   12,   13,   14,   15,
 /*   790 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   800 */    26,   27,   28,   29,   30,   88,   89,   90,   91,   92,
 /*   810 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   820 */   103,  104,  105,  106,  107,  108,  109,   88,   89,   90,
 /*   830 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   840 */   101,  102,  103,  104,  105,  106,  107,  108,  109,   88,
 /*   850 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   860 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   870 */   109,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   880 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   890 */   107,  108,  109,   88,   89,   90,   91,   92,   93,   94,
 /*   900 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   910 */   105,  106,  107,  108,  109,   88,   89,   90,   91,   92,
 /*   920 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   930 */   103,  104,  105,  106,  107,  108,  109,   88,   89,   90,
 /*   940 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   950 */   101,  102,  103,  104,  105,  106,  107,  108,  109,   88,
 /*   960 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   970 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   980 */   109,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   990 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1000 */   107,  108,  109,   88,   89,   90,   91,   92,   93,   94,
 /*  1010 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1020 */   105,  106,  107,  108,  109,   88,   89,   90,   91,   92,
 /*  1030 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1040 */   103,  104,  105,  106,  107,  108,  109,   88,   89,   90,
 /*  1050 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1060 */   101,  102,  103,  104,  105,  106,  107,  108,  109,   89,
 /*  1070 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*  1080 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
 /*  1090 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1100 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1110 */   109,   31,   32,   33,   34,   35,   36,   37,  110,   32,
 /*  1120 */    40,    0,    1,  110,    5,  117,  110,   47,    1,    1,
 /*  1130 */   122,  123,  119,  117,  121,  122,   56,    1,  122,  123,
 /*  1140 */    60,   32,   62,  110,   64,  110,   66,   67,  110,   69,
 /*  1150 */    70,   71,  110,   73,   74,  122,  121,  122,   21,   22,
 /*  1160 */   122,   24,  110,   26,  122,    1,   29,   65,   21,   22,
 /*  1170 */   110,   24,  110,   26,  122,   38,   29,    3,   32,   58,
 /*  1180 */    32,  119,  122,  121,  122,   38,   58,   50,   51,   52,
 /*  1190 */    53,   54,   55,  110,   58,  110,   75,   50,   51,   52,
 /*  1200 */    53,   54,   55,   75,    1,  122,  123,  122,    1,  110,
 /*  1210 */     1,   75,    2,   76,   77,   78,   79,   80,   81,   82,
 /*  1220 */    83,  122,   58,   76,   77,   78,   79,   80,   81,   82,
 /*  1230 */    83,   31,   32,   33,   34,   35,   36,   37,   32,   75,
 /*  1240 */    40,  110,  110,  110,    0,  110,   38,   47,   29,   32,
 /*  1250 */     5,   38,   32,  122,  122,  122,   56,  122,   48,   32,
 /*  1260 */    60,   58,   62,    1,   64,   58,   66,   67,    1,   69,
 /*  1270 */    70,   71,    1,   73,   74,   32,  115,  110,   75,   31,
 /*  1280 */    32,   24,   75,   35,   36,   37,   32,   30,   40,  122,
 /*  1290 */     1,  120,   41,  110,  110,   47,  120,  116,   41,   42,
 /*  1300 */    43,   44,   45,    5,   56,  122,  122,   46,   60,   61,
 /*  1310 */    62,    1,   64,   32,   66,   67,    1,   69,   70,   71,
 /*  1320 */    58,   73,   74,   32,   32,   58,   32,   31,   32,   58,
 /*  1330 */     5,   35,   36,   37,   32,    1,   40,   75,    1,  110,
 /*  1340 */    32,  110,   75,   47,    5,  110,   75,   58,    1,   46,
 /*  1350 */    32,  122,   56,  122,   32,   32,   60,  122,   62,   63,
 /*  1360 */    64,  124,   66,   67,   75,   69,   70,   71,   58,   73,
 /*  1370 */    74,  124,  124,   58,  124,   31,   32,   33,  124,   35,
 /*  1380 */    36,   37,  124,    1,   40,   75,    1,  124,  124,  110,
 /*  1390 */    75,   47,   58,  124,    1,   58,    1,  124,  124,  124,
 /*  1400 */    56,  122,  124,  124,   60,   58,   62,  124,   64,   75,
 /*  1410 */    66,   67,   75,   69,   70,   71,  124,   73,   74,  124,
 /*  1420 */   124,  110,   75,   31,   32,  124,  110,   35,   36,   37,
 /*  1430 */   110,   39,   40,  122,  124,  124,  124,  124,  122,   47,
 /*  1440 */    58,  124,  122,   58,  124,  124,  124,  124,   56,  124,
 /*  1450 */   124,   58,   60,   58,   62,  124,   64,   75,   66,   67,
 /*  1460 */    75,   69,   70,   71,  124,   73,   74,  110,   75,  110,
 /*  1470 */    75,   31,   32,  110,  110,   35,   36,   37,  110,  122,
 /*  1480 */    40,  122,  124,  124,  124,  122,  122,   47,  124,  124,
 /*  1490 */   122,  110,  124,  124,  124,  124,   56,   57,  124,  124,
 /*  1500 */    60,  124,   62,  122,   64,  124,   66,   67,  124,   69,
 /*  1510 */    70,   71,  124,   73,   74,  110,  124,  110,  124,   31,
 /*  1520 */    32,  110,  110,   35,   36,   37,  110,  122,   40,  122,
 /*  1530 */   124,  124,  124,  122,  122,   47,  124,  110,  122,  124,
 /*  1540 */   124,  110,  124,  124,   56,  124,  124,  124,   60,  122,
 /*  1550 */    62,   63,   64,  122,   66,   67,  124,   69,   70,   71,
 /*  1560 */   124,   73,   74,  110,  124,  110,  124,   31,   32,  110,
 /*  1570 */   110,   35,   36,   37,  110,  122,   40,  122,  110,  110,
 /*  1580 */   124,  122,  122,   47,  124,  110,  122,  110,  124,  110,
 /*  1590 */   122,  122,   56,  124,  124,  124,   60,  122,   62,  122,
 /*  1600 */    64,  122,   66,   67,  124,   69,   70,   71,   72,   73,
 /*  1610 */    74,  110,  124,  110,  110,   31,   32,   33,  110,   35,
 /*  1620 */    36,   37,  110,  122,   40,  122,  122,  124,  124,  124,
 /*  1630 */   122,   47,  124,  110,  122,  124,  124,  124,  124,  124,
 /*  1640 */    56,  124,  124,  124,   60,  122,   62,  124,   64,  124,
 /*  1650 */    66,   67,  124,   69,   70,   71,  124,   73,   74,  124,
 /*  1660 */   124,  124,  124,   31,   32,  124,  124,   35,   36,   37,
 /*  1670 */   124,  124,   40,  124,  124,  124,  124,  124,  124,   47,
 /*  1680 */   124,   49,  124,  124,  124,  124,  124,  124,   56,  124,
 /*  1690 */   124,  124,   60,  124,   62,  124,   64,  124,   66,   67,
 /*  1700 */   124,   69,   70,   71,  124,   73,   74,  124,  124,  124,
 /*  1710 */   124,   31,   32,  124,  124,   35,   36,   37,  124,  124,
 /*  1720 */    40,  124,  124,  124,  124,  124,  124,   47,  124,  124,
 /*  1730 */   124,  124,  124,  124,  124,  124,   56,  124,  124,  124,
 /*  1740 */    60,   61,   62,  124,   64,  124,   66,   67,  124,   69,
 /*  1750 */    70,   71,  124,   73,   74,  124,  124,  124,  124,   31,
 /*  1760 */    32,  124,  124,   35,   36,   37,  124,  124,   40,  124,
 /*  1770 */   124,  124,  124,  124,  124,   47,  124,  124,  124,  124,
 /*  1780 */   124,  124,  124,  124,   56,  124,  124,  124,   60,  124,
 /*  1790 */    62,  124,   64,  124,   66,   67,  124,   69,   70,   71,
 /*  1800 */    72,   73,   74,  124,  124,  124,  124,   31,   32,  124,
 /*  1810 */   124,   35,   36,   37,  124,   39,   40,  124,  124,  124,
 /*  1820 */   124,  124,  124,   47,  124,  124,  124,  124,  124,  124,
 /*  1830 */   124,  124,   56,  124,  124,  124,   60,  124,   62,  124,
 /*  1840 */    64,  124,   66,   67,  124,   69,   70,   71,  124,   73,
 /*  1850 */    74,  124,  124,  124,  124,   31,   32,  124,  124,   35,
 /*  1860 */    36,   37,  124,  124,   40,  124,  124,  124,  124,  124,
 /*  1870 */   124,   47,  124,   49,  124,  124,  124,  124,  124,  124,
 /*  1880 */    56,  124,  124,  124,   60,  124,   62,  124,   64,  124,
 /*  1890 */    66,   67,  124,   69,   70,   71,  124,   73,   74,  124,
 /*  1900 */   124,  124,  124,   31,   32,  124,  124,   35,   36,   37,
 /*  1910 */   124,   39,   40,  124,  124,  124,  124,  124,  124,   47,
 /*  1920 */   124,  124,  124,  124,  124,  124,  124,  124,   56,  124,
 /*  1930 */   124,  124,   60,  124,   62,  124,   64,  124,   66,   67,
 /*  1940 */   124,   69,   70,   71,  124,   73,   74,  124,  124,  124,
 /*  1950 */   124,   31,   32,  124,  124,   35,   36,   37,  124,   39,
 /*  1960 */    40,  124,  124,  124,  124,  124,  124,   47,  124,  124,
 /*  1970 */   124,  124,  124,  124,  124,  124,   56,  124,  124,  124,
 /*  1980 */    60,  124,   62,  124,   64,  124,   66,   67,  124,   69,
 /*  1990 */    70,   71,  124,   73,   74,  124,  124,  124,  124,   31,
 /*  2000 */    32,  124,  124,   35,   36,   37,  124,  124,   40,  124,
 /*  2010 */   124,  124,  124,  124,  124,   47,  124,  124,  124,  124,
 /*  2020 */   124,  124,  124,  124,   56,  124,  124,  124,   60,  124,
 /*  2030 */    62,  124,   64,  124,   66,   67,  124,   69,   70,   71,
 /*  2040 */   124,   73,   74,  124,   19,  124,   21,   22,  124,   24,
 /*  2050 */     5,   26,  124,   18,   29,  124,   21,   22,  124,   24,
 /*  2060 */   124,   26,  124,   38,   29,  124,   21,   22,  124,   24,
 /*  2070 */   124,   26,  124,   38,   29,   50,   51,   52,   53,   54,
 /*  2080 */    55,  124,  124,   38,  124,   50,   51,   52,   53,   54,
 /*  2090 */    55,  124,  124,  124,  124,   50,   51,   52,   53,   54,
 /*  2100 */    55,  124,   21,   22,  124,   24,  124,   26,   83,  124,
 /*  2110 */    29,  124,   21,   22,  124,   24,  124,   26,   83,   38,
 /*  2120 */    29,  124,  124,  124,  124,  124,  124,   46,   83,   38,
 /*  2130 */   124,   50,   51,   52,   53,   54,   55,  124,  124,   48,
 /*  2140 */   124,   50,   51,   52,   53,   54,   55,  124,  124,   21,
 /*  2150 */    22,  124,   24,  124,   26,   21,   22,   29,   24,  124,
 /*  2160 */    26,  124,  124,   29,   83,  124,   38,  124,  124,  124,
 /*  2170 */   124,  124,   38,  124,   83,  124,   48,  124,   50,   51,
 /*  2180 */    52,   53,   54,   55,   50,   51,   52,   53,   54,   55,
 /*  2190 */   124,  124,  124,  124,  124,  124,   21,   22,  124,   24,
 /*  2200 */   124,   26,   21,   22,   29,   24,  124,   26,  124,  124,
 /*  2210 */    29,   83,  124,   38,  124,  124,  124,   83,   84,   38,
 /*  2220 */   124,  124,  124,  124,  124,   50,   51,   52,   53,   54,
 /*  2230 */    55,   50,   51,   52,   53,   54,   55,  124,  124,   21,
 /*  2240 */    22,  124,   24,  124,   26,  124,  124,   29,  124,  124,
 /*  2250 */   124,  124,  124,  124,  124,  124,   38,  124,   83,  124,
 /*  2260 */   124,  124,  124,  124,   83,  124,  124,  124,   50,   51,
 /*  2270 */    52,   53,   54,   55,  124,  124,  124,  124,  124,  124,
 /*  2280 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*  2290 */   124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
 /*  2300 */   124,   83,
};
#define YY_SHIFT_USE_DFLT (-4)
static short yy_shift_ofst[] = {
 /*     0 */  1128, 1244, 1121,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*    10 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*    20 */    -4,   -4,   -4,   -4, 1968, 2175,  402, 1136, 1164, 1200,
 /*    30 */  1227,   -4, 1243, 1203, 1262, 1344,   81,   -4, 2175,  372,
 /*    40 */    -4, 2175, 2175,  285, 2175, 2175,  285, 2025,   15, 2035,
 /*    50 */    15, 2175,   15, 2175,  774, 2175,  774, 2175,  285, 2175,
 /*    60 */     4, 2175,  684, 2175,  212, 1137,  212, 1147,  212, 2175,
 /*    70 */   212, 2175,  212, 2175,  212, 2175,  212, 2175,  212, 2175,
 /*    80 */   212, 2175,   -4, 2175,  635,   25, 2175,    4,   -4,   -4,
 /*    90 */  2045,  278,   -4, 2175,  171, 2175,  660, 2091,  608, 2175,
 /*   100 */     4, 2175,  199,   -4, 2081,  608,   -4,    0,   -4, 2181,
 /*   110 */  2134,   -4,  246,   -4,   -4, 1298, 2175,  608,   -4,   -4,
 /*   120 */    -4,   -4,   -4,   -4,   -4,   -4,   -4, 1210,   -4, 2218,
 /*   130 */    -4, 1325, 2175,  608,   -4,   -4,  319, 1261,   -4, 1303,
 /*   140 */   391, 1339,  318,   -4,  237,   -4, 1119, 1245,   -4,   -4,
 /*   150 */    -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,   -4,
 /*   160 */    -4,   -4, 2175,   15, 2175,   15,  285,  285,  493,   -4,
 /*   170 */   365,  109, 2175,   78, 1128, 1207, 1872, 1281,   -4,  208,
 /*   180 */    51,   -4,  208,   -4, 1257, 2175,  608, 2175,  608, 2175,
 /*   190 */   608, 2175,  608, 2175,  608, 2175,  325,   -4,  208,   -4,
 /*   200 */    -4,   -4, 1208, 1219,  205, 1254, 1128, 1267, 1632, 1302,
 /*   210 */    -4, 2175,  580, 2128,  277,  334, 1128, 1271, 1440, 1292,
 /*   220 */    -4,   -4,   41,  326, 1289, 1310, 1248,  114,   -4, 2175,
 /*   230 */    -3, 1128, 1315, 1296,  331,   -4,  401, 1128, 2175,  432,
 /*   240 */    -4, 1127, 1102, 1206,   -4,   -4, 2175,  490,   -4, 2175,
 /*   250 */    48,   -4, 2175,  520,   -4, 2175,  550,   -4, 2175,  141,
 /*   260 */    -4,  272, 1109, 1128, 1334, 1728, 1308,   -4, 1323,   -4,
 /*   270 */   327,   -4,   -4, 1294, 1128, 1337, 1536, 1322,   -4,  523,
 /*   280 */  1128, 1347, 1488,  328,   -4,  338,  375, 1680,  463,   -4,
 /*   290 */   519,  584,  556, 1087,   -4,  202, 1146, 1128, 1382, 1824,
 /*   300 */  1217,   -4, 1213,   -4, 1251,  266,   -4,   -4,   -4,   -4,
 /*   310 */    -4,   -4,   -4,   -4, 2175,  248, 1128, 1385, 1920,  433,
 /*   320 */    -4,  602, 1174, 2175,  111, 1128, 1393, 1776, 1318,   -4,
 /*   330 */  2175,  460, 1128, 1395, 1392, 1148,   -4, 1584,  549,   -4,
 /*   340 */  1080, 1220,   -4,  335, 1209,  216, 1291,   -4,
};
#define YY_REDUCE_USE_DFLT (-64)
static short yy_reduce_ofst[] = {
 /*     0 */   629,  -64,  980,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 /*    10 */   -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 /*    20 */   -64,  -64,  -64,  -64,  -64, 1033,  -64,  651,  980,  -64,
 /*    30 */   -64,  -64,  -64,  937,  980,  -64,  -64,  -64, 1184,  -64,
 /*    40 */   -64, 1038, 1523,  -64, 1464, 1459,  -64, 1453,  -64, 1411,
 /*    50 */   -64, 1381,  -64, 1135,  -64,  251,  -64, 1131,  -64, 1427,
 /*    60 */   -64, 1363,  -64, 1279,  -64, 1359,  -64, 1099,  -64, 1052,
 /*    70 */   -64, 1183,  -64, 1479,  -64, 1357,  -64, 1512,  -64, 1503,
 /*    80 */   -64, 1501,  -64, 1469,  -64,  -64, 1431,  -64,  -64,  -64,
 /*    90 */   252,  -64,  -64, 1468,  -64, 1475,  -64, 1008,  -64, 1508,
 /*   100 */   -64,  255,  -64,  -64, 1013,  -64,  -64,  -64,  -64, 1035,
 /*   110 */  1062,  -64,  -64,  -64,  -64,  -64, 1060,  -64,  -64,  -64,
 /*   120 */   -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64, 1083,
 /*   130 */   -64,  -64, 1407,  -64,  -64,  -64, 1171,  -64,  -64,  -64,
 /*   140 */   -64,  -64, 1176,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 /*   150 */   -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 /*   160 */   -64,  -64, 1311,  -64, 1368,  -64,  -64,  -64,  -64,  -64,
 /*   170 */   -64,  -64, 1132,  -64,  849,  980,  -64,  -64,  -64,  -63,
 /*   180 */   -64,  -64,  210,  -64,  -64, 1405,  -64, 1416,  -64, 1455,
 /*   190 */   -64, 1460,  -64, 1504,  -64, 1042,  -64,  -64,  408,  -64,
 /*   200 */   -64,  -64,  -64,  -64,  130,  -64,  673,  980,  -64,  -64,
 /*   210 */   -64, 1231,  -64, 1016,  -64,  -64,  761,  980,  -64,  -64,
 /*   220 */   -64,  -64,  -64,  -64,  959,  980,  -64,  -64,  -64, 1477,
 /*   230 */    54,  717,  980,  -64,  -64,  -64,  -64, 1001, 1085,  -64,
 /*   240 */   -64,  -64,  -64,  -64,  -64,  -64, 1133,  -64,  -64, 1167,
 /*   250 */   -64,  -64, 1229,  -64,  -64, 1235,  -64,  -64, 1320,  -64,
 /*   260 */   -64,  -64,  -64,  739,  980,  -64,  -64,  -64,  -64,  -64,
 /*   270 */   -64,  -64,  -64,  -64,  805,  980,  -64,  -64,  -64,  -64,
 /*   280 */   783,  980,  -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
 /*   290 */   -64,  -64,  -64,  -64,  -64,  -64,  -64,  871,  980,  -64,
 /*   300 */   -64,  -64, 1161,  -64,  -64, 1181,  -64,  -64,  -64,  -64,
 /*   310 */   -64,  -64,  -64,  -64, 1316,  -64,  893,  980,  -64,  -64,
 /*   320 */   -64,  -64,  -64, 1364,  -64,  915,  980,  -64,  -64,  -64,
 /*   330 */  1412,  -64,  827,  980,  -64,  -64,  -64,  -64,  -64,  -64,
 /*   340 */   -64,  -64,  -64,  -64,  -64,  -64,  -64,  -64,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   500,  500,  500,  350,  352,  353,  354,  355,  356,  357,
 /*    10 */   358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
 /*    20 */   368,  369,  370,  371,  500,  500,  500,  500,  500,  500,
 /*    30 */   500,  372,  500,  500,  500,  500,  500,  374,  500,  500,
 /*    40 */   377,  500,  500,  427,  500,  500,  428,  500,  431,  500,
 /*    50 */   433,  500,  435,  500,  436,  500,  437,  500,  438,  500,
 /*    60 */   439,  500,  440,  500,  441,  500,  457,  500,  456,  500,
 /*    70 */   458,  500,  459,  500,  460,  500,  461,  500,  462,  500,
 /*    80 */   463,  500,  464,  500,  465,  500,  500,  466,  468,  469,
 /*    90 */   500,  500,  475,  500,  500,  500,  476,  500,  491,  500,
 /*   100 */   467,  500,  500,  470,  500,  485,  471,  500,  472,  500,
 /*   110 */   500,  473,  500,  474,  483,  495,  500,  484,  486,  493,
 /*   120 */   494,  495,  496,  497,  498,  499,  482,  500,  487,  500,
 /*   130 */   489,  495,  500,  492,  488,  490,  500,  500,  477,  500,
 /*   140 */   500,  500,  500,  478,  500,  479,  494,  493,  443,  445,
 /*   150 */   447,  449,  451,  453,  455,  442,  444,  446,  448,  450,
 /*   160 */   452,  454,  500,  434,  500,  432,  430,  429,  500,  378,
 /*   170 */   500,  500,  500,  500,  500,  500,  500,  500,  379,  500,
 /*   180 */   500,  383,  500,  384,  500,  500,  386,  500,  387,  500,
 /*   190 */   388,  500,  389,  500,  390,  500,  500,  392,  500,  391,
 /*   200 */   393,  385,  500,  500,  500,  500,  500,  500,  500,  500,
 /*   210 */   394,  500,  500,  500,  500,  487,  500,  500,  500,  500,
 /*   220 */   406,  408,  500,  500,  500,  500,  500,  500,  410,  500,
 /*   230 */   500,  500,  500,  500,  500,  412,  500,  500,  500,  500,
 /*   240 */   409,  500,  500,  500,  416,  426,  500,  500,  417,  500,
 /*   250 */   500,  418,  500,  500,  419,  500,  500,  420,  500,  500,
 /*   260 */   421,  500,  500,  500,  500,  500,  500,  422,  500,  424,
 /*   270 */   500,  425,  351,  500,  500,  500,  500,  500,  423,  500,
 /*   280 */   500,  500,  500,  500,  413,  500,  500,  500,  500,  411,
 /*   290 */   488,  500,  500,  500,  407,  500,  500,  500,  500,  500,
 /*   300 */   500,  395,  500,  396,  398,  500,  399,  400,  401,  402,
 /*   310 */   403,  404,  405,  397,  500,  500,  500,  500,  500,  500,
 /*   320 */   380,  500,  500,  500,  500,  500,  500,  500,  500,  381,
 /*   330 */   500,  500,  500,  500,  500,  500,  382,  500,  500,  375,
 /*   340 */   500,  500,  373,  500,  500,  500,  500,  376,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  phvolt_ARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_Trace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "OPEN_DELIMITER",  "COMMA",         "IN",          
  "QUESTION",      "COLON",         "RANGE",         "AND",         
  "OR",            "IS",            "EQUALS",        "NOTEQUALS",   
  "LESS",          "GREATER",       "GREATEREQUAL",  "LESSEQUAL",   
  "IDENTICAL",     "NOTIDENTICAL",  "DIVIDE",        "TIMES",       
  "MOD",           "PLUS",          "MINUS",         "CONCAT",      
  "SBRACKET_OPEN",  "PIPE",          "NOT",           "INCR",        
  "DECR",          "PARENTHESES_OPEN",  "DOT",           "IF",          
  "CLOSE_DELIMITER",  "ENDIF",         "ELSE",          "ELSEIF",      
  "ELSEFOR",       "FOR",           "IDENTIFIER",    "ENDFOR",      
  "SET",           "ASSIGN",        "ADD_ASSIGN",    "SUB_ASSIGN",  
  "MUL_ASSIGN",    "DIV_ASSIGN",    "SBRACKET_CLOSE",  "MACRO",       
  "PARENTHESES_CLOSE",  "ENDMACRO",      "INTEGER",       "STRING",      
  "DOUBLE",        "NULL",          "FALSE",         "TRUE",        
  "CALL",          "ENDCALL",       "OPEN_EDELIMITER",  "CLOSE_EDELIMITER",
  "BLOCK",         "ENDBLOCK",      "CACHE",         "ENDCACHE",    
  "RAW",           "ENDRAW",        "EXTENDS",       "INCLUDE",     
  "WITH",          "DO",            "RETURN",        "AUTOESCAPE",  
  "ENDAUTOESCAPE",  "BREAK",         "CONTINUE",      "RAW_FRAGMENT",
  "DEFINED",       "EMPTY",         "EVEN",          "ODD",         
  "NUMERIC",       "SCALAR",        "ITERABLE",      "CBRACKET_OPEN",
  "CBRACKET_CLOSE",  "error",         "program",       "volt_language",
  "statement_list",  "statement",     "raw_fragment",  "if_statement",
  "elseif_statement",  "elsefor_statement",  "for_statement",  "set_statement",
  "echo_statement",  "block_statement",  "cache_statement",  "extends_statement",
  "include_statement",  "do_statement",  "return_statement",  "autoescape_statement",
  "raw_statement",  "break_statement",  "continue_statement",  "macro_statement",
  "empty_statement",  "macro_call_statement",  "expr",          "set_assignments",
  "set_assignment",  "assignable_expr",  "macro_parameters",  "macro_parameter",
  "macro_parameter_default",  "argument_list",  "cache_lifetime",  "array_list",  
  "slice_offset",  "array_item",    "function_call",  "argument_item",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "program ::= volt_language",
 /*   1 */ "volt_language ::= statement_list",
 /*   2 */ "statement_list ::= statement_list statement",
 /*   3 */ "statement_list ::= statement",
 /*   4 */ "statement ::= raw_fragment",
 /*   5 */ "statement ::= if_statement",
 /*   6 */ "statement ::= elseif_statement",
 /*   7 */ "statement ::= elsefor_statement",
 /*   8 */ "statement ::= for_statement",
 /*   9 */ "statement ::= set_statement",
 /*  10 */ "statement ::= echo_statement",
 /*  11 */ "statement ::= block_statement",
 /*  12 */ "statement ::= cache_statement",
 /*  13 */ "statement ::= extends_statement",
 /*  14 */ "statement ::= include_statement",
 /*  15 */ "statement ::= do_statement",
 /*  16 */ "statement ::= return_statement",
 /*  17 */ "statement ::= autoescape_statement",
 /*  18 */ "statement ::= raw_statement",
 /*  19 */ "statement ::= break_statement",
 /*  20 */ "statement ::= continue_statement",
 /*  21 */ "statement ::= macro_statement",
 /*  22 */ "statement ::= empty_statement",
 /*  23 */ "statement ::= macro_call_statement",
 /*  24 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  25 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  26 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  27 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  28 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  29 */ "elseif_statement ::= OPEN_DELIMITER ELSEIF expr CLOSE_DELIMITER",
 /*  30 */ "elsefor_statement ::= OPEN_DELIMITER ELSEFOR CLOSE_DELIMITER",
 /*  31 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  32 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  33 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  34 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  35 */ "set_statement ::= OPEN_DELIMITER SET set_assignments CLOSE_DELIMITER",
 /*  36 */ "set_assignments ::= set_assignments COMMA set_assignment",
 /*  37 */ "set_assignments ::= set_assignment",
 /*  38 */ "set_assignment ::= assignable_expr ASSIGN expr",
 /*  39 */ "set_assignment ::= assignable_expr ADD_ASSIGN expr",
 /*  40 */ "set_assignment ::= assignable_expr SUB_ASSIGN expr",
 /*  41 */ "set_assignment ::= assignable_expr MUL_ASSIGN expr",
 /*  42 */ "set_assignment ::= assignable_expr DIV_ASSIGN expr",
 /*  43 */ "assignable_expr ::= IDENTIFIER",
 /*  44 */ "assignable_expr ::= assignable_expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /*  45 */ "assignable_expr ::= assignable_expr DOT assignable_expr",
 /*  46 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  47 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN macro_parameters PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  48 */ "macro_parameters ::= macro_parameters COMMA macro_parameter",
 /*  49 */ "macro_parameters ::= macro_parameter",
 /*  50 */ "macro_parameter ::= IDENTIFIER",
 /*  51 */ "macro_parameter ::= IDENTIFIER ASSIGN macro_parameter_default",
 /*  52 */ "macro_parameter_default ::= INTEGER",
 /*  53 */ "macro_parameter_default ::= STRING",
 /*  54 */ "macro_parameter_default ::= DOUBLE",
 /*  55 */ "macro_parameter_default ::= NULL",
 /*  56 */ "macro_parameter_default ::= FALSE",
 /*  57 */ "macro_parameter_default ::= TRUE",
 /*  58 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  59 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  60 */ "empty_statement ::= OPEN_DELIMITER CLOSE_DELIMITER",
 /*  61 */ "echo_statement ::= OPEN_EDELIMITER expr CLOSE_EDELIMITER",
 /*  62 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  63 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  64 */ "cache_statement ::= OPEN_DELIMITER CACHE expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  65 */ "cache_statement ::= OPEN_DELIMITER CACHE expr cache_lifetime CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  66 */ "cache_lifetime ::= INTEGER",
 /*  67 */ "cache_lifetime ::= IDENTIFIER",
 /*  68 */ "raw_statement ::= OPEN_DELIMITER RAW CLOSE_DELIMITER statement OPEN_DELIMITER ENDRAW CLOSE_DELIMITER",
 /*  69 */ "extends_statement ::= OPEN_DELIMITER EXTENDS expr CLOSE_DELIMITER",
 /*  70 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr CLOSE_DELIMITER",
 /*  71 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr WITH expr CLOSE_DELIMITER",
 /*  72 */ "do_statement ::= OPEN_DELIMITER DO expr CLOSE_DELIMITER",
 /*  73 */ "return_statement ::= OPEN_DELIMITER RETURN expr CLOSE_DELIMITER",
 /*  74 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE FALSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  75 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE TRUE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  76 */ "break_statement ::= OPEN_DELIMITER BREAK CLOSE_DELIMITER",
 /*  77 */ "continue_statement ::= OPEN_DELIMITER CONTINUE CLOSE_DELIMITER",
 /*  78 */ "raw_fragment ::= RAW_FRAGMENT",
 /*  79 */ "expr ::= MINUS expr",
 /*  80 */ "expr ::= PLUS expr",
 /*  81 */ "expr ::= expr MINUS expr",
 /*  82 */ "expr ::= expr PLUS expr",
 /*  83 */ "expr ::= expr TIMES expr",
 /*  84 */ "expr ::= expr TIMES TIMES expr",
 /*  85 */ "expr ::= expr DIVIDE expr",
 /*  86 */ "expr ::= expr DIVIDE DIVIDE expr",
 /*  87 */ "expr ::= expr MOD expr",
 /*  88 */ "expr ::= expr AND expr",
 /*  89 */ "expr ::= expr OR expr",
 /*  90 */ "expr ::= expr CONCAT expr",
 /*  91 */ "expr ::= expr PIPE expr",
 /*  92 */ "expr ::= expr RANGE expr",
 /*  93 */ "expr ::= expr EQUALS expr",
 /*  94 */ "expr ::= expr NOTEQUALS DEFINED",
 /*  95 */ "expr ::= expr IS DEFINED",
 /*  96 */ "expr ::= expr NOTEQUALS EMPTY",
 /*  97 */ "expr ::= expr IS EMPTY",
 /*  98 */ "expr ::= expr NOTEQUALS EVEN",
 /*  99 */ "expr ::= expr IS EVEN",
 /* 100 */ "expr ::= expr NOTEQUALS ODD",
 /* 101 */ "expr ::= expr IS ODD",
 /* 102 */ "expr ::= expr NOTEQUALS NUMERIC",
 /* 103 */ "expr ::= expr IS NUMERIC",
 /* 104 */ "expr ::= expr NOTEQUALS SCALAR",
 /* 105 */ "expr ::= expr IS SCALAR",
 /* 106 */ "expr ::= expr NOTEQUALS ITERABLE",
 /* 107 */ "expr ::= expr IS ITERABLE",
 /* 108 */ "expr ::= expr IS expr",
 /* 109 */ "expr ::= expr NOTEQUALS expr",
 /* 110 */ "expr ::= expr IDENTICAL expr",
 /* 111 */ "expr ::= expr NOTIDENTICAL expr",
 /* 112 */ "expr ::= expr LESS expr",
 /* 113 */ "expr ::= expr GREATER expr",
 /* 114 */ "expr ::= expr GREATEREQUAL expr",
 /* 115 */ "expr ::= expr LESSEQUAL expr",
 /* 116 */ "expr ::= expr DOT expr",
 /* 117 */ "expr ::= expr IN expr",
 /* 118 */ "expr ::= expr NOT IN expr",
 /* 119 */ "expr ::= NOT expr",
 /* 120 */ "expr ::= expr INCR",
 /* 121 */ "expr ::= expr DECR",
 /* 122 */ "expr ::= PARENTHESES_OPEN expr PARENTHESES_CLOSE",
 /* 123 */ "expr ::= SBRACKET_OPEN SBRACKET_CLOSE",
 /* 124 */ "expr ::= SBRACKET_OPEN array_list SBRACKET_CLOSE",
 /* 125 */ "expr ::= CBRACKET_OPEN CBRACKET_CLOSE",
 /* 126 */ "expr ::= CBRACKET_OPEN array_list CBRACKET_CLOSE",
 /* 127 */ "expr ::= expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /* 128 */ "expr ::= expr QUESTION expr COLON expr",
 /* 129 */ "expr ::= expr SBRACKET_OPEN COLON slice_offset SBRACKET_CLOSE",
 /* 130 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON SBRACKET_CLOSE",
 /* 131 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON slice_offset SBRACKET_CLOSE",
 /* 132 */ "slice_offset ::= INTEGER",
 /* 133 */ "slice_offset ::= IDENTIFIER",
 /* 134 */ "array_list ::= array_list COMMA array_item",
 /* 135 */ "array_list ::= array_item",
 /* 136 */ "array_item ::= STRING COLON expr",
 /* 137 */ "array_item ::= expr",
 /* 138 */ "expr ::= function_call",
 /* 139 */ "function_call ::= expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE",
 /* 140 */ "function_call ::= expr PARENTHESES_OPEN PARENTHESES_CLOSE",
 /* 141 */ "argument_list ::= argument_list COMMA argument_item",
 /* 142 */ "argument_list ::= argument_item",
 /* 143 */ "argument_item ::= expr",
 /* 144 */ "argument_item ::= STRING COLON expr",
 /* 145 */ "expr ::= IDENTIFIER",
 /* 146 */ "expr ::= INTEGER",
 /* 147 */ "expr ::= STRING",
 /* 148 */ "expr ::= DOUBLE",
 /* 149 */ "expr ::= NULL",
 /* 150 */ "expr ::= FALSE",
 /* 151 */ "expr ::= TRUE",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *phvolt_TokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to phvolt_ and phvolt_Free.
*/
void *phvolt_Alloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
#line 155 "parser.php5.lemon"
{
	if ((yypminor->yy0)) {
		if ((yypminor->yy0)->free_flag) {
			efree((yypminor->yy0)->token);
		}
		efree((yypminor->yy0));
	}
}
#line 1133 "parser.php5.c"
      break;
    case 88:
    case 89:
    case 90:
    case 91:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 114:
    case 115:
    case 117:
    case 118:
    case 119:
    case 120:
    case 121:
    case 122:
    case 123:
#line 172 "parser.php5.lemon"
{
#if PHP_VERSION_ID < 70000
	zval_ptr_dtor(&(yypminor->yy40));
#endif
}
#line 1175 "parser.php5.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from phvolt_Alloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void phvolt_Free(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     phvolt_ARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 86, 1 },
  { 87, 1 },
  { 88, 2 },
  { 88, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 89, 1 },
  { 91, 8 },
  { 91, 7 },
  { 91, 12 },
  { 91, 11 },
  { 91, 10 },
  { 92, 4 },
  { 93, 3 },
  { 94, 10 },
  { 94, 12 },
  { 94, 12 },
  { 94, 14 },
  { 95, 4 },
  { 111, 3 },
  { 111, 1 },
  { 112, 3 },
  { 112, 3 },
  { 112, 3 },
  { 112, 3 },
  { 112, 3 },
  { 113, 1 },
  { 113, 4 },
  { 113, 3 },
  { 107, 10 },
  { 107, 11 },
  { 114, 3 },
  { 114, 1 },
  { 115, 1 },
  { 115, 3 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 109, 11 },
  { 109, 9 },
  { 108, 2 },
  { 96, 3 },
  { 97, 8 },
  { 97, 7 },
  { 98, 8 },
  { 98, 9 },
  { 118, 1 },
  { 118, 1 },
  { 104, 7 },
  { 99, 4 },
  { 100, 4 },
  { 100, 6 },
  { 101, 4 },
  { 102, 4 },
  { 103, 8 },
  { 103, 8 },
  { 105, 3 },
  { 106, 3 },
  { 90, 1 },
  { 110, 2 },
  { 110, 2 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 4 },
  { 110, 3 },
  { 110, 4 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 3 },
  { 110, 4 },
  { 110, 2 },
  { 110, 2 },
  { 110, 2 },
  { 110, 3 },
  { 110, 2 },
  { 110, 3 },
  { 110, 2 },
  { 110, 3 },
  { 110, 4 },
  { 110, 5 },
  { 110, 5 },
  { 110, 5 },
  { 110, 6 },
  { 120, 1 },
  { 120, 1 },
  { 119, 3 },
  { 119, 1 },
  { 121, 3 },
  { 121, 1 },
  { 110, 1 },
  { 122, 4 },
  { 122, 3 },
  { 117, 3 },
  { 117, 1 },
  { 123, 1 },
  { 123, 3 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  phvolt_ARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
#line 164 "parser.php5.lemon"
{
	status->ret = yymsp[0].minor.yy40;
}
#line 1544 "parser.php5.c"
        break;
      case 1:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 138:
#line 168 "parser.php5.lemon"
{
	yygotominor.yy40 = yymsp[0].minor.yy40;
}
#line 1572 "parser.php5.c"
        break;
      case 2:
#line 178 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_zval_list(yymsp[-1].minor.yy40, yymsp[0].minor.yy40);
}
#line 1579 "parser.php5.c"
        break;
      case 3:
      case 37:
      case 49:
      case 135:
      case 142:
#line 182 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_zval_list(NULL, yymsp[0].minor.yy40);
}
#line 1590 "parser.php5.c"
        break;
      case 24:
#line 278 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_if_statement(yymsp[-5].minor.yy40, yymsp[-3].minor.yy40, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1603 "parser.php5.c"
        break;
      case 25:
#line 282 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_if_statement(yymsp[-4].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(31,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1616 "parser.php5.c"
        break;
      case 26:
#line 286 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_if_statement(yymsp[-9].minor.yy40, yymsp[-7].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(31,&yymsp[-10].minor);
  yy_destructor(32,&yymsp[-8].minor);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(34,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1632 "parser.php5.c"
        break;
      case 27:
#line 290 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_if_statement(yymsp[-8].minor.yy40, yymsp[-6].minor.yy40, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(31,&yymsp[-9].minor);
  yy_destructor(32,&yymsp[-7].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1648 "parser.php5.c"
        break;
      case 28:
#line 294 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_if_statement(yymsp[-7].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(31,&yymsp[-8].minor);
  yy_destructor(32,&yymsp[-6].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1664 "parser.php5.c"
        break;
      case 29:
#line 304 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_elseif_statement(yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(35,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1674 "parser.php5.c"
        break;
      case 30:
#line 314 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_elsefor_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(36,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1684 "parser.php5.c"
        break;
      case 31:
#line 324 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_for_statement(yymsp[-7].minor.yy0, NULL, yymsp[-5].minor.yy40, NULL, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(37,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1698 "parser.php5.c"
        break;
      case 32:
#line 328 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_for_statement(yymsp[-9].minor.yy0, NULL, yymsp[-7].minor.yy40, yymsp[-5].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1713 "parser.php5.c"
        break;
      case 33:
#line 332 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_for_statement(yymsp[-7].minor.yy0, yymsp[-9].minor.yy0, yymsp[-5].minor.yy40, NULL, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(2,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1728 "parser.php5.c"
        break;
      case 34:
#line 336 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_for_statement(yymsp[-9].minor.yy0, yymsp[-11].minor.yy0, yymsp[-7].minor.yy40, yymsp[-5].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-13].minor);
  yy_destructor(37,&yymsp[-12].minor);
  yy_destructor(2,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1744 "parser.php5.c"
        break;
      case 35:
#line 346 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_statement(yymsp[-1].minor.yy40);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(40,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1754 "parser.php5.c"
        break;
      case 36:
      case 48:
      case 134:
      case 141:
#line 356 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_zval_list(yymsp[-2].minor.yy40, yymsp[0].minor.yy40);
  yy_destructor(2,&yymsp[-1].minor);
}
#line 1765 "parser.php5.c"
        break;
      case 38:
#line 370 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_assignment(yymsp[-2].minor.yy40, PHVOLT_T_ASSIGN, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(41,&yymsp[-1].minor);
}
#line 1773 "parser.php5.c"
        break;
      case 39:
#line 374 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_assignment(yymsp[-2].minor.yy40, PHVOLT_T_ADD_ASSIGN, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(42,&yymsp[-1].minor);
}
#line 1781 "parser.php5.c"
        break;
      case 40:
#line 378 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_assignment(yymsp[-2].minor.yy40, PHVOLT_T_SUB_ASSIGN, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(43,&yymsp[-1].minor);
}
#line 1789 "parser.php5.c"
        break;
      case 41:
#line 382 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_assignment(yymsp[-2].minor.yy40, PHVOLT_T_MUL_ASSIGN, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(44,&yymsp[-1].minor);
}
#line 1797 "parser.php5.c"
        break;
      case 42:
#line 386 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_set_assignment(yymsp[-2].minor.yy40, PHVOLT_T_DIV_ASSIGN, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 1805 "parser.php5.c"
        break;
      case 43:
      case 67:
      case 133:
      case 145:
#line 390 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_IDENTIFIER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1815 "parser.php5.c"
        break;
      case 44:
      case 127:
#line 394 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ARRAYACCESS, yymsp[-3].minor.yy40, yymsp[-1].minor.yy40, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 1825 "parser.php5.c"
        break;
      case 45:
      case 116:
#line 398 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_DOT, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(30,&yymsp[-1].minor);
}
#line 1834 "parser.php5.c"
        break;
      case 46:
#line 408 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_statement(yymsp[-7].minor.yy0, NULL, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(47,&yymsp[-8].minor);
  yy_destructor(29,&yymsp[-6].minor);
  yy_destructor(48,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(49,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1849 "parser.php5.c"
        break;
      case 47:
#line 412 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_statement(yymsp[-8].minor.yy0, yymsp[-6].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(47,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(48,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(49,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1864 "parser.php5.c"
        break;
      case 50:
#line 436 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_parameter(yymsp[0].minor.yy0, NULL, status->scanner_state);
}
#line 1871 "parser.php5.c"
        break;
      case 51:
#line 440 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_parameter(yymsp[-2].minor.yy0, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(41,&yymsp[-1].minor);
}
#line 1879 "parser.php5.c"
        break;
      case 52:
      case 66:
      case 132:
      case 146:
#line 444 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_INTEGER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1889 "parser.php5.c"
        break;
      case 53:
      case 147:
#line 448 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_STRING, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1897 "parser.php5.c"
        break;
      case 54:
      case 148:
#line 452 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_DOUBLE, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1905 "parser.php5.c"
        break;
      case 55:
      case 149:
#line 456 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_NULL, NULL, status->scanner_state);
  yy_destructor(53,&yymsp[0].minor);
}
#line 1914 "parser.php5.c"
        break;
      case 56:
      case 150:
#line 460 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_FALSE, NULL, status->scanner_state);
  yy_destructor(54,&yymsp[0].minor);
}
#line 1923 "parser.php5.c"
        break;
      case 57:
      case 151:
#line 464 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_TRUE, NULL, status->scanner_state);
  yy_destructor(55,&yymsp[0].minor);
}
#line 1932 "parser.php5.c"
        break;
      case 58:
#line 474 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_call_statement(yymsp[-8].minor.yy40, yymsp[-6].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(56,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(48,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1947 "parser.php5.c"
        break;
      case 59:
#line 478 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_macro_call_statement(yymsp[-6].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(56,&yymsp[-7].minor);
  yy_destructor(29,&yymsp[-5].minor);
  yy_destructor(48,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1962 "parser.php5.c"
        break;
      case 60:
#line 488 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_empty_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1971 "parser.php5.c"
        break;
      case 61:
#line 498 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_echo_statement(yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(58,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[0].minor);
}
#line 1980 "parser.php5.c"
        break;
      case 62:
#line 508 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_block_statement(yymsp[-5].minor.yy0, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(60,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1993 "parser.php5.c"
        break;
      case 63:
#line 512 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_block_statement(yymsp[-4].minor.yy0, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(60,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2006 "parser.php5.c"
        break;
      case 64:
#line 522 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_cache_statement(yymsp[-5].minor.yy40, NULL, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(62,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(63,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2019 "parser.php5.c"
        break;
      case 65:
#line 526 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_cache_statement(yymsp[-6].minor.yy40, yymsp[-5].minor.yy40, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(62,&yymsp[-7].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(63,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2032 "parser.php5.c"
        break;
      case 68:
#line 550 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_raw_statement(yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(64,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2045 "parser.php5.c"
        break;
      case 69:
#line 560 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_extends_statement(yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(66,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2055 "parser.php5.c"
        break;
      case 70:
#line 570 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_include_statement(yymsp[-1].minor.yy40, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2065 "parser.php5.c"
        break;
      case 71:
#line 574 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_include_statement(yymsp[-3].minor.yy40, yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(67,&yymsp[-4].minor);
  yy_destructor(68,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2076 "parser.php5.c"
        break;
      case 72:
#line 584 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_do_statement(yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(69,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2086 "parser.php5.c"
        break;
      case 73:
#line 594 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_return_statement(yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(70,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2096 "parser.php5.c"
        break;
      case 74:
#line 604 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_autoescape_statement(0, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(71,&yymsp[-6].minor);
  yy_destructor(54,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(72,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2110 "parser.php5.c"
        break;
      case 75:
#line 608 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_autoescape_statement(1, yymsp[-3].minor.yy40, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(71,&yymsp[-6].minor);
  yy_destructor(55,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(72,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2124 "parser.php5.c"
        break;
      case 76:
#line 618 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_break_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(73,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2134 "parser.php5.c"
        break;
      case 77:
#line 628 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_continue_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(74,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2144 "parser.php5.c"
        break;
      case 78:
#line 638 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_literal_zval(PHVOLT_T_RAW_FRAGMENT, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2151 "parser.php5.c"
        break;
      case 79:
#line 648 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_MINUS, NULL, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2159 "parser.php5.c"
        break;
      case 80:
#line 652 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_PLUS, NULL, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2167 "parser.php5.c"
        break;
      case 81:
#line 656 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_SUB, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2175 "parser.php5.c"
        break;
      case 82:
#line 660 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ADD, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2183 "parser.php5.c"
        break;
      case 83:
#line 664 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_MUL, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2191 "parser.php5.c"
        break;
      case 84:
#line 668 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_POW, yymsp[-3].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-2].minor);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2200 "parser.php5.c"
        break;
      case 85:
#line 672 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_DIV, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2208 "parser.php5.c"
        break;
      case 86:
#line 676 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_MOD, yymsp[-3].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-2].minor);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2217 "parser.php5.c"
        break;
      case 87:
#line 680 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_MOD, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(20,&yymsp[-1].minor);
}
#line 2225 "parser.php5.c"
        break;
      case 88:
#line 684 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_AND, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(7,&yymsp[-1].minor);
}
#line 2233 "parser.php5.c"
        break;
      case 89:
#line 688 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_OR, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2241 "parser.php5.c"
        break;
      case 90:
#line 692 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_CONCAT, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(23,&yymsp[-1].minor);
}
#line 2249 "parser.php5.c"
        break;
      case 91:
#line 696 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_PIPE, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(25,&yymsp[-1].minor);
}
#line 2257 "parser.php5.c"
        break;
      case 92:
#line 700 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_RANGE, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(6,&yymsp[-1].minor);
}
#line 2265 "parser.php5.c"
        break;
      case 93:
#line 704 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_EQUALS, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(10,&yymsp[-1].minor);
}
#line 2273 "parser.php5.c"
        break;
      case 94:
#line 708 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISSET, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(76,&yymsp[0].minor);
}
#line 2282 "parser.php5.c"
        break;
      case 95:
#line 712 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISSET, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(76,&yymsp[0].minor);
}
#line 2291 "parser.php5.c"
        break;
      case 96:
#line 716 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISEMPTY, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(77,&yymsp[0].minor);
}
#line 2300 "parser.php5.c"
        break;
      case 97:
#line 720 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISEMPTY, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(77,&yymsp[0].minor);
}
#line 2309 "parser.php5.c"
        break;
      case 98:
#line 724 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISEVEN, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(78,&yymsp[0].minor);
}
#line 2318 "parser.php5.c"
        break;
      case 99:
#line 728 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISEVEN, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(78,&yymsp[0].minor);
}
#line 2327 "parser.php5.c"
        break;
      case 100:
#line 732 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISODD, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(79,&yymsp[0].minor);
}
#line 2336 "parser.php5.c"
        break;
      case 101:
#line 736 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISODD, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(79,&yymsp[0].minor);
}
#line 2345 "parser.php5.c"
        break;
      case 102:
#line 740 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISNUMERIC, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2354 "parser.php5.c"
        break;
      case 103:
#line 744 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISNUMERIC, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2363 "parser.php5.c"
        break;
      case 104:
#line 748 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISSCALAR, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2372 "parser.php5.c"
        break;
      case 105:
#line 752 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISSCALAR, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2381 "parser.php5.c"
        break;
      case 106:
#line 756 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_ISITERABLE, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2390 "parser.php5.c"
        break;
      case 107:
#line 760 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ISITERABLE, yymsp[-2].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2399 "parser.php5.c"
        break;
      case 108:
#line 764 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_IS, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
}
#line 2407 "parser.php5.c"
        break;
      case 109:
#line 768 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOTEQUALS, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
}
#line 2415 "parser.php5.c"
        break;
      case 110:
#line 772 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_IDENTICAL, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(16,&yymsp[-1].minor);
}
#line 2423 "parser.php5.c"
        break;
      case 111:
#line 776 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOTIDENTICAL, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(17,&yymsp[-1].minor);
}
#line 2431 "parser.php5.c"
        break;
      case 112:
#line 780 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_LESS, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(12,&yymsp[-1].minor);
}
#line 2439 "parser.php5.c"
        break;
      case 113:
#line 784 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_GREATER, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(13,&yymsp[-1].minor);
}
#line 2447 "parser.php5.c"
        break;
      case 114:
#line 788 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_GREATEREQUAL, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(14,&yymsp[-1].minor);
}
#line 2455 "parser.php5.c"
        break;
      case 115:
#line 792 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_LESSEQUAL, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(15,&yymsp[-1].minor);
}
#line 2463 "parser.php5.c"
        break;
      case 117:
#line 800 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_IN, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2471 "parser.php5.c"
        break;
      case 118:
#line 804 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT_IN, yymsp[-3].minor.yy40, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-2].minor);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2480 "parser.php5.c"
        break;
      case 119:
#line 808 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_NOT, NULL, yymsp[0].minor.yy40, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-1].minor);
}
#line 2488 "parser.php5.c"
        break;
      case 120:
#line 812 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_INCR, yymsp[-1].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(27,&yymsp[0].minor);
}
#line 2496 "parser.php5.c"
        break;
      case 121:
#line 816 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_DECR, yymsp[-1].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(28,&yymsp[0].minor);
}
#line 2504 "parser.php5.c"
        break;
      case 122:
#line 820 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ENCLOSED, yymsp[-1].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
}
#line 2513 "parser.php5.c"
        break;
      case 123:
#line 824 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-1].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 2522 "parser.php5.c"
        break;
      case 124:
#line 828 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ARRAY, yymsp[-1].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 2531 "parser.php5.c"
        break;
      case 125:
#line 832 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(83,&yymsp[-1].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2540 "parser.php5.c"
        break;
      case 126:
#line 836 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_ARRAY, yymsp[-1].minor.yy40, NULL, NULL, status->scanner_state);
  yy_destructor(83,&yymsp[-2].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2549 "parser.php5.c"
        break;
      case 128:
#line 844 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_expr(PHVOLT_T_TERNARY, yymsp[-2].minor.yy40, yymsp[0].minor.yy40, yymsp[-4].minor.yy40, status->scanner_state);
  yy_destructor(4,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2558 "parser.php5.c"
        break;
      case 129:
#line 848 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_slice(yymsp[-4].minor.yy40, NULL, yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 2568 "parser.php5.c"
        break;
      case 130:
#line 852 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_slice(yymsp[-4].minor.yy40, yymsp[-2].minor.yy40, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 2578 "parser.php5.c"
        break;
      case 131:
#line 856 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_slice(yymsp[-5].minor.yy40, yymsp[-3].minor.yy40, yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(24,&yymsp[-4].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(46,&yymsp[0].minor);
}
#line 2588 "parser.php5.c"
        break;
      case 136:
      case 144:
#line 894 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_named_item(yymsp[-2].minor.yy0, yymsp[0].minor.yy40, status->scanner_state);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2597 "parser.php5.c"
        break;
      case 137:
      case 143:
#line 898 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_named_item(NULL, yymsp[0].minor.yy40, status->scanner_state);
}
#line 2605 "parser.php5.c"
        break;
      case 139:
#line 912 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_func_call(yymsp[-3].minor.yy40, yymsp[-1].minor.yy40, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(48,&yymsp[0].minor);
}
#line 2614 "parser.php5.c"
        break;
      case 140:
#line 916 "parser.php5.lemon"
{
	yygotominor.yy40 = phvolt_ret_func_call(yymsp[-2].minor.yy40, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-1].minor);
  yy_destructor(48,&yymsp[0].minor);
}
#line 2623 "parser.php5.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  phvolt_ARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 46 "parser.php5.lemon"

	{

		smart_str error_str = {0};

		char *token_name = NULL;
		const phvolt_token_names *tokens = phvolt_tokens;
		int token_len = 0;
		int active_token = status->scanner_state->active_token;

		if (status->scanner_state->start_length) {

			if (active_token) {

				do {
					if (tokens->code == active_token) {
						token_name = tokens->name;
						token_len = tokens->len;
						break;
					}
					++tokens;
				} while (tokens[0].code != 0);

			}

			smart_str_appendl(&error_str, "Syntax error, unexpected token ", sizeof("Syntax error, unexpected token ") - 1);
			if (!token_name) {
				smart_str_appendl(&error_str, "UNKNOWN", sizeof("UNKNOWN") - 1);
			} else {
				smart_str_appendl(&error_str, token_name, token_len);
			}

			if (status->token->value) {
				smart_str_appendc(&error_str, '(');
				smart_str_appendl(&error_str, status->token->value, status->token->len);
				smart_str_appendc(&error_str, ')');
			}

			smart_str_appendl(&error_str, " in ", sizeof(" in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));
			smart_str_appendl(&error_str, " on line ", sizeof(" on line ") - 1);

			{
				char stmp[MAX_LENGTH_OF_LONG + 1];
				int str_len;
				str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->active_line);
				smart_str_appendl(&error_str, stmp, str_len);
			}

		} else {

			smart_str_appendl(&error_str, "Syntax error, unexpected EOF in ", sizeof("Syntax error, unexpected EOF in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));

			/* Report unclosed 'if' blocks */
			if ((status->scanner_state->if_level + status->scanner_state->old_if_level) > 0) {
				if ((status->scanner_state->if_level + status->scanner_state->old_if_level) == 1) {
					smart_str_appendl(&error_str, ", there is one 'if' block without close", sizeof(", there is one 'if' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->if_level + status->scanner_state->old_if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'if' blocks without close", sizeof(" 'if' blocks without close") - 1);
				}
			}

			/* Report unclosed 'for' blocks */
			if (status->scanner_state->for_level > 0) {
				if (status->scanner_state->for_level == 1) {
					smart_str_appendl(&error_str, ", there is one 'for' block without close", sizeof(", there is one 'for' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'for' blocks without close", sizeof(" 'for' blocks without close") - 1);
				}
			}
		}

		smart_str_0(&error_str);

#if PHP_VERSION_ID < 70000
		if (error_str.len) {
			status->syntax_error = error_str.c;
			status->syntax_error_len = error_str.len;
		} else {
			status->syntax_error = NULL;
		}
#else
		if (error_str.s) {
			status->syntax_error = estrndup(ZSTR_VAL(error_str.s), ZSTR_LEN(error_str.s));
			status->syntax_error_len = ZSTR_LEN(error_str.s);
		} else {
			status->syntax_error = NULL;
		}
#endif
	}

	status->status = PHVOLT_PARSING_FAILED;

#line 2774 "parser.php5.c"
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "phvolt_Alloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  phvolt_TOKENTYPE yyminor       /* The value for the token */
  phvolt_ARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  phvolt_ARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
