/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSInteger
extends COSNumber {
    private long value;

    public COSInteger(long val) {
        this.value = val;
    }

    public COSInteger(int val) {
        this((long)val);
    }

    public COSInteger(String val) throws IOException {
        try {
            this.value = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: value is not an integer type actual='" + val + "'");
        }
    }

    public boolean equals(Object o) {
        return o instanceof COSInteger && ((COSInteger)o).intValue() == this.intValue();
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public String toString() {
        return "COSInt{" + this.value + "}";
    }

    public void setValue(long newValue) {
        this.value = newValue;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromInt(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(String.valueOf(this.value).getBytes());
    }
}

