#ifndef INCLUDED_CALC_SPATIAL
#define INCLUDED_CALC_SPATIAL

#ifndef INCLUDED_CALC_ISPATIAL
#include "calc_ispatial.h"
#define INCLUDED_CALC_ISPATIAL
#endif

namespace calc {


//! holds data for a spatial value
/*! mutable fields are meant for "late" reading of data
 *  through loadExternal()
 */
class Spatial : public ISpatial {
private:
  static size_t d_maxBPC;
  static size_t d_currentBPC;
  void          countBPC(VS vs) const;


  /*! linear array with data (nrCols*nrRows) values
   *  The union is here for debug purposes
   */
 typedef UINT1 UINT1_A16 __attribute__ ((aligned (16)));
 typedef  INT4  INT4_A16 __attribute__ ((aligned (16)));
  union {
   REAL4     *d_vals __attribute__ ((aligned (16)));
//typedef float VE __attribute__ ((aligned (16),mode(V4SF)));
   UINT1_A16 *d_val1 __attribute__ ((aligned (16)));
    INT4_A16 *d_val4 __attribute__ ((aligned (16)));

   void *d_val __attribute__ ((aligned (16)));
  };

  void fill(const void *src);

  //! ptr to buffer that can hold the data, 0 if not allocated
  void *valuePtr() const;

  void    allocate();
  size_t  valLen() const;

  //! not implemented
  Spatial& operator=           (const Spatial& rhs);

public:
  Spatial(VS vs, CRIndex cri, size_t nrValues);

  Spatial(const Spatial& rhs);

  template<typename CR>
   Spatial(VS vs, const CR* data, size_t n):
     ISpatial(vs,crIndex<CR>(),n)
   {
     allocate();
     fill(data);
   }

  virtual ~Spatial();

  //----------------------------------------------------------------------------
  // MANIPULATORS
  //----------------------------------------------------------------------------

  void        setCell(const double& value, size_t i);
  void       *dest();

  //----------------------------------------------------------------------------
  // ACCESSORS
  //----------------------------------------------------------------------------

  const void*    src                  ()         const;
  bool           getCell              (double& value, size_t i) const;

  Spatial*       createClone          () const;
  void           analyzeBoolean       (bool& noneAreTrue,bool& noneAreFalse) const;
  Spatial*       findMVinMask         (const Field* mask) const;

  static size_t  maxBPC();
  static size_t  currentBPC();

};

}

#endif
