#ifndef INCLUDED_STDDEFX
#include "stddefx.h"
#define INCLUDED_STDDEFX
#endif

#ifndef INCLUDED_CALC_SIMDMATHTEST
#include "calc_simdmathtest.h"
#define INCLUDED_CALC_SIMDMATHTEST
#endif

// Library headers.
#ifndef INCLUDED_TEST
#include "Test.h"
#define INCLUDED_TEST
#endif

#ifndef INCLUDED_TESTCALLER
#include "TestCaller.h"
#define INCLUDED_TESTCALLER
#endif

#ifndef INCLUDED_TESTSUITE
#include "TestSuite.h"
#define INCLUDED_TESTSUITE
#endif

// PCRaster library headers.
#ifndef INCLUDED_COM_CSFCELL
#include "com_csfcell.h"
#define INCLUDED_COM_CSFCELL
#endif

// Module headers.
#ifndef INCLUDED_CALC_SIMDMATH
#include "calc_simdmath.h"
#define INCLUDED_CALC_SIMDMATH
#endif


/*!
  \file
  This file contains the implementation of the SIMDMathTest class.
*/

// NOTE use string failureExpected in files expected to fail, see style guide

//------------------------------------------------------------------------------
// DEFINITION OF STATIC SIMDMATH MEMBERS
//------------------------------------------------------------------------------

//! suite
Test *calc::SIMDMathTest::suite()
{
  TestSuite *suite = new TestSuite(__FILE__);

  suite->ADD_TEST(calc::SIMDMathTest, testLoop);
  suite->ADD_TEST(calc::SIMDMathTest, testMVPropagation);
  suite->ADD_TEST(calc::SIMDMathTest, testDomainErrors);

  return suite;
}



//------------------------------------------------------------------------------
// DEFINITION OF SIMDMATH MEMBERS
//------------------------------------------------------------------------------

//! ctor
calc::SIMDMathTest::SIMDMathTest(std::string const& name)

 : TestCase(name)

{
}



//! setUp
void calc::SIMDMathTest::setUp()
{
}



//! tearDown
void calc::SIMDMathTest::tearDown()
{
}

namespace calc {
namespace detail {
  struct TestVector {
    REAL4 *data;
    TestVector(size_t n, float v) {
      data = new float[n];
      for(size_t i=0;i<n;++i)
        data[i]=v;
     }
     ~TestVector() {
       delete data;
     }
    REAL4 &operator[](size_t i) {
      return data[i];
    }
  };
}
}

void calc::SIMDMathTest::testLoop()
{
  // 7 : uneven for both multi and single
  // TODO segfautls if this are vectors
  float  r[7] = { 2,2,2,2,2,2,2 };
  float  l[7] = { 3,3,3,3,3,3,3 };

  calc::SIMDInstr<Addps,float>::assTo1stArg(l,r,7);

  cu_assert(l[0]==5);
  cu_assert(l[3]==5);
  cu_assert(l[6]==5);
}

void calc::SIMDMathTest::testMVPropagation()
{
  //REAL4  r[7] = { 2,2,2,2,2,2,2 };
  //REAL4  l[7] = { 3,3,3,3,3,3,3 };
  detail::TestVector r(7,2);
  detail::TestVector l(7,3);

  // IA32SPEC: Table E-1
  // if some op is a QNan -> the same Qnan out
  com::setMV(r[1]);
  com::setMV(l[2]);
  // tricky optimizations can make this
  // happen, that's why TestVector is used
  cu_assert(com::isMV(r[1]));
  cu_assert(com::isMV(l[2]));

  calc::SIMDInstr<Mulps,float>::assTo1stArg(l.data,r.data,7);

  cu_assert(com::isMV(l[1]));
  cu_assert(com::isMV(l[2]));

  cu_assert(l[0]==6);
  cu_assert(l[3]==6);
  cu_assert(l[6]==6);
}

#ifndef INCLUDED_IOSTREAM
#include <iostream>
#define INCLUDED_IOSTREAM
#endif

void calc::SIMDMathTest::testDomainErrors()
{
  detail::TestVector r(7,2);
  detail::TestVector l(7,6);



  com::setMV(r[1]);
  r[2]=0;

  calc::SIMDInstr<Divps,float>::assTo1stArg(l.data,r.data,7);

  cu_assert(com::isMV(l[1]));
  //std::cout << "l2 " << l[2] << std::endl;
/* 
  cu_assert(isinf(l[2]));
  cu_assert(isnan(l[2]));
 */
//  cu_assert(l[2]));

  cu_assert(l[0]==3);
  cu_assert(l[3]==3);
  cu_assert(l[6]==3);
}
