#ifndef MEDIA_H
#define MEDIA_H

#include <chrono>
#include <optional>
#include <string>
#include <vector>
#include <boost/json.hpp>
#include "format.h"
#include "mediatype.h"
#include "subtitlelanguage.h"
#include "timeframe.h"
#include "videocodec.h"

namespace Nickvision::TubeConverter::Shared::Models
{
    /**
     * @brief A model of a downloadable yt-dlp media.
     */
    class Media
    {
    public:
        /**
         * @brief Constructs a Media from a yt-dlp json object.
         * @param info The json object to construct the Media from
         * @param includeMediaIdInTitle Whether or not to include the media id in the title
         * @param includeAutoGeneratedSubtitles Whether or not to include auto generated subtitles
         * @param preferredVideoCodec The preferred video codec
         */
        Media(boost::json::object info, bool includeMediaIdInTitle, bool includeAutoGeneratedSubtitles, VideoCodec preferredVideoCodec);
        /**
         * @brief Gets the URL of the media.
         * @return The URL of the media
         */
        const std::string& getUrl() const;
        /**
         * @brief Gets the title of the media.
         * @return The title of the media
         */
        const std::string& getTitle() const;
        /**
         * @brief Gets the type of the media.
         * @return The type of the media
         */
        MediaType getType() const;
        /**
         * @brief Gets the time frame of the media.
         * @return The time frame of the media
         */
        const TimeFrame& getTimeFrame() const;
        /**
         * @brief Gets the formats of the media.
         * @return The formats of the media
         */
        const std::vector<Format>& getFormats() const;
        /**
         * @brief Gets the subtitles of the media.
         * @return The subtitles of the media
         */
        const std::vector<SubtitleLanguage>& getSubtitles() const;

    private:
        std::string m_url;
        std::string m_title;
        MediaType m_type;
        TimeFrame m_timeFrame;
        std::vector<Format> m_formats;
        std::vector<SubtitleLanguage> m_subtitles;
    };
}

#endif //MEDIA_H