#include "models/previousdownloadoptions.h"
#include <libnick/filesystem/userdirectories.h>

using namespace Nickvision::App;
using namespace Nickvision::Filesystem;

namespace Nickvision::TubeConverter::Shared::Models
{
    PreviousDownloadOptions::PreviousDownloadOptions(const std::string& key, const std::string& appName)
        : DataFileBase{ key, appName }
    {
        
    }

    std::filesystem::path PreviousDownloadOptions::getSaveFolder() const
    {
        std::filesystem::path path{ m_json["SaveFolder"].is_string() ? m_json["SaveFolder"].as_string().c_str() : UserDirectories::get(UserDirectory::Downloads).string() };
        if(std::filesystem::exists(path))
        {
            return path;
        }
        return UserDirectories::get(UserDirectory::Downloads);
    }

    void PreviousDownloadOptions::setSaveFolder(const std::filesystem::path& previousSaveFolder)
    {
        if(std::filesystem::exists(previousSaveFolder))
        {
            m_json["SaveFolder"] = previousSaveFolder.string();
        }
        else
        {
            m_json["SaveFolder"] = UserDirectories::get(UserDirectory::Downloads).string();
        }
    }

    MediaFileType PreviousDownloadOptions::getFileType() const
    {
        return { m_json["FileType"].is_int64() ? static_cast<MediaFileType::MediaFileTypeValue>(m_json["FileType"].as_int64()) : MediaFileType::MP4 };
    }

    void PreviousDownloadOptions::setFileType(const MediaFileType& previousMediaFileType)
    {
        m_json["FileType"] = static_cast<int>(previousMediaFileType);
    }
    
    bool PreviousDownloadOptions::getSplitChapters() const
    {
        return m_json["SplitChapters"].is_bool() ? m_json["SplitChapters"].as_bool() : false;
    }

    void PreviousDownloadOptions::setSplitChapters(bool splitChapters)
    {
        m_json["SplitChapters"] = splitChapters;
    }

    bool PreviousDownloadOptions::getLimitSpeed() const
    {
        return m_json["LimitSpeed"].is_bool() ? m_json["LimitSpeed"].as_bool() : false;
    }

    void PreviousDownloadOptions::setLimitSpeed(bool limitSpeed)
    {
        m_json["LimitSpeed"] = limitSpeed;
    }

    bool PreviousDownloadOptions::getNumberTitles() const
    {
        return m_json["NumberTitles"].is_bool() ? m_json["NumberTitles"].as_bool() : false;
    }

    void PreviousDownloadOptions::setNumberTitles(bool numberTitles)
    {
        m_json["NumberTitles"] = numberTitles;
    }

    std::vector<SubtitleLanguage> PreviousDownloadOptions::getSubtitleLanguages() const
    {
        std::vector<SubtitleLanguage> languages;
        if(m_json.contains("SubtitleLanguages") && m_json["SubtitleLanguages"].is_array())
        {
            for(const boost::json::value& language : m_json["SubtitleLanguages"].as_array())
            {
                if(language.is_object())
                {
                    boost::json::object obj = language.as_object();
                    languages.push_back({ obj["Language"].is_string() ? obj["Language"].as_string().c_str() : "", obj["AutoGenerated"].is_bool() ? obj["AutoGenerated"].as_bool() : false });
                }
            }
        }
        return languages;
    }

    void PreviousDownloadOptions::setSubtitleLanguages(const std::vector<SubtitleLanguage>& previousSubtitleLanguages)
    {
        boost::json::array languages;
        for(const SubtitleLanguage& language : previousSubtitleLanguages)
        {
            boost::json::object obj;
            obj["Language"] = language.getLanguage();
            obj["AutoGenerated"] = language.isAutoGenerated();
            languages.push_back(obj);
        }
        m_json["SubtitleLanguages"] = languages;
    }
}