/*F***************************************************************************
 * This file is part of openSMILE.
 * 
 * Copyright (c) audEERING GmbH. All rights reserved.
 * See the file COPYING for details on license terms.
 ***************************************************************************E*/


/*  openSMILE component:

Component to compute chroma features from a semi-tone spectrum. 

This component is based on original code from Moritz Dausinger (wave2chroma). 
The openSMILE chroma component was implemented by Christoph Kozielski.

*/


#ifndef __CCHROMA_HPP
#define __CCHROMA_HPP

#include <core/smileCommon.hpp>
#include <core/vectorProcessor.hpp>

#define BUILD_COMPONENT_Chroma
#define COMPONENT_DESCRIPTION_CCHROMA "This component computes CHROMA features from a semi-tone scaled spectrum generated by the 'cTonespec' component."
#define COMPONENT_NAME_CCHROMA "cChroma"

class cChroma : public cVectorProcessor {
  private:
	  FLOAT_DMEM silThresh;
    int octaveSize;
    int nOctaves;

  protected:
    SMILECOMPONENT_STATIC_DECL_PR

    virtual void myFetchConfig() override;
    //virtual int myConfigureInstance() override;
    //virtual int myFinaliseInstance() override;
    //virtual eTickResult myTick(long long t) override;
	

    //virtual void configureField(int idxi, long __N, long nOut) override;
    virtual int setupNamesForField(int i, const char*name, long nEl) override;
    virtual int processVector(const FLOAT_DMEM *src, FLOAT_DMEM *dst, long Nsrc, long Ndst, int idxi) override;

  public:
    SMILECOMPONENT_STATIC_DECL
    
    cChroma(const char *_name);

    virtual ~cChroma();
};




#endif // __CCHROMA_HPP
