// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_H_
#define V8_ROOTS_STATIC_ROOTS_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/objects/instance-type.h"
#include "src/roots/roots.h"

// Disabling Wasm or Intl invalidates the contents of static-roots.h.
// TODO(olivf): To support static roots for multiple build configurations we
//              will need to generate target specific versions of this file.
static_assert(V8_ENABLE_WEBASSEMBLY);
static_assert(V8_INTL_SUPPORT);

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kMetaMap = 0x61;
  static constexpr Tagged_t kFixedArrayMap = 0x89;
  static constexpr Tagged_t kWeakFixedArrayMap = 0xb1;
  static constexpr Tagged_t kWeakArrayListMap = 0xd9;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x101;
  static constexpr Tagged_t kDescriptorArrayMap = 0x129;
  static constexpr Tagged_t kUndefinedMap = 0x151;
  static constexpr Tagged_t kNullMap = 0x179;
  static constexpr Tagged_t kTheHoleMap = 0x1a1;
  static constexpr Tagged_t kCallSiteInfoMap = 0x1c9;
  static constexpr Tagged_t kEnumCacheMap = 0x1f1;
  static constexpr Tagged_t kEmptyFixedArray = 0x219;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x221;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x229;
  static constexpr Tagged_t kNullValue = 0x235;
  static constexpr Tagged_t kUndefinedValue = 0x251;
  static constexpr Tagged_t kTheHoleValue = 0x26d;
  static constexpr Tagged_t kEmptyEnumCache = 0x289;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x295;
  static constexpr Tagged_t kScopeInfoMap = 0x2a5;
  static constexpr Tagged_t kModuleInfoMap = 0x2cd;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x2f5;
  static constexpr Tagged_t kFeedbackVectorMap = 0x31d;
  static constexpr Tagged_t kHeapNumberMap = 0x345;
  static constexpr Tagged_t kForeignMap = 0x36d;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x395;
  static constexpr Tagged_t kBooleanMap = 0x3bd;
  static constexpr Tagged_t kUninitializedMap = 0x3e5;
  static constexpr Tagged_t kArgumentsMarkerMap = 0x40d;
  static constexpr Tagged_t kExceptionMap = 0x435;
  static constexpr Tagged_t kTerminationExceptionMap = 0x45d;
  static constexpr Tagged_t kOptimizedOutMap = 0x485;
  static constexpr Tagged_t kStaleRegisterMap = 0x4ad;
  static constexpr Tagged_t kSelfReferenceMarkerMap = 0x4d5;
  static constexpr Tagged_t kBasicBlockCountersMarkerMap = 0x4fd;
  static constexpr Tagged_t kBigIntMap = 0x525;
  static constexpr Tagged_t kSymbolMap = 0x54d;
  static constexpr Tagged_t kStringMap = 0x575;
  static constexpr Tagged_t kOneByteStringMap = 0x59d;
  static constexpr Tagged_t kConsStringMap = 0x5c5;
  static constexpr Tagged_t kConsOneByteStringMap = 0x5ed;
  static constexpr Tagged_t kSlicedStringMap = 0x615;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x63d;
  static constexpr Tagged_t kExternalStringMap = 0x665;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x68d;
  static constexpr Tagged_t kUncachedExternalStringMap = 0x6b5;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x6dd;
  static constexpr Tagged_t kSharedExternalStringMap = 0x705;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x72d;
  static constexpr Tagged_t kSharedUncachedExternalStringMap = 0x755;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x77d;
  static constexpr Tagged_t kExternalInternalizedStringMap = 0x7a5;
  static constexpr Tagged_t kExternalOneByteInternalizedStringMap = 0x7cd;
  static constexpr Tagged_t kUncachedExternalInternalizedStringMap = 0x7f5;
  static constexpr Tagged_t kUncachedExternalOneByteInternalizedStringMap =
      0x81d;
  static constexpr Tagged_t kInternalizedStringMap = 0x845;
  static constexpr Tagged_t kOneByteInternalizedStringMap = 0x86d;
  static constexpr Tagged_t kThinStringMap = 0x895;
  static constexpr Tagged_t kSharedStringMap = 0x8bd;
  static constexpr Tagged_t kSharedOneByteStringMap = 0x8e5;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x90d;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x935;
  static constexpr Tagged_t kByteArrayMap = 0x95d;
  static constexpr Tagged_t kBytecodeArrayMap = 0x985;
  static constexpr Tagged_t kFreeSpaceMap = 0x9ad;
  static constexpr Tagged_t kPropertyArrayMap = 0x9d5;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0x9fd;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0xa25;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0xa4d;
  static constexpr Tagged_t kInstructionStreamMap = 0xa75;
  static constexpr Tagged_t kCellMap = 0xa9d;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xac5;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xacd;
  static constexpr Tagged_t kOnePointerFillerMap = 0xaf5;
  static constexpr Tagged_t kTwoPointerFillerMap = 0xb1d;
  static constexpr Tagged_t kNoClosuresCellMap = 0xb45;
  static constexpr Tagged_t kOneClosureCellMap = 0xb6d;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb95;
  static constexpr Tagged_t kTransitionArrayMap = 0xbbd;
  static constexpr Tagged_t kHashTableMap = 0xbe5;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xc0d;
  static constexpr Tagged_t kNameDictionaryMap = 0xc35;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xc5d;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xc85;
  static constexpr Tagged_t kNumberDictionaryMap = 0xcad;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xcd5;
  static constexpr Tagged_t kArrayListMap = 0xcfd;
  static constexpr Tagged_t kAccessorInfoMap = 0xd25;
  static constexpr Tagged_t kPreparseDataMap = 0xd4d;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xd75;
  static constexpr Tagged_t kCodeMap = 0xd9d;
  static constexpr Tagged_t kTrueValue = 0xdc5;
  static constexpr Tagged_t kFalseValue = 0xde1;
  static constexpr Tagged_t kHashSeed = 0xdfd;
  static constexpr Tagged_t kempty_string = 0xe0d;
  static constexpr Tagged_t klength_string = 0xe19;
  static constexpr Tagged_t kprototype_string = 0xe2d;
  static constexpr Tagged_t kname_string = 0xe45;
  static constexpr Tagged_t kenumerable_string = 0xe55;
  static constexpr Tagged_t kconfigurable_string = 0xe6d;
  static constexpr Tagged_t kvalue_string = 0xe85;
  static constexpr Tagged_t kwritable_string = 0xe99;
  static constexpr Tagged_t knot_mapped_symbol = 0xead;
  static constexpr Tagged_t kuninitialized_symbol = 0xebd;
  static constexpr Tagged_t kmegamorphic_symbol = 0xecd;
  static constexpr Tagged_t kelements_transition_symbol = 0xedd;
  static constexpr Tagged_t kmega_dom_symbol = 0xeed;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xefd;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xf29;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0xf4d;
  static constexpr Tagged_t kEmptyByteArray = 0xf6d;
  static constexpr Tagged_t kEmptyScopeInfo = 0xf75;
  static constexpr Tagged_t kEmptyPropertyArray = 0xf85;
  static constexpr Tagged_t kMinusZeroValue = 0xf8d;
  static constexpr Tagged_t kNanValue = 0xf99;
  static constexpr Tagged_t kHoleNanValue = 0xfa5;
  static constexpr Tagged_t kInfinityValue = 0xfb1;
  static constexpr Tagged_t kMinusInfinityValue = 0xfbd;
  static constexpr Tagged_t kMaxSafeInteger = 0xfc9;
  static constexpr Tagged_t kMaxUInt32 = 0xfd5;
  static constexpr Tagged_t kSmiMinValue = 0xfe1;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xfed;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xff9;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0x1021;
  static constexpr Tagged_t kCallableTaskMap = 0x1049;
  static constexpr Tagged_t kCallbackTaskMap = 0x1071;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0x1099;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x10c1;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x10e9;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x1111;
  static constexpr Tagged_t kAccessorPairMap = 0x1139;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x1161;
  static constexpr Tagged_t kAllocationMementoMap = 0x1189;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x11b1;
  static constexpr Tagged_t kAsmWasmDataMap = 0x11d9;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x1201;
  static constexpr Tagged_t kBreakPointMap = 0x1229;
  static constexpr Tagged_t kBreakPointInfoMap = 0x1251;
  static constexpr Tagged_t kClassPositionsMap = 0x1279;
  static constexpr Tagged_t kDebugInfoMap = 0x12a1;
  static constexpr Tagged_t kErrorStackDataMap = 0x12c9;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x12f1;
  static constexpr Tagged_t kInterceptorInfoMap = 0x1319;
  static constexpr Tagged_t kInterpreterDataMap = 0x1341;
  static constexpr Tagged_t kModuleRequestMap = 0x1369;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x1391;
  static constexpr Tagged_t kPromiseOnStackMap = 0x13b9;
  static constexpr Tagged_t kPromiseReactionMap = 0x13e1;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x1409;
  static constexpr Tagged_t kPrototypeInfoMap = 0x1431;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x1459;
  static constexpr Tagged_t kScriptMap = 0x1481;
  static constexpr Tagged_t kScriptOrModuleMap = 0x14a9;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x14d1;
  static constexpr Tagged_t kStackFrameInfoMap = 0x14f9;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x1521;
  static constexpr Tagged_t kTuple2Map = 0x1549;
  static constexpr Tagged_t kWasmExceptionTagMap = 0x1571;
  static constexpr Tagged_t kWasmIndirectFunctionTableMap = 0x1599;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x15c1;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x15e9;
  static constexpr Tagged_t kLoadHandler1Map = 0x1611;
  static constexpr Tagged_t kLoadHandler2Map = 0x1639;
  static constexpr Tagged_t kLoadHandler3Map = 0x1661;
  static constexpr Tagged_t kStoreHandler0Map = 0x1689;
  static constexpr Tagged_t kStoreHandler1Map = 0x16b1;
  static constexpr Tagged_t kStoreHandler2Map = 0x16d9;
  static constexpr Tagged_t kStoreHandler3Map = 0x1701;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x1729;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x1751;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x1779;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x17a1;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x17c9;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x17f1;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x1819;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x1841;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x1869;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x1891;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x18b9;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x18e1;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x1909;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x1931;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x1959;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x1981;
  static constexpr Tagged_t kInternalClassMap = 0x19a9;
  static constexpr Tagged_t kSmiPairMap = 0x19d1;
  static constexpr Tagged_t kSmiBoxMap = 0x19f9;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x1a21;
  static constexpr Tagged_t kExportedSubClassMap = 0x1a49;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x1a71;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x1a99;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1ac1;
  static constexpr Tagged_t kSortStateMap = 0x1ae9;
  static constexpr Tagged_t kWasmStringViewIterMap = 0x1b11;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x1b39;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x1b61;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1b89;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1bb1;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1bd9;
  static constexpr Tagged_t kInternalClassWithSmiElementsMap = 0x1c01;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1c29;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1c51;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1c79;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1ca1;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1cc9;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1cf1;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1d19;
  static constexpr Tagged_t kScriptContextTableMap = 0x1d41;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1d69;
  static constexpr Tagged_t kCoverageInfoMap = 0x1d91;
  static constexpr Tagged_t kSideEffectCallHandlerInfoMap = 0x1db9;
  static constexpr Tagged_t kSideEffectFreeCallHandlerInfoMap = 0x1de1;
  static constexpr Tagged_t kNextCallSideEffectFreeCallHandlerInfoMap = 0x1e09;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1e31;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1e59;
  static constexpr Tagged_t kWasmApiFunctionRefMap = 0x1e81;
  static constexpr Tagged_t kWasmCapiFunctionDataMap = 0x1ea9;
  static constexpr Tagged_t kWasmExportedFunctionDataMap = 0x1ed1;
  static constexpr Tagged_t kWasmInternalFunctionMap = 0x1ef9;
  static constexpr Tagged_t kWasmJSFunctionDataMap = 0x1f21;
  static constexpr Tagged_t kWasmResumeDataMap = 0x1f49;
  static constexpr Tagged_t kWasmTypeInfoMap = 0x1f71;
  static constexpr Tagged_t kWasmContinuationObjectMap = 0x1f99;
  static constexpr Tagged_t kWasmNullMap = 0x1fc1;
  static constexpr Tagged_t kWeakCellMap = 0x1fe9;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x2011;
  static constexpr Tagged_t kEmptyArrayList = 0x2039;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x2045;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x2051;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x205d;
  static constexpr Tagged_t kSingleCharacterStringTable = 0x2065;
  static constexpr Tagged_t kdot_string = 0x274d;
  static constexpr Tagged_t kzero_string = 0x276d;
  static constexpr Tagged_t kone_string = 0x277d;
  static constexpr Tagged_t kadoptText_string = 0x346d;
  static constexpr Tagged_t kapproximatelySign_string = 0x3485;
  static constexpr Tagged_t kbaseName_string = 0x34a5;
  static constexpr Tagged_t kaccounting_string = 0x34b9;
  static constexpr Tagged_t kbreakType_string = 0x34d1;
  static constexpr Tagged_t kcalendars_string = 0x34e9;
  static constexpr Tagged_t kcardinal_string = 0x3501;
  static constexpr Tagged_t kcaseFirst_string = 0x3515;
  static constexpr Tagged_t kceil_string = 0x352d;
  static constexpr Tagged_t kcompare_string = 0x353d;
  static constexpr Tagged_t kcollation_string = 0x3551;
  static constexpr Tagged_t kcollations_string = 0x3569;
  static constexpr Tagged_t kcompact_string = 0x3581;
  static constexpr Tagged_t kcompactDisplay_string = 0x3595;
  static constexpr Tagged_t kcurrency_string = 0x35b1;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x35c5;
  static constexpr Tagged_t kcurrencySign_string = 0x35e1;
  static constexpr Tagged_t kdateStyle_string = 0x35f9;
  static constexpr Tagged_t kdateTimeField_string = 0x3611;
  static constexpr Tagged_t kdayPeriod_string = 0x362d;
  static constexpr Tagged_t kdaysDisplay_string = 0x3645;
  static constexpr Tagged_t kdecimal_string = 0x365d;
  static constexpr Tagged_t kdialect_string = 0x3671;
  static constexpr Tagged_t kdigital_string = 0x3685;
  static constexpr Tagged_t kdirection_string = 0x3699;
  static constexpr Tagged_t kendRange_string = 0x36b1;
  static constexpr Tagged_t kengineering_string = 0x36c5;
  static constexpr Tagged_t kexceptZero_string = 0x36dd;
  static constexpr Tagged_t kexpand_string = 0x36f5;
  static constexpr Tagged_t kexponentInteger_string = 0x3709;
  static constexpr Tagged_t kexponentMinusSign_string = 0x3725;
  static constexpr Tagged_t kexponentSeparator_string = 0x3745;
  static constexpr Tagged_t kfallback_string = 0x3765;
  static constexpr Tagged_t kfirst_string = 0x3779;
  static constexpr Tagged_t kfirstDay_string = 0x378d;
  static constexpr Tagged_t kfloor_string = 0x37a1;
  static constexpr Tagged_t kformat_string = 0x37b5;
  static constexpr Tagged_t kfraction_string = 0x37c9;
  static constexpr Tagged_t kfractionalDigits_string = 0x37dd;
  static constexpr Tagged_t kfractionalSecond_string = 0x37f9;
  static constexpr Tagged_t kfull_string = 0x3815;
  static constexpr Tagged_t kgranularity_string = 0x3825;
  static constexpr Tagged_t kgrapheme_string = 0x383d;
  static constexpr Tagged_t kgroup_string = 0x3851;
  static constexpr Tagged_t kh11_string = 0x3865;
  static constexpr Tagged_t kh12_string = 0x3875;
  static constexpr Tagged_t kh23_string = 0x3885;
  static constexpr Tagged_t kh24_string = 0x3895;
  static constexpr Tagged_t khalfCeil_string = 0x38a5;
  static constexpr Tagged_t khalfEven_string = 0x38b9;
  static constexpr Tagged_t khalfExpand_string = 0x38cd;
  static constexpr Tagged_t khalfFloor_string = 0x38e5;
  static constexpr Tagged_t khalfTrunc_string = 0x38fd;
  static constexpr Tagged_t khour12_string = 0x3915;
  static constexpr Tagged_t khourCycle_string = 0x3929;
  static constexpr Tagged_t khourCycles_string = 0x3941;
  static constexpr Tagged_t khoursDisplay_string = 0x3959;
  static constexpr Tagged_t kideo_string = 0x3971;
  static constexpr Tagged_t kignorePunctuation_string = 0x3981;
  static constexpr Tagged_t kInvalid_Date_string = 0x39a1;
  static constexpr Tagged_t kinteger_string = 0x39b9;
  static constexpr Tagged_t kisWordLike_string = 0x39cd;
  static constexpr Tagged_t kkana_string = 0x39e5;
  static constexpr Tagged_t klanguage_string = 0x39f5;
  static constexpr Tagged_t klanguageDisplay_string = 0x3a09;
  static constexpr Tagged_t klessPrecision_string = 0x3a25;
  static constexpr Tagged_t kletter_string = 0x3a41;
  static constexpr Tagged_t klist_string = 0x3a55;
  static constexpr Tagged_t kliteral_string = 0x3a65;
  static constexpr Tagged_t klocale_string = 0x3a79;
  static constexpr Tagged_t kloose_string = 0x3a8d;
  static constexpr Tagged_t klower_string = 0x3aa1;
  static constexpr Tagged_t kltr_string = 0x3ab5;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x3ac5;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x3ae9;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x3b0d;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x3b2d;
  static constexpr Tagged_t kmin2_string = 0x3b4d;
  static constexpr Tagged_t kminimalDays_string = 0x3b5d;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x3b75;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x3b99;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x3bb9;
  static constexpr Tagged_t kminus_0 = 0x3bdd;
  static constexpr Tagged_t kminusSign_string = 0x3bed;
  static constexpr Tagged_t kminutesDisplay_string = 0x3c05;
  static constexpr Tagged_t kmonthsDisplay_string = 0x3c21;
  static constexpr Tagged_t kmorePrecision_string = 0x3c3d;
  static constexpr Tagged_t knan_string = 0x3c59;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x3c69;
  static constexpr Tagged_t knarrowSymbol_string = 0x3c89;
  static constexpr Tagged_t knegative_string = 0x3ca1;
  static constexpr Tagged_t knever_string = 0x3cb5;
  static constexpr Tagged_t knone_string = 0x3cc9;
  static constexpr Tagged_t knotation_string = 0x3cd9;
  static constexpr Tagged_t knormal_string = 0x3ced;
  static constexpr Tagged_t knumberingSystem_string = 0x3d01;
  static constexpr Tagged_t knumberingSystems_string = 0x3d1d;
  static constexpr Tagged_t knumeric_string = 0x3d39;
  static constexpr Tagged_t kordinal_string = 0x3d4d;
  static constexpr Tagged_t kpercentSign_string = 0x3d61;
  static constexpr Tagged_t kplusSign_string = 0x3d79;
  static constexpr Tagged_t kquarter_string = 0x3d8d;
  static constexpr Tagged_t kregion_string = 0x3da1;
  static constexpr Tagged_t krelatedYear_string = 0x3db5;
  static constexpr Tagged_t kroundingMode_string = 0x3dcd;
  static constexpr Tagged_t kroundingPriority_string = 0x3de5;
  static constexpr Tagged_t krtl_string = 0x3e01;
  static constexpr Tagged_t kscientific_string = 0x3e11;
  static constexpr Tagged_t ksecondsDisplay_string = 0x3e29;
  static constexpr Tagged_t ksegment_string = 0x3e45;
  static constexpr Tagged_t kSegmentIterator_string = 0x3e59;
  static constexpr Tagged_t kSegments_string = 0x3e75;
  static constexpr Tagged_t ksensitivity_string = 0x3e89;
  static constexpr Tagged_t ksep_string = 0x3ea1;
  static constexpr Tagged_t kshared_string = 0x3eb1;
  static constexpr Tagged_t ksignDisplay_string = 0x3ec5;
  static constexpr Tagged_t kstandard_string = 0x3edd;
  static constexpr Tagged_t kstartRange_string = 0x3ef1;
  static constexpr Tagged_t kstrict_string = 0x3f09;
  static constexpr Tagged_t kstripIfInteger_string = 0x3f1d;
  static constexpr Tagged_t kstyle_string = 0x3f39;
  static constexpr Tagged_t kterm_string = 0x3f4d;
  static constexpr Tagged_t ktextInfo_string = 0x3f5d;
  static constexpr Tagged_t ktimeStyle_string = 0x3f71;
  static constexpr Tagged_t ktimeZones_string = 0x3f89;
  static constexpr Tagged_t ktimeZoneName_string = 0x3fa1;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x3fb9;
  static constexpr Tagged_t ktrunc_string = 0x3fd9;
  static constexpr Tagged_t ktwo_digit_string = 0x3fed;
  static constexpr Tagged_t ktype_string = 0x4001;
  static constexpr Tagged_t kunknown_string = 0x4011;
  static constexpr Tagged_t kupper_string = 0x4025;
  static constexpr Tagged_t kusage_string = 0x4039;
  static constexpr Tagged_t kuseGrouping_string = 0x404d;
  static constexpr Tagged_t kunitDisplay_string = 0x4065;
  static constexpr Tagged_t kweekday_string = 0x407d;
  static constexpr Tagged_t kweekend_string = 0x4091;
  static constexpr Tagged_t kweeksDisplay_string = 0x40a5;
  static constexpr Tagged_t kweekInfo_string = 0x40bd;
  static constexpr Tagged_t kyearName_string = 0x40d1;
  static constexpr Tagged_t kyearsDisplay_string = 0x40e5;
  static constexpr Tagged_t kadd_string = 0x40fd;
  static constexpr Tagged_t kAggregateError_string = 0x410d;
  static constexpr Tagged_t kalways_string = 0x4129;
  static constexpr Tagged_t kanonymous_function_string = 0x413d;
  static constexpr Tagged_t kanonymous_string = 0x415d;
  static constexpr Tagged_t kapply_string = 0x4175;
  static constexpr Tagged_t kArguments_string = 0x4189;
  static constexpr Tagged_t karguments_string = 0x41a1;
  static constexpr Tagged_t karguments_to_string = 0x41b9;
  static constexpr Tagged_t kArray_string = 0x41d9;
  static constexpr Tagged_t karray_to_string = 0x41ed;
  static constexpr Tagged_t kArrayBuffer_string = 0x4209;
  static constexpr Tagged_t kArrayIterator_string = 0x4221;
  static constexpr Tagged_t kas_string = 0x423d;
  static constexpr Tagged_t kassert_string = 0x424d;
  static constexpr Tagged_t kasync_string = 0x4261;
  static constexpr Tagged_t kAtomicsCondition_string = 0x4275;
  static constexpr Tagged_t kAtomicsMutex_string = 0x4295;
  static constexpr Tagged_t kauto_string = 0x42b1;
  static constexpr Tagged_t kawait_string = 0x42c1;
  static constexpr Tagged_t kBigInt_string = 0x42d5;
  static constexpr Tagged_t kbigint_string = 0x42e9;
  static constexpr Tagged_t kBigInt64Array_string = 0x42fd;
  static constexpr Tagged_t kBigUint64Array_string = 0x4319;
  static constexpr Tagged_t kbind_string = 0x4335;
  static constexpr Tagged_t kblank_string = 0x4345;
  static constexpr Tagged_t kBoolean_string = 0x4359;
  static constexpr Tagged_t kboolean_string = 0x436d;
  static constexpr Tagged_t kboolean_to_string = 0x4381;
  static constexpr Tagged_t kbound__string = 0x439d;
  static constexpr Tagged_t kbuffer_string = 0x43b1;
  static constexpr Tagged_t kbyte_length_string = 0x43c5;
  static constexpr Tagged_t kbyte_offset_string = 0x43dd;
  static constexpr Tagged_t kCompileError_string = 0x43f5;
  static constexpr Tagged_t kcalendar_string = 0x440d;
  static constexpr Tagged_t kcallee_string = 0x4421;
  static constexpr Tagged_t kcaller_string = 0x4435;
  static constexpr Tagged_t kcause_string = 0x4449;
  static constexpr Tagged_t kcharacter_string = 0x445d;
  static constexpr Tagged_t kclosure_string = 0x4475;
  static constexpr Tagged_t kcode_string = 0x448d;
  static constexpr Tagged_t kcolumn_string = 0x449d;
  static constexpr Tagged_t kcomputed_string = 0x44b1;
  static constexpr Tagged_t kconjunction_string = 0x44c9;
  static constexpr Tagged_t kconsole_string = 0x44e1;
  static constexpr Tagged_t kconstrain_string = 0x44f5;
  static constexpr Tagged_t kconstruct_string = 0x450d;
  static constexpr Tagged_t kcurrent_string = 0x4525;
  static constexpr Tagged_t kDate_string = 0x4539;
  static constexpr Tagged_t kdate_to_string = 0x4549;
  static constexpr Tagged_t kdateAdd_string = 0x4565;
  static constexpr Tagged_t kdateFromFields_string = 0x4579;
  static constexpr Tagged_t kdateUntil_string = 0x4595;
  static constexpr Tagged_t kday_string = 0x45ad;
  static constexpr Tagged_t kdayOfWeek_string = 0x45bd;
  static constexpr Tagged_t kdayOfYear_string = 0x45d5;
  static constexpr Tagged_t kdays_string = 0x45ed;
  static constexpr Tagged_t kdaysInMonth_string = 0x45fd;
  static constexpr Tagged_t kdaysInWeek_string = 0x4615;
  static constexpr Tagged_t kdaysInYear_string = 0x462d;
  static constexpr Tagged_t kdefault_string = 0x4645;
  static constexpr Tagged_t kdefineProperty_string = 0x4659;
  static constexpr Tagged_t kdeleteProperty_string = 0x4675;
  static constexpr Tagged_t kdetached_string = 0x4691;
  static constexpr Tagged_t kdisjunction_string = 0x46a5;
  static constexpr Tagged_t kdone_string = 0x46bd;
  static constexpr Tagged_t kdot_brand_string = 0x46cd;
  static constexpr Tagged_t kdot_catch_string = 0x46e1;
  static constexpr Tagged_t kdot_default_string = 0x46f5;
  static constexpr Tagged_t kdot_for_string = 0x4709;
  static constexpr Tagged_t kdot_generator_object_string = 0x4719;
  static constexpr Tagged_t kdot_home_object_string = 0x4739;
  static constexpr Tagged_t kdot_new_target_string = 0x4751;
  static constexpr Tagged_t knew_target_string = 0x4751;
  static constexpr Tagged_t kdot_result_string = 0x4769;
  static constexpr Tagged_t kdot_repl_result_string = 0x477d;
  static constexpr Tagged_t kdot_static_home_object_string = 0x4795;
  static constexpr Tagged_t kdot_switch_tag_string = 0x47b5;
  static constexpr Tagged_t kdotAll_string = 0x47cd;
  static constexpr Tagged_t kError_string = 0x47e1;
  static constexpr Tagged_t kEvalError_string = 0x47f5;
  static constexpr Tagged_t kelement_string = 0x480d;
  static constexpr Tagged_t kepochMicroseconds_string = 0x4821;
  static constexpr Tagged_t kepochMilliseconds_string = 0x4841;
  static constexpr Tagged_t kepochNanoseconds_string = 0x4861;
  static constexpr Tagged_t kepochSeconds_string = 0x487d;
  static constexpr Tagged_t kera_string = 0x4895;
  static constexpr Tagged_t keraYear_string = 0x48a5;
  static constexpr Tagged_t kerrors_string = 0x48b9;
  static constexpr Tagged_t kerror_to_string = 0x48cd;
  static constexpr Tagged_t keval_string = 0x48e9;
  static constexpr Tagged_t kexception_string = 0x48f9;
  static constexpr Tagged_t kexec_string = 0x4911;
  static constexpr Tagged_t kfalse_string = 0x4921;
  static constexpr Tagged_t kfields_string = 0x4935;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4949;
  static constexpr Tagged_t kflags_string = 0x4969;
  static constexpr Tagged_t kFloat32Array_string = 0x497d;
  static constexpr Tagged_t kFloat64Array_string = 0x4995;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x49ad;
  static constexpr Tagged_t kfrom_string = 0x49d1;
  static constexpr Tagged_t kFunction_string = 0x49e1;
  static constexpr Tagged_t kfunction_native_code_string = 0x49f5;
  static constexpr Tagged_t kfunction_string = 0x4a21;
  static constexpr Tagged_t kfunction_to_string = 0x4a35;
  static constexpr Tagged_t kGenerator_string = 0x4a55;
  static constexpr Tagged_t kget_space_string = 0x4a6d;
  static constexpr Tagged_t kget_string = 0x4a7d;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x4a8d;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x4ab1;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x4ad5;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4af9;
  static constexpr Tagged_t kglobal_string = 0x4b15;
  static constexpr Tagged_t kglobalThis_string = 0x4b29;
  static constexpr Tagged_t kgroups_string = 0x4b41;
  static constexpr Tagged_t kgrowable_string = 0x4b55;
  static constexpr Tagged_t khas_string = 0x4b69;
  static constexpr Tagged_t khasIndices_string = 0x4b79;
  static constexpr Tagged_t khour_string = 0x4b91;
  static constexpr Tagged_t khours_string = 0x4ba1;
  static constexpr Tagged_t khoursInDay_string = 0x4bb5;
  static constexpr Tagged_t kignoreCase_string = 0x4bcd;
  static constexpr Tagged_t kid_string = 0x4be5;
  static constexpr Tagged_t killegal_access_string = 0x4bf5;
  static constexpr Tagged_t killegal_argument_string = 0x4c11;
  static constexpr Tagged_t kinLeapYear_string = 0x4c2d;
  static constexpr Tagged_t kindex_string = 0x4c45;
  static constexpr Tagged_t kindices_string = 0x4c59;
  static constexpr Tagged_t kInfinity_string = 0x4c6d;
  static constexpr Tagged_t kinfinity_string = 0x4c81;
  static constexpr Tagged_t kinput_string = 0x4c95;
  static constexpr Tagged_t kInt16Array_string = 0x4ca9;
  static constexpr Tagged_t kInt32Array_string = 0x4cc1;
  static constexpr Tagged_t kInt8Array_string = 0x4cd9;
  static constexpr Tagged_t kisExtensible_string = 0x4cf1;
  static constexpr Tagged_t kiso8601_string = 0x4d09;
  static constexpr Tagged_t kisoDay_string = 0x4d1d;
  static constexpr Tagged_t kisoHour_string = 0x4d31;
  static constexpr Tagged_t kisoMicrosecond_string = 0x4d45;
  static constexpr Tagged_t kisoMillisecond_string = 0x4d61;
  static constexpr Tagged_t kisoMinute_string = 0x4d7d;
  static constexpr Tagged_t kisoMonth_string = 0x4d95;
  static constexpr Tagged_t kisoNanosecond_string = 0x4da9;
  static constexpr Tagged_t kisoSecond_string = 0x4dc5;
  static constexpr Tagged_t kisoYear_string = 0x4ddd;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4df1;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4e0d;
  static constexpr Tagged_t kkeys_string = 0x4e29;
  static constexpr Tagged_t klargestUnit_string = 0x4e39;
  static constexpr Tagged_t klastIndex_string = 0x4e51;
  static constexpr Tagged_t klet_string = 0x4e69;
  static constexpr Tagged_t kline_string = 0x4e79;
  static constexpr Tagged_t klinear_string = 0x4e89;
  static constexpr Tagged_t kLinkError_string = 0x4e9d;
  static constexpr Tagged_t klong_string = 0x4eb5;
  static constexpr Tagged_t kMap_string = 0x4ec5;
  static constexpr Tagged_t kMapIterator_string = 0x4ed5;
  static constexpr Tagged_t kmax_byte_length_string = 0x4eed;
  static constexpr Tagged_t kmedium_string = 0x4f09;
  static constexpr Tagged_t kmergeFields_string = 0x4f1d;
  static constexpr Tagged_t kmessage_string = 0x4f35;
  static constexpr Tagged_t kmeta_string = 0x4f49;
  static constexpr Tagged_t kminus_Infinity_string = 0x4f59;
  static constexpr Tagged_t kmicrosecond_string = 0x4f71;
  static constexpr Tagged_t kmicroseconds_string = 0x4f89;
  static constexpr Tagged_t kmillisecond_string = 0x4fa1;
  static constexpr Tagged_t kmilliseconds_string = 0x4fb9;
  static constexpr Tagged_t kminute_string = 0x4fd1;
  static constexpr Tagged_t kminutes_string = 0x4fe5;
  static constexpr Tagged_t kModule_string = 0x4ff9;
  static constexpr Tagged_t kmonth_string = 0x500d;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x5021;
  static constexpr Tagged_t kmonths_string = 0x5041;
  static constexpr Tagged_t kmonthsInYear_string = 0x5055;
  static constexpr Tagged_t kmonthCode_string = 0x506d;
  static constexpr Tagged_t kmultiline_string = 0x5085;
  static constexpr Tagged_t kNaN_string = 0x509d;
  static constexpr Tagged_t knanosecond_string = 0x50ad;
  static constexpr Tagged_t knanoseconds_string = 0x50c5;
  static constexpr Tagged_t knarrow_string = 0x50dd;
  static constexpr Tagged_t knative_string = 0x50f1;
  static constexpr Tagged_t kNFC_string = 0x5105;
  static constexpr Tagged_t kNFD_string = 0x5115;
  static constexpr Tagged_t kNFKC_string = 0x5125;
  static constexpr Tagged_t kNFKD_string = 0x5135;
  static constexpr Tagged_t knot_equal_string = 0x5145;
  static constexpr Tagged_t knull_string = 0x515d;
  static constexpr Tagged_t knull_to_string = 0x516d;
  static constexpr Tagged_t kNumber_string = 0x5189;
  static constexpr Tagged_t knumber_string = 0x519d;
  static constexpr Tagged_t knumber_to_string = 0x51b1;
  static constexpr Tagged_t kObject_string = 0x51cd;
  static constexpr Tagged_t kobject_string = 0x51e1;
  static constexpr Tagged_t kobject_to_string = 0x51f5;
  static constexpr Tagged_t kObject_prototype_string = 0x5211;
  static constexpr Tagged_t kof_string = 0x522d;
  static constexpr Tagged_t koffset_string = 0x523d;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x5251;
  static constexpr Tagged_t kok_string = 0x5271;
  static constexpr Tagged_t kother_string = 0x5281;
  static constexpr Tagged_t koverflow_string = 0x5295;
  static constexpr Tagged_t kownKeys_string = 0x52a9;
  static constexpr Tagged_t kpercent_string = 0x52bd;
  static constexpr Tagged_t kplainDate_string = 0x52d1;
  static constexpr Tagged_t kplainTime_string = 0x52e9;
  static constexpr Tagged_t kposition_string = 0x5301;
  static constexpr Tagged_t kpreventExtensions_string = 0x5315;
  static constexpr Tagged_t kprivate_constructor_string = 0x5335;
  static constexpr Tagged_t kPromise_string = 0x534d;
  static constexpr Tagged_t kproto_string = 0x5361;
  static constexpr Tagged_t kproxy_string = 0x5379;
  static constexpr Tagged_t kProxy_string = 0x538d;
  static constexpr Tagged_t kquery_colon_string = 0x53a1;
  static constexpr Tagged_t kRangeError_string = 0x53b1;
  static constexpr Tagged_t kraw_json_string = 0x53c9;
  static constexpr Tagged_t kraw_string = 0x53dd;
  static constexpr Tagged_t kReferenceError_string = 0x53ed;
  static constexpr Tagged_t kReflectGet_string = 0x5409;
  static constexpr Tagged_t kReflectHas_string = 0x5421;
  static constexpr Tagged_t kRegExp_string = 0x5439;
  static constexpr Tagged_t kregexp_to_string = 0x544d;
  static constexpr Tagged_t kreject_string = 0x5469;
  static constexpr Tagged_t krelativeTo_string = 0x547d;
  static constexpr Tagged_t kresizable_string = 0x5495;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x54ad;
  static constexpr Tagged_t kreturn_string = 0x54cd;
  static constexpr Tagged_t krevoke_string = 0x54e1;
  static constexpr Tagged_t kroundingIncrement_string = 0x54f5;
  static constexpr Tagged_t kRuntimeError_string = 0x5515;
  static constexpr Tagged_t kWebAssemblyException_string = 0x552d;
  static constexpr Tagged_t kScript_string = 0x5551;
  static constexpr Tagged_t kscript_string = 0x5565;
  static constexpr Tagged_t ksecond_string = 0x5579;
  static constexpr Tagged_t kseconds_string = 0x558d;
  static constexpr Tagged_t kshort_string = 0x55a1;
  static constexpr Tagged_t kSet_string = 0x55b5;
  static constexpr Tagged_t ksentence_string = 0x55c5;
  static constexpr Tagged_t kset_space_string = 0x55d9;
  static constexpr Tagged_t kset_string = 0x55e9;
  static constexpr Tagged_t kSetIterator_string = 0x55f9;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x5611;
  static constexpr Tagged_t kShadowRealm_string = 0x562d;
  static constexpr Tagged_t kSharedArray_string = 0x5645;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x565d;
  static constexpr Tagged_t kSharedStruct_string = 0x567d;
  static constexpr Tagged_t ksign_string = 0x5695;
  static constexpr Tagged_t ksmallestUnit_string = 0x56a5;
  static constexpr Tagged_t ksource_string = 0x56bd;
  static constexpr Tagged_t ksourceText_string = 0x56d1;
  static constexpr Tagged_t kstack_string = 0x56e9;
  static constexpr Tagged_t kstackTraceLimit_string = 0x56fd;
  static constexpr Tagged_t ksticky_string = 0x5719;
  static constexpr Tagged_t kString_string = 0x572d;
  static constexpr Tagged_t kstring_string = 0x5741;
  static constexpr Tagged_t kstring_to_string = 0x5755;
  static constexpr Tagged_t kSymbol_iterator_string = 0x5771;
  static constexpr Tagged_t kSymbol_replace_string = 0x578d;
  static constexpr Tagged_t ksymbol_species_string = 0x57a9;
  static constexpr Tagged_t kSymbol_species_string = 0x57c5;
  static constexpr Tagged_t kSymbol_string = 0x57e1;
  static constexpr Tagged_t ksymbol_string = 0x57f5;
  static constexpr Tagged_t kSyntaxError_string = 0x5809;
  static constexpr Tagged_t ktarget_string = 0x5821;
  static constexpr Tagged_t kthis_function_string = 0x5835;
  static constexpr Tagged_t kthis_string = 0x5851;
  static constexpr Tagged_t kthrow_string = 0x5861;
  static constexpr Tagged_t ktimed_out_string = 0x5875;
  static constexpr Tagged_t ktimeZone_string = 0x588d;
  static constexpr Tagged_t ktoJSON_string = 0x58a1;
  static constexpr Tagged_t ktoString_string = 0x58b5;
  static constexpr Tagged_t ktrue_string = 0x58c9;
  static constexpr Tagged_t ktotal_string = 0x58d9;
  static constexpr Tagged_t kTypeError_string = 0x58ed;
  static constexpr Tagged_t kUint16Array_string = 0x5905;
  static constexpr Tagged_t kUint32Array_string = 0x591d;
  static constexpr Tagged_t kUint8Array_string = 0x5935;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x594d;
  static constexpr Tagged_t kundefined_string = 0x596d;
  static constexpr Tagged_t kundefined_to_string = 0x5985;
  static constexpr Tagged_t kunicode_string = 0x59a5;
  static constexpr Tagged_t kunicodeSets_string = 0x59b9;
  static constexpr Tagged_t kunit_string = 0x59d1;
  static constexpr Tagged_t kURIError_string = 0x59e1;
  static constexpr Tagged_t kUTC_string = 0x59f5;
  static constexpr Tagged_t kvalueOf_string = 0x5a05;
  static constexpr Tagged_t kWeakMap_string = 0x5a19;
  static constexpr Tagged_t kWeakRef_string = 0x5a2d;
  static constexpr Tagged_t kWeakSet_string = 0x5a41;
  static constexpr Tagged_t kweek_string = 0x5a55;
  static constexpr Tagged_t kweeks_string = 0x5a65;
  static constexpr Tagged_t kweekOfYear_string = 0x5a79;
  static constexpr Tagged_t kword_string = 0x5a91;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x5aa1;
  static constexpr Tagged_t kyear_string = 0x5ac1;
  static constexpr Tagged_t kyears_string = 0x5ad1;
  static constexpr Tagged_t kUninitializedValue = 0x5af5;
  static constexpr Tagged_t kArgumentsMarker = 0x5b2d;
  static constexpr Tagged_t kTerminationException = 0x5b65;
  static constexpr Tagged_t kException = 0x5ba5;
  static constexpr Tagged_t kOptimizedOut = 0x5bc1;
  static constexpr Tagged_t kStaleRegister = 0x5bf9;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5c31;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5c71;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5cb5;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5cc5;
  static constexpr Tagged_t kconsole_context_id_symbol = 0x5cd5;
  static constexpr Tagged_t kconsole_context_name_symbol = 0x5ce5;
  static constexpr Tagged_t kclass_fields_symbol = 0x5cf5;
  static constexpr Tagged_t kclass_positions_symbol = 0x5d05;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5d15;
  static constexpr Tagged_t kerror_script_symbol = 0x5d25;
  static constexpr Tagged_t kerror_stack_symbol = 0x5d35;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5d45;
  static constexpr Tagged_t kfrozen_symbol = 0x5d55;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5d65;
  static constexpr Tagged_t knative_context_index_symbol = 0x5d75;
  static constexpr Tagged_t knonextensible_symbol = 0x5d85;
  static constexpr Tagged_t kpromise_debug_marker_symbol = 0x5d95;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5da5;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5db5;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5dc5;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5dd5;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5de5;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5df5;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5e05;
  static constexpr Tagged_t ksealed_symbol = 0x5e15;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5e25;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5e35;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5e45;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5e55;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5e65;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5e75;
  static constexpr Tagged_t kwasm_wrapped_object_symbol = 0x5e85;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5e95;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5ea5;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5eb5;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5ee5;
  static constexpr Tagged_t kmatch_all_symbol = 0x5f1d;
  static constexpr Tagged_t kmatch_symbol = 0x5f49;
  static constexpr Tagged_t ksearch_symbol = 0x5f71;
  static constexpr Tagged_t ksplit_symbol = 0x5f9d;
  static constexpr Tagged_t kto_primitive_symbol = 0x5fc5;
  static constexpr Tagged_t kunscopables_symbol = 0x5ff5;
  static constexpr Tagged_t khas_instance_symbol = 0x6025;
  static constexpr Tagged_t kto_string_tag_symbol = 0x6055;
  static constexpr Tagged_t kconstructor_string = 0x60ad;
  static constexpr Tagged_t knext_string = 0x60c5;
  static constexpr Tagged_t kresolve_string = 0x60d5;
  static constexpr Tagged_t kthen_string = 0x60e9;
  static constexpr Tagged_t kiterator_symbol = 0x60f9;
  static constexpr Tagged_t kreplace_symbol = 0x6109;
  static constexpr Tagged_t kspecies_symbol = 0x6119;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x6129;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x6139;
  static constexpr Tagged_t kEmptySymbolTable = 0x615d;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x6179;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x618d;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x61a1;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x61ad;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x61cd;
  static constexpr Tagged_t kNativeScopeInfo = 0x61f1;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x6209;
  static constexpr Tagged_t kWasmNull = 0xfffd;
};

static constexpr std::array<Tagged_t, 738> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kOneByteStringMap,
    StaticReadOnlyRoot::kOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kSideEffectCallHandlerInfoMap,
    StaticReadOnlyRoot::kSideEffectFreeCallHandlerInfoMap,
    StaticReadOnlyRoot::kNextCallSideEffectFreeCallHandlerInfoMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWasmApiFunctionRefMap,
    StaticReadOnlyRoot::kWasmCapiFunctionDataMap,
    StaticReadOnlyRoot::kWasmExportedFunctionDataMap,
    StaticReadOnlyRoot::kWasmInternalFunctionMap,
    StaticReadOnlyRoot::kWasmJSFunctionDataMap,
    StaticReadOnlyRoot::kWasmResumeDataMap,
    StaticReadOnlyRoot::kWasmTypeInfoMap,
    StaticReadOnlyRoot::kWasmContinuationObjectMap,
    StaticReadOnlyRoot::kWasmNullMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kConsStringMap,
    StaticReadOnlyRoot::kThinStringMap,
    StaticReadOnlyRoot::kSlicedStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalStringMap,
    StaticReadOnlyRoot::kInternalizedStringMap,
    StaticReadOnlyRoot::kExternalInternalizedStringMap,
    StaticReadOnlyRoot::kExternalOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteInternalizedStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedOneByteStringMap,
    StaticReadOnlyRoot::kSharedStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kTheHoleMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kUninitializedMap,
    StaticReadOnlyRoot::kArgumentsMarkerMap,
    StaticReadOnlyRoot::kExceptionMap,
    StaticReadOnlyRoot::kTerminationExceptionMap,
    StaticReadOnlyRoot::kOptimizedOutMap,
    StaticReadOnlyRoot::kStaleRegisterMap,
    StaticReadOnlyRoot::kSelfReferenceMarkerMap,
    StaticReadOnlyRoot::kBasicBlockCountersMarkerMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSingleCharacterStringTable,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kWasmNull,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_function_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kawait_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kclosure_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMicroseconds_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kepochSeconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::kof_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kconsole_context_id_symbol,
    StaticReadOnlyRoot::kconsole_context_name_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_marker_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_wrapped_object_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsmWasmDataMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseOnStackMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kWasmExceptionTagMap,
    StaticReadOnlyRoot::kWasmIndirectFunctionTableMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithSmiElementsMap,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kWasmStringViewIterMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_H_
