<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/prometheus/integrations/steam.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/prometheus/metadata.yaml"
sidebar_label: "Steam"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Gaming"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Steam


<img src="https://netdata.cloud/img/a2s.png" width="150"/>


Plugin: go.d.plugin
Module: prometheus

<img src="https://img.shields.io/badge/maintained%20by-Community-blue" />

## Overview

Gain insights into Steam A2S-supported game servers for performance and availability through real-time metric monitoring.


Metrics are gathered by periodically sending HTTP requests to [A2S Exporter](https://github.com/armsnyder/a2s-exporter).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects instances running on the local host by trying to connect to known ports that are [allocated to exporters](https://github.com/prometheus/prometheus/wiki/Default-port-allocations).


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

This collector has built-in grouping logic based on the [type of metrics](https://prometheus.io/docs/concepts/metric_types/).

| Metric                    | Chart                                     | Dimension(s)         | Algorithm   |
|---------------------------|-------------------------------------------|----------------------|-------------|
| Gauge                     | for each label set                        | one, the metric name | absolute    |
| Counter                   | for each label set                        | one, the metric name | incremental |
| Summary (quantiles)       | for each label set (excluding 'quantile') | for each quantile    | absolute    |
| Summary (sum and count)   | for each label set                        | the metric name      | incremental |
| Histogram (buckets)       | for each label set (excluding 'le')       | for each bucket      | incremental |
| Histogram (sum and count) | for each label set                        | the metric name      | incremental |

Untyped metrics (have no '# TYPE') processing:

- As Counter or Gauge depending on pattern match when 'fallback_type' is used.
- As Counter if it has suffix '_total'.
- As Summary if it has 'quantile' label.
- As Histogram if it has 'le' label.

**The rest are ignored**.



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **prometheus** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **prometheus**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/prometheus.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Install Exporter

Install [A2S Exporter](https://github.com/armsnyder/a2s-exporter) by following the instructions mentioned in the exporter README.



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 10 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. |  | yes |
|  | timeout | HTTP request timeout (seconds). | 10 | no |
| **Filters** | selector | Time series selector (filter). |  | no |
| **Limits** | max_time_series | Global time series limit. If an endpoint returns more time series than this, the data is not processed. | 2000 | no |
|  | max_time_series_per_metric | Per-metric time series limit. Metrics with more time series than this are skipped. | 200 | no |
| **Customization** | fallback_type | Fallback type rules for untyped metrics. |  | no |
|  | label_prefix | Optional prefix added to all labels of all charts. Labels will be formatted as `prefix_name`. |  | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |

##### selector

This option allows you to filter out unwanted time series. Only metrics matching the selector will be collected.

- Logic: (pattern1 OR pattern2) AND !(pattern3 or pattern4)
- Pattern syntax: [selector](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/pkg/prometheus/selector/README.md).
- Option syntax:

```yaml
selector:
  allow:
    - pattern1
    - pattern2
  deny:
    - pattern3
    - pattern4
```


##### fallback_type

This option allows you to process Untyped metrics as Counter or Gauge instead of ignoring them.

- Metric name pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match).
- Option syntax:

```yaml
fallback_type:
  counter:
    - metric_name_pattern1
    - metric_name_pattern2
  gauge:
    - metric_name_pattern3
    - metric_name_pattern4
```



</details>


#### via UI

Configure the **prometheus** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the prometheus data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _prometheus_ (or scroll the list) to locate the **prometheus** collector.
5. Click the **+** next to the **prometheus** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/prometheus.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/prometheus.conf
```

##### Examples

###### Basic

> **Note**: Change the port of the monitored application on which it provides metrics.

A basic example configuration.


```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics

```
###### Read metrics from a file

An example configuration to read metrics from a file.

<details open><summary>Config</summary>

```yaml
# use "file://" scheme
jobs:
  - name: myapp
    url: file:///opt/metrics/myapp/metrics.txt

```
</details>

###### HTTP authentication

> **Note**: Change the port of the monitored application on which it provides metrics.

Basic HTTP authentication.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics
    username: username
    password: password

```
</details>

###### HTTPS with self-signed certificate

> **Note**: Change the port of the monitored application on which it provides metrics.

Do not validate server certificate chain and hostname.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:9090/metrics
    tls_skip_verify: yes

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.
> **Note**: Change the port of the monitored application on which it provides metrics.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics

  - name: remote
    url: http://192.0.2.1:9090/metrics

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `prometheus` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m prometheus
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m prometheus -j jobName
  ```

### Getting Logs

If you're encountering problems with the `prometheus` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep prometheus
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep prometheus /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep prometheus
```


