/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.DefaultExtensionRealmCache;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingExtensionRealmCache
extends DefaultExtensionRealmCache {
    private final Cache<ExtensionRealmCache.Key, Record> cache;

    @Inject
    public InvalidatingExtensionRealmCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public ExtensionRealmCache.CacheRecord get(ExtensionRealmCache.Key key) {
        Record r = this.cache.get(key);
        return r != null ? r.record : null;
    }

    public ExtensionRealmCache.CacheRecord put(ExtensionRealmCache.Key key, ClassRealm extensionRealm, ExtensionDescriptor extensionDescriptor, List<Artifact> artifacts) {
        ExtensionRealmCache.CacheRecord record = super.put(key, extensionRealm, extensionDescriptor, artifacts);
        ((DefaultExtensionRealmCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public void flush() {
        this.cache.clear();
    }

    public void register(MavenProject project, ExtensionRealmCache.Key key, ExtensionRealmCache.CacheRecord record) {
    }

    protected static class Record
    implements CacheRecord {
        private final ExtensionRealmCache.CacheRecord record;

        public Record(ExtensionRealmCache.CacheRecord record) {
            this.record = record;
        }

        @Override
        public Stream<Path> getDependencyPaths() {
            return this.record.getArtifacts().stream().map(artifact -> artifact.getFile().toPath());
        }

        @Override
        public void invalidate() {
            ClassRealm realm = this.record.getRealm();
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
        }
    }
}

