## =============================================================================
##  This file is part of the mmg software package for the tetrahedral
##  mesh modification.
##**  Copyright (c) Bx INP/Inria/UBordeaux/UPMC, 2004- .
##
##  mmg is free software: you can redistribute it and/or modify it
##  under the terms of the GNU Lesser General Public License as published
##  by the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  mmg is distributed in the hope that it will be useful, but WITHOUT
##  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
##  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
##  License for more details.
##
##  You should have received a copy of the GNU Lesser General Public
##  License and of the GNU General Public License along with mmg (in
##  files COPYING.LESSER and COPYING). If not, see
##  <http://www.gnu.org/licenses/>. Please read their terms carefully and
##  use this copy of the mmg distribution only if you accept them.
## =============================================================================

GET_FILENAME_COMPONENT ( SHRT_EXECUT_MMG3D ${EXECUT_MMG3D} NAME )

##############################################################################
#####
#####         Tests that may be run twice
#####
##############################################################################

SET ( test_names
  # Simple test: must already pass
  mmg3d_SimpleCube
  # MultiDomain
  mmg3d_MultiDom_Ellipse_fast
  mmg3d_MultiDom_Ellipse_ReqEntities_fast
  # Non-manifold test case
  mmg3d_NM_Cube_fast
  mmg3d_NM_Complex_fast
  )

SET ( input_files
  ${MMG3D_CI_TESTS}/Cube/cube
  ### Multidom
  ${MMG3D_CI_TESTS}/MultiDom_Ellipse/c.d
  ${MMG3D_CI_TESTS}/MultiDom_Ellipse_ReqEntities/c.d
  ### non-manifold
  ${MMG3D_CI_TESTS}/NM_Cube/nm
  ${MMG3D_CI_TESTS}/NM_Complex/nm4
  )

SET ( args
  "-v 5"
  ### MultiDomain
  "-v 5 -hausd 0.002"
  "-v 5 -hausd 0.002"
  ### non-manifold
  "-v 5 -hmax 0.1"
  "-v 5"
  )

IF ( LONG_TESTS )
  SET ( test_names ${test_names}
    # Check what happend when we refine an isotropic cube of size h with a
    # constant metric (h, h/2, h/4, h/8 and h/16) ---First with hmin=hmax
    mmg3d_CubeIso_h_hminMax
    mmg3d_CubeIso_0.5h_hminMax
    mmg3d_CubeIso_0.25h_hminMax
    #---Second with sol file
    mmg3d_CubeIso_h_met
    mmg3d_CubeIso_0.5h_met
    mmg3d_CubeIso_0.25h_met
    mmg3d_CubeIso_0.125h_met
    mmg3d_CubeAniIso_0.125h_met
    #####
    mmg3d_SphereIso_h_met
    mmg3d_SphereIso_0.5h_met
    mmg3d_SphereIso_0.25h_met
    mmg3d_SphereIso_0.125h_met
    mmg3d_SphereIso_0.020_met
    mmg3d_SphereIso_0.020-0.015_met
    mmg3d_SphereAni_0.02
    # Check what happend when we unrefine a sphere of size smallh with a
    # constant metric (2*smallh, 4*smallh and 8*smallh)
    mmg3d_SphereIso_2smallh_met
    mmg3d_SphereIso_4smallh_met
    mmg3d_SphereIso_8smallh_met
    # Check what happend when we use hausdorff number to refine the skin and a
    # big hgrad to have an inside of the initial size (0.5)
    mmg3d_SphereIso_h_hausd0.001
    mmg3d_SphereIso_h_hausd0.005
    # Check what happend when we refine a cube whose skin has already the good size
    mmg3d_CubeSkin0.05_Inside0.4
    mmg3d_CubeSkin0.1_Inside0.4
    mmg3d_CubeSkin0.2_Inside0.4
    mmg3d_CubeSkin0.0125_Inside0.125
    mmg3d_CubeSkin0.0125_Inside0.25
    mmg3d_CubeSkin0.0125_Inside0.5
    # Check results on various meshes
    # First: Meshes that we want unrefined
    mmg3d_Various_unref_Linkrods_met0.2
    mmg3d_Various_unref_Linkrods_met0.2_hausd0.01
    # Second: Meshes that we want refined
    mmg3d_Various_ref_Linkrods_met0.05
    mmg3d_Various_ref_Linkrods_met0.05_hausd0.01
    mmg3d_Various_ref_Linkrods_met0.05_hausd0.001
    # Third: We refine some parts and unrefined others
    mmg3d_Various_refunref_Santa_met0.05_hausd0.001_ar90
    mmg3d_Various_refunref_Santa_met0.05_hausd0.0001_ar90
    # 5: MultiDomain
    mmg3d_MultiDom_Cube
    mmg3d_MultiDom_Cube_ReqEntities
    mmg3d_MultiDom_Ellipse
    mmg3d_MultiDom_Ellipse_ReqEntities
    # Non-manifold test case
    mmg3d_NM_Cube
    mmg3d_NM_Complex
    )

  SET ( input_files  ${input_files}
    ### Cube
    ${MMG3D_CI_TESTS}/CubeIso_h_hminMax/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeIso_0.5h_hminMax/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeIso_0.25h_hminMax/CubeIso0.1
    ###
    ${MMG3D_CI_TESTS}/CubeIso_h_met/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeIso_0.5h_met/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeIso_0.25h_met/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeIso_0.125h_met/CubeIso0.1
    ${MMG3D_CI_TESTS}/CubeAniIso_0.125h_met/CubeIso0.1
    ### Sphere
    ${MMG3D_CI_TESTS}/SphereIso_h_met/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_0.5h_met/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_0.25h_met/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_0.125h_met/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_0.020_met/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_0.020-0.015_met/SphereIso0.020
    ${MMG3D_CI_TESTS}/SphereAni_0.02/sphere
    ###
    ${MMG3D_CI_TESTS}/SphereIso_2smallh_met/SphereIso0.0625
    ${MMG3D_CI_TESTS}/SphereIso_4smallh_met/SphereIso0.0625
    ${MMG3D_CI_TESTS}/SphereIso_8smallh_met/SphereIso0.0625
    ###
    ${MMG3D_CI_TESTS}/SphereIso_h_hausd0.001/SphereIso0.5
    ${MMG3D_CI_TESTS}/SphereIso_h_hausd0.005/SphereIso0.5
    ### CubeSkin
    ${MMG3D_CI_TESTS}/CubeSkin0.05_Inside0.4/CubeSkin0.05
    ${MMG3D_CI_TESTS}/CubeSkin0.1_Inside0.4/CubeSkin0.1
    ${MMG3D_CI_TESTS}/CubeSkin0.2_Inside0.4/CubeSkin0.2
    ${MMG3D_CI_TESTS}/CubeSkin0.0125_Inside0.125/CubeSkin0.125
    ${MMG3D_CI_TESTS}/CubeSkin0.0125_Inside0.25/CubeSkin0.25
    ${MMG3D_CI_TESTS}/CubeSkin0.0125_Inside0.5/CubeSkin0.5
    ### Linkrods
    ${MMG3D_CI_TESTS}/Various_unref_Linkrods_met0.2/linkrods
    ${MMG3D_CI_TESTS}/Various_unref_Linkrods_met0.2_hausd0.01/linkrods
    ${MMG3D_CI_TESTS}/Various_ref_Linkrods_met0.05/linkrods
    ${MMG3D_CI_TESTS}/Various_ref_Linkrods_met0.05_hausd0.01/linkrods
    ${MMG3D_CI_TESTS}/Various_ref_Linkrods_met0.05_hausd0.001/linkrods
    ### Santa
    ${MMG3D_CI_TESTS}/Various_refunref_Santa_met0.05_hausd0.001_ar90/santa
    ${MMG3D_CI_TESTS}/Various_refunref_Santa_met0.05_hausd0.0001_ar90/santa
    ### MultiDomain
    ${MMG3D_CI_TESTS}/MultiDom_Cube/c
    ${MMG3D_CI_TESTS}/MultiDom_Cube_ReqEntities/c
    ${MMG3D_CI_TESTS}/MultiDom_Ellipse/c.d
    ${MMG3D_CI_TESTS}/MultiDom_Ellipse_ReqEntities/c.d
    ${MMG3D_CI_TESTS}/NM_Cube/nm
    ${MMG3D_CI_TESTS}/NM_Complex/nm4
    )

  SET ( args ${args}
    ### Cube
    "-v 5 -hmax 0.1 -hmin 0.1"
    "-v 5 -hmax 0.05 -hmin 0.05"
    "-v 5 -hmax 0.025 -hmin 0.025"
    ###
    "-v 5"
    "-v 5"
    "-v 5"
    "-v 5"
    "-v 5"
    ### Sphere
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5"
    ###
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.1"
    ###
    "-v 5 -hausd 0.001 -hgrad -1"
    "-v 5 -hausd 0.005 -hgrad -1"
    ### CubeSkin
    "-v 5"
    "-v 5"
    "-v 5"
    "-v 5"
    "-v 5"
    "-v 5"
    ### Linkrods
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.01"
    "-v 5 -hausd 0.1"
    "-v 5 -hausd 0.01"
    "-v 5 -hausd 0.001"
    ### Santa
    "-v 5 -hausd 0.001 -ar 90"
    "-v 5 -hausd 0.0001 -ar 90"
    ### MultiDomain
    "-v 5 -hmax 0.02"
    "-v 5 -hmax 0.02"
    "-v 5 -hausd 0.0003"
    "-v 5 -hausd 0.0003"
    "-v 5 -hmax 0.05"
    "-v 5"
    )

ENDIF ( )

ADD_RUN_AGAIN_TESTS ( ${EXECUT_MMG3D} "${test_names}" "${args}" "${input_files}" )

IF ( LONG_TESTS )
  ### M6
  SET ( test_name
    # 4: Refinment on a solution
    mmg3d_Various_adpsol_hgrad1_M6Mach_Eps0.001_hmin0.001_hmax2
    )
  SET ( input_file
    ${MMG3D_CI_TESTS}/Various_adpsol_hgrad1_M6Mach_Eps0.001_hmin0.001_hmax2/M6
    )

  ADD_TEST(NAME ${test_name}
    COMMAND ${EXECUT_MMG3D}
    ### M6
    ${input_file}
    -v 5 -sol ${MMG3D_CI_TESTS}/Various_adpsol_hgrad1_M6Mach_Eps0.001_hmin0.001_hmax2/metM6.sol -hausd 0.1 -ar 60
    -out ${CTEST_OUTPUT_DIR}/${test_name}-out.o.meshb )

  SET_TESTS_PROPERTIES ( ${test_name}
    PROPERTIES FIXTURES_SETUP ${test_name} )

  IF ( RUN_AGAIN )
    ADD_TEST(NAME ${test_name}_2
      COMMAND ${EXECUT_MMG3D}
      -v 5 -hausd 0.1 -ar 60 -hgrad -1
      ${CTEST_OUTPUT_DIR}/${test_name}-out.o.meshb
      -out ${CTEST_OUTPUT_DIR}/${test_name}_2-out.o.meshb
      )

    SET_TESTS_PROPERTIES ( ${test_name}_2
      PROPERTIES FIXTURES_REQUIRED ${test_name} )

  ENDIF ( RUN_AGAIN )

  SET ( test_name
      # 4: Refinment on a solution
      mmg3d_Various_adpsol_hgrad1_M6Mach_Eps0.0005_hmin0.0001_hmax3
      )
  SET ( input_file
      ${MMG3D_CI_TESTS}/Various_adpsol_hgrad1_M6Mach_Eps0.0005_hmin0.0001_hmax3/M6
      )

  ADD_TEST(NAME ${test_name}
    COMMAND ${EXECUT_MMG3D}
    ${input_file}
    ### M6
    ${input_file}
    -v 5 -sol ${MMG3D_CI_TESTS}/Various_adpsol_hgrad1_M6Mach_Eps0.0005_hmin0.0001_hmax3/metM6.sol -hausd 0.1 -ar 60
    -out ${CTEST_OUTPUT_DIR}/${test_name}-out.o.meshb )

  SET_TESTS_PROPERTIES ( ${test_name}
    PROPERTIES FIXTURES_SETUP ${test_name} )

    IF ( RUN_AGAIN )
      ADD_TEST(NAME ${test_name}_2
        COMMAND ${EXECUT_MMG3D}
        -v 5 -hausd 0.1 -ar 60 -hgrad -1
        ${CTEST_OUTPUT_DIR}/${test_name}-out.o.meshb
        -out ${CTEST_OUTPUT_DIR}/${test_name}_2-out.o.meshb
        )

    SET_TESTS_PROPERTIES ( ${test_name}_2
      PROPERTIES FIXTURES_REQUIRED ${test_name} )

  ENDIF ( )
ENDIF ( LONG_TESTS )


###############################################################################
#####
#####         Input/Output
#####
###############################################################################

# Binary gmsh
ADD_TEST(NAME mmg3d_binary_gmsh_3d
  COMMAND ${EXECUT_MMG3D} -v 5
  ${MMG3D_CI_TESTS}/GmshInout/cube.mshb
  ${CTEST_OUTPUT_DIR}/mmg3d_binary_gmsh_3d-cube.o
  )

# Ascii gmsh
ADD_TEST(NAME mmg3d_ascii_gmsh_3d
  COMMAND ${EXECUT_MMG3D} -v 5
  ${MMG3D_CI_TESTS}/GmshInout/cube.msh
  ${CTEST_OUTPUT_DIR}/mmg3d_ascii_gmsh_3d-cube.o
)


##############################################################################
#####
#####         Check Memory Leak
#####
##############################################################################
#####
ADD_TEST(NAME mmg3d_LeakCheck_AbnormalEnd3
  COMMAND ${EXECUT_MMG3D} -v 5
  ${MMG3D_CI_TESTS}/LeakCheck_AbnormalEnd3/d -sol
  ${MMG3D_CI_TESTS}/LeakCheck_AbnormalEnd3/dsol.sol -ls
  -out ${CTEST_OUTPUT_DIR}/mmg3d_LeakCheck_AbnormalEnd3-d.o.meshb)
SET(passRegex "## ERROR: WRONG DATA TYPE OR WRONG SOLUTION NUMBER")
SET_PROPERTY(TEST mmg3d_LeakCheck_AbnormalEnd3
  PROPERTY PASS_REGULAR_EXPRESSION "${passRegex}")
#####
ADD_TEST(NAME mmg3d_LeakCheck_optLevelSet
  COMMAND ${EXECUT_MMG3D} -v 5  -ls -hgrad 1.5
  ${MMG3D_CI_TESTS}/LeakCheck_optLevelSet/rect03d
  -out ${CTEST_OUTPUT_DIR}/mmg3d_LeakCheck_optLevelSet-rect03d.o.meshb)


###############################################################################
#####
#####         Check Boundaries
#####
###############################################################################
#####
ADD_TEST(NAME mmg3d_ChkBdry_optls_test4
  COMMAND ${EXECUT_MMG3D} -v 5  -ls -hgrad 1.5
  -in ${MMG3D_CI_TESTS}/ChkBdry_optls_test4/test4
  -sol ${MMG3D_CI_TESTS}/ChkBdry_optls_test4/test4.sol
  -out ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_optls_test4-test4.o.meshb)
#####
ADD_TEST(NAME mmg3d_ChkBdry_optls_temp
  COMMAND ${EXECUT_MMG3D} -v 5 -ls -hmin 5 -hmax 6
  -nr -hausd 0.5 -hgrad 1.2
  -in ${MMG3D_CI_TESTS}/ChkBdry_optls_temp/temp
  -sol ${MMG3D_CI_TESTS}/ChkBdry_optls_temp/temp.sol
  -out ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_optls_temp-temp.o.meshb)
####
ADD_TEST(NAME mmg3d_ChkBdry_optls_temp2
  COMMAND ${EXECUT_MMG3D} -v 5  -ls -hmin 5 -hmax 6
  -nr -hausd 0.5 -hgrad 1.2
  -in ${MMG3D_CI_TESTS}/ChkBdry_optls_temp/temp
  -sol ${MMG3D_CI_TESTS}/ChkBdry_optls_temp/temp.sol
  -out ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_optls_temp2-temp.o.meshb)
#####
ADD_TEST(NAME mmg3d_ChkBdry_cube
  COMMAND ${EXECUT_MMG3D} -v 5
  ${MMG3D_CI_TESTS}/ChkBdry_cube/cube
  ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_cube-cube.o
  )
#####
ADD_TEST(NAME mmg3d_ChkBdry_multidomCube
  COMMAND ${EXECUT_MMG3D} -v 5 -hmax 0.1
  ${MMG3D_CI_TESTS}/ChkBdry_multidomCube/c
  ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_multidomCube-cube.o
  )
#####
ADD_TEST(NAME mmg3d_ChkBdry_multidomCube2
  COMMAND ${EXECUT_MMG3D} -v 5 -hmax 0.1
  ${MMG3D_CI_TESTS}/ChkBdry_multidomCube2/c
  ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_multidomCube2-c.o
  )
#####
ADD_TEST(NAME mmg3d_ChkBdry_multidomCube3
  COMMAND ${EXECUT_MMG3D} -v 5 -hmax 0.1
  ${MMG3D_CI_TESTS}/ChkBdry_multidomCube3/c
  ${CTEST_OUTPUT_DIR}/mmg3d_ChkBdry_multidomCube2-cube.o
  )

ADD_TEST(NAME mmg3d_OpnBdy_unref_peninsula
  COMMAND ${EXECUT_MMG3D} -v 5 -opnbdy
  -in ${MMG3D_CI_TESTS}/OpnBdy_peninsula/peninsula
  -out ${CTEST_OUTPUT_DIR}/mmg3d_OpnBdy_peninsula.o.meshb)

ADD_TEST(NAME mmg3d_OpnBdy_ref_peninsula
  COMMAND ${EXECUT_MMG3D} -v 5 -hmax 0.06 -opnbdy
  -in ${MMG3D_CI_TESTS}/OpnBdy_peninsula/peninsula
  -out ${CTEST_OUTPUT_DIR}/mmg3d_OpnBdy_peninsula.o.meshb)

ADD_TEST(NAME mmg3d_OpnBdy_unref_island
  COMMAND ${EXECUT_MMG3D} -v 5 -opnbdy
  -in ${MMG3D_CI_TESTS}/OpnBdy_island/island
  -out ${CTEST_OUTPUT_DIR}/mmg3d_OpnBdy_island.o.meshb)

ADD_TEST(NAME mmg3d_OpnBdy_ref_island
  COMMAND ${EXECUT_MMG3D} -v 5 -hmax 0.06 -opnbdy
  -in ${MMG3D_CI_TESTS}/OpnBdy_island/island
  -out ${CTEST_OUTPUT_DIR}/mmg3d_OpnBdy_island.o.meshb)

###############################################################################
#####
#####         Check Lagrangian motion option
#####
###############################################################################
#####
IF ( USE_SUSCELAS )
  ADD_TEST(NAME mmg3d_LagMotion1_tinyBoxt
    COMMAND ${EXECUT_MMG3D} -v 5  -lag 1
    -in ${MMG3D_CI_TESTS}/LagMotion1_tinyBoxt/tinyBoxt
    -sol ${MMG3D_CI_TESTS}/LagMotion1_tinyBoxt/tinyBoxt.sol
    -out ${CTEST_OUTPUT_DIR}/mmg3d_LagMotion1_tinyBoxt-tinyBoxt.o.meshb
    )
ENDIF()

##############################################################################
#####
#####         Check Local parameters at tetra
#####
##############################################################################
#####
ADD_TEST(NAME mmg3d_TetLoc_Ellipse
  COMMAND ${EXECUT_MMG3D} -v 5 -hgrad -1
  ${MMG3D_CI_TESTS}/TetLoc_Ellipse/c
  ${CTEST_OUTPUT_DIR}/mmg3d_TetLoc_Ellipse-c.o.meshb
  -hgrad 2
  )

##############################################################################
#####
#####         Check optim + aniso option
#####
##############################################################################
#####
ADD_TEST(NAME mmg3d_OptimAni_Sphere
  COMMAND ${EXECUT_MMG3D} -v 5 -optim -A
  ${MMG3D_CI_TESTS}/SphereIso_h_met/SphereIso0.5.meshb -sol 2
  ${CTEST_OUTPUT_DIR}/mmg3d_OptimAni_Sphere.o.mesh
  )


###############################################################################
#####
#####         Check Results
#####
###############################################################################
#####

IF ( LONG_TESTS )
  # Test the Ls option
  ADD_TEST(NAME mmg3d_OptLs_cube303d_hminMax_hgrad1.2_hausd0.005
    COMMAND ${EXECUT_MMG3D} -v 5 -ls
    ${MMG3D_CI_TESTS}/OptLs_cube303d_hminMax_hgrad1.2_hausd0.005/cube303d
    -sol ${MMG3D_CI_TESTS}/OptLs_cube303d_hminMax_hgrad1.2_hausd0.005/cube303d.sol
    -hausd 0.005 -nr -hgrad 1.2 -hmin 0.001 -hmax 0.1
    mmg3d_OptLs_cube303d_hminMax_hgrad1.2_hausd0.005-cube303d.o.meshb)
  ADD_TEST(NAME mmg3d_OptLs_temp_hminMax_hgrad1.2_hausd0.1
    COMMAND ${EXECUT_MMG3D} -v 5 -ls
    ${MMG3D_CI_TESTS}/OptLs_temp_hminMax_hgrad1.2_hausd0.1/temp
    -sol ${MMG3D_CI_TESTS}/OptLs_temp_hminMax_hgrad1.2_hausd0.1/temp.sol
    -hausd 0.1 -nr -hgrad 1.2 -hmin 3 -hmax 4
    ${CTEST_OUTPUT_DIR}/mmg3d_OptLs_temp_hminMax_hgrad1.2_hausd0.1-temp.o.meshb)

  ###############################################################################
  #####
  #####         Check Lagrangian motion option
  #####
  ###############################################################################
  #####
  IF ( USE_SUSCELAS )
    ADD_TEST(NAME mmg3d_LagMotion1_boxt
      COMMAND ${EXECUT_MMG3D} -v 5  -lag 1
      -in ${MMG3D_CI_TESTS}/LagMotion1_boxt/boxt
      -sol ${MMG3D_CI_TESTS}/LagMotion1_boxt/boxt.sol
      -out ${CTEST_OUTPUT_DIR}/mmg3d_LagMotion1_boxt-boxt.o.meshb
      )
  ENDIF()

ENDIF()

###############################################################################
#####
#####         Bug Fix
#####
###############################################################################
#####
#ADD_TEST(NAME mmg3d_BUG_OptLsSingularities
# COMMAND ${EXECUT_MMG3D} -v 5  -ls
# ${MMG3D_CI_TESTS}/BUG_OptLsSingularities/test4
# ${CTEST_OUTPUT_DIR}/mmg3d_BUG_OptLsSingularities-test4.o.meshb)
#
#ADD_TEST(NAME mmg3d_TestDoSol_1
# COMMAND ${EXECUT_MMG3D} -v 5  -hgrad -1 -hausd 1 -m 100
# ${MMG3D_CI_TESTS}/TestDoSol_1/66_shaver3.mesh
# ${CTEST_OUTPUT_DIR}/mmg3d_TestDoSol_1-66_shaver3.o.meshb)
