/*
 * MinIO Client (C) 2020 MinIO, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cmd

import "github.com/minio/cli"

var adminBucketRemoteSubcommands = []cli.Command{
	adminBucketRemoteAddCmd,
	adminBucketRemoteEditCmd,
	adminBucketRemoteListCmd,
	adminBucketRemoteRmCmd,
}

var adminBucketRemoteCmd = cli.Command{
	Name:            "remote",
	Usage:           "configure remote target buckets",
	Action:          mainadminBucketRemote,
	Before:          setGlobalsFromContext,
	Flags:           globalFlags,
	Subcommands:     adminBucketRemoteSubcommands,
	HideHelpCommand: true,
}

// mainadminBucketRemote is the handle for "mc admin bucket remote" command.
func mainadminBucketRemote(ctx *cli.Context) error {
	commandNotFound(ctx, adminBucketRemoteSubcommands)
	return nil
	// Sub-commands like "add", "ls", "rm" have their own main.
}
