dnl mexopt.m4 --- check for MEX options file.
dnl
dnl Copyright (C) 2001--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MEX_OPTIONS
# --------------
# Check for MEX options file.
AC_DEFUN([AX_MEX_OPTIONS],
[dnl
AC_PREREQ([2.50])
mex_options=yes
AC_ARG_WITH([mex-options], AC_HELP_STRING([--with-mex-options=ARG], [use MEX options file ARG [[standard]]]),
[mex_options=$withval])
AC_MSG_CHECKING([for MEX options file handling])
case $mex_options in
  yes)
    AC_MSG_RESULT([standard])
    mexopts_sh=
    ;;
  no)
    AC_MSG_RESULT([disabled])
    mexopts_sh=$ac_aux_dir/noopts.sh
    ;;
  *)
    AC_MSG_RESULT([enabled])
    mexopts_sh=$mex_options
    ;;
esac
if test -n "$mexopts_sh" ; then
    AC_MSG_CHECKING([whether MEX options file exists])
    if test -f "$mexopts_sh" ; then
	AC_MSG_RESULT([yes])
	# Canonicalize file name.
	mexopts_sh_dir=`echo "$mexopts_sh" | sed 's,[[^/]]*$,,'`
	mexopts_sh_dir=`cd "${mexopts_sh_dir-.}" && pwd`
	mexopts_sh_name=`echo "$mexopts_sh" | sed 's,.*/,,'`
	mexopts_sh="$mexopts_sh_dir/$mexopts_sh_name"
    else
	AC_MSG_RESULT([no])
	AC_MSG_ERROR([$mexopts_sh: no such file])
    fi
    MEXOPTS="-f $mexopts_sh"
else
    MEXOPTS=
fi
AC_SUBST([mexopts_sh])
AC_SUBST([MEXOPTS])
])

dnl mexopt.m4 ends here
