dnl ccmex.m4 --- check how to compile c programs using mex
dnl
dnl Copyright (C) 2007 Duncan Brown
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:    

# AX_CC_MEX
# ------------
# Check for the flags needed to build a file with mex
AC_DEFUN([AX_CC_MEX],
[dnl
AC_REQUIRE([AX_PATH_MEX])
AC_REQUIRE([AX_DOT_MEXEXT])
AC_LANG([C])

dnl Source code for the test matlab C program
ac_mex_source='[#include "mex.h"
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) { return; }]'

dnl Check that the test C program can be compiled with mex
ac_exeext_save=$ac_exeext
ac_exeext=$MEXEXT
ac_link_save=$ac_link
ac_link='$MEX $MEXOPTS $MEXFLAGS -output conftest$ac_exeext conftest.$ac_ext $MEXLDADD >&AS_MESSAGE_LOG_FD'
AC_MSG_CHECKING([if mex works])
AC_LINK_IFELSE([AC_LANG_SOURCE($ac_mex_source)],
[AC_MSG_RESULT([yes])],
[AC_MSG_RESULT([no])])

dnl Try to figure out how mex compiles a C program
ax_cv_mex_version=
ac_cv_mex_cppflags=
ac_cv_mex_includes=
ac_cv_mex_cflags=
ac_cv_mex_libs=
ac_cv_mex_ldflags=

dnl Variable that will be subsituted
MEX_VERSION_C=
MEX_LDFLAGS=
MEX_CPPFLAGS=
MEX_INCLUDES=
MEX_CFLAGS=
MEX_LIBS=
MEX_LDFLAGS=

AC_MSG_CHECKING([if mex -n works])
ac_save_MEXOPTS=$MEXOPTS
MEXOPTS="-n $MEXOPTS"
AC_LANG_CONFTEST([AC_LANG_SOURCE($ac_mex_source)])
(eval echo $as_me:__oline__: \"$ac_link\") >&AS_MESSAGE_LOG_FD
ac_cv_mex_n_output=`eval $ac_link AS_MESSAGE_LOG_FD>&1 2>&1`
ac_cv_mex_n_result=$?
echo "$ac_cv_mex_n_output" >&AS_MESSAGE_LOG_FD
MEXOPTS=$ac_save_MEXOPTS
rm -f conftest*
ac_exeext=$ac_exeext_save
ac_link=$ac_link_save

if test $ac_cv_mex_n_result -eq 0 ; then
  ac_cv_mex_working=yes
  AC_MSG_RESULT([$ac_cv_mex_working])

  dnl Save positional arguments (if any)
  ac_save_positional="$[@]"

  set X $ac_cv_mex_n_output
  while test $[@%:@] != 1; do
    shift
      ac_arg=$[1]
      case $ac_arg in
        *mexversion.c)
          ax_cv_mex_version=$ac_arg
          ;;
        -pthread)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -mt)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -ansi)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          ;;
        -D*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          ;;
        -I*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_includes, ,
            ac_cv_mex_includes="$ac_cv_mex_includes $ac_arg")
          ;;
        -f* | -O* | -xO* | -xlibmil )
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          ;;
        -l*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_libs, ,
            ac_cv_mex_libs="$ac_cv_mex_libs $ac_arg")
          ;;
        -L)
          # When -L is seen by itself, it takes an argument
          # We remove the space between option and argument and re-iterate
          # unless we find an empty arg or a new option (starting with -)
          case $[2] in
             "" | -*);;
             *)
             ac_arg="$ac_arg$[2]"
             shift; shift
             set X $ac_arg "$[@]"
             ;;
           esac
           ;;
        -L* | -Wl,* | -shared | -bundle | -G)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -undefined)
          # the darwin linker undefined option takes and argument
          ac_arg="$ac_arg $[2]"
          shift
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;   
          # ignore everything else
      esac
  done
  
  # restore positional arguments
  set X $ac_save_positional; shift

  MEX_VERSION_C=$ax_cv_mex_version

  AC_MSG_CHECKING([for CPPFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_cppflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_CPPFLAGS=`echo $ac_cv_mex_cppflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_CPPFLAGS])
  fi
  AC_MSG_CHECKING([for INCLUDES needed to build mex objects])
  if test "x$ac_cv_mex_includes" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_INCLUDES=`echo $ac_cv_mex_includes | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_INCLUDES])
  fi
  AC_MSG_CHECKING([for CFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_cflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_CFLAGS=`echo $ac_cv_mex_cflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_CFLAGS])
  fi
  AC_MSG_CHECKING([for LIBS needed to build mex objects])
  if test "x$ac_cv_mex_libs" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_LIBS=`echo $ac_cv_mex_libs | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_LIBS])
  fi
  AC_MSG_CHECKING([for LDFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_ldflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_LDFLAGS=`echo $ac_cv_mex_ldflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_LDFLAGS])
  fi
else
  ac_cv_mex_working=no
  AC_MSG_RESULT([$ac_cv_mex_working])
fi

AC_SUBST(MEX_VERSION_C)
AC_SUBST(MEX_CPPFLAGS)
AC_SUBST(MEX_INCLUDES)
AC_SUBST(MEX_CFLAGS)
AC_SUBST(MEX_LIBS)
AC_SUBST(MEX_LDFLAGS)

])

# AX_MEX_CONDITIONAL
# ---------------------
# Define Matlab conditional for GNU Automake.
AC_DEFUN([AX_MEX_CONDITIONAL],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_CC_MEX])
AM_CONDITIONAL(MEX, test x$ac_cv_mex_working = xyes)
AM_CONDITIONAL(MEX_VERSION_C, test x$ax_cv_mex_version != x)
])

dnl ccmex.m4 ends here
