/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import edu.sdsc.nbcr.opal.manager.condorAPI.Cluster;
import edu.sdsc.nbcr.opal.manager.condorAPI.Condor;
import edu.sdsc.nbcr.opal.manager.condorAPI.CondorException;
import edu.sdsc.nbcr.opal.manager.condorAPI.Job;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobDescription;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CondorJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)CondorJobManager.class.getName());
    private Properties props;
    private AppConfigType config;
    private StatusOutputType status;
    private String handle;
    private boolean started = false;
    private volatile boolean done = false;
    private Job job;
    private Condor condor;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.debug((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
        this.condor = new Condor();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.debug((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.debug((Object)"called");
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String cmd = null;
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            String mpiScript = this.props.getProperty("mpi.script");
            if (mpiScript == null) {
                String msg = "Can't find property mpi.script for running parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            cmd = mpiScript;
            String newArgs = this.config.getBinaryLocation();
            args = args != null && !args.equals("") ? newArgs + " " + args : newArgs;
            logger.debug((Object)("CMD: " + cmd + " " + args));
        } else {
            cmd = this.config.getBinaryLocation();
            if (args == null) {
                args = "";
            }
            logger.debug((Object)("CMD: " + cmd + " " + args));
        }
        long hardLimit = 0L;
        if (this.props.getProperty("opal.hard_limit") != null) {
            hardLimit = Long.parseLong(this.props.getProperty("opal.hard_limit"));
            logger.debug((Object)("All jobs have a hard limit of " + hardLimit + " seconds"));
        }
        try {
            String condorExprFileName;
            logger.debug((Object)("Working directory: " + workingDir));
            JobDescription jd = new JobDescription();
            if (this.config.isParallel()) {
                jd.addAttribute("universe", "parallel");
                jd.addAttribute("machine_count", Integer.toString(numProcs));
            } else {
                jd.addAttribute("universe", "vanilla");
            }
            jd.addAttribute("getenv", "true");
            jd.addAttribute("executable", cmd);
            jd.addAttribute("arguments", args);
            jd.addAttribute("initialdir", workingDir);
            jd.addAttribute("output", workingDir + "stdout.txt");
            jd.addAttribute("error", workingDir + "stderr.txt");
            jd.addAttribute("log", workingDir + "condor.log");
            jd.addAttribute("log_xml", "true");
            jd.addAttribute("should_transfer_files", "yes");
            jd.addAttribute("when_to_transfer_output", "on_exit");
            jd.addAttribute("notification", "never");
            jd.addAttribute("transfer_input_files", this.config.getBinaryLocation());
            File wd = new File(workingDir);
            String[] wdFiles = wd.list();
            if (wdFiles != null) {
                for (int i = 0; i < wdFiles.length; ++i) {
                    jd.addAttribute("transfer_input_files", workingDir + File.separator + wdFiles[i]);
                }
            }
            if ((condorExprFileName = this.props.getProperty("condor.expr.file")) != null) {
                try {
                    Properties condorProps = new Properties();
                    FileInputStream in = new FileInputStream(condorExprFileName);
                    condorProps.load(in);
                    in.close();
                    Enumeration<Object> keys = condorProps.keys();
                    while (keys.hasMoreElements()) {
                        String condorKey = keys.nextElement().toString();
                        String condorVal = condorProps.getProperty(condorKey);
                        if (condorVal == null) continue;
                        jd.addAttribute(condorKey, condorVal);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to load " + condorExprFileName + "identified by condor.expr.file: " + e.getMessage()));
                }
            }
            jd.addQueue();
            this.condor.setLogFile(workingDir + "condor.log", 5);
            Cluster cluster = this.condor.submit(jd);
            this.job = cluster.getJob(0);
            this.handle = this.job.getJobId().toString();
            logger.info((Object)("Condor job id=" + this.handle + " has been submitted"));
        }
        catch (Exception e) {
            String msg = "Error while running executable via Condor - " + e.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.started = true;
        return this.handle;
    }

    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.debug((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.job.waitForRun();
        }
        catch (CondorException e) {
            String msg = "Can't wait for activation of Condor job: " + this.handle;
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        this.status.setCode(2);
        this.status.setMessage("Execution in progress");
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.debug((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.job.waitFor();
        }
        catch (CondorException e) {
            String msg = "Exception while waiting for process to finish";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        int exitValue = this.job.getStatus();
        if (exitValue == 4) {
            this.status.setCode(8);
            this.status.setMessage("Execution complete - check outputs to verify successful execution");
        } else {
            this.status.setCode(4);
            this.status.setMessage("Execution failed - process exited with value " + exitValue);
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.debug((Object)"called");
        if (!this.started) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.condor.rm(this.job);
        }
        catch (CondorException e) {
            String msg = "Exception while trying to destroy condor job";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }
}

