/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.state;

import edu.sdsc.nbcr.opal.JobOutputType;
import edu.sdsc.nbcr.opal.JobStatisticsType;
import edu.sdsc.nbcr.opal.OutputFileType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.state.JobInfo;
import edu.sdsc.nbcr.opal.state.JobOutput;
import edu.sdsc.nbcr.opal.state.OutputFile;
import edu.sdsc.nbcr.opal.state.ServiceStatus;
import edu.sdsc.nbcr.opal.state.StateManagerException;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HibernateUtil {
    private static Logger logger = Logger.getLogger((String)HibernateUtil.class.getName());
    private static SessionFactory sessionFactory = null;
    private static String confFile = "hibernate-opal.cfg.xml";

    private static SessionFactory buildSessionFactory() {
        try {
            Configuration conf = new Configuration();
            conf = conf.configure(confFile);
            SessionFactory sessionFactoryTemp = conf.buildSessionFactory();
            return sessionFactoryTemp;
        }
        catch (HibernateException ex) {
            logger.error((Object)("Initial SessionFactory creation failed." + (Object)((Object)ex)));
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void setConfFile(String conf) {
        confFile = conf;
    }

    public static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            sessionFactory = HibernateUtil.buildSessionFactory();
        }
        return sessionFactory;
    }

    public static boolean saveJobInfoInDatabase(JobInfo info) throws StateManagerException {
        logger.debug((Object)"called");
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            session.save((Object)info);
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error during database update: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return true;
    }

    public static int markZombieJobs() throws StateManagerException {
        logger.debug((Object)"called");
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            java.util.Date lastUpdate = new java.util.Date();
            int numUpdates = session.createQuery("update JobInfo info set info.lastUpdateDate = :lastUpdateDate, info.lastUpdateTime = :lastUpdateTime, info.code = :code, info.message = :message where info.code != 8and info.code != 4").setDate("lastUpdateDate", lastUpdate).setTime("lastUpdateTime", lastUpdate).setInteger("code", 4).setString("message", "Job failed - server was restarted during job execution").executeUpdate();
            session.getTransaction().commit();
            session.close();
            return numUpdates;
        }
        catch (HibernateException ex) {
            String msg = "Error during database update: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
    }

    public static int updateJobInfoInDatabase(String jobID, int code, String message, String baseURL, String handle) throws StateManagerException {
        logger.debug((Object)"called");
        return HibernateUtil.updateJobInfoInDatabase(jobID, code, message, baseURL, null, null, handle);
    }

    public static int updateJobInfoInDatabase(String jobID, int code, String message, String baseURL, java.util.Date activationTime, java.util.Date completionTime, String handle) throws StateManagerException {
        logger.debug((Object)"called");
        logger.debug((Object)("Updating status to: " + message));
        int numRows = 1;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            java.util.Date lastUpdate = new java.util.Date();
            String queryString = "update JobInfo info set info.lastUpdateDate = :lastUpdateDate, info.lastUpdateTime = :lastUpdateTime, info.code = :code, info.message = :message, info.baseURL = :baseURL, ";
            if (activationTime != null) {
                queryString = queryString + "info.activationTimeTime = :activationTimeTime, ";
                queryString = queryString + "info.activationTimeDate = :activationTimeDate, ";
            }
            if (completionTime != null) {
                queryString = queryString + "info.completionTimeTime = :completionTimeTime, ";
                queryString = queryString + "info.completionTimeDate = :completionTimeDate, ";
            }
            queryString = queryString + "info.handle = :handle where info.jobID = '" + jobID + "'";
            Query query = session.createQuery(queryString);
            query.setDate("lastUpdateDate", lastUpdate).setTime("lastUpdateTime", lastUpdate).setInteger("code", code).setString("message", message).setString("baseURL", baseURL).setString("handle", handle);
            if (activationTime != null) {
                query.setDate("activationTimeDate", activationTime);
                query.setTime("activationTimeTime", activationTime);
            }
            if (completionTime != null) {
                query.setDate("completionTimeDate", completionTime);
                query.setTime("completionTimeTime", completionTime);
            }
            numRows = query.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error during database update: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        if (numRows != 1) {
            String msg = "Unable to update status for job: " + jobID;
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        logger.debug((Object)("Updated status for job: " + jobID));
        return numRows;
    }

    public static boolean saveOutputsInDatabase(String jobID, JobOutputType outputs) throws StateManagerException {
        logger.debug((Object)"called");
        try {
            int i;
            Session session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            List results = session.createCriteria(JobInfo.class).add((Criterion)Restrictions.eq((String)"jobID", (Object)jobID)).list();
            if (results.size() != 1) {
                session.close();
                throw new StateManagerException("Can't find job info for job: " + jobID);
            }
            JobInfo info = (JobInfo)results.get(0);
            JobOutput out = new JobOutput();
            out.setJob(info);
            out.setStdOut(outputs.getStdOut().toString());
            out.setStdErr(outputs.getStdErr().toString());
            OutputFile[] files = new OutputFile[outputs.getOutputFile().length];
            for (i = 0; i < outputs.getOutputFile().length; ++i) {
                files[i] = new OutputFile();
                files[i].setJob(info);
                files[i].setName(outputs.getOutputFile()[i].getName());
                files[i].setUrl(outputs.getOutputFile()[i].getUrl().toString());
            }
            session.save((Object)out);
            for (i = 0; i < files.length; ++i) {
                session.save((Object)files[i]);
            }
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error during database update: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return true;
    }

    public static StatusOutputType getStatus(String jobID) throws StateManagerException {
        logger.debug((Object)"called");
        StatusOutputType status = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            List results = session.createCriteria(JobInfo.class).add((Criterion)Restrictions.eq((String)"jobID", (Object)jobID)).list();
            if (results.size() == 1) {
                JobInfo info = (JobInfo)results.get(0);
                status = new StatusOutputType();
                status.setCode(info.getCode());
                status.setMessage(info.getMessage());
                try {
                    status.setBaseURL(new URI(info.getBaseURL()));
                }
                catch (URI.MalformedURIException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error while getting status from database: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        if (status == null) {
            String msg = "Can't retrieve status for job: " + jobID;
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return status;
    }

    public static JobStatisticsType getStatistics(String jobID) throws StateManagerException {
        logger.debug((Object)"called");
        JobStatisticsType stats = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            List results = session.createCriteria(JobInfo.class).add((Criterion)Restrictions.eq((String)"jobID", (Object)jobID)).list();
            if (results.size() == 1) {
                JobInfo info = (JobInfo)results.get(0);
                stats = new JobStatisticsType();
                Calendar startTime = Calendar.getInstance();
                TimeZone tz = TimeZone.getDefault();
                long dateOffsetRaw = tz.getRawOffset();
                startTime.setTimeInMillis(info.getStartTimeTime().getTime() + info.getStartTimeDate().getTime() + dateOffsetRaw);
                stats.setStartTime(startTime);
                if (info.getActivationTimeTime() != null && info.getActivationTimeDate() != null) {
                    Calendar activationTime = Calendar.getInstance();
                    activationTime.setTimeInMillis(info.getActivationTimeTime().getTime() + info.getActivationTimeDate().getTime() + dateOffsetRaw);
                    stats.setActivationTime(activationTime);
                }
                if (info.getCompletionTimeTime() != null && info.getCompletionTimeDate() != null) {
                    Calendar completionTime = Calendar.getInstance();
                    completionTime.setTimeInMillis(info.getCompletionTimeTime().getTime() + info.getCompletionTimeDate().getTime() + dateOffsetRaw);
                    stats.setCompletionTime(completionTime);
                }
            }
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error while getting statistics from database: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        if (stats == null) {
            String msg = "Can't retrieve statistics for job: " + jobID;
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return stats;
    }

    public static JobOutputType getOutputs(String jobID) throws StateManagerException {
        logger.debug((Object)"called");
        JobOutputType outputs = new JobOutputType();
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            List results = session.createQuery("from JobOutput output left join fetch output.job where output.job.jobID = '" + jobID + "'").list();
            JobOutput output = null;
            if (results.size() != 1) {
                String msg = "Can't get job outputs for job: " + jobID;
                logger.error((Object)msg);
                throw new StateManagerException(msg);
            }
            output = (JobOutput)results.get(0);
            try {
                outputs.setStdOut(new URI(output.getStdOut()));
                outputs.setStdErr(new URI(output.getStdErr()));
            }
            catch (URI.MalformedURIException e) {
                String msg = "Can't set URI for stdout/stderr for job: " + e.getMessage();
                logger.error((Object)msg);
                throw new StateManagerException(msg);
            }
            results = session.createQuery("from OutputFile file left join fetch file.job where file.job.jobID = '" + jobID + "'").list();
            if (results != null) {
                OutputFileType[] outputFileObj = new OutputFileType[results.size()];
                for (int i = 0; i < results.size(); ++i) {
                    OutputFile file = (OutputFile)results.get(i);
                    outputFileObj[i] = new OutputFileType();
                    outputFileObj[i].setName(file.getName());
                    try {
                        outputFileObj[i].setUrl(new URI(file.getUrl()));
                        continue;
                    }
                    catch (URI.MalformedURIException e) {
                        String msg = "Can't set URI for output file: " + e.getMessage();
                        logger.error((Object)msg);
                        throw new StateManagerException(msg);
                    }
                }
                outputs.setOutputFile(outputFileObj);
            }
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error while getting outputs from database: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return outputs;
    }

    public static long getNumJobsThisHour(String remoteIP) throws StateManagerException {
        logger.debug((Object)"called");
        Long numJobs = new Long(0L);
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            long timeNow = System.currentTimeMillis();
            long timePast = timeNow - 3600000L;
            Time endTimeSQL = new Time(timeNow);
            Date endDateSQL = new Date(timeNow);
            Time startTimeSQL = new Time(timePast);
            Date startDateSQL = new Date(timePast);
            String query = endDateSQL.toString().equals(startDateSQL.toString()) ? "select count(*)   from JobInfo jobInfo where  jobInfo.clientIP = :remoteIP  and jobInfo.startTimeTime >= :startTime  and jobInfo.startTimeTime <= :endTime  and jobInfo.startTimeDate = :startDate and jobInfo.startTimeDate = :endDate " : "select count(*)   from JobInfo jobInfo where  jobInfo.clientIP = :remoteIP  and (jobInfo.startTimeTime >= :startTime  and jobInfo.startTimeDate = :startDate) or (jobInfo.startTimeTime <= :endTime  and jobInfo.startTimeDate = :endDate) ";
            Query queryStat = session.createQuery(query);
            queryStat.setString("remoteIP", remoteIP).setTime("startTime", (java.util.Date)startTimeSQL).setTime("endTime", (java.util.Date)endTimeSQL).setDate("startDate", (java.util.Date)startDateSQL).setDate("endDate", (java.util.Date)endDateSQL);
            List results = queryStat.list();
            if (results.size() != 1) {
                session.close();
                String msg = "Error while trying to retrive number of jobs from database";
                throw new StateManagerException(msg);
            }
            numJobs = (Long)results.get(0);
            session.close();
        }
        catch (HibernateException he) {
            String msg = "Error while trying to retrieve hits from database: " + he.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return numJobs;
    }

    public static long getNumExecutingJobs() throws StateManagerException {
        logger.debug((Object)"called");
        Long numJobs = new Long(0L);
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            String query = "select count(*)   from JobInfo jobInfo where  jobInfo.code = :code";
            Query queryStat = session.createQuery(query);
            queryStat.setInteger("code", 2);
            List results = queryStat.list();
            if (results.size() != 1) {
                session.close();
                String msg = "Error while trying to retrive number of jobs from database";
                throw new StateManagerException(msg);
            }
            numJobs = (Long)results.get(0);
            session.close();
        }
        catch (HibernateException he) {
            String msg = "Error while trying to retrieve hits from database: " + he.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return numJobs;
    }

    public static long getNumPendingJobs() throws StateManagerException {
        logger.debug((Object)"called");
        Long numJobs = new Long(0L);
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            String query = "select count(*)   from JobInfo jobInfo where  jobInfo.code = :code";
            Query queryStat = session.createQuery(query);
            queryStat.setInteger("code", 1);
            List results = queryStat.list();
            if (results.size() != 1) {
                session.close();
                String msg = "Error while trying to retrive number of pending jobs from database";
                throw new StateManagerException(msg);
            }
            numJobs = (Long)results.get(0);
            session.close();
        }
        catch (HibernateException he) {
            String msg = "Error while trying to retrieve hits for pending jobs from database: " + he.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return numJobs;
    }

    public static boolean saveServiceStatus(ServiceStatus status) throws StateManagerException {
        logger.debug((Object)"called");
        Configuration conf = new Configuration();
        conf = conf.configure(confFile);
        String dialect = conf.getProperty("dialect");
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)status);
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error during database update: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return true;
    }

    public static ServiceStatus getServiceStatus(String serviceName) throws StateManagerException {
        logger.debug((Object)"called");
        ServiceStatus status = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            List results = session.createCriteria(ServiceStatus.class).add((Criterion)Restrictions.eq((String)"serviceName", (Object)serviceName)).list();
            if (results.size() == 1) {
                status = (ServiceStatus)results.get(0);
            }
            session.close();
        }
        catch (HibernateException ex) {
            String msg = "Error while getting status from database: " + ex.getMessage();
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        if (status == null) {
            String msg = "Can't retrieve status for service: " + serviceName;
            logger.error((Object)msg);
            throw new StateManagerException(msg);
        }
        return status;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Initializing hibernate");
        Session session = HibernateUtil.getSessionFactory().openSession();
        java.util.Date nowDate = new java.util.Date();
        JobInfo info = new JobInfo();
        String jobID = "app" + System.currentTimeMillis();
        info.setJobID(jobID);
        info.setCode(0);
        info.setMessage("This is a test");
        info.setBaseURL("http://localhost/test");
        info.setStartTimeTime(new Time(nowDate.getTime()));
        info.setStartTimeDate(new Date(nowDate.getTime()));
        info.setActivationTimeTime(new Time(nowDate.getTime()));
        info.setActivationTimeDate(new Date(nowDate.getTime()));
        info.setCompletionTimeTime(new Time(nowDate.getTime()));
        info.setCompletionTimeDate(new Date(nowDate.getTime()));
        info.setLastUpdateTime(new Time(nowDate.getTime()));
        info.setLastUpdateDate(new Date(nowDate.getTime()));
        info.setClientDN("CN=Test");
        info.setClientIP("127.0.0.1");
        info.setServiceName("Command-line");
        System.out.println("Trying to save JobInfo into database");
        HibernateUtil.saveJobInfoInDatabase(info);
        System.out.println("Saved JobInfo into database successfully");
        System.out.println("Trying to save job outputs into database");
        JobOutputType outputs = new JobOutputType();
        outputs.setStdOut(new URI("http://localhost/test/stdout.txt"));
        outputs.setStdErr(new URI("http://localhost/test/stderr.txt"));
        OutputFileType[] files = new OutputFileType[]{new OutputFileType()};
        files[0].setName("foo.txt");
        files[0].setUrl(new URI("http://localhost/test/foo.txt"));
        outputs.setOutputFile(files);
        HibernateUtil.saveOutputsInDatabase(jobID, outputs);
        System.out.println("Saved OutputFile into database successfully");
        System.out.println("Update job info for job: " + jobID);
        HibernateUtil.updateJobInfoInDatabase(jobID, 1, "This is a test update", info.getBaseURL(), "testHandle");
        System.out.println("Searching for status for job: " + jobID);
        StatusOutputType status = HibernateUtil.getStatus(jobID);
        System.out.println("Job Status: " + jobID + " - {" + status.getCode() + ", " + status.getMessage() + ", " + status.getBaseURL() + "}");
        System.out.println("Searching for statistics for job: " + jobID);
        JobStatisticsType stats = HibernateUtil.getStatistics(jobID);
        System.out.println("Job Statistics: " + jobID + " - {" + stats.getStartTime().getTime() + ", " + stats.getActivationTime().getTime() + ", " + stats.getCompletionTime().getTime() + "}");
        System.out.println("Searching for job outputs for job: " + jobID);
        outputs = HibernateUtil.getOutputs(jobID);
        System.out.println("Standard output: " + outputs.getStdOut());
        System.out.println("Standard error: " + outputs.getStdErr());
        files = outputs.getOutputFile();
        for (int i = 0; i < files.length; ++i) {
            System.out.println(files[i].getName() + ": " + files[i].getUrl());
        }
        ServiceStatus serviceStatus = new ServiceStatus();
        String serviceName = "FooService";
        serviceStatus.setServiceName(serviceName);
        serviceStatus.setStatus("ACTIVE");
        System.out.println("Saving service status for service: " + serviceName);
        HibernateUtil.saveServiceStatus(serviceStatus);
        System.out.println("Retrieving status for service: " + serviceName);
        serviceStatus = HibernateUtil.getServiceStatus(serviceName);
        System.out.println("Service status is: " + serviceStatus.getStatus());
    }
}

