/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.GlobusJobManager;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import java.io.File;
import org.apache.log4j.Logger;
import org.globus.ftp.FileInfo;
import org.globus.ftp.GridFTPClient;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.io.urlcopy.UrlCopy;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class RemoteGlobusJobManager
extends GlobusJobManager {
    private static Logger logger = Logger.getLogger((String)RemoteGlobusJobManager.class.getName());
    private String workingDir;
    private String gridFTPBase;
    private GSSCredential gssCred;

    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        this.workingDir = workingDir;
        String serviceCertPath = this.props.getProperty("globus.service_cert");
        if (serviceCertPath == null) {
            String msg = "Can't find property: globus.service_cert";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String serviceKeyPath = this.props.getProperty("globus.service_privkey");
        if (serviceKeyPath == null) {
            String msg = "Can't find property: globus.service_privkey";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.gridFTPBase = this.props.getProperty("globus.gridftp_base");
        if (this.config.getGridftpBase() != null) {
            this.gridFTPBase = this.config.getGridftpBase().toString();
        }
        String remoteDir = null;
        File wd = new File(workingDir);
        try {
            GlobusCredential globusCred = new GlobusCredential(serviceCertPath, serviceKeyPath);
            this.gssCred = new GlobusGSSCredentialImpl(globusCred, 0);
            GlobusURL baseURL = new GlobusURL(this.gridFTPBase);
            GridFTPClient client = new GridFTPClient(baseURL.getHost(), baseURL.getPort());
            client.authenticate(this.gssCred);
            remoteDir = baseURL.getPath() + File.separator + wd.getName();
            client.makeDir(remoteDir);
            String[] inputFiles = wd.list();
            for (int i = 0; i < inputFiles.length; ++i) {
                logger.info((Object)("Staging input file: " + inputFiles[i]));
                UrlCopy uc = new UrlCopy();
                uc.setDestinationUrl(new GlobusURL(this.gridFTPBase + "/" + wd.getName() + "/" + inputFiles[i]));
                uc.setSourceUrl(new GlobusURL("file:///" + workingDir + "/" + inputFiles[i]));
                uc.setCredentials(this.gssCred);
                uc.copy();
            }
        }
        catch (Exception e) {
            String msg = "Exception while preparing and staging input files";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        return super.launchJob(argList, numProcs, remoteDir);
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.info((Object)"called");
        super.waitForCompletion();
        try {
            GlobusURL baseURL = new GlobusURL(this.gridFTPBase);
            GridFTPClient client = new GridFTPClient(baseURL.getHost(), baseURL.getPort());
            client.authenticate(this.gssCred);
            client.setPassive();
            client.setLocalActive();
            File wd = new File(this.workingDir);
            String remoteDir = baseURL.getPath() + File.separator + wd.getName();
            client.changeDir(remoteDir);
            Object[] remoteFiles = client.list().toArray();
            for (int i = 0; i < remoteFiles.length; ++i) {
                FileInfo fileInfo = (FileInfo)remoteFiles[i];
                if (!fileInfo.isFile()) continue;
                String fileName = fileInfo.getName();
                logger.info((Object)("Staging output file: " + fileName));
                UrlCopy uc = new UrlCopy();
                uc.setSourceUrl(new GlobusURL(this.gridFTPBase + "/" + wd.getName() + "/" + fileName));
                uc.setDestinationUrl(new GlobusURL("file:///" + this.workingDir + "/" + fileName));
                uc.setCredentials(this.gssCred);
                uc.copy();
            }
        }
        catch (Exception e) {
            String msg = "Exception while staging output files";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        return this.status;
    }
}

