/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.common;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSContextImpl;
import org.globus.security.gridmap.GridMap;

public class CAAuthHandler
extends BasicHandler {
    private String caMapLoc = null;
    private static Logger logger = Logger.getLogger((String)CAAuthHandler.class.getName());

    public void init() {
        super.init();
        this.caMapLoc = (String)this.getOption("ca-map");
        if (this.caMapLoc == null) {
            logger.error((Object)"Property ca-map not set");
        } else {
            logger.info((Object)("Location of ca-map: " + this.caMapLoc));
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        String issuerDN;
        block11: {
            logger.info((Object)"entering");
            Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (tmp == null || !(tmp instanceof HttpServletRequest)) {
                logger.info((Object)"exiting");
                return;
            }
            HttpServletRequest req = (HttpServletRequest)tmp;
            Object userDN = req.getAttribute("org.globus.gsi.authorized.user.dn");
            if (userDN == null) {
                logger.info((Object)"exiting");
                return;
            }
            logger.info((Object)("Client's DN: " + userDN));
            Object gssContext = req.getAttribute("org.globus.gsi.context");
            issuerDN = null;
            try {
                if (gssContext != null) {
                    Object certs = ((GlobusGSSContextImpl)gssContext).inquireByOid(GSSConstants.X509_CERT_CHAIN);
                    if (certs != null) {
                        X509Certificate[] chain = (X509Certificate[])certs;
                        logger.debug((Object)"Certificate chain - ");
                        for (int i = 0; i < chain.length; ++i) {
                            logger.debug((Object)chain[i].getSubjectDN());
                        }
                        issuerDN = ((Object)chain[chain.length - 1].getSubjectDN()).toString();
                        logger.info((Object)("Client's CA DN: " + issuerDN));
                    }
                    break block11;
                }
                logger.info((Object)"exiting");
                return;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new AxisFault("Error while reading certificate chain: " + e.getMessage());
            }
        }
        GridMap caMap = new GridMap();
        try {
            caMap.load(this.caMapLoc);
        }
        catch (IOException ioe) {
            logger.fatal((Object)"Can't load ca-map", (Throwable)ioe);
            throw new AxisFault("Can't load ca-map", (Throwable)ioe);
        }
        if (issuerDN == null) {
            logger.error((Object)"Can't find DN for the client's CA");
            throw new AxisFault("Can't find DN for the client's CA");
        }
        if (caMap.getUserID(issuerDN) == null) {
            logger.info((Object)"DN for the client's CA not on the ca-map");
            throw new AxisFault("CA: " + issuerDN + " does not have an entry on the ca-map");
        }
        logger.info((Object)"exiting");
    }
}

