//
// Generated by https://github.com/blacktop/ipsw (Version: 3.1.640, BuildCommit: Homebrew)
//
// - LC_BUILD_VERSION:  Platform: macOS, MinOS: 26, SDK: 26, Tool: ld (1220.3)
// - LC_SOURCE_VERSION: 716.0.8.0.0
//

@interface CKDownloadQueue : CKServiceInterface {
	NSMutableDictionary *_downloadsByItemID;
	NSLock *_downloadsLock;
	id _observerToken NS_AVAILABLE_MAC(13);
	NSLock *_tokenLock NS_AVAILABLE_MAC(13);
}

+ (nonnull instancetype)sharedDownloadQueue;

@property (retain, nonatomic, nullable) NSMutableDictionary<NSString *, CKDownloadQueueClient *> *downloadQueueObservers; // <NSString * _Nonnull, CKDownloadQueueClient * _Nonnull>
@property (readonly, nonatomic, nullable) NSArray<SSDownload *> *downloads; // Unverified generic type
@property (retain, nonatomic, nullable) CKDownloadQueueClient *sharedObserver;

- (void)addDownload:(nonnull SSDownload *)download;
- (nonnull NSString *)addObserver:(nullable id <CKDownloadQueueObserver>)observer;
- (nonnull NSString *)addObserver:(nullable id <CKDownloadQueueObserver>)observer forDownloadTypes:(long long)downloadTypes;
- (nonnull NSString *)addObserverForDownloadTypes:(long long)downloadTypes withBlock:(nullable UnknownBlock)block;
- (BOOL)cacheReceiptDataForDownload:(nullable SSDownload *)download;
- (void)cancelDownload:(nullable SSDownload *)download promptToConfirm:(BOOL)promptToConfirm askToDelete:(BOOL)askToDelete;
- (void)checkStoreDownloadQueueForAccount:(nullable ISStoreAccount *)account; // Unverified account type
- (void)connectionWasInterrupted;
- (nullable SSDownload *)downloadForItemIdentifier:(unsigned long long)identifier; // Unverified return type
- (void)fetchIconForItemIdentifier:(unsigned long long)identifier atURL:(nullable NSURL *)url replyBlock:(nonnull UnknownBlock)block;
- (nonnull instancetype)initWithStoreClient:(nullable ISStoreClient *)client; // Unverified client type
- (void)lockApplicationsForBundleID:(nullable NSString *)bundleID; // Unverified bundleID type
- (void)lockedApplicationTriedToLaunchAtPath:(nullable NSString *)path; // Unverified path type
- (void)pauseDownloadWithItemIdentifier:(unsigned long long)identifier;
- (void)performedIconAnimationForDownloadWithIdentifier:(unsigned long long)identifier;
- (void)removeDownloadWithItemIdentifier:(unsigned long long)identifier;
- (void)removeObserver:(nullable NSString *)observer; // Unverified observer type
- (void)resumeDownloadWithItemIdentifier:(unsigned long long)identifier;
- (void)unlockApplicationsWithBundleIdentifier:(nullable NSString *)bundleID; // Unverified bundleID type

@end
