%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: September 30, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedCoreProperties-6.1.0.txt
# Date: 2011-12-11, 18:26:55 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

% ================================================
*/

unicode_cased(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_cased(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_cased(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_cased(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

% Derived Property:   Cased (Cased)
%  As defined by Unicode Standard Definition D120
%  C has the Lowercase or Uppercase property or has a General_Category value of Titlecase_Letter.

unicode_cased(0x0041, 0x005A).	% Cased L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_cased(0x0061, 0x007A).	% Cased L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_cased(0x00AA, 0x00AA).	% Cased Lo       FEMININE ORDINAL INDICATOR
unicode_cased(0x00B5, 0x00B5).	% Cased L&       MICRO SIGN
unicode_cased(0x00BA, 0x00BA).	% Cased Lo       MASCULINE ORDINAL INDICATOR
unicode_cased(0x00C0, 0x00D6).	% Cased L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_cased(0x00D8, 0x00F6).	% Cased L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_cased(0x00F8, 0x01BA).	% Cased L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_cased(0x01BC, 0x01BF).	% Cased L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_cased(0x01C4, 0x0293).	% Cased L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_cased(0x0295, 0x02AF).	% Cased L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_cased(0x02B0, 0x02B8).	% Cased Lm   [9] MODIFIER LETTER SMALL H..MODIFIER LETTER SMALL Y
unicode_cased(0x02C0, 0x02C1).	% Cased Lm   [2] MODIFIER LETTER GLOTTAL STOP..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_cased(0x02E0, 0x02E4).	% Cased Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_cased(0x0345, 0x0345).	% Cased Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_cased(0x0370, 0x0373).	% Cased L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_cased(0x0376, 0x0377).	% Cased L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_cased(0x037A, 0x037A).	% Cased Lm       GREEK YPOGEGRAMMENI
unicode_cased(0x037B, 0x037D).	% Cased L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_cased(0x0386, 0x0386).	% Cased L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_cased(0x0388, 0x038A).	% Cased L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_cased(0x038C, 0x038C).	% Cased L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_cased(0x038E, 0x03A1).	% Cased L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_cased(0x03A3, 0x03F5).	% Cased L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_cased(0x03F7, 0x0481).	% Cased L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_cased(0x048A, 0x0527).	% Cased L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_cased(0x0531, 0x0556).	% Cased L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_cased(0x0561, 0x0587).	% Cased L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_cased(0x10A0, 0x10C5).	% Cased L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_cased(0x10C7, 0x10C7).	% Cased L&       GEORGIAN CAPITAL LETTER YN
unicode_cased(0x10CD, 0x10CD).	% Cased L&       GEORGIAN CAPITAL LETTER AEN
unicode_cased(0x1D00, 0x1D2B).	% Cased L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_cased(0x1D2C, 0x1D6A).	% Cased Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_cased(0x1D6B, 0x1D77).	% Cased L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_cased(0x1D78, 0x1D78).	% Cased Lm       MODIFIER LETTER CYRILLIC EN
unicode_cased(0x1D79, 0x1D9A).	% Cased L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_cased(0x1D9B, 0x1DBF).	% Cased Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_cased(0x1E00, 0x1F15).	% Cased L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_cased(0x1F18, 0x1F1D).	% Cased L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_cased(0x1F20, 0x1F45).	% Cased L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_cased(0x1F48, 0x1F4D).	% Cased L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_cased(0x1F50, 0x1F57).	% Cased L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_cased(0x1F59, 0x1F59).	% Cased L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_cased(0x1F5B, 0x1F5B).	% Cased L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_cased(0x1F5D, 0x1F5D).	% Cased L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_cased(0x1F5F, 0x1F7D).	% Cased L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_cased(0x1F80, 0x1FB4).	% Cased L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_cased(0x1FB6, 0x1FBC).	% Cased L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_cased(0x1FBE, 0x1FBE).	% Cased L&       GREEK PROSGEGRAMMENI
unicode_cased(0x1FC2, 0x1FC4).	% Cased L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_cased(0x1FC6, 0x1FCC).	% Cased L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_cased(0x1FD0, 0x1FD3).	% Cased L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_cased(0x1FD6, 0x1FDB).	% Cased L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_cased(0x1FE0, 0x1FEC).	% Cased L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_cased(0x1FF2, 0x1FF4).	% Cased L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_cased(0x1FF6, 0x1FFC).	% Cased L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_cased(0x2071, 0x2071).	% Cased Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_cased(0x207F, 0x207F).	% Cased Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_cased(0x2090, 0x209C).	% Cased Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_cased(0x2102, 0x2102).	% Cased L&       DOUBLE-STRUCK CAPITAL C
unicode_cased(0x2107, 0x2107).	% Cased L&       EULER CONSTANT
unicode_cased(0x210A, 0x2113).	% Cased L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_cased(0x2115, 0x2115).	% Cased L&       DOUBLE-STRUCK CAPITAL N
unicode_cased(0x2119, 0x211D).	% Cased L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_cased(0x2124, 0x2124).	% Cased L&       DOUBLE-STRUCK CAPITAL Z
unicode_cased(0x2126, 0x2126).	% Cased L&       OHM SIGN
unicode_cased(0x2128, 0x2128).	% Cased L&       BLACK-LETTER CAPITAL Z
unicode_cased(0x212A, 0x212D).	% Cased L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_cased(0x212F, 0x2134).	% Cased L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_cased(0x2139, 0x2139).	% Cased L&       INFORMATION SOURCE
unicode_cased(0x213C, 0x213F).	% Cased L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_cased(0x2145, 0x2149).	% Cased L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_cased(0x214E, 0x214E).	% Cased L&       TURNED SMALL F
unicode_cased(0x2160, 0x217F).	% Cased Nl  [32] ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_cased(0x2183, 0x2184).	% Cased L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_cased(0x24B6, 0x24E9).	% Cased So  [52] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_cased(0x2C00, 0x2C2E).	% Cased L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_cased(0x2C30, 0x2C5E).	% Cased L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_cased(0x2C60, 0x2C7B).	% Cased L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_cased(0x2C7C, 0x2C7D).	% Cased Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_cased(0x2C7E, 0x2CE4).	% Cased L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_cased(0x2CEB, 0x2CEE).	% Cased L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_cased(0x2CF2, 0x2CF3).	% Cased L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_cased(0x2D00, 0x2D25).	% Cased L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_cased(0x2D27, 0x2D27).	% Cased L&       GEORGIAN SMALL LETTER YN
unicode_cased(0x2D2D, 0x2D2D).	% Cased L&       GEORGIAN SMALL LETTER AEN
unicode_cased(0xA640, 0xA66D).	% Cased L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_cased(0xA680, 0xA697).	% Cased L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_cased(0xA722, 0xA76F).	% Cased L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_cased(0xA770, 0xA770).	% Cased Lm       MODIFIER LETTER US
unicode_cased(0xA771, 0xA787).	% Cased L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_cased(0xA78B, 0xA78E).	% Cased L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_cased(0xA790, 0xA793).	% Cased L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_cased(0xA7A0, 0xA7AA).	% Cased L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_cased(0xA7F8, 0xA7F9).	% Cased Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_cased(0xA7FA, 0xA7FA).	% Cased L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_cased(0xFB00, 0xFB06).	% Cased L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_cased(0xFB13, 0xFB17).	% Cased L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_cased(0xFF21, 0xFF3A).	% Cased L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_cased(0xFF41, 0xFF5A).	% Cased L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_cased(0x10400, 0x1044F).	% Cased L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_cased(0x1D400, 0x1D454).	% Cased L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_cased(0x1D456, 0x1D49C).	% Cased L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_cased(0x1D49E, 0x1D49F).	% Cased L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_cased(0x1D4A2, 0x1D4A2).	% Cased L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_cased(0x1D4A5, 0x1D4A6).	% Cased L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_cased(0x1D4A9, 0x1D4AC).	% Cased L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_cased(0x1D4AE, 0x1D4B9).	% Cased L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_cased(0x1D4BB, 0x1D4BB).	% Cased L&       MATHEMATICAL SCRIPT SMALL F
unicode_cased(0x1D4BD, 0x1D4C3).	% Cased L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_cased(0x1D4C5, 0x1D505).	% Cased L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_cased(0x1D507, 0x1D50A).	% Cased L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_cased(0x1D50D, 0x1D514).	% Cased L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_cased(0x1D516, 0x1D51C).	% Cased L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_cased(0x1D51E, 0x1D539).	% Cased L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_cased(0x1D53B, 0x1D53E).	% Cased L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_cased(0x1D540, 0x1D544).	% Cased L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_cased(0x1D546, 0x1D546).	% Cased L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_cased(0x1D54A, 0x1D550).	% Cased L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_cased(0x1D552, 0x1D6A5).	% Cased L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_cased(0x1D6A8, 0x1D6C0).	% Cased L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_cased(0x1D6C2, 0x1D6DA).	% Cased L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_cased(0x1D6DC, 0x1D6FA).	% Cased L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_cased(0x1D6FC, 0x1D714).	% Cased L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_cased(0x1D716, 0x1D734).	% Cased L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_cased(0x1D736, 0x1D74E).	% Cased L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_cased(0x1D750, 0x1D76E).	% Cased L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_cased(0x1D770, 0x1D788).	% Cased L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_cased(0x1D78A, 0x1D7A8).	% Cased L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_cased(0x1D7AA, 0x1D7C2).	% Cased L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_cased(0x1D7C4, 0x1D7CB).	% Cased L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA

% Total code points: 3448
