%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%  This file is part of VivoMind Prolog Unicode Resources  
%  
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: September 30, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedCoreProperties-6.1.0.txt
# Date: 2011-12-11, 18:26:55 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

% ================================================
*/

unicode_math(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_math(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_math(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_math(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

% Derived Property: Math
%  Generated from: Sm + Other_Math

unicode_math(0x002B, 0x002B).	% Math Sm       PLUS SIGN
unicode_math(0x003C, 0x003E).	% Math Sm   [3] LESS-THAN SIGN..GREATER-THAN SIGN
unicode_math(0x005E, 0x005E).	% Math Sk       CIRCUMFLEX ACCENT
unicode_math(0x007C, 0x007C).	% Math Sm       VERTICAL LINE
unicode_math(0x007E, 0x007E).	% Math Sm       TILDE
unicode_math(0x00AC, 0x00AC).	% Math Sm       NOT SIGN
unicode_math(0x00B1, 0x00B1).	% Math Sm       PLUS-MINUS SIGN
unicode_math(0x00D7, 0x00D7).	% Math Sm       MULTIPLICATION SIGN
unicode_math(0x00F7, 0x00F7).	% Math Sm       DIVISION SIGN
unicode_math(0x03D0, 0x03D2).	% Math L&   [3] GREEK BETA SYMBOL..GREEK UPSILON WITH HOOK SYMBOL
unicode_math(0x03D5, 0x03D5).	% Math L&       GREEK PHI SYMBOL
unicode_math(0x03F0, 0x03F1).	% Math L&   [2] GREEK KAPPA SYMBOL..GREEK RHO SYMBOL
unicode_math(0x03F4, 0x03F5).	% Math L&   [2] GREEK CAPITAL THETA SYMBOL..GREEK LUNATE EPSILON SYMBOL
unicode_math(0x03F6, 0x03F6).	% Math Sm       GREEK REVERSED LUNATE EPSILON SYMBOL
unicode_math(0x0606, 0x0608).	% Math Sm   [3] ARABIC-INDIC CUBE ROOT..ARABIC RAY
unicode_math(0x2016, 0x2016).	% Math Po       DOUBLE VERTICAL LINE
unicode_math(0x2032, 0x2034).	% Math Po   [3] PRIME..TRIPLE PRIME
unicode_math(0x2040, 0x2040).	% Math Pc       CHARACTER TIE
unicode_math(0x2044, 0x2044).	% Math Sm       FRACTION SLASH
unicode_math(0x2052, 0x2052).	% Math Sm       COMMERCIAL MINUS SIGN
unicode_math(0x2061, 0x2064).	% Math Cf   [4] FUNCTION APPLICATION..INVISIBLE PLUS
unicode_math(0x207A, 0x207C).	% Math Sm   [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
unicode_math(0x207D, 0x207D).	% Math Ps       SUPERSCRIPT LEFT PARENTHESIS
unicode_math(0x207E, 0x207E).	% Math Pe       SUPERSCRIPT RIGHT PARENTHESIS
unicode_math(0x208A, 0x208C).	% Math Sm   [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
unicode_math(0x208D, 0x208D).	% Math Ps       SUBSCRIPT LEFT PARENTHESIS
unicode_math(0x208E, 0x208E).	% Math Pe       SUBSCRIPT RIGHT PARENTHESIS
unicode_math(0x20D0, 0x20DC).	% Math Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_math(0x20E1, 0x20E1).	% Math Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_math(0x20E5, 0x20E6).	% Math Mn   [2] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING DOUBLE VERTICAL STROKE OVERLAY
unicode_math(0x20EB, 0x20EF).	% Math Mn   [5] COMBINING LONG DOUBLE SOLIDUS OVERLAY..COMBINING RIGHT ARROW BELOW
unicode_math(0x2102, 0x2102).	% Math L&       DOUBLE-STRUCK CAPITAL C
unicode_math(0x2107, 0x2107).	% Math L&       EULER CONSTANT
unicode_math(0x210A, 0x2113).	% Math L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_math(0x2115, 0x2115).	% Math L&       DOUBLE-STRUCK CAPITAL N
unicode_math(0x2118, 0x2118).	% Math Sm       SCRIPT CAPITAL P
unicode_math(0x2119, 0x211D).	% Math L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_math(0x2124, 0x2124).	% Math L&       DOUBLE-STRUCK CAPITAL Z
unicode_math(0x2128, 0x2128).	% Math L&       BLACK-LETTER CAPITAL Z
unicode_math(0x2129, 0x2129).	% Math So       TURNED GREEK SMALL LETTER IOTA
unicode_math(0x212C, 0x212D).	% Math L&   [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
unicode_math(0x212F, 0x2131).	% Math L&   [3] SCRIPT SMALL E..SCRIPT CAPITAL F
unicode_math(0x2133, 0x2134).	% Math L&   [2] SCRIPT CAPITAL M..SCRIPT SMALL O
unicode_math(0x2135, 0x2138).	% Math Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_math(0x213C, 0x213F).	% Math L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_math(0x2140, 0x2144).	% Math Sm   [5] DOUBLE-STRUCK N-ARY SUMMATION..TURNED SANS-SERIF CAPITAL Y
unicode_math(0x2145, 0x2149).	% Math L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_math(0x214B, 0x214B).	% Math Sm       TURNED AMPERSAND
unicode_math(0x2190, 0x2194).	% Math Sm   [5] LEFTWARDS ARROW..LEFT RIGHT ARROW
unicode_math(0x2195, 0x2199).	% Math So   [5] UP DOWN ARROW..SOUTH WEST ARROW
unicode_math(0x219A, 0x219B).	% Math Sm   [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
unicode_math(0x219C, 0x219F).	% Math So   [4] LEFTWARDS WAVE ARROW..UPWARDS TWO HEADED ARROW
unicode_math(0x21A0, 0x21A0).	% Math Sm       RIGHTWARDS TWO HEADED ARROW
unicode_math(0x21A1, 0x21A2).	% Math So   [2] DOWNWARDS TWO HEADED ARROW..LEFTWARDS ARROW WITH TAIL
unicode_math(0x21A3, 0x21A3).	% Math Sm       RIGHTWARDS ARROW WITH TAIL
unicode_math(0x21A4, 0x21A5).	% Math So   [2] LEFTWARDS ARROW FROM BAR..UPWARDS ARROW FROM BAR
unicode_math(0x21A6, 0x21A6).	% Math Sm       RIGHTWARDS ARROW FROM BAR
unicode_math(0x21A7, 0x21A7).	% Math So       DOWNWARDS ARROW FROM BAR
unicode_math(0x21A9, 0x21AD).	% Math So   [5] LEFTWARDS ARROW WITH HOOK..LEFT RIGHT WAVE ARROW
unicode_math(0x21AE, 0x21AE).	% Math Sm       LEFT RIGHT ARROW WITH STROKE
unicode_math(0x21B0, 0x21B1).	% Math So   [2] UPWARDS ARROW WITH TIP LEFTWARDS..UPWARDS ARROW WITH TIP RIGHTWARDS
unicode_math(0x21B6, 0x21B7).	% Math So   [2] ANTICLOCKWISE TOP SEMICIRCLE ARROW..CLOCKWISE TOP SEMICIRCLE ARROW
unicode_math(0x21BC, 0x21CD).	% Math So  [18] LEFTWARDS HARPOON WITH BARB UPWARDS..LEFTWARDS DOUBLE ARROW WITH STROKE
unicode_math(0x21CE, 0x21CF).	% Math Sm   [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
unicode_math(0x21D0, 0x21D1).	% Math So   [2] LEFTWARDS DOUBLE ARROW..UPWARDS DOUBLE ARROW
unicode_math(0x21D2, 0x21D2).	% Math Sm       RIGHTWARDS DOUBLE ARROW
unicode_math(0x21D3, 0x21D3).	% Math So       DOWNWARDS DOUBLE ARROW
unicode_math(0x21D4, 0x21D4).	% Math Sm       LEFT RIGHT DOUBLE ARROW
unicode_math(0x21D5, 0x21DB).	% Math So   [7] UP DOWN DOUBLE ARROW..RIGHTWARDS TRIPLE ARROW
unicode_math(0x21DD, 0x21DD).	% Math So       RIGHTWARDS SQUIGGLE ARROW
unicode_math(0x21E4, 0x21E5).	% Math So   [2] LEFTWARDS ARROW TO BAR..RIGHTWARDS ARROW TO BAR
unicode_math(0x21F4, 0x22FF).	% Math Sm [268] RIGHT ARROW WITH SMALL CIRCLE..Z NOTATION BAG MEMBERSHIP
unicode_math(0x2308, 0x230B).	% Math Sm   [4] LEFT CEILING..RIGHT FLOOR
unicode_math(0x2320, 0x2321).	% Math Sm   [2] TOP HALF INTEGRAL..BOTTOM HALF INTEGRAL
unicode_math(0x237C, 0x237C).	% Math Sm       RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
unicode_math(0x239B, 0x23B3).	% Math Sm  [25] LEFT PARENTHESIS UPPER HOOK..SUMMATION BOTTOM
unicode_math(0x23B4, 0x23B5).	% Math So   [2] TOP SQUARE BRACKET..BOTTOM SQUARE BRACKET
unicode_math(0x23B7, 0x23B7).	% Math So       RADICAL SYMBOL BOTTOM
unicode_math(0x23D0, 0x23D0).	% Math So       VERTICAL LINE EXTENSION
unicode_math(0x23DC, 0x23E1).	% Math Sm   [6] TOP PARENTHESIS..BOTTOM TORTOISE SHELL BRACKET
unicode_math(0x23E2, 0x23E2).	% Math So       WHITE TRAPEZIUM
unicode_math(0x25A0, 0x25A1).	% Math So   [2] BLACK SQUARE..WHITE SQUARE
unicode_math(0x25AE, 0x25B6).	% Math So   [9] BLACK VERTICAL RECTANGLE..BLACK RIGHT-POINTING TRIANGLE
unicode_math(0x25B7, 0x25B7).	% Math Sm       WHITE RIGHT-POINTING TRIANGLE
unicode_math(0x25BC, 0x25C0).	% Math So   [5] BLACK DOWN-POINTING TRIANGLE..BLACK LEFT-POINTING TRIANGLE
unicode_math(0x25C1, 0x25C1).	% Math Sm       WHITE LEFT-POINTING TRIANGLE
unicode_math(0x25C6, 0x25C7).	% Math So   [2] BLACK DIAMOND..WHITE DIAMOND
unicode_math(0x25CA, 0x25CB).	% Math So   [2] LOZENGE..WHITE CIRCLE
unicode_math(0x25CF, 0x25D3).	% Math So   [5] BLACK CIRCLE..CIRCLE WITH UPPER HALF BLACK
unicode_math(0x25E2, 0x25E2).	% Math So       BLACK LOWER RIGHT TRIANGLE
unicode_math(0x25E4, 0x25E4).	% Math So       BLACK UPPER LEFT TRIANGLE
unicode_math(0x25E7, 0x25EC).	% Math So   [6] SQUARE WITH LEFT HALF BLACK..WHITE UP-POINTING TRIANGLE WITH DOT
unicode_math(0x25F8, 0x25FF).	% Math Sm   [8] UPPER LEFT TRIANGLE..LOWER RIGHT TRIANGLE
unicode_math(0x2605, 0x2606).	% Math So   [2] BLACK STAR..WHITE STAR
unicode_math(0x2640, 0x2640).	% Math So       FEMALE SIGN
unicode_math(0x2642, 0x2642).	% Math So       MALE SIGN
unicode_math(0x2660, 0x2663).	% Math So   [4] BLACK SPADE SUIT..BLACK CLUB SUIT
unicode_math(0x266D, 0x266E).	% Math So   [2] MUSIC FLAT SIGN..MUSIC NATURAL SIGN
unicode_math(0x266F, 0x266F).	% Math Sm       MUSIC SHARP SIGN
unicode_math(0x27C0, 0x27C4).	% Math Sm   [5] THREE DIMENSIONAL ANGLE..OPEN SUPERSET
unicode_math(0x27C5, 0x27C5).	% Math Ps       LEFT S-SHAPED BAG DELIMITER
unicode_math(0x27C6, 0x27C6).	% Math Pe       RIGHT S-SHAPED BAG DELIMITER
unicode_math(0x27C7, 0x27E5).	% Math Sm  [31] OR WITH DOT INSIDE..WHITE SQUARE WITH RIGHTWARDS TICK
unicode_math(0x27E6, 0x27E6).	% Math Ps       MATHEMATICAL LEFT WHITE SQUARE BRACKET
unicode_math(0x27E7, 0x27E7).	% Math Pe       MATHEMATICAL RIGHT WHITE SQUARE BRACKET
unicode_math(0x27E8, 0x27E8).	% Math Ps       MATHEMATICAL LEFT ANGLE BRACKET
unicode_math(0x27E9, 0x27E9).	% Math Pe       MATHEMATICAL RIGHT ANGLE BRACKET
unicode_math(0x27EA, 0x27EA).	% Math Ps       MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
unicode_math(0x27EB, 0x27EB).	% Math Pe       MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
unicode_math(0x27EC, 0x27EC).	% Math Ps       MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
unicode_math(0x27ED, 0x27ED).	% Math Pe       MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
unicode_math(0x27EE, 0x27EE).	% Math Ps       MATHEMATICAL LEFT FLATTENED PARENTHESIS
unicode_math(0x27EF, 0x27EF).	% Math Pe       MATHEMATICAL RIGHT FLATTENED PARENTHESIS
unicode_math(0x27F0, 0x27FF).	% Math Sm  [16] UPWARDS QUADRUPLE ARROW..LONG RIGHTWARDS SQUIGGLE ARROW
unicode_math(0x2900, 0x2982).	% Math Sm [131] RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE..Z NOTATION TYPE COLON
unicode_math(0x2983, 0x2983).	% Math Ps       LEFT WHITE CURLY BRACKET
unicode_math(0x2984, 0x2984).	% Math Pe       RIGHT WHITE CURLY BRACKET
unicode_math(0x2985, 0x2985).	% Math Ps       LEFT WHITE PARENTHESIS
unicode_math(0x2986, 0x2986).	% Math Pe       RIGHT WHITE PARENTHESIS
unicode_math(0x2987, 0x2987).	% Math Ps       Z NOTATION LEFT IMAGE BRACKET
unicode_math(0x2988, 0x2988).	% Math Pe       Z NOTATION RIGHT IMAGE BRACKET
unicode_math(0x2989, 0x2989).	% Math Ps       Z NOTATION LEFT BINDING BRACKET
unicode_math(0x298A, 0x298A).	% Math Pe       Z NOTATION RIGHT BINDING BRACKET
unicode_math(0x298B, 0x298B).	% Math Ps       LEFT SQUARE BRACKET WITH UNDERBAR
unicode_math(0x298C, 0x298C).	% Math Pe       RIGHT SQUARE BRACKET WITH UNDERBAR
unicode_math(0x298D, 0x298D).	% Math Ps       LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
unicode_math(0x298E, 0x298E).	% Math Pe       RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
unicode_math(0x298F, 0x298F).	% Math Ps       LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
unicode_math(0x2990, 0x2990).	% Math Pe       RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
unicode_math(0x2991, 0x2991).	% Math Ps       LEFT ANGLE BRACKET WITH DOT
unicode_math(0x2992, 0x2992).	% Math Pe       RIGHT ANGLE BRACKET WITH DOT
unicode_math(0x2993, 0x2993).	% Math Ps       LEFT ARC LESS-THAN BRACKET
unicode_math(0x2994, 0x2994).	% Math Pe       RIGHT ARC GREATER-THAN BRACKET
unicode_math(0x2995, 0x2995).	% Math Ps       DOUBLE LEFT ARC GREATER-THAN BRACKET
unicode_math(0x2996, 0x2996).	% Math Pe       DOUBLE RIGHT ARC LESS-THAN BRACKET
unicode_math(0x2997, 0x2997).	% Math Ps       LEFT BLACK TORTOISE SHELL BRACKET
unicode_math(0x2998, 0x2998).	% Math Pe       RIGHT BLACK TORTOISE SHELL BRACKET
unicode_math(0x2999, 0x29D7).	% Math Sm  [63] DOTTED FENCE..BLACK HOURGLASS
unicode_math(0x29D8, 0x29D8).	% Math Ps       LEFT WIGGLY FENCE
unicode_math(0x29D9, 0x29D9).	% Math Pe       RIGHT WIGGLY FENCE
unicode_math(0x29DA, 0x29DA).	% Math Ps       LEFT DOUBLE WIGGLY FENCE
unicode_math(0x29DB, 0x29DB).	% Math Pe       RIGHT DOUBLE WIGGLY FENCE
unicode_math(0x29DC, 0x29FB).	% Math Sm  [32] INCOMPLETE INFINITY..TRIPLE PLUS
unicode_math(0x29FC, 0x29FC).	% Math Ps       LEFT-POINTING CURVED ANGLE BRACKET
unicode_math(0x29FD, 0x29FD).	% Math Pe       RIGHT-POINTING CURVED ANGLE BRACKET
unicode_math(0x29FE, 0x2AFF).	% Math Sm [258] TINY..N-ARY WHITE VERTICAL BAR
unicode_math(0x2B30, 0x2B44).	% Math Sm  [21] LEFT ARROW WITH SMALL CIRCLE..RIGHTWARDS ARROW THROUGH SUPERSET
unicode_math(0x2B47, 0x2B4C).	% Math Sm   [6] REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW..RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
unicode_math(0xFB29, 0xFB29).	% Math Sm       HEBREW LETTER ALTERNATIVE PLUS SIGN
unicode_math(0xFE61, 0xFE61).	% Math Po       SMALL ASTERISK
unicode_math(0xFE62, 0xFE62).	% Math Sm       SMALL PLUS SIGN
unicode_math(0xFE63, 0xFE63).	% Math Pd       SMALL HYPHEN-MINUS
unicode_math(0xFE64, 0xFE66).	% Math Sm   [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
unicode_math(0xFE68, 0xFE68).	% Math Po       SMALL REVERSE SOLIDUS
unicode_math(0xFF0B, 0xFF0B).	% Math Sm       FULLWIDTH PLUS SIGN
unicode_math(0xFF1C, 0xFF1E).	% Math Sm   [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
unicode_math(0xFF3C, 0xFF3C).	% Math Po       FULLWIDTH REVERSE SOLIDUS
unicode_math(0xFF3E, 0xFF3E).	% Math Sk       FULLWIDTH CIRCUMFLEX ACCENT
unicode_math(0xFF5C, 0xFF5C).	% Math Sm       FULLWIDTH VERTICAL LINE
unicode_math(0xFF5E, 0xFF5E).	% Math Sm       FULLWIDTH TILDE
unicode_math(0xFFE2, 0xFFE2).	% Math Sm       FULLWIDTH NOT SIGN
unicode_math(0xFFE9, 0xFFEC).	% Math Sm   [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
unicode_math(0x1D400, 0x1D454).	% Math L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_math(0x1D456, 0x1D49C).	% Math L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_math(0x1D49E, 0x1D49F).	% Math L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_math(0x1D4A2, 0x1D4A2).	% Math L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_math(0x1D4A5, 0x1D4A6).	% Math L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_math(0x1D4A9, 0x1D4AC).	% Math L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_math(0x1D4AE, 0x1D4B9).	% Math L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_math(0x1D4BB, 0x1D4BB).	% Math L&       MATHEMATICAL SCRIPT SMALL F
unicode_math(0x1D4BD, 0x1D4C3).	% Math L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_math(0x1D4C5, 0x1D505).	% Math L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_math(0x1D507, 0x1D50A).	% Math L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_math(0x1D50D, 0x1D514).	% Math L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_math(0x1D516, 0x1D51C).	% Math L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_math(0x1D51E, 0x1D539).	% Math L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_math(0x1D53B, 0x1D53E).	% Math L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_math(0x1D540, 0x1D544).	% Math L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_math(0x1D546, 0x1D546).	% Math L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_math(0x1D54A, 0x1D550).	% Math L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_math(0x1D552, 0x1D6A5).	% Math L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_math(0x1D6A8, 0x1D6C0).	% Math L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_math(0x1D6C1, 0x1D6C1).	% Math Sm       MATHEMATICAL BOLD NABLA
unicode_math(0x1D6C2, 0x1D6DA).	% Math L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_math(0x1D6DB, 0x1D6DB).	% Math Sm       MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
unicode_math(0x1D6DC, 0x1D6FA).	% Math L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_math(0x1D6FB, 0x1D6FB).	% Math Sm       MATHEMATICAL ITALIC NABLA
unicode_math(0x1D6FC, 0x1D714).	% Math L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_math(0x1D715, 0x1D715).	% Math Sm       MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
unicode_math(0x1D716, 0x1D734).	% Math L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_math(0x1D735, 0x1D735).	% Math Sm       MATHEMATICAL BOLD ITALIC NABLA
unicode_math(0x1D736, 0x1D74E).	% Math L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_math(0x1D74F, 0x1D74F).	% Math Sm       MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_math(0x1D750, 0x1D76E).	% Math L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_math(0x1D76F, 0x1D76F).	% Math Sm       MATHEMATICAL SANS-SERIF BOLD NABLA
unicode_math(0x1D770, 0x1D788).	% Math L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_math(0x1D789, 0x1D789).	% Math Sm       MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
unicode_math(0x1D78A, 0x1D7A8).	% Math L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_math(0x1D7A9, 0x1D7A9).	% Math Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
unicode_math(0x1D7AA, 0x1D7C2).	% Math L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_math(0x1D7C3, 0x1D7C3).	% Math Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_math(0x1D7C4, 0x1D7CB).	% Math L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_math(0x1D7CE, 0x1D7FF).	% Math Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_math(0x1EE00, 0x1EE03).	% Math Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_math(0x1EE05, 0x1EE1F).	% Math Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_math(0x1EE21, 0x1EE22).	% Math Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_math(0x1EE24, 0x1EE24).	% Math Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_math(0x1EE27, 0x1EE27).	% Math Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_math(0x1EE29, 0x1EE32).	% Math Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_math(0x1EE34, 0x1EE37).	% Math Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_math(0x1EE39, 0x1EE39).	% Math Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_math(0x1EE3B, 0x1EE3B).	% Math Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_math(0x1EE42, 0x1EE42).	% Math Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_math(0x1EE47, 0x1EE47).	% Math Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_math(0x1EE49, 0x1EE49).	% Math Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_math(0x1EE4B, 0x1EE4B).	% Math Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_math(0x1EE4D, 0x1EE4F).	% Math Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_math(0x1EE51, 0x1EE52).	% Math Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_math(0x1EE54, 0x1EE54).	% Math Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_math(0x1EE57, 0x1EE57).	% Math Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_math(0x1EE59, 0x1EE59).	% Math Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_math(0x1EE5B, 0x1EE5B).	% Math Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_math(0x1EE5D, 0x1EE5D).	% Math Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_math(0x1EE5F, 0x1EE5F).	% Math Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_math(0x1EE61, 0x1EE62).	% Math Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_math(0x1EE64, 0x1EE64).	% Math Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_math(0x1EE67, 0x1EE6A).	% Math Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_math(0x1EE6C, 0x1EE72).	% Math Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_math(0x1EE74, 0x1EE77).	% Math Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_math(0x1EE79, 0x1EE7C).	% Math Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_math(0x1EE7E, 0x1EE7E).	% Math Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_math(0x1EE80, 0x1EE89).	% Math Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_math(0x1EE8B, 0x1EE9B).	% Math Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_math(0x1EEA1, 0x1EEA3).	% Math Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_math(0x1EEA5, 0x1EEA9).	% Math Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_math(0x1EEAB, 0x1EEBB).	% Math Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_math(0x1EEF0, 0x1EEF1).	% Math Sm   [2] ARABIC MATHEMATICAL OPERATOR MEEM WITH HAH WITH TATWEEL..ARABIC MATHEMATICAL OPERATOR HAH WITH DAL

% Total code points: 2310
