
import { viteSingleFile } from 'vite-plugin-singlefile';
import path from 'path';
import fs from 'fs';

const GUIDE_FOR_FRONTEND = `
<!--
  This is a single file build of the frontend.
  It is automatically generated by the build process.
  Do not edit this file directly.
  To make changes, refer to the "Web UI" section in the README.
-->
`.trim();

export default {
  plugins: [
    viteSingleFile(),
    (function llamaCppPlugin() {
      let config;
      return {
        name: 'llamacpp:build',
        apply: 'build',
        async configResolved(_config) {
          config = _config;
        },
        writeBundle() {
          const outputIndexHtml = path.join(config.build.outDir, 'index.html');
          const content = fs.readFileSync(outputIndexHtml, 'utf-8');

          const targetOutputFile = path.join(config.build.outDir, '../../public/index.html');
          fs.writeFileSync(targetOutputFile, GUIDE_FOR_FRONTEND + '\n' + content);
        }
      }
    })(),
  ],
};
