
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include <sys/types.h>
#include <sys/param.h>

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <signal.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <assert.h>
#include <netdb.h>
#include <pthread.h>
#include <err.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <openssl/ssl.h>

#include <pdel/structs/structs.h>
#include <pdel/structs/structs.h>
#include <pdel/structs/type/array.h>
#include <pdel/structs/type/int.h>
#include <pdel/structs/type/string.h>
#include <pdel/structs/type/struct.h>
#include <pdel/structs/type/union.h>
#include <pdel/structs/xmlrpc.h>

#include <pdel/tmpl/tmpl.h>
#include <pdel/sys/alog.h>
#include <pdel/util/typed_mem.h>
#include <pdel/util/pevent.h>

#include <pdel/http/http_defs.h>
#include <pdel/http/http_server.h>
#include <pdel/http/http_servlet.h>
#include <pdel/http/servlet/xmlrpc.h>

#include <pdel/version.h>

#define MEM_TYPE		"xmlrpc_test"

struct three_stooges {
	int32_t		moe;
	int32_t		larry;
	int32_t		curly;
};

extern const struct structs_type three_stooges_type;

extern int	debug_level;

extern const	char host_os[];
extern const	char host_arch[];

extern const	struct http_servlet_xmlrpc_method arrayOfStructsTest_method;
extern const	struct http_servlet_xmlrpc_method countTheEntities_method;
extern const	struct http_servlet_xmlrpc_method easyStructTest_method;
extern const	struct http_servlet_xmlrpc_method echoStructTest_method;
extern const	struct http_servlet_xmlrpc_method manyTypesTest_method;
extern const	struct http_servlet_xmlrpc_method moderateSizeArrayCheck_method;
extern const	struct http_servlet_xmlrpc_method nestedStructTest_method;
extern const	struct http_servlet_xmlrpc_method simpleStructReturnTest_method;

