
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "xmlrpc_test.h"

static http_servlet_xmlrpc_handler_t	nestedStructTest_handler;

const struct	http_servlet_xmlrpc_method nestedStructTest_method = {
	"validator1.nestedStructTest",
	nestedStructTest_handler,
	NULL,			/* this handler wants "exploded" parameters */
	1, 1
};

static void *
nestedStructTest_handler(void *arg, const char *method,
	struct http_request *req, u_int nparams, const void **params,
	const char *mtype, const struct structs_type **rtypep, int *faulted)
{
	const char *struct_names[] = { "2000", "04", "01", NULL };
	const struct xmlrpc_value_union *v;
	const struct xmlrpc_struct *s;
	int32_t *result;
	int32_t sum;
	int i;
	int j;

	alog(LOG_INFO, "method \"%s\" invoked", method);

	/* Find the nested structure */
	for (i = 0, v = params[0]; struct_names[i] != NULL; i++) {
		for (j = 0; ; j++) {
			const struct xmlrpc_member *member;
			const void *data = v;
			char name[32];

			snprintf(name, sizeof(name), "struct.%d", j);
			if (structs_find(&structs_type_xmlrpc_value,
			    name, (void **)&data, 0) == NULL)
				return (NULL);
			member = data;
			if (strcmp(member->name, struct_names[i]) == 0) {
				v = &member->value;		/* found it */
				break;
			}
		}
	}

	/* Make sure we're now looking at a structure */
	if (strcmp(v->field_name, "struct") != 0) {
		errno = EINVAL;
		return (NULL);
	}
	s = &v->un->struct_;

	/* Add together the three_stooges fields */
	for (sum = i = 0; i < s->length; i++) {
		if (strcmp(s->elems[i].name, "moe") != 0
		    && strcmp(s->elems[i].name, "larry") != 0
		    && strcmp(s->elems[i].name, "curly") != 0)
			continue;
		if (strcmp(s->elems[i].value.field_name, "i4") != 0) {
			errno = EINVAL;
			return (NULL);
		}
		sum += s->elems[i].value.un->i4;
	}

	/* Copy result into malloc'd buffer */
	if ((result = MALLOC(mtype, sizeof(*result))) == NULL)
		return (NULL);
	*result = sum;

	/* Return result */
	*rtypep = &structs_type_int;
	return (result);
}

