
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "xmlrpc_test.h"

static http_servlet_xmlrpc_handler_t	manyTypesTest_handler;

const struct	http_servlet_xmlrpc_method manyTypesTest_method = {
	"validator1.manyTypesTest",
	manyTypesTest_handler,
	NULL,			/* this handler wants "exploded" parameters */
	6, 6
};

static void *
manyTypesTest_handler(void *arg, const char *method, struct http_request *req,
	u_int nparams, const void **params, const char *mtype,
	const struct structs_type **rtypep, int *faulted)
{
	const struct structs_type *const vtype = &structs_type_xmlrpc_value;
	struct xmlrpc_value_union *v;
	int i;

	alog(LOG_INFO, "method \"%s\" invoked", method);

	/* Initialize "exploded" XML-RPC return value */
	if ((v = MALLOC(mtype, sizeof(*v))) == NULL)
		return (NULL);
	if (structs_init(vtype, NULL, v) == -1)
		goto fail1;

	/* Set returned value to be an array */
	if (structs_union_set(vtype, NULL, v, "array") == -1)
		goto fail2;

	/* Copy input parameters into the output array */
	for (i = 0; i < nparams; i++) {
		char name[32];

		if (structs_array_insert(vtype, "array.data", i, v) == -1)
			goto fail2;
		snprintf(name, sizeof(name), "array.data.%d", i);
		if (structs_set(vtype, params[i], name, v) == -1)
			goto fail2;
	}

	/* Return "raw" result */
	*rtypep = NULL;
	return (v);

	/* Clean up after failure */
fail2:	structs_free(vtype, NULL, v);
fail1:	FREE(mtype, v);
	return (NULL);
}

