
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "xmlrpc_test.h"

struct entities {
	int32_t	ctLeftAngleBrackets;
	int32_t	ctRightAngleBrackets;
	int32_t	ctAmpersands;
	int32_t	ctApostrophes;
	int32_t	ctQuotes;
};

static const struct structs_field entities_fields[] = {
	STRUCTS_STRUCT_FIELD(entities, ctLeftAngleBrackets,
		&structs_type_int32),
	STRUCTS_STRUCT_FIELD(entities, ctRightAngleBrackets,
		&structs_type_int32),
	STRUCTS_STRUCT_FIELD(entities, ctAmpersands, &structs_type_int32),
	STRUCTS_STRUCT_FIELD(entities, ctApostrophes, &structs_type_int32),
	STRUCTS_STRUCT_FIELD(entities, ctQuotes, &structs_type_int32),
	STRUCTS_STRUCT_FIELD_END
};
static const struct structs_type entities_type
	= STRUCTS_STRUCT_TYPE(entities, entities_fields);

static const struct structs_type *countTheEntities_ptypes[] = {
	&structs_type_string
};

static http_servlet_xmlrpc_handler_t	countTheEntities_handler;

const struct	http_servlet_xmlrpc_method countTheEntities_method = {
	"validator1.countTheEntities",
	countTheEntities_handler,
	countTheEntities_ptypes,
	1, 1
};

static void *
countTheEntities_handler(void *arg, const char *method,
	struct http_request *req, u_int nparams, const void **params,
	const char *mtype, const struct structs_type **rtypep, int *faulted)
{
	const char *const string = *((char **)params[0]);
	struct entities *e;
	const char *s;

	alog(LOG_INFO, "method \"%s\" invoked", method);
	if ((e = MALLOC(mtype, sizeof(*e))) == NULL)
		return (NULL);
	memset(e, 0, sizeof(*e));
	for (s = string; *s != '\0'; s++) {
		switch (*s) {
		case '<':
			e->ctLeftAngleBrackets++;
			break;
		case '>':
			e->ctRightAngleBrackets++;
			break;
		case '&':
			e->ctAmpersands++;
			break;
		case '\'':
			e->ctApostrophes++;
			break;
		case '"':
			e->ctQuotes++;
			break;
		default:
			break;
		}
	}
	*rtypep = &entities_type;
	return (e);
}


