
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_STRUCTS_TYPE_ID_H_
#define _PDEL_STRUCTS_TYPE_ID_H_

/*********************************************************************
			IDENTIFIER TYPES
*********************************************************************/

/*
 * Types where the range of possible values is a list of unique string
 * identifiers which have corresponding unique integral values.
 * The integral value is stored in memory as a 1, 2, or 4 byte value.
 *
 * The default value for an instance is first identifier in the list.
 *
 * For example, "red", "green", or "blue".
 *
 * Arguments to STRUCTS_ID_TYPE() macro:
 *	[struct structs_id *]	List of identifiers, terminated by NULL "id"
 *	[int]			Size of identifier word in bytes (1, 2, or 4)
 */

struct structs_id {
	const char	*id;		/* string representation */
	u_int32_t	value;		/* integer representation */
	u_int		imatch;		/* case-insensitive matching allowed */
};

__BEGIN_DECLS

extern structs_init_t		structs_id_init;
extern structs_ascify_t		structs_id_ascify;
extern structs_binify_t		structs_id_binify;

__END_DECLS

#define STRUCTS_ID_TYPE(idlist, vsize) {				\
	(vsize),							\
	"id",								\
	STRUCTS_TYPE_PRIMITIVE,						\
	structs_id_init,						\
	structs_region_copy,						\
	structs_region_equal,						\
	structs_id_ascify,						\
	structs_id_binify,						\
	structs_region_encode_netorder,					\
	structs_region_decode_netorder,					\
	structs_nothing_free,						\
	{ { (idlist) }, { NULL }, { NULL } }				\
}

#endif	/* _PDEL_STRUCTS_TYPE_ID_H_ */

