
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_PPP_PPP_NODE_H_
#define _PDEL_PPP_PPP_NODE_H_

struct ppp_node;
struct ppp_log;

typedef void	ppp_node_recv_t(void *arg, u_int link_num, u_int16_t proto,
			u_char *data, size_t len);

typedef void	ppp_node_recvmsg_t(void *arg, struct ng_mesg *msg);

__BEGIN_DECLS

/* Functions */
extern struct	ppp_node *ppp_node_create(struct pevent_ctx *ev_ctx,
			pthread_mutex_t *mutex, struct ppp_log *log);
extern void	ppp_node_destroy(struct ppp_node **nodep);
extern int	ppp_node_write(struct ppp_node *node, u_int link_num,
			u_int16_t proto, const void *data, size_t len);
extern int	ppp_node_connect(struct ppp_node *node, u_int link_num,
			const char *path, const char *hook);
extern int	ppp_node_disconnect(struct ppp_node *node, u_int link_num);

extern const	char *ppp_node_get_path(struct ppp_node *node);
extern int	ppp_node_get_config(struct ppp_node *node,
			struct ng_ppp_node_conf *conf);
extern int	ppp_node_set_config(struct ppp_node *node,
			const struct ng_ppp_node_conf *conf);
extern int	ppp_node_send_msg(struct ppp_node *node,
			const char *relpath, u_int32_t cookie, u_int32_t cmd,
			const void *payload, size_t plen);
extern int	ppp_node_recv_msg(struct ppp_node *node,
			struct ng_mesg *msg, size_t mlen, char *raddr);
extern void	ppp_node_set_recv(struct ppp_node *node,
			ppp_node_recv_t *recv, void *arg);
extern int	ppp_node_set_recvmsg(struct ppp_node *node,
			u_int32_t cookie, u_int32_t cmd,
			ppp_node_recvmsg_t *recvmsg, void *arg);

__END_DECLS

#endif	/* _PDEL_PPP_PPP_NODE_H_ */
