
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_PPP_PPP_MSOFT_H_
#define _PDEL_PPP_PPP_MSOFT_H_

__BEGIN_DECLS

extern void	ppp_msoft_nt_challenge_response(const u_char *chal,
			const char *password, u_char *hash);

extern void	ppp_msoft_nt_password_hash(const char *password, u_char *hash);
extern void	ppp_msoft_lm_password_hash(const char *password, u_char *hash);

extern void	ppp_msoft_generate_nt_response(const u_char *authchal,
			const u_char *peerchal, const char *username,
			const char *password, u_char *hash);
extern void	ppp_msoft_generate_authenticator_response(const char *password,
			const u_char *ntresp, const u_char *peerchal,
			const u_char *authchal, const char *username,
			u_char *authresp);
extern int	ppp_msoft_check_authenticator_response(const char *password,
			const u_char *ntresp, const u_char *peerchal,
			const u_char *authchal, const char *username,
			const char *rechash);

extern void	ppp_msoft_get_key(const u_char *h, u_char *h2, int len);
extern void	ppp_msoft_get_start_key(const u_char *chal, u_char *h);

extern void	ppp_msoft_get_master_key(const u_char *resp, u_char *h);
extern void	ppp_msoft_get_asymetric_start_key(int which,
			const u_char *master, u_char *key);

extern void	ppp_msoft_init_key_v1(int e128, const char *pass,
			const u_char *chal, u_char *key);
extern void	ppp_msoft_init_key_v2(int which, const char *pass,
			const u_char *resp, u_char *key);

__END_DECLS

#endif	/* _PDEL_PPP_PPP_MSOFT_H_ */
