
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_PPP_PPP_IPCP_H_
#define _PDEL_PPP_PPP_IPCP_H_

struct ppp_fsm;
struct ppp_node;

/*
 * Configuration for an IPCP FSM
 */
struct ppp_ipcp_config {
	struct in_addr	ip[2];
	struct in_addr	mask[2];
	u_char		do_dns[2];
	struct in_addr	dns[2];
	u_char		do_nbns[2];
	struct in_addr	nbns[2];
};

/*
 * IPCP request state
 */
struct ppp_ipcp_vjc {
	u_char		enabled;
	u_char		maxchan;
	u_char		compcid;
};

struct ppp_ipcp_req {
	struct in_addr		ip[2];
	struct ppp_ipcp_vjc	vjc[2];
	u_char			ask_dns;
	u_char			ask_nbns;
	struct in_addr		dns[2];
	struct in_addr		nbns[2];
};

__BEGIN_DECLS

/* FSM type for IPCP */
extern const	struct ppp_fsm_type ppp_fsm_ipcp;

/* Functions */
extern struct	ppp_fsm_instance *ppp_ipcp_create(struct ppp_ipcp_config *conf,
			struct ppp_node *node);
extern void	ppp_ipcp_get_req(struct ppp_fsm *ipcp,
			struct ppp_ipcp_req *req);

__END_DECLS

#endif	/* _PDEL_PPP_PPP_IPCP_H_ */
