
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_PPP_PPP_ENGINE_H_
#define _PDEL_PPP_PPP_ENGINE_H_

struct ppp_engine;
struct ppp_manager;
struct ppp_bundle;
struct ppp_link;
struct ppp_node;
struct ppp_link_config;
struct ppp_bundle_config;
struct ppp_log;

__BEGIN_DECLS

/********************************************************************
			PUBLIC FUNCTIONS
********************************************************************/

extern struct	ppp_engine *ppp_engine_create(struct ppp_manager *manager,
			const pthread_attr_t *attr, struct ppp_log *log);
extern void	ppp_engine_destroy(struct ppp_engine **enginep, int wait);

extern int	ppp_engine_get_bundles(struct ppp_engine *engine,
			struct ppp_bundle ***listp, const char *mtype);

/********************************************************************
			PRIVATE FUNCTIONS
********************************************************************/

#ifdef _PDEL_PPP_PRIVATE_H_

extern int	ppp_engine_add_link(struct ppp_engine *engine,
			struct ppp_link *link);
extern void	ppp_engine_del_link(struct ppp_engine *engine,
			struct ppp_link *link);
extern struct	ppp_bundle *ppp_engine_join(struct ppp_engine *engine,
			struct ppp_link *link, struct ppp_node **nodep,
			u_int16_t *link_num);
extern int	ppp_engine_add_bundle(struct ppp_engine *engine,
			struct ppp_bundle *bundle);
extern void	ppp_engine_del_bundle(struct ppp_engine *engine,
                        struct ppp_bundle *bundle);
extern void	ppp_engine_set_pptp_server(struct ppp_engine *engine, void *s);
extern void	*ppp_engine_get_pptp_server(struct ppp_engine *engine);
extern void	ppp_engine_set_l2tp_server(struct ppp_engine *engine, void *s);
extern void	*ppp_engine_get_l2tp_server(struct ppp_engine *engine);
struct ppp_log	*ppp_engine_get_log(struct ppp_engine *engine);
extern struct	pevent_ctx *ppp_engine_get_ev_ctx(struct ppp_engine *engine);
extern pthread_mutex_t	*ppp_engine_get_mutex(struct ppp_engine *engine);

/* Functions that call through to the manager */
extern void	*ppp_engine_bundle_config(struct ppp_engine *engine,
			struct ppp_link *link, struct ppp_bundle_config *conf);
extern void	*ppp_engine_bundle_plumb(struct ppp_engine *engine,
			struct ppp_bundle *bundle,
			const char *path, const char *hook,
			struct in_addr *ips, struct in_addr *dns,
			struct in_addr *nbns, u_int mtu);
extern void	ppp_engine_bundle_unplumb(struct ppp_engine *engine,
			void *arg, struct ppp_bundle *bundle);
extern void	ppp_engine_release_ip(struct ppp_engine *engine,
			struct ppp_bundle *bundle, struct in_addr ip);

__END_DECLS

#endif	/* _PDEL_PPP_PRIVATE_H_ */

#endif	/* _PDEL_PPP_PPP_ENGINE_H_ */
