
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_PPP_AUTH_RADIUS_H_
#define _PDEL_PPP_AUTH_RADIUS_H_

/*
 * Support for PPP authentication via RADIUS.
 */

/************************************************************************
			PUBLIC DECLARATIONS
************************************************************************/

struct ppp_auth_cred;
struct ppp_auth_resp;

/* Attributes returned by server (or NULL if not present in server reply) */
struct ppp_auth_radius_info {
	struct in_addr	*ip;
	struct in_addr	*netmask;
	char		*filter_id;
	u_int32_t	*session_timeout;
	u_int32_t	*mtu;
	u_int32_t	*routing;
	u_int32_t	*vjc;
	char		**routes;		/* NULL terminated list */
	char		*reply_message;
	char		*mschap_error;
	char		*mschap2_success;
	u_int32_t	*mppe_policy;
	u_int32_t	*mppe_types;
};

__BEGIN_DECLS

/*
 * Perform RADIUS authentication using the supplied 'struct rad_handle',
 * which must already be configured (see libradius(3)).
 *
 * 'log' may be NULL, otherwise it's used for logging.
 *
 * If 'rip' is non-NULL, then all fields in *rip will be initialized to NULL
 * and then filled in with whichever attributes are returned by the RADIUS
 * server. The fields in 'rip' should eventually be free'd by calling the
 * ppp_auth_radius_info_reset() function. Note: 'rip' fields are filled in
 * even if the server rejects authentication.
 *
 * This function is async cancel-safe.
 *
 * Returns:
 *	 0	Credentials are valid
 *	-1	Credentials can't be validated; resp->errmsg contains message
 *		and 'rip' has not been modified.
 */
extern int	ppp_auth_radius_check(struct rad_handle *rad,
			struct ppp_log *log, const struct ppp_auth_cred *creds,
			struct ppp_auth_resp *resp,
			struct ppp_auth_radius_info *rip);

/*
 * Free memory allocated for fields in a 'struct ppp_auth_radius_info'
 * and set them all to NULL.
 */
extern void	ppp_auth_radius_info_reset(struct ppp_auth_radius_info *rip);

__END_DECLS

#endif	/* _PDEL_PPP_AUTH_RADIUS_H_ */
