
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_IO_TCP_SERVER_H_
#define _PDEL_IO_TCP_SERVER_H_

struct tcp_server;
struct tcp_connection;
struct pevent_ctx;

/*
 * Application handlers for a single connection. The setup method
 * should return a non-NULL cookie if successful, which will be
 * available from tcp_server_get_conn_cookie().
 */
typedef void	*tcp_setup_t(struct tcp_connection *conn);
typedef void	tcp_handler_t(struct tcp_connection *conn);
typedef void	tcp_teardown_t(struct tcp_connection *conn);

__BEGIN_DECLS

/* Functions */
extern struct	tcp_server *tcp_server_start(struct pevent_ctx *ctx,
			void *cookie, const char *mtype, struct in_addr ip,
			u_int16_t port, u_int max_conn, u_int conn_timeout,
			tcp_setup_t *setup, tcp_handler_t *handler,
			tcp_teardown_t *teardown);
extern void	tcp_server_stop(struct tcp_server **servp);
extern void	*tcp_server_get_cookie(struct tcp_server *serv);

extern struct	tcp_server *tcp_connection_get_server(
			struct tcp_connection *conn);
extern void	*tcp_connection_get_cookie(struct tcp_connection *conn);
extern int	tcp_connection_get_fd(struct tcp_connection *conn);
extern FILE	*tcp_connection_get_fp(struct tcp_connection *conn);
extern struct	tcp_connection *tcp_connection_first(struct tcp_server *serv);
extern struct	tcp_connection *tcp_connection_next(
			struct tcp_connection *conn);
extern void	tcp_connection_get_peer(struct tcp_connection *conn,
			struct sockaddr_in *sin);

__END_DECLS

#endif	/* _PDEL_IO_TCP_SERVER_H_ */

