
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_NET_ROUTE_MSG_H_
#define _PDEL_NET_ROUTE_MSG_H_

struct route_msg;

__BEGIN_DECLS

extern struct	route_msg *route_msg_create(void);
extern void	route_msg_destroy(struct route_msg **msgp);
extern int	route_msg_get_type(struct route_msg *msg);
extern void	route_msg_set_type(struct route_msg *msg, int type);
extern int	route_msg_get_index(struct route_msg *msg);
extern void	route_msg_set_index(struct route_msg *msg, int index);
extern int	route_msg_get_flags(struct route_msg *msg);
extern void	route_msg_set_flags(struct route_msg *msg, int flags);
extern int	route_msg_get_error(struct route_msg *msg);
extern pid_t	route_msg_get_pid(struct route_msg *msg);
extern int	route_msg_get_seq(struct route_msg *msg);
extern const	struct sockaddr *route_msg_get_dest(struct route_msg *msg);
extern int	route_msg_set_dest(struct route_msg *msg,
			const struct sockaddr *dest);
extern const	struct sockaddr *route_msg_get_gateway(struct route_msg *msg);
extern int	route_msg_set_gateway(struct route_msg *msg,
			const struct sockaddr *gateway);
extern const	struct sockaddr *route_msg_get_netmask(struct route_msg *msg);
extern int	route_msg_set_netmask(struct route_msg *msg,
			const struct sockaddr *netmask);
extern const	struct sockaddr *route_msg_get_genmask(struct route_msg *msg);
extern int	route_msg_set_genmask(struct route_msg *msg,
			const struct sockaddr *genmask);
extern const	struct sockaddr *route_msg_get_ifp(struct route_msg *msg);
extern int	route_msg_set_ifp(struct route_msg *msg,
			const struct sockaddr *ifp);
extern const	struct sockaddr *route_msg_get_ifa(struct route_msg *msg);
extern int	route_msg_set_ifa(struct route_msg *msg,
			const struct sockaddr *ifa);
extern const	struct sockaddr *route_msg_get_author(struct route_msg *msg);
extern int	route_msg_set_author(struct route_msg *msg,
			const struct sockaddr *author);
extern const	struct sockaddr *route_msg_get_brd(struct route_msg *msg);
extern int	route_msg_set_brd(struct route_msg *msg,
			const struct sockaddr *brd);
extern int	route_msg_decode(const u_char *data, size_t dlen,
			struct route_msg ***listp, const char *mtype);
extern int	route_msg_encode(const struct route_msg *msg,
			u_char *data, size_t dlen);
extern void	route_msg_print(struct route_msg *msg, FILE *fp);
extern int	route_msg_send(struct route_msg *msg, int sock);
extern int	route_msg_recv(struct route_msg ***listp,
			int sock, const char *mtype);

__END_DECLS

#endif	/* _PDEL_NET_ROUTE_MSG_H_ */

